/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.file.openquery;

import com.spss.java_client.core.documents.syntax.SyntaxMgr;
import com.spss.java_client.core.error_handler.ErrorDispatcher;
import com.spss.java_client.core.error_handler.ErrorEventMsg;
import com.spss.java_client.core.error_handler.ICoreErrorHandler;
import com.spss.java_client.core.error_handler.IErrorHandler;
import com.spss.java_client.core.server.DataServerProxy;
import com.spss.java_client.ui.SpssMgr;
import com.spss.java_client.ui.dialogs.base.file.openquery.DBData;
import com.spss.java_client.ui.dialogs.base.file.openquery.DBWizardDataReader;
import com.spss.java_client.ui.dialogs.base.file.openquery.DBWizardDlgType;
import com.spss.java_client.ui.dialogs.base.file.openquery.DBWizardExportOldGeneration;
import com.spss.java_client.ui.dialogs.base.file.openquery.DBWizardSerializedData;
import com.spss.java_client.ui.dialogs.base.file.openquery.KeyAlreadyExistsException;
import com.spss.java_client.ui.dialogs.base.file.openquery.KeyDoesNotExistsException;
import com.spss.java_client.ui.dialogs.base.file.openquery.UIData;
import com.spss.java_client.ui.dialogs.base.file.openquery.aggregate_data.AggregateDataPage;
import com.spss.java_client.ui.dialogs.base.file.openquery.compute_new_fields.ComputeNewFieldsPage;
import com.spss.java_client.ui.dialogs.base.file.openquery.define_variables.DefineVariablesPage;
import com.spss.java_client.ui.dialogs.base.file.openquery.limit_retrieved_cases.LimitRetrievedCasesPage;
import com.spss.java_client.ui.dialogs.base.file.openquery.results.ResultsPage;
import com.spss.java_client.ui.dialogs.base.file.openquery.select_data.SelectDataPage;
import com.spss.java_client.ui.dialogs.base.file.openquery.sort_cases.SortCasesPage;
import com.spss.java_client.ui.dialogs.base.file.openquery.specify_relationships.SpecifyRelationshipsPage;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.DBWizardSyntaxUtil;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.DBWizardUtil;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.odbc.ODBC;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.spss.GenerateSyntax;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.spss.ResultsPageInfo;
import com.spss.java_client.ui.dialogs.base.file.openquery.welcome.WelcomePage;
import com.spss.java_client.ui.dialogs.base.file.res.FileResBundle;
import com.spss.java_client.ui.dialogs.common.AbstractWizardPage;
import com.spss.java_client.ui.dialogs.common.BaseWizardDialog;
import com.spss.java_client.ui.dialogs.common.IPlainListVarMoveHandler;
import com.spss.java_client.ui.dialogs.common.WizardModel;
import java.util.HashMap;
import java.util.Stack;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class NewQueryDlg
extends BaseWizardDialog
implements ICoreErrorHandler {
    private AbstractWizardPage mOpenDataSourcePage;
    private AbstractWizardPage mSelectDataPage;
    private AbstractWizardPage mSpecifyRelationPage;
    private AbstractWizardPage mComputeNewFieldsPage;
    private AbstractWizardPage mLimitRetrievedCasesPage;
    private AbstractWizardPage mAggregateDataPage;
    private AbstractWizardPage mSortCasesPage;
    private AbstractWizardPage mDefineVariablesPage;
    private AbstractWizardPage mResultsPage;

    public NewQueryDlg(JFrame jFrame) {
        super(jFrame, true, FileResBundle.getDefaultResourceBundleName(), FileResBundle.getImageFolder());
        ErrorDispatcher.getErrorDispatcher().addListener((IErrorHandler)this);
        if (DBWizardDlgType.getDBWizardDlgTypeInstance() == DBWizardDlgType.DBWizardDialogTypeEnum.eEditQueryDlg || DBWizardDlgType.getDBWizardDlgTypeInstance() == DBWizardDlgType.DBWizardDialogTypeEnum.eEditQueryFromMFCDlg) {
            Boolean bl;
            boolean bl2;
            WizardModel wizardModel = this.getWizardModel();
            Stack<AbstractWizardPage> stack = new Stack<AbstractWizardPage>();
            stack.add(this.mOpenDataSourcePage);
            stack.add(this.mSelectDataPage);
            if (DBData.getDBData().getFilteredColumnsInfo().keySet().size() > 1) {
                stack.add(this.mSpecifyRelationPage);
            }
            if (bl2 = DataServerProxy.getDataProxy().isRemoteConnection()) {
                stack.add(this.mComputeNewFieldsPage);
            }
            stack.add(this.mLimitRetrievedCasesPage);
            if (bl2 && (bl = (Boolean)UIData.getUIData().getObject("LRCP_USE_RANDOM_SAMPLING_CHECK")) != null && !bl.booleanValue()) {
                stack.add(this.mAggregateDataPage);
            }
            stack.add(this.mDefineVariablesPage);
            if (bl2) {
                stack.add(this.mSortCasesPage);
            }
            stack.add(this.mResultsPage);
            wizardModel.resetStackForTreeTraversal(stack);
            this.showWizardPage(null, this.mResultsPage);
            try {
                DBWizardSyntaxUtil.setTempTableNameMap((HashMap)DBWizardSerializedData.getInstance().getObject("DBW_TEMP_TABLE_MAP"));
            }
            catch (KeyDoesNotExistsException keyDoesNotExistsException) {
                keyDoesNotExistsException.printStackTrace();
            }
            this.setLocationRelativeTo(jFrame);
            this.setVisible(true);
        }
        this.setLocationRelativeTo(jFrame);
    }

    public String getResBundleName() {
        return FileResBundle.getDefaultResourceBundleName();
    }

    public String getImageFolderName() {
        return FileResBundle.getImageFolder();
    }

    @Override
    public void init() {
        super.init();
        boolean bl = ODBC.getODBC().isRemoteConnection();
        DBWizardUtil.setPanel(this.mCmdButtonPanel);
        this.mOpenDataSourcePage = new WelcomePage(this);
        this.mSelectDataPage = new SelectDataPage(this);
        this.mSpecifyRelationPage = new SpecifyRelationshipsPage(this);
        if (bl) {
            this.mComputeNewFieldsPage = new ComputeNewFieldsPage(this);
        }
        this.mLimitRetrievedCasesPage = new LimitRetrievedCasesPage(this);
        if (bl) {
            this.mAggregateDataPage = new AggregateDataPage(this);
        }
        this.mDefineVariablesPage = new DefineVariablesPage(this);
        if (bl) {
            this.mSortCasesPage = new SortCasesPage(this);
        }
        this.mResultsPage = new ResultsPage(this);
        if (DBWizardDlgType.getDBWizardDlgTypeInstance() == DBWizardDlgType.DBWizardDialogTypeEnum.eNewQueryDlg) {
            DBWizardDataReader.readDefaultData();
        }
        this.registerPages(bl);
        this.mPlainListVarMoveHandler = (IPlainListVarMoveHandler)((Object)this.mAggregateDataPage);
        this.pack();
    }

    public AbstractWizardPage getWelcomePage() {
        return this.mOpenDataSourcePage;
    }

    public String getDialogHelpID() {
        return "idh_idd_tablewizard";
    }

    @Override
    protected boolean proceedWithNewDataset() {
        return SpssMgr.getSpssMgr().proceedWithNewDataset();
    }

    @Override
    protected boolean canBeRecalled() {
        return false;
    }

    @Override
    public String generateSyntax() {
        GenerateSyntax generateSyntax = GenerateSyntax.getGenerateSyntax();
        String string = generateSyntax.generateSPSSSyntax();
        string = generateSyntax.handlePrompts(string);
        string = SyntaxMgr.getSyntaxMgr().wrapSyntaxForPaste(string);
        return string;
    }

    public Vector<Object> getTabTraversal(Vector<Object> vector) {
        int n;
        Vector<Object> vector2 = new Vector<Object>();
        for (n = 0; n < vector.size(); ++n) {
            vector2.add(vector.elementAt(n));
        }
        for (n = 0; n < this.mCmdButtonPanel.getComponentCount(); ++n) {
            vector2.add(this.mCmdButtonPanel.getComponent(n));
        }
        return vector2;
    }

    @Override
    public String getIActionKey() {
        return "file_new_query";
    }

    public JPanel getCmdPanel() {
        return this.mCmdButtonPanel;
    }

    @Override
    public void showWizardPage(AbstractWizardPage abstractWizardPage, AbstractWizardPage abstractWizardPage2) {
        if (DBWizardDlgType.getDBWizardDlgTypeInstance() == DBWizardDlgType.DBWizardDialogTypeEnum.eEditQueryDlg || DBWizardDlgType.getDBWizardDlgTypeInstance() == DBWizardDlgType.DBWizardDialogTypeEnum.eEditQueryFromMFCDlg) {
            if (abstractWizardPage == null) {
                abstractWizardPage2 = this.mResultsPage;
            }
            this.enableFinish(true);
            this.enableBack(true);
            this.enableNext(false);
        }
        super.showWizardPage(abstractWizardPage, abstractWizardPage2);
    }

    public void handleError(ErrorEventMsg errorEventMsg) {
        if (errorEventMsg.getErrorCode() == -14 || errorEventMsg.getErrorCode() == -12) {
            errorEventMsg.setErrorHandled(true);
            errorEventMsg.setUserNotified(true);
        }
    }

    @Override
    protected BaseWizardDialog.DoFinishAction doFinish() {
        Object object;
        String string = ((ResultsPage)this.mResultsPage).getFileName();
        if (string != null && string.length() > 0) {
            object = DBWizardSerializedData.getInstance();
            ((DBWizardSerializedData)object).clearMap();
            try {
                DBWizardExportOldGeneration.fillDBData();
                DBWizardExportOldGeneration.fillUIData();
                ((DBWizardSerializedData)object).putObject("DBW_IS_REMOTE_CONNECTION", ODBC.getODBC().isRemoteConnection());
                ((DBWizardSerializedData)object).putObject("DBW_DBDATA", DBData.getDBData());
                ((DBWizardSerializedData)object).putObject("DBW_UIDATA", UIData.getUIData());
                String string2 = "";
                ResultsPageInfo resultsPageInfo = ResultsPageInfo.getResultsPageInfo();
                if (resultsPageInfo.isExisting()) {
                    string2 = resultsPageInfo.getSql();
                }
                ((DBWizardSerializedData)object).putObject("DBW_FINAL_SYNTAX", string2);
                ((DBWizardSerializedData)object).putObject("DBW_TEMP_TABLE_MAP", DBWizardExportOldGeneration.getEmptyTempTableNameMap());
            }
            catch (KeyAlreadyExistsException keyAlreadyExistsException) {
                keyAlreadyExistsException.printStackTrace();
            }
            int n = ((ResultsPage)this.mResultsPage).getFileOverrideOption();
            if (n == 1) {
                ((DBWizardSerializedData)object).writeObject(string);
            }
        }
        object = BaseWizardDialog.DoFinishAction.eOK;
        if (((ResultsPage)this.mResultsPage).isPasteRadioButtonSelected()) {
            object = BaseWizardDialog.DoFinishAction.ePaste;
        }
        this.disconnectDataSource();
        return object;
    }

    protected void disconnectDataSource() {
        ODBC.getODBC().disconnect();
    }

    @Override
    protected boolean doCancel() {
        this.disconnectDataSource();
        return true;
    }

    private void registerPages(boolean bl) {
        try {
            this.registerPage(this.mOpenDataSourcePage);
            this.registerPage(this.mSelectDataPage);
            this.registerPage(this.mSpecifyRelationPage);
            if (bl) {
                this.registerPage(this.mComputeNewFieldsPage);
            }
            this.registerPage(this.mLimitRetrievedCasesPage);
            if (bl) {
                this.registerPage(this.mAggregateDataPage);
            }
            this.registerPage(this.mDefineVariablesPage);
            if (bl) {
                this.registerPage(this.mSortCasesPage);
            }
            this.registerPage(this.mResultsPage);
        }
        catch (BaseWizardDialog.PageAlreadyRegistered pageAlreadyRegistered) {
            pageAlreadyRegistered.printStackTrace();
        }
    }
}

