/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.file.openquery;

import com.spss.java_client.ui.dialogs.base.file.openquery.DBData;
import com.spss.java_client.ui.dialogs.base.file.openquery.KeyAlreadyExistsException;
import com.spss.java_client.ui.dialogs.base.file.openquery.KeyDoesNotExistsException;
import com.spss.java_client.ui.dialogs.base.file.openquery.UIData;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StreamCorruptedException;
import java.util.HashMap;
import java.util.Map;

public class DBWizardSerializedData {
    private static DBWizardSerializedData mInstance;
    private static final int BASE_VERSION = 1;
    private static final int CURRENT_VERSION = 1;
    private HashMap<String, Object> mSerializeDataMap = new HashMap();

    private DBWizardSerializedData() {
    }

    public static DBWizardSerializedData getInstance() {
        if (mInstance == null) {
            mInstance = new DBWizardSerializedData();
        }
        return mInstance;
    }

    public void writeObject(String string) {
        try {
            DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream(string));
            dataOutputStream.writeInt(1);
            dataOutputStream.writeBoolean((Boolean)this.mSerializeDataMap.get("DBW_IS_REMOTE_CONNECTION"));
            dataOutputStream.writeUTF((String)this.mSerializeDataMap.get("DBW_FINAL_SYNTAX"));
            HashMap hashMap = (HashMap)this.mSerializeDataMap.get("DBW_TEMP_TABLE_MAP");
            dataOutputStream.writeInt(hashMap != null ? hashMap.size() : 0);
            if (hashMap != null) {
                for (Map.Entry entry : hashMap.entrySet()) {
                    dataOutputStream.writeUTF((String)entry.getKey());
                    dataOutputStream.writeUTF((String)entry.getValue());
                }
            }
            UIData.getUIData().writeData(dataOutputStream);
            DBData.getDBData().writeData(dataOutputStream);
            dataOutputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void readObject(String string) throws Exception {
        try {
            DataInputStream dataInputStream = new DataInputStream(new FileInputStream(string));
            this.mSerializeDataMap = new HashMap();
            int n = dataInputStream.readInt();
            if (n < 1 || n > 1) {
                dataInputStream.close();
                throw new StreamCorruptedException();
            }
            boolean bl = dataInputStream.readBoolean();
            String string2 = dataInputStream.readUTF();
            HashMap<String, String> hashMap = new HashMap<String, String>();
            int n2 = dataInputStream.readInt();
            for (int i = 0; i < n2; ++i) {
                hashMap.put(dataInputStream.readUTF(), dataInputStream.readUTF());
            }
            this.mSerializeDataMap.put("DBW_TEMP_TABLE_MAP", hashMap);
            UIData.getUIData().readData(dataInputStream, n);
            DBData.getDBData().clear();
            DBData.getDBData().readData(dataInputStream, n);
            this.mSerializeDataMap.put("DBW_IS_REMOTE_CONNECTION", bl);
            this.mSerializeDataMap.put("DBW_FINAL_SYNTAX", string2);
            this.mSerializeDataMap.put("DBW_UIDATA", UIData.getUIData());
            this.mSerializeDataMap.put("DBW_DBDATA", DBData.getDBData());
            dataInputStream.close();
        }
        catch (StreamCorruptedException streamCorruptedException) {
            throw streamCorruptedException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
    }

    public void putObject(String string, Object object) throws KeyAlreadyExistsException {
        if (this.mSerializeDataMap.containsKey(string)) {
            throw new KeyAlreadyExistsException();
        }
        this.mSerializeDataMap.put(string, object);
    }

    public Object getObject(String string) throws KeyDoesNotExistsException {
        Object object = this.mSerializeDataMap.get(string);
        if (object == null) {
            throw new KeyDoesNotExistsException();
        }
        return object;
    }

    public void clearMap() {
        this.mSerializeDataMap.clear();
    }
}

