/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.file.openquery;

import com.spss.java_client.core.server.messages.DataAccess.odbcmsg.ColumnsInfo;
import com.spss.java_client.core.server.messages.DataAccess.odbcmsg.TablesInfo;
import com.spss.java_client.ui.dialogs.base.file.openquery.DBData;
import com.spss.java_client.ui.dialogs.base.file.openquery.DefineVarDataOG;
import com.spss.java_client.ui.dialogs.base.file.openquery.UIData;
import com.spss.java_client.ui.dialogs.base.file.openquery.aggregate_data.AggregatedVariablesOG;
import com.spss.java_client.ui.dialogs.base.file.openquery.compute_new_fields.ComputedFieldTableData;
import com.spss.java_client.ui.dialogs.base.file.openquery.limit_retrieved_cases.CriteriaTableData;
import com.spss.java_client.ui.dialogs.base.file.openquery.limit_retrieved_cases.PromptValuesData;
import com.spss.java_client.ui.dialogs.base.file.openquery.sort_cases.SortDataClass;
import com.spss.java_client.ui.dialogs.base.file.openquery.sort_cases.SortDataClassOG;
import com.spss.java_client.ui.dialogs.base.file.openquery.specify_relationships.SerializedJoinInfo;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.DBWizardSyntaxUtil;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.DBWizardUtil;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.odbc.ODBC;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.odbc.ODBCColumn;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.odbc.ODBCTable;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.spss.AggregateColumn;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.spss.AggregatePageInfo;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.spss.ComputeNewFieldsPageInfo;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.spss.ComputedColumn;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.spss.DefineVariablesPageInfo;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.spss.LimitPageInfo;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.spss.RelationshipPageInfo;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.spss.ResultsPageInfo;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.spss.SPSSColumn;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.spss.SampleCases;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.spss.Selected;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.spss.SortCasesPageInfo;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.spss.TableJoin;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.spss.WhereLimitEntry;
import com.spss.java_client.ui.dialogs.base.file.res.FileResBundle;
import com.spss.java_client.ui.resources.ResUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;

public class DBWizardExportOldGeneration {
    public static void fillDBData() {
        DBData dBData = DBData.getDBData();
        ODBC oDBC = ODBC.getODBC();
        dBData.clear();
        dBData.setDBName(oDBC.getLastDataSourceName());
        dBData.setUseODBC(oDBC.isUseODBC());
        dBData.setConnectionString(oDBC.getLastConnectString());
        DBWizardExportOldGeneration.fillAllTablesInfo(dBData);
        DBWizardExportOldGeneration.fillFilteredTablesInfo(dBData);
        DBWizardExportOldGeneration.fillAllColumnsInfo(dBData);
        DBWizardExportOldGeneration.fillFilteredColumnsInfo(dBData);
        DBWizardExportOldGeneration.fillDefineVarDataList(dBData);
        DBWizardExportOldGeneration.fillJoinLists(dBData);
    }

    private static void fillAllTablesInfo(DBData dBData) {
        TablesInfo tablesInfo = dBData.getTablesInfo();
        Vector vector = tablesInfo.getTableCols();
        Vector<TablesInfo.InternalTableInfo> vector2 = dBData.getSynonymTablesInfo();
        Vector<String> vector3 = dBData.getSynonymsData();
        Vector<TablesInfo.InternalTableInfo> vector4 = dBData.getUserTablesInfo();
        Vector<String> vector5 = dBData.getTablesData();
        Vector<TablesInfo.InternalTableInfo> vector6 = dBData.getViewTablesInfo();
        Vector<String> vector7 = dBData.getViewsData();
        Vector<TablesInfo.InternalTableInfo> vector8 = dBData.getSystemTablesInfo();
        Vector<String> vector9 = dBData.getSystemTablesData();
        ODBC oDBC = ODBC.getODBC();
        List<ODBCTable> list = oDBC.getTables();
        dBData.setTableCount(list.size());
        for (ODBCTable oDBCTable : list) {
            String string;
            TablesInfo.InternalTableInfo internalTableInfo = new TablesInfo.InternalTableInfo(tablesInfo);
            internalTableInfo.setDescription(oDBCTable.getDescription());
            internalTableInfo.setName(oDBCTable.getName());
            internalTableInfo.setOwner(oDBCTable.getOwner());
            internalTableInfo.setQualifier(oDBCTable.getQualifier());
            internalTableInfo.setType(oDBCTable.getType());
            vector.add(internalTableInfo);
            if (internalTableInfo.isSynonymType()) {
                string = internalTableInfo.getOwner().length() > 0 ? internalTableInfo.getOwner() + DBWizardUtil.getOwnerNameSeperator() + internalTableInfo.getName() : internalTableInfo.getName();
                vector3.add(string);
                vector2.add(internalTableInfo);
                continue;
            }
            if (internalTableInfo.isUserType()) {
                string = internalTableInfo.getOwner().length() > 0 ? internalTableInfo.getOwner() + DBWizardUtil.getOwnerNameSeperator() + internalTableInfo.getName() : internalTableInfo.getName();
                vector5.add(string);
                vector4.add(internalTableInfo);
                continue;
            }
            if (internalTableInfo.isViewType()) {
                string = internalTableInfo.getOwner().length() > 0 ? internalTableInfo.getOwner() + DBWizardUtil.getOwnerNameSeperator() + internalTableInfo.getName() : internalTableInfo.getName();
                vector7.add(string);
                vector6.add(internalTableInfo);
                continue;
            }
            if (!internalTableInfo.isSystemType()) continue;
            string = internalTableInfo.getOwner().length() > 0 ? internalTableInfo.getOwner() + DBWizardUtil.getOwnerNameSeperator() + internalTableInfo.getName() : internalTableInfo.getName();
            vector9.add(string);
            vector8.add(internalTableInfo);
        }
    }

    private static void fillFilteredTablesInfo(DBData dBData) {
        TablesInfo tablesInfo = dBData.getFilteredTablesInfo();
        Vector vector = tablesInfo.getTableCols();
        Selected selected = Selected.getSelected();
        List<ODBCTable> list = selected.getSelectedTables();
        for (ODBCTable oDBCTable : list) {
            TablesInfo.InternalTableInfo internalTableInfo = new TablesInfo.InternalTableInfo(tablesInfo);
            internalTableInfo.setDescription(oDBCTable.getDescription());
            internalTableInfo.setName(oDBCTable.getName());
            internalTableInfo.setOwner(oDBCTable.getOwner());
            internalTableInfo.setQualifier(oDBCTable.getQualifier());
            internalTableInfo.setType(oDBCTable.getType());
            vector.add(internalTableInfo);
        }
    }

    private static void fillFilteredColumnsInfo(DBData dBData) {
        Selected selected = Selected.getSelected();
        HashMap<String, ColumnsInfo> hashMap = dBData.getFilteredColumnsInfo();
        List<ODBCTable> list = selected.getSelectedTables();
        for (ODBCTable object2 : list) {
            hashMap.put(DBWizardExportOldGeneration.makeOldGenTableName(object2), new ColumnsInfo());
        }
        List<SPSSColumn> list2 = selected.getSelectedColumns();
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            ODBCColumn oDBCColumn = (ODBCColumn)iterator.next();
            ColumnsInfo columnsInfo = hashMap.get(DBWizardExportOldGeneration.makeOldGenTableName(oDBCColumn.getTable()));
            ColumnsInfo.InternalColumnInfo internalColumnInfo = new ColumnsInfo.InternalColumnInfo(columnsInfo);
            internalColumnInfo.setStrQualifier(oDBCColumn.getQualifier());
            internalColumnInfo.setStrOwner(oDBCColumn.getOwner());
            internalColumnInfo.setStrTableName(oDBCColumn.getTableName());
            internalColumnInfo.setStrTypeName(oDBCColumn.getTypeName());
            internalColumnInfo.setStrColumnName(oDBCColumn.getColumnName());
            internalColumnInfo.setStrRemarks(oDBCColumn.getRemarks());
            internalColumnInfo.setIDataType(oDBCColumn.getDataType());
            internalColumnInfo.setIPrecision(oDBCColumn.getPrecision());
            internalColumnInfo.setILength(oDBCColumn.getLength());
            internalColumnInfo.setIScale(oDBCColumn.getScale());
            internalColumnInfo.setIRadix(oDBCColumn.getRadix());
            internalColumnInfo.setINullable(oDBCColumn.getNullable());
            columnsInfo.getColInfos().add(internalColumnInfo);
        }
    }

    private static void fillAllColumnsInfo(DBData dBData) {
        Selected selected = Selected.getSelected();
        HashMap<String, ColumnsInfo> hashMap = dBData.getColumnsInfo();
        List<ODBCTable> list = selected.getSelectedTables();
        for (ODBCTable oDBCTable : list) {
            hashMap.put(DBWizardExportOldGeneration.makeOldGenTableName(oDBCTable), new ColumnsInfo());
            List<ODBCColumn> list2 = ODBC.getODBC().getColumns(oDBCTable.getQualifiedName());
            for (ODBCColumn oDBCColumn : list2) {
                ColumnsInfo columnsInfo = hashMap.get(DBWizardExportOldGeneration.makeOldGenTableName(oDBCColumn.getTable()));
                ColumnsInfo.InternalColumnInfo internalColumnInfo = new ColumnsInfo.InternalColumnInfo(columnsInfo);
                internalColumnInfo.setStrQualifier(oDBCColumn.getQualifier());
                internalColumnInfo.setStrOwner(oDBCColumn.getOwner());
                internalColumnInfo.setStrTableName(oDBCColumn.getTableName());
                internalColumnInfo.setStrTypeName(oDBCColumn.getTypeName());
                internalColumnInfo.setStrColumnName(oDBCColumn.getColumnName());
                internalColumnInfo.setStrRemarks(oDBCColumn.getRemarks());
                internalColumnInfo.setIDataType(oDBCColumn.getDataType());
                internalColumnInfo.setIPrecision(oDBCColumn.getPrecision());
                internalColumnInfo.setILength(oDBCColumn.getLength());
                internalColumnInfo.setIScale(oDBCColumn.getScale());
                internalColumnInfo.setIRadix(oDBCColumn.getRadix());
                internalColumnInfo.setINullable(oDBCColumn.getNullable());
                columnsInfo.getColInfos().add(internalColumnInfo);
            }
        }
    }

    private static void fillDefineVarDataList(DBData dBData) {
        LinkedList<DefineVarDataOG> linkedList = dBData.getDefineVarDataList();
        Selected selected = Selected.getSelected();
        List<SPSSColumn> list = selected.getSelectedColumns();
        DefineVariablesPageInfo defineVariablesPageInfo = DefineVariablesPageInfo.getDefineVariablesPageInfo();
        List<SPSSColumn> list2 = defineVariablesPageInfo.getRecodeColumns();
        for (SPSSColumn sPSSColumn : list) {
            DefineVarDataOG defineVarDataOG = new DefineVarDataOG();
            defineVarDataOG.setAutoRecodeInfo(list2.contains(sPSSColumn));
            defineVarDataOG.setOriginalColumnName(sPSSColumn.getColumnName());
            defineVarDataOG.setOwner(sPSSColumn.getOwner());
            defineVarDataOG.setQualifiedNameInfo(DBWizardExportOldGeneration.makeStupidTableColumnName(sPSSColumn));
            defineVarDataOG.setResultNameInfo(sPSSColumn.getUserName());
            defineVarDataOG.setTableName(sPSSColumn.getTableName());
            defineVarDataOG.setVarTypeInfo(sPSSColumn.getTypeName());
            defineVarDataOG.setBreakVar(true);
            linkedList.add(defineVarDataOG);
        }
    }

    private static String makeStupidTableColumnName(SPSSColumn sPSSColumn) {
        if (sPSSColumn.getOwner().length() > 0) {
            return sPSSColumn.getOwner() + "." + sPSSColumn.getTableName() + ": " + sPSSColumn.getColumnName();
        }
        return sPSSColumn.getTableName() + ": " + sPSSColumn.getColumnName();
    }

    private static String makeOldGenTableName(ODBCTable oDBCTable) {
        if (oDBCTable.getOwner().length() > 0) {
            return oDBCTable.getOwner() + "." + oDBCTable.getName();
        }
        return oDBCTable.getName();
    }

    private static void fillJoinLists(DBData dBData) {
        ArrayList<SerializedJoinInfo> arrayList = dBData.getSerializableAutoJoinList();
        ArrayList<SerializedJoinInfo> arrayList2 = dBData.getSerializableSysJoinList();
        ArrayList<SerializedJoinInfo> arrayList3 = dBData.getSerializableUserJoinList();
        RelationshipPageInfo relationshipPageInfo = RelationshipPageInfo.getRelationshipPageInfo();
        List<TableJoin> list = relationshipPageInfo.getTableJoins();
        for (TableJoin tableJoin : list) {
            SerializedJoinInfo serializedJoinInfo = new SerializedJoinInfo();
            ColumnsInfo.InternalColumnInfo internalColumnInfo = DBWizardExportOldGeneration.getColumnInfo(dBData, tableJoin.getLeft());
            ColumnsInfo.InternalColumnInfo internalColumnInfo2 = DBWizardExportOldGeneration.getColumnInfo(dBData, tableJoin.getRight());
            TablesInfo.InternalTableInfo internalTableInfo = DBWizardExportOldGeneration.getTableInfo(dBData, tableJoin.getLeft().getTable());
            TablesInfo.InternalTableInfo internalTableInfo2 = DBWizardExportOldGeneration.getTableInfo(dBData, tableJoin.getRight().getTable());
            serializedJoinInfo.setJoinType(tableJoin.getJoinType());
            serializedJoinInfo.setSrcColumnInfo(internalColumnInfo);
            serializedJoinInfo.setSrcTableInfo(internalTableInfo);
            serializedJoinInfo.setTargetColumnInfo(internalColumnInfo2);
            serializedJoinInfo.setTargetTableInfo(internalTableInfo2);
            switch (tableJoin.getJoinOrigin()) {
                case AUTO_JOIN: {
                    arrayList.add(serializedJoinInfo);
                    break;
                }
                case SYSTEM_JOIN: {
                    arrayList2.add(serializedJoinInfo);
                    break;
                }
                case USER_JOIN: {
                    arrayList3.add(serializedJoinInfo);
                }
            }
        }
    }

    private static TablesInfo.InternalTableInfo getTableInfo(DBData dBData, ODBCTable oDBCTable) {
        TablesInfo tablesInfo = dBData.getFilteredTablesInfo();
        Vector vector = tablesInfo.getTableCols();
        for (TablesInfo.InternalTableInfo internalTableInfo : vector) {
            if (!internalTableInfo.getName().equals(oDBCTable.getName()) || !internalTableInfo.getOwner().equals(oDBCTable.getOwner()) || !internalTableInfo.getQualifier().equals(oDBCTable.getQualifier())) continue;
            return internalTableInfo;
        }
        return null;
    }

    private static ColumnsInfo.InternalColumnInfo getColumnInfo(DBData dBData, ODBCColumn oDBCColumn) {
        HashMap<String, ColumnsInfo> hashMap = dBData.getColumnsInfo();
        Set<String> set = hashMap.keySet();
        for (String string : set) {
            ColumnsInfo columnsInfo = hashMap.get(string);
            Vector vector = columnsInfo.getColInfos();
            for (ColumnsInfo.InternalColumnInfo internalColumnInfo : vector) {
                if (!internalColumnInfo.getStrColumnName().equals(oDBCColumn.getColumnName()) || !internalColumnInfo.getStrTableName().equals(oDBCColumn.getTableName()) || !internalColumnInfo.getStrOwner().equals(oDBCColumn.getOwner()) || !internalColumnInfo.getStrQualifier().equals(oDBCColumn.getQualifier())) continue;
                return internalColumnInfo;
            }
        }
        return null;
    }

    public static void fillUIData() {
        UIData uIData = UIData.getUIData();
        uIData.clearMap();
        ODBC oDBC = ODBC.getODBC();
        uIData.putObject("WP_DATABASE_NAME", oDBC.getLastDataSourceName());
        uIData.putObject("WP_IS_ODBC", oDBC.isUseODBC());
        uIData.putObject("WP_CONNECTION_STRING", oDBC.getLastConnectString());
        uIData.putObject("WP_SELECTED_TABLE_TYPES", Selected.getSelected().getSelectedTableTypes());
        DBWizardExportOldGeneration.exportComputeNewFieldPageInfo(uIData);
        DBWizardExportOldGeneration.exportLimitPageInfo(uIData);
        DBWizardExportOldGeneration.exportAggregatePageInfo(uIData);
        DBWizardExportOldGeneration.exportDefineVariablesPageInfo(uIData);
        DBWizardExportOldGeneration.exportSortCasesPageInfo(uIData);
        DBWizardExportOldGeneration.exportResultsPageInfo(uIData);
    }

    private static void exportComputeNewFieldPageInfo(UIData uIData) {
        ComputeNewFieldsPageInfo computeNewFieldsPageInfo = ComputeNewFieldsPageInfo.getNewFieldsInfo();
        List<ComputedColumn> list = computeNewFieldsPageInfo.getNewColumns();
        ArrayList<ComputedFieldTableData> arrayList = new ArrayList<ComputedFieldTableData>();
        int n = 1;
        for (ComputedColumn computedColumn : list) {
            ComputedFieldTableData computedFieldTableData = new ComputedFieldTableData(n, computedColumn.getColumnName(), computedColumn.getExpression());
            arrayList.add(computedFieldTableData);
            ++n;
        }
        uIData.putObject("CNFP_TRANS_EXPR_TABLE", arrayList);
    }

    private static void exportLimitPageInfo(UIData uIData) {
        LimitPageInfo limitPageInfo = LimitPageInfo.getLimitPageInfo();
        if (!limitPageInfo.isExisting()) {
            return;
        }
        List<WhereLimitEntry> list = limitPageInfo.getWhereLimitList();
        ArrayList<CriteriaTableData> arrayList = new ArrayList<CriteriaTableData>(list.size());
        TreeMap<String, PromptValuesData> treeMap = new TreeMap<String, PromptValuesData>();
        int n = 0;
        for (WhereLimitEntry whereLimitEntry : list) {
            String string;
            CriteriaTableData criteriaTableData = new CriteriaTableData();
            criteriaTableData.setSerialNumber(n + 1);
            criteriaTableData.setConnector(whereLimitEntry.getConnector());
            criteriaTableData.setExpression1(whereLimitEntry.getLeftSide());
            criteriaTableData.setRelation(whereLimitEntry.getRelation());
            criteriaTableData.setExpression2(whereLimitEntry.getRightSide());
            PromptValuesData promptValuesData = whereLimitEntry.getLeftSidePrompt();
            if (promptValuesData != null) {
                string = "" + n + ',' + 2;
                treeMap.put(string, promptValuesData);
            }
            if ((promptValuesData = whereLimitEntry.getRightSidePrompt()) != null) {
                string = "" + n + ',' + 4;
                treeMap.put(string, promptValuesData);
            }
            arrayList.add(criteriaTableData);
            ++n;
        }
        uIData.putObject("LRCP_CRITERIA_TABLE_MODEL", arrayList);
        if (treeMap.size() > 0) {
            uIData.putObject("LRCP_PROMPT_DATA_VALUES_MAP", treeMap);
        }
        if (!limitPageInfo.isUseSampling()) {
            uIData.putObject("LRCP_USE_RANDOM_SAMPLING_CHECK", false);
            uIData.putObject("LRCP_NATIVE_RANDOM_SAMPLING_RADIO", false);
            uIData.putObject("LRCP_APPROXIMATELY_RADIO", false);
            uIData.putObject("LRCP_EXACTLY_TEXTFIELD1", "100");
            uIData.putObject("LRCP_EXACTLY_TEXTFIELD2", "1000");
            uIData.putObject("LRCP_APPROXIMATELY_SPINNER", 10);
        } else {
            SampleCases sampleCases = limitPageInfo.getSampleCases();
            uIData.putObject("LRCP_USE_RANDOM_SAMPLING_CHECK", true);
            uIData.putObject("LRCP_NATIVE_RANDOM_SAMPLING_RADIO", sampleCases.getSampleMethod() == 1);
            uIData.putObject("LRCP_APPROXIMATELY_RADIO", sampleCases.getSampleSizeMethod() == 0);
            uIData.putObject("LRCP_APPROXIMATELY_SPINNER", sampleCases.getPercentageOfCases());
            uIData.putObject("LRCP_EXACTLY_TEXTFIELD1", sampleCases.getNumberOfCases());
            uIData.putObject("LRCP_EXACTLY_TEXTFIELD2", sampleCases.getFromFirstCases());
        }
    }

    private static void exportAggregatePageInfo(UIData uIData) {
        Object object;
        AggregatePageInfo aggregatePageInfo = AggregatePageInfo.getAggregatePageInfo();
        List<SPSSColumn> list = aggregatePageInfo.getBreakColumns();
        List<AggregateColumn> list2 = aggregatePageInfo.getAggregateColumns();
        TreeMap<String, ColumnsInfo.InternalColumnInfo> treeMap = new TreeMap<String, ColumnsInfo.InternalColumnInfo>();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        DBData dBData = DBData.getDBData();
        for (SPSSColumn sPSSColumn : list) {
            object = DBWizardExportOldGeneration.makeStupidTableColumnName(sPSSColumn);
            ColumnsInfo.InternalColumnInfo internalColumnInfo = null;
            if (sPSSColumn instanceof ComputedColumn) {
                ComputedColumn computedColumn = (ComputedColumn)sPSSColumn;
                internalColumnInfo = new ColumnsInfo.InternalColumnInfo(new ColumnsInfo());
                internalColumnInfo.setStrColumnName(computedColumn.getColumnName());
            } else {
                internalColumnInfo = DBWizardExportOldGeneration.getColumnInfo(dBData, sPSSColumn);
            }
            treeMap.put((String)object, internalColumnInfo);
        }
        uIData.putObject("ADP_BREAK_VARAIBLE_LIST", treeMap);
        for (AggregateColumn aggregateColumn : list2) {
            object = new AggregatedVariablesOG();
            ((AggregatedVariablesOG)object).setColumnDisplayedName(aggregateColumn.getUserName());
            ((AggregatedVariablesOG)object).setFunctionSuffix(aggregateColumn.getFunction());
            ((AggregatedVariablesOG)object).setColumnOriginalName(aggregateColumn.getColumnName());
            ((AggregatedVariablesOG)object).setColumnType(aggregateColumn.getDataType());
            ((AggregatedVariablesOG)object).setFunction(DBWizardSyntaxUtil.localizeFunctionName(aggregateColumn.getFunction()));
            boolean bl = false;
            if (aggregateColumn.getSPSSDataType() == 1) {
                bl = true;
            }
            ((AggregatedVariablesOG)object).setIsStringType(bl);
            ((AggregatedVariablesOG)object).setOwnerName(aggregateColumn.getOwner());
            ((AggregatedVariablesOG)object).setTableName(aggregateColumn.getTableName());
            arrayList.add(object);
        }
        uIData.putObject("ADP_SUMMARIES_VARIABLE_TABLE", arrayList);
        uIData.putObject("ADP_NUMBER_CASES_CHECK", aggregatePageInfo.isIncludeNumberOfCases());
    }

    private static void exportDefineVariablesPageInfo(UIData uIData) {
        DefineVariablesPageInfo defineVariablesPageInfo = DefineVariablesPageInfo.getDefineVariablesPageInfo();
        if (!defineVariablesPageInfo.isExisting()) {
            return;
        }
        uIData.putObject("DVP_VARIABLE_WIDTH_TEXT", "" + defineVariablesPageInfo.getAssumedStringWidth());
        uIData.putObject("DVP_MINIMIZE_STRING_WIDTHS", defineVariablesPageInfo.isMinimizeStrings());
    }

    private static void exportSortCasesPageInfo(UIData uIData) {
        SortCasesPageInfo sortCasesPageInfo = SortCasesPageInfo.getSortCasesPageInfo();
        if (!sortCasesPageInfo.isExisting()) {
            return;
        }
        List<SortDataClass> list = sortCasesPageInfo.getSortData();
        ArrayList<SortDataClassOG> arrayList = new ArrayList<SortDataClassOG>();
        ResourceBundle resourceBundle = ResUtil.getBundle(FileResBundle.getDefaultResourceBundleName(), ResUtil.getLocale());
        for (SortDataClass sortDataClass : list) {
            String string = sortDataClass.getColumn().getUserName();
            String string2 = sortDataClass.getSortType() == 2 ? ResUtil.getString(resourceBundle, "IDS_SORT_CASES_COMBO_VALUE2") : ResUtil.getString(resourceBundle, "IDS_SORT_CASES_COMBO_VALUE1");
            SortDataClassOG sortDataClassOG = new SortDataClassOG(string, string2);
            arrayList.add(sortDataClassOG);
        }
        uIData.putObject("SDP_TARGET_TABLE", arrayList);
    }

    private static void exportResultsPageInfo(UIData uIData) {
        ResultsPageInfo resultsPageInfo = ResultsPageInfo.getResultsPageInfo();
        if (!resultsPageInfo.isExisting()) {
            return;
        }
        uIData.putObject("RP_SQL_QUERY", resultsPageInfo.getSql());
        uIData.putObject("RP_RETRIEVE_RADIO", resultsPageInfo.getRetrive());
        uIData.putObject("RP_SAVE_FILENAME", resultsPageInfo.getFileName());
    }

    public static Map<String, String> getEmptyTempTableNameMap() {
        return new LinkedHashMap<String, String>();
    }
}

