/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.file.openquery;

import com.spss.java_client.core.comp_util.IDialogCallback;
import com.spss.java_client.core.documents.DocType;
import com.spss.java_client.core.documents.data.data_access.ODBC.ODBCDacProxy;
import com.spss.java_client.core.server.DataServerProxy;
import com.spss.java_client.core.server.messages.DataAccess.OleDbDataSourceInfo;
import com.spss.java_client.core.server.messages.DataAccess.odbcmsg.ODBCWizardCapabilities;
import com.spss.java_client.core.server.messages.DataAccess.odbcmsg.TablesInfo;
import com.spss.java_client.ui.SpssFrameMgr;
import com.spss.java_client.ui.dialogs.base.file.DialogCallbackImpl;
import com.spss.java_client.ui.dialogs.base.file.openquery.DBData;
import com.spss.java_client.ui.dialogs.base.file.openquery.DBWizardConvertToNewGeneration;
import com.spss.java_client.ui.dialogs.base.file.openquery.DBWizardDlgType;
import com.spss.java_client.ui.dialogs.base.file.openquery.DBWizardMFCAppDataReader;
import com.spss.java_client.ui.dialogs.base.file.openquery.DBWizardMFCAppSerializedData;
import com.spss.java_client.ui.dialogs.base.file.openquery.DBWizardSerializedData;
import com.spss.java_client.ui.dialogs.base.file.openquery.KeyDoesNotExistsException;
import com.spss.java_client.ui.dialogs.base.file.openquery.ODBCSerializationContext;
import com.spss.java_client.ui.dialogs.base.file.openquery.UIData;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.DBWizardSyntaxUtil;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.DBWizardUtil;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.odbc.ODBC;
import com.spss.java_client.ui.dialogs.base.file.res.FileResBundle;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.resources.ResUtil;
import java.io.IOException;
import java.io.StreamCorruptedException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import java.util.TreeMap;
import java.util.Vector;

public class DBWizardDataReader {
    public static void readDefaultData() {
        UIData uIData = UIData.getUIData();
        uIData.clearMap();
        uIData.putObject("WP_IS_ODBC", true);
        uIData.putObject("WP_CONNECTION_STRING", "");
        uIData.putObject("WP_DATABASE_NAME", "");
        uIData.putObject("SDP_SORT_FIELD_CHECK", false);
        uIData.putObject("SDP_SHOW_TABLES_CHECK", true);
        uIData.putObject("SDP_SHOW_VIEWS_CHECK", false);
        uIData.putObject("SDP_SHOW_SYNONYM_CHECK", false);
        uIData.putObject("SDP_SHOW_SYSTEM_TABLES_CHECK", false);
        uIData.putObject("SDP_REMOVE_TREE_NODE", new ArrayList());
        uIData.putObject("SDP_EXPANDED_NODE", new ArrayList());
        uIData.putObject("SDP_FILTERED_DATA_MAP", new HashMap());
        uIData.putObject("SRP_AUTO_JOIN_CHECK", true);
        uIData.putObject("CNFP_TRANS_EXPR_TABLE", new ArrayList());
        uIData.putObject("LRCP_USE_RANDOM_SAMPLING_CHECK", false);
        uIData.putObject("LRCP_NATIVE_RANDOM_SAMPLING_RADIO", false);
        uIData.putObject("LRCP_EXACTLY_TEXTFIELD1", "100");
        uIData.putObject("LRCP_EXACTLY_TEXTFIELD2", "1000");
        uIData.putObject("LRCP_APPROXIMATELY_RADIO", true);
        uIData.putObject("LRCP_APPROXIMATELY_SPINNER", 10);
        uIData.putObject("LRCP_CRITERIA_TABLE_MODEL", new ArrayList());
        uIData.putObject("LRCP_PROMPT_DATA_VALUES_MAP", new TreeMap());
        uIData.putObject("ADP_SOURCE_LIST", new TreeMap());
        uIData.putObject("ADP_BREAK_VARAIBLE_LIST", new TreeMap());
        uIData.putObject("ADP_SUMMARIES_VARIABLE_TABLE", new ArrayList());
        uIData.putObject("ADP_NUMBER_CASES_CHECK", false);
        uIData.putObject("DVP_VARIABLE_WIDTH_TEXT", "255");
        uIData.putObject("SDP_SOURCE_LIST", new ArrayList());
        uIData.putObject("SDP_TARGET_TABLE", new ArrayList());
        uIData.putObject("RP_SQL_QUERY", "");
        uIData.putObject("RP_PASTE_RADIO", false);
        uIData.putObject("RP_RETRIEVE_RADIO", true);
        uIData.putObject("RP_SAVE_FILENAME", "");
        uIData.putObject("DBW_TEMP_TABLE_MAP", new LinkedHashMap());
    }

    public static boolean readSerializedData(String string) throws KeyDoesNotExistsException, IOException {
        if (string.length() > 0) {
            DBWizardSerializedData dBWizardSerializedData = DBWizardSerializedData.getInstance();
            UIData uIData = UIData.getUIData();
            try {
                dBWizardSerializedData.readObject(string);
                try {
                    ODBC oDBC = ODBC.getODBC();
                    uIData.setUIData((UIData)dBWizardSerializedData.getObject("DBW_UIDATA"));
                    DBData.setDBData((DBData)dBWizardSerializedData.getObject("DBW_DBDATA"));
                    ResourceBundle resourceBundle = ResUtil.getBundle(FileResBundle.getDefaultResourceBundleName(), ResUtil.getLocale());
                    SpssFrame spssFrame = SpssFrameMgr.getSpssFrameMgr().getDesignatedWindow(DocType.DE_DOC);
                    Boolean bl = (Boolean)dBWizardSerializedData.getObject("DBW_IS_REMOTE_CONNECTION");
                    String string2 = uIData.getString("WP_DATABASE_NAME");
                    Boolean bl2 = uIData.getBoolean("WP_IS_ODBC");
                    String string3 = uIData.getString("WP_CONNECTION_STRING");
                    if (bl.booleanValue() != oDBC.isRemoteConnection()) {
                        SpssAlertOptionPane.showWarningMessageDialog(spssFrame, MessageFormat.format(ResUtil.getString(resourceBundle, "ERR_DB_COMMON_REMOTE_CONNECTION"), string, string2), ResUtil.getString(resourceBundle, "IDS_DBWIZARD_WARNING_TITLE"));
                        return false;
                    }
                    if (!oDBC.connectFromConnectionString(bl2, false, string2, string3)) {
                        SpssAlertOptionPane.showWarningMessageDialog(spssFrame, MessageFormat.format(ResUtil.getString(resourceBundle, "ERR_DB_COMMON_CONNECTION_FAILED"), string, string2), ResUtil.getString(resourceBundle, "IDS_DBWIZARD_WARNING_TITLE"));
                        return false;
                    }
                    String string4 = uIData.getString("WP_SELECTED_TABLE_TYPES");
                    if (!oDBC.loadTables(null, string4)) {
                        SpssAlertOptionPane.showWarningMessageDialog(spssFrame, MessageFormat.format(ResUtil.getString(resourceBundle, "ERR_DB_COMMON_CONNECTION_FAILED"), string, string2), ResUtil.getString(resourceBundle, "IDS_DBWIZARD_WARNING_TITLE"));
                        return false;
                    }
                    ODBCSerializationContext oDBCSerializationContext = new ODBCSerializationContext(DBData.getDBData());
                    DBWizardConvertToNewGeneration.fillSelected(oDBCSerializationContext);
                    DBWizardConvertToNewGeneration.fillRelationshipPageInfo(oDBCSerializationContext);
                    DBWizardConvertToNewGeneration.fillComputeNewFieldsPageInfo(oDBCSerializationContext);
                    DBWizardConvertToNewGeneration.fillLimitPageInfo(oDBCSerializationContext);
                    DBWizardConvertToNewGeneration.fillAggregatePageInfo(oDBCSerializationContext);
                    DBWizardConvertToNewGeneration.fillDefineVariablesPageInfo(oDBCSerializationContext);
                    DBWizardConvertToNewGeneration.fillSortCasesPageInfo(oDBCSerializationContext);
                    DBWizardConvertToNewGeneration.fillResultsPageInfo(oDBCSerializationContext);
                    return true;
                }
                catch (KeyDoesNotExistsException keyDoesNotExistsException) {
                    throw new KeyDoesNotExistsException();
                }
            }
            catch (StreamCorruptedException streamCorruptedException) {
                DBWizardMFCAppDataReader.SPSS_11 = false;
                DBWizardMFCAppDataReader.DBWizardMFCAppReadStatus dBWizardMFCAppReadStatus = DBWizardMFCAppDataReader.readSPQFile(string);
                if (dBWizardMFCAppReadStatus == DBWizardMFCAppDataReader.DBWizardMFCAppReadStatus.eReadSuccess) {
                    return DBWizardDataReader.validateLegacyQuery(string);
                }
                if (dBWizardMFCAppReadStatus == DBWizardMFCAppDataReader.DBWizardMFCAppReadStatus.eReadFailure) {
                    DBWizardMFCAppDataReader.SPSS_11 = true;
                    dBWizardMFCAppReadStatus = DBWizardMFCAppDataReader.readSPQFile(string);
                    if (dBWizardMFCAppReadStatus == DBWizardMFCAppDataReader.DBWizardMFCAppReadStatus.eReadSuccess) {
                        return DBWizardDataReader.validateLegacyQuery(string);
                    }
                    if (dBWizardMFCAppReadStatus == DBWizardMFCAppDataReader.DBWizardMFCAppReadStatus.eReadFailure) {
                        throw new StreamCorruptedException();
                    }
                } else {
                    return false;
                }
                return false;
            }
            catch (IOException iOException) {
                throw new IOException();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            catch (AssertionError assertionError) {
                ((Throwable)((Object)assertionError)).printStackTrace();
            }
        }
        return false;
    }

    public static boolean readSerializedDataOld(String string) throws KeyDoesNotExistsException, IOException {
        if (string.length() > 0) {
            DBWizardSerializedData dBWizardSerializedData = DBWizardSerializedData.getInstance();
            UIData uIData = UIData.getUIData();
            try {
                dBWizardSerializedData.readObject(string);
                try {
                    Boolean bl = (Boolean)dBWizardSerializedData.getObject("DBW_IS_REMOTE_CONNECTION");
                    uIData.setUIData((UIData)dBWizardSerializedData.getObject("DBW_UIDATA"));
                    DBData.setDBData((DBData)dBWizardSerializedData.getObject("DBW_DBDATA"));
                    String string2 = (String)UIData.getUIData().getObject("WP_DATABASE_NAME");
                    ResourceBundle resourceBundle = ResUtil.getBundle(FileResBundle.getDefaultResourceBundleName(), ResUtil.getLocale());
                    SpssFrame spssFrame = SpssFrameMgr.getSpssFrameMgr().getDesignatedWindow(DocType.DE_DOC);
                    if (bl.booleanValue() == DataServerProxy.getDataProxy().isRemoteConnection()) {
                        String string3 = (String)UIData.getUIData().getObject("WP_CONNECTION_STRING");
                        DBWizardSyntaxUtil.setConnectionString(string3);
                        DBData dBData = (DBData)dBWizardSerializedData.getObject("DBW_DBDATA");
                        DBWizardSyntaxUtil.setUseODBC(dBData.isODBC());
                        ODBCDacProxy oDBCDacProxy = ODBCDacProxy.getODBCDacProxy();
                        ODBCWizardCapabilities oDBCWizardCapabilities = new ODBCWizardCapabilities();
                        ODBCDacProxy.SqlReturnCode sqlReturnCode = new ODBCDacProxy.SqlReturnCode(oDBCDacProxy);
                        sqlReturnCode.setSqlCode((short)0);
                        ODBCDacProxy.ProxyReturnCode proxyReturnCode = ODBCDacProxy.ProxyReturnCode.UI_CANCELLED;
                        if (dBData.isODBC()) {
                            if (DBWizardUtil.getDBMSName().toUpperCase().contains("OPENACCESS")) {
                                DialogCallbackImpl dialogCallbackImpl = new DialogCallbackImpl(spssFrame);
                                proxyReturnCode = oDBCDacProxy.connectToDataSource(dBData.getDBName(), (IDialogCallback)dialogCallbackImpl, dBData.getWizardCapabities(), sqlReturnCode);
                            } else {
                                proxyReturnCode = oDBCDacProxy.reconnect(string3, oDBCWizardCapabilities, sqlReturnCode);
                            }
                        } else {
                            proxyReturnCode = DBWizardDataReader.findOleDbDataSource(string2, string3) ? ODBCDacProxy.ProxyReturnCode.PROXY_OK : ODBCDacProxy.ProxyReturnCode.UI_CANCELLED;
                        }
                        if (proxyReturnCode == ODBCDacProxy.ProxyReturnCode.PROXY_OK && sqlReturnCode.getSqlCode() != -1) {
                            DBWizardUtil.loadDataFromQuery();
                            return true;
                        }
                        SpssAlertOptionPane.showWarningMessageDialog(spssFrame, MessageFormat.format(ResUtil.getString(resourceBundle, "ERR_DB_COMMON_CONNECTION_FAILED"), string, string2), ResUtil.getString(resourceBundle, "IDS_DBWIZARD_WARNING_TITLE"));
                        return false;
                    }
                    SpssAlertOptionPane.showWarningMessageDialog(spssFrame, MessageFormat.format(ResUtil.getString(resourceBundle, "ERR_DB_COMMON_REMOTE_CONNECTION"), string, string2), ResUtil.getString(resourceBundle, "IDS_DBWIZARD_WARNING_TITLE"));
                    return false;
                }
                catch (KeyDoesNotExistsException keyDoesNotExistsException) {
                    throw new KeyDoesNotExistsException();
                }
            }
            catch (StreamCorruptedException streamCorruptedException) {
                DBWizardMFCAppDataReader.SPSS_11 = false;
                DBWizardMFCAppDataReader.DBWizardMFCAppReadStatus dBWizardMFCAppReadStatus = DBWizardMFCAppDataReader.readSPQFile(string);
                if (dBWizardMFCAppReadStatus == DBWizardMFCAppDataReader.DBWizardMFCAppReadStatus.eReadSuccess) {
                    return DBWizardDataReader.validateLegacyQuery(string);
                }
                if (dBWizardMFCAppReadStatus == DBWizardMFCAppDataReader.DBWizardMFCAppReadStatus.eReadFailure) {
                    DBWizardMFCAppDataReader.SPSS_11 = true;
                    dBWizardMFCAppReadStatus = DBWizardMFCAppDataReader.readSPQFile(string);
                    if (dBWizardMFCAppReadStatus == DBWizardMFCAppDataReader.DBWizardMFCAppReadStatus.eReadSuccess) {
                        return DBWizardDataReader.validateLegacyQuery(string);
                    }
                    if (dBWizardMFCAppReadStatus == DBWizardMFCAppDataReader.DBWizardMFCAppReadStatus.eReadFailure) {
                        throw new StreamCorruptedException();
                    }
                } else {
                    return false;
                }
                return false;
            }
            catch (IOException iOException) {
                throw new IOException();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            catch (AssertionError assertionError) {
                ((Throwable)((Object)assertionError)).printStackTrace();
            }
        }
        return false;
    }

    public static boolean validateLegacyQuery(String string) {
        DBWizardMFCAppSerializedData dBWizardMFCAppSerializedData = DBWizardMFCAppSerializedData.getInstance();
        SpssFrame spssFrame = SpssFrameMgr.getSpssFrameMgr().getDesignatedWindow(DocType.DE_DOC);
        ResourceBundle resourceBundle = ResUtil.getBundle(FileResBundle.getDefaultResourceBundleName(), ResUtil.getLocale());
        if (DataServerProxy.getDataProxy().isRemoteConnection() != dBWizardMFCAppSerializedData.isServerQuery()) {
            SpssAlertOptionPane.showWarningMessageDialog(spssFrame, MessageFormat.format(ResUtil.getString(resourceBundle, "ERR_DB_COMMON_REMOTE_CONNECTION"), string, dBWizardMFCAppSerializedData.getDSNName()), ResUtil.getString(resourceBundle, "IDS_DBWIZARD_WARNING_TITLE"));
            return false;
        }
        ODBCWizardCapabilities oDBCWizardCapabilities = new ODBCWizardCapabilities();
        ODBCDacProxy oDBCDacProxy = ODBCDacProxy.getODBCDacProxy();
        ODBCDacProxy.SqlReturnCode sqlReturnCode = new ODBCDacProxy.SqlReturnCode(oDBCDacProxy);
        sqlReturnCode.setSqlCode((short)0);
        dBWizardMFCAppSerializedData.setWizardCap(oDBCWizardCapabilities);
        ODBCDacProxy.ProxyReturnCode proxyReturnCode = dBWizardMFCAppSerializedData.isODBC() ? oDBCDacProxy.reconnect(dBWizardMFCAppSerializedData.getConnectionString(), oDBCWizardCapabilities, sqlReturnCode) : (DBWizardDataReader.findOleDbDataSource(dBWizardMFCAppSerializedData.getConnectionString()) ? ODBCDacProxy.ProxyReturnCode.PROXY_OK : ODBCDacProxy.ProxyReturnCode.UI_CANCELLED);
        if (proxyReturnCode != ODBCDacProxy.ProxyReturnCode.PROXY_OK || sqlReturnCode.getSqlCode() == -1) {
            SpssAlertOptionPane.showWarningMessageDialog(spssFrame, MessageFormat.format(ResUtil.getString(resourceBundle, "ERR_DB_COMMON_CONNECTION_FAILED"), string, dBWizardMFCAppSerializedData.getDSNName()), ResUtil.getString(resourceBundle, "IDS_DBWIZARD_WARNING_TITLE"));
            return false;
        }
        dBWizardMFCAppSerializedData.initializeDBWizard();
        DBWizardDlgType.setDBWizardDlgType(DBWizardDlgType.DBWizardDialogTypeEnum.eEditQueryFromMFCDlg);
        return true;
    }

    public static boolean findOleDbDataSource(String string, String string2) {
        Vector vector = new Vector();
        ODBCDacProxy oDBCDacProxy = ODBCDacProxy.getODBCDacProxy();
        ODBCDacProxy.SqlReturnCode sqlReturnCode = new ODBCDacProxy.SqlReturnCode(oDBCDacProxy);
        if (oDBCDacProxy.getOleDbDataSources(vector, sqlReturnCode) == ODBCDacProxy.ProxyReturnCode.PROXY_OK && vector.size() > 0) {
            for (OleDbDataSourceInfo oleDbDataSourceInfo : vector) {
                if (!string.equals(oleDbDataSourceInfo.getName()) || !string2.equals(oleDbDataSourceInfo.getConn())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean findOleDbDataSource(String string) {
        Vector vector = new Vector();
        ODBCDacProxy oDBCDacProxy = ODBCDacProxy.getODBCDacProxy();
        ODBCDacProxy.SqlReturnCode sqlReturnCode = new ODBCDacProxy.SqlReturnCode(oDBCDacProxy);
        if (oDBCDacProxy.getOleDbDataSources(vector, sqlReturnCode) == ODBCDacProxy.ProxyReturnCode.PROXY_OK && vector.size() > 0) {
            for (OleDbDataSourceInfo oleDbDataSourceInfo : vector) {
                if (!string.equals(oleDbDataSourceInfo.getConn())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean getTablesOLeDb(String string) {
        ODBCDacProxy oDBCDacProxy = ODBCDacProxy.getODBCDacProxy();
        ODBCDacProxy.SqlReturnCode sqlReturnCode = new ODBCDacProxy.SqlReturnCode(oDBCDacProxy);
        oDBCDacProxy.setConnectString(string);
        TablesInfo tablesInfo = new TablesInfo();
        ODBCDacProxy.ProxyReturnCode proxyReturnCode = oDBCDacProxy.getTables(tablesInfo, sqlReturnCode, false);
        return proxyReturnCode == ODBCDacProxy.ProxyReturnCode.PROXY_OK && sqlReturnCode.getSqlCode() != -1;
    }
}

