/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.file.openquery;

import com.spss.java_client.core.comp_util.IDialogCallback;
import com.spss.java_client.core.comp_util.InDataStream;
import com.spss.java_client.core.comp_util.OutDataStream;
import com.spss.java_client.core.documents.DocType;
import com.spss.java_client.core.documents.data.data_access.ODBC.ODBCDacProxy;
import com.spss.java_client.core.server.InputDataStream;
import com.spss.java_client.core.server.OutputDataStream;
import com.spss.java_client.core.server.messages.DataAccess.odbcmsg.ColumnsInfo;
import com.spss.java_client.core.server.messages.DataAccess.odbcmsg.ODBCWizardCapabilities;
import com.spss.java_client.core.server.messages.DataAccess.odbcmsg.TablesInfo;
import com.spss.java_client.ui.SpssFrameMgr;
import com.spss.java_client.ui.dialogs.base.file.DialogCallbackImpl;
import com.spss.java_client.ui.dialogs.base.file.ProgressFrame;
import com.spss.java_client.ui.dialogs.base.file.openquery.AggregateData;
import com.spss.java_client.ui.dialogs.base.file.openquery.DefineVarDataOG;
import com.spss.java_client.ui.dialogs.base.file.openquery.specify_relationships.JoinType;
import com.spss.java_client.ui.dialogs.base.file.openquery.specify_relationships.RelationshipPageUtils;
import com.spss.java_client.ui.dialogs.base.file.openquery.specify_relationships.SerializedJoinInfo;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.DBWizardUtil;
import com.spss.java_client.ui.doc_types.SpssFrame;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Vector;

public class DBData
implements Serializable {
    private static final String ORACLE_DB = "Oracle";
    private static final String TERADATA_DB = "Teradata";
    private static final String EXCEL_DB = "Excel";
    private static final String EXCEL_ME_NOT = "ExcelMeNot";
    private static DBData mDBData;
    private boolean mUseODBC;
    private Vector<String> mSystemTablesData;
    private Vector<String> mSynonymsData;
    private Vector<String> mViewsData;
    private Vector<String> mTablesData;
    private TablesInfo mTablesInfo;
    private HashMap<String, ColumnsInfo> mColumnsInfo;
    private HashMap<String, ColumnsInfo> mQualifiedColumnsInfo;
    private TablesInfo mFilteredTablesInfo;
    private HashMap<String, ColumnsInfo> mFilteredColumnsInfo;
    private LinkedList<AggregateData> mAggregateDataList;
    private HashMap<String, ColumnsInfo> mTableColumns;
    private LinkedList<DefineVarDataOG> mDefineVarDataList;
    private String mDBName;
    private ODBCWizardCapabilities mWizardCapabilities;
    private ArrayList<SerializedJoinInfo> mSerializableAutoJoinList;
    private ArrayList<SerializedJoinInfo> mSerializableSysJoinList;
    private ArrayList<SerializedJoinInfo> mSerializableUserJoinList;
    private HashMap<String, String> mInvalidFieldsMap;
    private String mConnectionString;
    private int mTableCount;
    private static final long serialVersionUID = 1001L;
    private static String mSavedDataSourceName;
    private static String mSavedConnectionString;
    private Vector<TablesInfo.InternalTableInfo> mUserTablesInfo;
    private Vector<TablesInfo.InternalTableInfo> mViewTablesInfo;
    private Vector<TablesInfo.InternalTableInfo> mSystemTablesInfo;
    private Vector<TablesInfo.InternalTableInfo> mSynonymTablesInfo;

    public static DBData getDBData() {
        if (mDBData == null) {
            mDBData = new DBData();
        }
        return mDBData;
    }

    public static String createQualifiedTablename(String string, String string2) {
        if (string != null && string.length() > 0) {
            return string + DBWizardUtil.getOwnerNameSeperator() + string2;
        }
        return string2;
    }

    public void clear() {
        this.mAggregateDataList.clear();
        this.mColumnsInfo.clear();
        this.mQualifiedColumnsInfo.clear();
        this.mDBName = "";
        this.mDefineVarDataList.clear();
        this.mFilteredColumnsInfo.clear();
        this.mFilteredTablesInfo.getTableCols().clear();
        this.mInvalidFieldsMap.clear();
        this.mSynonymsData.clear();
        this.mSystemTablesData.clear();
        this.mTableColumns.clear();
        this.mTablesData.clear();
        this.mTablesInfo.getTableCols().clear();
        this.mUseODBC = false;
        this.mViewsData.clear();
        this.mWizardCapabilities = new ODBCWizardCapabilities();
        this.mSerializableAutoJoinList.clear();
        this.mSerializableSysJoinList.clear();
        this.mSerializableUserJoinList.clear();
        this.mUserTablesInfo.clear();
        this.mViewTablesInfo.clear();
        this.mSystemTablesInfo.clear();
        this.mSynonymTablesInfo.clear();
        RelationshipPageUtils.getAllDropListeners().clear();
    }

    public static void setDBData(DBData dBData) {
        mDBData = dBData;
    }

    public TablesInfo getTablesInfo() {
        return this.mTablesInfo;
    }

    public Vector<TablesInfo.InternalTableInfo> getUserTablesInfo() {
        return this.mUserTablesInfo;
    }

    public Vector<TablesInfo.InternalTableInfo> getViewTablesInfo() {
        return this.mViewTablesInfo;
    }

    public Vector<TablesInfo.InternalTableInfo> getSynonymTablesInfo() {
        return this.mSynonymTablesInfo;
    }

    public Vector<TablesInfo.InternalTableInfo> getSystemTablesInfo() {
        return this.mSystemTablesInfo;
    }

    public void setTablesInfo(TablesInfo tablesInfo) {
        this.mTablesInfo = tablesInfo;
    }

    public TablesInfo getFilteredTablesInfo() {
        return this.mFilteredTablesInfo;
    }

    public void setFilteredTablesInfo(TablesInfo tablesInfo) {
        this.mFilteredTablesInfo.setTableCols(tablesInfo.getTableCols());
    }

    public void setFilteredColumnsInfo(HashMap<String, ColumnsInfo> hashMap) {
        this.mFilteredColumnsInfo.clear();
        for (String string : hashMap.keySet()) {
            this.mFilteredColumnsInfo.put(string, hashMap.get(string));
        }
    }

    public HashMap<String, ColumnsInfo> getColumnsInfo() {
        return this.mColumnsInfo;
    }

    public HashMap<String, ColumnsInfo> getQualifiedColumnsInfo() {
        return this.mQualifiedColumnsInfo;
    }

    public void setColumnsInfo(HashMap<String, ColumnsInfo> hashMap) {
        this.mColumnsInfo = hashMap;
    }

    public void setQualifiedColumnsInfo(HashMap<String, ColumnsInfo> hashMap) {
        this.mQualifiedColumnsInfo = hashMap;
    }

    public HashMap<String, ColumnsInfo> getFilteredColumnsInfo() {
        return this.mFilteredColumnsInfo;
    }

    public LinkedList<AggregateData> getAggregateDataList() {
        return this.mAggregateDataList;
    }

    public void setAggregateList(LinkedList<AggregateData> linkedList) {
        this.mAggregateDataList = linkedList;
    }

    public LinkedList<DefineVarDataOG> getDefineVarDataList() {
        return this.mDefineVarDataList;
    }

    public void setDefineVarDataList(LinkedList<DefineVarDataOG> linkedList) {
        this.mDefineVarDataList = linkedList;
    }

    public Vector<String> getTablesData() {
        return this.mTablesData;
    }

    public Vector<String> getViewsData() {
        return this.mViewsData;
    }

    public Vector<String> getSynonymsData() {
        return this.mSynonymsData;
    }

    public Vector<String> getSystemTablesData() {
        return this.mSystemTablesData;
    }

    public void setTablesData(Vector<String> vector) {
        for (String string : vector) {
            this.mTablesData.add(string);
        }
    }

    public void setViewsData(Vector<String> vector) {
        for (String string : vector) {
            this.mViewsData.add(string);
        }
    }

    public void setSynonymsData(Vector<String> vector) {
        for (String string : vector) {
            this.mSynonymsData.add(string);
        }
    }

    public void setSystemTablesData(Vector<String> vector) {
        for (String string : vector) {
            this.mSystemTablesData.add(string);
        }
    }

    public HashMap<String, String> getInvalidFieldsMap() {
        return this.mInvalidFieldsMap;
    }

    public void setDBName(String string) {
        this.mDBName = string;
    }

    public String getDBName() {
        return this.mDBName;
    }

    public ODBCWizardCapabilities getWizardCapabities() {
        return this.mWizardCapabilities;
    }

    public String getFieldType(String string, String string2) {
        Object object;
        if (string.length() < 1 || string2.length() < 1) {
            return "";
        }
        ColumnsInfo columnsInfo = this.getColumnsInfo().get(string);
        if (columnsInfo == null && (object = this.mWizardCapabilities.getStrQualifierNameSeparator()) != null) {
            String string3;
            int n;
            if (((String)object).length() < 1) {
                object = ".";
            }
            if ((n = string.lastIndexOf((String)object)) > -1 && (string3 = string.substring(n + 1)) != null) {
                columnsInfo = this.getColumnsInfo().get(string3);
            }
        }
        if (columnsInfo != null) {
            for (ColumnsInfo.InternalColumnInfo internalColumnInfo : columnsInfo.getColInfos()) {
                if (!internalColumnInfo.getStrColumnName().equals(string2)) continue;
                return internalColumnInfo.getStrTypeName();
            }
        }
        return "";
    }

    public void setWizardCapabities(ODBCWizardCapabilities oDBCWizardCapabilities) {
        this.mWizardCapabilities = oDBCWizardCapabilities;
    }

    public boolean loadTablesAndColumns(boolean bl) {
        ODBCDacProxy.ProxyReturnCode proxyReturnCode;
        String string;
        SpssFrame spssFrame = SpssFrameMgr.getSpssFrameMgr().getDesignatedWindow(DocType.DE_DOC);
        ODBCDacProxy oDBCDacProxy = ODBCDacProxy.getODBCDacProxy();
        this.mTablesData.clear();
        this.mUserTablesInfo.clear();
        this.mViewsData.clear();
        this.mViewTablesInfo.clear();
        this.mSynonymsData.clear();
        this.mSynonymTablesInfo.clear();
        this.mSystemTablesData.clear();
        this.mSystemTablesInfo.clear();
        this.mTablesInfo.initialize();
        this.mUseODBC = bl;
        ODBCDacProxy.SqlReturnCode sqlReturnCode = new ODBCDacProxy.SqlReturnCode(oDBCDacProxy);
        DialogCallbackImpl dialogCallbackImpl = new DialogCallbackImpl(spssFrame);
        if (bl) {
            string = this.getSavedConnectString(this.mDBName);
            if (string.length() < 1 && this.mConnectionString != null && this.mConnectionString.length() < 1) {
                string = this.mConnectionString;
            }
            oDBCDacProxy.setConnectString(string);
            proxyReturnCode = oDBCDacProxy.connectToDataSource(this.mDBName, (IDialogCallback)dialogCallbackImpl, this.mWizardCapabilities, sqlReturnCode);
        } else {
            proxyReturnCode = ODBCDacProxy.getODBCDacProxy().setOleDbConnectionString(this.getConnectionString(), (IDialogCallback)dialogCallbackImpl, this.mWizardCapabilities, sqlReturnCode);
        }
        DBWizardUtil.setOpenQuoteChar(this.mWizardCapabilities.getStrIdentifierQuoteCharacter());
        DBWizardUtil.setCloseQuoteChar(this.mWizardCapabilities.getStrIdentifierQuoteSuffixCharacter());
        if (sqlReturnCode.getSqlCode() == -1 || sqlReturnCode.getSqlCode() == 100 || proxyReturnCode == ODBCDacProxy.ProxyReturnCode.NETWORK_ERROR || proxyReturnCode == ODBCDacProxy.ProxyReturnCode.UI_CANCELLED) {
            return false;
        }
        if (proxyReturnCode == ODBCDacProxy.ProxyReturnCode.PROXY_OK) {
            int n;
            if (bl) {
                this.mConnectionString = oDBCDacProxy.getConnectString();
            }
            this.mTableColumns.clear();
            string = new ODBCDacProxy.SqlReturnCode(oDBCDacProxy);
            if (!bl) {
                ODBCDacProxy.getODBCDacProxy().setConnectString(this.mConnectionString);
            }
            proxyReturnCode = ODBCDacProxy.getODBCDacProxy().getTables(this.mTablesInfo, (ODBCDacProxy.SqlReturnCode)string, bl);
            if (string.getSqlCode() == -1) {
                return false;
            }
            this.mTablesInfo.sort();
            this.mTableCount = n = this.mTablesInfo.getTableCols().size();
            if (n > 0) {
                ProgressFrame progressFrame = new ProgressFrame(DBWizardUtil.getDialog());
                progressFrame.setVisible(true);
                progressFrame.setAlwaysOnTop(true);
                progressFrame.setLabelText(String.format(DBWizardUtil.getDialog().getResString("IDS_DB_WELCOME_PROGRESS_LABEL"), this.mDBName));
                progressFrame.setProgressValue(0);
                int n2 = 0;
                int n3 = 0;
                for (TablesInfo.InternalTableInfo internalTableInfo : this.mTablesInfo.getTableCols()) {
                    int n4;
                    String string2;
                    ++n3;
                    if (internalTableInfo.isSynonymType()) {
                        string2 = internalTableInfo.getOwner().length() > 0 ? internalTableInfo.getOwner() + DBWizardUtil.getOwnerNameSeperator() + internalTableInfo.getName() : internalTableInfo.getName();
                        this.mSynonymsData.add(string2);
                        this.mSynonymTablesInfo.add(internalTableInfo);
                    } else if (internalTableInfo.isUserType()) {
                        string2 = internalTableInfo.getOwner().length() > 0 ? internalTableInfo.getOwner() + DBWizardUtil.getOwnerNameSeperator() + internalTableInfo.getName() : internalTableInfo.getName();
                        this.mTablesData.add(string2);
                        this.mUserTablesInfo.add(internalTableInfo);
                    } else if (internalTableInfo.isViewType()) {
                        string2 = internalTableInfo.getOwner().length() > 0 ? internalTableInfo.getOwner() + DBWizardUtil.getOwnerNameSeperator() + internalTableInfo.getName() : internalTableInfo.getName();
                        this.mViewsData.add(string2);
                        this.mViewTablesInfo.add(internalTableInfo);
                    } else if (internalTableInfo.isSystemType()) {
                        string2 = internalTableInfo.getOwner().length() > 0 ? internalTableInfo.getOwner() + DBWizardUtil.getOwnerNameSeperator() + internalTableInfo.getName() : internalTableInfo.getName();
                        this.mSystemTablesData.add(string2);
                        this.mSystemTablesInfo.add(internalTableInfo);
                    }
                    if ((n4 = n3 * 100 / n) == n2) continue;
                    n2 = n4;
                    progressFrame.setProgressValue(n2);
                    progressFrame.update(progressFrame.getGraphics());
                }
                progressFrame.dispose();
            }
            return true;
        }
        return false;
    }

    public ColumnsInfo getColumnsInfo(String string) {
        assert (string != null);
        ColumnsInfo columnsInfo = this.mColumnsInfo.get(string);
        if (columnsInfo != null) {
            return columnsInfo;
        }
        TablesInfo.InternalTableInfo internalTableInfo = this.getTableInfo(string);
        ODBCDacProxy.SqlReturnCode sqlReturnCode = new ODBCDacProxy.SqlReturnCode(ODBCDacProxy.getODBCDacProxy());
        columnsInfo = new ColumnsInfo();
        String string2 = internalTableInfo.getName();
        if (!DBData.getDBData().isODBC() && string.indexOf(32) > -1) {
            String string3 = DBWizardUtil.getOpenQuoteChar();
            String string4 = DBWizardUtil.getCloseQuoteChar();
            string2 = string3 + string + string4;
        }
        ODBCDacProxy.getODBCDacProxy().getColumns(string2, internalTableInfo.getOwner(), internalTableInfo.getQualifier(), internalTableInfo.getName(), columnsInfo, sqlReturnCode, DBData.getDBData().isODBC());
        DBData.getDBData().getColumnsInfo().put(string, columnsInfo);
        return columnsInfo;
    }

    public TablesInfo.InternalTableInfo getTableInfo(String string) {
        for (TablesInfo.InternalTableInfo internalTableInfo : this.mTablesInfo.getTableCols()) {
            if (!internalTableInfo.getQualifiedName().equals(string)) continue;
            return internalTableInfo;
        }
        return null;
    }

    public ColumnsInfo.InternalColumnInfo getInternalColumnInfo(String string, String string2) {
        ColumnsInfo columnsInfo = this.getColumnsInfo(string);
        Vector vector = columnsInfo.getColInfos();
        for (ColumnsInfo.InternalColumnInfo internalColumnInfo : vector) {
            if (!internalColumnInfo.getStrColumnName().equals(string2)) continue;
            return internalColumnInfo;
        }
        return null;
    }

    public boolean isODBC() {
        return this.mUseODBC;
    }

    public void setUseODBC(boolean bl) {
        this.mUseODBC = bl;
    }

    public String getConnectionString() {
        return this.mConnectionString;
    }

    public void setConnectionString(String string) {
        this.mConnectionString = string;
    }

    public int getTableCount() {
        return this.mTableCount;
    }

    public void setTableCount(int n) {
        this.mTableCount = n;
    }

    public ArrayList<SerializedJoinInfo> getSerializableAutoJoinList() {
        return this.mSerializableAutoJoinList;
    }

    public void setSerializableAutoJoinList(ArrayList<SerializedJoinInfo> arrayList) {
        this.mSerializableAutoJoinList = arrayList;
    }

    public ArrayList<SerializedJoinInfo> getSerializableSysJoinList() {
        return this.mSerializableSysJoinList;
    }

    public void setSerializableSysJoinList(ArrayList<SerializedJoinInfo> arrayList) {
        this.mSerializableSysJoinList = arrayList;
    }

    public ArrayList<SerializedJoinInfo> getSerializableUserJoinList() {
        return this.mSerializableUserJoinList;
    }

    public void setSerializableUserJoinList(ArrayList<SerializedJoinInfo> arrayList) {
        this.mSerializableUserJoinList = arrayList;
    }

    public void clearJoinInfo() {
        this.mSerializableAutoJoinList.clear();
        this.mSerializableSysJoinList.clear();
        this.mSerializableUserJoinList.clear();
    }

    public HashMap<String, ColumnsInfo.InternalColumnInfo> getSelectedColumnsMap() {
        HashMap<String, ColumnsInfo.InternalColumnInfo> hashMap = new HashMap<String, ColumnsInfo.InternalColumnInfo>();
        HashMap<String, ColumnsInfo> hashMap2 = this.getFilteredColumnsInfo();
        for (String string : hashMap2.keySet()) {
            ColumnsInfo columnsInfo = hashMap2.get(string);
            for (ColumnsInfo.InternalColumnInfo internalColumnInfo : columnsInfo.getColInfos()) {
                hashMap.put(internalColumnInfo.getQualifiedColumnName(), internalColumnInfo);
            }
        }
        return hashMap;
    }

    public void writeData(DataOutputStream dataOutputStream) {
        try {
            Iterator<Map.Entry<String, Object>> iterator;
            dataOutputStream.writeBoolean(this.mUseODBC);
            dataOutputStream.writeUTF(this.mDBName);
            dataOutputStream.writeUTF(this.mConnectionString);
            dataOutputStream.writeInt(this.mTableCount);
            dataOutputStream.writeInt(this.mSystemTablesData.size());
            for (String object22 : this.mSystemTablesData) {
                dataOutputStream.writeUTF(object22);
            }
            dataOutputStream.writeInt(this.mSynonymsData.size());
            for (String string : this.mSynonymsData) {
                dataOutputStream.writeUTF(string);
            }
            dataOutputStream.writeInt(this.mViewsData.size());
            for (String string : this.mViewsData) {
                dataOutputStream.writeUTF(string);
            }
            dataOutputStream.writeInt(this.mTablesData.size());
            for (String string : this.mTablesData) {
                dataOutputStream.writeUTF(string);
            }
            OutDataStream outDataStream = new OutDataStream();
            this.mTablesInfo.writeContent((OutputDataStream)outDataStream);
            byte[] byArray = outDataStream.getStreamAsBytes();
            dataOutputStream.writeInt(byArray.length);
            dataOutputStream.write(byArray);
            dataOutputStream.writeInt(this.mColumnsInfo.size());
            for (Map.Entry<String, ColumnsInfo> entry : this.mColumnsInfo.entrySet()) {
                dataOutputStream.writeUTF(entry.getKey());
                outDataStream = new OutDataStream();
                entry.getValue().writeContent((OutputDataStream)outDataStream);
                byte[] byArray2 = outDataStream.getStreamAsBytes();
                dataOutputStream.writeInt(byArray2.length);
                dataOutputStream.write(byArray2);
            }
            outDataStream = new OutDataStream();
            this.mFilteredTablesInfo.writeContent((OutputDataStream)outDataStream);
            byte[] byArray3 = outDataStream.getStreamAsBytes();
            dataOutputStream.writeInt(byArray3.length);
            dataOutputStream.write(byArray3);
            dataOutputStream.writeInt(this.mFilteredColumnsInfo.size());
            for (Map.Entry<String, ColumnsInfo> entry : this.mFilteredColumnsInfo.entrySet()) {
                dataOutputStream.writeUTF(entry.getKey());
                outDataStream = new OutDataStream();
                entry.getValue().writeContent((OutputDataStream)outDataStream);
                byte[] byArray4 = outDataStream.getStreamAsBytes();
                dataOutputStream.writeInt(byArray4.length);
                dataOutputStream.write(byArray4);
            }
            dataOutputStream.writeInt(this.mAggregateDataList.size());
            for (AggregateData aggregateData : this.mAggregateDataList) {
                dataOutputStream.writeUTF(aggregateData.getName());
                dataOutputStream.writeUTF(aggregateData.getOwnerName());
                dataOutputStream.writeUTF(aggregateData.getQualifierName());
                dataOutputStream.writeUTF(aggregateData.getTableName());
                dataOutputStream.writeUTF(aggregateData.getType());
                dataOutputStream.writeBoolean(aggregateData.isBreakVariable());
            }
            dataOutputStream.writeInt(this.mTableColumns.size());
            for (Map.Entry<String, Object> entry : this.mTableColumns.entrySet()) {
                dataOutputStream.writeUTF(entry.getKey());
                outDataStream = new OutDataStream();
                ((ColumnsInfo)entry.getValue()).writeContent((OutputDataStream)outDataStream);
                byte[] byArray5 = outDataStream.getStreamAsBytes();
                dataOutputStream.writeInt(byArray5.length);
                dataOutputStream.write(byArray5);
            }
            dataOutputStream.writeInt(this.mDefineVarDataList.size());
            for (DefineVarDataOG defineVarDataOG : this.mDefineVarDataList) {
                dataOutputStream.writeUTF(defineVarDataOG.getQualifiedNameInfo());
                dataOutputStream.writeUTF(defineVarDataOG.getResultNameInfo());
                dataOutputStream.writeUTF(defineVarDataOG.getTableName());
                dataOutputStream.writeUTF(defineVarDataOG.getVarTypeInfo());
                dataOutputStream.writeBoolean(defineVarDataOG.getAutoRecodeInfo());
                dataOutputStream.writeBoolean(defineVarDataOG.isBreakVar());
            }
            outDataStream = new OutDataStream();
            this.mWizardCapabilities.writeContent((OutputDataStream)outDataStream);
            byte[] byArray6 = outDataStream.getStreamAsBytes();
            dataOutputStream.writeInt(byArray6.length);
            dataOutputStream.write(byArray6);
            dataOutputStream.writeInt(this.mSerializableAutoJoinList.size());
            for (SerializedJoinInfo serializedJoinInfo : this.mSerializableAutoJoinList) {
                dataOutputStream.writeInt(serializedJoinInfo.getJoinType().ordinal());
                ColumnsInfo.InternalColumnInfo internalColumnInfo = serializedJoinInfo.getSrcColumnInfo();
                this.writeInternalColumnInfo(dataOutputStream, internalColumnInfo);
                iterator = serializedJoinInfo.getSrcTableInfo();
                this.writeInternalTableInfo(dataOutputStream, (TablesInfo.InternalTableInfo)iterator);
                ColumnsInfo.InternalColumnInfo internalColumnInfo2 = serializedJoinInfo.getTargetColumnInfo();
                this.writeInternalColumnInfo(dataOutputStream, internalColumnInfo2);
                iterator = serializedJoinInfo.getTargetTableInfo();
                this.writeInternalTableInfo(dataOutputStream, (TablesInfo.InternalTableInfo)iterator);
            }
            dataOutputStream.writeInt(this.mSerializableSysJoinList.size());
            for (SerializedJoinInfo serializedJoinInfo : this.mSerializableSysJoinList) {
                dataOutputStream.writeInt(serializedJoinInfo.getJoinType().ordinal());
                ColumnsInfo.InternalColumnInfo internalColumnInfo = serializedJoinInfo.getSrcColumnInfo();
                this.writeInternalColumnInfo(dataOutputStream, internalColumnInfo);
                iterator = serializedJoinInfo.getSrcTableInfo();
                this.writeInternalTableInfo(dataOutputStream, (TablesInfo.InternalTableInfo)iterator);
                ColumnsInfo.InternalColumnInfo internalColumnInfo3 = serializedJoinInfo.getTargetColumnInfo();
                this.writeInternalColumnInfo(dataOutputStream, internalColumnInfo3);
                iterator = serializedJoinInfo.getTargetTableInfo();
                this.writeInternalTableInfo(dataOutputStream, (TablesInfo.InternalTableInfo)iterator);
            }
            dataOutputStream.writeInt(this.mSerializableUserJoinList.size());
            for (SerializedJoinInfo serializedJoinInfo : this.mSerializableUserJoinList) {
                dataOutputStream.writeInt(serializedJoinInfo.getJoinType().ordinal());
                ColumnsInfo.InternalColumnInfo internalColumnInfo = serializedJoinInfo.getSrcColumnInfo();
                this.writeInternalColumnInfo(dataOutputStream, internalColumnInfo);
                iterator = serializedJoinInfo.getSrcTableInfo();
                this.writeInternalTableInfo(dataOutputStream, (TablesInfo.InternalTableInfo)iterator);
                ColumnsInfo.InternalColumnInfo internalColumnInfo4 = serializedJoinInfo.getTargetColumnInfo();
                this.writeInternalColumnInfo(dataOutputStream, internalColumnInfo4);
                iterator = serializedJoinInfo.getTargetTableInfo();
                this.writeInternalTableInfo(dataOutputStream, (TablesInfo.InternalTableInfo)iterator);
            }
            dataOutputStream.writeInt(this.mInvalidFieldsMap.size());
            for (Map.Entry entry : this.mInvalidFieldsMap.entrySet()) {
                dataOutputStream.writeUTF((String)entry.getKey());
                dataOutputStream.writeUTF((String)entry.getValue());
            }
            dataOutputStream.writeInt(this.mUserTablesInfo.size());
            for (TablesInfo.InternalTableInfo internalTableInfo : this.mUserTablesInfo) {
                this.writeInternalTableInfo(dataOutputStream, internalTableInfo);
            }
            dataOutputStream.writeInt(this.mViewTablesInfo.size());
            for (TablesInfo.InternalTableInfo internalTableInfo : this.mViewTablesInfo) {
                this.writeInternalTableInfo(dataOutputStream, internalTableInfo);
            }
            dataOutputStream.writeInt(this.mSystemTablesInfo.size());
            for (TablesInfo.InternalTableInfo internalTableInfo : this.mSystemTablesInfo) {
                this.writeInternalTableInfo(dataOutputStream, internalTableInfo);
            }
            dataOutputStream.writeInt(this.mSynonymTablesInfo.size());
            for (TablesInfo.InternalTableInfo internalTableInfo : this.mSynonymTablesInfo) {
                this.writeInternalTableInfo(dataOutputStream, internalTableInfo);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void readData(DataInputStream dataInputStream, int n) throws Exception {
        TablesInfo.InternalTableInfo internalTableInfo;
        ColumnsInfo.InternalColumnInfo internalColumnInfo;
        int n2;
        int n3;
        ColumnsInfo columnsInfo;
        int n4;
        String string;
        int n5;
        int n6;
        this.mUseODBC = dataInputStream.readBoolean();
        this.mDBName = dataInputStream.readUTF();
        this.mConnectionString = dataInputStream.readUTF();
        this.saveDriverLoginInfo(this.mDBName, this.mConnectionString);
        this.mTableCount = dataInputStream.readInt();
        this.mSystemTablesData = new Vector();
        int n7 = dataInputStream.readInt();
        for (n6 = 0; n6 < n7; ++n6) {
            this.mSystemTablesData.add(dataInputStream.readUTF());
        }
        this.mSynonymsData = new Vector();
        n7 = dataInputStream.readInt();
        for (n6 = 0; n6 < n7; ++n6) {
            this.mSynonymsData.add(dataInputStream.readUTF());
        }
        this.mViewsData = new Vector();
        n7 = dataInputStream.readInt();
        for (n6 = 0; n6 < n7; ++n6) {
            this.mViewsData.add(dataInputStream.readUTF());
        }
        this.mTablesData = new Vector();
        n7 = dataInputStream.readInt();
        for (n6 = 0; n6 < n7; ++n6) {
            this.mTablesData.add(dataInputStream.readUTF());
        }
        n7 = dataInputStream.readInt();
        byte[] byArray = new byte[n7];
        int n8 = dataInputStream.read(byArray);
        assert (n8 == n7);
        InDataStream inDataStream = new InDataStream(ByteBuffer.wrap(byArray));
        this.mTablesInfo.readContent((InputDataStream)inDataStream);
        n7 = dataInputStream.readInt();
        for (n5 = 0; n5 < n7; ++n5) {
            string = dataInputStream.readUTF();
            n4 = dataInputStream.readInt();
            byArray = new byte[n4];
            n8 = dataInputStream.read(byArray);
            assert (n8 == n4);
            inDataStream = new InDataStream(ByteBuffer.wrap(byArray));
            columnsInfo = new ColumnsInfo();
            columnsInfo.readContent((InputDataStream)inDataStream);
            this.mColumnsInfo.put(string, columnsInfo);
            if (columnsInfo.getColInfos().size() <= 0) continue;
            String string2 = ((ColumnsInfo.InternalColumnInfo)columnsInfo.getColInfos().get(0)).getStrOwner();
            if (string2 != null && string2.length() > 0) {
                this.mQualifiedColumnsInfo.put(string2 + DBWizardUtil.getOwnerNameSeperator() + string, columnsInfo);
                continue;
            }
            this.mQualifiedColumnsInfo.put(string, columnsInfo);
        }
        n7 = dataInputStream.readInt();
        byArray = new byte[n7];
        n8 = dataInputStream.read(byArray);
        assert (n8 == n7);
        inDataStream = new InDataStream(ByteBuffer.wrap(byArray));
        this.mFilteredTablesInfo.readContent((InputDataStream)inDataStream);
        n7 = dataInputStream.readInt();
        for (n5 = 0; n5 < n7; ++n5) {
            string = dataInputStream.readUTF();
            n4 = dataInputStream.readInt();
            byArray = new byte[n4];
            n8 = dataInputStream.read(byArray);
            assert (n8 == n4);
            inDataStream = new InDataStream(ByteBuffer.wrap(byArray));
            columnsInfo = new ColumnsInfo();
            columnsInfo.readContent((InputDataStream)inDataStream);
            this.mFilteredColumnsInfo.put(string, columnsInfo);
        }
        n7 = dataInputStream.readInt();
        for (n3 = 0; n3 < n7; ++n3) {
            AggregateData aggregateData = new AggregateData();
            aggregateData.setName(dataInputStream.readUTF());
            aggregateData.setOwnerName(dataInputStream.readUTF());
            aggregateData.setQualifierName(dataInputStream.readUTF());
            aggregateData.setTableName(dataInputStream.readUTF());
            aggregateData.setType(dataInputStream.readUTF());
            aggregateData.setBreakVariable(dataInputStream.readBoolean());
            this.mAggregateDataList.add(aggregateData);
        }
        n7 = dataInputStream.readInt();
        for (n3 = 0; n3 < n7; ++n3) {
            string = dataInputStream.readUTF();
            n4 = dataInputStream.readInt();
            byArray = new byte[n4];
            n8 = dataInputStream.read(byArray);
            assert (n8 == n4);
            inDataStream = new InDataStream(ByteBuffer.wrap(byArray));
            columnsInfo = new ColumnsInfo();
            columnsInfo.readContent((InputDataStream)inDataStream);
            this.mTableColumns.put(string, columnsInfo);
        }
        n7 = dataInputStream.readInt();
        for (int i = 0; i < n7; ++i) {
            DefineVarDataOG defineVarDataOG = new DefineVarDataOG();
            defineVarDataOG.setQualifiedNameInfo(dataInputStream.readUTF());
            defineVarDataOG.setResultNameInfo(dataInputStream.readUTF());
            defineVarDataOG.setTableName(dataInputStream.readUTF());
            defineVarDataOG.setVarTypeInfo(dataInputStream.readUTF());
            defineVarDataOG.setAutoRecodeInfo(dataInputStream.readBoolean());
            defineVarDataOG.setBreakVar(dataInputStream.readBoolean());
            this.mDefineVarDataList.add(defineVarDataOG);
        }
        n7 = dataInputStream.readInt();
        byArray = new byte[n7];
        n8 = dataInputStream.read(byArray);
        assert (n8 == n7);
        inDataStream = new InDataStream(ByteBuffer.wrap(byArray));
        this.mWizardCapabilities.readContent((InputDataStream)inDataStream);
        TablesInfo tablesInfo = new TablesInfo();
        ColumnsInfo columnsInfo2 = new ColumnsInfo();
        n7 = dataInputStream.readInt();
        for (n2 = 0; n2 < n7; ++n2) {
            SerializedJoinInfo serializedJoinInfo = new SerializedJoinInfo();
            serializedJoinInfo.setJoinType(JoinType.fromInt(dataInputStream.readInt()));
            internalColumnInfo = new ColumnsInfo.InternalColumnInfo(columnsInfo2);
            this.readInternalColumnInfo(dataInputStream, internalColumnInfo);
            serializedJoinInfo.setSrcColumnInfo(internalColumnInfo);
            internalTableInfo = new TablesInfo.InternalTableInfo(tablesInfo);
            this.readInternalTableInfo(dataInputStream, internalTableInfo);
            serializedJoinInfo.setSrcTableInfo(internalTableInfo);
            internalColumnInfo = new ColumnsInfo.InternalColumnInfo(columnsInfo2);
            this.readInternalColumnInfo(dataInputStream, internalColumnInfo);
            serializedJoinInfo.setTargetColumnInfo(internalColumnInfo);
            internalTableInfo = new TablesInfo.InternalTableInfo(tablesInfo);
            this.readInternalTableInfo(dataInputStream, internalTableInfo);
            serializedJoinInfo.setTargetTableInfo(internalTableInfo);
            this.mSerializableAutoJoinList.add(serializedJoinInfo);
        }
        n7 = dataInputStream.readInt();
        for (n2 = 0; n2 < n7; ++n2) {
            SerializedJoinInfo serializedJoinInfo = new SerializedJoinInfo();
            serializedJoinInfo.setJoinType(JoinType.fromInt(dataInputStream.readInt()));
            internalColumnInfo = new ColumnsInfo.InternalColumnInfo(columnsInfo2);
            this.readInternalColumnInfo(dataInputStream, internalColumnInfo);
            serializedJoinInfo.setSrcColumnInfo(internalColumnInfo);
            internalTableInfo = new TablesInfo.InternalTableInfo(tablesInfo);
            this.readInternalTableInfo(dataInputStream, internalTableInfo);
            serializedJoinInfo.setSrcTableInfo(internalTableInfo);
            internalColumnInfo = new ColumnsInfo.InternalColumnInfo(columnsInfo2);
            this.readInternalColumnInfo(dataInputStream, internalColumnInfo);
            serializedJoinInfo.setTargetColumnInfo(internalColumnInfo);
            internalTableInfo = new TablesInfo.InternalTableInfo(tablesInfo);
            this.readInternalTableInfo(dataInputStream, internalTableInfo);
            serializedJoinInfo.setTargetTableInfo(internalTableInfo);
            this.mSerializableSysJoinList.add(serializedJoinInfo);
        }
        n7 = dataInputStream.readInt();
        for (n2 = 0; n2 < n7; ++n2) {
            SerializedJoinInfo serializedJoinInfo = new SerializedJoinInfo();
            serializedJoinInfo.setJoinType(JoinType.fromInt(dataInputStream.readInt()));
            internalColumnInfo = new ColumnsInfo.InternalColumnInfo(columnsInfo2);
            this.readInternalColumnInfo(dataInputStream, internalColumnInfo);
            serializedJoinInfo.setSrcColumnInfo(internalColumnInfo);
            internalTableInfo = new TablesInfo.InternalTableInfo(tablesInfo);
            this.readInternalTableInfo(dataInputStream, internalTableInfo);
            serializedJoinInfo.setSrcTableInfo(internalTableInfo);
            internalColumnInfo = new ColumnsInfo.InternalColumnInfo(columnsInfo2);
            this.readInternalColumnInfo(dataInputStream, internalColumnInfo);
            serializedJoinInfo.setTargetColumnInfo(internalColumnInfo);
            internalTableInfo = new TablesInfo.InternalTableInfo(tablesInfo);
            this.readInternalTableInfo(dataInputStream, internalTableInfo);
            serializedJoinInfo.setTargetTableInfo(internalTableInfo);
            this.mSerializableUserJoinList.add(serializedJoinInfo);
        }
        n7 = dataInputStream.readInt();
        for (n2 = 0; n2 < n7; ++n2) {
            this.mInvalidFieldsMap.put(dataInputStream.readUTF(), dataInputStream.readUTF());
        }
        n7 = dataInputStream.readInt();
        for (n2 = 0; n2 < n7; ++n2) {
            internalTableInfo = new TablesInfo.InternalTableInfo(tablesInfo);
            this.readInternalTableInfo(dataInputStream, internalTableInfo);
            this.mUserTablesInfo.add(internalTableInfo);
        }
        n7 = dataInputStream.readInt();
        for (n2 = 0; n2 < n7; ++n2) {
            internalTableInfo = new TablesInfo.InternalTableInfo(tablesInfo);
            this.readInternalTableInfo(dataInputStream, internalTableInfo);
            this.mViewTablesInfo.add(internalTableInfo);
        }
        n7 = dataInputStream.readInt();
        for (n2 = 0; n2 < n7; ++n2) {
            internalTableInfo = new TablesInfo.InternalTableInfo(tablesInfo);
            this.readInternalTableInfo(dataInputStream, internalTableInfo);
            this.mSystemTablesInfo.add(internalTableInfo);
        }
        n7 = dataInputStream.readInt();
        for (n2 = 0; n2 < n7; ++n2) {
            internalTableInfo = new TablesInfo.InternalTableInfo(tablesInfo);
            this.readInternalTableInfo(dataInputStream, internalTableInfo);
            this.mSynonymTablesInfo.add(internalTableInfo);
        }
    }

    public void saveDriverLoginInfo(String string, String string2) {
        if (string != null && string2 != null) {
            mSavedDataSourceName = string;
            mSavedConnectionString = string2;
        }
    }

    public String getSavedConnectString(String string) {
        if (string != null && string.length() > 0 && string.equals(mSavedDataSourceName)) {
            return mSavedConnectionString;
        }
        return "";
    }

    public String getSavedDataSourceName() {
        return mSavedDataSourceName;
    }

    private DBData() {
        this.initVars();
    }

    private void initVars() {
        this.mSystemTablesData = new Vector();
        this.mSynonymsData = new Vector();
        this.mTablesData = new Vector();
        this.mViewsData = new Vector();
        this.mTablesInfo = new TablesInfo();
        this.mWizardCapabilities = new ODBCWizardCapabilities();
        this.mColumnsInfo = new HashMap();
        this.mQualifiedColumnsInfo = new HashMap();
        this.mFilteredTablesInfo = new TablesInfo();
        this.mFilteredColumnsInfo = new HashMap();
        this.mInvalidFieldsMap = new HashMap();
        this.mTableColumns = new HashMap();
        this.mAggregateDataList = new LinkedList();
        this.mDefineVarDataList = new LinkedList();
        this.mSerializableAutoJoinList = new ArrayList();
        this.mSerializableUserJoinList = new ArrayList();
        this.mSerializableSysJoinList = new ArrayList();
        this.mUserTablesInfo = new Vector();
        this.mViewTablesInfo = new Vector();
        this.mSynonymTablesInfo = new Vector();
        this.mSystemTablesInfo = new Vector();
    }

    private void writeInternalTableInfo(DataOutputStream dataOutputStream, TablesInfo.InternalTableInfo internalTableInfo) throws IOException {
        dataOutputStream.writeUTF(internalTableInfo.getDescription());
        dataOutputStream.writeUTF(internalTableInfo.getName());
        dataOutputStream.writeUTF(internalTableInfo.getOwner());
        dataOutputStream.writeUTF(internalTableInfo.getQualifier());
        dataOutputStream.writeUTF(internalTableInfo.getType());
    }

    private void writeInternalColumnInfo(DataOutputStream dataOutputStream, ColumnsInfo.InternalColumnInfo internalColumnInfo) throws IOException {
        dataOutputStream.writeUTF(internalColumnInfo.getStrColumnName());
        dataOutputStream.writeUTF(internalColumnInfo.getStrOwner());
        dataOutputStream.writeUTF(internalColumnInfo.getStrQualifier());
        dataOutputStream.writeUTF(internalColumnInfo.getStrRemarks());
        dataOutputStream.writeUTF(internalColumnInfo.getStrTableName());
        dataOutputStream.writeUTF(internalColumnInfo.getStrTypeName());
        dataOutputStream.writeInt(internalColumnInfo.getCBDataType());
        dataOutputStream.writeInt(internalColumnInfo.getCBLength());
        dataOutputStream.writeInt(internalColumnInfo.getCBNullable());
        dataOutputStream.writeInt(internalColumnInfo.getCBPrecision());
        dataOutputStream.writeInt(internalColumnInfo.getCBRadix());
        dataOutputStream.writeInt(internalColumnInfo.getCBScale());
        dataOutputStream.writeInt(internalColumnInfo.getILength());
        dataOutputStream.writeInt(internalColumnInfo.getIPrecision());
        dataOutputStream.writeShort(internalColumnInfo.getIDataType());
        dataOutputStream.writeShort(internalColumnInfo.getINullable());
        dataOutputStream.writeShort(internalColumnInfo.getIRadix());
        dataOutputStream.writeShort(internalColumnInfo.getIScale());
    }

    private void readInternalColumnInfo(DataInputStream dataInputStream, ColumnsInfo.InternalColumnInfo internalColumnInfo) throws IOException {
        internalColumnInfo.setStrColumnName(dataInputStream.readUTF());
        internalColumnInfo.setStrOwner(dataInputStream.readUTF());
        internalColumnInfo.setStrQualifier(dataInputStream.readUTF());
        internalColumnInfo.setStrRemarks(dataInputStream.readUTF());
        internalColumnInfo.setStrTableName(dataInputStream.readUTF());
        internalColumnInfo.setStrTypeName(dataInputStream.readUTF());
        internalColumnInfo.setCBDataType(dataInputStream.readInt());
        internalColumnInfo.setCBLength(dataInputStream.readInt());
        internalColumnInfo.setCBNullable(dataInputStream.readInt());
        internalColumnInfo.setCBPrecision(dataInputStream.readInt());
        internalColumnInfo.setCBRadix(dataInputStream.readInt());
        internalColumnInfo.setCBScale(dataInputStream.readInt());
        internalColumnInfo.setILength(dataInputStream.readInt());
        internalColumnInfo.setIPrecision(dataInputStream.readInt());
        internalColumnInfo.setIDataType(dataInputStream.readShort());
        internalColumnInfo.setINullable(dataInputStream.readShort());
        internalColumnInfo.setIRadix(dataInputStream.readShort());
        internalColumnInfo.setIScale(dataInputStream.readShort());
    }

    private void readInternalTableInfo(DataInputStream dataInputStream, TablesInfo.InternalTableInfo internalTableInfo) throws IOException {
        internalTableInfo.setDescription(dataInputStream.readUTF());
        internalTableInfo.setName(dataInputStream.readUTF());
        internalTableInfo.setOwner(dataInputStream.readUTF());
        internalTableInfo.setQualifier(dataInputStream.readUTF());
        internalTableInfo.setType(dataInputStream.readUTF());
    }

    static {
        mSavedDataSourceName = "";
        mSavedConnectionString = "";
    }
}

