/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.file.open_dimensions_data;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.ui.dialogs.base.file.open_dimensions_data.OpenDimensionsDataDlg;
import com.spss.java_client.ui.dialogs.base.file.open_dimensions_data.SelectVariablesColumn;
import com.spss.java_client.ui.dialogs.base.file.open_dimensions_data.SelectVariablesTableModel;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.BaseProcedureTab;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.uitools.dialogs.BaseDialog;
import com.spss.uitools.winutils.DimensionsDataModelInterface;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;

public class SelectVariablesTab
extends BaseProcedureTab {
    private Object[][] mVarData;
    private JTable mVariablesTable;
    private JScrollPane mVariablesTableScrollPane;
    private boolean[] mSelectedVars;
    private Vector<Integer> mSelectedVarIndexes;
    private SelectVariablesTableModel mTableModel;
    private JButton mSelectAllButton;
    private JButton mDeselectAllButton;
    private JCheckBox mSystemVarsCheck;
    private JCheckBox mCodesCheck;
    private JCheckBox mSourceFileCheck;
    private static SelectVariablesColumn[] fSelectVariablesColumns = null;

    public SelectVariablesTab(BaseDialog baseDialog, boolean bl) {
        super(baseDialog, bl);
        fSelectVariablesColumns = new SelectVariablesColumn[]{new SelectVariablesColumn(0, true), new SelectVariablesColumn(1, true), new SelectVariablesColumn(2, true)};
        this.reset();
    }

    @Override
    public String getDialogHelpID() {
        return "idh_dimensions_data_select_variables";
    }

    @Override
    public void reset() {
        super.reset();
        this.setDefaults();
    }

    @Override
    protected void saveTabState(DialogDataModel dialogDataModel) {
        super.saveTabState(dialogDataModel);
    }

    @Override
    protected void loadTabState(DialogDataModel dialogDataModel, BaseProcedureDialog.NameLabelOption nameLabelOption) {
        super.loadTabState(dialogDataModel, nameLabelOption);
    }

    @Override
    protected void initPanel() {
        super.initPanel();
        this.setupPanel();
        this.setFocusTraversalPolicy();
    }

    public void generateSelectAllSyntax(StringBuffer stringBuffer) {
        stringBuffer.append("SELECT * FROM VDATA ");
    }

    protected void generateSyntax(StringBuffer stringBuffer) {
        stringBuffer.append("SELECT ");
        int n = 0;
        for (int i = 0; i < this.mTableModel.getRowCount(); ++i) {
            if (!((Boolean)this.mTableModel.getValueAt(i, 0)).booleanValue()) continue;
            if (n > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append((String)this.mTableModel.getValueAt(i, 1));
            if (stringBuffer.length() > Short.MAX_VALUE) {
                return;
            }
            ++n;
        }
        stringBuffer.append(" FROM VDATA ");
    }

    private void setDefaults() {
        this.mSystemVarsCheck.setSelected(false);
        this.mCodesCheck.setSelected(false);
        this.mSourceFileCheck.setSelected(false);
    }

    private void setupPanel() {
        this.mVariablesTable = new JTable(){

            @Override
            public void setValueAt(Object object, int n, int n2) {
                if (n2 == 0) {
                    ((SelectVariablesTab)SelectVariablesTab.this).mSelectedVars[((VarTableItem)((SelectVariablesTab)SelectVariablesTab.this).mTableModel.getValue((int)n)).getImportIndex()] = (Boolean)object;
                    SelectVariablesTab.this.mTableModel.setValueAt(object, n, n2);
                }
            }
        };
        this.mVariablesTable.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                SelectVariablesTab.this.mVariablesTable.clearSelection();
            }

            @Override
            public void focusGained(FocusEvent focusEvent) {
                SelectVariablesTab.this.mVariablesTable.selectAll();
            }
        });
        SelectVariablesTableModel.COLUMN_NAMES[0] = this.getResString("IDS_OPEN_DIMENSIONS_DATA_SELECT_VARS_TAB_TABLE_HEADING_COL0");
        SelectVariablesTableModel.COLUMN_NAMES[1] = this.getResString("IDS_OPEN_DIMENSIONS_DATA_SELECT_VARS_TAB_TABLE_HEADING_COL1");
        SelectVariablesTableModel.COLUMN_NAMES[2] = this.getResString("IDS_OPEN_DIMENSIONS_DATA_SELECT_VARS_TAB_TABLE_HEADING_COL2");
        this.mVariablesTable.setRowSelectionAllowed(false);
        this.mVariablesTable.setCellSelectionEnabled(true);
        this.mVariablesTable.setAutoResizeMode(3);
        JTableHeader jTableHeader = this.mVariablesTable.getTableHeader();
        jTableHeader.setDefaultRenderer(new SelectVariablesTableHeaderRenderer());
        jTableHeader.setReorderingAllowed(false);
        jTableHeader.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() > 1) {
                    return;
                }
                int n = SelectVariablesTab.this.mVariablesTable.getTableHeader().columnAtPoint(mouseEvent.getPoint());
                if (n != -1 && fSelectVariablesColumns[n].isSortable()) {
                    this.sortColumn(n, (SelectVariablesTableModel)SelectVariablesTab.this.mVariablesTable.getModel());
                }
            }

            void sortColumn(int n, SelectVariablesTableModel selectVariablesTableModel) {
                Vector vector = selectVariablesTableModel.getData();
                switch (fSelectVariablesColumns[n].getSortSequence()) {
                    case ASCENDING: {
                        Collections.sort(vector, new VarNameTableSorter(n, SelectVariablesColumn.SORT_ORDER.DESCENDING));
                        fSelectVariablesColumns[n].setSortSequence(SelectVariablesColumn.SORT_ORDER.DESCENDING);
                        break;
                    }
                    case DESCENDING: {
                        Collections.sort(vector, new VarOrigOrderTableSorter());
                        fSelectVariablesColumns[n].setSortSequence(SelectVariablesColumn.SORT_ORDER.FILE_ORDER);
                        break;
                    }
                    default: {
                        Collections.sort(vector, new VarNameTableSorter(n, SelectVariablesColumn.SORT_ORDER.ASCENDING));
                        fSelectVariablesColumns[n].setSortSequence(SelectVariablesColumn.SORT_ORDER.ASCENDING);
                    }
                }
                ((SelectVariablesTableHeaderRenderer)SelectVariablesTab.this.mVariablesTable.getTableHeader().getDefaultRenderer()).setSortedColumn(n);
                selectVariablesTableModel.fireTableDataChanged();
                SelectVariablesTab.this.mVariablesTable.getTableHeader().repaint();
            }
        });
        this.mVariablesTableScrollPane = new JScrollPane(this.mVariablesTable, 20, 31);
        this.mVariablesTableScrollPane.setBorder(BorderFactory.createLineBorder(Color.gray));
        Dimension dimension = this.mVariablesTableScrollPane.getSize();
        dimension.height = 300;
        dimension.width = 450;
        this.mVariablesTableScrollPane.setPreferredSize(dimension);
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_OPEN_DIMENSIONS_DATA_SELECT_VARS_TAB_SELECT_ALL_BUTTON"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                for (int i = 0; i < SelectVariablesTab.this.mSelectedVars.length; ++i) {
                    ((SelectVariablesTab)SelectVariablesTab.this).mSelectedVars[i] = true;
                }
                SelectVariablesTab.this.updateTable();
            }
        };
        this.mSelectAllButton = new JButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this.mParent, "IDS_OPEN_DIMENSIONS_DATA_SELECT_VARS_TAB_DESELECT_ALL_BUTTON"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                for (int i = 0; i < SelectVariablesTab.this.mSelectedVars.length; ++i) {
                    ((SelectVariablesTab)SelectVariablesTab.this).mSelectedVars[i] = false;
                }
                SelectVariablesTab.this.updateTable();
            }
        };
        this.mDeselectAllButton = new JButton(toggleButtonAction);
        this.mSystemVarsCheck = new JCheckBox(this.createToggleButtonAction("IDS_OPEN_DIMENSIONS_DATA_SELECT_VARS_TAB_SYSTEM_VARS_CHECK"));
        this.mSystemVarsCheck.setMnemonic(this.getDlgAccessKey("IDK_OPEN_DIMENSIONS_DATA_SELECT_VARS_TAB_SYSTEM_VARS_CHECK_KEY"));
        this.mCodesCheck = new JCheckBox(this.createToggleButtonAction("IDS_OPEN_DIMENSIONS_DATA_SELECT_VARS_TAB_CASE_VARS_CHECK"));
        this.mCodesCheck.setMnemonic(this.getDlgAccessKey("IDK_OPEN_DIMENSIONS_DATA_SELECT_VARS_TAB_CASE_VARS_CHECK_KEY"));
        this.mSourceFileCheck = new JCheckBox(this.createToggleButtonAction("IDS_OPEN_DIMENSIONS_DATA_SELECT_VARS_TAB_SOURCEFILE_VARS_CHECK"));
        this.mSourceFileCheck.setMnemonic(this.getDlgAccessKey("IDK_OPEN_DIMENSIONS_DATA_SELECT_VARS_TAB_SOURCEFILE_VARS_CHECK_KEY"));
        this.setLayout(new GridBagLayout());
        Insets insets = (Insets)DialogUtil.getStandardControlInsets().clone();
        insets.left = 10;
        Insets insets2 = (Insets)DialogUtil.getStandardDialogInsets().clone();
        insets2.top = DialogUtil.getComponentGroupGap();
        insets2.bottom = 0;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel(new GridBagLayout(), true);
        int n = 24;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mSelectAllButton, gridBagConstraints, 0, 0, 1, 1, n, new Insets(insets.top, insets.left + 40, insets.bottom, insets.right));
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mDeselectAllButton, gridBagConstraints, 0, 1, 1, 1, n, new Insets(insets.top, insets.left + 40, insets.bottom, insets.right));
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        n = 23;
        DialogUtil.addUsingGBL(jPanel, this.mSystemVarsCheck, gridBagConstraints, 1, 0, 1, 1, n, new Insets(insets.top, insets.left + 10, insets.bottom, insets.right));
        DialogUtil.addUsingGBL(jPanel, this.mCodesCheck, gridBagConstraints, 1, 1, 1, 1, n, new Insets(insets.top, insets.left + 10, insets.bottom, insets.right));
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mSourceFileCheck, gridBagConstraints, 1, 2, 1, 1, n, new Insets(insets.top, insets.left + 10, insets.bottom, insets.right));
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        n = 24;
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(this, this.mVariablesTableScrollPane, gridBagConstraints, 0, 0, 1, 1, n, insets);
        n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(this, jPanel, gridBagConstraints, 0, 1, 1, 1, n, insets2);
    }

    private ToggleButtonAction createToggleButtonAction(String string) {
        return new ToggleButtonAction(this.mParent, string){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object = actionEvent.getSource();
                if (object instanceof JCheckBox && (object == SelectVariablesTab.this.mSystemVarsCheck || object == SelectVariablesTab.this.mCodesCheck || object == SelectVariablesTab.this.mSourceFileCheck)) {
                    SelectVariablesTab.this.updateTable();
                }
            }
        };
    }

    private void setFocusTraversalPolicy() {
        this.mComponentOrder.add(this.mVariablesTable);
        this.mComponentOrder.add(this.mSelectAllButton);
        this.mComponentOrder.add(this.mDeselectAllButton);
        this.mComponentOrder.add(this.mSystemVarsCheck);
        this.mComponentOrder.add(this.mCodesCheck);
        this.mComponentOrder.add(this.mSourceFileCheck);
    }

    @Override
    protected boolean validateTab() {
        boolean bl = super.validateTab();
        boolean bl2 = false;
        for (int i = 0; i < this.mTableModel.getRowCount(); ++i) {
            if (!((Boolean)this.mTableModel.getValueAt(i, 0)).booleanValue()) continue;
            bl2 = true;
            break;
        }
        if (!bl2) {
            SpssAlertOptionPane.showWarningMessageDialog(this, this.getResString("ERR_OPEN_DIMENSIONS_DATA_SELECT_VARS_TAB_NO_VARS_SELECTED_MESSAGE"), VersionInfo.getAppVersionString());
            bl = false;
        }
        return bl;
    }

    private SelectVariablesTableModel getTableModel() {
        if (this.mVarData == null) {
            return null;
        }
        Vector<VarTableItem> vector = new Vector<VarTableItem>();
        if (this.mSelectedVarIndexes == null) {
            this.mSelectedVarIndexes = new Vector();
        } else {
            this.mSelectedVarIndexes.clear();
        }
        for (int i = 0; i < this.mVarData[0].length; ++i) {
            DimensionsDataModelInterface.UsageTypeConstants usageTypeConstants;
            Boolean bl = (Boolean)this.mVarData[3][i];
            if (!this.mSystemVarsCheck.isSelected() && bl.booleanValue() || (usageTypeConstants = (DimensionsDataModelInterface.UsageTypeConstants)this.mVarData[2][i]) == null || !(this.mSystemVarsCheck.isSelected() && bl != false || usageTypeConstants != DimensionsDataModelInterface.UsageTypeConstants.vtCoding && usageTypeConstants != DimensionsDataModelInterface.UsageTypeConstants.vtSourceFile && usageTypeConstants != DimensionsDataModelInterface.UsageTypeConstants.vtOtherSpecify || this.mCodesCheck.isSelected() && usageTypeConstants == DimensionsDataModelInterface.UsageTypeConstants.vtCoding) && (!this.mSourceFileCheck.isSelected() || usageTypeConstants != DimensionsDataModelInterface.UsageTypeConstants.vtSourceFile)) continue;
            VarTableItem varTableItem = new VarTableItem(this.mSelectedVars[i], (String)this.mVarData[0][i], (DimensionsDataModelInterface.DataTypeConstants)this.mVarData[1][i], i);
            vector.addElement(varTableItem);
        }
        Collections.sort(vector, new VarOrigOrderTableSorter());
        return new SelectVariablesTableModel(vector, this.mVariablesTable);
    }

    protected void initTable() {
        this.mVarData = ((OpenDimensionsDataDlg)this.mParent).getFullVarList();
        if (this.mVarData != null && this.mVarData[0].length > 0) {
            this.mSelectedVars = new boolean[this.mVarData[0].length];
            for (int i = 0; i < this.mSelectedVars.length; ++i) {
                this.mSelectedVars[i] = true;
            }
            this.updateTable();
        }
    }

    protected void updateTable() {
        this.mTableModel = this.getTableModel();
        this.mVariablesTable.setModel(this.mTableModel);
        this.mVariablesTable.getColumnModel().getColumn(0).setPreferredWidth(15);
        this.mVariablesTable.getColumnModel().getColumn(1).setPreferredWidth(160);
        this.mVariablesTable.getColumnModel().getColumn(2).setPreferredWidth(45);
        this.mVariablesTable.getColumnModel().getColumn(1).setCellRenderer(new TextCellsRenderer());
        this.mVariablesTable.getColumnModel().getColumn(2).setCellRenderer(new TextCellsRenderer());
        this.mVariablesTable.validate();
        this.mVariablesTable.repaint();
    }

    protected JCheckBox getSystemVarsCheckBox() {
        return this.mSystemVarsCheck;
    }

    protected JCheckBox getCodesCheckBox() {
        return this.mCodesCheck;
    }

    protected JCheckBox getSourceFileCheckBox() {
        return this.mSourceFileCheck;
    }

    private class SelectVariablesTableHeaderRenderer
    implements TableCellRenderer {
        private JPanel mRenderer = new JPanel(new BorderLayout(0, 0));
        private JLabel mTextRenderer = new JLabel();
        private int fSortedColumnNumber = -1;

        public SelectVariablesTableHeaderRenderer() {
            this.mRenderer.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            this.mTextRenderer.setHorizontalTextPosition(10);
            this.mTextRenderer.setHorizontalAlignment(0);
            this.mRenderer.add((Component)this.mTextRenderer, "Center");
        }

        public void setSortedColumn(int n) {
            this.fSortedColumnNumber = n;
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (jTable != null) {
                if (this.fSortedColumnNumber == n2) {
                    if (fSelectVariablesColumns[n2].getSortSequence() == SelectVariablesColumn.SORT_ORDER.ASCENDING) {
                        this.mTextRenderer.setIcon(new ImageIcon(ResUtil.getImageResource("sortasc.gif")));
                    } else if (fSelectVariablesColumns[n2].getSortSequence() == SelectVariablesColumn.SORT_ORDER.DESCENDING) {
                        this.mTextRenderer.setIcon(new ImageIcon(ResUtil.getImageResource("sortdesc.gif")));
                    } else {
                        this.mTextRenderer.setIcon(null);
                    }
                } else {
                    this.mTextRenderer.setIcon(null);
                }
            }
            this.mTextRenderer.setText(object.toString());
            return this.mRenderer;
        }
    }

    public class VarNameTableSorter
    implements Comparator {
        SelectVariablesColumn.SORT_ORDER fSortOrder;
        int colNumber = -1;

        VarNameTableSorter(int n, SelectVariablesColumn.SORT_ORDER sORT_ORDER) {
            this.fSortOrder = sORT_ORDER;
            this.colNumber = n;
        }

        public int compare(Object object, Object object2) {
            String string;
            String string2;
            VarTableItem varTableItem = (VarTableItem)object;
            VarTableItem varTableItem2 = (VarTableItem)object2;
            if (this.colNumber == 0) {
                string2 = Boolean.toString(varTableItem.getImport());
                string = Boolean.toString(varTableItem2.getImport());
            } else if (this.colNumber == 1) {
                string2 = varTableItem.getName();
                string = varTableItem2.getName();
            } else if (this.colNumber == 2) {
                string2 = varTableItem.getType().getName();
                string = varTableItem2.getType().getName();
            } else {
                string2 = varTableItem.getName();
                string = varTableItem2.getName();
            }
            if (string2 instanceof String && string2.length() == 0) {
                string2 = null;
            }
            if (string instanceof String && string.length() == 0) {
                string = null;
            }
            if (string2 == null && string == null) {
                return 0;
            }
            if (string2 == null) {
                return 1;
            }
            if (string == null) {
                return -1;
            }
            if (this.fSortOrder == SelectVariablesColumn.SORT_ORDER.ASCENDING) {
                return string2.toString().compareToIgnoreCase(string.toString());
            }
            return string.toString().compareToIgnoreCase(string2.toString());
        }
    }

    public class VarOrigOrderTableSorter
    implements Comparator {
        VarOrigOrderTableSorter() {
        }

        public int compare(Object object, Object object2) {
            int n;
            VarTableItem varTableItem = (VarTableItem)object;
            VarTableItem varTableItem2 = (VarTableItem)object2;
            int n2 = varTableItem.getImportIndex();
            if (n2 < (n = varTableItem2.getImportIndex())) {
                return -1;
            }
            if (n2 == n) {
                return 0;
            }
            return 1;
        }
    }

    class TextCellsRenderer
    extends JLabel
    implements TableCellRenderer {
        TextCellsRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (n2 == 1) {
                URL uRL = SelectVariablesTab.class.getResource(((DimensionsDataModelInterface.DataTypeConstants)SelectVariablesTab.this.mTableModel.getValueAt(n, 2)).getIcon());
                if (uRL != null) {
                    this.setIcon(new ImageIcon(uRL));
                    this.setIconTextGap(6);
                }
                this.setText((String)object);
            } else if (n2 == 2) {
                this.setText(((DimensionsDataModelInterface.DataTypeConstants)SelectVariablesTab.this.mTableModel.getValueAt(n, n2)).getName());
            }
            return this;
        }
    }

    public class VarTableItem {
        boolean mImport;
        String mName = "";
        DimensionsDataModelInterface.DataTypeConstants mType;
        int mImportIndex;

        public VarTableItem(boolean bl, String string, DimensionsDataModelInterface.DataTypeConstants dataTypeConstants, int n) {
            this.mImport = bl;
            this.mName = string;
            this.mType = dataTypeConstants;
            this.mImportIndex = n;
        }

        public boolean getImport() {
            return this.mImport;
        }

        public void setImport(boolean bl) {
            this.mImport = bl;
        }

        public String getName() {
            return this.mName;
        }

        public void setName(String string) {
            this.mName = string;
        }

        public DimensionsDataModelInterface.DataTypeConstants getType() {
            return this.mType;
        }

        public void setType(DimensionsDataModelInterface.DataTypeConstants dataTypeConstants) {
            this.mType = dataTypeConstants;
        }

        public int getImportIndex() {
            return this.mImportIndex;
        }

        public void setImportIndex(int n) {
            this.mImportIndex = n;
        }
    }
}

