/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.file.open_dimensions_data;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.DataDocument;
import com.spss.java_client.ui.dialogs.base.file.open_dimensions_data.CaseSelectionTab;
import com.spss.java_client.ui.dialogs.base.file.open_dimensions_data.SelectVariablesTab;
import com.spss.java_client.ui.dialogs.base.file.res.FileResBundle;
import com.spss.java_client.ui.dialogs.common.BaseTabbedDialog;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.uitools.util.CharacterUtil;
import java.awt.Window;
import javax.swing.JFrame;
import javax.swing.event.ChangeEvent;

public class OpenDimensionsDataDlg
extends BaseTabbedDialog {
    public static final int SELECT_STMT_MAX_LEN = Short.MAX_VALUE;
    private String mConnectionString;
    private Object[][] mFullDimensionsVarList;
    private SelectVariablesTab mSelectVariablesTab;
    private CaseSelectionTab mCaseSelectionTab;
    Boolean mHasSystemVars;
    Boolean mHasCodeVars;
    Boolean mHasSourceFileVars;
    private boolean mDoSelectAll = false;
    private static String mHelpId = "idh_dimensions_data_connection";

    public OpenDimensionsDataDlg(JFrame jFrame, String string, Object[][] objectArray, boolean bl, boolean bl2, boolean bl3) {
        super(jFrame, false, FileResBundle.getDefaultResourceBundleName(), FileResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_OPEN_DIMENSIONS_DATA_TITLE"));
        this.mConnectionString = string.replaceAll("\r", "").replaceAll("\n", "");
        this.mFullDimensionsVarList = objectArray;
        this.mHasSystemVars = bl;
        this.mHasCodeVars = bl2;
        this.mHasSourceFileVars = bl3;
        this.pack();
        this.getSelectVarsTab().initTable();
        this.setVisible(true);
        this.setLocationRelativeTo(jFrame);
        this.mCaseSelectionTab.setEnabled(this.mHasSystemVars);
        this.mSelectVariablesTab.getSystemVarsCheckBox().setEnabled(true);
        this.mSelectVariablesTab.getCodesCheckBox().setEnabled(true);
        this.mSelectVariablesTab.getSourceFileCheckBox().setEnabled(true);
    }

    @Override
    protected boolean canBeRecalled() {
        return false;
    }

    @Override
    public String getIActionKey() {
        return "file_open_dimensions_data";
    }

    @Override
    public String getDialogHelpID() {
        return mHelpId;
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        super.stateChanged(changeEvent);
    }

    @Override
    public void reset() {
        super.reset();
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    @Override
    protected void init() {
        super.init();
        this.mSelectVariablesTab = new SelectVariablesTab(this, true);
        this.mCaseSelectionTab = new CaseSelectionTab(this, true);
        this.addTab(this.getResString("IDS_OPEN_DIMENSIONS_DATA_SELECT_VARS_TAB_TITLE"), this.mSelectVariablesTab);
        this.addTab(this.getResString("IDS_OPEN_DIMENSIONS_DATA_CASE_TAB_TITLE"), this.mCaseSelectionTab);
        this.mTabbedPane.addChangeListener(this);
        super.enableOkPaste(true);
    }

    @Override
    public String generateSyntax() {
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        StringBuffer stringBuffer2 = new StringBuffer();
        if (this.mDoSelectAll) {
            this.getSelectVarsTab().generateSelectAllSyntax(stringBuffer2);
            this.mDoSelectAll = false;
        } else {
            this.getSelectVarsTab().generateSyntax(stringBuffer2);
        }
        this.getCaseSelectionTab().generateSyntax(stringBuffer2);
        stringBuffer.append("GET DATA /TYPE=OLEDB ");
        stringBuffer.append("\n   /CONNECT=");
        stringBuffer.append(CharacterUtil.smartQuote((String)this.mConnectionString, (boolean)true));
        stringBuffer.append("\n   /SQL=");
        stringBuffer.append(CharacterUtil.smartQuote((String)stringBuffer2.toString(), (boolean)true));
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        stringBuffer.append("CACHE");
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        stringBuffer.append("DATASET NAME ");
        stringBuffer.append(DataDocument.getNextFreeDatasetName());
        stringBuffer.append(" WINDOW=FRONT");
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        return stringBuffer.toString();
    }

    @Override
    public boolean okPastePressed() {
        boolean bl = true;
        StringBuffer stringBuffer = new StringBuffer();
        this.getSelectVarsTab().generateSyntax(stringBuffer);
        if (stringBuffer.length() > Short.MAX_VALUE) {
            if (0 == SpssAlertOptionPane.showConfirmDialog((Window)((Object)this), this.getResString("ERR_OPEN_DIMENSIONS_DATA_SELECT_TOO_LONG_MESSAGE"), VersionInfo.getAppVersionString(), SpssAlertOptionPane.OptionType.OK_CANCEL_OPTION)) {
                this.mDoSelectAll = true;
                bl = true;
            } else {
                bl = false;
            }
        }
        return bl;
    }

    public Object[][] getFullVarList() {
        return this.mFullDimensionsVarList;
    }

    public boolean getHasSystemVars() {
        return this.mHasSystemVars;
    }

    public SelectVariablesTab getSelectVarsTab() {
        return this.mSelectVariablesTab;
    }

    public CaseSelectionTab getCaseSelectionTab() {
        return this.mCaseSelectionTab;
    }
}

