/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.file.export_to_db.welcome;

import com.spss.java_client.core.common.prefs.PrefsMgr;
import com.spss.java_client.core.documents.data.data_access.ODBC.ODBCDacProxy;
import com.spss.java_client.core.error_handler.ErrorDispatcher;
import com.spss.java_client.core.error_handler.ErrorEventMsg;
import com.spss.java_client.core.error_handler.IErrorHandler;
import com.spss.java_client.core.server.DataServerProxy;
import com.spss.java_client.core.server.messages.DataAccess.DataSourceInfo;
import com.spss.java_client.ui.dialogs.base.file.export_to_db.AbstractExportToDBPage;
import com.spss.java_client.ui.dialogs.base.file.export_to_db.ExportToDBData;
import com.spss.java_client.ui.dialogs.base.file.export_to_db.ExportToDBDlg;
import com.spss.java_client.ui.dialogs.base.file.export_to_db.utilities.DBListCellRenderer;
import com.spss.java_client.ui.dialogs.base.file.export_to_db.utilities.DBListEntry;
import com.spss.java_client.ui.dialogs.base.file.export_to_db.utilities.ExportToDBUtil;
import com.spss.java_client.ui.dialogs.base.file.openquery.DBData;
import com.spss.java_client.ui.dialogs.common.BaseWizardDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.winutils.LaunchOLEDB;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class WelcomePage
extends AbstractExportToDBPage
implements WindowListener,
ListSelectionListener,
MouseListener,
FocusListener,
KeyListener,
IErrorHandler {
    private JButton mDataSourceButton;
    private int mDSNSourceCount;
    private JList mList;
    private DialogFocusTraversalPolicy mPolicy;
    private JScrollPane mScrollPane;
    private boolean mInWindowActivated = false;
    private boolean mHandledODBCFailure = false;
    private LaunchOLEDB mOledbDialog = null;

    public WelcomePage(BaseWizardDialog baseWizardDialog) {
        super("WelcomePage", baseWizardDialog, true);
        if (OSInfo.getOSType().equals((Object)OSInfo.OSType.LINUX)) {
            ErrorDispatcher.getErrorDispatcher().addListener((IErrorHandler)this);
        }
    }

    @Override
    public String getDialogHelpID() {
        return "idh_idd_exdb_page_welcome";
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        Border border = BorderFactory.createLineBorder(Color.BLUE, 1);
        if (focusEvent.getSource().equals(this.mList)) {
            this.mScrollPane.setBorder(border);
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        LineBorder lineBorder = new LineBorder(Color.GRAY);
        if (focusEvent.getSource().equals(this.mList)) {
            this.mScrollPane.setBorder(lineBorder);
        }
    }

    @Override
    public String getNextPage() {
        ExportToDBUtil.setDialog(this.mWizardDialog);
        if (this.setTableData()) {
            if (ExportToDBData.getExDBData().getTableCount() == 0) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this.mWizardDialog), this.mWizardDialog.getResString("ERR_EX2DB_WELCOME_NO_TABLES_PRESENT"), this.mWizardDialog.getResString("IDS_EX2DB_RESULTS_OPTION_PANE_TITLE"));
                return "WelcomePage";
            }
            return "HowToExportDataPage";
        }
        return "WelcomePage";
    }

    @Override
    public boolean hasNextPage() {
        return true;
    }

    @Override
    public void init() {
        ExportToDBUtil.setDialog(this.mWizardDialog);
        this.mWizardDialog.addWindowListener(this);
        super.init();
    }

    @Override
    public boolean isLastPage() {
        return false;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 2) {
            this.mWizardDialog.showWizardPage(this.mWizardDialog.getWizardModel().getCurrentPage(), this.mWizardDialog.getWizardModel().getNextPage());
        }
        if (this.mList.getModel().getSize() == 0) {
            this.mList.clearSelection();
            this.mWizardDialog.enableNext(false);
        } else {
            this.mWizardDialog.enableNext(this.mList.getSelectedIndex() > -1);
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
        this.mInWindowActivated = true;
        if (this.mWizardDialog.getWizardModel().getCurrentPage() == this) {
            this.updateDSNlist();
        }
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    public void handleError(ErrorEventMsg errorEventMsg) {
        if (OSInfo.getOSType().equals((Object)OSInfo.OSType.LINUX) && (errorEventMsg.getErrorCode() == -14 || errorEventMsg.getErrorCode() == -12)) {
            if (this.mInWindowActivated && !this.mHandledODBCFailure) {
                this.mHandledODBCFailure = true;
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this.mWizardDialog), this.mWizardDialog.getResString("ERR_DB_WELCOME_NO_ODBC_PRESENT"), this.mWizardDialog.getResString("IDS_DB_RESULTS_OPTION_PANE_TITLE"));
                this.mWizardDialog.dispose();
            }
            errorEventMsg.setErrorHandled(true);
            errorEventMsg.setUserNotified(true);
        }
    }

    @Override
    protected void aboutToHidePanel() {
        ExportToDBUtil.setExToDBWizardPreviousPage(ExportToDBUtil.ExToDBWizardPreviousPage.eWelcome);
    }

    @Override
    protected void aboutToShowPanel() {
        super.aboutToShowPanel();
        this.mWizardDialog.enableFinish(false);
        this.mWizardDialog.enableBack(false);
        this.mWizardDialog.setDefaultButton(BaseWizardDialog.WizardButton.eNext);
        this.mWizardDialog.setFocusTraversalPolicy(this.mPolicy);
        this.updateDSNlist();
        if (this.mList.getModel().getSize() < 1 && !this.mDataSourceButton.isEnabled()) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this.mWizardDialog), this.mWizardDialog.getResString("ERR_DB_WELCOME_NO_ODBC_PRESENT"), this.mWizardDialog.getResString("IDS_DB_RESULTS_OPTION_PANE_TITLE"));
            this.mWizardDialog.dispose();
        }
    }

    protected void updateDSNlist() {
        ((DefaultListModel)this.mList.getModel()).clear();
        this.doPopulateDSNList();
        this.mList.requestFocus();
        this.mWizardDialog.enableNext(this.mList.getModel().getSize() > 0);
        if (this.mList.getModel().getSize() > 0) {
            int n = this.getIndexToSelect();
            this.mList.setSelectedIndex(n);
            if (n > 0) {
                Rectangle rectangle = this.mList.getCellBounds(n - 1, n + 2);
                if (rectangle != null) {
                    this.mList.scrollRectToVisible(rectangle);
                } else {
                    this.mList.ensureIndexIsVisible(n);
                }
            }
        }
    }

    @Override
    protected void initVars() {
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mWizardDialog, "IDS_EX2DB_ADD_DATA_SOURCE_BUTTON"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (OSInfo.getOSType().equals((Object)OSInfo.OSType.WIN)) {
                    if (!OSInfo.isWindowsXP()) {
                        WelcomePage.this.setOleDbToNativeClass();
                        ConnectionHandler connectionHandler = new ConnectionHandler(OleDbLaunchType.admin);
                        connectionHandler.start();
                    } else {
                        Runtime runtime = Runtime.getRuntime();
                        try {
                            runtime.exec(System.getenv("windir") + WelcomePage.this.mWizardDialog.getResString("IDS_EX2DB_ODBC_EXE_PATH"));
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                } else if (OSInfo.getOSType().equals((Object)OSInfo.OSType.MAC)) {
                    try {
                        String[] stringArray;
                        String string = "/Applications/Utilities/ODBC Administrator.app";
                        File file = new File(string);
                        if (!file.exists() && (string = (stringArray = PrefsMgr.getPrefsMgr().getUIUserPrefs().node("options").node("data")).get("mac_odbc_app", null)) == null) {
                            File file2;
                            JFileChooser jFileChooser = new JFileChooser();
                            jFileChooser.setDialogTitle(WelcomePage.this.mWizardDialog.getResString("IDS_DB_WELCOME_MAC_ODBC_PROMPT"));
                            File file3 = new File("/Applications/Utilities");
                            jFileChooser.setCurrentDirectory(file3);
                            int n = jFileChooser.showOpenDialog(this.mMainDialog.getRootPane());
                            if (n == 0 && (string = (file2 = jFileChooser.getSelectedFile()).getCanonicalPath()) != null & string.length() > 0) {
                                stringArray.put("mac_odbc_app", string);
                            }
                        }
                        if (string != null) {
                            stringArray = new String[]{"open", string};
                            Runtime.getRuntime().exec(stringArray);
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        };
        this.mDataSourceButton = new JButton(toggleButtonAction);
        this.mList = new JList();
        this.mList.setModel(new DefaultListModel());
        this.mList.addListSelectionListener(this);
        this.mList.setSelectionMode(0);
        this.mList.setSelectedIndex(0);
        this.mList.requestFocus();
        this.mList.addMouseListener(this);
        this.mList.addKeyListener(this);
        this.mList.addFocusListener(this);
        this.mList.setBorder(new EmptyBorder(1, 1, 1, 1));
        this.mList.setMinimumSize(new Dimension(150, 300));
    }

    @Override
    protected boolean isTopHorizontalBarPresent() {
        return false;
    }

    @Override
    protected void setTabTraversalOrder() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mList);
        vector.add(this.mDataSourceButton);
        Vector<Object> vector2 = ((ExportToDBDlg)this.mWizardDialog).getTabTraversal(vector);
        this.mPolicy = new DialogFocusTraversalPolicy(vector2, false);
    }

    @Override
    protected JPanel setupPageBody() {
        JPanel jPanel = new JPanel(true);
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n = DialogUtil.getComponentGroupGap();
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = new Insets(n, n, n, insets.right);
        int n2 = 23;
        DialogUtil.addUsingGBL(jPanel, this.setupListPanel(), gridBagConstraints, 1, 0, 2, 1, n2, insets2);
        ImageIcon imageIcon = new ImageIcon(this.mWizardDialog.getResImageURL("IDS_EX2DB_WEL_WELCOME_IMG"));
        JLabel jLabel = new JLabel();
        jLabel.setIcon(imageIcon);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        n2 = 10;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n2, insets2);
        return jPanel;
    }

    @Override
    protected JPanel setupPageHeader() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n2 = 4;
        Insets insets = new Insets(n2, n2, 0, n2);
        JLabel jLabel = new JLabel(this.mWizardDialog.getResString("IDS_EX2DB_WELCOME_PAGE_HEADING"));
        jLabel.setFont(jLabel.getFont().deriveFont(1, 18.0f));
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 2, 1, n, insets);
        ImageIcon imageIcon = new ImageIcon();
        JLabel jLabel2 = new JLabel();
        jLabel2.setIcon(imageIcon);
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 1, 0, 1, 1, n, insets);
        JTextArea jTextArea = new JTextArea(this.mWizardDialog.getResString("IDS_EX2DB_WELCOME_PAGE_NOTE"));
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setBorder(null);
        jTextArea.setOpaque(false);
        jTextArea.setFocusable(false);
        jTextArea.setMinimumSize(new Dimension(400, 52));
        jTextArea.setPreferredSize(new Dimension(400, 52));
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, jTextArea, gridBagConstraints, 0, 1, 2, 1, n, insets);
        return jPanel;
    }

    private int getIndexToSelect() {
        int n = 0;
        String string = DBData.getDBData().getSavedDataSourceName();
        if (string != null && string.length() > 0) {
            for (int i = 0; i < this.mList.getModel().getSize(); ++i) {
                DBListEntry dBListEntry = (DBListEntry)this.mList.getModel().getElementAt(i);
                if (!dBListEntry.getText().equals(string)) continue;
                n = i;
                break;
            }
        }
        return n;
    }

    private void doPopulateDSNList() {
        Vector vector = new Vector();
        ODBCDacProxy oDBCDacProxy = ODBCDacProxy.getODBCDacProxy();
        ODBCDacProxy.SqlReturnCode sqlReturnCode = new ODBCDacProxy.SqlReturnCode(oDBCDacProxy);
        ODBCDacProxy.getODBCDacProxy().getDataSources(vector, sqlReturnCode);
        this.mDSNSourceCount = vector.size();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (DataSourceInfo dataSourceInfo : vector) {
            if (dataSourceInfo.getIsNativePevDriver() || dataSourceInfo.getDesc().endsWith("(*.txt; *.csv)") || dataSourceInfo.getDesc().startsWith("SPSS") && dataSourceInfo.getDesc().endsWith("TextFile (*.*)")) continue;
            arrayList.add(dataSourceInfo.getName());
        }
        Collections.sort(arrayList, new ListComparator());
        DBListEntry[] dBListEntryArray = new DBListEntry[this.mDSNSourceCount];
        int n = 0;
        for (String string : arrayList) {
            dBListEntryArray[n] = new DBListEntry(string, this.mWizardDialog.getResImageURL("IDS_DB_WEL_WELCOME_DB_IMG"));
            ((DefaultListModel)this.mList.getModel()).addElement(dBListEntryArray[n]);
            ++n;
        }
        this.mList.setCellRenderer(new DBListCellRenderer());
    }

    private boolean setTableData() {
        ExportToDBData.getExDBData().clear();
        ODBCDacProxy oDBCDacProxy = ODBCDacProxy.getODBCDacProxy();
        String string = "";
        string = ((DBListEntry)this.mList.getSelectedValue()).getText();
        ExportToDBData.getExDBData().setDSNName(string);
        boolean bl = ExportToDBData.getExDBData().loadTables();
        String string2 = ExportToDBData.getExDBData().getConnectionString();
        if (string2 != null && string2.contains("DBQ")) {
            String[] stringArray = string2.split(";");
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].contains("DBQ")) continue;
                String[] stringArray2 = stringArray[i].split("=");
                ExportToDBData.getExDBData().setDSNName(stringArray2[1]);
            }
        } else {
            ExportToDBData.getExDBData().setDSNName(string);
        }
        if (!bl) {
            this.mList.requestFocus();
        } else {
            DBData.getDBData().saveDriverLoginInfo(string, oDBCDacProxy.getConnectString());
        }
        return bl;
    }

    private JPanel setupListPanel() {
        JPanel jPanel = new JPanel(true);
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = DialogUtil.getStandardControlInsets();
        this.mScrollPane = new JScrollPane(this.mList);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        Insets insets2 = new Insets(insets.left, n2, insets.left, n2);
        jPanel.setBorder(new EtchedBorder());
        DialogUtil.addUsingGBL(jPanel, this.mScrollPane, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        this.mScrollPane.setPreferredSize(this.mList.getMinimumSize());
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        JLabel jLabel = DialogUtil.createLabel(this.mWizardDialog, "IDS_EX2DB_WELCOME_PAGE_DSN_LIST_LABEL");
        jLabel.setLabelFor(this.mList);
        Insets insets3 = new Insets(n2, n2, 0, insets.right);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets3);
        if (OSInfo.getOSType().equals((Object)OSInfo.OSType.WIN) || OSInfo.getOSType().equals((Object)OSInfo.OSType.MAC)) {
            if (!DataServerProxy.getDataProxy().isRemoteConnection()) {
                gridBagConstraints.fill = 0;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 0.0;
                n = 23;
                insets3 = new Insets(insets.left, n2, n2, insets.right);
                DialogUtil.addUsingGBL(jPanel, this.mDataSourceButton, gridBagConstraints, 0, 2, 1, 1, n, insets3);
            } else {
                insets3 = new Insets(insets.top, n2, 0, insets.right);
                DialogUtil.addUsingGBL(jPanel, new JPanel(), gridBagConstraints, 0, 2, 1, 1, n, insets3);
                this.mDataSourceButton.setEnabled(false);
                this.mDataSourceButton.setVisible(false);
            }
        } else if (OSInfo.getOSType().equals((Object)OSInfo.OSType.LINUX)) {
            this.mDataSourceButton.setEnabled(false);
            this.mDataSourceButton.setVisible(false);
        }
        return jPanel;
    }

    private void setOleDbToNativeClass() {
        if (this.mOledbDialog == null) {
            this.mOledbDialog = new LaunchOLEDB();
        }
    }

    private void adminLaunchComplete(boolean bl) {
        if (!bl) {
            this.showOdbcAdminMessage();
        }
    }

    protected void showOdbcAdminMessage() {
        SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this.mWizardDialog), this.mWizardDialog.getResString("ERR_DB_ODBC_ADMIN_LAUNCH"), this.mWizardDialog.getResString("IDS_DB_WEL_TITLE"));
    }

    class ConnectionHandler
    extends Thread {
        private OleDbLaunchType mLaunchType;

        ConnectionHandler(OleDbLaunchType oleDbLaunchType) {
            this.mLaunchType = oleDbLaunchType;
        }

        @Override
        public void run() {
            if (this.mLaunchType == OleDbLaunchType.admin) {
                try {
                    final boolean bl = WelcomePage.this.mOledbDialog.launchOdbcAdministrator();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            WelcomePage.this.adminLaunchComplete(bl);
                        }
                    });
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    static enum OleDbLaunchType {
        admin,
        load,
        save;

    }

    private class ListComparator<T>
    implements Comparator {
        private ListComparator() {
        }

        public int compare(Object object, Object object2) {
            if (object instanceof String && object2 instanceof String) {
                String string = (String)object;
                String string2 = (String)object2;
                return string.compareToIgnoreCase(string2);
            }
            return -1;
        }
    }
}

