/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.file.export_to_db.utilities;

import com.spss.java_client.ui.dialogs.base.file.export_to_db.utilities.ExportToDBSyntaxUtil;
import java.util.LinkedList;

public class InsertSQLSpec {
    protected String sourceTableName;
    protected String targetTableName;
    protected String dsnName;
    protected LinkedList<String> sourceColumnList = new LinkedList();
    protected LinkedList<String> targetColumnList = new LinkedList();

    public InsertSQLSpec(String string, String string2, LinkedList<String> linkedList, LinkedList<String> linkedList2) {
        this.sourceTableName = string;
        this.targetTableName = string2;
        this.sourceColumnList = linkedList;
        this.targetColumnList = linkedList2;
    }

    public LinkedList<String> getKeepList() {
        return this.sourceColumnList;
    }

    public String getInsertSQL(String string) {
        this.dsnName = string.toUpperCase();
        if (this.dsnName.contains("GREENPLUM") || this.dsnName.contains("POSTGRESQL")) {
            this.sourceTableName = "\"" + this.sourceTableName + "\"";
        }
        LinkedList<String> linkedList = this.quoteList(this.sourceColumnList);
        LinkedList<String> linkedList2 = this.quoteList(this.targetColumnList);
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("INSERT INTO ");
        stringBuffer.append(this.targetTableName);
        stringBuffer.append(" (");
        stringBuffer.append(ExportToDBSyntaxUtil.makeSeparatedList(linkedList2, ", "));
        stringBuffer.append(") SELECT ");
        stringBuffer.append(ExportToDBSyntaxUtil.makeSeparatedList(linkedList, ", "));
        stringBuffer.append(" FROM ");
        stringBuffer.append(this.sourceTableName);
        return stringBuffer.toString();
    }

    public String getSourceTableName() {
        return this.sourceTableName;
    }

    public String getTargetTableName() {
        return this.targetTableName;
    }

    protected LinkedList<String> quoteList(LinkedList<String> linkedList) {
        LinkedList<String> linkedList2 = new LinkedList<String>();
        for (String string : linkedList) {
            string = ExportToDBSyntaxUtil.checkForQuotes(string, true, true);
            linkedList2.add(string);
        }
        return linkedList2;
    }
}

