/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.file.export_to_db.utilities;

import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.comp_util.OSCheck;
import com.spss.java_client.core.documents.DocType;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.case_filter.UseCaseFilter;
import com.spss.java_client.core.documents.data.dictionary.FormatType;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.SPSS_Format;
import com.spss.java_client.core.documents.data.dictionary.SpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.value_labels.IValueLabelMap;
import com.spss.java_client.ui.SpssFrameMgr;
import com.spss.java_client.ui.dialogs.base.file.export_to_db.ExportToDBData;
import com.spss.java_client.ui.dialogs.base.file.export_to_db.match_cases_to_records.JConnector;
import com.spss.java_client.ui.dialogs.base.file.export_to_db.match_cases_to_records.MatchCasesToRecordsPage;
import com.spss.java_client.ui.dialogs.base.file.res.FileResBundle;
import com.spss.java_client.ui.dialogs.common.BaseWizardDialog;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.res.CommonDlgResBundle;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.doc_types.data.DataFrame;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class ExportToDBUtil {
    private static String sActionString;
    private static ArrayList<JConnector> sAllConnectors;
    private static String sCasesToExportString;
    private static int sCount;
    private static String sDefaultType;
    private static String sDefaultWidth;
    private static boolean sFinishEnabled;
    private static boolean sExistingFieldCheck;
    private static boolean sIsReset;
    private static ArrayList<MatchCasesToRecordsPage.JoinInfo> sJoinInfoList;
    private static JPanel sJoinPanel;
    private static String sNewTableName;
    private static String sValidTableName;
    private static JPanel sPanel;
    private static ExToDBWizardPreviousPage sPreviousPage;
    private static String sQuoteChar;
    private static ExportToDBOptions sSelectedOption;
    private static String sUserMissingValuesString;
    private static BaseWizardDialog sWizardDialog;
    private static String sFisrtAvailableType;
    private static Vector<String> sDataTypes;
    private static HashMap<String, Boolean> sTableOwnerMap;
    private static boolean sBulkLoadingChecked;
    private static int sBatchSize;
    private static boolean sBatchCommitSelected;
    private static boolean sRowWiseBindingSelected;
    private static final int DEFAULT_NONSTR_VALLAB_WIDTH = 17;

    public static String getActionString() {
        return sActionString;
    }

    public static JConnector getActiveConnector(JPanel jPanel) {
        ExportToDBUtil.getAllConnectors(jPanel);
        for (int i = 0; i < sAllConnectors.size(); ++i) {
            if (!sAllConnectors.get(i).isSelected()) continue;
            return sAllConnectors.get(i);
        }
        return null;
    }

    public static JComponent getComponentAt(int n) {
        Component[] componentArray = sPanel.getComponents();
        return (JComponent)componentArray[n];
    }

    public static ArrayList<JConnector> getAllConnectors(JPanel jPanel) {
        sAllConnectors = new ArrayList();
        int n = jPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component component = jPanel.getComponent(i);
            if (!(component instanceof JConnector)) continue;
            sAllConnectors.add((JConnector)component);
        }
        return sAllConnectors;
    }

    public static String getCasesToExportString() {
        return sCasesToExportString;
    }

    public static int getClassifiedDataType(int n) {
        if (n == 1 || n == 12 || n == -96 || n == -9 || n == -8) {
            return 1;
        }
        if (n == -1 || n == -97) {
            return -1;
        }
        if (n == 9 || n == 10 || n == 11) {
            return 9;
        }
        return n;
    }

    public static int getCount() {
        return sCount;
    }

    public static String getDataSetName() {
        ISpssDataSrc iSpssDataSrc = null;
        SpssFrame spssFrame = SpssFrameMgr.getSpssFrameMgr().getDesignatedWindow(DocType.DE_DOC);
        if (spssFrame instanceof DataFrame) {
            LocallyUniqueId locallyUniqueId = ((DataFrame)spssFrame).getDatasetId();
            iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        }
        String string = "";
        if (iSpssDataSrc != null) {
            string = iSpssDataSrc.getFileSpec();
            string = string + " [" + iSpssDataSrc.getDatasetName() + "]";
        }
        String string2 = System.getProperty("file.separator");
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        while (stringTokenizer.hasMoreElements()) {
            string = ((String)stringTokenizer.nextElement()).trim();
        }
        return string;
    }

    public static void getDefaultDataType(ISpssVariable iSpssVariable) {
        ExportToDBUtil.getDefaultDataType(iSpssVariable, false);
    }

    public static void getDefaultDataType(ISpssVariable iSpssVariable, boolean bl) {
        ExportToDBData exportToDBData = ExportToDBData.getExDBData();
        LinkedHashMap<ISpssVariable, SPSS_Format> linkedHashMap = exportToDBData.getSpssVarPropsMap();
        LinkedHashMap<String, String> linkedHashMap2 = exportToDBData.getSQLNameWidthMap();
        SPSS_Format sPSS_Format = linkedHashMap.get(iSpssVariable);
        if (bl) {
            sPSS_Format = new SPSS_Format(FormatType.A, (short)(sPSS_Format.getWidth() + sPSS_Format.getDecimals()), sPSS_Format.getDecimals());
        }
        switch (sPSS_Format.getFormatType()) {
            case A: {
                if (exportToDBData.isDatabase("GREENPLUM")) {
                    sDefaultType = "character varying";
                    sDefaultWidth = linkedHashMap2.get(sDefaultType);
                    break;
                }
            }
            case AHEX: {
                if (exportToDBData.isDatabase("Access") && iSpssVariable.getType() > 255) {
                    sDefaultType = "memo";
                    break;
                }
                ExportToDBUtil.findStringType();
                break;
            }
            case F: {
                if (exportToDBData.isDatabase("Netezza") && sPSS_Format.getWidth() > 14) {
                    ExportToDBUtil.findNumericType();
                    break;
                }
            }
            case COMMA: 
            case DOT: 
            case PERCENT: 
            case E: 
            case CCA: 
            case CCB: 
            case CCC: 
            case CCD: 
            case CCE: {
                ExportToDBUtil.findDoubleType();
                break;
            }
            case DOLLAR: {
                if (OSCheck.getOSType() == OSInfo.OSType.MAC) {
                    ExportToDBUtil.findDoubleType();
                    break;
                }
                if (ExportToDBUtil.findDataType("currency") || ExportToDBUtil.findDataType("money")) break;
                ExportToDBUtil.findDoubleType();
                break;
            }
            case ADATE: 
            case DATE: 
            case EDATE: 
            case JDATE: 
            case SDATE: 
            case MOYR: 
            case QYR: 
            case WKYR: {
                if (ExportToDBUtil.findDataType("date") || ExportToDBUtil.findSQLType(9) || ExportToDBUtil.findDataType("datetime") || ExportToDBUtil.findSQLType(10) || ExportToDBUtil.findDataType("timestamp")) break;
                ExportToDBUtil.findSQLType(11);
                break;
            }
            case MONTH: 
            case WKDAY: {
                if (ExportToDBUtil.findDataType("integer") || ExportToDBUtil.findSQLType(4) || ExportToDBUtil.findDataType("int") || ExportToDBUtil.findSQLType(-5)) break;
                ExportToDBUtil.findDoubleType();
                break;
            }
            case DATETIME: 
            case YMDHMS: {
                if (ExportToDBUtil.findDataType("datetime") && (sPSS_Format.getWidth() <= Integer.valueOf(sDefaultWidth) || exportToDBData.isDatabase("MySQL")) || ExportToDBUtil.findSQLType(10) && sPSS_Format.getWidth() <= Integer.valueOf(sDefaultWidth) || ExportToDBUtil.findDataType("timestamp") && sPSS_Format.getWidth() <= Integer.valueOf(sDefaultWidth)) break;
                ExportToDBUtil.findSQLType(11);
                break;
            }
            case DTIME: 
            case TIME: {
                if (ExportToDBUtil.findDataType("time") && ExportToDBUtil.findSQLType(10) || exportToDBData.isDatabase("Informix") && ExportToDBUtil.findSQLType(10) || exportToDBData.isDatabase("HDB") && ExportToDBUtil.findDataType("time")) break;
                ExportToDBUtil.findDoubleType();
                break;
            }
        }
        if (sDefaultType.equals("") || sDefaultWidth != null && sDefaultWidth.equals("")) {
            sDefaultType = sFisrtAvailableType;
            sDefaultWidth = linkedHashMap2.get(sDefaultType);
        }
    }

    public static String getDefaultType() {
        return sDefaultType;
    }

    public static String getDefaultWidth() {
        return sDefaultWidth;
    }

    public static BaseWizardDialog getDialog() {
        return sWizardDialog;
    }

    public static ExportToDBOptions getExToDBSelectedOption() {
        return sSelectedOption;
    }

    public static ExToDBWizardPreviousPage getExToDBWizardPreviousPage() {
        return sPreviousPage;
    }

    public static ImageIcon getHeaderImage(BaseWizardDialog baseWizardDialog) {
        URL uRL = null;
        ExportToDBOptions exportToDBOptions = ExportToDBUtil.getExToDBSelectedOption();
        if (exportToDBOptions == ExportToDBOptions.eReplaceValExisitngFields) {
            uRL = baseWizardDialog.getResImageURL("IDS_EX2DB_EXPORT_OPTION_1_SMALL_IMG");
        } else if (exportToDBOptions == ExportToDBOptions.eAddFieldsToExistingTable) {
            uRL = baseWizardDialog.getResImageURL("IDS_EX2DB_EXPORT_OPTION_2_SMALL_IMG");
        } else if (exportToDBOptions == ExportToDBOptions.eAppendNewRecordToExistingTable) {
            uRL = baseWizardDialog.getResImageURL("IDS_EX2DB_EXPORT_OPTION_3_SMALL_IMG");
        } else if (exportToDBOptions == ExportToDBOptions.eDropAndCreateNewTable) {
            uRL = baseWizardDialog.getResImageURL("IDS_EX2DB_EXPORT_OPTION_4_SMALL_IMG");
        } else if (exportToDBOptions == ExportToDBOptions.eCreateNewTable) {
            uRL = baseWizardDialog.getResImageURL("IDS_EX2DB_EXPORT_OPTION_5_SMALL_IMG");
        }
        return new ImageIcon(uRL);
    }

    public static int getIdxOfActiveCon(JPanel jPanel) {
        ExportToDBUtil.getAllConnectors(jPanel);
        int n = -1;
        for (int i = 0; i < sAllConnectors.size(); ++i) {
            if (!sAllConnectors.get(i).isSelected()) continue;
            n = i;
        }
        return n;
    }

    public static ArrayList<MatchCasesToRecordsPage.JoinInfo> getJoinInfoList() {
        return sJoinInfoList;
    }

    public static JPanel getJoinPanel() {
        return sJoinPanel;
    }

    public static String getNewTableName() {
        return sNewTableName;
    }

    public static String getQuoteChar() {
        if (sQuoteChar != null && sQuoteChar.length() > 0) {
            return sQuoteChar;
        }
        return "\"";
    }

    public static String getStrDataType(int n) {
        ResourceBundle resourceBundle = ResUtil.getBundle(FileResBundle.getDefaultResourceBundleName(), ResUtil.getLocale());
        if (n == 1 || n == -1) {
            return ResUtil.getString(resourceBundle, "IDS_DB_COMMON_STRING");
        }
        if (n == 9) {
            return ResUtil.getString(resourceBundle, "IDS_DB_COMMON_DATE");
        }
        return ResUtil.getString(resourceBundle, "IDS_DB_COMMON_NUMERIC");
    }

    public static Vector getSupportedDataTypes() {
        String string = ExportToDBData.getExDBData().getWizardCapabities().getStrDataTypeNames();
        String string2 = ExportToDBData.getExDBData().getWizardCapabities().getStrDataSQLtypes();
        if (!string.equals("")) {
            sDataTypes.clear();
            String[] stringArray = string.split(";");
            String[] stringArray2 = string2.split(";");
            for (int i = 0; i < stringArray.length; ++i) {
                if (ExportToDBData.getExDBData().isDatabase("ORACLE")) {
                    if (stringArray2[i].equals("8") || sDataTypes.indexOf(stringArray[i].toLowerCase()) >= 0) continue;
                    sDataTypes.add(stringArray[i].toLowerCase());
                    continue;
                }
                if (ExportToDBData.getExDBData().isDatabase("SQL Server") && stringArray[i].equalsIgnoreCase("time") && !stringArray2[i].equals((short)10) || sDataTypes.indexOf(stringArray[i].toLowerCase()) >= 0) continue;
                sDataTypes.add(stringArray[i].toLowerCase());
            }
            if (ExportToDBData.getExDBData().isDatabase("Access")) {
                sDataTypes.add("memo");
            }
            Collections.sort(sDataTypes, new ListComparator());
        }
        return sDataTypes;
    }

    public static String getUserMissingValuesString() {
        return sUserMissingValuesString;
    }

    public static String getWidth(ISpssVariable iSpssVariable) {
        return ExportToDBUtil.getWidth(iSpssVariable, true);
    }

    public static String getWidth(ISpssVariable iSpssVariable, boolean bl) {
        ExportToDBData exportToDBData = ExportToDBData.getExDBData();
        SPSS_Format sPSS_Format = exportToDBData.getSpssVarPropsMap().get(iSpssVariable);
        if (sPSS_Format != null) {
            if (bl) {
                int n = 0;
                int n2 = 0;
                int n3 = 0;
                switch (sPSS_Format.getFormatType()) {
                    case A: 
                    case AHEX: {
                        n2 = sPSS_Format.getWidth();
                        break;
                    }
                    default: {
                        n = 17;
                        n2 = sPSS_Format.getWidth() + sPSS_Format.getDecimals() + 1 + 1;
                    }
                }
                n3 = Math.max(n, n2);
                try {
                    IValueLabelMap iValueLabelMap = iSpssVariable.getValueLabels();
                    for (Map.Entry entry : iValueLabelMap.getValueLabelEntries()) {
                        if (n3 >= ((String)entry.getValue()).getBytes("UTF-8").length) continue;
                        n3 = ((String)entry.getValue()).getBytes("UTF-8").length;
                    }
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    unsupportedEncodingException.printStackTrace();
                    n3 = 254;
                }
                return String.valueOf(n3);
            }
            return String.valueOf(sPSS_Format.getWidth());
        }
        return "";
    }

    public static String getValidTableName() {
        return sValidTableName;
    }

    public static boolean getBulkLoadingChecked() {
        return sBulkLoadingChecked;
    }

    public static int getBatchSize() {
        return sBatchSize;
    }

    public static boolean getBatchCommitSelected() {
        return sBatchCommitSelected;
    }

    public static boolean getRowWiseBindingSelected() {
        return sRowWiseBindingSelected;
    }

    public static HashMap<String, Boolean> getTableOwnerMap() {
        return sTableOwnerMap;
    }

    public static void setTableOwnerMap(HashMap<String, Boolean> hashMap) {
        sTableOwnerMap = hashMap;
    }

    public static void setValidTableName(String string) {
        sValidTableName = string;
    }

    public static boolean isFilterOn() {
        ISpssDataSrc iSpssDataSrc = null;
        boolean bl = false;
        SpssFrame spssFrame = SpssFrameMgr.getSpssFrameMgr().getDesignatedWindow(DocType.DE_DOC);
        if (spssFrame instanceof DataFrame) {
            LocallyUniqueId locallyUniqueId = ((DataFrame)spssFrame).getDatasetId();
            iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        }
        if (iSpssDataSrc != null) {
            if (iSpssDataSrc.getCaseFilter() != null || iSpssDataSrc.getFilterVarIndex() != -1) {
                bl = true;
            } else {
                UseCaseFilter useCaseFilter = ((SpssDataSrc)iSpssDataSrc).getUseCaseFilter();
                if (useCaseFilter != null) {
                    bl = useCaseFilter.getUseOn();
                }
            }
        }
        return bl;
    }

    public static boolean isFinishEnabled() {
        return sFinishEnabled;
    }

    public static boolean isReset() {
        return sIsReset;
    }

    public static boolean isStringType(int n) {
        return n == 1 || n == 12 || n == -96 || n == -9 || n == -8 || n == -1 || n == -97 || n == -1 || n == -10;
    }

    public static boolean isSynonymsTable(String string) {
        return ExportToDBData.getExDBData().getSynonymsData().contains(string);
    }

    public static boolean isSystemTable(String string) {
        return ExportToDBData.getExDBData().getSystemTablesData().contains(string);
    }

    public static boolean isUserTable(String string) {
        return ExportToDBData.getExDBData().getTablesData().contains(string);
    }

    public static boolean isViewTable(String string) {
        return ExportToDBData.getExDBData().getViewsData().contains(string);
    }

    public static void setActionString(String string) {
        sActionString = string;
    }

    public static void setCasesToExportString(String string) {
        sCasesToExportString = string;
    }

    public static void setCount(int n) {
        sCount = n;
    }

    public static void setDialog(BaseWizardDialog baseWizardDialog) {
        sWizardDialog = baseWizardDialog;
    }

    public static void setExToDBSelectedOption(ExportToDBOptions exportToDBOptions) {
        sSelectedOption = exportToDBOptions;
    }

    public static void setExToDBWizardPreviousPage(ExToDBWizardPreviousPage exToDBWizardPreviousPage) {
        sPreviousPage = exToDBWizardPreviousPage;
    }

    public static void setFinishEnabled(boolean bl) {
        sFinishEnabled = bl;
    }

    public static void setJoinInfoList(ArrayList<MatchCasesToRecordsPage.JoinInfo> arrayList) {
        sJoinInfoList = arrayList;
    }

    public static void setJoinPanel(JPanel jPanel) {
        sJoinPanel = jPanel;
    }

    public static void setNewTableName(String string) {
        sNewTableName = string;
        ExportToDBUtil.setValidTableName(string);
    }

    public static void setPanel(JPanel jPanel) {
        sPanel = jPanel;
    }

    public static void setQuoteChar(String string) {
        sQuoteChar = string;
    }

    public static void setReset(boolean bl) {
        sIsReset = bl;
    }

    public static void setUserMissingValuesString(String string) {
        sUserMissingValuesString = string;
    }

    public static void setExistingFieldCheck(boolean bl) {
        sExistingFieldCheck = bl;
    }

    public static boolean isExistingFieldCheck() {
        return sExistingFieldCheck;
    }

    public static void setFirstAvailableType(String string) {
        sFisrtAvailableType = string;
    }

    public static void setBulkLoadingChecked(boolean bl) {
        sBulkLoadingChecked = bl;
    }

    public static void setBatchSize(int n) {
        sBatchSize = n;
    }

    public static void setBatchCommitSelected(boolean bl) {
        sBatchCommitSelected = bl;
    }

    public static void setRowWiseBindingSelected(boolean bl) {
        sRowWiseBindingSelected = bl;
    }

    private static boolean findDataType(String string) {
        boolean bl = false;
        LinkedHashMap<String, String> linkedHashMap = ExportToDBData.getExDBData().getSQLNameWidthMap();
        if (((HashMap)linkedHashMap).get(string) != null) {
            sDefaultWidth = (String)((HashMap)linkedHashMap).get(string);
            sDefaultType = string;
            bl = true;
        }
        return bl;
    }

    private static boolean findDoubleType() {
        boolean bl = true;
        if (!(ExportToDBUtil.findDataType("number") || ExportToDBUtil.findDataType("double") || ExportToDBUtil.findSQLType(8) || ExportToDBUtil.findDataType("float") || ExportToDBUtil.findSQLType(6) || ExportToDBUtil.findDataType("real") || ExportToDBUtil.findSQLType(7))) {
            bl = false;
        }
        return bl;
    }

    private static boolean findNumericType() {
        boolean bl = true;
        if (!ExportToDBUtil.findDataType("numeric") && !ExportToDBUtil.findDataType("double")) {
            bl = false;
        }
        return bl;
    }

    private static boolean findStringType() {
        ExportToDBData exportToDBData;
        boolean bl = true;
        if (ExportToDBUtil.useUnicodeDataType() && ((exportToDBData = ExportToDBData.getExDBData()).isDatabase("Oracle") ? ExportToDBUtil.findDataType("nvarchar2") : exportToDBData.isDatabase("SQL Server") && ExportToDBUtil.findDataType("nvarchar"))) {
            return true;
        }
        if (ExportToDBData.getExDBData().isDatabase("Postgre") && ExportToDBUtil.findDataType("character varying")) {
            return true;
        }
        if (!(ExportToDBUtil.findDataType("varchar2") || ExportToDBUtil.findDataType("varchar") || ExportToDBUtil.findSQLType(12) || ExportToDBUtil.findDataType("char") || ExportToDBUtil.findSQLType(1) || ExportToDBUtil.findDataType("memo") || ExportToDBUtil.findDataType("longchar") || ExportToDBUtil.findSQLType(-1))) {
            bl = false;
        }
        return bl;
    }

    private static boolean useUnicodeDataType() {
        return ExportToDBData.getExDBData().getWizardCapabities().getODBCInUnicode();
    }

    private static boolean findSQLType(int n) {
        String string;
        boolean bl = false;
        LinkedHashMap<String, String> linkedHashMap = ExportToDBData.getExDBData().getSQLNameWidthMap();
        LinkedHashMap<Integer, String> linkedHashMap2 = ExportToDBData.getExDBData().getSQLTypeNameMap();
        if (((HashMap)linkedHashMap2).get(n) != null && ((HashMap)linkedHashMap).get(string = (String)((HashMap)linkedHashMap2).get(n)) != null) {
            String string2 = (String)((HashMap)linkedHashMap).get(string);
            sDefaultType = string;
            sDefaultWidth = string2;
            bl = true;
        }
        return bl;
    }

    public static JPanel setupInfoPanel() {
        return ExportToDBUtil.setupInfoPanel("IDS_EX2DB_MATCH_CASES_TO_RECORDS_INFO_NOTE");
    }

    public static JPanel setupInfoPanel(String string) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        JLabel jLabel = new JLabel();
        ResourceBundle resourceBundle = ResUtil.getBundle(CommonDlgResBundle.getDefaultResourceBundleName(), ResUtil.getLocale());
        URL uRL = ResUtil.getImageResourceFullPath(CommonDlgResBundle.getImageFolder() + ResUtil.getString(resourceBundle, "IDS_INFO_DOT_IMAGE"));
        ImageIcon imageIcon = new ImageIcon(uRL);
        jLabel.setIcon(imageIcon);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        resourceBundle = ResUtil.getBundle(FileResBundle.getDefaultResourceBundleName(), ResUtil.getLocale());
        JTextArea jTextArea = new JTextArea(ResUtil.getString(resourceBundle, string));
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setBorder(null);
        jTextArea.setOpaque(false);
        jTextArea.setFocusable(false);
        jTextArea.setMinimumSize(new Dimension(100, 60));
        jTextArea.setPreferredSize(new Dimension(100, 60));
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, jTextArea, gridBagConstraints, 1, 0, 1, 1, n, insets);
        return jPanel;
    }

    static {
        sDefaultType = "";
        sDefaultWidth = "";
        sPreviousPage = ExToDBWizardPreviousPage.eNone;
        sSelectedOption = ExportToDBOptions.eReplaceValExisitngFields;
        sDataTypes = new Vector();
        sTableOwnerMap = new HashMap();
    }

    private static class ListComparator
    implements Comparator {
        private ListComparator() {
        }

        public int compare(Object object, Object object2) {
            if (object instanceof String && object2 instanceof String) {
                String string = (String)object;
                String string2 = (String)object2;
                return string.compareToIgnoreCase(string2);
            }
            return -1;
        }
    }

    public static enum ExToDBWizardPreviousPage {
        eFinish,
        eHowToExportDataPage,
        eMatchCasesToRecordsPage,
        eNone,
        eSelectCasesToExportPage,
        eSelectTableOrViewPage,
        eSelectVarsToStoreInExistingFieldPage,
        eSelectVarsToStoreInNewFieldPage,
        eSelectVarsToStoreInNewRecordsPage,
        eSelectVarsToStoreInNewTablePage,
        eWelcome;

    }

    public static enum ExToDBPage {
        eExistingFieldPage,
        eNewFieldsPage,
        eNewRecordsPage,
        eNewTablePage;

    }

    public static enum ExportToDBOptions {
        eAddFieldsToExistingTable,
        eAppendNewRecordToExistingTable,
        eCreateNewTable,
        eDropAndCreateNewTable,
        eReplaceValExisitngFields;

    }
}

