/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.file.export_to_db.utilities;

import com.spss.java_client.core.comp_util.PassEncrypt;
import com.spss.java_client.core.documents.data.VarNameValidator;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.SPSS_Format;
import com.spss.java_client.ui.dialogs.base.file.export_to_db.ExportToDBData;
import com.spss.java_client.ui.dialogs.base.file.export_to_db.utilities.AlterAddSQLSpec;
import com.spss.java_client.ui.dialogs.base.file.export_to_db.utilities.CreateSQLSpec;
import com.spss.java_client.ui.dialogs.base.file.export_to_db.utilities.ExportToDBUtil;
import com.spss.java_client.ui.dialogs.base.file.export_to_db.utilities.InsertSQLSpec;
import com.spss.java_client.ui.dialogs.base.file.export_to_db.utilities.UpdateSQLSpec;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.DBWizardSyntaxUtil;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.uitools.util.CharacterUtil;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Pattern;

public class ExportToDBSyntaxUtil {
    private static StringBuffer sAllSyntax;
    private static String sConnectionStr;
    private static String sMissingValuesSyntax;
    private static String sSelectCasesSyntax;
    private static boolean sUseQuotedIdentifiers;
    private static UpdateSQLSpec updateSQLSpec;
    private static AlterAddSQLSpec alterAddSQLSpec;
    private static InsertSQLSpec insertSQLSpec;
    private static CreateSQLSpec createSQLSpec;

    public static String getAllSyntax() {
        StringBuilder stringBuilder;
        ExportToDBSyntaxUtil.initVars();
        ExportToDBUtil.ExportToDBOptions exportToDBOptions = ExportToDBUtil.getExToDBSelectedOption();
        String string = ExportToDBSyntaxUtil.uniqueTempTableName();
        String string2 = ExportToDBSyntaxUtil.checkForQuotes(string, false);
        sAllSyntax = SyntaxUtil.startSyntax();
        sAllSyntax.append("SAVE TRANSLATE");
        sAllSyntax.append(" /TYPE=ODBC");
        if (ExportToDBUtil.getBulkLoadingChecked()) {
            sAllSyntax.append("\n  /BULKLOADING ");
            int n = ExportToDBUtil.getBatchSize();
            sAllSyntax.append("BATCHSIZE=" + n + " ");
            if (ExportToDBUtil.getBatchCommitSelected()) {
                sAllSyntax.append("METHOD=BATCH");
            } else {
                sAllSyntax.append("METHOD=ODBC ");
                if (ExportToDBUtil.getRowWiseBindingSelected()) {
                    sAllSyntax.append("BINDING=ROW ");
                } else {
                    sAllSyntax.append("BINDING=COLUMN ");
                }
            }
        }
        PassEncrypt passEncrypt = new PassEncrypt();
        String string3 = passEncrypt.odbcEncryptPassword(sConnectionStr, true, true);
        string3 = "\n  /CONNECT=" + CharacterUtil.smartQuote((String)string3, (boolean)true);
        sAllSyntax.append(string3);
        sAllSyntax.append("\n  /ENCRYPTED");
        if (ExportToDBUtil.isFilterOn()) {
            sAllSyntax.append("\n  /UNSELECTED=");
            sAllSyntax.append(ExportToDBSyntaxUtil.getSelectCasesSyntax());
        }
        sAllSyntax.append("\n  /MISSING=" + ExportToDBSyntaxUtil.getMissingValuesSyntax());
        String string4 = ExportToDBData.getExDBData().getWizardCapabities().getStrDBMSName();
        if (!string4.equals("EXCEL") || string4.equals("EXCEL") && exportToDBOptions == ExportToDBUtil.ExportToDBOptions.eReplaceValExisitngFields) {
            if (exportToDBOptions == ExportToDBUtil.ExportToDBOptions.eDropAndCreateNewTable) {
                sAllSyntax.append(ExportToDBSyntaxUtil.makeSQL("DROP TABLE " + ExportToDBSyntaxUtil.getValidTableName()));
                sAllSyntax.append(ExportToDBSyntaxUtil.makeSQL(createSQLSpec.getCreateSQL(string4)));
            } else if (exportToDBOptions == ExportToDBUtil.ExportToDBOptions.eCreateNewTable) {
                sAllSyntax.append(ExportToDBSyntaxUtil.makeSQL(createSQLSpec.getCreateSQL(string4)));
            }
        }
        if (exportToDBOptions != ExportToDBUtil.ExportToDBOptions.eAppendNewRecordToExistingTable) {
            sAllSyntax.append("\n  /REPLACE");
        } else if (string4.equals("EXCEL")) {
            sAllSyntax.append("\n  /APPEND");
        }
        sAllSyntax.append("\n  /TABLE='");
        if (!string4.equals("EXCEL") || string4.equals("EXCEL") && exportToDBOptions == ExportToDBUtil.ExportToDBOptions.eReplaceValExisitngFields) {
            sAllSyntax.append(string);
        } else {
            sAllSyntax.append(ExportToDBSyntaxUtil.getValidTableName());
        }
        sAllSyntax.append("'");
        sAllSyntax.append("\n  /KEEP=");
        if (exportToDBOptions == ExportToDBUtil.ExportToDBOptions.eReplaceValExisitngFields || exportToDBOptions == ExportToDBUtil.ExportToDBOptions.eAddFieldsToExistingTable) {
            sAllSyntax.append(ExportToDBSyntaxUtil.makeSeparatedList(updateSQLSpec.getKeepList(), ", "));
        } else if (exportToDBOptions == ExportToDBUtil.ExportToDBOptions.eAppendNewRecordToExistingTable) {
            sAllSyntax.append(ExportToDBSyntaxUtil.makeSeparatedList(insertSQLSpec.getKeepList(), ", "));
        } else if (exportToDBOptions == ExportToDBUtil.ExportToDBOptions.eCreateNewTable || exportToDBOptions == ExportToDBUtil.ExportToDBOptions.eDropAndCreateNewTable) {
            sAllSyntax.append(ExportToDBSyntaxUtil.makeSeparatedList(createSQLSpec.getKeepList(), ", "));
        }
        if (!string4.equals("EXCEL") || string4.equals("EXCEL") && exportToDBOptions == ExportToDBUtil.ExportToDBOptions.eReplaceValExisitngFields) {
            ExportToDBSyntaxUtil.appendSqlQuery();
        }
        if (!string4.equals("EXCEL") || string4.equals("EXCEL") && exportToDBOptions == ExportToDBUtil.ExportToDBOptions.eReplaceValExisitngFields) {
            sAllSyntax.append(ExportToDBSyntaxUtil.makeSQL("DROP TABLE " + string2));
        }
        if ((exportToDBOptions == ExportToDBUtil.ExportToDBOptions.eCreateNewTable || exportToDBOptions == ExportToDBUtil.ExportToDBOptions.eDropAndCreateNewTable) && createSQLSpec.getValLabelColumnList().size() > 0) {
            stringBuilder = new StringBuilder();
            for (String string5 : createSQLSpec.getValLabelColumnList()) {
                stringBuilder.append(string5 + ",");
            }
            sAllSyntax.append("\n  /ODBCOPTIONS VALLABELS=" + stringBuilder.substring(0, stringBuilder.length() - 1));
        }
        if (exportToDBOptions == ExportToDBUtil.ExportToDBOptions.eAddFieldsToExistingTable && alterAddSQLSpec.getValLabelColumnList().size() > 0) {
            stringBuilder = new StringBuilder();
            for (String string5 : alterAddSQLSpec.getValLabelColumnList()) {
                stringBuilder.append(string5 + ",");
            }
            sAllSyntax.append("\n  /ODBCOPTIONS VALLABELS=" + stringBuilder.substring(0, stringBuilder.length() - 1));
        }
        sAllSyntax.append(SyntaxUtil.terminateSyntax());
        return sAllSyntax.toString();
    }

    public static String checkForQuotes(String string, boolean bl) {
        return ExportToDBSyntaxUtil.checkForQuotes(string, bl, false);
    }

    public static String checkForQuotes(String string, boolean bl, boolean bl2) {
        String string2 = ExportToDBData.getExDBData().getWizardCapabities().getStrDBMSName();
        ExportToDBData exportToDBData = ExportToDBData.getExDBData();
        String string3 = ExportToDBUtil.getQuoteChar();
        int n = VarNameValidator.validateSPSSName((String)string, (boolean)true).asInt();
        boolean bl3 = false;
        if (n > 1 && n < 8) {
            bl3 = true;
        } else if (DBWizardSyntaxUtil.isODBCSqlKeyWords(string) || DBWizardSyntaxUtil.isSqlKeyWords(string)) {
            bl3 = true;
        } else if (string.startsWith("@")) {
            bl3 = true;
        } else if (bl && (string.contains("$") || string.contains("%") || string.contains("@") || string.contains("#"))) {
            bl3 = true;
        }
        if (!bl3 && (exportToDBData.isDatabase("Oracle") || exportToDBData.isDatabase("DB2") || exportToDBData.isDatabase("AS")) || exportToDBData.isDatabase("GREENPLUM") || exportToDBData.isDatabase("HDB")) {
            if (!string.toUpperCase().equals(string)) {
                bl3 = true;
            } else if (exportToDBData.getWizardCapabities().getODBCInUnicode()) {
                bl3 = true;
            }
        }
        if (!bl3 && exportToDBData.isDatabase("XML")) {
            bl3 = true;
        }
        if (!bl3 && exportToDBData.isDatabase("SQL Server") && sUseQuotedIdentifiers) {
            bl3 = true;
        }
        if (!bl3 && (exportToDBData.isDatabase("Netezza") || exportToDBData.isDatabase("PostgreSQL"))) {
            if (!string.toLowerCase().equals(string)) {
                bl3 = true;
            } else if (exportToDBData.getWizardCapabities().getODBCInUnicode()) {
                bl3 = true;
            }
        }
        if (bl3 && !string.contains(string3)) {
            if (string2.equalsIgnoreCase("ACCESS") || string2.equalsIgnoreCase("EXCEL")) {
                string = string3 + string + string3;
            } else if (exportToDBData.isDatabase("SQL Server")) {
                if (!string.startsWith("[") || !string.endsWith("]")) {
                    if (bl2) {
                        string = '[' + string + ']';
                    } else {
                        int n2 = string.indexOf(".");
                        if (n2 > -1) {
                            String string4 = string.substring(0, n2);
                            String string5 = string.substring(n2 + 1);
                            int n3 = string5.indexOf(".");
                            if (n3 > -1) {
                                String string6 = string5.substring(0, n3);
                                String string7 = string5.substring(n3 + 1);
                                string7 = '[' + string7 + ']';
                                string6 = '[' + string6 + ']';
                                string4 = '[' + string4 + ']';
                                string = string4 + '.' + string6 + '.' + string7;
                            } else {
                                string5 = '[' + string5 + ']';
                                string4 = '[' + string4 + ']';
                                string = string4 + '.' + string5;
                            }
                        } else {
                            string = '[' + string + ']';
                        }
                    }
                }
            } else {
                String string8 = ".";
                String[] stringArray = string.split(Pattern.quote(string8));
                if (stringArray.length > 1 && !bl2) {
                    string = "";
                    for (int i = 0; i < stringArray.length; ++i) {
                        string = i == 0 ? string + stringArray[i] : string + string3 + stringArray[i] + string3;
                        if (i == stringArray.length - 1) continue;
                        string = string + string8;
                    }
                } else {
                    string = string3 + string + string3;
                }
            }
        }
        return string;
    }

    public static String getValidTableName() {
        String string = ExportToDBUtil.getValidTableName();
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append(ExportToDBSyntaxUtil.checkForQuotes(string, true));
        return stringBuffer.toString();
    }

    public static String getValidColName(String string) {
        String string2 = ExportToDBData.getExDBData().getWizardCapabities().getStrDBMSName();
        String string3 = string.toUpperCase();
        StringBuffer stringBuffer = new StringBuffer("");
        if (string2.equalsIgnoreCase("ORACLE") || string2.contains("DB2")) {
            if (!string.equals(string3)) {
                int n = string.indexOf(".");
                if (n > -1) {
                    String string4 = string.substring(0, n);
                    String string5 = string.substring(n + 1);
                    string5 = ExportToDBSyntaxUtil.getValidColName(string5);
                    stringBuffer.append(string4);
                    stringBuffer.append('.');
                    stringBuffer.append(string5);
                } else {
                    String string6 = ExportToDBUtil.getQuoteChar();
                    stringBuffer.append(string6);
                    stringBuffer.append(string);
                    stringBuffer.append(string6);
                }
            } else {
                stringBuffer.append(ExportToDBSyntaxUtil.checkForQuotes(string, true));
            }
        } else {
            stringBuffer.append(ExportToDBSyntaxUtil.checkForQuotes(string, true));
        }
        return stringBuffer.toString();
    }

    public static void reset() {
        sAllSyntax = new StringBuffer("");
        sConnectionStr = "";
        sSelectCasesSyntax = "";
        sMissingValuesSyntax = "";
        updateSQLSpec = null;
        alterAddSQLSpec = null;
        insertSQLSpec = null;
        createSQLSpec = null;
        sUseQuotedIdentifiers = true;
    }

    public static String getConnectionStr() {
        return sConnectionStr;
    }

    public static String getMissingValuesSyntax() {
        return sMissingValuesSyntax;
    }

    public static String getSelectCasesSyntax() {
        return sSelectCasesSyntax;
    }

    public static void setMissingValuesSyntax(String string) {
        sMissingValuesSyntax = string;
    }

    public static void setSelectCasesSyntax(String string) {
        sSelectCasesSyntax = string;
    }

    public static void setUseQuotedIdentifiers(boolean bl) {
        sUseQuotedIdentifiers = bl;
    }

    public static void setUseQuotedIdentifiers() {
        ExportToDBSyntaxUtil.setUseQuotedIdentifiers(ExportToDBSyntaxUtil.checkConnectionStrForUseQuotedIds());
    }

    public static String uniqueTempTableName() {
        if (!ExportToDBSyntaxUtil.findTable("SPSS_TEMP")) {
            return "SPSS_TEMP";
        }
        for (int i = 1; i < 100001; ++i) {
            String string = String.format("SPSS_TEMP_%d", i);
            if (ExportToDBSyntaxUtil.findTable(string)) continue;
            return string;
        }
        return "";
    }

    private static boolean findTable(String string) {
        Vector<String> vector = ExportToDBData.getExDBData().getAllTableNames();
        for (int i = 0; i < vector.size(); ++i) {
            if (!vector.get(i).equalsIgnoreCase(string)) continue;
            return true;
        }
        return ExportToDBUtil.getExToDBSelectedOption() == ExportToDBUtil.ExportToDBOptions.eCreateNewTable && ExportToDBUtil.getNewTableName().equalsIgnoreCase(string);
    }

    private static void initVars() {
        sAllSyntax = SyntaxUtil.startSyntax();
        sConnectionStr = ExportToDBData.getExDBData().getConnectionString();
        sConnectionStr = sConnectionStr.replaceAll("\r", "").replaceAll("\n", "");
        ExportToDBSyntaxUtil.setUseQuotedIdentifiers(ExportToDBSyntaxUtil.checkConnectionStrForUseQuotedIds());
    }

    private static boolean checkConnectionStrForUseQuotedIds() {
        boolean bl = true;
        if (sConnectionStr != null && sConnectionStr.contains("QuotedId=No")) {
            bl = false;
        }
        return bl;
    }

    private static void appendSqlQuery() {
        ExportToDBUtil.ExportToDBOptions exportToDBOptions = ExportToDBUtil.getExToDBSelectedOption();
        String string = ExportToDBData.getExDBData().getWizardCapabities().getStrDBMSName();
        StringBuffer stringBuffer = new StringBuffer("");
        if (exportToDBOptions == ExportToDBUtil.ExportToDBOptions.eAddFieldsToExistingTable) {
            stringBuffer.append(alterAddSQLSpec.getAlterAddSQL(string));
            sAllSyntax.append(ExportToDBSyntaxUtil.makeSQL(stringBuffer.toString()));
            stringBuffer = new StringBuffer();
        }
        if (exportToDBOptions == ExportToDBUtil.ExportToDBOptions.eAddFieldsToExistingTable || exportToDBOptions == ExportToDBUtil.ExportToDBOptions.eReplaceValExisitngFields) {
            stringBuffer.append(updateSQLSpec.getUpdateSQL(string));
        } else if (exportToDBOptions == ExportToDBUtil.ExportToDBOptions.eAppendNewRecordToExistingTable) {
            stringBuffer.append(insertSQLSpec.getInsertSQL(string));
        } else if (exportToDBOptions == ExportToDBUtil.ExportToDBOptions.eDropAndCreateNewTable || exportToDBOptions == ExportToDBUtil.ExportToDBOptions.eCreateNewTable) {
            stringBuffer.append(createSQLSpec.getInsertSQL(string));
        }
        sAllSyntax.append(ExportToDBSyntaxUtil.makeSQL(stringBuffer.toString()));
    }

    public static String makeSeparatedList(LinkedList<String> linkedList, String string) {
        StringBuffer stringBuffer = new StringBuffer("");
        boolean bl = false;
        for (String string2 : linkedList) {
            if (bl) {
                stringBuffer.append(string);
            }
            stringBuffer.append(string2);
            bl = true;
        }
        return stringBuffer.toString();
    }

    public static String makeSeparatedListOfPairs(LinkedList<String> linkedList, LinkedList<String> linkedList2, String string, String string2) {
        LinkedList<String> linkedList3 = new LinkedList<String>();
        ListIterator listIterator = linkedList.listIterator();
        ListIterator listIterator2 = linkedList2.listIterator();
        while (listIterator.hasNext() && listIterator2.hasNext()) {
            linkedList3.add((String)listIterator2.next() + string + (String)listIterator.next());
        }
        return ExportToDBSyntaxUtil.makeSeparatedList(linkedList3, string2);
    }

    public static String makeColumnSpec(String string, String string2, String string3, boolean bl) {
        return ExportToDBSyntaxUtil.makeColumnSpec(null, string, string2, string3, bl);
    }

    public static String makeColumnSpec(String string, String string2, String string3, String string4, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer("");
        string2 = ExportToDBSyntaxUtil.checkForQuotes(string2, true, true);
        stringBuffer.append(string2);
        stringBuffer.append(" ");
        stringBuffer.append(string3);
        stringBuffer.append(" ");
        ExportToDBData exportToDBData = ExportToDBData.getExDBData();
        if (string != null && exportToDBData.isDatabase("Netezza") && string3.equals("numeric")) {
            Set<Map.Entry<ISpssVariable, SPSS_Format>> set = exportToDBData.getSpssVarPropsMap().entrySet();
            for (Map.Entry<ISpssVariable, SPSS_Format> entry : set) {
                ISpssVariable iSpssVariable = entry.getKey();
                SPSS_Format sPSS_Format = entry.getValue();
                if (!iSpssVariable.getName().equals(string)) continue;
                string4 = sPSS_Format.getWidth() + ", " + sPSS_Format.getDecimals();
                break;
            }
        }
        if (string4 != null) {
            stringBuffer.append("(");
            stringBuffer.append(string4);
            stringBuffer.append(")");
        }
        if (bl) {
            stringBuffer.append(" NOT NULL");
        }
        return stringBuffer.toString();
    }

    private static StringBuffer makeSQL(String string) {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("\n  /SQL=");
        stringBuffer.append(CharacterUtil.smartQuote((String)string, (boolean)true));
        return stringBuffer;
    }

    public static void setUpdateSQLSpec(UpdateSQLSpec updateSQLSpec) {
        ExportToDBSyntaxUtil.updateSQLSpec = updateSQLSpec;
    }

    public static AlterAddSQLSpec getAlterAddSQLSpec() {
        return alterAddSQLSpec;
    }

    public static void setAlterAddSQLSpec(AlterAddSQLSpec alterAddSQLSpec) {
        ExportToDBSyntaxUtil.alterAddSQLSpec = alterAddSQLSpec;
    }

    public static void setInsertSQLSpec(InsertSQLSpec insertSQLSpec) {
        ExportToDBSyntaxUtil.insertSQLSpec = insertSQLSpec;
    }

    public static void setCreateSQLSpec(CreateSQLSpec createSQLSpec) {
        ExportToDBSyntaxUtil.createSQLSpec = createSQLSpec;
    }

    static {
        sUseQuotedIdentifiers = true;
    }
}

