/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.file.export_to_db.store_vars_new_table;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.comp_util.OSCheck;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.SpssVariable;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.SpssMultiLineRadioButton;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.dialogs.base.file.export_to_db.AbstractExportToDBPage;
import com.spss.java_client.ui.dialogs.base.file.export_to_db.ArrowButtonEditor;
import com.spss.java_client.ui.dialogs.base.file.export_to_db.ArrowButtonRenderer;
import com.spss.java_client.ui.dialogs.base.file.export_to_db.ExportToDBArrowButton;
import com.spss.java_client.ui.dialogs.base.file.export_to_db.ExportToDBData;
import com.spss.java_client.ui.dialogs.base.file.export_to_db.ExportToDBDlg;
import com.spss.java_client.ui.dialogs.base.file.export_to_db.ExportToDBScrollPane;
import com.spss.java_client.ui.dialogs.base.file.export_to_db.ExportToDBToolTipHeader;
import com.spss.java_client.ui.dialogs.base.file.export_to_db.store_vars_new_table.NewTablePageArrowButton;
import com.spss.java_client.ui.dialogs.base.file.export_to_db.store_vars_new_table.StoreInNewTableData;
import com.spss.java_client.ui.dialogs.base.file.export_to_db.store_vars_new_table.StoreInNewTableModel;
import com.spss.java_client.ui.dialogs.base.file.export_to_db.store_vars_new_table.StoreVarNewTableDropListener;
import com.spss.java_client.ui.dialogs.base.file.export_to_db.utilities.CreateSQLSpec;
import com.spss.java_client.ui.dialogs.base.file.export_to_db.utilities.ExportToDBSyntaxUtil;
import com.spss.java_client.ui.dialogs.base.file.export_to_db.utilities.ExportToDBUtil;
import com.spss.java_client.ui.dialogs.common.BaseWizardDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.controls.drag_drop.DragPane;
import com.spss.uitools.controls.drag_drop.IDropListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Set;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.plaf.UIResource;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class StoreVarsInNewTablePage
extends AbstractExportToDBPage
implements ListDataListener,
ListSelectionListener,
TableModelListener,
FocusListener,
KeyListener {
    private JRadioButton mExportAsNullAndBlankRadio;
    private JRadioButton mExportAsValidRadio;
    private StoreVarNewTableDropListener mExToDBDropListener;
    private DragPane mGlassPane;
    private JLabel mImageLabel;
    private JLabel mNewTableName;
    private SpssButtonGroup mRadioButtonGroup;
    private SrcVariableList mSrcList;
    private JTable mTable;
    private ExportToDBScrollPane mTableScroll;
    private JTable mMainTable;
    private JTable mFixedTable;
    private ArrayList<ExportToDBArrowButton> mArrowButtonsList;
    private HashMap<String, Integer> mDuplicateFieldsMap;
    private boolean mIsFieldNameEmpty;
    private boolean mIsVarToSaveEmpty;
    private boolean mEnableNextFinish;
    private DialogFocusTraversalPolicy mPolicy;
    private ArrayList<Integer> mTableColWidth;
    private boolean mIsExcel;

    public StoreVarsInNewTablePage(BaseWizardDialog baseWizardDialog) {
        super("StoreVarsInNewTablePage", baseWizardDialog, true);
        this.mExToDBDropListener = new StoreVarNewTableDropListener((JComponent)this.mTable, this.mArrowButtonsList);
        this.mGlassPane = (DragPane)this.mWizardDialog.getGlassPane();
    }

    @Override
    public String getDialogHelpID() {
        return "idh_idd_exdb_page_vars2new_table";
    }

    @Override
    public String getNextPage() {
        return "FinishPage";
    }

    @Override
    public boolean hasNextPage() {
        return true;
    }

    @Override
    public boolean isLastPage() {
        return false;
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        int n = this.mFixedTable.getSelectedRow();
        int n2 = this.mFixedTable.getSelectedColumn();
        if (n != -1 && n2 != -1) {
            StoreInNewTableModel storeInNewTableModel = (StoreInNewTableModel)this.mFixedTable.getModel();
            TableCellEditor tableCellEditor = this.mFixedTable.getCellEditor(n, 0);
            if (tableCellEditor != null) {
                tableCellEditor.stopCellEditing();
            }
            storeInNewTableModel.fireTableRowsUpdated(n, n);
        }
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        if (listDataEvent.getSource() instanceof DefaultComboBoxModel) {
            int n = this.mFixedTable.getSelectedRow();
            if (n != -1) {
                StoreInNewTableModel storeInNewTableModel = (StoreInNewTableModel)this.mFixedTable.getModel();
                TableCellEditor tableCellEditor = this.mMainTable.getCellEditor(n, 3);
                if (tableCellEditor != null) {
                    tableCellEditor.stopCellEditing();
                }
                storeInNewTableModel.fireTableRowsUpdated(n, n);
            }
        } else {
            int n = this.mMainTable.getSelectedRow();
            int n2 = this.mMainTable.getSelectedColumn();
            if (n != -1 && n2 != -1) {
                StoreInNewTableModel storeInNewTableModel = (StoreInNewTableModel)this.mMainTable.getModel();
                TableCellEditor tableCellEditor = this.mMainTable.getCellEditor(n, n2);
                if (tableCellEditor != null && tableCellEditor.getCellEditorValue() != null) {
                    storeInNewTableModel.setValueAt(tableCellEditor.getCellEditorValue(), n, n2 + 1);
                    storeInNewTableModel.fireTableRowsUpdated(n, n);
                }
            }
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        for (int i = 0; i < this.mArrowButtonsList.size(); ++i) {
            this.mArrowButtonsList.get(i).setEnabled(true);
            ((StoreInNewTableModel)this.mTable.getModel()).fireTableRowsUpdated(i, i);
        }
    }

    @Override
    public boolean validateOnBack() {
        return this.validate();
    }

    @Override
    public boolean validate() {
        String string;
        Object object;
        this.generateSyntax();
        if (this.mExportAsValidRadio.isSelected()) {
            ExportToDBUtil.setUserMissingValuesString(this.mWizardDialog.getResString("IDS_EX2DB_EXPORT_MISSING_VALUES_AS_VALID_TEXT"));
        } else {
            ExportToDBUtil.setUserMissingValuesString(this.mWizardDialog.getResString("IDS_EX2DB_EXPORT_MISSING_VALUES_AS_NULL_BLANK_TEXT"));
        }
        StoreInNewTableModel storeInNewTableModel = (StoreInNewTableModel)this.mTable.getModel();
        String string2 = this.getDuplicateFieldName();
        if (string2 != null) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this.mWizardDialog), MessageFormat.format(this.mWizardDialog.getResString("ERR_EX2DB_DUPLICATE_FIELD_NAME"), string2), this.mWizardDialog.getResString("IDS_DBWIZARD_WARNING_TITLE"));
            for (int i = 0; i < storeInNewTableModel.getRowCount(); ++i) {
                object = (String)storeInNewTableModel.getValueAt(i, 3);
                if (!((String)object).equals(string2)) continue;
                this.mMainTable.requestFocusInWindow();
                this.mMainTable.setRowSelectionInterval(i, i);
                this.mMainTable.setColumnSelectionInterval(2, 2);
                this.mMainTable.editCellAt(i, 2);
                return false;
            }
        }
        if ((string = this.fieldNotSpecified()) != null) {
            if (this.mIsFieldNameEmpty) {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this.mWizardDialog), MessageFormat.format(this.mWizardDialog.getResString("ERR_EX2DB_ENTER_FIELD_NAME"), string), this.mWizardDialog.getResString("IDS_DBWIZARD_WARNING_TITLE"));
                for (int i = 0; i < storeInNewTableModel.getRowCount(); ++i) {
                    ISpssVariable iSpssVariable = (ISpssVariable)storeInNewTableModel.getValueAt(i, 1);
                    if (!iSpssVariable.getName().equals(string)) continue;
                    this.mMainTable.requestFocusInWindow();
                    this.mMainTable.setRowSelectionInterval(i, i);
                    this.mMainTable.setColumnSelectionInterval(2, 2);
                    this.mMainTable.editCellAt(i, 2);
                    break;
                }
            }
            return false;
        }
        object = this.variableNotSpecified();
        boolean bl = false;
        if (object != null && ((Vector)object).size() > 0) {
            if (this.mIsVarToSaveEmpty) {
                block2: for (int i = 0; i < ((Vector)object).size(); ++i) {
                    int n = SpssAlertOptionPane.showConfirmDialog((Window)((Object)this.mWizardDialog), MessageFormat.format(this.mWizardDialog.getResString("ERR_EX2DB_VAR_TO_SAVE_NOT_SPECIFIED"), ((Vector)object).get(i)), this.mWizardDialog.getResString("IDS_DBWIZARD_WARNING_TITLE"), SpssAlertOptionPane.IconType.eWarning, SpssAlertOptionPane.OptionType.OK_CANCEL_OPTION);
                    if (n != 0) {
                        return false;
                    }
                    bl = true;
                    for (int j = 0; j < storeInNewTableModel.getRowCount(); ++j) {
                        String string3 = (String)storeInNewTableModel.getValueAt(j, 3);
                        if (!string3.equals(string)) continue;
                        this.mMainTable.requestFocusInWindow();
                        this.mMainTable.setRowSelectionInterval(j, j);
                        this.mMainTable.setColumnSelectionInterval(0, 0);
                        this.mMainTable.editCellAt(j, 0);
                        continue block2;
                    }
                }
            }
            return bl;
        }
        string2 = this.checkWidthPositive();
        if (string2 != null) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this.mWizardDialog), MessageFormat.format(this.mWizardDialog.getResString("ERR_EX2DB_WIDTH_MUST_BE_POSITIVE"), string2), this.mWizardDialog.getResString("IDS_DBWIZARD_WARNING_TITLE"));
            for (int i = 0; i < storeInNewTableModel.getRowCount(); ++i) {
                ISpssVariable iSpssVariable = (ISpssVariable)storeInNewTableModel.getValueAt(i, 1);
                if (iSpssVariable == null || !iSpssVariable.getName().equals(string2)) continue;
                this.mMainTable.requestFocus();
                this.mMainTable.setRowSelectionInterval(i, i);
                this.mMainTable.setColumnSelectionInterval(4, 4);
                this.mMainTable.editCellAt(i, 4);
                break;
            }
            return false;
        }
        String string4 = this.getCaseSensitiveDuplicateFields();
        if (string4 != null) {
            String[] stringArray = string4.split(";");
            int n = SpssAlertOptionPane.showConfirmDialog((Window)((Object)this.mWizardDialog), MessageFormat.format(this.mWizardDialog.getResString("ERR_EX2DB_FIELD_SAME_NAME_DIFFER_IN_CASE"), stringArray[0], stringArray[1]), this.mWizardDialog.getResString("IDS_DBWIZARD_WARNING_TITLE"), SpssAlertOptionPane.IconType.eWarning, SpssAlertOptionPane.OptionType.OK_CANCEL_OPTION);
            if (n == 0) {
                return true;
            }
            for (int i = 0; i < storeInNewTableModel.getRowCount(); ++i) {
                String string5 = (String)storeInNewTableModel.getValueAt(i, 3);
                if (!string5.equals(stringArray[0])) continue;
                this.mMainTable.requestFocusInWindow();
                this.mMainTable.setRowSelectionInterval(i, i);
                this.mMainTable.setColumnSelectionInterval(2, 2);
                this.mMainTable.editCellAt(i, 2);
                break;
            }
            return false;
        }
        string2 = this.checkWidthRange();
        if (string2 != null) {
            int n = SpssAlertOptionPane.showConfirmDialog((Window)((Object)this.mWizardDialog), MessageFormat.format(this.mWizardDialog.getResString("ERR_EX2DB_WIDTH_GREATER_THAN_SPECIFIED"), string2), this.mWizardDialog.getResString("IDS_DBWIZARD_WARNING_TITLE"), SpssAlertOptionPane.IconType.eWarning, SpssAlertOptionPane.OptionType.OK_CANCEL_OPTION);
            if (n == 0) {
                return true;
            }
            for (int i = 0; i < storeInNewTableModel.getRowCount(); ++i) {
                ISpssVariable iSpssVariable = (ISpssVariable)storeInNewTableModel.getValueAt(i, 1);
                if (!iSpssVariable.getName().equals(string2)) continue;
                this.mMainTable.requestFocusInWindow();
                this.mMainTable.setRowSelectionInterval(i, i);
                this.mMainTable.setColumnSelectionInterval(4, 4);
                this.mMainTable.editCellAt(i, 4);
                break;
            }
            return false;
        }
        return true;
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        this.updateNextFinishButtons();
        if (tableModelEvent.getType() == 1) {
            int n = this.mArrowButtonsList.size();
            int n2 = this.mTable.getRowCount();
            int n3 = n2 - n;
            for (int i = 0; i < n3; ++i) {
                NewTablePageArrowButton newTablePageArrowButton = new NewTablePageArrowButton(this.mWizardDialog, ExportToDBArrowButton.ButtonOrientation.right, this.mSrcList, this.mTableScroll);
                this.mArrowButtonsList.add(newTablePageArrowButton);
            }
            this.mFixedTable.getColumnModel().getColumn(0).setCellRenderer(new ArrowButtonRenderer(this.mMainTable, this.mArrowButtonsList, this.mWizardDialog));
            this.mFixedTable.getColumnModel().getColumn(0).setCellEditor(new ArrowButtonEditor(this.mMainTable, this.mArrowButtonsList, ExportToDBUtil.ExToDBPage.eNewTablePage, this.mWizardDialog));
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getSource() == this.mTableScroll) {
            int n = this.mMainTable.getSelectedRow();
            int n2 = this.mMainTable.getSelectedColumn();
            if (n != -1 && n2 != -1) {
                this.mMainTable.requestFocus();
                this.mMainTable.setRowSelectionInterval(n, n);
                this.mMainTable.setColumnSelectionInterval(n2, n2);
            } else {
                this.mFixedTable.requestFocus();
                if (n == -1) {
                    n = 0;
                }
                this.mFixedTable.setRowSelectionInterval(n, n);
                this.mFixedTable.setColumnSelectionInterval(0, 0);
            }
        } else if (focusEvent.getSource() instanceof JComboBox) {
            ((JComboBox)focusEvent.getSource()).showPopup();
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        if (focusEvent.getSource() == this.mTableScroll) {
            this.mTableScroll.setBorder(new LineBorder(Color.gray));
        } else if (focusEvent.getSource() instanceof JComboBox) {
            ((JComboBox)focusEvent.getSource()).hidePopup();
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 37) {
            int n;
            if (keyEvent.getSource() == this.mMainTable && (n = this.mMainTable.getSelectedColumn()) == 0) {
                this.mFixedTable.requestFocus();
                this.mFixedTable.setColumnSelectionInterval(0, 0);
            }
        } else if (keyEvent.getKeyCode() == 39 && keyEvent.getSource() == this.mFixedTable) {
            this.mMainTable.requestFocus();
            this.mMainTable.setColumnSelectionInterval(0, 0);
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    private void updateNextFinishButtons() {
        int n = this.mTable.getModel().getRowCount();
        for (int i = 0; i < n; ++i) {
            SpssVariable spssVariable = (SpssVariable)this.mTable.getModel().getValueAt(i, 1);
            if (spssVariable.getName().length() > 0) {
                this.mEnableNextFinish = true;
                break;
            }
            this.mEnableNextFinish = false;
        }
        this.mWizardDialog.enableNext(this.mEnableNextFinish);
        this.mWizardDialog.enableFinish(this.mEnableNextFinish);
        ExportToDBUtil.setFinishEnabled(this.mEnableNextFinish);
    }

    @Override
    protected void aboutToHidePanel() {
        this.mGlassPane.removeDropListener((IDropListener)this.mExToDBDropListener);
        ExportToDBUtil.setExToDBWizardPreviousPage(ExportToDBUtil.ExToDBWizardPreviousPage.eSelectVarsToStoreInNewTablePage);
        for (int i = 0; i < this.mMainTable.getModel().getColumnCount() - 1; ++i) {
            this.mTableColWidth.add(i, this.mMainTable.getColumnModel().getColumn(i).getWidth());
        }
        super.aboutToHidePanel();
    }

    @Override
    protected void aboutToShowPanel() {
        this.mIsExcel = ExportToDBData.getExDBData().isDatabase("Excel");
        this.updateNextFinishButtons();
        this.setHeaderImage();
        this.mGlassPane.addDropListener((IDropListener)this.mExToDBDropListener);
        if (ComponentState.isBtdRtlOrLtr() && ExportToDBUtil.getNewTableName() != null && ExportToDBUtil.getNewTableName().length() > 0) {
            this.mNewTableName.setText(ComponentState.prepareStringForBidiRendering((String)ExportToDBUtil.getNewTableName()));
        } else {
            this.mNewTableName.setText(ExportToDBUtil.getNewTableName());
        }
        if ((ExportToDBUtil.getExToDBWizardPreviousPage() == ExportToDBUtil.ExToDBWizardPreviousPage.eSelectTableOrViewPage || ExportToDBUtil.getExToDBWizardPreviousPage() == ExportToDBUtil.ExToDBWizardPreviousPage.eSelectCasesToExportPage || ExportToDBUtil.getExToDBWizardPreviousPage() == ExportToDBUtil.ExToDBWizardPreviousPage.eHowToExportDataPage) && ExportToDBUtil.isReset()) {
            this.reset();
        }
        this.mMainTable = this.mTableScroll.getMainTable();
        this.mFixedTable = this.mTableScroll.getFixedTable();
        this.setupMainTable();
        this.setupFixedTable();
        this.setRenderersAndEditors();
        this.mSrcList.addListSelectionListener(this);
        this.mSrcList.getModel().addListDataListener(this);
        this.mMainTable.getModel().addTableModelListener(this);
        this.mSrcList.setSelectedIndex(0);
        this.mTableScroll.addFocusListener(this);
        this.mFixedTable.addKeyListener(this);
        this.mMainTable.addKeyListener(this);
        this.mWizardDialog.setFocusTraversalPolicy(this.mPolicy);
        this.mSrcList.requestFocus();
    }

    @Override
    protected void initVars() {
        this.mImageLabel = new JLabel("");
        this.mImageLabel.setIcon(new ImageIcon());
        this.mSrcList = new SrcVariableList();
        this.mSrcList.loadFromActiveDataset();
        this.mSrcList.setSelectedIndex(0);
        this.mNewTableName = new JLabel("");
        this.mExportAsValidRadio = new SpssMultiLineRadioButton(new ToggleButtonAction(this.mWizardDialog, "IDS_EX2DB_EXPORT_MISSING_VALUES_AS_VALID_RADIO"), 700);
        this.mExportAsNullAndBlankRadio = new SpssMultiLineRadioButton(new ToggleButtonAction(this.mWizardDialog, "IDS_EX2DB_EXPORT_MISSING_VALUES_AS_NULL_BLANK_RADIO"), 700);
        this.mRadioButtonGroup = new SpssButtonGroup();
        this.mRadioButtonGroup.add(this.mExportAsValidRadio);
        this.mRadioButtonGroup.add(this.mExportAsNullAndBlankRadio);
        this.mExportAsValidRadio.setSelected(true);
        this.mTable = new JTable();
        this.mFixedTable = new JTable();
        this.mFixedTable.setSurrendersFocusOnKeystroke(true);
        this.mMainTable = new JTable();
        this.mArrowButtonsList = new ArrayList();
        this.mDuplicateFieldsMap = new HashMap();
        this.mWizardDialog.enableNext(false);
        this.setupNewTable();
        if (OSCheck.getOSType() == OSInfo.OSType.MAC) {
            this.mTable.setGridColor(this.mTable.getGridColor().darker());
            this.mMainTable.setGridColor(this.mMainTable.getGridColor().darker());
        }
    }

    @Override
    protected void setTabTraversalOrder() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mSrcList);
        vector.add(this.mTableScroll);
        vector.add(this.mRadioButtonGroup);
        Vector<Object> vector2 = ((ExportToDBDlg)this.mWizardDialog).getTabTraversal(vector);
        this.mPolicy = new DialogFocusTraversalPolicy(vector2, false);
    }

    @Override
    protected JPanel setupPageBody() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = new Insets(0, insets.left, insets.bottom, insets.right);
        JLabel jLabel = DialogUtil.createLabel(this.mWizardDialog, "IDS_EX2DB_MATCH_CASES_TO_RECORDS_SRC_LIST_LABEL");
        jLabel.setLabelFor(this.mSrcList);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets2);
        FontMetrics fontMetrics = jLabel.getFontMetrics(jLabel.getFont());
        int n3 = -1;
        n3 = ComponentState.isBtdRtlOrLtr() && jLabel.getText() != null && jLabel.getText().length() > 0 ? fontMetrics.stringWidth(ComponentState.removeBidiDirectionMarks((String)jLabel.getText())) : fontMetrics.stringWidth(jLabel.getText());
        Insets insets3 = new Insets(0, n3 + 8, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel, new JLabel(ExportToDBUtil.getDataSetName()), gridBagConstraints, 0, 0, 1, 1, n, insets3);
        jLabel = DialogUtil.createLabel(this.mWizardDialog, "IDS_EX2DB_MATCH_CASES_TO_RECORDS_TARGET_TABLE_LABEL");
        jLabel.setLabelFor(this.mTable);
        insets3 = new Insets(0, 2 * n2, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 1, 0, 1, 1, n, insets3);
        n3 = ComponentState.isBtdRtlOrLtr() && jLabel.getText() != null && jLabel.getText().length() > 0 ? fontMetrics.stringWidth(ComponentState.removeBidiDirectionMarks((String)jLabel.getText())) : fontMetrics.stringWidth(jLabel.getText());
        insets3 = new Insets(0, 2 * n2 + n3 + 4, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mNewTableName, gridBagConstraints, 1, 0, 1, 1, n, insets3);
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        JScrollPane jScrollPane = new JScrollPane(this.mSrcList);
        jScrollPane.setPreferredSize(this.mSrcList.getMinimumSize());
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        gridBagConstraints.weightx = 0.8;
        this.mTableScroll = new ExportToDBScrollPane(this.mTable);
        this.mTableScroll.setPreferredSize(this.mTable.getPreferredSize());
        insets2 = new Insets(0, 2 * n2, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mTableScroll, gridBagConstraints, 1, 1, 3, 1, n, insets2);
        insets2 = new Insets(0, insets.left, 0, insets.right);
        DialogUtil.addUsingGBL(jPanel, ExportToDBUtil.setupInfoPanel(), gridBagConstraints, 0, 2, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, ExportToDBUtil.setupInfoPanel("IDS_EX2DB_EXPORT_VALUE_LABLES_INFO_NOTE"), gridBagConstraints, 1, 2, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.setUpMissingValuePanel(), gridBagConstraints, 0, 3, 4, 1, n, insets2);
        return jPanel;
    }

    @Override
    protected JPanel setupPageHeader() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = new Insets(0, insets.left, n2, insets.right);
        JLabel jLabel = new JLabel(this.mWizardDialog.getResString("IDS_EX2DB_VAR_TO_STORE_IN_NEW_TABLE_HEADING"));
        jLabel.setFont(jLabel.getFont().deriveFont(1, 20.0f));
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 2, 1, n, insets2);
        n = 24;
        DialogUtil.addUsingGBL(jPanel, this.mImageLabel, gridBagConstraints, 0, 0, 2, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        n = 23;
        JTextArea jTextArea = new JTextArea(this.mWizardDialog.getResString("IDS_EX2DB_VAR_TO_STORE_IN_NEW_TABLE_NOTE1"));
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setBorder(null);
        jTextArea.setOpaque(false);
        jTextArea.setFocusable(false);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, jTextArea, gridBagConstraints, 0, 1, 2, 1, n, insets2);
        insets2 = new Insets(0, insets.left, 0, insets.right);
        JTextArea jTextArea2 = new JTextArea(this.mWizardDialog.getResString("IDS_EX2DB_VAR_TO_STORE_IN_NEW_TABLE_NOTE2"));
        jTextArea2.setLineWrap(true);
        jTextArea2.setWrapStyleWord(true);
        jTextArea2.setBorder(null);
        jTextArea2.setOpaque(false);
        jTextArea2.setFocusable(false);
        DialogUtil.addUsingGBL(jPanel, jTextArea2, gridBagConstraints, 0, 2, 2, 1, n, insets2);
        return jPanel;
    }

    private void reset() {
        this.mArrowButtonsList.clear();
        this.mExportAsValidRadio.setSelected(true);
        this.mSrcList.getModel().removeAll();
        this.mSrcList.removeListSelectionListener(this);
        this.mSrcList.getModel().removeListDataListener(this);
        this.mSrcList.loadFromActiveDataset();
        this.mSrcList.setSelectedIndex(0);
        StoreInNewTableModel storeInNewTableModel = (StoreInNewTableModel)this.mTable.getModel();
        storeInNewTableModel.removeAllRows();
        for (int i = 0; i < 10; ++i) {
            StoreInNewTableData storeInNewTableData = new StoreInNewTableData();
            storeInNewTableData.setDataType("");
            storeInNewTableData.setDataWidth("");
            storeInNewTableData.setFieldName("");
            storeInNewTableData.setPrimaryKeyCheck(false);
            storeInNewTableData.setVarToSave((ISpssVariable)new SpssVariable());
            storeInNewTableData.setValueLabels(false);
            storeInNewTableModel.addRow(storeInNewTableData);
        }
        this.mDuplicateFieldsMap.clear();
    }

    private void setHeaderImage() {
        ImageIcon imageIcon = ExportToDBUtil.getHeaderImage(this.mWizardDialog);
        this.mImageLabel.setIcon(imageIcon);
    }

    private JPanel setUpMissingValuePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        TitledBorder titledBorder = new TitledBorder(this.mWizardDialog.getResString("IDS_EX2DB_EXPORT_USER_MISSING_VALUES_TITLE_BORDER"));
        jPanel.setBorder(titledBorder);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = new Insets(insets.top, insets.left, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mExportAsValidRadio, gridBagConstraints, 0, 0, 1, 1, n, insets2);
        insets2 = new Insets(insets.top, insets.left, n2, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mExportAsNullAndBlankRadio, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        return jPanel;
    }

    private void loadData() {
        ArrayList<StoreInNewTableData> arrayList = new ArrayList<StoreInNewTableData>();
        for (int i = 0; i < 10; ++i) {
            StoreInNewTableData storeInNewTableData = new StoreInNewTableData();
            storeInNewTableData.setDataType("");
            storeInNewTableData.setDataWidth("");
            storeInNewTableData.setFieldName("");
            storeInNewTableData.setPrimaryKeyCheck(false);
            storeInNewTableData.setVarToSave((ISpssVariable)new SpssVariable());
            storeInNewTableData.setValueLabels(false);
            arrayList.add(storeInNewTableData);
        }
        StoreInNewTableModel storeInNewTableModel = new StoreInNewTableModel(arrayList);
        this.mTable.setModel(storeInNewTableModel);
    }

    private void setupNewTable() {
        this.loadData();
        this.mTable.setRowSelectionAllowed(false);
        this.mTable.setColumnSelectionAllowed(false);
        this.mTable.setCellSelectionEnabled(true);
        this.mTable.setSelectionMode(0);
        ExportToDBToolTipHeader exportToDBToolTipHeader = new ExportToDBToolTipHeader(this.mTable.getColumnModel());
        this.mTable.setTableHeader(exportToDBToolTipHeader);
        String[] stringArray = this.mWizardDialog.getResStringArray("IDS_NEW_TABLE_TOOLTIP_LIST");
        exportToDBToolTipHeader.setToolTipStrings(stringArray);
        exportToDBToolTipHeader.setFont(exportToDBToolTipHeader.getFont().deriveFont(1, 12.0f));
        this.mTableColWidth = new ArrayList();
        this.mTableColWidth.add(120);
        this.mTableColWidth.add(20);
        this.mTableColWidth.add(120);
        this.mTableColWidth.add(70);
        this.mTableColWidth.add(40);
        this.mTableColWidth.add(80);
    }

    private void setupMainTable() {
        this.mMainTable.getColumnModel().getColumn(0).setHeaderValue(this.mWizardDialog.getResString("IDS_EX2DB_VAR_TO_SAVE_COLUMN"));
        this.mMainTable.getColumnModel().getColumn(1).setHeaderValue("");
        this.mMainTable.getColumnModel().getColumn(2).setHeaderValue(this.mWizardDialog.getResString("IDS_EX2DB_FIELD_NAME_COLUMN"));
        this.mMainTable.getColumnModel().getColumn(3).setHeaderValue(this.mWizardDialog.getResString("IDS_EX2DB_TYPE_COLUMN"));
        this.mMainTable.getColumnModel().getColumn(4).setHeaderValue(this.mWizardDialog.getResString("IDS_EX2DB_WIDTH_COLUMN"));
        this.mMainTable.getColumnModel().getColumn(5).setHeaderValue(this.mWizardDialog.getResString("IDS_EX2DB_LABEL_COLUMN"));
        this.mMainTable.getTableHeader().setReorderingAllowed(false);
        this.mMainTable.getColumnModel().getColumn(0).setPreferredWidth(this.mTableColWidth.get(0));
        this.mMainTable.getColumnModel().getColumn(1).setPreferredWidth(this.mTableColWidth.get(1));
        this.mMainTable.getColumnModel().getColumn(1).setMaxWidth(this.mTableColWidth.get(1));
        this.mMainTable.getColumnModel().getColumn(1).setMinWidth(this.mTableColWidth.get(1));
        this.mMainTable.getColumnModel().getColumn(2).setPreferredWidth(this.mTableColWidth.get(2));
        this.mMainTable.getColumnModel().getColumn(3).setPreferredWidth(this.mTableColWidth.get(3));
        this.mMainTable.getColumnModel().getColumn(4).setPreferredWidth(this.mTableColWidth.get(4));
        this.mMainTable.getColumnModel().getColumn(5).setPreferredWidth(this.mTableColWidth.get(5));
        this.mMainTable.setAutoResizeMode(0);
    }

    private void setupFixedTable() {
        this.mArrowButtonsList.clear();
        for (int i = 0; i < this.mFixedTable.getModel().getRowCount(); ++i) {
            NewTablePageArrowButton newTablePageArrowButton = new NewTablePageArrowButton(this.mWizardDialog, ExportToDBArrowButton.ButtonOrientation.right, this.mSrcList, this.mTableScroll);
            this.mArrowButtonsList.add(newTablePageArrowButton);
        }
    }

    private void setRenderersAndEditors() {
        this.mFixedTable.getColumnModel().getColumn(0).setCellRenderer(new ArrowButtonRenderer(this.mMainTable, this.mArrowButtonsList, this.mWizardDialog));
        this.mFixedTable.getColumnModel().getColumn(0).setCellEditor(new ArrowButtonEditor(this.mMainTable, this.mArrowButtonsList, ExportToDBUtil.ExToDBPage.eNewTablePage, this.mWizardDialog));
        this.mMainTable.getColumnModel().getColumn(0).setCellRenderer(new SpssVarRenderer());
        this.mMainTable.getColumnModel().getColumn(1).setCellRenderer(new BooleanRenderer());
        this.mMainTable.getColumnModel().getColumn(1).setHeaderRenderer(new KeyHeaderRenderer());
        this.mMainTable.getColumnModel().getColumn(2).setCellRenderer(new NewTableCellRenderer());
        Vector vector = ExportToDBUtil.getSupportedDataTypes();
        JComboBox jComboBox = new JComboBox(vector);
        jComboBox.setBackground(Color.WHITE);
        jComboBox.setEditable(false);
        if (vector.size() > 20) {
            jComboBox.setMaximumRowCount(20);
        } else {
            jComboBox.setMaximumRowCount(vector.size());
        }
        jComboBox.getModel().addListDataListener(this);
        jComboBox.addFocusListener(this);
        jComboBox.setRenderer(new ToolTipRenderer());
        jComboBox.setSelectedIndex(0);
        this.mMainTable.getColumnModel().getColumn(3).setCellEditor(new DefaultCellEditor(jComboBox));
        this.mMainTable.getColumnModel().getColumn(3).setCellRenderer(new NewTableCellRenderer());
        this.mMainTable.getColumnModel().getColumn(4).setCellRenderer(new VariableWidthColRenderer());
        this.mMainTable.getColumnModel().getColumn(5).setCellRenderer(new BooleanRenderer());
        this.mFixedTable.setRowHeight(jComboBox.getMinimumSize().height - 3);
        this.mMainTable.setRowHeight(jComboBox.getMinimumSize().height - 3);
    }

    private void detectDuplicateNames() {
        StoreInNewTableModel storeInNewTableModel = (StoreInNewTableModel)this.mTable.getModel();
        this.mDuplicateFieldsMap.clear();
        for (int i = 0; i < storeInNewTableModel.getRowCount(); ++i) {
            String string = (String)storeInNewTableModel.getValueAt(i, 3);
            if (string.equals("")) continue;
            if (this.mDuplicateFieldsMap.size() > 0) {
                if (this.mDuplicateFieldsMap.containsKey(string)) {
                    int n = this.mDuplicateFieldsMap.get(string);
                    this.mDuplicateFieldsMap.put(string, n + 1);
                    continue;
                }
                this.mDuplicateFieldsMap.put(string, 0);
                continue;
            }
            this.mDuplicateFieldsMap.put(string, 0);
        }
    }

    private String getDuplicateFieldName() {
        this.detectDuplicateNames();
        Set<String> set = this.mDuplicateFieldsMap.keySet();
        for (String string : set) {
            int n = this.mDuplicateFieldsMap.get(string);
            if (n <= 0) continue;
            return string;
        }
        return null;
    }

    private String getCaseSensitiveDuplicateFields() {
        StoreInNewTableModel storeInNewTableModel = (StoreInNewTableModel)this.mTable.getModel();
        this.mDuplicateFieldsMap.clear();
        for (int i = 0; i < storeInNewTableModel.getRowCount(); ++i) {
            String string = (String)storeInNewTableModel.getValueAt(i, 3);
            if (string.equals("")) continue;
            for (int j = 0; j < storeInNewTableModel.getRowCount(); ++j) {
                String string2;
                if (i == j || (string2 = (String)storeInNewTableModel.getValueAt(j, 3)).equals("") || !string.equalsIgnoreCase(string2)) continue;
                return string + ";" + string2;
            }
        }
        return null;
    }

    private String fieldNotSpecified() {
        this.mIsFieldNameEmpty = false;
        StoreInNewTableModel storeInNewTableModel = (StoreInNewTableModel)this.mTable.getModel();
        for (int i = 0; i < storeInNewTableModel.getRowCount(); ++i) {
            ISpssVariable iSpssVariable = (ISpssVariable)storeInNewTableModel.getValueAt(i, 1);
            String string = iSpssVariable.getName();
            String string2 = (String)storeInNewTableModel.getValueAt(i, 3);
            if (string.equals("") || !string2.trim().equals("")) continue;
            this.mIsFieldNameEmpty = true;
            return string;
        }
        return null;
    }

    private Vector<String> variableNotSpecified() {
        this.mIsVarToSaveEmpty = false;
        Vector<String> vector = new Vector<String>();
        StoreInNewTableModel storeInNewTableModel = (StoreInNewTableModel)this.mTable.getModel();
        for (int i = 0; i < storeInNewTableModel.getRowCount(); ++i) {
            ISpssVariable iSpssVariable = (ISpssVariable)storeInNewTableModel.getValueAt(i, 1);
            String string = iSpssVariable.getName();
            String string2 = (String)storeInNewTableModel.getValueAt(i, 3);
            if (!string.trim().equals("") || string2.equals("")) continue;
            this.mIsVarToSaveEmpty = true;
            vector.add(string2);
        }
        return vector;
    }

    private String checkWidthPositive() {
        StoreInNewTableModel storeInNewTableModel = (StoreInNewTableModel)this.mTable.getModel();
        for (int i = 0; i < storeInNewTableModel.getRowCount(); ++i) {
            String string;
            ISpssVariable iSpssVariable = (ISpssVariable)storeInNewTableModel.getValueAt(i, 1);
            if (iSpssVariable.getName().equals("")) continue;
            String string2 = (String)storeInNewTableModel.getValueAt(i, 4);
            LinkedHashMap<String, Integer> linkedHashMap = ExportToDBData.getExDBData().getSQLNameTypeMapping();
            if (string2 == null || string2.length() <= 0 || linkedHashMap.get(string2) == null || !ExportToDBUtil.isStringType(linkedHashMap.get(string2)) || (string = (String)storeInNewTableModel.getValueAt(i, 5)).length() != 0 && string.charAt(0) != '-' && !string.equals("0") && this.isNumber(string)) continue;
            return iSpssVariable.getName();
        }
        return null;
    }

    private boolean isNumber(String string) {
        boolean bl = true;
        block3: for (int i = 0; i < string.length(); ++i) {
            switch (string.charAt(i)) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    continue block3;
                }
                default: {
                    bl = false;
                }
            }
        }
        return bl;
    }

    private String checkWidthRange() {
        StoreInNewTableModel storeInNewTableModel = (StoreInNewTableModel)this.mTable.getModel();
        for (int i = 0; i < storeInNewTableModel.getRowCount(); ++i) {
            int n;
            ISpssVariable iSpssVariable = (ISpssVariable)storeInNewTableModel.getValueAt(i, 1);
            if (iSpssVariable.getName().equals("")) continue;
            short s = iSpssVariable.getFormat().getWidth();
            String string = (String)storeInNewTableModel.getValueAt(i, 5);
            if (string.equals("") || (n = Integer.parseInt(string)) >= s) continue;
            return iSpssVariable.getName();
        }
        return null;
    }

    private void generateSQLSpec() {
        String string = ExportToDBSyntaxUtil.uniqueTempTableName();
        String string2 = ExportToDBSyntaxUtil.getValidTableName();
        LinkedList<String> linkedList = new LinkedList<String>();
        LinkedList<String> linkedList2 = new LinkedList<String>();
        LinkedList<String> linkedList3 = new LinkedList<String>();
        LinkedList<String> linkedList4 = new LinkedList<String>();
        LinkedList<String> linkedList5 = new LinkedList<String>();
        LinkedList<String> linkedList6 = new LinkedList<String>();
        StoreInNewTableModel storeInNewTableModel = (StoreInNewTableModel)this.mTable.getModel();
        LinkedHashMap<String, Integer> linkedHashMap = ExportToDBData.getExDBData().getSQLNameTypeMapping();
        for (int i = 0; i < storeInNewTableModel.getRowCount(); ++i) {
            ISpssVariable iSpssVariable = (ISpssVariable)storeInNewTableModel.getValueAt(i, 1);
            if (iSpssVariable == null || iSpssVariable.getName().length() <= 0) continue;
            String string3 = iSpssVariable.getName();
            linkedList.add(string3);
            String string4 = (String)storeInNewTableModel.getValueAt(i, 3);
            linkedList2.add(string4);
            boolean bl = (Boolean)storeInNewTableModel.getValueAt(i, 2);
            if (bl) {
                linkedList5.add(string4);
            }
            String string5 = (String)storeInNewTableModel.getValueAt(i, 4);
            linkedList3.add(string5);
            if (ExportToDBUtil.isStringType(linkedHashMap.get(string5))) {
                String string6 = (String)storeInNewTableModel.getValueAt(i, 5);
                linkedList4.add(string6);
            } else {
                linkedList4.add(null);
            }
            boolean bl2 = (Boolean)storeInNewTableModel.getValueAt(i, 6);
            if (!bl2) continue;
            linkedList6.add(string3);
        }
        CreateSQLSpec createSQLSpec = new CreateSQLSpec(string, string2, linkedList, linkedList2, linkedList3, linkedList4, linkedList5, linkedList6);
        ExportToDBSyntaxUtil.setCreateSQLSpec(createSQLSpec);
    }

    private void generateSyntax() {
        this.generateSQLSpec();
        if (this.mExportAsNullAndBlankRadio.isSelected()) {
            ExportToDBSyntaxUtil.setMissingValuesSyntax("RECODE");
        } else {
            ExportToDBSyntaxUtil.setMissingValuesSyntax("IGNORE");
        }
    }

    private String generateCreateCmd() {
        CharSequence charSequence;
        if (ExportToDBData.getExDBData().isDatabase("SQL Server")) {
            charSequence = ExportToDBData.getExDBData().getConnectionString();
            ExportToDBSyntaxUtil.setUseQuotedIdentifiers(!((String)charSequence).contains("QuotedId=No"));
        }
        charSequence = new StringBuffer("");
        StringBuffer stringBuffer = new StringBuffer("");
        StoreInNewTableModel storeInNewTableModel = (StoreInNewTableModel)this.mTable.getModel();
        LinkedHashMap<String, Integer> linkedHashMap = ExportToDBData.getExDBData().getSQLNameTypeMapping();
        ((StringBuffer)charSequence).append(ExportToDBSyntaxUtil.getValidTableName());
        ((StringBuffer)charSequence).append("(");
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = ExportToDBData.getExDBData().isDatabase("DB2");
        boolean bl4 = ExportToDBData.getExDBData().isDatabase("Excel");
        for (int i = 0; i < storeInNewTableModel.getRowCount(); ++i) {
            String string;
            ISpssVariable iSpssVariable = (ISpssVariable)storeInNewTableModel.getValueAt(i, 1);
            if (iSpssVariable == null || iSpssVariable.getName().length() <= 0) continue;
            if (bl) {
                ((StringBuffer)charSequence).append(", ");
            }
            String string2 = (String)storeInNewTableModel.getValueAt(i, 3);
            ((StringBuffer)charSequence).append(ExportToDBSyntaxUtil.getValidColName(string2));
            boolean bl5 = bl4 ? false : (Boolean)storeInNewTableModel.getValueAt(i, 2);
            if (bl5) {
                if (bl2) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(ExportToDBSyntaxUtil.getValidColName(string2));
                bl2 = true;
            }
            if (linkedHashMap.get(string = (String)storeInNewTableModel.getValueAt(i, 4)) != null) {
                int n = linkedHashMap.get(string);
                if (ExportToDBUtil.isStringType(n)) {
                    ((StringBuffer)charSequence).append(" " + string);
                    String string3 = (String)storeInNewTableModel.getValueAt(i, 5);
                    ((StringBuffer)charSequence).append("(" + string3 + ")");
                } else {
                    ((StringBuffer)charSequence).append(" " + string);
                }
                bl = true;
            }
            if (!bl5 || !bl3) continue;
            ((StringBuffer)charSequence).append(" NOT NULL");
        }
        if (stringBuffer.length() > 0) {
            ((StringBuffer)charSequence).append(", primary key(" + stringBuffer + ")");
        }
        ((StringBuffer)charSequence).append(")");
        if (ExportToDBData.getExDBData().isDatabase("Neoview")) {
            ((StringBuffer)charSequence).append(" NO PARTITION");
        }
        return ((StringBuffer)charSequence).toString();
    }

    private ArrayList<String> getFieldNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        StoreInNewTableModel storeInNewTableModel = (StoreInNewTableModel)this.mTable.getModel();
        for (int i = 0; i < storeInNewTableModel.getRowCount(); ++i) {
            ISpssVariable iSpssVariable = (ISpssVariable)storeInNewTableModel.getValueAt(i, 1);
            if (iSpssVariable.getName().length() <= 0) continue;
            String string = (String)storeInNewTableModel.getValueAt(i, 3);
            arrayList.add(string);
        }
        return arrayList;
    }

    private ArrayList<String> getVarNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        StoreInNewTableModel storeInNewTableModel = (StoreInNewTableModel)this.mTable.getModel();
        for (int i = 0; i < storeInNewTableModel.getRowCount(); ++i) {
            ISpssVariable iSpssVariable = (ISpssVariable)storeInNewTableModel.getValueAt(i, 1);
            if (iSpssVariable.getName().length() <= 0) continue;
            arrayList.add(iSpssVariable.getName());
        }
        return arrayList;
    }

    private class ToolTipRenderer
    extends JLabel
    implements ListCellRenderer {
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (object != null && object.toString().length() > 0) {
                if (ComponentState.isBtdRtlOrLtr() && object instanceof String) {
                    this.setText(ComponentState.prepareStringForBidiRendering((String)object.toString()));
                    this.setToolTipText(ComponentState.prepareStringForBidiRendering((String)object.toString()));
                } else {
                    this.setText(object.toString());
                    this.setToolTipText(object.toString());
                }
                if (bl) {
                    this.setBackground(jList.getSelectionBackground());
                    this.setForeground(jList.getSelectionForeground());
                } else {
                    this.setBackground(jList.getBackground());
                    this.setForeground(jList.getForeground());
                }
                this.setOpaque(true);
            }
            return this;
        }

        @Override
        public void setText(String string) {
            if (ComponentState.isBtdRtlOrLtr() && string != null && string.length() > 0) {
                super.setText(ComponentState.prepareStringForBidiRendering((String)string));
            } else {
                super.setText(string);
            }
        }

        @Override
        public void setToolTipText(String string) {
            if (ComponentState.isBtdRtlOrLtr() && string != null && string.length() > 0) {
                super.setToolTipText(ComponentState.prepareStringForBidiRendering((String)string));
            } else {
                super.setToolTipText(string);
            }
        }
    }

    private class NewTableCellRenderer
    extends JLabel
    implements TableCellRenderer {
        private NewTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JLabel jLabel = new JLabel("");
            if (bl2 || bl) {
                jLabel.setBorder(new LineBorder(Color.BLUE));
            }
            if (!bl2) {
                jLabel.setBorder(null);
            }
            if (object != null) {
                if (ComponentState.isBtdRtlOrLtr() && object instanceof String && ((String)object).length() > 0) {
                    jLabel.setText(ComponentState.prepareStringForBidiRendering((String)object.toString()));
                    jLabel.setToolTipText(ComponentState.prepareStringForBidiRendering((String)object.toString()));
                } else {
                    jLabel.setText(object.toString());
                    jLabel.setToolTipText(object.toString());
                }
            }
            return jLabel;
        }
    }

    private class SpssVarRenderer
    extends JLabel
    implements TableCellRenderer {
        private SpssVarRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            ISpssVariable iSpssVariable;
            JLabel jLabel = new JLabel("");
            if (bl2 || bl) {
                jLabel.setBorder(new LineBorder(Color.BLUE));
            }
            if (!bl2) {
                jLabel.setBorder(null);
            }
            if (object != null && (iSpssVariable = (ISpssVariable)object) != null) {
                if (ComponentState.isBtdRtlOrLtr() && iSpssVariable.getName() != null && iSpssVariable.getName().length() > 0) {
                    jLabel.setText(ComponentState.prepareStringForBidiRendering((String)iSpssVariable.getName()));
                    jLabel.setToolTipText(ComponentState.prepareStringForBidiRendering((String)iSpssVariable.getName()));
                } else {
                    jLabel.setText(iSpssVariable.getName());
                    jLabel.setToolTipText(iSpssVariable.getName());
                }
            }
            return jLabel;
        }
    }

    private class KeyHeaderRenderer
    extends JLabel
    implements TableCellRenderer,
    UIResource {
        private KeyHeaderRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            ImageIcon imageIcon = new ImageIcon(StoreVarsInNewTablePage.this.mWizardDialog.getResImageURL("IDS_EX2DB_PRIMARY_KEY_IMG"));
            JLabel jLabel = new JLabel("");
            jLabel.setIcon(imageIcon);
            return jLabel;
        }
    }

    private class BooleanRenderer
    extends JCheckBox
    implements TableCellRenderer,
    UIResource {
        public BooleanRenderer() {
            this.setHorizontalAlignment(0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setEnabled(!StoreVarsInNewTablePage.this.mIsExcel);
            if (bl) {
                this.setForeground(jTable.getSelectionForeground());
                super.setBackground(jTable.getBackground());
                this.setBorder(new LineBorder(Color.blue));
            } else {
                this.setForeground(jTable.getForeground());
                this.setBackground(jTable.getBackground());
                this.setBorder(new EmptyBorder(1, 1, 1, 1));
            }
            if (!StoreVarsInNewTablePage.this.mIsExcel) {
                StoreInNewTableModel storeInNewTableModel;
                ISpssVariable iSpssVariable;
                this.setSelected(object != null && (Boolean)object != false);
                if (n2 == 5 && (iSpssVariable = (ISpssVariable)(storeInNewTableModel = (StoreInNewTableModel)jTable.getModel()).getValueAt(n, 1)) != null) {
                    boolean bl3 = iSpssVariable.getValueLabels().size() > 0;
                    boolean bl4 = false;
                    switch (iSpssVariable.getFormat().getFormatType()) {
                        case A: 
                        case AHEX: 
                        case F: 
                        case COMMA: 
                        case DOT: 
                        case PERCENT: 
                        case E: 
                        case CCA: 
                        case CCB: 
                        case CCC: 
                        case CCD: 
                        case CCE: 
                        case DOLLAR: {
                            bl4 = bl3;
                            break;
                        }
                    }
                    this.setEnabled(bl4);
                }
            }
            return this;
        }
    }

    private class VariableWidthColRenderer
    extends JTextField
    implements TableCellRenderer {
        private JTextField mTextField;

        private VariableWidthColRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            StoreInNewTableModel storeInNewTableModel;
            this.mTextField = new JTextField("");
            if (bl2 || bl) {
                this.mTextField.setBorder(new LineBorder(Color.BLUE));
            }
            if (!bl2) {
                this.mTextField.setBorder(BorderFactory.createEtchedBorder());
            }
            if ((storeInNewTableModel = (StoreInNewTableModel)jTable.getModel()).isCellEditable(n, 5)) {
                String string = (String)storeInNewTableModel.getValueAt(n, 5);
                this.mTextField.setText(string);
                this.mTextField.setToolTipText(string);
            } else {
                this.mTextField.setEditable(false);
                this.mTextField.setEnabled(false);
            }
            return this.mTextField;
        }
    }
}

