/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.file.export_to_db.store_vars_new_fields;

import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.SpssVariable;
import com.spss.java_client.ui.dialogs.base.file.export_to_db.ExportToDBData;
import com.spss.java_client.ui.dialogs.base.file.export_to_db.store_vars_new_fields.StoreVarsInNewFieldTableData;
import com.spss.java_client.ui.dialogs.base.file.export_to_db.utilities.ExportToDBUtil;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import javax.swing.JComboBox;
import javax.swing.table.AbstractTableModel;

public class StoreVarsInNewFieldTableModel
extends AbstractTableModel {
    private static final int COLUMN_COUNT = 6;
    private ArrayList<StoreVarsInNewFieldTableData> mDataList;

    public StoreVarsInNewFieldTableModel() {
    }

    public StoreVarsInNewFieldTableModel(ArrayList<StoreVarsInNewFieldTableData> arrayList) {
        this.mDataList = arrayList;
    }

    @Override
    public Class<?> getColumnClass(int n) {
        if (n == 3) {
            return JComboBox.class;
        }
        if (n == 5) {
            return Boolean.class;
        }
        return super.getColumnClass(n);
    }

    @Override
    public int getColumnCount() {
        return 6;
    }

    @Override
    public int getRowCount() {
        if (this.mDataList != null) {
            return this.mDataList.size();
        }
        return 0;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (this.mDataList != null) {
            switch (n2) {
                case 1: {
                    ISpssVariable iSpssVariable = this.mDataList.get(n).getSourceOfValue();
                    if (iSpssVariable != null) {
                        return iSpssVariable;
                    }
                    return new SpssVariable();
                }
                case 2: {
                    return this.mDataList.get(n).getFieldName();
                }
                case 3: {
                    return this.mDataList.get(n).getDataType().toLowerCase();
                }
                case 4: {
                    return this.mDataList.get(n).getDataWidth();
                }
                case 5: {
                    return this.mDataList.get(n).isValueLabels();
                }
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        if (this.mDataList.get(n).isExisting()) {
            return false;
        }
        if (n2 == 1) {
            return false;
        }
        if (n2 == 4) {
            LinkedHashMap<String, Integer> linkedHashMap = ExportToDBData.getExDBData().getSQLNameTypeMapping();
            String string = this.getValueAt(n, 3).toString();
            if (string != null && string.length() > 0) {
                return ExportToDBUtil.isStringType(linkedHashMap.get(string));
            }
            return false;
        }
        if (n2 == 5) {
            ISpssVariable iSpssVariable = (ISpssVariable)this.getValueAt(n, 1);
            boolean bl = iSpssVariable.getValueLabels().size() > 0;
            boolean bl2 = false;
            switch (iSpssVariable.getFormat().getFormatType()) {
                case A: 
                case AHEX: 
                case F: 
                case COMMA: 
                case DOT: 
                case PERCENT: 
                case E: 
                case CCA: 
                case CCB: 
                case CCC: 
                case CCD: 
                case CCE: 
                case DOLLAR: {
                    bl2 = bl;
                    break;
                }
            }
            return bl2;
        }
        return true;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        if (this.mDataList != null) {
            switch (n2) {
                case 1: {
                    this.mDataList.get(n).setSourceOfValue((ISpssVariable)object);
                    break;
                }
                case 2: {
                    this.mDataList.get(n).setFieldName((String)object);
                    break;
                }
                case 3: {
                    String string = this.mDataList.get(n).getDataType();
                    String string2 = object.toString();
                    if (!string2.equals(string)) {
                        this.mDataList.get(n).setValueLabels(false);
                    }
                    this.mDataList.get(n).setDataType(string2);
                    break;
                }
                case 4: {
                    this.mDataList.get(n).setDataWidth((String)object);
                    break;
                }
                case 5: {
                    boolean bl = (Boolean)object;
                    ISpssVariable iSpssVariable = (ISpssVariable)this.getValueAt(n, 1);
                    ExportToDBUtil.getDefaultDataType(iSpssVariable, bl);
                    String string = ExportToDBUtil.getDefaultType();
                    this.mDataList.get(n).setDataType(string);
                    String string3 = ExportToDBUtil.getWidth(iSpssVariable, bl);
                    this.mDataList.get(n).setDataWidth(string3);
                    this.mDataList.get(n).setValueLabels(bl);
                    this.fireTableDataChanged();
                }
            }
        }
        this.fireTableCellUpdated(n, n2);
    }

    public void addRow(ArrayList<StoreVarsInNewFieldTableData> arrayList) {
        this.mDataList = arrayList;
        this.fireTableDataChanged();
    }

    public void addRow(StoreVarsInNewFieldTableData storeVarsInNewFieldTableData) {
        int n = this.mDataList.size();
        this.mDataList.add(storeVarsInNewFieldTableData);
        this.fireTableRowsInserted(n + 1, n + 1);
    }
}

