/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.file.export_to_db.select_table_view;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.data_access.ODBC.ODBCDacProxy;
import com.spss.java_client.core.server.messages.DataAccess.odbcmsg.ColumnsInfo;
import com.spss.java_client.core.server.messages.DataAccess.odbcmsg.TablesInfo;
import com.spss.java_client.ui.dialogs.base.file.export_to_db.AbstractExportToDBPage;
import com.spss.java_client.ui.dialogs.base.file.export_to_db.ExportToDBData;
import com.spss.java_client.ui.dialogs.base.file.export_to_db.ExportToDBDlg;
import com.spss.java_client.ui.dialogs.base.file.export_to_db.utilities.ExportToDBUtil;
import com.spss.java_client.ui.dialogs.common.BaseWizardDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SelectTableOrViewPage
extends AbstractExportToDBPage
implements ItemListener,
ListDataListener,
ListSelectionListener {
    ArrayList<TableData> mTableInfo;
    ArrayList<TableData> mTableEntries;
    private ColumnsInfo mColumnsInfo;
    private JLabel mDataBaseName;
    private JLabel mHeadLabel;
    private JLabel mImageLabel;
    private JList mList;
    private DialogFocusTraversalPolicy mPolicy;
    private String mSelectedTable;
    private JCheckBox mSynonymsCheckBox;
    private JCheckBox mSystemTableCheckBox;
    private JCheckBox mTableCheckBox;
    private JCheckBox mViewCheckBox;
    private DefaultListModel mListModel;
    private boolean mEnableFinish;
    private String mInitialSelection;
    private JScrollPane mScroll;

    public SelectTableOrViewPage(BaseWizardDialog baseWizardDialog) {
        super("SelectTableOrViewPage", baseWizardDialog, true);
    }

    @Override
    public String getDialogHelpID() {
        return "idh_idd_exdb_page_select_table";
    }

    @Override
    public String getNextPage() {
        ExportToDBUtil.ExportToDBOptions exportToDBOptions = ExportToDBUtil.getExToDBSelectedOption();
        if (ExportToDBUtil.isFilterOn()) {
            return "SelectCasesToExportPage";
        }
        if (exportToDBOptions == ExportToDBUtil.ExportToDBOptions.eReplaceValExisitngFields || exportToDBOptions == ExportToDBUtil.ExportToDBOptions.eAddFieldsToExistingTable) {
            return "MatchCasesToRecordsPage";
        }
        if (exportToDBOptions == ExportToDBUtil.ExportToDBOptions.eAppendNewRecordToExistingTable) {
            return "StoreVarsInNewRecordsPage";
        }
        if (exportToDBOptions == ExportToDBUtil.ExportToDBOptions.eDropAndCreateNewTable) {
            return "StoreVarsInNewTablePage";
        }
        return null;
    }

    @Override
    public boolean hasNextPage() {
        return true;
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.mWizardDialog.enableNext(this.mList.getModel().getSize() > 0);
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.mWizardDialog.enableNext(this.mList.getModel().getSize() > 0);
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
    }

    @Override
    public boolean isLastPage() {
        return false;
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.loadTableWiseData();
    }

    @Override
    public boolean validate() {
        Object object;
        Object object22;
        String string = this.mList.getSelectedValue().toString();
        ODBCDacProxy oDBCDacProxy = ODBCDacProxy.getODBCDacProxy();
        ODBCDacProxy.SqlReturnCode sqlReturnCode = new ODBCDacProxy.SqlReturnCode(oDBCDacProxy);
        ColumnsInfo columnsInfo = new ColumnsInfo();
        TablesInfo tablesInfo = ExportToDBData.getExDBData().getTablesInfo();
        for (Object object22 : tablesInfo.getTableCols()) {
            String string2 = object22.getQualifier();
            if (string2 != null && string2.length() > 0) {
                String string3 = ExportToDBData.getExDBData().getWizardCapabities().getStrDBMSName().toUpperCase();
                if ((string3.contains("EXCEL") || string3.contains("ACCESS") || string3.contains("INFORMIX")) && !string3.contains("OPENACCESS")) {
                    string2 = "";
                }
            } else {
                string2 = "";
            }
            object22.setQualifier(string2);
            if (!object22.getFullQualifiedName().equals(string)) continue;
            ODBCDacProxy.getODBCDacProxy().getColumns(object22.getName(), object22.getOwner(), object22.getQualifier(), object22.getName(), columnsInfo, sqlReturnCode, true);
            if (sqlReturnCode.getSqlCode() != 0) continue;
            this.mColumnsInfo = columnsInfo;
        }
        if (this.mColumnsInfo == null) {
            object = String.format(this.mWizardDialog.getResString("ERR_TABLE_HAS_NO_COLUMN"), string);
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this.mWizardDialog), (String)object, VersionInfo.getAppVersionString());
            this.mList.requestFocus();
            return false;
        }
        ExportToDBData.getExDBData().setColumnsInfo(this.mColumnsInfo);
        object = this.mList.getSelectedValue().toString();
        ExportToDBUtil.setNewTableName((String)object);
        if ((String)this.mList.getSelectedValue() != null && this.mSelectedTable != null && !this.mSelectedTable.equals(object22 = (String)this.mList.getSelectedValue())) {
            ExportToDBUtil.setReset(true);
        }
        ExportToDBUtil.setFinishEnabled(((JButton)ExportToDBUtil.getComponentAt(2)).isEnabled());
        return true;
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.mWizardDialog.enableNext(this.mList.getSelectedIndex() != -1);
        if (ExportToDBUtil.isFinishEnabled()) {
            if (this.mInitialSelection != null) {
                this.mEnableFinish = this.mInitialSelection.equals(this.mList.getSelectedValue());
            }
            this.mWizardDialog.enableFinish(this.mEnableFinish);
        }
    }

    @Override
    protected void aboutToHidePanel() {
        ExportToDBUtil.setExToDBWizardPreviousPage(ExportToDBUtil.ExToDBWizardPreviousPage.eSelectTableOrViewPage);
        ExportToDBUtil.setFinishEnabled(this.mEnableFinish);
    }

    @Override
    protected void aboutToShowPanel() {
        this.mEnableFinish = ExportToDBUtil.isFinishEnabled();
        this.mDataBaseName.setText(ExportToDBData.getExDBData().getDSNName());
        this.setHeaderImage();
        this.mTableCheckBox.removeItemListener(this);
        this.mViewCheckBox.removeItemListener(this);
        this.mSystemTableCheckBox.removeItemListener(this);
        this.mSynonymsCheckBox.removeItemListener(this);
        this.mList.removeListSelectionListener(this);
        this.mList.getModel().removeListDataListener(this);
        if (ExportToDBUtil.getExToDBWizardPreviousPage() == ExportToDBUtil.ExToDBWizardPreviousPage.eHowToExportDataPage && ExportToDBUtil.isReset()) {
            this.reset();
        }
        if (ExportToDBUtil.getExToDBWizardPreviousPage() != ExportToDBUtil.ExToDBWizardPreviousPage.eHowToExportDataPage && ExportToDBUtil.getExToDBWizardPreviousPage() != ExportToDBUtil.ExToDBWizardPreviousPage.eWelcome) {
            ExportToDBUtil.setReset(false);
        }
        this.mWizardDialog.setFocusTraversalPolicy(this.mPolicy);
        this.mTableCheckBox.addItemListener(this);
        this.mViewCheckBox.addItemListener(this);
        this.mSystemTableCheckBox.addItemListener(this);
        this.mSynonymsCheckBox.addItemListener(this);
        this.mList.addListSelectionListener(this);
        this.mList.getModel().addListDataListener(this);
        this.mWizardDialog.enableFinish(this.mEnableFinish);
        this.mWizardDialog.enableNext(this.mList.getModel().getSize() > 0);
        this.mSelectedTable = this.mInitialSelection = (String)this.mList.getSelectedValue();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SelectTableOrViewPage.this.mList.requestFocusInWindow();
            }
        });
    }

    @Override
    protected void initVars() {
        this.mImageLabel = new JLabel("");
        this.mImageLabel.setIcon(new ImageIcon());
        this.mDataBaseName = new JLabel("");
        this.mListModel = new DefaultListModel();
        this.mList = new JList();
        this.mList.setLayoutOrientation(1);
        this.mList.setVisibleRowCount(18);
        this.mList.setModel(this.mListModel);
        this.mList.setSelectionMode(0);
        this.mList.getModel().addListDataListener(this);
        this.mList.addListSelectionListener(this);
        this.mTableCheckBox = new JCheckBox(new ToggleButtonAction(this.mWizardDialog, "IDS_EX2DB_TABLE_CHECK"));
        this.mViewCheckBox = new JCheckBox(new ToggleButtonAction(this.mWizardDialog, "IDS_EX2DB_VIEWS_CHECK"));
        this.mSynonymsCheckBox = new JCheckBox(new ToggleButtonAction(this.mWizardDialog, "IDS_EX2DB_SYNONYMS_CHECK"));
        this.mSystemTableCheckBox = new JCheckBox(new ToggleButtonAction(this.mWizardDialog, "IDS_EX2DB_SYSTEM_TABLES_CHECK"));
        this.mTableCheckBox.setSelected(true);
        this.mTableCheckBox.addItemListener(this);
        this.mViewCheckBox.addItemListener(this);
        this.mSynonymsCheckBox.addItemListener(this);
        this.mSystemTableCheckBox.addItemListener(this);
        this.mSelectedTable = new String("");
        this.mInitialSelection = new String("");
        this.mTableInfo = new ArrayList();
        this.mTableEntries = new ArrayList();
        this.mWizardDialog.enableFinish(false);
    }

    @Override
    protected boolean isLowerHorizontalBarPresent() {
        return true;
    }

    @Override
    protected boolean isTopHorizontalBarPresent() {
        return true;
    }

    @Override
    protected void setTabTraversalOrder() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mList);
        vector.add(this.mTableCheckBox);
        vector.add(this.mViewCheckBox);
        vector.add(this.mSynonymsCheckBox);
        vector.add(this.mSystemTableCheckBox);
        Vector<Object> vector2 = ((ExportToDBDlg)this.mWizardDialog).getTabTraversal(vector);
        this.mPolicy = new DialogFocusTraversalPolicy(vector2, false);
    }

    @Override
    protected JPanel setupPageBody() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = new Insets(insets.left, insets.left, insets.bottom, insets.right);
        JLabel jLabel = DialogUtil.createLabel(this.mWizardDialog, "IDS_EX2DB_TABLES_AND_VIEW_LIST_LABEL");
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.mScroll = new JScrollPane(this.mList);
        jLabel.setLabelFor(this.mList);
        DialogUtil.addUsingGBL(jPanel, this.mScroll, gridBagConstraints, 0, 2, 5, 1, n, insets2);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        jLabel = new JLabel(this.mWizardDialog.getResString("IDS_EX2DB_SHOW_LABEL"));
        insets2 = new Insets(0, insets.left, 2 * n2, insets.right);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 3, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, this.mTableCheckBox, gridBagConstraints, 1, 3, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, this.mViewCheckBox, gridBagConstraints, 2, 3, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, this.mSynonymsCheckBox, gridBagConstraints, 3, 3, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, this.mSystemTableCheckBox, gridBagConstraints, 4, 3, 1, 1, n, insets2);
        insets2 = new Insets(0, insets.left, 0, insets.right);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        return jPanel;
    }

    @Override
    protected JPanel setupPageHeader() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = new Insets(n2, insets.left, 0, insets.right);
        this.mHeadLabel = DialogUtil.createLabel(this.mWizardDialog, "IDS_EX2DB_SELECT_TABLE_OR_VIEW_HEADING");
        this.mHeadLabel.setFont(this.mHeadLabel.getFont().deriveFont(1, 20.0f));
        DialogUtil.addUsingGBL(jPanel, this.mHeadLabel, gridBagConstraints, 0, 0, 2, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        n = 24;
        DialogUtil.addUsingGBL(jPanel, this.mImageLabel, gridBagConstraints, 0, 0, 2, 2, n, insets2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        n = 23;
        JLabel jLabel = new JLabel(this.mWizardDialog.getResString("IDS_EX2DB_CONNECT_TO_DATABASE"));
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 1, 2, 1, n, insets2);
        FontMetrics fontMetrics = jLabel.getFontMetrics(jLabel.getFont());
        int n3 = fontMetrics.stringWidth(jLabel.getText());
        insets2 = new Insets(n2, n3 + 3, 0, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mDataBaseName, gridBagConstraints, 0, 1, 2, 1, n, insets2);
        return jPanel;
    }

    private void loadTablesInfoList() {
        this.mTableInfo.clear();
        this.mListModel.clear();
        TablesInfo tablesInfo = ExportToDBData.getExDBData().getTablesInfo();
        Vector vector = tablesInfo.getTableCols();
        for (TablesInfo.InternalTableInfo internalTableInfo : vector) {
            Object object;
            String string = internalTableInfo.getQualifier();
            if (string != null && string.length() > 0) {
                object = ExportToDBData.getExDBData().getWizardCapabities().getStrDBMSName().toUpperCase();
                if ((((String)object).contains("EXCEL") || ((String)object).contains("ACCESS") || ((String)object).contains("INFORMIX")) && !((String)object).contains("OPENACCESS")) {
                    string = "";
                }
            } else {
                string = "";
            }
            object = new TableData(string, internalTableInfo.getOwner(), internalTableInfo.getName());
            this.mTableInfo.add((TableData)object);
        }
    }

    private void setInitialSelection() {
        if (this.mSelectedTable != null) {
            if (this.mSelectedTable.length() > 0) {
                if (this.mListModel.contains(this.mSelectedTable)) {
                    this.mList.setSelectedValue(this.mSelectedTable, true);
                } else {
                    this.mList.setSelectedIndex(0);
                }
            }
        } else if (this.mListModel.getSize() > 0) {
            this.mList.setSelectedIndex(0);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void loadTableWiseData() {
        String string;
        int n;
        this.mTableEntries.clear();
        this.mSelectedTable = (String)this.mList.getSelectedValue();
        this.mListModel.clear();
        ExportToDBUtil.getTableOwnerMap().clear();
        if (this.mTableCheckBox.isSelected()) {
            for (n = 0; n < this.mTableInfo.size(); ++n) {
                void charSequence2;
                string = this.mTableInfo.get(n).getOwnerName();
                String string2 = "";
                if (string.length() > 0) {
                    String string3 = string + "." + this.mTableInfo.get(n).getTableName();
                } else {
                    String string4 = this.mTableInfo.get(n).getTableName();
                }
                if (!ExportToDBUtil.isUserTable((String)charSequence2)) continue;
                this.mTableEntries.add(this.mTableInfo.get(n));
            }
        }
        if (this.mViewCheckBox.isSelected()) {
            for (n = 0; n < this.mTableInfo.size(); ++n) {
                void var3_15;
                string = this.mTableInfo.get(n).getOwnerName();
                String string5 = "";
                if (string.length() > 0) {
                    String string6 = string + "." + this.mTableInfo.get(n).getTableName();
                } else {
                    String string7 = this.mTableInfo.get(n).getTableName();
                }
                if (!ExportToDBUtil.isViewTable((String)var3_15)) continue;
                this.mTableEntries.add(this.mTableInfo.get(n));
            }
        }
        if (this.mSynonymsCheckBox.isSelected()) {
            for (n = 0; n < this.mTableInfo.size(); ++n) {
                void var3_20;
                string = this.mTableInfo.get(n).getOwnerName();
                String string8 = "";
                if (string.length() > 0) {
                    String string9 = string + "." + this.mTableInfo.get(n).getTableName();
                } else {
                    String string10 = this.mTableInfo.get(n).getTableName();
                }
                if (!ExportToDBUtil.isSynonymsTable((String)var3_20)) continue;
                this.mTableEntries.add(this.mTableInfo.get(n));
            }
        }
        if (this.mSystemTableCheckBox.isSelected()) {
            for (n = 0; n < this.mTableInfo.size(); ++n) {
                void var3_25;
                string = this.mTableInfo.get(n).getOwnerName();
                String string11 = "";
                if (string.length() > 0) {
                    String string12 = string + "." + this.mTableInfo.get(n).getTableName();
                } else {
                    String string13 = this.mTableInfo.get(n).getTableName();
                }
                if (!ExportToDBUtil.isSystemTable((String)var3_25)) continue;
                this.mTableEntries.add(this.mTableInfo.get(n));
            }
        }
        for (n = 0; n < this.mTableEntries.size(); ++n) {
            boolean bl = false;
            if (this.mTableEntries.get(n) == null) continue;
            StringBuffer stringBuffer = new StringBuffer();
            if (!this.mTableEntries.get(n).getQualifier().equals("")) {
                stringBuffer.append(this.mTableEntries.get(n).getQualifier());
            }
            if (!this.mTableEntries.get(n).getOwnerName().equals("")) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(".");
                }
                String string14 = this.mTableEntries.get(n).getOwnerName();
                stringBuffer.append(string14);
                bl = true;
            }
            if (this.mTableEntries.get(n).getTableName().equals("")) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.append(".");
            }
            stringBuffer.append(this.mTableEntries.get(n).getTableName());
            this.mListModel.add(n, stringBuffer.toString());
            ExportToDBUtil.getTableOwnerMap().put(stringBuffer.toString(), bl);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.mListModel.size(); ++i) {
            arrayList.add((String)this.mListModel.get(i));
        }
        Collections.sort(arrayList, new ListComparator());
        this.mListModel.clear();
        for (String string15 : arrayList) {
            this.mListModel.addElement(string15);
        }
        this.mList.setModel(this.mListModel);
        this.setInitialSelection();
    }

    private void loadCheckBoxState() {
        this.mSystemTableCheckBox.setSelected(ExportToDBData.getExDBData().getWizardCapabities().getStrDBMSName().equals("EXCEL"));
        boolean bl = ExportToDBUtil.getExToDBSelectedOption() == ExportToDBUtil.ExportToDBOptions.eDropAndCreateNewTable || ExportToDBUtil.getExToDBSelectedOption() == ExportToDBUtil.ExportToDBOptions.eAddFieldsToExistingTable;
        this.mViewCheckBox.setSelected(false);
        this.mViewCheckBox.setEnabled(!bl);
    }

    private void reset() {
        this.mTableCheckBox.setSelected(true);
        this.mSynonymsCheckBox.setSelected(false);
        this.mSelectedTable = "";
        this.loadCheckBoxState();
        this.loadTablesInfoList();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    SelectTableOrViewPage.this.loadTableWiseData();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                SelectTableOrViewPage.this.setInitialSelection();
                ExportToDBUtil.setFinishEnabled(false);
            }
        });
    }

    private void setHeaderImage() {
        ImageIcon imageIcon = ExportToDBUtil.getHeaderImage(this.mWizardDialog);
        this.mImageLabel.setIcon(imageIcon);
    }

    private class ListComparator
    implements Comparator {
        private ListComparator() {
        }

        public int compare(Object object, Object object2) {
            if (object instanceof String && object2 instanceof String) {
                String string = (String)object;
                String string2 = (String)object2;
                if (string.startsWith("'")) {
                    string = string.substring(1);
                }
                if (string2.startsWith("'")) {
                    string2 = string2.substring(1);
                }
                return string.compareToIgnoreCase(string2);
            }
            return -1;
        }
    }

    public class TableData {
        private String mQualifier;
        private String mOwnerName;
        private String mTableName;

        public TableData(String string, String string2, String string3) {
            this.mQualifier = string;
            this.mOwnerName = string2;
            this.mTableName = string3;
        }

        public String getOwnerName() {
            return this.mOwnerName;
        }

        public void setOwnerName(String string) {
            this.mOwnerName = string;
        }

        public String getTableName() {
            return this.mTableName;
        }

        public void setTableName(String string) {
            this.mTableName = string;
        }

        public String getQualifier() {
            return this.mQualifier;
        }
    }
}

