/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.file.export_to_db.select_cases_to_export;

import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.base.file.export_to_db.AbstractExportToDBPage;
import com.spss.java_client.ui.dialogs.base.file.export_to_db.ExportToDBDlg;
import com.spss.java_client.ui.dialogs.base.file.export_to_db.utilities.ExportToDBSyntaxUtil;
import com.spss.java_client.ui.dialogs.base.file.export_to_db.utilities.ExportToDBUtil;
import com.spss.java_client.ui.dialogs.common.BaseWizardDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;

public class SelectCasesToExportPage
extends AbstractExportToDBPage {
    private JLabel mImageLabel;
    private DialogFocusTraversalPolicy mPolicy;
    private SpssButtonGroup mRadioButtonGroup;
    private JRadioButton mAllCasesRadio;
    private JRadioButton mFilteredCasesRadio;

    public SelectCasesToExportPage(BaseWizardDialog baseWizardDialog) {
        super("SelectCasesToExportPage", baseWizardDialog, true);
    }

    @Override
    public String getDialogHelpID() {
        return "idh_idd_exdb_page_select_cases";
    }

    @Override
    public String getNextPage() {
        ExportToDBUtil.ExportToDBOptions exportToDBOptions = ExportToDBUtil.getExToDBSelectedOption();
        if (exportToDBOptions == ExportToDBUtil.ExportToDBOptions.eReplaceValExisitngFields || exportToDBOptions == ExportToDBUtil.ExportToDBOptions.eAddFieldsToExistingTable) {
            return "MatchCasesToRecordsPage";
        }
        if (exportToDBOptions == ExportToDBUtil.ExportToDBOptions.eAppendNewRecordToExistingTable) {
            return "StoreVarsInNewRecordsPage";
        }
        if (exportToDBOptions == ExportToDBUtil.ExportToDBOptions.eDropAndCreateNewTable || exportToDBOptions == ExportToDBUtil.ExportToDBOptions.eCreateNewTable) {
            return "StoreVarsInNewTablePage";
        }
        return null;
    }

    @Override
    public boolean hasNextPage() {
        return true;
    }

    @Override
    public boolean isLastPage() {
        return false;
    }

    @Override
    public boolean validate() {
        this.generateSyntax();
        if (this.mAllCasesRadio.isSelected()) {
            ExportToDBUtil.setCasesToExportString(this.mWizardDialog.getResString("IDS_ALL_CASES_TO_EXPORT_LABEL"));
        } else {
            ExportToDBUtil.setCasesToExportString(this.mWizardDialog.getResString("IDS_FILTERED_CASES_TO_EXPORT_LABEL"));
        }
        return true;
    }

    @Override
    protected void aboutToHidePanel() {
        ExportToDBUtil.setExToDBWizardPreviousPage(ExportToDBUtil.ExToDBWizardPreviousPage.eSelectCasesToExportPage);
    }

    @Override
    protected void aboutToShowPanel() {
        if (ExportToDBUtil.getExToDBWizardPreviousPage() == ExportToDBUtil.ExToDBWizardPreviousPage.eMatchCasesToRecordsPage) {
            ExportToDBUtil.setReset(false);
        }
        this.setHeaderImage();
        this.mWizardDialog.setFocusTraversalPolicy(this.mPolicy);
        this.mWizardDialog.enableFinish(ExportToDBUtil.isFinishEnabled());
        if (this.mAllCasesRadio.isSelected()) {
            this.mAllCasesRadio.requestFocusInWindow();
        } else {
            this.mFilteredCasesRadio.requestFocusInWindow();
        }
    }

    @Override
    protected void initVars() {
        this.mImageLabel = new JLabel("");
        this.mImageLabel.setIcon(new ImageIcon());
        this.mRadioButtonGroup = new SpssButtonGroup();
        this.mAllCasesRadio = new JRadioButton(new ToggleButtonAction(this.mWizardDialog, "IDS_EX2DB_SELECT_CASES_ALL_CASES_RADIO"));
        this.mFilteredCasesRadio = new JRadioButton(new ToggleButtonAction(this.mWizardDialog, "IDS_EX2DB_SELECT_CASES_FILTERED_CASES_RADIO"));
        this.mRadioButtonGroup.add(this.mAllCasesRadio);
        this.mRadioButtonGroup.add(this.mFilteredCasesRadio);
        this.mAllCasesRadio.setSelected(true);
    }

    @Override
    protected boolean isLowerHorizontalBarPresent() {
        return false;
    }

    @Override
    protected boolean isTopHorizontalBarPresent() {
        return false;
    }

    @Override
    protected void setTabTraversalOrder() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mRadioButtonGroup);
        Vector<Object> vector2 = ((ExportToDBDlg)this.mWizardDialog).getTabTraversal(vector);
        this.mPolicy = new DialogFocusTraversalPolicy(vector2, false);
    }

    @Override
    protected JPanel setupPageBody() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        TitledBorder titledBorder = new TitledBorder(this.mWizardDialog.getResString("IDS_EX2DB_SELECT_CASES_TO_EXPORT_TITLE_BORDER"));
        jPanel.setBorder(titledBorder);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = new Insets(0, insets.left, n2, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mAllCasesRadio, gridBagConstraints, 0, 0, 2, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, this.mFilteredCasesRadio, gridBagConstraints, 0, 2, 2, 1, n, insets2);
        ImageIcon imageIcon = new ImageIcon(this.mWizardDialog.getResImageURL("IDS_EX2DB_SELECT_CASES_ALL_CASES_IMG"));
        JLabel jLabel = new JLabel("");
        jLabel.setIcon(imageIcon);
        insets2 = new Insets(n2, insets.left, n2, insets.right);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 1, 2, 1, n, insets2);
        gridBagConstraints.weighty = 1.0;
        imageIcon = new ImageIcon(this.mWizardDialog.getResImageURL("IDS_EX2DB_SELECT_CASES_FILTERED_CASES_IMG"));
        jLabel = new JLabel("");
        jLabel.setIcon(imageIcon);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 3, 2, 1, n, insets2);
        return jPanel;
    }

    @Override
    protected JPanel setupPageHeader() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = new Insets(0, insets.left, n2, insets.right);
        JLabel jLabel = DialogUtil.createLabel(this.mWizardDialog, "IDS_EX2DB_SELECT_CASES_TO_EXPORT_HEADING");
        jLabel.setFont(jLabel.getFont().deriveFont(1, 20.0f));
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 2, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        n = 24;
        DialogUtil.addUsingGBL(jPanel, this.mImageLabel, gridBagConstraints, 0, 0, 2, 2, n, insets2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        n = 23;
        JLabel jLabel2 = new JLabel(this.mWizardDialog.getResString("IDS_EX2DB_SELECT_CASES_TO_EXPORT_NOTE"));
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 0, 1, 2, 1, n, insets2);
        return jPanel;
    }

    private void setHeaderImage() {
        ImageIcon imageIcon = ExportToDBUtil.getHeaderImage(this.mWizardDialog);
        this.mImageLabel.setIcon(imageIcon);
    }

    private void generateSyntax() {
        if (this.mAllCasesRadio.isSelected()) {
            ExportToDBSyntaxUtil.setSelectCasesSyntax("RETAIN");
        } else {
            ExportToDBSyntaxUtil.setSelectCasesSyntax("DELETE");
        }
    }
}

