/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.file.export_to_db.match_cases_to_records;

import com.spss.java_client.ui.controls.SrcVariableList;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.geom.Line2D;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class JConnector
extends JComponent
implements AdjustmentListener {
    private static final int s_Dir_1 = 1;
    private static final int s_Dir_2 = 2;
    private int m_LineDirection;
    private SrcVariableList mComp1;
    private JTable mComp2;
    private transient Line2D mConLine1;
    private transient Line2D mConLine2;
    private transient Line2D mLinUnion;
    private JPanel mPanel;
    private Point mPtOrigin;
    private Point mPtTarget;
    private transient boolean mSelected;
    private int mSrcCol;
    private JScrollPane mSrcScroll;
    private int mtargetCol;
    private JScrollPane mTargetScroll;

    public JConnector(SrcVariableList srcVariableList, JTable jTable, int n, int n2, JScrollPane jScrollPane, JScrollPane jScrollPane2, JPanel jPanel) {
        this.mComp1 = srcVariableList;
        this.mComp2 = jTable;
        this.mSrcCol = n;
        this.mtargetCol = n2;
        this.mSrcScroll = jScrollPane;
        this.mTargetScroll = jScrollPane2;
        this.mPanel = jPanel;
        this.init();
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        this.calculate();
        this.repaint();
    }

    public Line2D getLine() {
        return new Line2D.Float(this.mPtOrigin, this.mPtTarget);
    }

    public int getSrcCol() {
        return this.mSrcCol;
    }

    public int gettargetCol() {
        return this.mtargetCol;
    }

    public void init() {
        this.mPtOrigin = null;
        this.mPtTarget = null;
        this.mLinUnion = new Line2D.Float();
        this.mConLine1 = new Line2D.Float();
        this.mConLine2 = new Line2D.Float();
        this.mSelected = false;
        this.setOpaque(false);
        this.calculate();
        this.mSrcScroll.getVerticalScrollBar().addAdjustmentListener(this);
        this.mTargetScroll.getVerticalScrollBar().addAdjustmentListener(this);
    }

    public boolean isSelected() {
        return this.mSelected;
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        graphics.setColor(Color.BLACK);
    }

    @Override
    public void paintComponent(Graphics graphics) {
        this.calculate();
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setColor(Color.black);
        graphics2D.setStroke(new BasicStroke(this.mSelected ? 2.0f : 1.0f));
        graphics2D.draw(this.mLinUnion);
        graphics2D.setStroke(new BasicStroke(12.0f));
        graphics2D.draw(this.mConLine1);
        graphics2D.setStroke(new BasicStroke(12.0f));
        graphics2D.draw(this.mConLine2);
    }

    public void setSelected(boolean bl) {
        this.mSelected = bl;
        this.repaint();
    }

    private void calculate() {
        this.initPoints();
        this.initBounds(this.mPtOrigin, this.mPtTarget);
        this.initLine();
    }

    private void initBounds(Point point, Point point2) {
        Rectangle rectangle = new Rectangle();
        rectangle.x = (int)Math.min(point.getX(), point2.getX());
        rectangle.y = (int)Math.min(point.getY(), point2.getY());
        rectangle.height = (int)Math.max(point.getY(), point2.getY()) - rectangle.y;
        if (rectangle.height < 5) {
            rectangle.height = 5;
        }
        rectangle.width = (int)Math.max(point.getX(), point2.getX()) - rectangle.x;
        if (rectangle.width == 0) {
            rectangle.width = 10;
        }
        this.setBounds(rectangle);
    }

    private void initLine() {
        if (this.m_LineDirection == 1) {
            this.mConLine1.setLine(0.0, 0.0, 2.0, 0.0);
            this.mLinUnion.setLine(2.0, 0.0, this.getWidth() - 2, this.getHeight());
            this.mConLine2.setLine(this.getWidth() - 2, this.getHeight(), this.getWidth(), this.getHeight());
        }
        if (this.m_LineDirection == 2) {
            this.mConLine1.setLine(0.0, this.getHeight(), 2.0, this.getHeight());
            this.mLinUnion.setLine(2.0, this.getHeight(), this.getWidth() - 2, 0.0);
            this.mConLine2.setLine(this.getWidth() - 2, 0.0, this.getWidth(), 0.0);
        }
    }

    private void initPoints() {
        int n = this.mSrcCol;
        int n2 = this.mtargetCol;
        if (this.mtargetCol == -1) {
            n2 = 0;
        }
        this.mPtOrigin = new Point(this.mComp1.getX(), this.mComp1.getY() + 16 * n + 12);
        this.mPtTarget = new Point(this.mPanel.getWidth(), this.mComp2.getY() + 16 * n2 + 12);
        this.m_LineDirection = this.mPtOrigin.getY() >= this.mPtTarget.getY() ? 2 : 1;
        if (this.m_LineDirection == 2 && n != 0) {
            this.mPtOrigin = new Point(this.mComp1.getX(), this.mComp1.getY() + 16 * (n + 1) + 2);
        }
    }
}

