/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.file.export_to_db.how_to_export_data;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.data_access.ODBC.ODBCDacProxy;
import com.spss.java_client.core.server.messages.DataAccess.odbcmsg.TablesInfo;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.base.file.export_to_db.AbstractExportToDBPage;
import com.spss.java_client.ui.dialogs.base.file.export_to_db.ExportToDBData;
import com.spss.java_client.ui.dialogs.base.file.export_to_db.ExportToDBDlg;
import com.spss.java_client.ui.dialogs.base.file.export_to_db.utilities.ExportToDBUtil;
import com.spss.java_client.ui.dialogs.common.BaseWizardDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.uitools.controls.ContextEnabledTextField;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;

public class HowToExportDataPage
extends AbstractExportToDBPage
implements ItemListener {
    private JRadioButton mAddFieldsToTableRadio;
    private JTextArea mAddFieldsToExistingNote;
    private JRadioButton mAppendRecordsToTableRadio;
    private JRadioButton mCreateNewTableRadio;
    private JLabel mDataBaseName;
    private JRadioButton mDropAndCreateTableRadio;
    private JLabel mName;
    private DialogFocusTraversalPolicy mPolicy;
    private SpssButtonGroup mRadioButtonGroup;
    private JRadioButton mReplaceValRadio;
    private JTextArea mReplaceValuesNote;
    private ContextEnabledTextField mTableNameTextField;

    public HowToExportDataPage(BaseWizardDialog baseWizardDialog) {
        super("HowToExportDataPage", baseWizardDialog, true);
    }

    @Override
    public String getNextPage() {
        if (this.mCreateNewTableRadio.isSelected()) {
            if (ExportToDBUtil.isFilterOn()) {
                return "SelectCasesToExportPage";
            }
            return "StoreVarsInNewTablePage";
        }
        return "SelectTableOrViewPage";
    }

    @Override
    public String getDialogHelpID() {
        return "idh_idd_exdb_page_how_to_export";
    }

    @Override
    public boolean hasNextPage() {
        return true;
    }

    @Override
    public boolean isLastPage() {
        return false;
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.updateTableNameComponentStatus();
    }

    private void updateTableNameComponentStatus() {
        boolean bl = this.mCreateNewTableRadio.isSelected();
        if (this.mName != null) {
            this.mName.setEnabled(bl);
        }
        if (this.mTableNameTextField != null) {
            this.mTableNameTextField.setEnabled(bl);
            this.mTableNameTextField.setOpaque(bl);
        }
        this.mWizardDialog.enableFinish(false);
        ExportToDBUtil.setFinishEnabled(false);
        ExportToDBUtil.setReset(true);
    }

    @Override
    public boolean validate() {
        Vector<String> vector = ExportToDBData.getExDBData().getAllTableNames();
        boolean bl = false;
        if (this.mCreateNewTableRadio.isSelected()) {
            String string = this.mTableNameTextField.getText().trim();
            if (string.length() > 0) {
                for (int i = 0; i < vector.size(); ++i) {
                    if (!vector.get(i).equalsIgnoreCase(string)) continue;
                    bl = true;
                    break;
                }
                if (bl) {
                    String string2 = String.format(this.mWizardDialog.getResString("ERR_TABLE_ALREADY_EXISTS"), this.mTableNameTextField.getText());
                    int n = SpssAlertOptionPane.showConfirmDialog((Window)((Object)this.mWizardDialog), string2, VersionInfo.getAppVersionString(), SpssAlertOptionPane.IconType.eWarning, SpssAlertOptionPane.OptionType.YES_NO_OPTION);
                    if (n == 1) {
                        ExportToDBUtil.setNewTableName(this.mTableNameTextField.getText());
                        ExportToDBUtil.setExToDBSelectedOption(ExportToDBUtil.ExportToDBOptions.eDropAndCreateNewTable);
                        return true;
                    }
                    this.setModeToExport();
                    this.setFocusOnNameTextField();
                    return false;
                }
            } else {
                SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this.mWizardDialog), this.mWizardDialog.getResString("ERR_ENTER_THE_NAME_OF_NEW_TABLE"), VersionInfo.getAppVersionString());
                this.setModeToExport();
                this.setFocusOnNameTextField();
                return false;
            }
        }
        this.setModeToExport();
        if (this.mCreateNewTableRadio.isSelected()) {
            ExportToDBUtil.setNewTableName(this.mTableNameTextField.getText());
        }
        return true;
    }

    private void setFocusOnNameTextField() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                HowToExportDataPage.this.mTableNameTextField.setSelectionStart(0);
                HowToExportDataPage.this.mTableNameTextField.setSelectionEnd(HowToExportDataPage.this.mTableNameTextField.getText().length());
                HowToExportDataPage.this.mTableNameTextField.requestFocus();
            }
        });
    }

    @Override
    public boolean validateOnBack() {
        int n = SpssAlertOptionPane.showConfirmDialog((Window)((Object)this.mWizardDialog), this.mWizardDialog.getResString("ERR_WANT_TO_GO_BACK"), this.mWizardDialog.getResString("IDS_DB_RESULTS_OPTION_PANE_TITLE"), SpssAlertOptionPane.IconType.eWarning, SpssAlertOptionPane.OptionType.YES_NO_OPTION);
        if (n == 1) {
            ODBCDacProxy.getODBCDacProxy().disconnect();
        }
        return n == 1;
    }

    @Override
    protected void aboutToHidePanel() {
        ExportToDBUtil.setExToDBWizardPreviousPage(ExportToDBUtil.ExToDBWizardPreviousPage.eHowToExportDataPage);
    }

    @Override
    protected void aboutToShowPanel() {
        if (ExportToDBUtil.getExToDBWizardPreviousPage() == ExportToDBUtil.ExToDBWizardPreviousPage.eWelcome) {
            this.reset();
        }
        if (ExportToDBUtil.getExToDBWizardPreviousPage() == ExportToDBUtil.ExToDBWizardPreviousPage.eSelectTableOrViewPage || ExportToDBUtil.getExToDBWizardPreviousPage() == ExportToDBUtil.ExToDBWizardPreviousPage.eSelectVarsToStoreInNewTablePage || ExportToDBUtil.getExToDBWizardPreviousPage() == ExportToDBUtil.ExToDBWizardPreviousPage.eSelectCasesToExportPage) {
            ExportToDBUtil.setReset(false);
        }
        this.mDataBaseName.setText(ExportToDBData.getExDBData().getDSNName());
        if (ExportToDBData.getExDBData().getWizardCapabities().getStrDBMSName().equals("EXCEL") || !this.mReplaceValRadio.isEnabled()) {
            this.mAddFieldsToTableRadio.setEnabled(false);
            this.mAddFieldsToExistingNote.setEnabled(false);
        } else if (ExportToDBData.getExDBData().getWizardCapabities().getStrDBMSName().equals("Redshift")) {
            this.mAddFieldsToTableRadio.setEnabled(false);
            this.mReplaceValRadio.setEnabled(false);
            this.mAppendRecordsToTableRadio.setSelected(true);
        } else {
            this.mAddFieldsToTableRadio.setEnabled(true);
            this.mAddFieldsToExistingNote.setEnabled(true);
        }
        this.mWizardDialog.setFocusTraversalPolicy(this.mPolicy);
        if (ExportToDBUtil.isFinishEnabled()) {
            this.mWizardDialog.enableFinish(true);
        }
        this.mWizardDialog.enableBack(true);
        if (this.mReplaceValRadio.isSelected()) {
            this.mReplaceValRadio.requestFocusInWindow();
        } else if (this.mAddFieldsToTableRadio.isSelected()) {
            this.mAddFieldsToTableRadio.requestFocusInWindow();
        } else if (this.mAppendRecordsToTableRadio.isSelected()) {
            this.mAppendRecordsToTableRadio.requestFocusInWindow();
        } else if (this.mDropAndCreateTableRadio.isSelected()) {
            this.mDropAndCreateTableRadio.requestFocusInWindow();
        } else if (this.mCreateNewTableRadio.isSelected()) {
            this.mCreateNewTableRadio.requestFocusInWindow();
        }
    }

    @Override
    protected void initVars() {
        this.mRadioButtonGroup = new SpssButtonGroup();
        this.mReplaceValRadio = new JRadioButton(new ToggleButtonAction(this.mWizardDialog, "IDS_REPLACE_VAL_IN_EXISTING_FIELDS_RADIO"));
        this.mAddFieldsToTableRadio = new JRadioButton(new ToggleButtonAction(this.mWizardDialog, "IDS_ADD_NEW_FIELD_TO_EXISTING_TABLE_RADIO"));
        this.mAppendRecordsToTableRadio = new JRadioButton(new ToggleButtonAction(this.mWizardDialog, "IDS_APPEND_NEW_RECORDS_TO_EXISTING_TABLE_RADIO"));
        this.mDropAndCreateTableRadio = new JRadioButton(new ToggleButtonAction(this.mWizardDialog, "IDS_DROP_AND_CREATE_NEW_TABLE_RADIO"));
        this.mCreateNewTableRadio = new JRadioButton(new ToggleButtonAction(this.mWizardDialog, "IDS_CREATE_NEW_TABLE_RADIO"));
        this.checkForUserTables();
        this.mReplaceValRadio.addItemListener(this);
        this.mAddFieldsToTableRadio.addItemListener(this);
        this.mAppendRecordsToTableRadio.addItemListener(this);
        this.mDropAndCreateTableRadio.addItemListener(this);
        this.mCreateNewTableRadio.addItemListener(this);
        this.mRadioButtonGroup.add(this.mReplaceValRadio);
        this.mRadioButtonGroup.add(this.mAddFieldsToTableRadio);
        this.mRadioButtonGroup.add(this.mAppendRecordsToTableRadio);
        this.mRadioButtonGroup.add(this.mDropAndCreateTableRadio);
        this.mRadioButtonGroup.add(this.mCreateNewTableRadio);
        this.mTableNameTextField = new ContextEnabledTextField();
        this.mTableNameTextField.setEnabled(false);
        this.mTableNameTextField.setOpaque(false);
        this.mDataBaseName = new JLabel("");
        this.mWizardDialog.enableFinish(false);
    }

    @Override
    protected boolean isLowerHorizontalBarPresent() {
        return true;
    }

    @Override
    protected boolean isTopHorizontalBarPresent() {
        return false;
    }

    @Override
    protected void setTabTraversalOrder() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mRadioButtonGroup);
        vector.add(this.mTableNameTextField);
        Vector<Object> vector2 = ((ExportToDBDlg)this.mWizardDialog).getTabTraversal(vector);
        this.mPolicy = new DialogFocusTraversalPolicy(vector2, false);
    }

    @Override
    protected JPanel setupPageBody() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        TitledBorder titledBorder = new TitledBorder(this.mWizardDialog.getResString("IDS_EX2DB_CONNECT_TO_DATABASE_OPTION_TITLE_BORDER"));
        jPanel.setBorder(titledBorder);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = new Insets(2 * insets.left, insets.left, n2, insets.right);
        Insets insets3 = new Insets(n2, insets.left, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mReplaceValRadio, gridBagConstraints, 1, 0, 3, 1, n, insets3);
        DialogUtil.addUsingGBL(jPanel, this.mAddFieldsToTableRadio, gridBagConstraints, 1, 2, 3, 1, n, insets3);
        DialogUtil.addUsingGBL(jPanel, this.mAppendRecordsToTableRadio, gridBagConstraints, 1, 4, 3, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, this.mDropAndCreateTableRadio, gridBagConstraints, 1, 5, 3, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel, this.mCreateNewTableRadio, gridBagConstraints, 1, 6, 3, 1, n, insets2);
        ImageIcon imageIcon = new ImageIcon(this.mWizardDialog.getResImageURL("IDS_REPLACE_VAL_IN_EXISTING_FIELDS_IMG"));
        JLabel jLabel = new JLabel();
        jLabel.setIcon(imageIcon);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 2, n, insets2);
        this.mReplaceValuesNote = new JTextArea(this.mWizardDialog.getResString("IDS_REPLACE_VAL_IN_EXISTING_FIELDS_RADIO_NOTE"));
        this.mReplaceValuesNote.setLineWrap(true);
        this.mReplaceValuesNote.setWrapStyleWord(true);
        this.mReplaceValuesNote.setBorder(null);
        this.mReplaceValuesNote.setOpaque(false);
        this.mReplaceValuesNote.setFocusable(false);
        this.mReplaceValuesNote.setPreferredSize(new Dimension(400, 32));
        Insets insets4 = new Insets(0, 2 * n2, n2, insets.right);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mReplaceValuesNote, gridBagConstraints, 1, 1, 3, 1, n, insets4);
        imageIcon = new ImageIcon(this.mWizardDialog.getResImageURL("IDS_ADD_NEW_FIELD_TO_EXISTING_TABLE_IMG"));
        jLabel = new JLabel();
        jLabel.setIcon(imageIcon);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 2, 1, 2, n, insets2);
        this.mAddFieldsToExistingNote = new JTextArea(this.mWizardDialog.getResString("IDS_REPLACE_VAL_IN_EXISTING_FIELDS_RADIO_NOTE"));
        this.mAddFieldsToExistingNote.setLineWrap(true);
        this.mAddFieldsToExistingNote.setWrapStyleWord(true);
        this.mAddFieldsToExistingNote.setBorder(null);
        this.mAddFieldsToExistingNote.setOpaque(false);
        this.mAddFieldsToExistingNote.setFocusable(false);
        this.mAddFieldsToExistingNote.setPreferredSize(new Dimension(400, 32));
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mAddFieldsToExistingNote, gridBagConstraints, 1, 3, 3, 1, n, insets4);
        imageIcon = new ImageIcon(this.mWizardDialog.getResImageURL("IDS_APPEND_NEW_RECORDS_TO_EXISTING_TABLE_IMG"));
        jLabel = new JLabel();
        jLabel.setIcon(imageIcon);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 4, 1, 1, n, insets2);
        imageIcon = new ImageIcon(this.mWizardDialog.getResImageURL("IDS_DROP_AND_CREATE_NEW_TABLE_IMG"));
        jLabel = new JLabel();
        jLabel.setIcon(imageIcon);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 5, 1, 1, n, insets2);
        imageIcon = new ImageIcon(this.mWizardDialog.getResImageURL("IDS_CREATE_NEW_TABLE_IMG"));
        jLabel = new JLabel();
        jLabel.setIcon(imageIcon);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 6, 1, 1, n, insets2);
        this.mName = DialogUtil.createLabel(this.mWizardDialog, "IDS_CREATE_NEW_TABLE_NAME_LABEL");
        this.mName.setLabelFor((Component)this.mTableNameTextField);
        this.mName.setEnabled(false);
        this.mTableNameTextField.setPreferredSize(new Dimension(350, this.mTableNameTextField.getPreferredSize().height));
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        insets4 = new Insets(0, n2, n2, insets.right);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel2, this.mName, gridBagConstraints, 0, 0, 1, 1, n, insets4);
        DialogUtil.addUsingGBL(jPanel2, (JComponent)this.mTableNameTextField, gridBagConstraints, 1, 0, 2, 1, n, insets4);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 0;
        insets4 = new Insets(0, 4 * n2, insets.bottom, insets.right);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 1, 7, 3, 1, n, insets4);
        return jPanel;
    }

    @Override
    protected JPanel setupPageHeader() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = new Insets(n2, insets.left, 0, insets.right);
        JLabel jLabel = DialogUtil.createLabel(this.mWizardDialog, "IDS_EX2DB_HOW_TO_EXPORT_PAGE_HEADING");
        jLabel.setFont(jLabel.getFont().deriveFont(1, 20.0f));
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 2, 1, n, insets2);
        JLabel jLabel2 = new JLabel(this.mWizardDialog.getResString("IDS_EX2DB_CONNECT_TO_DATABASE"));
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 0, 1, 2, 1, n, insets2);
        FontMetrics fontMetrics = jLabel2.getFontMetrics(jLabel2.getFont());
        int n3 = fontMetrics.stringWidth(jLabel2.getText());
        insets2 = new Insets(n2, n3 + 3, 0, insets.right);
        DialogUtil.addUsingGBL(jPanel, this.mDataBaseName, gridBagConstraints, 0, 1, 2, 1, n, insets2);
        return jPanel;
    }

    private void setModeToExport() {
        if (this.mReplaceValRadio.isSelected()) {
            ExportToDBUtil.setExToDBSelectedOption(ExportToDBUtil.ExportToDBOptions.eReplaceValExisitngFields);
        } else if (this.mAddFieldsToTableRadio.isSelected()) {
            ExportToDBUtil.setExToDBSelectedOption(ExportToDBUtil.ExportToDBOptions.eAddFieldsToExistingTable);
        } else if (this.mAppendRecordsToTableRadio.isSelected()) {
            ExportToDBUtil.setExToDBSelectedOption(ExportToDBUtil.ExportToDBOptions.eAppendNewRecordToExistingTable);
        } else if (this.mDropAndCreateTableRadio.isSelected()) {
            ExportToDBUtil.setExToDBSelectedOption(ExportToDBUtil.ExportToDBOptions.eDropAndCreateNewTable);
        } else if (this.mCreateNewTableRadio.isSelected()) {
            ExportToDBUtil.setExToDBSelectedOption(ExportToDBUtil.ExportToDBOptions.eCreateNewTable);
        }
    }

    private void reset() {
        this.checkForUserTables();
        this.mTableNameTextField.setText("");
        ExportToDBUtil.setReset(true);
        ExportToDBUtil.setFinishEnabled(false);
    }

    private void checkForUserTables() {
        int n = 0;
        TablesInfo tablesInfo = ExportToDBData.getExDBData().getTablesInfo();
        Vector vector = tablesInfo.getTableCols();
        if (vector != null) {
            n = vector.size();
            for (TablesInfo.InternalTableInfo internalTableInfo : vector) {
                if (!internalTableInfo.getType().equalsIgnoreCase("SYSTEM TABLE")) continue;
                --n;
            }
        }
        if (n < 1) {
            this.mReplaceValRadio.setEnabled(false);
            if (this.mReplaceValuesNote != null) {
                this.mReplaceValuesNote.setEnabled(false);
            }
            this.mAddFieldsToTableRadio.setEnabled(false);
            if (this.mAddFieldsToExistingNote != null) {
                this.mAddFieldsToExistingNote.setEnabled(false);
            }
            this.mAppendRecordsToTableRadio.setEnabled(false);
            this.mDropAndCreateTableRadio.setEnabled(false);
            this.mCreateNewTableRadio.setSelected(true);
            this.updateTableNameComponentStatus();
        } else {
            this.mReplaceValRadio.setEnabled(true);
            if (this.mReplaceValuesNote != null) {
                this.mReplaceValuesNote.setEnabled(true);
            }
            this.mAddFieldsToTableRadio.setEnabled(true);
            if (this.mAddFieldsToExistingNote != null) {
                this.mAddFieldsToExistingNote.setEnabled(true);
            }
            this.mAppendRecordsToTableRadio.setEnabled(true);
            this.mDropAndCreateTableRadio.setEnabled(true);
            this.mReplaceValRadio.setSelected(true);
        }
    }
}

