/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.file.export_to_db.finish;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.base.file.export_to_db.AbstractExportToDBPage;
import com.spss.java_client.ui.dialogs.base.file.export_to_db.ExportToDBData;
import com.spss.java_client.ui.dialogs.base.file.export_to_db.ExportToDBDlg;
import com.spss.java_client.ui.dialogs.base.file.export_to_db.utilities.ExportToDBSyntaxUtil;
import com.spss.java_client.ui.dialogs.base.file.export_to_db.utilities.ExportToDBUtil;
import com.spss.java_client.ui.dialogs.common.BaseWizardDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.controls.IntTextField;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class FinishPage
extends AbstractExportToDBPage
implements ItemListener,
DocumentListener {
    private JLabel mActionLabel;
    private JLabel mCasesToExportLabel;
    private JLabel mDataSetLabel;
    private JRadioButton mExportDataRadio;
    private JLabel mImageLabel;
    private JRadioButton mPasteSyntaxRadio;
    private DialogFocusTraversalPolicy mPolicy;
    private SpssButtonGroup mRadioButtonGroup;
    private JLabel mTableLabel;
    private JLabel mUserMissingValuesLabel;
    private JCheckBox mBulkLoadCheck;
    private IntTextField mBatchSizeEdit;
    private JLabel mBatchSizeLabel;
    private JRadioButton mBatchCommitRadio;
    private JRadioButton mOdbcRadio;
    private JRadioButton mRowWiseBindingRadio;
    private JRadioButton mColumnWiseBindingRadio;
    private SpssButtonGroup mRadioButtonGroupForBatchOdbc;
    private SpssButtonGroup mRadioButtonGroupForRowColumn;
    private static final int mMaxBatchSize = Integer.MAX_VALUE;
    boolean mSupportBulkLoading;
    boolean mSupportOdbc;

    public FinishPage(BaseWizardDialog baseWizardDialog) {
        super("FinishPage", baseWizardDialog, true);
    }

    @Override
    public String getNextPage() {
        return null;
    }

    @Override
    public boolean hasNextPage() {
        return false;
    }

    boolean canEnableFinish() {
        boolean bl;
        boolean bl2 = bl = !this.mBulkLoadCheck.isSelected();
        if (!bl) {
            bl = this.mBatchSizeEdit.getText().length() > 0;
        }
        return bl;
    }

    public void enableFinish(boolean bl) {
        this.mWizardDialog.enableFinish(bl);
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.enableFinish(this.canEnableFinish());
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.enableFinish(this.canEnableFinish());
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.enableFinish(this.canEnableFinish());
    }

    @Override
    public String getDialogHelpID() {
        return "idh_idd_exdb_page_finish";
    }

    public boolean isExportRadioButtonSelected() {
        return this.mExportDataRadio != null ? this.mExportDataRadio.isSelected() : true;
    }

    @Override
    public boolean isLastPage() {
        return true;
    }

    public boolean isPasteRadioButtonSelected() {
        return this.mPasteSyntaxRadio != null ? this.mPasteSyntaxRadio.isSelected() : false;
    }

    @Override
    protected void aboutToHidePanel() {
        this.mWizardDialog.setDefaultButton(BaseWizardDialog.WizardButton.eNext);
        ExportToDBUtil.setExToDBWizardPreviousPage(ExportToDBUtil.ExToDBWizardPreviousPage.eFinish);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.mBulkLoadCheck && this.mSupportBulkLoading) {
            boolean bl = this.mBulkLoadCheck.isSelected();
            this.mBatchSizeLabel.setEnabled(bl);
            this.mBatchSizeLabel.setOpaque(bl);
            this.mBatchSizeEdit.setEnabled(bl);
            this.mBatchSizeEdit.setOpaque(bl);
            this.mBatchCommitRadio.setEnabled(bl);
            this.mBatchCommitRadio.setOpaque(bl);
            if (this.mSupportOdbc) {
                this.mOdbcRadio.setEnabled(bl);
                this.mOdbcRadio.setOpaque(bl);
                this.mRowWiseBindingRadio.setEnabled(bl);
                this.mRowWiseBindingRadio.setOpaque(bl);
                this.mColumnWiseBindingRadio.setEnabled(bl);
                this.mColumnWiseBindingRadio.setOpaque(bl);
            }
        }
        if (itemEvent.getSource() == this.mBatchCommitRadio || itemEvent.getSource() == this.mOdbcRadio) {
            if (this.mBatchCommitRadio.isSelected()) {
                this.mRadioButtonGroupForRowColumn.clearSelection();
            }
            if (this.mOdbcRadio.isSelected() && !this.mRowWiseBindingRadio.isSelected() && !this.mColumnWiseBindingRadio.isSelected()) {
                this.mRowWiseBindingRadio.setSelected(true);
            }
        }
        if (!(itemEvent.getSource() != this.mRowWiseBindingRadio && itemEvent.getSource() != this.mColumnWiseBindingRadio || !this.mRowWiseBindingRadio.isSelected() && !this.mColumnWiseBindingRadio.isSelected() || this.mOdbcRadio.isSelected())) {
            this.mOdbcRadio.setSelected(true);
        }
        this.enableFinish(this.canEnableFinish());
    }

    @Override
    protected void aboutToShowPanel() {
        this.mWizardDialog.setDefaultButton(null);
        this.mWizardDialog.setDefaultButton(BaseWizardDialog.WizardButton.eFinish);
        this.setHeaderImage();
        this.setActionLabel();
        String string = ExportToDBUtil.getNewTableName();
        if (ExportToDBUtil.getTableOwnerMap().get(string) != null) {
            if (string.length() > 0 && ExportToDBUtil.getTableOwnerMap().get(string).booleanValue()) {
                int n = string.indexOf(".");
                String string2 = string.substring(0, n);
                String string3 = string.substring(n + 1);
                string3 = ExportToDBSyntaxUtil.getValidColName(string3);
                this.mTableLabel.setText(string2 + "." + string3);
            } else {
                this.mTableLabel.setText(ExportToDBSyntaxUtil.getValidTableName());
            }
        } else {
            this.mTableLabel.setText(ExportToDBSyntaxUtil.getValidTableName());
        }
        this.mDataSetLabel.setText(ExportToDBUtil.getDataSetName());
        String string4 = ExportToDBUtil.getCasesToExportString();
        if (string4 != null && string4.length() > 0) {
            this.mCasesToExportLabel.setText(string4);
        } else {
            this.mCasesToExportLabel.setText(this.mWizardDialog.getResString("IDS_ALL_CASES_TO_EXPORT_LABEL"));
        }
        this.mActionLabel.setText(ExportToDBUtil.getActionString());
        this.mUserMissingValuesLabel.setText(ExportToDBUtil.getUserMissingValuesString());
        this.mWizardDialog.setFocusTraversalPolicy(this.mPolicy);
        if (this.mExportDataRadio.isSelected()) {
            this.mExportDataRadio.requestFocusInWindow();
        } else {
            this.mPasteSyntaxRadio.requestFocusInWindow();
        }
        this.mSupportBulkLoading = ExportToDBData.getExDBData().getWizardCapabities().getBatchSupport();
        this.mSupportOdbc = ExportToDBData.getExDBData().getWizardCapabities().getArrayBindingSupport();
        this.mBulkLoadCheck.setSelected(this.mSupportBulkLoading);
        this.mBulkLoadCheck.setEnabled(this.mSupportBulkLoading);
        this.mBulkLoadCheck.setOpaque(this.mSupportBulkLoading);
        this.mBatchSizeLabel.setEnabled(this.mSupportBulkLoading);
        this.mBatchSizeLabel.setOpaque(this.mSupportBulkLoading);
        this.mBatchSizeEdit.setEnabled(this.mSupportBulkLoading);
        this.mBatchSizeEdit.setOpaque(this.mSupportBulkLoading);
        this.mBatchCommitRadio.setSelected(this.mSupportBulkLoading);
        this.mBatchCommitRadio.setEnabled(this.mSupportBulkLoading);
        this.mBatchCommitRadio.setOpaque(this.mSupportBulkLoading);
        this.mOdbcRadio.setEnabled(this.mSupportOdbc && this.mSupportBulkLoading);
        this.mOdbcRadio.setOpaque(this.mSupportOdbc && this.mSupportBulkLoading);
        this.mRowWiseBindingRadio.setEnabled(this.mSupportOdbc && this.mSupportBulkLoading);
        this.mRowWiseBindingRadio.setOpaque(this.mSupportOdbc && this.mSupportBulkLoading);
        this.mColumnWiseBindingRadio.setEnabled(this.mSupportOdbc && this.mSupportBulkLoading);
        this.mColumnWiseBindingRadio.setOpaque(this.mSupportOdbc && this.mSupportBulkLoading);
    }

    @Override
    protected void initVars() {
        this.mImageLabel = new JLabel("");
        this.mImageLabel.setIcon(new ImageIcon());
        this.mRadioButtonGroup = new SpssButtonGroup();
        if (VersionInfo.allowSyntax()) {
            this.mExportDataRadio = new JRadioButton(new ToggleButtonAction(this.mWizardDialog, "IDS_EX2DB_FINISH_PAGE_EXPORT_DATA_RADIO"));
            this.mPasteSyntaxRadio = new JRadioButton(new ToggleButtonAction(this.mWizardDialog, "IDS_EX2DB_FINISH_PAGE_PASTE_SYNTAX_RADIO"));
            this.mRadioButtonGroup.add(this.mExportDataRadio);
            this.mRadioButtonGroup.add(this.mPasteSyntaxRadio);
            this.mExportDataRadio.setSelected(true);
        }
        this.mDataSetLabel = new JLabel("");
        this.mTableLabel = new JLabel("");
        this.mCasesToExportLabel = new JLabel("");
        this.mActionLabel = new JLabel("");
        this.mUserMissingValuesLabel = new JLabel("");
        this.mBulkLoadCheck = new JCheckBox(new ToggleButtonAction(this.mWizardDialog, "IDS_EX2DB_FINISH_PAGE_BULK_LOAD_CHECK"));
        this.mBatchSizeEdit = new IntTextField(1, Integer.MAX_VALUE, true);
        this.mBatchSizeLabel = new JLabel(this.mWizardDialog.getResString("IDS_EX2DB_FINISH_PAGE_BATCH_SIZE_LABEL"));
        this.mBatchSizeLabel.setLabelFor((Component)this.mBatchSizeEdit);
        this.mBatchCommitRadio = new JRadioButton(new ToggleButtonAction(this.mWizardDialog, "IDS_EX2DB_FINISH_PAGE_BATCH_COMMIT_RADIO"));
        this.mOdbcRadio = new JRadioButton(new ToggleButtonAction(this.mWizardDialog, "IDS_EX2DB_FINISH_PAGE_ODBC_RADIO"));
        this.mRowWiseBindingRadio = new JRadioButton(new ToggleButtonAction(this.mWizardDialog, "IDS_EX2DB_FINISH_PAGE_ROW_WISE_BINDING_RADIO"));
        this.mColumnWiseBindingRadio = new JRadioButton(new ToggleButtonAction(this.mWizardDialog, "IDS_EX2DB_FINISH_PAGE_COLUMN_WISE_BINDING_RADIO"));
        this.mRadioButtonGroupForBatchOdbc = new SpssButtonGroup();
        this.mRadioButtonGroupForBatchOdbc.add(this.mBatchCommitRadio);
        this.mRadioButtonGroupForBatchOdbc.add(this.mOdbcRadio);
        this.mRadioButtonGroupForRowColumn = new SpssButtonGroup();
        this.mRadioButtonGroupForRowColumn.add(this.mRowWiseBindingRadio);
        this.mRadioButtonGroupForRowColumn.add(this.mColumnWiseBindingRadio);
        this.mBulkLoadCheck.setSelected(true);
        this.mBatchSizeEdit.setText("10000");
        this.mBatchCommitRadio.setSelected(true);
        this.mBulkLoadCheck.addItemListener(this);
        this.mBatchSizeEdit.getDocument().addDocumentListener(this);
        this.mBatchCommitRadio.addItemListener(this);
        this.mOdbcRadio.addItemListener(this);
        this.mRowWiseBindingRadio.addItemListener(this);
        this.mColumnWiseBindingRadio.addItemListener(this);
    }

    @Override
    protected boolean isTopHorizontalBarPresent() {
        return false;
    }

    @Override
    protected void setTabTraversalOrder() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mRadioButtonGroup);
        vector.add(this.mBulkLoadCheck);
        vector.add(this.mBatchSizeEdit);
        vector.add(this.mRadioButtonGroupForBatchOdbc);
        vector.add(this.mRadioButtonGroupForRowColumn);
        Vector<Object> vector2 = ((ExportToDBDlg)this.mWizardDialog).getTabTraversal(vector);
        this.mPolicy = new DialogFocusTraversalPolicy(vector2, false);
    }

    @Override
    protected JPanel setupPageBody() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = new Insets(n2, insets.left, n2, insets.right);
        ArrayList<JLabel> arrayList = new ArrayList<JLabel>();
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        TitledBorder titledBorder = new TitledBorder(this.mWizardDialog.getResString("IDS_EX2DB_FINISH_PAGE_SUMMARY_TITLE_BORDER"));
        jPanel2.setBorder(titledBorder);
        JLabel jLabel = new JLabel(this.mWizardDialog.getResString("IDS_EX2DB_FINISH_PAGE_DATASET_LABEL"));
        arrayList.add(jLabel);
        DialogUtil.addUsingGBL(jPanel2, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets2);
        jLabel = new JLabel(this.mWizardDialog.getResString("IDS_EX2DB_FINISH_PAGE_TABLE_LABEL"));
        arrayList.add(jLabel);
        DialogUtil.addUsingGBL(jPanel2, jLabel, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        jLabel = new JLabel(this.mWizardDialog.getResString("IDS_EX2DB_FINISH_PAGE_CASES_TO_EXPORT_LABEL"));
        arrayList.add(jLabel);
        DialogUtil.addUsingGBL(jPanel2, jLabel, gridBagConstraints, 0, 2, 1, 1, n, insets2);
        jLabel = new JLabel(this.mWizardDialog.getResString("IDS_EX2DB_FINISH_PAGE_ACTION_LABEL"));
        arrayList.add(jLabel);
        DialogUtil.addUsingGBL(jPanel2, jLabel, gridBagConstraints, 0, 3, 3, 1, n, insets2);
        gridBagConstraints.weighty = 1.0;
        jLabel = new JLabel(this.mWizardDialog.getResString("IDS_EX2DB_FINISH_PAGE_USER_MISSING_VALUES_LABEL"));
        arrayList.add(jLabel);
        DialogUtil.addUsingGBL(jPanel2, jLabel, gridBagConstraints, 0, 4, 1, 1, n, insets2);
        int n3 = this.getMaxLabelWidth(arrayList);
        insets2 = new Insets(n2, n3, n2, insets.right);
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel2, this.mDataSetLabel, gridBagConstraints, 0, 0, 2, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel2, this.mTableLabel, gridBagConstraints, 0, 1, 2, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel2, this.mCasesToExportLabel, gridBagConstraints, 0, 2, 2, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel2, this.mActionLabel, gridBagConstraints, 0, 3, 2, 1, n, insets2);
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel2, this.mUserMissingValuesLabel, gridBagConstraints, 0, 4, 2, 1, n, insets2);
        gridBagConstraints.weighty = 0.0;
        insets2 = new Insets(insets.top, insets.left, 0, insets.right);
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        titledBorder = new TitledBorder(this.mWizardDialog.getResString("IDS_EX2DB_FINISH_PAGE_BULKLOADING_TITLE_BORDER"));
        jPanel3.setBorder(titledBorder);
        this.mBatchSizeLabel.setLabelFor((Component)this.mBatchSizeEdit);
        this.mBatchSizeLabel.setDisplayedMnemonic(this.mWizardDialog.getResInt("IDK_EX2DB_FINISH_PAGE_BATCH_SIZE_LABEL_KEY"));
        DialogUtil.addUsingGBL(jPanel3, this.mBulkLoadCheck, gridBagConstraints, 0, 0, 1, 1, n, insets2);
        insets2 = new Insets(0, 20, 0, insets.right);
        DialogUtil.addUsingGBL(jPanel3, this.mBatchSizeLabel, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel3, this.mBatchCommitRadio, gridBagConstraints, 0, 2, 1, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel3, this.mOdbcRadio, gridBagConstraints, 0, 3, 1, 1, n, insets2);
        n3 = this.mBatchSizeLabel.getFontMetrics(this.mBatchSizeLabel.getFont()).stringWidth(this.mBatchSizeLabel.getText()) + 20 + 10;
        insets2 = new Insets(0, n3, 0, 0);
        gridBagConstraints.ipadx = 50;
        DialogUtil.addUsingGBL(jPanel3, (JComponent)this.mBatchSizeEdit, gridBagConstraints, 0, 1, 2, 1, n, insets2);
        gridBagConstraints.fill = 0;
        insets2 = new Insets(0, 40, insets.bottom, 40);
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel3, this.mRowWiseBindingRadio, gridBagConstraints, 0, 4, 2, 1, n, insets2);
        DialogUtil.addUsingGBL(jPanel3, this.mColumnWiseBindingRadio, gridBagConstraints, 0, 5, 2, 1, n, insets2);
        gridBagConstraints.fill = 2;
        insets2 = new Insets(insets.top, insets.left, 0, insets.right);
        JPanel jPanel4 = new JPanel(new GridBagLayout());
        if (VersionInfo.allowSyntax()) {
            titledBorder = new TitledBorder(this.mWizardDialog.getResString("IDS_EX2DB_FINISH_PAGE_WHAT_TO_DO_TITLE_BORDER"));
            jPanel4.setBorder(titledBorder);
            gridBagConstraints.weighty = 0.0;
            DialogUtil.addUsingGBL(jPanel4, this.mExportDataRadio, gridBagConstraints, 0, 0, 3, 1, n, insets2);
            gridBagConstraints.weighty = 1.0;
            insets2 = new Insets(insets.top, insets.left, n2, insets.right);
            DialogUtil.addUsingGBL(jPanel4, this.mPasteSyntaxRadio, gridBagConstraints, 0, 1, 3, 1, n, insets2);
        }
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 0.6;
        insets2 = new Insets(n2, insets.left, n2, insets.right);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 4, 1, n, insets2);
        gridBagConstraints.weighty = 0.3;
        insets2 = new Insets(0, insets.left, 0, insets.right);
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 1, 4, 1, n, insets2);
        gridBagConstraints.weighty = 0.1;
        insets2 = new Insets(0, insets.left, 0, insets.right);
        DialogUtil.addUsingGBL(jPanel, jPanel4, gridBagConstraints, 0, 2, 4, 1, n, insets2);
        return jPanel;
    }

    @Override
    protected JPanel setupPageHeader() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = new Insets(n2, insets.left, n2, insets.right);
        String string = "IDS_EX2DB_FINISH_PAGE_HEADING";
        if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
            string = "IDS_EX2DB_FINISH_PAGE_HEADING_MAC";
        }
        JLabel jLabel = DialogUtil.createLabel(this.mWizardDialog, string);
        jLabel.setFont(jLabel.getFont().deriveFont(1, 20.0f));
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        n = 24;
        DialogUtil.addUsingGBL(jPanel, this.mImageLabel, gridBagConstraints, 1, 0, 2, 2, n, insets2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        n = 23;
        JLabel jLabel2 = new JLabel(this.mWizardDialog.getResString("IDS_EX2DB_FINISH_PAGE_NOTE"));
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 0, 1, 2, 1, n, insets2);
        this.mWizardDialog.pack();
        return jPanel;
    }

    private int getMaxLabelWidth(ArrayList<JLabel> arrayList) {
        int n = 0;
        for (int i = 0; i < arrayList.size(); ++i) {
            FontMetrics fontMetrics = arrayList.get(i).getFontMetrics(arrayList.get(i).getFont());
            int n2 = fontMetrics.stringWidth(arrayList.get(i).getText());
            if (n2 <= n) continue;
            n = n2;
        }
        return n += 10;
    }

    private void setActionLabel() {
        if (ExportToDBUtil.getExToDBSelectedOption() == ExportToDBUtil.ExportToDBOptions.eReplaceValExisitngFields) {
            ExportToDBUtil.setActionString(MessageFormat.format(this.mWizardDialog.getResString("IDS_FINISH_ACTION_1"), String.valueOf(ExportToDBUtil.getCount())));
        } else if (ExportToDBUtil.getExToDBSelectedOption() == ExportToDBUtil.ExportToDBOptions.eAddFieldsToExistingTable) {
            ExportToDBUtil.setActionString(MessageFormat.format(this.mWizardDialog.getResString("IDS_FINISH_ACTION_2"), String.valueOf(ExportToDBUtil.getCount())));
        } else if (ExportToDBUtil.getExToDBSelectedOption() == ExportToDBUtil.ExportToDBOptions.eAppendNewRecordToExistingTable) {
            ExportToDBUtil.setActionString(this.mWizardDialog.getResString("IDS_FINISH_ACTION_3"));
        } else if (ExportToDBUtil.getExToDBSelectedOption() == ExportToDBUtil.ExportToDBOptions.eDropAndCreateNewTable) {
            ExportToDBUtil.setActionString(this.mWizardDialog.getResString("IDS_FINISH_ACTION_4"));
        } else {
            ExportToDBUtil.setActionString(this.mWizardDialog.getResString("IDS_FINISH_ACTION_5"));
        }
    }

    private void setHeaderImage() {
        ImageIcon imageIcon = ExportToDBUtil.getHeaderImage(this.mWizardDialog);
        this.mImageLabel.setIcon(imageIcon);
    }

    private void generateSyntax() {
        if (!this.mBulkLoadCheck.isSelected()) {
            ExportToDBUtil.setBulkLoadingChecked(false);
        } else {
            ExportToDBUtil.setBulkLoadingChecked(true);
            ExportToDBUtil.setBatchSize(Integer.parseInt(this.mBatchSizeEdit.getText()));
            ExportToDBUtil.setBatchCommitSelected(this.mBatchCommitRadio.isSelected());
            ExportToDBUtil.setRowWiseBindingSelected(this.mRowWiseBindingRadio.isSelected());
        }
    }

    @Override
    public boolean validate() {
        this.generateSyntax();
        return true;
    }
}

