/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.file.export_to_db;

import com.spss.java_client.core.comp_util.IDialogCallback;
import com.spss.java_client.core.documents.DocType;
import com.spss.java_client.core.documents.data.data_access.ODBC.ODBCDacProxy;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.SPSS_Format;
import com.spss.java_client.core.server.messages.DataAccess.odbcmsg.ColumnsInfo;
import com.spss.java_client.core.server.messages.DataAccess.odbcmsg.ODBCWizardCapabilities;
import com.spss.java_client.core.server.messages.DataAccess.odbcmsg.TablesInfo;
import com.spss.java_client.ui.SpssFrameMgr;
import com.spss.java_client.ui.controls.SrcVariableList;
import com.spss.java_client.ui.dialogs.base.file.DialogCallbackImpl;
import com.spss.java_client.ui.dialogs.base.file.ProgressFrame;
import com.spss.java_client.ui.dialogs.base.file.export_to_db.utilities.ExportToDBUtil;
import com.spss.java_client.ui.dialogs.base.file.openquery.DBData;
import com.spss.java_client.ui.dialogs.base.file.openquery.utilities.DBWizardUtil;
import com.spss.java_client.ui.doc_types.SpssFrame;
import java.util.LinkedHashMap;
import java.util.Vector;

public class ExportToDBData {
    private static ExportToDBData mExToDBData;
    private ColumnsInfo mColumnsInfo;
    private String mConnectionString;
    private String mDSNName;
    private ProgressFrame mProgressFrame;
    private Vector<String> mSynonymsData;
    private Vector<String> mSystemTablesData;
    private int mTableCount;
    private Vector<String> mTablesData;
    private Vector<String> mAllTableNames;
    private TablesInfo mTablesInfo;
    private Vector<String> mViewsData;
    private ODBCWizardCapabilities mWizardCapabilities;
    private LinkedHashMap<ISpssVariable, SPSS_Format> mSpssVarPropsMap;
    private LinkedHashMap<Integer, String> mSQLTypeNameMap;
    private LinkedHashMap<String, Integer> mSQLNameTypeMap;
    private LinkedHashMap<String, String> mSQLNameWidthMap;

    public static ExportToDBData getExDBData() {
        if (mExToDBData == null) {
            mExToDBData = new ExportToDBData();
        }
        return mExToDBData;
    }

    private ExportToDBData() {
        this.initVars();
    }

    public void clear() {
        this.mDSNName = "";
        this.mSynonymsData.clear();
        this.mSystemTablesData.clear();
        this.mTablesData.clear();
        this.mTablesInfo.getTableCols().clear();
        this.mViewsData.clear();
        this.mAllTableNames.clear();
    }

    public ColumnsInfo getColumnsInfo() {
        return this.mColumnsInfo;
    }

    public String getConnectionString() {
        return this.mConnectionString;
    }

    public String getDSNName() {
        return this.mDSNName;
    }

    public Vector<String> getSynonymsData() {
        return this.mSynonymsData;
    }

    public Vector<String> getSystemTablesData() {
        return this.mSystemTablesData;
    }

    public int getTableCount() {
        return this.mTableCount;
    }

    public Vector<String> getTablesData() {
        return this.mTablesData;
    }

    public TablesInfo getTablesInfo() {
        return this.mTablesInfo;
    }

    public Vector<String> getViewsData() {
        return this.mViewsData;
    }

    public Vector<String> getAllTableNames() {
        return this.mAllTableNames;
    }

    public ODBCWizardCapabilities getWizardCapabities() {
        return this.mWizardCapabilities;
    }

    public boolean isDatabase(String string) {
        boolean bl = false;
        String string2 = this.getWizardCapabities().getStrDBMSName();
        if (string2 != null) {
            bl = (string2 = string2.toLowerCase()).indexOf(string.toLowerCase()) > -1;
        }
        return bl;
    }

    public boolean loadTables() {
        SpssFrame spssFrame = SpssFrameMgr.getSpssFrameMgr().getDesignatedWindow(DocType.DE_DOC);
        ODBCDacProxy oDBCDacProxy = ODBCDacProxy.getODBCDacProxy();
        this.mTablesData.clear();
        this.mViewsData.clear();
        this.mSynonymsData.clear();
        this.mSystemTablesData.clear();
        this.mAllTableNames.clear();
        ODBCDacProxy.SqlReturnCode sqlReturnCode = new ODBCDacProxy.SqlReturnCode(oDBCDacProxy);
        DialogCallbackImpl dialogCallbackImpl = new DialogCallbackImpl(spssFrame);
        oDBCDacProxy.setConnectString(DBData.getDBData().getSavedConnectString(this.mDSNName));
        ODBCDacProxy.ProxyReturnCode proxyReturnCode = oDBCDacProxy.connectToDataSource(this.mDSNName, (IDialogCallback)dialogCallbackImpl, this.mWizardCapabilities, sqlReturnCode);
        ExportToDBUtil.setQuoteChar(this.mWizardCapabilities.getStrIdentifierQuoteCharacter());
        if (sqlReturnCode.getSqlCode() == -1 || sqlReturnCode.getSqlCode() == 100) {
            return false;
        }
        if (proxyReturnCode == ODBCDacProxy.ProxyReturnCode.NETWORK_ERROR) {
            return false;
        }
        if (proxyReturnCode == ODBCDacProxy.ProxyReturnCode.UI_CANCELLED) {
            return false;
        }
        if (proxyReturnCode == ODBCDacProxy.ProxyReturnCode.PROXY_OK) {
            int n;
            this.mConnectionString = oDBCDacProxy.getConnectString();
            this.mConnectionString = this.mConnectionString.replace("QuotedId=No", "QuotedId=Yes");
            ODBCDacProxy.SqlReturnCode sqlReturnCode2 = new ODBCDacProxy.SqlReturnCode(oDBCDacProxy);
            proxyReturnCode = ODBCDacProxy.getODBCDacProxy().getTables(this.mTablesInfo, sqlReturnCode2, true);
            if (sqlReturnCode2.getSqlCode() == -1) {
                return false;
            }
            this.initializeMaps();
            this.mTableCount = n = this.mTablesInfo.getTableCols().size();
            if (n > 0) {
                this.mProgressFrame = new ProgressFrame(ExportToDBUtil.getDialog());
                this.mProgressFrame.setVisible(true);
                this.mProgressFrame.setAlwaysOnTop(true);
                this.mProgressFrame.setLabelText(String.format(ExportToDBUtil.getDialog().getResString("IDS_DB_WELCOME_PROGRESS_LABEL"), this.mDSNName));
                this.mProgressFrame.setProgressValue(0);
                int n2 = this.mTablesInfo.getTableCols().size();
                int n3 = 0;
                int n4 = 0;
                for (TablesInfo.InternalTableInfo internalTableInfo : this.mTablesInfo.getTableCols()) {
                    ++n3;
                    String string = "";
                    this.mAllTableNames.add(internalTableInfo.getName());
                    if (internalTableInfo.getType().equals("TABLE") || internalTableInfo.getType().equals("GLOBAL TEMPORARY") || internalTableInfo.getType().equals("LOCAL TEMPORARY")) {
                        string = internalTableInfo.getOwner().length() > 0 ? internalTableInfo.getOwner() + DBWizardUtil.getOwnerNameSeperator() + internalTableInfo.getName() : internalTableInfo.getName();
                        this.mTablesData.add(string);
                    } else if (internalTableInfo.getType().equals("VIEW")) {
                        string = internalTableInfo.getOwner().length() > 0 ? internalTableInfo.getOwner() + DBWizardUtil.getOwnerNameSeperator() + internalTableInfo.getName() : internalTableInfo.getName();
                        this.mViewsData.add(string);
                    } else if (internalTableInfo.getType().equals("SYSTEM TABLE")) {
                        string = internalTableInfo.getOwner().length() > 0 ? internalTableInfo.getOwner() + DBWizardUtil.getOwnerNameSeperator() + internalTableInfo.getName() : internalTableInfo.getName();
                        this.mSystemTablesData.add(string);
                    } else if (internalTableInfo.getType().equals("SYNONYM") || internalTableInfo.getType().equals("ALIAS") || internalTableInfo.getType().equals("NICKNAME")) {
                        string = internalTableInfo.getOwner().length() > 0 ? internalTableInfo.getOwner() + DBWizardUtil.getOwnerNameSeperator() + internalTableInfo.getName() : internalTableInfo.getName();
                        this.mSynonymsData.add(string);
                    }
                    if ((n4 = n3 * 100 / n2) % 1 != 0) continue;
                    this.mProgressFrame.setProgressValue(n4);
                    this.mProgressFrame.update(this.mProgressFrame.getGraphics());
                }
                this.mProgressFrame.dispose();
            }
            return true;
        }
        return false;
    }

    public void setColumnsInfo(ColumnsInfo columnsInfo) {
        this.mColumnsInfo = columnsInfo;
    }

    public void setDSNName(String string) {
        this.mDSNName = string;
    }

    public void setSynonymsData(Vector<String> vector) {
        for (String string : vector) {
            this.mSynonymsData.add(string);
        }
    }

    public void setSystemTablesData(Vector<String> vector) {
        for (String string : vector) {
            this.mSystemTablesData.add(string);
        }
    }

    public void setTablesData(Vector<String> vector) {
        for (String string : vector) {
            this.mTablesData.add(string);
        }
    }

    public void setViewsData(Vector<String> vector) {
        for (String string : vector) {
            this.mViewsData.add(string);
        }
    }

    public LinkedHashMap<ISpssVariable, SPSS_Format> getSpssVarPropsMap() {
        return this.mSpssVarPropsMap;
    }

    public LinkedHashMap<String, String> getSQLNameWidthMap() {
        return this.mSQLNameWidthMap;
    }

    public LinkedHashMap<Integer, String> getSQLTypeNameMap() {
        return this.mSQLTypeNameMap;
    }

    public LinkedHashMap<String, Integer> getSQLNameTypeMapping() {
        return this.mSQLNameTypeMap;
    }

    private void initializeMaps() {
        if (this.mWizardCapabilities.getStrDataSQLtypes().equals("")) {
            SrcVariableList srcVariableList = new SrcVariableList();
            srcVariableList.loadFromActiveDataset();
            for (int i = 0; i < srcVariableList.getModel().getSize(); ++i) {
                ISpssVariable iSpssVariable = srcVariableList.getModel().getElementAt(i);
                SPSS_Format sPSS_Format = iSpssVariable.getFormat();
                this.mSpssVarPropsMap.put(iSpssVariable, sPSS_Format);
            }
        } else {
            Object object;
            Object object2;
            if (this.mSpssVarPropsMap.size() > 0) {
                this.mSpssVarPropsMap.clear();
                this.mSQLTypeNameMap.clear();
                this.mSQLNameTypeMap.clear();
                this.mSQLNameWidthMap.clear();
            }
            SrcVariableList srcVariableList = new SrcVariableList();
            srcVariableList.loadFromActiveDataset();
            for (int i = 0; i < srcVariableList.getModel().getSize(); ++i) {
                object2 = srcVariableList.getModel().getElementAt(i);
                object = object2.getFormat();
                this.mSpssVarPropsMap.put((ISpssVariable)object2, (SPSS_Format)object);
            }
            String string = ExportToDBData.getExDBData().getWizardCapabities().getStrDataSQLtypes();
            object2 = ExportToDBData.getExDBData().getWizardCapabities().getStrDataTypeNames();
            object = ExportToDBData.getExDBData().getWizardCapabities().getStrDataTypeSizes();
            String[] stringArray = string.split(";");
            String[] stringArray2 = ((String)object2).split(";");
            String[] stringArray3 = ((String)object).split(";");
            ExportToDBUtil.setFirstAvailableType(stringArray2[0]);
            for (int i = 0; i < stringArray2.length; ++i) {
                this.mSQLTypeNameMap.put(Integer.parseInt(stringArray[i]), stringArray2[i].toLowerCase());
                this.mSQLNameWidthMap.put(stringArray2[i].toLowerCase(), stringArray3[i]);
                this.mSQLNameTypeMap.put(stringArray2[i].toLowerCase(), Integer.parseInt(stringArray[i]));
            }
            if (this.isDatabase("Access")) {
                this.mSQLTypeNameMap.put(28, "memo");
                this.mSQLNameWidthMap.put("memo", Integer.toString(28));
                this.mSQLNameTypeMap.put("memo", 28);
            }
            if (this.isDatabase("Microsoft SQL Server")) {
                this.mSQLNameTypeMap.remove("date");
                this.mSQLNameWidthMap.remove("date");
            }
            if (this.isDatabase("Redshift")) {
                this.mSQLNameTypeMap.remove("time");
                this.mSQLNameWidthMap.remove("time");
            }
        }
    }

    private void initVars() {
        this.mSystemTablesData = new Vector();
        this.mSynonymsData = new Vector();
        this.mTablesData = new Vector();
        this.mViewsData = new Vector();
        this.mAllTableNames = new Vector();
        this.mTablesInfo = new TablesInfo();
        this.mWizardCapabilities = new ODBCWizardCapabilities();
        this.mSpssVarPropsMap = new LinkedHashMap();
        this.mSQLTypeNameMap = new LinkedHashMap();
        this.mSQLNameTypeMap = new LinkedHashMap();
        this.mSQLNameWidthMap = new LinkedHashMap();
    }
}

