/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.file.export_to_db;

import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.dialogs.base.file.export_to_db.ExportToDBArrowButton;
import com.spss.java_client.ui.dialogs.common.BaseWizardDialog;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableCellRenderer;

public class ArrowButtonRenderer
extends DefaultTableCellRenderer {
    private JTable mTable;
    private ArrayList<ExportToDBArrowButton> mArrowButtonsList;
    private BaseWizardDialog mParent;

    public ArrowButtonRenderer(JTable jTable, ArrayList<ExportToDBArrowButton> arrayList, BaseWizardDialog baseWizardDialog) {
        this.mTable = jTable;
        this.mArrowButtonsList = arrayList;
        this.mParent = baseWizardDialog;
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        if (!this.mTable.getModel().isCellEditable(n, n2)) {
            JTextField jTextField = new JTextField();
            jTextField.setEditable(false);
            jTextField.setEnabled(false);
            return jTextField;
        }
        JButton jButton = new JButton();
        ISpssVariable iSpssVariable = (ISpssVariable)this.mTable.getValueAt(n, 0);
        if (this.mArrowButtonsList.size() > 0 && n < this.mArrowButtonsList.size()) {
            if (this.mArrowButtonsList.get(n).isEnabled()) {
                if (bl2) {
                    jButton.setBorder(BorderFactory.createLineBorder(Color.blue));
                } else {
                    jButton.setBorder(BorderFactory.createLineBorder(Color.GRAY));
                }
                if (iSpssVariable != null && iSpssVariable.getName().length() > 0) {
                    jButton.setIcon(new ImageIcon(this.mParent.getResImageURL("IDS_EX2DB_ARROW_LEFT_IMG")));
                    this.mArrowButtonsList.get(n).setArrowOrientation(ExportToDBArrowButton.ButtonOrientation.left);
                } else {
                    jButton.setIcon(new ImageIcon(this.mParent.getResImageURL("IDS_EX2DB_ARROW_RIGHT_IMG")));
                    this.mArrowButtonsList.get(n).setArrowOrientation(ExportToDBArrowButton.ButtonOrientation.right);
                }
            } else {
                jButton.setIcon(new ImageIcon(this.mParent.getResImageURL("IDS_EX2DB_ARROW_RIGHT_GRAY_IMG")));
            }
        } else {
            jButton.setIcon(new ImageIcon(this.mParent.getResImageURL("IDS_EX2DB_ARROW_RIGHT_IMG")));
        }
        return jButton;
    }
}

