/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.file;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.DocType;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.core.documents.data.dictionary.IVariableSet;
import com.spss.java_client.ui.SpssFrameMgr;
import com.spss.java_client.ui.controls.PlainTable;
import com.spss.java_client.ui.dialogs.base.file.SaveDataVariablesTableModel;
import com.spss.java_client.ui.dialogs.base.file.SaveDataVariablesWrapper;
import com.spss.java_client.ui.dialogs.base.file.res.FileResBundle;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.ProcedureDlgMgr;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.doc_types.data.DataFrame;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.shared.core_tools.utils.SerializableObject;
import com.spss.uitools.dialogs.BaseDialog;
import com.spss.uitools.dialogs.UIToolDialogUtil;
import com.spss.uitools.help.StatsHelp;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.basic.BasicFileChooserUI;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;

public class SaveDataVariablesDlg
extends BaseDialog
implements ActionListener {
    private static final String SAVEDATA_VARIABLES_TABLE_DATA = "IDS_SAVEDATA_VARIABLES_TABLE_DATA";
    private static JLabel sSelectedVarsLabel;
    private Vector<SaveDataVariablesWrapper> mVarsVector;
    private DialogDataModel mDialogDataModel = new DialogDataModel();
    private ContinueAction mContinueAction;
    private boolean mContinuePressed;
    private boolean mIsAscent;
    private PlainTable mVarTable;
    private JButton mKeepAllButton;
    private JButton mVisibleOnlyButton;
    private JButton mDropAllButton;
    private JScrollPane mTableScrollPane;
    private SaveDataVariablesTableModel mTableModel;
    private int mMaxAllowedVars;

    public SaveDataVariablesDlg(SpssFrame spssFrame, BasicFileChooserUI basicFileChooserUI) throws HeadlessException {
        super((JFrame)spssFrame, true, ResUtil.getBundle(FileResBundle.getDefaultResourceBundleName(), ResUtil.getLocale()), FileResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_SAVE_DATA_AS_VARIABLES_TITLE"));
        this.setLocationRelativeTo(this.getParent());
        this.setDefaultCloseOperation(2);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProcedureDlgMgr.getMgr().loadPersistentState("SAVE_DATA_VARIABLES", SaveDataVariablesDlg.this.getDialogDataModel());
                SaveDataVariablesDlg.this.loadState();
            }
        });
    }

    public boolean wasContinuePressed() {
        return this.mContinuePressed;
    }

    public boolean continuePressed() {
        return this.getKeepCount() <= this.mMaxAllowedVars || 0 == SpssAlertOptionPane.showConfirmDialog((Window)((Object)this), String.format(ComponentState.getSPSSLocale(), this.getResString("ERR_MAX_VARS_WARNING"), this.mMaxAllowedVars), VersionInfo.getAppVersionString(), SpssAlertOptionPane.OptionType.OK_CANCEL_OPTION);
    }

    public void setMaxAllowedVars(int n) {
        this.mMaxAllowedVars = n;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.mKeepAllButton) {
            Vector<SaveDataVariablesWrapper> vector = this.mVarsVector;
            int n = vector.size();
            if (n > 0) {
                for (int i = 0; i < n; ++i) {
                    this.mVarTable.getModel().setValueAt(true, i, 0);
                }
                this.mKeepAllButton.setEnabled(false);
                this.mDropAllButton.setEnabled(true);
            }
        } else if (actionEvent.getSource() == this.mDropAllButton) {
            Vector<SaveDataVariablesWrapper> vector = this.mVarsVector;
            int n = vector.size();
            if (n > 0) {
                for (int i = 0; i < n; ++i) {
                    this.mVarTable.getModel().setValueAt(false, i, 0);
                }
                this.mKeepAllButton.setEnabled(true);
            }
        } else if (actionEvent.getSource() == this.mVisibleOnlyButton) {
            ISpssDataSrc iSpssDataSrc = this.getDataSource();
            Vector<SaveDataVariablesWrapper> vector = this.mVarsVector;
            if (vector != null && vector.size() > 0) {
                int n = vector.size();
                for (int i = 0; i < n; ++i) {
                    SaveDataVariablesWrapper saveDataVariablesWrapper = vector.get(i);
                    ISpssVariable iSpssVariable = saveDataVariablesWrapper.getSpssVar();
                    this.mTableModel.setValueAt(iSpssDataSrc.isVariableInCurrentSet(iSpssVariable), i, 0);
                }
            }
        }
    }

    public int getVariablesCount() {
        return this.mVarsVector.size();
    }

    public String getDropSyntaxString() {
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n").append(SyntaxUtil.getSubCommand("/DROP="));
        int n = this.mVarsVector.size();
        if (this.mVarsVector != null && n > 0) {
            for (int i = 0; i < n; ++i) {
                SaveDataVariablesWrapper saveDataVariablesWrapper = this.mVarsVector.get(i);
                if (saveDataVariablesWrapper.isChecked()) continue;
                stringBuffer.append(saveDataVariablesWrapper.getSpssVar().getName());
                stringBuffer.append(" ");
                bl = true;
            }
        }
        if (bl) {
            String string = stringBuffer.toString();
            return string.substring(0, string.length() - 1);
        }
        return null;
    }

    public String getKeepSyntaxString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        stringBuffer.append("  /");
        int n2 = this.mVarsVector.size();
        if (this.mVarsVector != null && n2 > 0) {
            for (int i = 0; i < n2; ++i) {
                SaveDataVariablesWrapper saveDataVariablesWrapper = this.mVarsVector.get(i);
                if (!saveDataVariablesWrapper.isChecked()) continue;
                stringBuffer.append(saveDataVariablesWrapper.getSpssVar().getName());
                stringBuffer.append(" ");
                ++n;
            }
        }
        if (this.mVarsVector != null && n == this.mVarsVector.size()) {
            return null;
        }
        return stringBuffer.toString();
    }

    public int getKeepCount() {
        int n = this.getDropCount();
        int n2 = this.getVariablesCount();
        return n2 - n;
    }

    void setSelectedVariable() {
        int n = this.getDropCount();
        int n2 = this.getVariablesCount();
        int n3 = n2 - n;
        String string = String.valueOf(n3);
        String string2 = String.valueOf(n2);
        sSelectedVarsLabel.setText(MessageFormat.format(this.getResString("IDS_SELECTED_LABEL"), string, string2));
    }

    void enableDisableKeepDrop() {
        int n;
        int n2 = this.getDropCount();
        if (n2 == (n = this.getVariablesCount())) {
            this.mDropAllButton.setEnabled(false);
            this.mKeepAllButton.setEnabled(true);
            this.mContinueAction.setEnabled(false);
            this.mVarTable.requestFocusInWindow();
        } else if (n2 == 0) {
            this.mDropAllButton.setEnabled(true);
            this.mKeepAllButton.setEnabled(false);
        } else {
            this.mDropAllButton.setEnabled(true);
            this.mKeepAllButton.setEnabled(true);
            this.mContinueAction.setEnabled(true);
        }
    }

    Vector<SaveDataVariablesWrapper> getVarNamesInUse() {
        this.mVarsVector = new Vector();
        SpssFrame spssFrame = SpssFrameMgr.getSpssFrameMgr().getDesignatedWindow(DocType.DE_DOC);
        if (spssFrame instanceof DataFrame) {
            ISpssDataSrc iSpssDataSrc = this.getDataSource();
            IVariableSet iVariableSet = iSpssDataSrc.getALLVARIABLES();
            Vector vector = iVariableSet.getVariableNames(IVariableSet.ChangeCase.kNoChange);
            int n = iSpssDataSrc.columnCount();
            for (int i = 0; i < n; ++i) {
                String string = (String)vector.get(i);
                int n2 = iSpssDataSrc.findVarIndex(string);
                ISpssVariable iSpssVariable = iSpssDataSrc.getVariable(n2);
                SaveDataVariablesWrapper saveDataVariablesWrapper = new SaveDataVariablesWrapper(iSpssVariable, true, i + 1);
                this.mVarsVector.add(saveDataVariablesWrapper);
            }
            return this.mVarsVector;
        }
        return null;
    }

    protected JPanel setupCmdButtonPanel() {
        JPanel jPanel = new JPanel(true);
        Insets insets = DialogUtil.getStandardButtonInsets();
        boolean bl = UIToolDialogUtil.areCommandButtonsBelow();
        this.mContinueAction = new ContinueAction();
        JButton jButton = new JButton(this.mContinueAction);
        JButton jButton2 = new JButton(new CancelAction());
        JButton jButton3 = new JButton(new HelpAction());
        DialogUtil.setupMacHelpButton(jButton3);
        if (bl) {
            jPanel.setBorder(new EmptyBorder(DialogUtil.getMainButtonGap(), 0, 0, 0));
            int n = insets.left + insets.right;
            if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
                jPanel.setLayout(new GridBagLayout());
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                Insets insets2 = new Insets(0, n, 0, 0);
                int n2 = 23;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.fill = 2;
                DialogUtil.addUsingGBL(jPanel, jButton3, gridBagConstraints, 0, 0, 1, 1, n2, null);
                n2 = 24;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.fill = 0;
                DialogUtil.addUsingGBL(jPanel, jButton2, gridBagConstraints, 1, 0, 1, 1, n2, insets2);
                gridBagConstraints.fill = 2;
                gridBagConstraints.weightx = 0.0;
                DialogUtil.addUsingGBL(jPanel, jButton, gridBagConstraints, 2, 0, 1, 1, n2, insets2);
            } else {
                FlowLayout flowLayout = new FlowLayout(1, n, 0);
                jPanel.setLayout(flowLayout);
                jPanel.add(jButton);
                jPanel.add(jButton2);
                jPanel.add(jButton3);
            }
        } else {
            jPanel.setBorder(new EmptyBorder(0, DialogUtil.getMainButtonGap(), 0, 0));
            int n = insets.top + insets.bottom;
            BoxLayout boxLayout = new BoxLayout(jPanel, 1);
            jPanel.setLayout(boxLayout);
            jPanel.add(Box.createVerticalStrut(n * 2));
            jPanel.add(jButton);
            jPanel.add(Box.createVerticalStrut(n));
            jPanel.add(jButton2);
            jPanel.add(Box.createVerticalStrut(n));
            jPanel.add(jButton3);
            jPanel.add(Box.createVerticalStrut(n));
        }
        this.getRootPane().setDefaultButton(jButton);
        DialogUtil.createCmdButtonGroup(jPanel);
        return jPanel;
    }

    protected void init() {
        super.init();
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        this.setupMainPanel(jPanel);
        this.enableVisibleOnlyButton();
        this.setFocusTraversalPolicy();
        this.pack();
    }

    private boolean saveState(DialogDataModel dialogDataModel) {
        if (dialogDataModel != null) {
            int[] nArray = this.mTableModel.getIndexes();
            Vector<SaveDataVariablesWrapper> vector = new Vector<SaveDataVariablesWrapper>();
            for (int n : nArray) {
                vector.add(this.mVarsVector.get(n));
            }
            SerializableObject[] serializableObjectArray = new SerializableObject[vector.size()];
            dialogDataModel.putSerializableArray(SAVEDATA_VARIABLES_TABLE_DATA, vector.toArray(serializableObjectArray));
            return true;
        }
        return false;
    }

    private void initVars() {
        this.mTableModel = new SaveDataVariablesTableModel(this);
        this.mVarTable = new PlainTable(this.mTableModel);
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent();
            }
        };
        AbstractAction abstractAction2 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().focusPreviousComponent();
            }
        };
        this.mVarTable.getInputMap(0).put(KeyStroke.getKeyStroke(9, 0), "tabOut");
        this.mVarTable.getInputMap(0).put(KeyStroke.getKeyStroke(9, 1), "tabIn");
        this.mVarTable.getActionMap().put("tabIn", abstractAction2);
        this.mVarTable.getActionMap().put("tabOut", abstractAction);
        TableColumnModel tableColumnModel = this.mVarTable.getColumnModel();
        JTableHeader jTableHeader = this.mVarTable.getTableHeader();
        tableColumnModel.getColumn(3).setCellRenderer(new OrderColumnCellRenderer());
        tableColumnModel.getColumn(2).setCellRenderer(new OrderColumnCellRenderer());
        tableColumnModel.getColumn(1).setCellRenderer(new OrderColumnCellRenderer());
        tableColumnModel.getColumn(0).setCellRenderer(new CheckBoxRenderer());
        jTableHeader.setReorderingAllowed(false);
        jTableHeader.addMouseListener(new HeaderListener(jTableHeader));
        this.mVarTable.setRowSelectionAllowed(false);
        this.mVarTable.setCellSelectionEnabled(true);
        this.mVarTable.setShowGrid(false);
        int n = this.mVarsVector.size();
        String string = String.valueOf(n);
        sSelectedVarsLabel = new JLabel(MessageFormat.format(this.getResString("IDS_SELECTED_LABEL"), string, string));
        this.mVarTable.getTableHeader().setVisible(true);
        this.mTableScrollPane = new JScrollPane(this.mVarTable);
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, "IDS_KEEP_ALL");
        this.mKeepAllButton = new JButton(toggleButtonAction);
        this.mKeepAllButton.setEnabled(false);
        toggleButtonAction = new ToggleButtonAction(this, "IDS_DROP_ALL");
        this.mDropAllButton = new JButton(toggleButtonAction);
        toggleButtonAction = new ToggleButtonAction(this, "IDS_VISIBLE_ONLY");
        this.mVisibleOnlyButton = new JButton(toggleButtonAction);
        this.mVisibleOnlyButton.setEnabled(false);
        this.mDropAllButton.addActionListener(this);
        this.mKeepAllButton.addActionListener(this);
        this.mVisibleOnlyButton.addActionListener(this);
        Dimension dimension = this.mVarTable.getMinimumSize();
        dimension.width *= 6;
        dimension.height += 4;
        this.mVarTable.setMinimumSize(new Dimension(200, 180));
        this.mTableScrollPane.setPreferredSize(this.mVarTable.getMinimumSize());
    }

    private void setupMainPanel(JPanel jPanel) {
        JLabel jLabel = new JLabel(this.getResString("IDS_MARKED_VARIABLES_NOTE"));
        int n = DialogUtil.getComponentGroupGap();
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n3 = 23;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        Insets insets = new Insets(0, n2, n, 0);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n3, insets);
        insets.set(n2, n2, n, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, this.mTableScrollPane, gridBagConstraints, 0, 1, 1, 3, n3, insets);
        insets.set(n2, n, n, 0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mKeepAllButton, gridBagConstraints, 1, 1, 1, 1, n3, insets);
        insets.set(n2, n, n, 0);
        DialogUtil.addUsingGBL(jPanel, this.mVisibleOnlyButton, gridBagConstraints, 1, 2, 1, 1, n3, insets);
        insets.set(n2, n, n, 0);
        DialogUtil.addUsingGBL(jPanel, this.mDropAllButton, gridBagConstraints, 1, 3, 1, 1, n3, insets);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, sSelectedVarsLabel, gridBagConstraints, 0, 4, 1, 1, n3, insets);
    }

    private DialogDataModel getDialogDataModel() {
        return this.mDialogDataModel;
    }

    private void loadState() {
        SerializableObject[] serializableObjectArray = this.mDialogDataModel.getSerializableArray(SAVEDATA_VARIABLES_TABLE_DATA);
        if (serializableObjectArray != null) {
            try {
                this.mVarsVector.removeAllElements();
                for (SerializableObject serializableObject : serializableObjectArray) {
                    this.mVarsVector.add(((SaveDataVariablesWrapper)serializableObject).clone());
                }
                this.restoreTableState();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                cloneNotSupportedException.printStackTrace();
            }
        }
        Object[] objectArray = this.mDialogDataModel.getArray("IDS_INDEXES_ARRAY");
        Object[] objectArray2 = null;
        if (objectArray != null) {
            objectArray2 = (Object[])objectArray.clone();
        }
        if (objectArray2 != null) {
            int[] nArray = new int[objectArray2.length];
            for (int i = 0; i < objectArray2.length; ++i) {
                nArray[i] = (Integer)objectArray2[i];
            }
            this.mTableModel.setIndexes(nArray);
        }
    }

    private void restoreTableState() {
        int n = this.mVarTable.getRowCount();
        if (n != this.mVarsVector.size()) {
            this.getVarNamesInUse();
        }
        for (int i = 0; i < n; ++i) {
            SaveDataVariablesWrapper saveDataVariablesWrapper = this.mVarsVector.get(i);
            this.mTableModel.setValueAt(saveDataVariablesWrapper.isChecked(), i, 0);
            this.mTableModel.setValueAt(saveDataVariablesWrapper, i, 1);
            this.mTableModel.setValueAt(saveDataVariablesWrapper.getSpssVar().getLabel(), i, 2);
            this.mTableModel.setValueAt(saveDataVariablesWrapper.getOrderNumber(), i, 3);
        }
    }

    private ISpssDataSrc getDataSource() {
        ISpssDataSrc iSpssDataSrc = null;
        SpssFrame spssFrame = SpssFrameMgr.getSpssFrameMgr().getDesignatedWindow(DocType.DE_DOC);
        if (spssFrame instanceof DataFrame) {
            LocallyUniqueId locallyUniqueId = ((DataFrame)spssFrame).getDatasetId();
            iSpssDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        }
        return iSpssDataSrc;
    }

    private void enableVisibleOnlyButton() {
        ISpssDataSrc iSpssDataSrc = this.getDataSource();
        Vector vector = iSpssDataSrc.getVariableSetsInUse();
        if (vector.contains(this.getResString("IDS_ALLVARIABLES_CHECK"))) {
            this.mVisibleOnlyButton.setEnabled(false);
        } else {
            this.mVisibleOnlyButton.setEnabled(true);
        }
    }

    private int getDropCount() {
        int n = 0;
        int n2 = this.mVarsVector.size();
        if (this.mVarsVector != null && n2 > 0) {
            for (int i = 0; i < n2; ++i) {
                SaveDataVariablesWrapper saveDataVariablesWrapper = this.mVarsVector.get(i);
                if (saveDataVariablesWrapper.isChecked()) continue;
                ++n;
            }
        }
        return n;
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mVarTable);
        vector.add(this.mKeepAllButton);
        vector.add(this.mVisibleOnlyButton);
        vector.add(this.mDropAllButton);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    public void doHelp() {
        StatsHelp.getStatsHelp().showHelp(StatsHelp.Book.BASE, "idh_idd_save_variables");
    }

    class CheckBoxRenderer
    extends JCheckBox
    implements TableCellRenderer {
        private Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);

        public CheckBoxRenderer() {
            this.setBorderPainted(true);
            this.setHorizontalAlignment(0);
            this.setVerticalAlignment(0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (bl) {
                super.setBackground(jTable.getSelectionBackground());
                this.setForeground(jTable.getSelectionForeground());
            } else {
                this.setForeground(jTable.getForeground());
                this.setBackground(jTable.getBackground());
            }
            this.setSelected(object != null && (Boolean)object != false);
            this.setBorder(bl2 ? UIManager.getBorder("Table.focusSelectedCellHighlightBorder") : this.noFocusBorder);
            return this;
        }
    }

    public class OrderColumnCellRenderer
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (bl2) {
                this.setForeground(jTable.getSelectionForeground());
                this.setBackground(jTable.getSelectionBackground());
                this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            } else {
                this.setForeground(jTable.getForeground());
                this.setBackground(jTable.getBackground());
                this.setBorder(noFocusBorder);
            }
            if (n2 == 3) {
                this.setHorizontalAlignment(0);
            }
            this.setValue(object);
            return this;
        }

        @Override
        public void setText(String string) {
            if (ComponentState.isBtdRtlOrLtr() && string != null && string.length() > 0) {
                super.setText(ComponentState.prepareStringForBidiRendering((String)string));
            } else {
                super.setText(string);
            }
        }
    }

    class HeaderListener
    extends MouseAdapter {
        JTableHeader header;

        HeaderListener(JTableHeader jTableHeader) {
            this.header = jTableHeader;
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            int n = this.header.columnAtPoint(mouseEvent.getPoint());
            int n2 = this.header.getTable().convertColumnIndexToModel(n);
            if (this.header.getTable().isEditing()) {
                this.header.getTable().getCellEditor().stopCellEditing();
            }
            SaveDataVariablesDlg.this.mIsAscent = ((SaveDataVariablesTableModel)this.header.getTable().getModel()).sortByColumn(n2, SaveDataVariablesDlg.this.mIsAscent);
        }
    }

    class HelpAction
    extends AbstractAction {
        HelpAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_HELP"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SaveDataVariablesDlg.this.doHelp();
        }
    }

    class CancelAction
    extends AbstractAction {
        CancelAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_CANCEL"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SaveDataVariablesDlg.this.dispose();
        }
    }

    class ContinueAction
    extends AbstractAction {
        ContinueAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_CONTINUE"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SaveDataVariablesDlg.this.mContinuePressed = true;
            if (SaveDataVariablesDlg.this.continuePressed() && SaveDataVariablesDlg.this.saveState(SaveDataVariablesDlg.this.getDialogDataModel())) {
                ProcedureDlgMgr.getMgr().savePersistentState("SAVE_DATA_VARIABLES", SaveDataVariablesDlg.this.mDialogDataModel);
                SaveDataVariablesDlg.this.dispose();
            } else {
                SaveDataVariablesDlg.this.mContinuePressed = false;
            }
        }
    }
}

