/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.file;

import com.spss.java_client.core.common.LocallyUniqueId;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.DatasetNameValidator;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.syntax.SyntaxMgr;
import com.spss.java_client.ui.dialogs.base.file.res.FileResBundle;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.dialogs.BaseDialog;
import com.spss.uitools.help.StatsHelp;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

public class RenameDatasetDlg
extends BaseDialog {
    private String mDatasetName;
    private String mSavedDatasetName;
    protected JTextField mDatasetNameEdit;
    protected ISpssDataSrc mDataSrc = null;

    public RenameDatasetDlg(SpssFrame spssFrame) throws HeadlessException {
        super((JFrame)spssFrame, true, ResUtil.getBundle(FileResBundle.getDefaultResourceBundleName(), ResUtil.getLocale()), FileResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_RENAME_DATASET"));
        this.setLocationRelativeTo(this.getParent());
    }

    public String generateSyntax() {
        String string = "DATASET NAME ";
        this.mDatasetName = this.mDatasetNameEdit.getText();
        string = string + this.mDatasetName;
        string = string + ".\n";
        return string;
    }

    public final String getIActionKey() {
        return "file_rename_dataset";
    }

    public void reset() {
        this.mDatasetName = this.mSavedDatasetName;
        this.mDatasetNameEdit.setText(this.mDatasetName);
        this.mDatasetNameEdit.setCaretPosition(0);
        this.mDatasetNameEdit.moveCaretPosition(this.mDatasetName.length());
        this.mDatasetNameEdit.requestFocus();
    }

    protected void init() {
        super.init();
        LocallyUniqueId locallyUniqueId = DataMgr.getDataMgr().getActiveDocumentId();
        this.mDataSrc = DataMgr.getDataMgr().getDataSource(locallyUniqueId);
        if (this.mDataSrc != null) {
            this.mSavedDatasetName = this.mDatasetName = this.mDataSrc.getDatasetName();
        }
        JPanel jPanel = this.getViewPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        Insets insets = new Insets(0, 0, 0, 0);
        JLabel jLabel = new JLabel(this.getResString("IDS_DATASET_NAME_COLON"), 10);
        if (OSInfo.getOSType() != OSInfo.OSType.MAC) {
            jLabel.setDisplayedMnemonic(this.getDlgAccessKey("IDK_DATASET_NAME_COLON_KEY"));
        }
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        this.mDatasetNameEdit = new JTextField();
        Dimension dimension = new Dimension(280, 22);
        this.mDatasetNameEdit.setPreferredSize(dimension);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mDatasetNameEdit, gridBagConstraints, 0, 1, 1, 1, n, new Insets(5, 0, 0, 0));
        jLabel.setLabelFor(this.mDatasetNameEdit);
        this.mDatasetNameEdit.setText(this.mDatasetName);
        this.mDatasetNameEdit.setCaretPosition(0);
        this.mDatasetNameEdit.moveCaretPosition(this.mDatasetName.length());
        this.pack();
    }

    public boolean okPastePressed() {
        return this.validateName(this.mDatasetNameEdit.getText());
    }

    public void doOkPaste(boolean bl) {
        if (bl) {
            SyntaxMgr.getSyntaxMgr().executeSyntax(this.generateSyntax());
        } else {
            SyntaxMgr.getSyntaxMgr().pasteSyntax(this.generateSyntax());
        }
    }

    protected JPanel setupCmdButtonPanel() {
        JPanel jPanel = new JPanel(true);
        Insets insets = DialogUtil.getStandardButtonInsets();
        boolean bl = DialogUtil.areCommandButtonsBelow();
        OKAction oKAction = new OKAction();
        JButton jButton = new JButton(oKAction);
        PasteButtonAction pasteButtonAction = new PasteButtonAction();
        JButton jButton2 = new JButton(pasteButtonAction);
        ResetAction resetAction = new ResetAction();
        JButton jButton3 = new JButton(resetAction);
        JButton jButton4 = new JButton(new CancelAction());
        JButton jButton5 = new JButton(new HelpAction());
        DialogUtil.setupMacHelpButton(jButton5);
        if (bl) {
            jPanel.setBorder(new EmptyBorder(DialogUtil.getMainButtonGap(), 0, 0, 0));
            int n = insets.left + insets.right;
            if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
                jPanel.setLayout(new GridBagLayout());
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                Insets insets2 = new Insets(0, n, 0, 0);
                int n2 = 23;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.fill = 2;
                DialogUtil.addUsingGBL(jPanel, jButton5, gridBagConstraints, 0, 0, 1, 1, n2, null);
                DialogUtil.addUsingGBL(jPanel, jButton3, gridBagConstraints, 1, 0, 1, 1, n2, insets2);
                DialogUtil.addUsingGBL(jPanel, jButton2, gridBagConstraints, 2, 0, 1, 1, n2, insets2);
                n2 = 24;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.fill = 0;
                DialogUtil.addUsingGBL(jPanel, jButton4, gridBagConstraints, 3, 0, 1, 1, n2, insets2);
                gridBagConstraints.fill = 2;
                gridBagConstraints.weightx = 0.0;
                DialogUtil.addUsingGBL(jPanel, jButton, gridBagConstraints, 4, 0, 1, 1, n2, insets2);
            } else {
                FlowLayout flowLayout = new FlowLayout(1, n, 0);
                jPanel.setLayout(flowLayout);
                jPanel.add(jButton);
                jPanel.add(jButton2);
                jPanel.add(jButton3);
                jPanel.add(jButton4);
                jPanel.add(jButton5);
            }
        } else {
            jPanel.setBorder(new EmptyBorder(0, DialogUtil.getMainButtonGap(), 0, 0));
            int n = insets.top + insets.bottom;
            BoxLayout boxLayout = new BoxLayout(jPanel, 1);
            jPanel.setLayout(boxLayout);
            jPanel.add(Box.createVerticalStrut(n * 2));
            jPanel.add(jButton);
            jPanel.add(Box.createVerticalStrut(n));
            jPanel.add(jButton2);
            jPanel.add(Box.createVerticalStrut(n));
            jPanel.add(jButton3);
            jPanel.add(Box.createVerticalStrut(n));
            jPanel.add(jButton4);
            jPanel.add(Box.createVerticalStrut(n));
            jPanel.add(jButton5);
            jPanel.add(Box.createVerticalStrut(n));
        }
        this.getRootPane().setDefaultButton(jButton);
        DialogUtil.createCmdButtonGroup(jPanel);
        return jPanel;
    }

    public boolean validateName(String string) {
        boolean bl = false;
        if (DataMgr.getDataMgr().getDataSource(string) != null) {
            if (0 == string.compareToIgnoreCase(this.mSavedDatasetName)) {
                bl = true;
            } else {
                String string2 = String.format(this.getResString("ERR_RENAME_DATASET_ERROR"), string);
                JOptionPane.showMessageDialog((Component)((Object)this), string2, VersionInfo.getAppVersionString(), 2);
            }
        } else {
            boolean bl2 = bl = DatasetNameValidator.validateDatasetName((String)string, (Component)((Object)this)) == 1;
        }
        if (!bl) {
            this.mDatasetNameEdit.setCaretPosition(0);
            this.mDatasetNameEdit.moveCaretPosition(string.length());
            this.mDatasetNameEdit.requestFocus();
        }
        return bl;
    }

    public void doHelp() {
        StatsHelp.getStatsHelp().showHelp(StatsHelp.Book.BASE, "idh_idd_dialog_rename_dataset");
    }

    class HelpAction
    extends AbstractAction {
        HelpAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_HELP"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            RenameDatasetDlg.this.doHelp();
        }
    }

    class CancelAction
    extends AbstractAction {
        CancelAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_CANCEL"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            RenameDatasetDlg.this.dispose();
        }
    }

    class ResetAction
    extends AbstractAction {
        ResetAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_RESET"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            RenameDatasetDlg.this.reset();
        }
    }

    class PasteButtonAction
    extends AbstractAction {
        PasteButtonAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_PASTE"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (RenameDatasetDlg.this.okPastePressed()) {
                RenameDatasetDlg.this.doOkPaste(false);
                RenameDatasetDlg.this.dispose();
            }
        }
    }

    class OKAction
    extends AbstractAction {
        OKAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_OK"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (RenameDatasetDlg.this.okPastePressed()) {
                RenameDatasetDlg.this.doOkPaste(true);
                RenameDatasetDlg.this.dispose();
            }
        }
    }
}

