/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.file;

import com.spss.java_client.core.comp_util.OSCheck;
import com.spss.java_client.ui.dialogs.base.file.res.FileResBundle;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.dialogs.BaseDialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

public class OleDbConnectInfoDlg
extends BaseDialog {
    protected boolean mOkSelected = false;
    protected JTextField mEditField;
    protected SpssFrame mOwner;

    public OleDbConnectInfoDlg(SpssFrame spssFrame) throws HeadlessException {
        super((JFrame)spssFrame, true, ResUtil.getBundle(FileResBundle.getDefaultResourceBundleName(), ResUtil.getLocale()), FileResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_OLEDB_INFO_TITLE"));
        this.mOwner = spssFrame;
        this.initDlg();
        this.setLocationRelativeTo(this.getParent());
    }

    public boolean isOkSelected() {
        return this.mOkSelected;
    }

    public String getInfoName() {
        return this.mEditField.getText().trim();
    }

    protected void init() {
        super.init();
    }

    protected void initDlg() {
        JPanel jPanel = this.getViewPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(n * 2, n, n, n);
        Dimension dimension = new Dimension(290, 30);
        int n2 = 23;
        JLabel jLabel = new JLabel(this.getResString("IDS_CREATE_NEW_TABLE_NAME_LABEL"), 10);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 1, 1, 1, n2, insets);
        insets.set(n, n, n, n);
        this.mEditField = new JTextField();
        this.mEditField.setPreferredSize(dimension);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mEditField, gridBagConstraints, 1, 1, 1, 1, n2, insets);
        jLabel.setLabelFor(this.mEditField);
        this.pack();
    }

    protected JPanel setupCmdButtonPanel() {
        JPanel jPanel = new JPanel(true);
        Insets insets = DialogUtil.getStandardButtonInsets();
        jPanel.setBorder(new EmptyBorder(DialogUtil.getMainButtonGap(), 0, 0, 0));
        int n = (insets.left + insets.right) * 2;
        OKAction oKAction = new OKAction();
        JButton jButton = new JButton(oKAction);
        JButton jButton2 = new JButton(new CancelAction());
        if (OSCheck.getOSType() == OSInfo.OSType.MAC) {
            FlowLayout flowLayout = new FlowLayout(2, n, 0);
            jPanel.setLayout(flowLayout);
            jPanel.add(jButton2);
            jPanel.add(jButton);
        } else {
            FlowLayout flowLayout = new FlowLayout(1, n, 0);
            jPanel.setLayout(flowLayout);
            jPanel.add(jButton);
            jPanel.add(jButton2);
        }
        this.getRootPane().setDefaultButton(jButton);
        return jPanel;
    }

    public void doHelp() {
    }

    class CancelAction
    extends AbstractAction {
        CancelAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_CANCEL"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            OleDbConnectInfoDlg.this.mOkSelected = false;
            OleDbConnectInfoDlg.this.dispose();
        }
    }

    class OKAction
    extends AbstractAction {
        OKAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_OK"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            OleDbConnectInfoDlg.this.mOkSelected = true;
            OleDbConnectInfoDlg.this.dispose();
        }
    }
}

