/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.file;

import com.spss.java_client.core.common.fopen.RefFileFilter;
import com.spss.java_client.core.comp_util.FileLocationsUtil;
import com.spss.java_client.core.server.DataServerProxy;
import com.spss.java_client.core.server.messages.DataAccess.QueryAttribute;
import com.spss.java_client.core.server.messages.DataAccess.odbcmsg.DataSourceConnectResponse;
import com.spss.java_client.ui.dialogs.base.file.res.FileResBundle;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.dialogs.BaseDialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileFilter;

public class OdbcDriverLoginDlg
extends BaseDialog {
    protected boolean mOkSelected = false;
    protected String mDataSourceName;
    protected DataSourceConnectResponse mConnectResponse;
    protected Vector<QueryAttribute> mAttributes;
    protected JTextField mEditField1;
    protected JPasswordField mEditField2;
    protected LoginType mLoginType;
    protected SpssFrame mOwner;

    public OdbcDriverLoginDlg(SpssFrame spssFrame, String string, DataSourceConnectResponse dataSourceConnectResponse) throws HeadlessException {
        super((JFrame)spssFrame, true, ResUtil.getBundle(FileResBundle.getDefaultResourceBundleName(), ResUtil.getLocale()), FileResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_ODBC_DRIVER_LOGIN"));
        this.mDataSourceName = string;
        this.mConnectResponse = dataSourceConnectResponse;
        this.mOwner = spssFrame;
        this.initLoginDlg();
        this.setLocationRelativeTo(this.getParent());
    }

    public boolean isOkSelected() {
        return this.mOkSelected;
    }

    protected void init() {
        super.init();
    }

    protected void setLoginType() {
        this.mLoginType = LoginType.GENERIC;
        this.mAttributes = this.mConnectResponse.getAttributes();
        if (this.mAttributes.size() == 2) {
            QueryAttribute queryAttribute = this.mAttributes.elementAt(1);
            if (queryAttribute.getQueryType() == QueryAttribute.QueryType.FILENAME) {
                this.mLoginType = LoginType.FILENAME_BROWSE;
            }
        } else if (this.mAttributes.size() == 3) {
            QueryAttribute queryAttribute = this.mAttributes.elementAt(1);
            QueryAttribute queryAttribute2 = this.mAttributes.elementAt(2);
            if (queryAttribute.getQueryType() == QueryAttribute.QueryType.STRING && queryAttribute2.getQueryType() == QueryAttribute.QueryType.PASSWORD) {
                this.mLoginType = LoginType.ID_PASSWORD;
            }
        } else if (this.mAttributes.size() > 3) {
            boolean bl = false;
            boolean bl2 = false;
            for (QueryAttribute queryAttribute : this.mAttributes) {
                if ("LogonID".equals(queryAttribute.getStrAttributeName())) {
                    bl = true;
                    continue;
                }
                if (!"Password".equals(queryAttribute.getStrAttributeName())) continue;
                bl2 = true;
            }
            if (bl || bl2) {
                this.mLoginType = LoginType.ID_PASSWORD;
            }
        }
    }

    protected void initLoginDlg() {
        this.setLoginType();
        if (this.mLoginType == LoginType.FILENAME_BROWSE) {
            this.initFilenameBrowseDlg();
        } else if (this.mLoginType == LoginType.ID_PASSWORD) {
            this.initIdPasswordDlg();
        } else {
            this.initGenericDlg();
        }
    }

    protected void initFilenameBrowseDlg() {
        JPanel jPanel = this.getViewPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(0, n, n, 0);
        Insets insets2 = new Insets(0, n, n, 0);
        JLabel jLabel = new JLabel(this.getResString("IDS_ODBC_DRIVER_LOGIN_DATASOURCE"), 10);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        int n2 = 23;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n2, insets);
        JLabel jLabel2 = new JLabel(this.mDataSourceName, 10);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 1, 0, 1, 1, n2, insets);
        JLabel jLabel3 = new JLabel(this.getResString("IDS_ODBC_DRIVER_LOGIN_FILENAME"), 10);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jLabel3, gridBagConstraints, 0, 1, 1, 1, n2, insets);
        this.mEditField1 = new JTextField();
        this.mEditField1.setPreferredSize(new Dimension(280, this.mEditField1.getPreferredSize().height));
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mEditField1, gridBagConstraints, 1, 1, 1, 1, n2, insets);
        jLabel3.setLabelFor(this.mEditField1);
        BrowseAction browseAction = new BrowseAction();
        JButton jButton = new JButton(browseAction);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        DialogUtil.addUsingGBL(jPanel, jButton, gridBagConstraints, 2, 1, 1, 1, n2, insets2);
        this.pack();
    }

    protected void initIdPasswordDlg() {
        JPanel jPanel = this.getViewPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(0, n, n, 0);
        JLabel jLabel = new JLabel(this.getResString("IDS_ODBC_DRIVER_LOGIN_DATASOURCE"), 10);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        int n2 = 23;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n2, insets);
        JLabel jLabel2 = new JLabel(this.mDataSourceName, 10);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 1, 0, 1, 1, n2, insets);
        JLabel jLabel3 = new JLabel(this.getResString("IDS_ODBC_DRIVER_LOGIN_ID"), 10);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jLabel3, gridBagConstraints, 0, 1, 1, 1, n2, insets);
        this.mEditField1 = new JTextField();
        this.mEditField1.setPreferredSize(new Dimension(280, this.mEditField1.getPreferredSize().height));
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mEditField1, gridBagConstraints, 1, 1, 1, 1, n2, insets);
        jLabel3.setLabelFor(this.mEditField1);
        JLabel jLabel4 = new JLabel(this.getResString("IDS_ODBC_DRIVER_LOGIN_PASSWORD"), 10);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jLabel4, gridBagConstraints, 0, 2, 1, 1, n2, insets);
        this.mEditField2 = new JPasswordField();
        this.mEditField2.setPreferredSize(new Dimension(280, this.mEditField2.getPreferredSize().height));
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mEditField2, gridBagConstraints, 1, 2, 1, 1, n2, insets);
        jLabel4.setLabelFor(this.mEditField2);
        this.pack();
    }

    protected void initGenericDlg() {
        JOptionPane.showMessageDialog(this.mOwner, this.getResString("ERR_ODBC_LOGIN_DRIVER_CONFIG_ERROR"), this.getResString("IDS_ODBC_DRIVER_LOGIN"), 2);
        this.dispose();
    }

    protected JPanel setupCmdButtonPanel() {
        JPanel jPanel = new JPanel(true);
        Insets insets = DialogUtil.getStandardButtonInsets();
        jPanel.setBorder(new EmptyBorder(DialogUtil.getMainButtonGap(), 0, 0, 0));
        int n = (insets.left + insets.right) * 2;
        OKAction oKAction = new OKAction();
        JButton jButton = new JButton(oKAction);
        JButton jButton2 = new JButton(new CancelAction());
        if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
            FlowLayout flowLayout = new FlowLayout(2, n, 0);
            jPanel.setLayout(flowLayout);
            jPanel.add(jButton2);
            jPanel.add(jButton);
        } else {
            FlowLayout flowLayout = new FlowLayout(1, n, 0);
            jPanel.setLayout(flowLayout);
            jPanel.add(jButton);
            jPanel.add(jButton2);
        }
        this.getRootPane().setDefaultButton(jButton);
        return jPanel;
    }

    protected void SaveUserAttributes() {
        if (this.mLoginType == LoginType.FILENAME_BROWSE) {
            QueryAttribute queryAttribute = this.mAttributes.elementAt(1);
            String string = this.mEditField1.getText();
            queryAttribute.setStrUserResponse(string);
        } else if (this.mLoginType == LoginType.ID_PASSWORD) {
            if (this.mAttributes.size() == 3) {
                QueryAttribute queryAttribute = this.mAttributes.elementAt(1);
                String string = this.mEditField1.getText();
                queryAttribute.setStrUserResponse(string);
                queryAttribute = this.mAttributes.elementAt(2);
                char[] cArray = this.mEditField2.getPassword();
                if (cArray != null) {
                    String string2 = new String(cArray);
                    queryAttribute.setStrUserResponse(string2);
                }
            } else if (this.mAttributes.size() > 3) {
                for (QueryAttribute queryAttribute : this.mAttributes) {
                    char[] cArray;
                    if ("LogonID".equals(queryAttribute.getStrAttributeName())) {
                        String string = this.mEditField1.getText();
                        queryAttribute.setStrUserResponse(string);
                        continue;
                    }
                    if (!"Password".equals(queryAttribute.getStrAttributeName()) || (cArray = this.mEditField2.getPassword()) == null) continue;
                    String string = new String(cArray);
                    queryAttribute.setStrUserResponse(string);
                }
            }
        } else {
            this.SaveGenericUserAttributes();
        }
    }

    protected void SaveGenericUserAttributes() {
    }

    public void doHelp() {
    }

    protected static enum LoginType {
        ID_PASSWORD,
        FILENAME_BROWSE,
        GENERIC;

    }

    class CancelAction
    extends AbstractAction {
        CancelAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_CANCEL"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            OdbcDriverLoginDlg.this.mOkSelected = false;
            OdbcDriverLoginDlg.this.dispose();
        }
    }

    class BrowseAction
    extends AbstractAction {
        BrowseAction() {
            this.putValue("Name", OdbcDriverLoginDlg.this.getResString("IDS_RTD_BROWSE"));
            Integer n = OdbcDriverLoginDlg.this.getDlgAccessKey("IDK_RTD_BROWSE_KEY");
            this.putValue("MnemonicKey", n);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            RemoteFileChooser remoteFileChooser = new RemoteFileChooser(RemoteFileChooser.ChooserType.OpenFile, RemoteFileChooser.ChooserOption.GenericWithoutPES, FileLocationsUtil.getDataFilesDirectoryPath(), true);
            String string = ";";
            remoteFileChooser.addChoosableFileFilter((FileFilter)new RefFileFilter(OdbcDriverLoginDlg.this.getResString("IDS_ODBC_LOGIN_FILE_FILTER_EXCEL"), OdbcDriverLoginDlg.this.getResString("IDS_ODBC_LOGIN_FILE_FILTER_EXCEL_EXT")));
            remoteFileChooser.addChoosableFileFilter((FileFilter)new RefFileFilter(OdbcDriverLoginDlg.this.getResString("IDS_ODBC_LOGIN_FILE_FILTER_ACCESS"), OdbcDriverLoginDlg.this.getResString("IDS_ODBC_LOGIN_FILE_FILTER_ACCESSL_EXT"), string));
            remoteFileChooser.addChoosableFileFilter((FileFilter)new RefFileFilter(OdbcDriverLoginDlg.this.getResString("IDS_ODBC_LOGIN_FILE_FILTER_FOXPRO"), OdbcDriverLoginDlg.this.getResString("IDS_ODBC_LOGIN_FILE_FILTER_FOXPRL_EXT")));
            remoteFileChooser.setAcceptAllFileFilterUsed(true);
            int n = remoteFileChooser.showOpenDialog(OdbcDriverLoginDlg.this.mOwner);
            if (n == 0) {
                FileLocationsUtil.setOtherFilesDirectoryPath((String)remoteFileChooser.getCurrentDirectory().getAbsolutePath());
                if (DataServerProxy.getDataProxy().isRemoteConnection()) {
                    OdbcDriverLoginDlg.this.mEditField1.setText(remoteFileChooser.getSelectedFile().getAbsolutePath());
                } else {
                    OdbcDriverLoginDlg.this.mEditField1.setText(remoteFileChooser.getSelectedFile().toString());
                }
            }
        }
    }

    class OKAction
    extends AbstractAction {
        OKAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_OK"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            OdbcDriverLoginDlg.this.SaveUserAttributes();
            OdbcDriverLoginDlg.this.mOkSelected = true;
            OdbcDriverLoginDlg.this.dispose();
        }
    }
}

