/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.file;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.fopen.RefFileFilter;
import com.spss.java_client.ui.controls.FileTextField;
import com.spss.java_client.ui.dialogs.base.file.res.FileResBundle;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.ProcedureDlgMgr;
import com.spss.java_client.ui.dialogs.common.SyntaxUtil;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.fopen.RefWindowsFileChooserUI;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.uitools.util.CharacterUtil;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.filechooser.FileFilter;

public class ExportToDimensionDlg
extends BaseProcedureDialog {
    private static final String DATA_FILE_TEXT_FIELD_KEY = "IDS_DATA_FILE_TEXT_FIELD";
    private static final String META_DATA_FILE_TEXT_FIELD_KEY = "IDS_META_DATA_FILE_TEXT_FIELD_KEY";
    private JButton mDataFileButton;
    private JButton mMetaDataFileButton;
    private RemoteFileChooser mDataRemoteFileChooser;
    private RemoteFileChooser mMetadataRemoteFileChooser;
    private FileTextField mDataFileTextField;
    private FileTextField mMetaDataFileTextField;
    private String mDropSyntax;

    public ExportToDimensionDlg(JFrame jFrame) throws HeadlessException {
        super(jFrame, true, FileResBundle.getDefaultResourceBundleName(), FileResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_EXPORT_TO_DIMENSION_TITLE"));
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public String generateSyntax() {
        StringBuffer stringBuffer = SyntaxUtil.startSyntax();
        stringBuffer.append(SyntaxUtil.getMainCommand("SAVE DATA COLLECTION"));
        stringBuffer.append("\n").append(SyntaxUtil.getSubCommand("/OUTFILE="));
        stringBuffer.append(CharacterUtil.smartQuote((String)this.mDataFileTextField.getText()));
        stringBuffer.append("\n").append(SyntaxUtil.getSubCommand("/METADATA="));
        stringBuffer.append(CharacterUtil.smartQuote((String)this.mMetaDataFileTextField.getText()));
        if (this.mDropSyntax != null) {
            stringBuffer.append(this.mDropSyntax);
        }
        stringBuffer.append(SyntaxUtil.terminateSyntax());
        return stringBuffer.toString();
    }

    @Override
    public String getDialogHelpID() {
        return "idh_dimensions_export";
    }

    @Override
    public String getIActionKey() {
        return "file_export_to_dimensions";
    }

    @Override
    public void reset() {
        super.reset();
        this.mDataFileTextField.setText("");
        this.mMetaDataFileTextField.setText("");
        this.enableOkPaste(false);
    }

    private void enableOkPasteButtons() {
        if (this.mDataFileTextField.getText() != null && this.mMetaDataFileTextField.getText() != null) {
            if (!this.mDataFileTextField.getText().equals("") && !this.mMetaDataFileTextField.getText().equals("")) {
                this.enableOkPaste(true);
            } else {
                this.enableOkPaste(false);
            }
        }
    }

    @Override
    protected void init() {
        super.init();
        this.initVars();
        JPanel jPanel = this.getViewPanel();
        this.setupMainPanel(jPanel);
        this.setFocusTraversalPolicy(new DialogFocusTraversalPolicy(this.setTabTraversal(), false));
        this.pack();
    }

    @Override
    protected void loadDialogState() {
        String string;
        this.mDropSyntax = this.getDialogDataModel().getString("EXPORT_DIMENSION_DROP_SYNTAX_KEY");
        String string2 = this.getDialogDataModel().getString(DATA_FILE_TEXT_FIELD_KEY);
        if (string2 != null) {
            this.mDataFileTextField.setText(string2);
        }
        if ((string = this.getDialogDataModel().getString(META_DATA_FILE_TEXT_FIELD_KEY)) != null) {
            this.mMetaDataFileTextField.setText(string);
        }
        this.enableOkPasteButtons();
        this.setVisible(true);
    }

    @Override
    protected void saveDialogState() {
        super.saveDialogState();
        this.getDialogDataModel().putString("EXPORT_DIMENSION_DROP_SYNTAX_KEY", this.mDropSyntax);
    }

    private void initVars() {
        this.mDataFileTextField = new FileTextField();
        this.mDataFileTextField.setAction(new TextFieldAction(this, DATA_FILE_TEXT_FIELD_KEY));
        this.mDataFileTextField.setText("");
        this.mDataFileTextField.setBorder(null);
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this, "IDS_DATA_FILE_3DOT"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                ExportToDimensionDlg.this.mDataRemoteFileChooser = new RemoteFileChooser(RemoteFileChooser.ChooserType.SaveFile, RemoteFileChooser.ChooserOption.ExportDimensions, System.getProperty("application.home").concat(System.getProperty("file.separator")), false, true, true);
                ExportToDimensionDlg.this.mDataRemoteFileChooser.setDialogTitle(ExportToDimensionDlg.this.getResString("IDS_EXPORT_TO_DIMENSIONS_DATA_FILE_CHOOSER_TITLE"));
                ExportToDimensionDlg.this.mDataRemoteFileChooser.setFileFilter((FileFilter)new RefFileFilter(ExportToDimensionDlg.this.getResString("IDS_EXPORT_TO_DIMENSION_DATA_FILE_TYPE"), ExportToDimensionDlg.this.getResString("IDS_EXPORT_TO_DIMENSION_DATA_FILE_EXTENSION")));
                ExportToDimensionDlg.this.mDataRemoteFileChooser.setAcceptAllFileFilterUsed(false);
                if (ExportToDimensionDlg.this.mDataFileTextField.getText() != null && ExportToDimensionDlg.this.mDataFileTextField.getText().length() > 0) {
                    try {
                        File file = new File(new File(ExportToDimensionDlg.this.mDataFileTextField.getText()).getCanonicalPath());
                        ExportToDimensionDlg.this.mDataRemoteFileChooser.setSelectedFile(file);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if ((n = ExportToDimensionDlg.this.mDataRemoteFileChooser.showSaveDialog((Component)((Object)ExportToDimensionDlg.this))) == 0) {
                    ExportToDimensionDlg.this.mDataFileTextField.setText(ExportToDimensionDlg.this.mDataRemoteFileChooser.getSelectedFile().toString().endsWith(".sav") ? ExportToDimensionDlg.this.mDataRemoteFileChooser.getSelectedFile().toString() : ExportToDimensionDlg.this.mDataRemoteFileChooser.getSelectedFile().toString() + ".sav");
                    RefWindowsFileChooserUI refWindowsFileChooserUI = (RefWindowsFileChooserUI)((Object)ExportToDimensionDlg.this.mDataRemoteFileChooser.getUI());
                    ExportToDimensionDlg.this.mDropSyntax = refWindowsFileChooserUI.getDropVariablesSyntax();
                    ExportToDimensionDlg.this.enableOkPasteButtons();
                    ProcedureDlgMgr.getMgr().savePersistentState("SAVE_DATA_VARIABLES", null);
                } else {
                    ComponentState.trace1((String)"No Selection", (int)15);
                }
            }
        };
        this.mDataFileButton = new JButton(toggleButtonAction);
        this.mMetaDataFileTextField = new FileTextField();
        this.mMetaDataFileTextField.setAction(new TextFieldAction(this, META_DATA_FILE_TEXT_FIELD_KEY));
        this.mMetaDataFileTextField.setText("");
        this.mMetaDataFileTextField.setBorder(null);
        toggleButtonAction = new ToggleButtonAction(this, "IDS_METADATA_FILE_3DOT"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                ExportToDimensionDlg.this.mMetadataRemoteFileChooser = new RemoteFileChooser(RemoteFileChooser.ChooserType.SaveFile, RemoteFileChooser.ChooserOption.ExportDimensions, System.getProperty("application.home").concat(System.getProperty("file.separator")), false, false, true);
                ExportToDimensionDlg.this.mMetadataRemoteFileChooser.setDialogTitle(ExportToDimensionDlg.this.getResString("IDS_EXPORT_TO_DIMENSIONS_METADATA_FILE_CHOOSER_TITLE"));
                ExportToDimensionDlg.this.mMetadataRemoteFileChooser.setFileFilter((FileFilter)new RefFileFilter(ExportToDimensionDlg.this.getResString("IDS_EXPORT_TO_DIMENSION_FILE_TYPE"), ExportToDimensionDlg.this.getResString("IDS_EXPORT_TO_DIMENSION_FILE_EXTENSION")));
                ExportToDimensionDlg.this.mMetadataRemoteFileChooser.setAcceptAllFileFilterUsed(false);
                if (ExportToDimensionDlg.this.mMetaDataFileTextField.getText() != null && ExportToDimensionDlg.this.mMetaDataFileTextField.getText().length() > 0) {
                    try {
                        File file = new File(new File(ExportToDimensionDlg.this.mMetaDataFileTextField.getText()).getCanonicalPath());
                        ExportToDimensionDlg.this.mMetadataRemoteFileChooser.setSelectedFile(file);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if ((n = ExportToDimensionDlg.this.mMetadataRemoteFileChooser.showSaveDialog((Component)((Object)ExportToDimensionDlg.this))) == 0) {
                    ExportToDimensionDlg.this.mMetaDataFileTextField.setText(ExportToDimensionDlg.this.mMetadataRemoteFileChooser.getSelectedFile().toString().endsWith(".mdd") ? ExportToDimensionDlg.this.mMetadataRemoteFileChooser.getSelectedFile().toString() : ExportToDimensionDlg.this.mMetadataRemoteFileChooser.getSelectedFile().toString() + ".mdd");
                    ExportToDimensionDlg.this.enableOkPasteButtons();
                } else {
                    ComponentState.trace1((String)"No Selection", (int)15);
                }
            }
        };
        this.mMetaDataFileButton = new JButton(toggleButtonAction);
        this.mDataFileButton.setPreferredSize(this.mMetaDataFileButton.getMinimumSize());
        this.mDataFileTextField.setEditable(false);
        this.mDataFileTextField.setOpaque(false);
        this.mMetaDataFileTextField.setEditable(false);
        this.mMetaDataFileTextField.setOpaque(false);
        this.enableOkPaste(false);
    }

    public void setMessageText(JTextArea jTextArea, String string) {
        jTextArea.setText(string);
        FontMetrics fontMetrics = this.getFontMetrics(jTextArea.getFont());
        String[] stringArray = string.split("\n");
        int n = 0;
        int n2 = 0;
        for (String string2 : stringArray) {
            n2 = fontMetrics.stringWidth(string2);
            n = n2 > n ? n2 : n;
        }
        int n3 = (int)Math.ceil((float)n / 434.0f);
        jTextArea.setRows(n3 + stringArray.length - 1);
        int n4 = n >= 434 ? 40 : (int)Math.ceil(n / 11) + 1;
        jTextArea.setColumns(n4);
    }

    private void setupMainPanel(JPanel jPanel) {
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        ImageIcon imageIcon = new ImageIcon(ResUtil.getCommonDlgImageResource(ResUtil.getCommonDlgString("IDS_INFO_DOT_IMAGE")));
        JLabel jLabel = new JLabel(imageIcon);
        JTextArea jTextArea = new JTextArea();
        jTextArea.setFocusable(false);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setLineWrap(true);
        this.setMessageText(jTextArea, this.getResString("IDS_EXPORT_DIMENSION_DESCRIPTION"));
        jTextArea.setBackground(jPanel2.getBackground());
        JTextArea jTextArea2 = new JTextArea();
        jTextArea2.setFocusable(false);
        jTextArea2.setWrapStyleWord(true);
        jTextArea2.setLineWrap(true);
        this.setMessageText(jTextArea2, this.getResString("IDS_EXPORT_TO_DIMENSION_INFORMATION"));
        jTextArea2.setBackground(jPanel3.getBackground());
        int n = DialogUtil.getComponentGroupGap();
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n3 = 23;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        Insets insets = new Insets(0, n2, n, 0);
        DialogUtil.addUsingGBL(jPanel2, jTextArea, gridBagConstraints, 0, 0, 1, 1, n3, insets);
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n3, null);
        JSeparator jSeparator = new JSeparator();
        gridBagConstraints.fill = 2;
        insets.set(n, 0, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jSeparator, gridBagConstraints, 0, 1, 1, 1, n3, insets);
        JPanel jPanel4 = new JPanel(new GridBagLayout());
        gridBagConstraints.fill = 0;
        insets.set(n, n2, n, 0);
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel4, this.mDataFileButton, gridBagConstraints, 0, 0, 1, 1, n3, insets);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel4, (JComponent)((Object)this.mDataFileTextField), gridBagConstraints, 1, 0, 1, 1, n3, insets);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        DialogUtil.addUsingGBL(jPanel4, this.mMetaDataFileButton, gridBagConstraints, 0, 1, 1, 1, n3, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel4, (JComponent)((Object)this.mMetaDataFileTextField), gridBagConstraints, 1, 1, 1, 1, n3, insets);
        DialogUtil.addUsingGBL(jPanel, jPanel4, gridBagConstraints, 0, 2, 1, 1, n3, insets);
        JSeparator jSeparator2 = new JSeparator();
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jSeparator2, gridBagConstraints, 0, 3, 1, 1, n3, null);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        insets.set(n, n2, n, 0);
        DialogUtil.addUsingGBL(jPanel3, jLabel, gridBagConstraints, 0, 0, 1, 1, n3, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        insets.set(n, n, n, 0);
        DialogUtil.addUsingGBL(jPanel3, jTextArea2, gridBagConstraints, 1, 0, 1, 1, n3, insets);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 4, 1, 1, n3, null);
    }

    private Vector<Object> setTabTraversal() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mDataFileButton);
        vector.add(this.mMetaDataFileButton);
        for (int i = 0; i < this.mCmdButtonPanel.getComponentCount(); ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        return vector;
    }
}

