/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.file;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.ui.controls.FixedLengthDocument;
import com.spss.java_client.ui.dialogs.base.file.res.FileResBundle;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.dialogs.BaseDialog;
import com.spss.uitools.help.StatsHelp;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;

public class EncryptionPasswordDlg
extends BaseDialog {
    private JPasswordField mPasswordTextField;
    private JPasswordField mConfirmTextField;
    private boolean mOkSelected = false;
    private JTextArea mCautionLabel;

    public EncryptionPasswordDlg(SpssFrame spssFrame) {
        super((JFrame)spssFrame, true, ResUtil.getBundle(FileResBundle.getDefaultResourceBundleName(), ResUtil.getLocale()), FileResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_ENCRYPT_DIALGO_TITLE"));
        this.setLocationRelativeTo(this.getParent());
    }

    public void doHelp() {
        String string = VersionInfo.isSmartReader() ? "idh_password_protect_smartreader" : "idh_idd_password_protect";
        StatsHelp.getStatsHelp().showHelp(StatsHelp.Book.BASE, string);
    }

    protected void init() {
        super.init();
        JPanel jPanel = this.getViewPanel();
        this.initVars();
        this.setUpUI(jPanel);
        this.setFocusTraversalPolicy();
        this.pack();
    }

    protected JPanel setupCmdButtonPanel() {
        JPanel jPanel = new JPanel(true);
        Insets insets = DialogUtil.getStandardButtonInsets();
        jPanel.setBorder(new EmptyBorder(DialogUtil.getMainButtonGap(), 0, 0, 0));
        int n = insets.left + insets.right;
        JButton jButton = new JButton(new CancelAction());
        JButton jButton2 = new JButton(new OkAction());
        JButton jButton3 = new JButton((Action)this.createHelpAction());
        DialogUtil.setupMacHelpButton(jButton3);
        jPanel.setBorder(new EmptyBorder(DialogUtil.getMainButtonGap(), 0, 0, 0));
        if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
            jPanel.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            Insets insets2 = new Insets(0, n, 0, 0);
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 2;
            int n2 = 24;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 0;
            DialogUtil.addUsingGBL(jPanel, jButton3, gridBagConstraints, 0, 0, 1, 1, n2, null);
            DialogUtil.addUsingGBL(jPanel, jButton, gridBagConstraints, 1, 0, 1, 1, n2, insets2);
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 0.0;
            DialogUtil.addUsingGBL(jPanel, jButton2, gridBagConstraints, 2, 0, 1, 1, n2, insets2);
        } else {
            FlowLayout flowLayout = new FlowLayout(1, n, 0);
            jPanel.setLayout(flowLayout);
            jPanel.add(jButton2);
            jPanel.add(jButton);
            jPanel.add(jButton3);
        }
        this.getRootPane().setDefaultButton(jButton2);
        DialogUtil.createCmdButtonGroup(jPanel);
        return jPanel;
    }

    private void setUpUI(JPanel jPanel) {
        JPanel jPanel2 = this.getPasswordPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        int n = 23;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n, null);
    }

    private JPanel getPasswordPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        TitledBorder titledBorder = new TitledBorder(this.getResString("IDS_ENCRYPT_FILE_PASSWORD_GROUP_BOX"));
        jPanel.setBorder(titledBorder);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n = 23;
        Insets insets = new Insets(DialogUtil.getStandardControlInsets().top, DialogUtil.getStandardControlInsets().left, DialogUtil.getStandardControlInsets().bottom + 3, DialogUtil.getStandardControlInsets().right);
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_ENCRYPT_SPECIFY_PASSWORD_LABEL");
        jLabel.setLabelFor(this.mPasswordTextField);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mPasswordTextField, gridBagConstraints, 0, 1, 1, 1, n, insets);
        JLabel jLabel2 = DialogUtil.createLabel(this, "IDS_ENCRYPT_CONFIRM_PASSWORD_LABEL");
        jLabel2.setLabelFor(this.mConfirmTextField);
        DialogUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 0, 2, 1, 1, n, insets);
        DialogUtil.addUsingGBL(jPanel, this.mConfirmTextField, gridBagConstraints, 0, 3, 1, 1, n, insets);
        this.mCautionLabel = new JTextArea();
        this.mCautionLabel.setBackground(this.getBackground());
        this.mCautionLabel.setEditable(false);
        this.mCautionLabel.setText(this.getResString("IDS_ENCRYPT_PASSWORD_CAUTION_TEXT"));
        this.mCautionLabel.setOpaque(false);
        DialogUtil.addUsingGBL(jPanel, this.mCautionLabel, gridBagConstraints, 0, 4, 1, 1, n, insets);
        return jPanel;
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mPasswordTextField);
        vector.add(this.mConfirmTextField);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private void initVars() {
        this.mPasswordTextField = new JPasswordField();
        this.mPasswordTextField.setDocument(new FixedLengthDocument(10));
        this.mConfirmTextField = new JPasswordField();
        this.mConfirmTextField.setDocument(new FixedLengthDocument(10));
    }

    private boolean validatePassword() {
        String string;
        boolean bl = false;
        String string2 = this.mPasswordTextField.getPassword().length > 0 ? new String(this.mPasswordTextField.getPassword()) : null;
        String string3 = string = this.mConfirmTextField.getPassword().length > 0 ? new String(this.mConfirmTextField.getPassword()) : null;
        if (string2 != null && string != null && string2.equals(string)) {
            bl = true;
        }
        return bl;
    }

    public boolean isOkSelected() {
        return this.mOkSelected;
    }

    public void useSyntaxCaution(boolean bl) {
        if (bl) {
            this.mCautionLabel.setText(this.getResString("IDS_ENCRYPT_SYNTAX_PASSWORD_CAUTION_TEXT"));
        } else {
            this.mCautionLabel.setText(this.getResString("IDS_ENCRYPT_PASSWORD_CAUTION_TEXT"));
        }
    }

    public String getEncryptFilePassword() {
        return this.mPasswordTextField.getPassword().length > 0 ? new String(this.mPasswordTextField.getPassword()) : null;
    }

    public void setEncryptFilePassword(String string) {
        this.mPasswordTextField.setText(string);
        this.mConfirmTextField.setText(string);
    }

    private class OkAction
    extends AbstractAction {
        OkAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_OK"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = EncryptionPasswordDlg.this.validatePassword();
            if (bl) {
                EncryptionPasswordDlg.this.mOkSelected = true;
                EncryptionPasswordDlg.this.dispose();
            } else {
                String string = EncryptionPasswordDlg.this.mPasswordTextField.getPassword().length > 0 ? EncryptionPasswordDlg.this.getResString("IDS_ENCRYPT_PASSWORD_MISMATCH") : EncryptionPasswordDlg.this.getResString("IDS_ENCRYPT_PASSWORD_BLANK");
                SpssAlertOptionPane.showErrorMessageDialog(EncryptionPasswordDlg.this.mPasswordTextField, string, VersionInfo.getAppVersionString());
                EncryptionPasswordDlg.this.mPasswordTextField.selectAll();
                EncryptionPasswordDlg.this.mPasswordTextField.requestFocusInWindow();
            }
        }
    }

    private class CancelAction
    extends AbstractAction {
        CancelAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_CANCEL"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            EncryptionPasswordDlg.this.dispose();
        }
    }
}

