/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.file;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.comp_util.PassEncrypt;
import com.spss.java_client.core.documents.data.data_access.DacMgr;
import com.spss.java_client.ui.controls.FixedLengthDocument;
import com.spss.java_client.ui.dialogs.base.file.res.FileResBundle;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.doc_types.doc_util.DocUtil;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.controls.FocusableLabel;
import com.spss.uitools.dialogs.BaseDialog;
import com.spss.uitools.help.StatsHelp;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.border.EmptyBorder;

public class EncryptionEnterPasswordDlg
extends BaseDialog {
    private JButton mCancelButton;
    private JButton mOkButton;
    private JPasswordField mPasswordTextField;
    private DacMgr.FileType mFileType;
    private boolean mOkSelected = false;
    JLabel mFileIsPasswordProtectedLabel;
    protected String mFilePath = null;
    DocUtil.EncryptionTestResults mEncryptionTestResults;

    public EncryptionEnterPasswordDlg(JFrame jFrame, String string) {
        super(jFrame, true, ResUtil.getBundle(FileResBundle.getDefaultResourceBundleName(), ResUtil.getLocale()), FileResBundle.getImageFolder());
        this.init(string, null, null);
    }

    public EncryptionEnterPasswordDlg(JFrame jFrame, String string, DacMgr.FileType fileType, DocUtil.EncryptionTestResults encryptionTestResults) {
        super(jFrame, true, ResUtil.getBundle(FileResBundle.getDefaultResourceBundleName(), ResUtil.getLocale()), FileResBundle.getImageFolder());
        this.init(string, fileType, encryptionTestResults);
    }

    private void init(String string, DacMgr.FileType fileType, DocUtil.EncryptionTestResults encryptionTestResults) {
        String string2 = MessageFormat.format(this.getResString("IDS_ENCRYPT_IS_PASSWORD_PROTECTED_LABEL"), string);
        this.mFileIsPasswordProtectedLabel.setText(string2);
        this.setTitle(this.getResString("IDS_ENCRYPT_ENTER_PASSWORD_DIALOG_TITLE"));
        this.mPasswordTextField.requestFocusInWindow();
        this.mFilePath = string;
        this.mFileType = fileType;
        this.mEncryptionTestResults = encryptionTestResults;
        this.setLocationRelativeTo(this.getParent());
    }

    public void doHelp() {
        String string = VersionInfo.isSmartReader() ? "idh_password_protect_smartreader" : "idh_idd_password_protect";
        StatsHelp.getStatsHelp().showHelp(StatsHelp.Book.BASE, string);
    }

    protected void init() {
        super.init();
        JPanel jPanel = this.getViewPanel();
        this.initVars();
        this.setUpUI(jPanel);
        this.setFocusTraversalPolicy();
        this.pack();
    }

    protected JPanel setupCmdButtonPanel() {
        JPanel jPanel = new JPanel(true);
        Insets insets = DialogUtil.getStandardButtonInsets();
        jPanel.setBorder(new EmptyBorder(DialogUtil.getMainButtonGap(), 0, 0, 0));
        int n = insets.left + insets.right;
        this.mCancelButton = new JButton(new CancelAction());
        this.mOkButton = new JButton(new OkAction());
        JButton jButton = new JButton((Action)this.createHelpAction());
        DialogUtil.setupMacHelpButton(jButton);
        jPanel.setBorder(new EmptyBorder(DialogUtil.getMainButtonGap(), 0, 0, 0));
        if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
            jPanel.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            Insets insets2 = new Insets(0, n, 0, 0);
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 2;
            int n2 = 24;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 0;
            DialogUtil.addUsingGBL(jPanel, jButton, gridBagConstraints, 0, 0, 1, 1, n2, insets2);
            DialogUtil.addUsingGBL(jPanel, this.mCancelButton, gridBagConstraints, 1, 0, 1, 1, n2, insets2);
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 0.0;
            DialogUtil.addUsingGBL(jPanel, this.mOkButton, gridBagConstraints, 2, 0, 1, 1, n2, insets2);
        } else {
            FlowLayout flowLayout = new FlowLayout(1, n, 0);
            jPanel.setLayout(flowLayout);
            jPanel.add(this.mOkButton);
            jPanel.add(this.mCancelButton);
            jPanel.add(jButton);
        }
        this.getRootPane().setDefaultButton(this.mOkButton);
        DialogUtil.createCmdButtonGroup(jPanel);
        return jPanel;
    }

    private void setUpUI(JPanel jPanel) {
        JPanel jPanel2 = this.getPasswordPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        int n = 23;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n, null);
    }

    private JPanel getPasswordPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n = 23;
        Insets insets = new Insets(DialogUtil.getStandardControlInsets().top, DialogUtil.getStandardControlInsets().left, DialogUtil.getStandardControlInsets().bottom + 3, DialogUtil.getStandardControlInsets().right);
        this.mFileIsPasswordProtectedLabel = new FocusableLabel();
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_ENCRYPT_ENTER_PASSWORD_PASSWORD_LABEL");
        jLabel.setLabelFor(this.mPasswordTextField);
        DialogUtil.addUsingGBL(jPanel, this.mFileIsPasswordProtectedLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        jPanel2.add(jLabel);
        jPanel2.add(this.mPasswordTextField);
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 1, 1, 1, n, insets);
        return jPanel;
    }

    private void setFocusTraversalPolicy() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mFileIsPasswordProtectedLabel);
        vector.add(this.mPasswordTextField);
        int n = this.mCmdButtonPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            vector.add(this.mCmdButtonPanel.getComponent(i));
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private void initVars() {
        this.mPasswordTextField = new JPasswordField();
        this.mPasswordTextField.setDocument(new FixedLengthDocument(10));
        this.mPasswordTextField.setPreferredSize(new Dimension(300, 30));
    }

    private boolean validatePassword() {
        String string;
        boolean bl = false;
        String string2 = string = this.mPasswordTextField.getPassword().length > 0 ? new String(this.mPasswordTextField.getPassword()) : null;
        if (string != null && string.length() > 0) {
            bl = true;
        }
        return bl;
    }

    public boolean isOkSelected() {
        return this.mOkSelected;
    }

    public String getEncryptFilePassword() {
        return this.mPasswordTextField.getPassword().length > 0 ? new String(this.mPasswordTextField.getPassword()) : null;
    }

    public static enum DataType {
        Data,
        Ouput,
        Syntax;

    }

    private class OkAction
    extends AbstractAction {
        OkAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_OK"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = EncryptionEnterPasswordDlg.this.validatePassword();
            String string = null;
            Vector vector = null;
            if (EncryptionEnterPasswordDlg.this.mEncryptionTestResults != null) {
                EncryptionEnterPasswordDlg.this.mEncryptionTestResults.setRetVal((short)0);
                EncryptionEnterPasswordDlg.this.mEncryptionTestResults.setErrorMsg(null);
            }
            if (bl) {
                Object object;
                String string2 = PassEncrypt.manglePassword((String)new String(EncryptionEnterPasswordDlg.this.mPasswordTextField.getPassword()));
                if (EncryptionEnterPasswordDlg.this.mFileType != null) {
                    if (EncryptionEnterPasswordDlg.this.mFileType == DacMgr.FileType.Data) {
                        object = DacMgr.getSysFileVarInfoReturnInfo((String)EncryptionEnterPasswordDlg.this.mFilePath, (String)string2);
                        vector = object.getVarBlocks();
                        if (EncryptionEnterPasswordDlg.this.mEncryptionTestResults != null) {
                            EncryptionEnterPasswordDlg.this.mEncryptionTestResults.setRetVal(object.getRetVal());
                            EncryptionEnterPasswordDlg.this.mEncryptionTestResults.setErrorMsg(object.getErrorMsg());
                            if (object.getRetVal() == 89) {
                                string = EncryptionEnterPasswordDlg.this.getResString("IDS_ENCRYPT_PASSWORD_INVALID");
                            }
                        }
                    } else {
                        boolean bl2 = DacMgr.isEncryptionPasswordValid((String)EncryptionEnterPasswordDlg.this.mFilePath, (DacMgr.FileType)EncryptionEnterPasswordDlg.this.mFileType, (String)string2);
                        if (!bl2) {
                            string = EncryptionEnterPasswordDlg.this.getResString("IDS_ENCRYPT_PASSWORD_INVALID");
                        }
                    }
                }
                if (string == null) {
                    EncryptionEnterPasswordDlg.this.mOkSelected = true;
                    if (EncryptionEnterPasswordDlg.this.mEncryptionTestResults != null) {
                        if (EncryptionEnterPasswordDlg.this.mEncryptionTestResults instanceof DocUtil.DataEncryptionTestResults) {
                            ((DocUtil.DataEncryptionTestResults)EncryptionEnterPasswordDlg.this.mEncryptionTestResults).setVarBlocks(vector);
                        }
                        if ((object = EncryptionEnterPasswordDlg.this.getEncryptFilePassword()) != null) {
                            EncryptionEnterPasswordDlg.this.mEncryptionTestResults.setMangledPassword(PassEncrypt.manglePassword((String)object));
                        }
                    }
                    EncryptionEnterPasswordDlg.this.dispose();
                }
            } else {
                String string3 = string = EncryptionEnterPasswordDlg.this.mPasswordTextField.getPassword().length > 0 ? EncryptionEnterPasswordDlg.this.getResString("IDS_ENCRYPT_PASSWORD_MISMATCH") : EncryptionEnterPasswordDlg.this.getResString("IDS_ENCRYPT_PASSWORD_BLANK");
            }
            if (string != null) {
                SpssAlertOptionPane.showErrorMessageDialog(EncryptionEnterPasswordDlg.this.mPasswordTextField, string, VersionInfo.getAppVersionString());
                EncryptionEnterPasswordDlg.this.mPasswordTextField.selectAll();
                EncryptionEnterPasswordDlg.this.mPasswordTextField.requestFocusInWindow();
            }
        }
    }

    private class CancelAction
    extends AbstractAction {
        CancelAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_CANCEL"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (EncryptionEnterPasswordDlg.this.mEncryptionTestResults != null) {
                EncryptionEnterPasswordDlg.this.mEncryptionTestResults.setPasswordDlgOKPressed(false);
            }
            EncryptionEnterPasswordDlg.this.dispose();
        }
    }
}

