/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.edit.paste_special;

import com.spss.java_client.core.documents.output.serialize.IOutputFlavor;
import com.spss.java_client.ui.dialogs.base.edit.paste_special.FlavorsListCellRenderer;
import com.spss.java_client.ui.dialogs.base.edit.res.EditResBundle;
import com.spss.java_client.ui.dialogs.common.BaseProcedureDialog;
import com.spss.java_client.ui.dialogs.common.DialogDataModel;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.ProcedureDlgMgr;
import com.spss.java_client.ui.doc_types.output.IViewerWindowEx;
import com.spss.java_client.ui.doc_types.output.ViewerFrame;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.clipboard.AppClipboard;
import com.spss.uitools.dialogs.BaseDialog;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.FlavorEvent;
import java.awt.datatransfer.FlavorListener;
import java.awt.event.ActionEvent;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class PasteSpecialDlg
extends BaseDialog
implements ListSelectionListener,
FlavorListener {
    private IViewerWindowEx mViewerWindow;
    private JButton mOKButton;
    private static final Dimension RESULT_LABEL_SIZE = new Dimension(230, 55);
    private static final Dimension RESULT_IMAGE_SIZE = new Dimension(55, 55);
    private DialogDataModel mDialogDataModel = new DialogDataModel();
    private JList mFlavorsList;
    private JLabel mResultImageLabel;
    private JTextArea mResultMessageLabel;

    public PasteSpecialDlg(Window window, IViewerWindowEx iViewerWindowEx) {
        super(window, true, ResUtil.getBundle(EditResBundle.getDefaultResourceBundleName(), ResUtil.getLocale()), EditResBundle.getImageFolder());
        this.mViewerWindow = iViewerWindowEx;
        this.setTitle(this.getResString("IDS_PST_SPECIAL_TITLE"));
        this.setLocationRelativeTo(this.getParent());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (PasteSpecialDlg.this.isDisplayable()) {
                    ProcedureDlgMgr.getMgr().loadPersistentState(PasteSpecialDlg.this.getIActionKey(), PasteSpecialDlg.this.getDialogDataModel());
                    BaseProcedureDialog.loadState(PasteSpecialDlg.this.getDialogDataModel(), (Container)((Object)PasteSpecialDlg.this), BaseProcedureDialog.NameLabelOption.no_override);
                }
            }
        });
    }

    public void doHelp() {
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        if (listSelectionEvent.getSource() == this.mFlavorsList) {
            Object e = this.mFlavorsList.getSelectedValue();
            String string = "";
            URL uRL = null;
            if (e.equals(IOutputFlavor.NATIVE_FLAVOR)) {
                string = this.getResString("IDS_PST_SPECIAL_INSERT_NATIVE");
                uRL = this.getResImageURL("IDS_PST_SPECIAL_INSERT_NATIVE_IMG");
            } else if (e.equals(IOutputFlavor.HTML_FLAVOR)) {
                string = this.getResString("IDS_PST_SPECIAL_INSERT_HTML");
                uRL = this.getResImageURL("IDS_PST_SPECIAL_INSERT_HTML_IMG");
            } else if (e.equals(IOutputFlavor.RTF_FLAVOR)) {
                string = this.getResString("IDS_PST_SPECIAL_INSERT_RTF");
                uRL = this.getResImageURL("IDS_PST_SPECIAL_INSERT_RTF_IMG");
            } else if (e.equals(IOutputFlavor.TEXT_FLAVOR)) {
                string = this.getResString("IDS_PST_SPECIAL_INSERT_TEXT");
                uRL = this.getResImageURL("IDS_PST_SPECIAL_INSERT_TEXT_IMG");
            } else if (e.equals(IOutputFlavor.IMAGE_FLAVOR)) {
                string = this.getResString("IDS_PST_SPECIAL_INSERT_IMAGE");
                uRL = this.getResImageURL("IDS_PST_SPECIAL_INSERT_IMAGE_IMG");
            }
            this.mResultMessageLabel.setText(string);
            this.mResultMessageLabel.setSize(RESULT_LABEL_SIZE);
            this.mResultImageLabel.setIcon(new ImageIcon(uRL));
            this.mResultImageLabel.setSize(RESULT_IMAGE_SIZE);
        }
    }

    @Override
    public void flavorsChanged(FlavorEvent flavorEvent) {
        this.populateFlavorsList();
    }

    protected void init() {
        super.init();
        this.initVars();
        this.setupViewPanel(this.getViewPanel());
        Toolkit.getDefaultToolkit().getSystemClipboard().addFlavorListener(this);
        this.populateFlavorsList();
        this.pack();
    }

    protected JPanel setupCmdButtonPanel() {
        JPanel jPanel = new JPanel(true);
        Insets insets = DialogUtil.getStandardButtonInsets();
        if (DialogUtil.areCommandButtonsBelow()) {
            jPanel.setBorder(new EmptyBorder(DialogUtil.getMainButtonGap(), 0, 0, 0));
            int n = insets.left + insets.right;
            this.mOKButton = new JButton(new OkAction());
            JButton jButton = new JButton(new CancelAction());
            if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
                jPanel.setLayout(new GridBagLayout());
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                Insets insets2 = new Insets(0, n, 0, 0);
                int n2 = 23;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.fill = 2;
                n2 = 24;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.fill = 0;
                DialogUtil.addUsingGBL(jPanel, jButton, gridBagConstraints, 3, 0, 1, 1, n2, insets2);
                gridBagConstraints.fill = 2;
                gridBagConstraints.weightx = 0.0;
                DialogUtil.addUsingGBL(jPanel, this.mOKButton, gridBagConstraints, 4, 0, 1, 1, n2, insets2);
            } else {
                FlowLayout flowLayout = new FlowLayout(1, n, 0);
                jPanel.setLayout(flowLayout);
                jPanel.add(this.mOKButton);
                jPanel.add(jButton);
            }
        } else {
            jPanel.setBorder(new EmptyBorder(0, DialogUtil.getMainButtonGap(), 0, 0));
            int n = insets.top + insets.bottom;
            BoxLayout boxLayout = new BoxLayout(jPanel, 1);
            jPanel.setLayout(boxLayout);
            jPanel.add(Box.createVerticalStrut(n * 2));
            this.mOKButton = new JButton(new OkAction());
            jPanel.add(this.mOKButton);
            jPanel.add(Box.createVerticalStrut(n));
            JButton jButton = new JButton(new CancelAction());
            jPanel.add(jButton);
            jPanel.add(Box.createVerticalStrut(n));
        }
        return jPanel;
    }

    private void populateFlavorsList() {
        boolean bl;
        DataFlavor[] dataFlavorArray;
        this.mFlavorsList.removeListSelectionListener(this);
        DefaultListModel defaultListModel = (DefaultListModel)this.mFlavorsList.getModel();
        defaultListModel.clear();
        AppClipboard appClipboard = AppClipboard.getAppClipboard();
        for (DataFlavor dataFlavor : dataFlavorArray = IOutputFlavor.OUTPUT_FLAVORS) {
            if (!appClipboard.isFlavorAvailable(dataFlavor)) continue;
            defaultListModel.addElement(dataFlavor);
        }
        this.mFlavorsList.addListSelectionListener(this);
        boolean bl2 = bl = defaultListModel.getSize() > 0;
        if (bl) {
            this.mFlavorsList.setSelectedIndex(0);
        }
        this.mOKButton.setEnabled(bl);
    }

    private void initVars() {
        this.mFlavorsList = new JList(new DefaultListModel());
        this.mFlavorsList.setCellRenderer(new FlavorsListCellRenderer());
        this.mFlavorsList.setSelectionMode(0);
        this.mFlavorsList.addListSelectionListener(this);
        this.mResultImageLabel = new JLabel();
        this.mResultImageLabel.setMinimumSize(RESULT_IMAGE_SIZE);
        this.mResultMessageLabel = new JTextArea();
        this.mResultMessageLabel.setLineWrap(true);
        this.mResultMessageLabel.setWrapStyleWord(true);
        this.mResultMessageLabel.setBorder(null);
        this.mResultMessageLabel.setOpaque(false);
        this.mResultMessageLabel.setFocusable(false);
        this.mResultMessageLabel.setPreferredSize(new Dimension(100, 45));
        this.mResultImageLabel.setMinimumSize(RESULT_LABEL_SIZE);
    }

    private void setupViewPanel(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_PST_SPECIAL_PASTE_AS");
        jLabel.setLabelFor(this.mFlavorsList);
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        JScrollPane jScrollPane = new JScrollPane(this.mFlavorsList);
        jScrollPane.setPreferredSize(new Dimension(230, 80));
        jScrollPane.setVerticalScrollBarPolicy(20);
        jScrollPane.setHorizontalScrollBarPolicy(30);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        n = 21;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        Insets insets2 = (Insets)insets.clone();
        insets2.top = DialogUtil.getComponentGroupGap() * 3;
        DialogUtil.addUsingGBL(jPanel, this.setupResultPanel(), gridBagConstraints, 0, 2, 2, 1, n, insets2);
    }

    private JPanel setupResultPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_PST_SPECIAL_RESULT_TITLE")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        int n = 23;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(n2, n2, n2, n2);
        DialogUtil.addUsingGBL(jPanel, this.mResultImageLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        Insets insets2 = DialogUtil.getStandardControlInsets();
        DialogUtil.addUsingGBL(jPanel, this.mResultMessageLabel, gridBagConstraints, 1, 0, 1, 1, n, insets2);
        return jPanel;
    }

    private DialogDataModel getDialogDataModel() {
        return this.mDialogDataModel;
    }

    private String getIActionKey() {
        return "view_customize_toolbar";
    }

    private class CancelAction
    extends AbstractAction {
        CancelAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_CANCEL"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PasteSpecialDlg.this.dispose();
        }
    }

    private class OkAction
    extends AbstractAction {
        OkAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_OK"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BaseProcedureDialog.saveState(PasteSpecialDlg.this.getDialogDataModel(), (Container)((Object)PasteSpecialDlg.this));
            ProcedureDlgMgr.getMgr().savePersistentState(PasteSpecialDlg.this.getIActionKey(), PasteSpecialDlg.this.getDialogDataModel());
            Object e = PasteSpecialDlg.this.mFlavorsList.getSelectedValue();
            if (e instanceof DataFlavor) {
                Container container = PasteSpecialDlg.this.getParent();
                if (container instanceof ViewerFrame) {
                    ((ViewerFrame)container).doPaste((DataFlavor)e);
                } else {
                    PasteSpecialDlg.this.mViewerWindow.doPaste((DataFlavor)e);
                }
            }
            PasteSpecialDlg.this.dispose();
        }
    }
}

