/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.edit.find;

import com.ibm.statistics.lighttable.ui.LtEditorFrame;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.DocType;
import com.spss.java_client.ui.dialogs.base.edit.find.BaseFindDlg;
import com.spss.java_client.ui.dialogs.base.edit.find.IReplaceAllCallback;
import com.spss.java_client.ui.dialogs.base.edit.find.ISearchProxy;
import com.spss.java_client.ui.dialogs.base.edit.find.SearchOptions;
import com.spss.java_client.ui.dialogs.base.edit.find.ViewerFindBasePanel;
import com.spss.java_client.ui.dialogs.base.edit.find.ViewerFindPanel;
import com.spss.java_client.ui.dialogs.base.edit.find.ViewerRangePanel;
import com.spss.java_client.ui.dialogs.base.edit.find.ViewerReplacePanel;
import com.spss.java_client.ui.dialogs.base.edit.find.ViewerSearchOptions;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.doc_types.output.ViewerDocument;
import com.spss.java_client.ui.doc_types.output.ViewerFrame;
import com.spss.java_client.ui.doc_types.output.ViewerItem;
import com.spss.java_client.ui.texteditor.TextEditorFrame;
import com.spss.pivottable.PTInfo;
import com.spss.pivottable.gui.TableEditorFrame;
import com.spss.uitools.help.StatsHelp;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.util.Stack;
import javax.swing.SwingUtilities;

public class ViewerFindDlg
extends BaseFindDlg
implements WindowFocusListener,
IReplaceAllCallback {
    protected static ViewerSearchOptions sSearchOptions = new ViewerSearchOptions();
    protected static Stack<String> sLookForStack = new Stack();
    protected static Stack<String> sReplaceWithStack = new Stack();
    protected static Stack<String> sSearRange1Stack = new Stack();
    protected static Stack<String> sSearRange2Stack = new Stack();
    private static boolean sSessionFirstTime = true;
    private boolean mTrayWasOn;
    protected ViewerFindPanel mViewerFindPanel;
    protected ViewerReplacePanel mViewerReplacePanel;
    protected ViewerRangePanel mViewerRangePanel;
    private boolean mViewerPanelVisibleSaved;

    public ViewerFindDlg(Window window, ISearchProxy iSearchProxy, boolean bl) {
        super(window, iSearchProxy);
        this.initDialog(bl);
        boolean bl2 = window instanceof TextEditorFrame;
        boolean bl3 = window instanceof TableEditorFrame;
        ViewerFindBasePanel viewerFindBasePanel = this.getSelectedTab();
        this.mViewerPanelVisibleSaved = !bl2 && !bl3;
        viewerFindBasePanel.updateViewerPanesCtrls(this.mViewerPanelVisibleSaved);
        if (sSessionFirstTime) {
            this.clearPersistence();
        }
        this.addWindowFocusListener(this);
        sSearchOptions.setInitiatedFromInPlaceEdit(false);
        this.pack();
        this.setLocationRelativeTo(window);
    }

    public void doHelp() {
        StatsHelp.getStatsHelp().showHelp(StatsHelp.Book.BASE, "idh_search_viewer");
    }

    @Override
    public void updateTitle() {
        String string = this.getResString("IDS_FIND_AND_REPLACE");
        boolean bl = sSearchOptions.getInitiatedFromInPlaceEdit() || sSearchOptions.getInitiatedFromOutOfPlaceFrame();
        String string2 = this.mProxy.getDocumentName();
        if (bl && this.mProxy instanceof ViewerDocument) {
            try {
                ViewerDocument viewerDocument = (ViewerDocument)this.mProxy;
                string2 = viewerDocument.getFocusedViewerItem().getCoreItem().getDescription();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.setTitle(string + " - " + string2);
    }

    public void editingStopped() {
        this.setInitiator();
        ViewerFindBasePanel viewerFindBasePanel = this.getSelectedTab();
        viewerFindBasePanel.updateViewerPanesCtrls(true);
        this.updateTitle();
    }

    @Override
    public boolean findNext() {
        Stack<String> stack = this.getSearchStack();
        int n = stack.size();
        if (n == 0) {
            Toolkit.getDefaultToolkit().beep();
            return false;
        }
        this.setInitiator();
        boolean bl = false;
        String string = (String)stack.get(n - 1);
        if (!this.mProxy.findNext(string, sSearchOptions)) {
            this.setCursor(null);
            this.showNotFoundMsg(string);
            sSearchOptions.setItemDone(false);
            sSearchOptions.setFirstSearch(true);
            sSearchOptions.setSelectedItems(null);
        } else {
            sSearchOptions.setFirstSearch(false);
            bl = true;
            this.setCursor(null);
            if (this.isVisible()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ViewerFindDlg.this.mFindNextButton.requestFocus();
                    }
                });
            }
        }
        return bl;
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl) {
            this.setInitiator();
        }
        super.setVisible(bl);
        if (bl) {
            if (sSessionFirstTime) {
                sSessionFirstTime = false;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ViewerFindDlg.this.setInListLoad(true);
                        ViewerFindBasePanel viewerFindBasePanel = ViewerFindDlg.this.getSelectedTab();
                        viewerFindBasePanel.resetComboText();
                        ViewerFindDlg.this.setInListLoad(false);
                        ViewerFindDlg.this.updateCmdButtons();
                    }
                });
            }
        } else {
            this.mProxy.stopSearch();
        }
    }

    public boolean isReplaceChecked() {
        return this.getSelectedTab() instanceof ViewerReplacePanel;
    }

    public void enableReplace(boolean bl) {
        this.mReplaceButton.setEnabled(bl);
    }

    public void refreshTab(boolean bl) {
        int n = this.mTabbedPane.getSelectedIndex();
        this.mTabbedPane.removeAll();
        this.mTabbedPane.addTab(this.getResString("IDS_EDIT_FIND"), this.mViewerFindPanel);
        this.mTabbedPane.addTab(this.getResString("IDS_EDIT_REPLACE"), this.mViewerReplacePanel);
        if (!bl) {
            this.mTabbedPane.addTab(this.getResString("IDS_EDIT_RANGE"), this.mViewerRangePanel);
        }
        if (n < this.mTabbedPane.getTabCount()) {
            this.mTabbedPane.setSelectedIndex(n);
        }
        sSearchOptions.setInitiatedFromInPlaceEdit(false);
    }

    protected void initDialog(boolean bl) {
        this.mViewerFindPanel = new ViewerFindPanel((Window)this.getParent(), this, this.mProxy, this.getResourceBundle());
        this.mViewerReplacePanel = new ViewerReplacePanel((Window)this.getParent(), this, this.mProxy, this.getResourceBundle());
        this.mViewerRangePanel = new ViewerRangePanel((Window)this.getParent(), this, this.mProxy, this.getResourceBundle());
        this.mTabbedPane.addTab(this.getResString("IDS_EDIT_FIND"), this.mViewerFindPanel);
        this.mTabbedPane.addTab(this.getResString("IDS_EDIT_REPLACE"), this.mViewerReplacePanel);
        if (!bl) {
            this.mTabbedPane.addTab(this.getResString("IDS_EDIT_RANGE"), this.mViewerRangePanel);
        }
    }

    @Override
    public void windowGainedFocus(WindowEvent windowEvent) {
        boolean bl = true;
        if (this.getParent() instanceof ViewerFrame) {
            ViewerFrame viewerFrame = (ViewerFrame)this.getParent();
            boolean bl2 = sSearchOptions.getInitiatedFromInPlaceEdit() || sSearchOptions.getInitiatedFromOutOfPlaceFrame();
            ViewerFindBasePanel viewerFindBasePanel = this.getSelectedTab();
            viewerFindBasePanel.updateViewerPanesCtrls(!bl2);
            bl = viewerFrame.getDocument().getSelectedItemCount(false) == 0 || bl2;
        }
        this.updateSearchEnable(bl);
    }

    @Override
    public void windowLostFocus(WindowEvent windowEvent) {
    }

    @Override
    protected void updateCmdButtons() {
        if (this.mInListLoad) {
            return;
        }
        boolean bl = false;
        ViewerFindBasePanel viewerFindBasePanel = this.getSelectedTab();
        String string = viewerFindBasePanel.getFindString();
        bl = string != null && string.length() > 0;
        this.mFindNextAction.setEnabled(bl);
        if (this.getSelectedTab() instanceof ViewerFindPanel || this.getSelectedTab() instanceof ViewerRangePanel) {
            this.mReplaceButton.setEnabled(false);
            this.mRepAllButton.setEnabled(false);
            if (this.getSelectedTab() instanceof ViewerRangePanel) {
                ViewerRangePanel viewerRangePanel = (ViewerRangePanel)this.getSelectedTab();
                this.mFindNextAction.setEnabled(viewerRangePanel.getFindNextEnableStatus());
                this.getSelectedTab().updateViewerPanesCtrls(false);
            } else {
                this.getSelectedTab().updateViewerPanesCtrls(this.mViewerPanelVisibleSaved);
            }
        } else if (this.getSelectedTab() instanceof ViewerReplacePanel) {
            string = viewerFindBasePanel.getReplaceString();
            this.mReplaceButton.setEnabled(bl);
            this.mRepAllButton.setEnabled(bl);
            this.getSelectedTab().updateViewerPanesCtrls(this.mViewerPanelVisibleSaved);
        }
    }

    private ViewerFindBasePanel getSelectedTab() {
        Component component;
        ViewerFindBasePanel viewerFindBasePanel = (ViewerFindBasePanel)this.mTabbedPane.getSelectedComponent();
        if (viewerFindBasePanel == null && (component = this.mTabbedPane.getComponentAt(0)) instanceof ViewerFindBasePanel) {
            viewerFindBasePanel = (ViewerFindBasePanel)component;
        }
        return viewerFindBasePanel;
    }

    @Override
    public void notifyReplaceAllComplete(int n, int n2) {
        String string;
        String string2;
        PTInfo.savePivotingTrayState((boolean)this.mTrayWasOn);
        sSearchOptions.setReplaceAll(false);
        if (sSearchOptions.getItemsSearched() == 0) {
            string2 = this.getResString("ERR_NOT_SEARCHABLE_MSG");
        } else if (n == 0 && n2 == 0) {
            string2 = this.getResString("ERR_NOTHING_REPLACED");
        } else {
            string = this.getResString("ERR_NUM_REPLACED");
            if (n2 > 0) {
                string = string + String.format(this.getResString("ERR_NUM_SKIPPED"), n2);
            }
            string2 = String.format(string, n);
        }
        if (sSearchOptions.getSearchArea() == SearchOptions.SearchArea.selected) {
            string = this.getResString("ERR_EXPAND_SEARCH");
            int n3 = SpssAlertOptionPane.showConfirmDialog((Window)((Object)this), string2 = string2 + "\n\n" + string, VersionInfo.getAppVersionString(), SpssAlertOptionPane.OptionType.YES_NO_OPTION);
            if (n3 == 1) {
                ViewerFindBasePanel viewerFindBasePanel = this.getSelectedTab();
                viewerFindBasePanel.getAllRadioButton().setSelected(true);
                viewerFindBasePanel.updateUpDownCtrls(true);
            }
        } else {
            SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this), string2, VersionInfo.getAppVersionString());
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ViewerFindDlg.this.mRepAllButton.requestFocus();
            }
        });
        sSearchOptions.setItemDone(false);
        sSearchOptions.setFirstSearch(true);
        sSearchOptions.setSelectedItems(null);
        this.setCursor(null);
    }

    @Override
    protected void doFindNext() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        ViewerFindBasePanel viewerFindBasePanel = this.getSelectedTab();
        String string = viewerFindBasePanel.getFindString();
        if (viewerFindBasePanel instanceof ViewerRangePanel) {
            string = viewerFindBasePanel.getFindRangeString();
            sSearchOptions.setFindType(ViewerSearchOptions.FindType.findrange);
            this.saveRangeValues(string);
        } else {
            sSearchOptions.setFindType(ViewerSearchOptions.FindType.find);
            this.saveFindValue(string);
        }
        this.saveOptions();
        this.setInitiator();
        if (this.getParent() instanceof Window) {
            sSearchOptions.setTopFrame((Window)this.getParent());
        } else {
            sSearchOptions.setTopFrame(null);
        }
        if (!this.mProxy.findNext(string, sSearchOptions)) {
            this.setCursor(null);
            this.showNotFoundMsg(string);
            sSearchOptions.setItemDone(false);
            sSearchOptions.setFirstSearch(true);
            sSearchOptions.setSelectedItems(null);
        } else {
            sSearchOptions.setFirstSearch(false);
            this.setCursor(null);
            if (this.isVisible()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ViewerFindDlg.this.mFindNextButton.requestFocus();
                    }
                });
            }
        }
    }

    @Override
    protected void doReplace() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        ViewerFindBasePanel viewerFindBasePanel = this.getSelectedTab();
        String string = viewerFindBasePanel.getFindString();
        String string2 = viewerFindBasePanel.getReplaceString();
        sSearchOptions.setFindType(ViewerSearchOptions.FindType.replace);
        sSearchOptions.setReplaceString(string2);
        this.saveFindValue(string);
        this.saveReplaceValue(string2);
        this.saveOptions();
        if (this.getParent() instanceof Window) {
            sSearchOptions.setTopFrame((Window)this.getParent());
        } else {
            sSearchOptions.setTopFrame(null);
        }
        if (!this.mProxy.replaceNext(string, string2, sSearchOptions)) {
            this.setCursor(null);
            this.enableReplace(true);
            this.showNotFoundMsg(string);
            sSearchOptions.setItemDone(false);
            sSearchOptions.setFirstSearch(true);
            sSearchOptions.setSelectedItems(null);
        } else {
            sSearchOptions.setFirstSearch(false);
            this.setCursor(null);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ViewerFindDlg.this.mReplaceButton.requestFocus();
                }
            });
        }
    }

    @Override
    protected void doReplaceAll() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        ViewerFindBasePanel viewerFindBasePanel = this.getSelectedTab();
        String string = viewerFindBasePanel.getFindString();
        String string2 = viewerFindBasePanel.getReplaceString();
        sSearchOptions.setFindType(ViewerSearchOptions.FindType.replaceall);
        sSearchOptions.setReplaceString(string2);
        this.saveFindValue(string);
        this.saveReplaceValue(string2);
        this.saveOptions();
        this.setInitiator();
        if (this.getParent() instanceof Window) {
            sSearchOptions.setTopFrame((Window)this.getParent());
        } else {
            sSearchOptions.setTopFrame(null);
        }
        sSearchOptions.setReplaceAll(true);
        this.mTrayWasOn = PTInfo.isPivotingTrayOn();
        PTInfo.savePivotingTrayState((boolean)false);
        if (this.mProxy instanceof ViewerDocument) {
            ((ViewerDocument)this.mProxy).delayedReplaceAll(string, string2, sSearchOptions, this);
        } else {
            int n = 0;
            try {
                n = this.mProxy.replaceAll(string, string2, sSearchOptions);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.notifyReplaceAllComplete(n, 0);
        }
    }

    @Override
    protected Stack<String> getSearchStack() {
        return sLookForStack;
    }

    @Override
    protected Stack<String> getReplaceStack() {
        return sReplaceWithStack;
    }

    @Override
    protected Stack<String> getRange1Stack() {
        return sSearRange1Stack;
    }

    @Override
    protected Stack<String> getRange2Stack() {
        return sSearRange2Stack;
    }

    @Override
    protected SearchOptions getSearchOptions() {
        return sSearchOptions;
    }

    @Override
    public void showNotFoundMsg(String string) {
        Object object;
        Object object2;
        String string2;
        if (sSearchOptions.getItemsSearched() == 0) {
            string2 = this.getResString("ERR_NOT_SEARCHABLE_MSG");
        } else {
            String string3;
            object2 = this.getSelectedTab();
            if (object2 instanceof ViewerRangePanel) {
                string3 = string;
                object = this.getResString("ERR_RANGE_NOT_FOUND_MSG");
                if (string.indexOf("<>") > -1) {
                    String[] stringArray = string.split("<>");
                    String[] stringArray2 = this.getResStringArray("IDS_RANGE_MSG");
                    string3 = stringArray2[0] + " " + stringArray[0] + " " + stringArray2[1] + " " + stringArray[1];
                }
                string2 = String.format((String)object, string3);
            } else {
                string3 = this.getResString("ERR_NOT_FOUND_MSG");
                string2 = String.format(string3, string);
            }
        }
        Toolkit.getDefaultToolkit().beep();
        if (sSearchOptions.getItemsSearched() > 0 && (sSearchOptions.getSearchArea() == SearchOptions.SearchArea.selected || sSearchOptions.getInitiatedFromInPlaceEdit())) {
            object2 = this.getResString("ERR_EXPAND_SEARCH");
            int n = SpssAlertOptionPane.showConfirmDialog((Window)((Object)this), string2 = string2 + "\n\n" + (String)object2, VersionInfo.getAppVersionString(), SpssAlertOptionPane.OptionType.YES_NO_OPTION);
            if (n == 1) {
                if (sSearchOptions.getInitiatedFromInPlaceEdit() && (object = sSearchOptions.getCurrentItem().getTopLevelAncestor()) instanceof ViewerFrame) {
                    sSearchOptions.setFirstSearch(true);
                    ((ViewerFrame)object).commitEdits(sSearchOptions);
                }
                object = this.getSelectedTab();
                ((ViewerFindBasePanel)object).getAllRadioButton().setSelected(true);
                ((ViewerFindBasePanel)object).updateUpDownCtrls(true);
                this.saveOptions();
            }
        } else {
            SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this), string2, VersionInfo.getAppVersionString());
        }
    }

    @Override
    protected void loadOptions() {
        ViewerFindBasePanel viewerFindBasePanel = this.getSelectedTab();
        viewerFindBasePanel.loadOptions();
    }

    @Override
    protected void saveOptions() {
        ViewerFindBasePanel viewerFindBasePanel = this.getSelectedTab();
        viewerFindBasePanel.saveOptions();
    }

    private void setInitiator() {
        boolean bl = false;
        if (this.getParent() instanceof ViewerFrame) {
            ViewerFrame viewerFrame = (ViewerFrame)this.getParent();
            ViewerItem viewerItem = viewerFrame.getDocument().getFocusedViewerItem();
            boolean bl2 = bl = viewerItem != null && viewerItem.isInPlaceEdit();
            if (!bl && viewerItem != null && viewerItem.isInEditMode()) {
                viewerFrame.commitEdits(sSearchOptions);
            }
        }
        if (!sSearchOptions.isFirstSearch()) {
            return;
        }
        sSearchOptions.setInitiatedFromInPlaceEdit(bl);
        boolean bl3 = this.mProxy instanceof Window || this.getParent() instanceof TableEditorFrame || this.getParent() instanceof LtEditorFrame;
        sSearchOptions.setInitiatedFromOutOfPlaceFrame(bl3);
    }

    private void updateSearchEnable(boolean bl) {
        ViewerFindBasePanel viewerFindBasePanel = this.getSelectedTab();
        boolean bl2 = this.mInListLoad;
        this.mInListLoad = true;
        viewerFindBasePanel.updateSearchEnable(bl);
        this.mInListLoad = bl2;
    }

    @Override
    protected DocType getDocType() {
        return DocType.OUTPUT_DOC;
    }

    @Override
    protected String getFindKey() {
        return "find_output";
    }

    @Override
    protected String getReplaceKey() {
        return "replace_output";
    }

    @Override
    protected String getRange1Key() {
        return "range1_output";
    }

    @Override
    protected String getRange2Key() {
        return "range2_output";
    }

    protected void saveRangeValues(String string) {
        ViewerFindBasePanel viewerFindBasePanel = this.getSelectedTab();
        if (!(viewerFindBasePanel instanceof ViewerRangePanel)) {
            return;
        }
        ViewerRangePanel viewerRangePanel = (ViewerRangePanel)viewerFindBasePanel;
        String string2 = viewerRangePanel.getValueOneCombo().getEditor().getItem().toString();
        String string3 = viewerRangePanel.getValueTwoCombo().getEditor().getItem().toString();
        Stack<String> stack = this.getRange1Stack();
        this.saveStackValue(stack, string2, this.getRange1Key());
        Stack<String> stack2 = this.getRange2Stack();
        this.saveStackValue(stack2, string3, this.getRange2Key());
        this.loadRangeSelections(stack, stack2, false);
    }
}

