/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.edit.find;

import com.spss.java_client.core.comp_util.OSCheck;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.base.edit.find.BaseFindDlg;
import com.spss.java_client.ui.dialogs.base.edit.find.FindBasePanel;
import com.spss.java_client.ui.dialogs.base.edit.find.ISearchProxy;
import com.spss.java_client.ui.dialogs.base.edit.find.SearchOptions;
import com.spss.java_client.ui.dialogs.base.edit.find.ViewerSearchOptions;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.res.CommonDlgResBundle;
import com.spss.java_client.ui.doc_types.output.IViewerWindow;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.pivottable.gui.TableEditorFrame;
import com.spss.shared.core_tools.system.OSInfo;
import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.net.URL;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;

public class ViewerFindBasePanel
extends FindBasePanel {
    protected JPanel mLowerPanel;
    protected JRadioButton mAllRadio;
    protected JRadioButton mSelectedRadio;
    protected TitledBorder mDirectionBorder;
    protected JRadioButton mUpRadio;
    protected JRadioButton mDownRadio;
    protected TitledBorder mViewerPanesBorder;
    protected JRadioButton mBothRadio;
    protected JRadioButton mContentsRadio;
    protected JRadioButton mOutlineRadio;
    protected JCheckBox mIncludeHiddenCheck;
    protected JLabel mChartsAndTreesLabel;
    protected JCheckBox mMatchCaseCheck;
    protected JCheckBox mMatchWholeCellsCheck;
    protected JCheckBox mFootnoteMarkersCheck;

    public ViewerFindBasePanel(Window window, BaseFindDlg baseFindDlg, ISearchProxy iSearchProxy, ResourceBundle resourceBundle) {
        super(window, baseFindDlg, iSearchProxy, resourceBundle);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.mParentDlg.isInListLoad()) {
            return;
        }
        ViewerSearchOptions viewerSearchOptions = (ViewerSearchOptions)this.mParentDlg.getSearchOptions();
        Object object = actionEvent.getSource();
        if (object == this.mSelectedRadio || object == this.mAllRadio) {
            boolean bl = this.mSelectedRadio.isSelected();
            if (bl) {
                this.mDownRadio.setSelected(true);
            }
            this.updateUpDownCtrls(!bl);
            viewerSearchOptions.setFirstSearch(true);
        } else if (object == this.mUpRadio || object == this.mDownRadio || object == this.mBothRadio || object == this.mContentsRadio || object == this.mOutlineRadio || object == this.mIncludeHiddenCheck || object == this.mMatchCaseCheck || object == this.mMatchWholeCellsCheck) {
            viewerSearchOptions.setFirstSearch(true);
        }
    }

    public void updateViewerPanesCtrls(boolean bl) {
        Color color = bl ? UIManager.getColor("TitledBorder.titleColor") : (this.getBackground() != null ? this.getBackground().darker() : (UIManager.getColor("Panel.background") != null ? UIManager.getColor("Panel.background").darker() : Color.darkGray));
        this.mViewerPanesBorder.setTitleColor(color);
        this.mBothRadio.setEnabled(bl);
        this.mContentsRadio.setEnabled(bl);
        this.mOutlineRadio.setEnabled(bl);
        this.mChartsAndTreesLabel.setEnabled(bl);
        this.mIncludeHiddenCheck.setEnabled(bl);
        boolean bl2 = this.getParent() instanceof TableEditorFrame;
    }

    public void updateUpDownCtrls(boolean bl) {
        Color color = bl ? UIManager.getColor("TitledBorder.titleColor") : this.getBackground().darker();
        this.mDirectionBorder.setTitleColor(color);
        if (!bl && (this.mUpRadio.isFocusOwner() || this.mDownRadio.isFocusOwner())) {
            this.mAllRadio.requestFocusInWindow();
        }
        this.mUpRadio.setEnabled(bl);
        this.mDownRadio.setEnabled(bl);
    }

    public JRadioButton getAllRadioButton() {
        return this.mAllRadio;
    }

    public void updateSearchEnable(boolean bl) {
        if (bl) {
            if (this.mSelectedRadio.isFocusOwner()) {
                this.mAllRadio.requestFocusInWindow();
            }
            this.mAllRadio.setSelected(true);
            this.mSelectedRadio.setEnabled(false);
            this.updateUpDownCtrls(true);
        } else {
            this.mSelectedRadio.setEnabled(true);
        }
    }

    @Override
    protected void showLowerControls(boolean bl) {
        this.mLowerPanel.setVisible(bl);
    }

    protected void loadOptions() {
        ViewerSearchOptions viewerSearchOptions = (ViewerSearchOptions)this.mParentDlg.getSearchOptions();
        this.mMatchCaseCheck.setSelected(viewerSearchOptions.getMatchCase());
        this.mIncludeHiddenCheck.setSelected(viewerSearchOptions.getIncludeHidden());
        this.mMatchWholeCellsCheck.setSelected(viewerSearchOptions.getMatchCells());
        this.mFootnoteMarkersCheck.setSelected(viewerSearchOptions.getFootnoteMarkerOnly());
        ViewerSearchOptions.PaneSelection paneSelection = viewerSearchOptions.getPaneSelection();
        if (paneSelection == ViewerSearchOptions.PaneSelection.contents) {
            this.mContentsRadio.setSelected(true);
        } else if (paneSelection == ViewerSearchOptions.PaneSelection.outline) {
            this.mOutlineRadio.setSelected(true);
        } else {
            this.mBothRadio.setSelected(true);
        }
        SearchOptions.SearchArea searchArea = viewerSearchOptions.getSearchArea();
        if (searchArea == SearchOptions.SearchArea.selected) {
            this.mSelectedRadio.setSelected(true);
        } else {
            this.mAllRadio.setSelected(true);
        }
        SearchOptions.SearchDirection searchDirection = viewerSearchOptions.getSearchDirection();
        if (searchDirection == SearchOptions.SearchDirection.up) {
            this.mUpRadio.setSelected(true);
        } else {
            this.mDownRadio.setSelected(true);
        }
    }

    protected void saveOptions() {
        ViewerSearchOptions viewerSearchOptions = (ViewerSearchOptions)this.mParentDlg.getSearchOptions();
        viewerSearchOptions.setMatchCase(this.mMatchCaseCheck.isSelected());
        viewerSearchOptions.setIncludeHidden(this.mIncludeHiddenCheck.isSelected());
        viewerSearchOptions.setMatchCells(this.mMatchWholeCellsCheck.isSelected());
        viewerSearchOptions.setFootnoteMarkerOnly(this.mFootnoteMarkersCheck.isSelected());
        ViewerSearchOptions.PaneSelection paneSelection = ViewerSearchOptions.PaneSelection.both;
        if (this.mContentsRadio.isSelected()) {
            paneSelection = ViewerSearchOptions.PaneSelection.contents;
            viewerSearchOptions.setCurrentPane(IViewerWindow.PaneType.Content);
        } else if (this.mOutlineRadio.isSelected()) {
            paneSelection = ViewerSearchOptions.PaneSelection.outline;
            viewerSearchOptions.setCurrentPane(IViewerWindow.PaneType.Outline);
        } else if (viewerSearchOptions.isFirstSearch()) {
            viewerSearchOptions.setCurrentPane(IViewerWindow.PaneType.Outline);
        }
        viewerSearchOptions.setPaneSelection(paneSelection);
        SearchOptions.SearchArea searchArea = this.mSelectedRadio.isSelected() ? SearchOptions.SearchArea.selected : SearchOptions.SearchArea.all;
        viewerSearchOptions.setSearchArea(searchArea);
        SearchOptions.SearchDirection searchDirection = this.mUpRadio.isSelected() ? SearchOptions.SearchDirection.up : SearchOptions.SearchDirection.down;
        viewerSearchOptions.setSearchDirection(searchDirection);
    }

    protected JPanel getUpperOptions() {
        JPanel jPanel = new JPanel(new GridBagLayout(), true);
        this.mMatchCaseCheck = new JCheckBox(this.getResString("IDS_MATCH_CASE"));
        if (OSCheck.getOSType() != OSInfo.OSType.MAC) {
            this.mMatchCaseCheck.setMnemonic(this.getDlgAccessKey("IDK_MATCH_CASE_KEY"));
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = DialogUtil.getStandardControlInsets();
        int n2 = 23;
        Insets insets2 = new Insets(3, n, 0, n);
        DialogUtil.addUsingGBL(jPanel, this.mMatchCaseCheck, gridBagConstraints, 0, 1, 1, 1, n2, insets2);
        this.mMatchCaseCheck.addActionListener(this);
        this.mFootnoteMarkersCheck = new JCheckBox(this.getResString("IDS_FIND_FOOTNOTE_MARKERS"));
        if (OSCheck.getOSType() != OSInfo.OSType.MAC) {
            this.mFootnoteMarkersCheck.setMnemonic(this.getDlgAccessKey("IDK_FIND_FOOTNOTE_MARKERS_KEY"));
        }
        DialogUtil.addUsingGBL(jPanel, this.mFootnoteMarkersCheck, gridBagConstraints, 1, 1, 1, 1, n2, insets2);
        this.mFootnoteMarkersCheck.addActionListener(this);
        this.mMatchWholeCellsCheck = new JCheckBox(this.getResString("IDS_MATCH_CELLS"));
        if (OSCheck.getOSType() != OSInfo.OSType.MAC) {
            this.mMatchWholeCellsCheck.setMnemonic(this.getDlgAccessKey("IDK_MATCH_CELLS_KEY"));
        }
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, this.mMatchWholeCellsCheck, gridBagConstraints, 0, 2, 1, 1, n2, insets2);
        this.mMatchWholeCellsCheck.addActionListener(this);
        return jPanel;
    }

    @Override
    protected JPanel getLowerControlPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = DialogUtil.getStandardControlInsets();
        int n2 = 23;
        this.mLowerPanel = new JPanel(new GridBagLayout(), true);
        JPanel jPanel = new JPanel(new GridBagLayout(), true);
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_SEARCH_AREA")));
        Insets insets2 = (Insets)insets.clone();
        insets2.top = n;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(this.mLowerPanel, jPanel, gridBagConstraints, 0, 0, 1, 1, n2, insets2);
        JPanel jPanel2 = new JPanel(new GridBagLayout(), true);
        jPanel2.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_ITEMS_TO_SEARCH")));
        gridBagConstraints.weightx = 0.33;
        gridBagConstraints.weighty = 0.0;
        insets2 = (Insets)insets.clone();
        insets2.bottom = 0;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n2, insets2);
        this.mAllRadio = new JRadioButton(this.getResString("IDS_ALL"));
        if (OSCheck.getOSType() != OSInfo.OSType.MAC) {
            this.mAllRadio.setMnemonic(this.getDlgAccessKey("IDK_ALL_KEY"));
        }
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel2, this.mAllRadio, gridBagConstraints, 0, 0, 1, 1, n2, insets2);
        this.mSelectedRadio = new JRadioButton(this.getResString("IDS_SELECTED"));
        if (OSCheck.getOSType() != OSInfo.OSType.MAC) {
            this.mSelectedRadio.setMnemonic(this.getDlgAccessKey("IDK_SELECTED_KEY"));
        }
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel2, this.mSelectedRadio, gridBagConstraints, 0, 1, 1, 1, n2, insets2);
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        spssButtonGroup.add(this.mAllRadio);
        spssButtonGroup.add(this.mSelectedRadio);
        this.mAllRadio.setSelected(true);
        this.mAllRadio.addActionListener(this);
        this.mSelectedRadio.addActionListener(this);
        JPanel jPanel3 = new JPanel(new GridBagLayout(), true);
        this.mDirectionBorder = BorderFactory.createTitledBorder(this.getResString("IDS_DIRECTION"));
        jPanel3.setBorder(this.mDirectionBorder);
        gridBagConstraints.weightx = 0.33;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 1, 0, 1, 1, n2, insets2);
        this.mDownRadio = new JRadioButton(this.getResString("IDS_DOWN"));
        if (OSCheck.getOSType() != OSInfo.OSType.MAC) {
            this.mDownRadio.setMnemonic(this.getDlgAccessKey("IDK_DOWN_KEY"));
        }
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel3, this.mDownRadio, gridBagConstraints, 0, 0, 1, 1, n2, insets2);
        this.mUpRadio = new JRadioButton(this.getResString("IDS_UP"));
        if (OSCheck.getOSType() != OSInfo.OSType.MAC) {
            this.mUpRadio.setMnemonic(this.getDlgAccessKey("IDK_UP_KEY"));
        }
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel3, this.mUpRadio, gridBagConstraints, 0, 1, 1, 1, n2, insets2);
        spssButtonGroup = new SpssButtonGroup();
        spssButtonGroup.add(this.mDownRadio);
        spssButtonGroup.add(this.mUpRadio);
        this.mDownRadio.setSelected(true);
        this.mUpRadio.addActionListener(this);
        this.mDownRadio.addActionListener(this);
        JPanel jPanel4 = new JPanel(new GridBagLayout(), true);
        this.mViewerPanesBorder = BorderFactory.createTitledBorder(this.getResString("IDS_VIEWER_PANES"));
        jPanel4.setBorder(this.mViewerPanesBorder);
        gridBagConstraints.weightx = 0.33;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        DialogUtil.addUsingGBL(jPanel, jPanel4, gridBagConstraints, 2, 0, 1, 1, n2, insets2);
        this.mBothRadio = new JRadioButton(this.getResString("IDS_BOTH_PANES"));
        if (OSCheck.getOSType() != OSInfo.OSType.MAC) {
            this.mBothRadio.setMnemonic(this.getDlgAccessKey("IDK_BOTH_PANES_KEY"));
        }
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel4, this.mBothRadio, gridBagConstraints, 0, 0, 1, 1, n2, insets2);
        this.mContentsRadio = new JRadioButton(this.getResString("IDS_CONTENTS_PANE"));
        if (OSCheck.getOSType() != OSInfo.OSType.MAC) {
            this.mContentsRadio.setMnemonic(this.getDlgAccessKey("IDK_CONTENTS_PANE_KEY"));
        }
        DialogUtil.addUsingGBL(jPanel4, this.mContentsRadio, gridBagConstraints, 0, 1, 1, 1, n2, insets2);
        this.mOutlineRadio = new JRadioButton(this.getResString("IDS_OUTLINE_PANE"));
        if (OSCheck.getOSType() != OSInfo.OSType.MAC) {
            this.mOutlineRadio.setMnemonic(this.getDlgAccessKey("IDK_OUTLINE_PANE_KEY"));
        }
        gridBagConstraints.weighty = 1.0;
        insets2.bottom = 1;
        DialogUtil.addUsingGBL(jPanel4, this.mOutlineRadio, gridBagConstraints, 0, 2, 1, 1, n2, insets2);
        spssButtonGroup = new SpssButtonGroup();
        spssButtonGroup.add(this.mBothRadio);
        spssButtonGroup.add(this.mContentsRadio);
        spssButtonGroup.add(this.mOutlineRadio);
        this.mBothRadio.setSelected(true);
        this.mBothRadio.addActionListener(this);
        this.mContentsRadio.addActionListener(this);
        this.mOutlineRadio.addActionListener(this);
        this.mIncludeHiddenCheck = new JCheckBox(this.getResString("IDS_INCLUDE_HIDDEN"));
        if (OSCheck.getOSType() != OSInfo.OSType.MAC) {
            this.mIncludeHiddenCheck.setMnemonic(this.getDlgAccessKey("IDK_INCLUDE_HIDDEN_KEY"));
        }
        insets2 = new Insets(n, n, 4, n);
        gridBagConstraints.weighty = 0.0;
        DialogUtil.addUsingGBL(jPanel, this.mIncludeHiddenCheck, gridBagConstraints, 0, 1, 3, 1, n2, insets2);
        this.mIncludeHiddenCheck.addActionListener(this);
        JPanel jPanel5 = new JPanel();
        DialogUtil.applyTopBorder(jPanel5);
        n2 = 22;
        Insets insets3 = new Insets(5, n, 0, n);
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, jPanel5, gridBagConstraints, 0, 2, 3, 1, n2, insets3);
        this.mChartsAndTreesLabel = new JLabel(this.getResString("IDS_CHARTS_WARNING"));
        n2 = 23;
        gridBagConstraints.fill = 0;
        ResourceBundle resourceBundle = ResUtil.getBundle(CommonDlgResBundle.getDefaultResourceBundleName(), ResUtil.getLocale());
        URL uRL = ResUtil.getImageResourceFullPath(CommonDlgResBundle.getImageFolder() + ResUtil.getString(resourceBundle, "IDS_INFO_DOT_IMAGE"));
        this.mChartsAndTreesLabel.setIcon(new ImageIcon(uRL));
        insets2 = new Insets(0, n, 3, n);
        DialogUtil.addUsingGBL(jPanel, this.mChartsAndTreesLabel, gridBagConstraints, 0, 3, 3, 1, n2, insets2);
        return this.mLowerPanel;
    }
}

