/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.edit.find;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.DocType;
import com.spss.java_client.ui.dialogs.base.edit.find.BaseFindDlg;
import com.spss.java_client.ui.dialogs.base.edit.find.FindBasePanel;
import com.spss.java_client.ui.dialogs.base.edit.find.ISearchProxy;
import com.spss.java_client.ui.dialogs.base.edit.find.SearchOptions;
import com.spss.java_client.ui.dialogs.base.edit.find.SyntaxFindBasePanel;
import com.spss.java_client.ui.dialogs.base.edit.find.SyntaxFindPanel;
import com.spss.java_client.ui.dialogs.base.edit.find.SyntaxReplacePanel;
import com.spss.java_client.ui.dialogs.base.edit.find.SyntaxSearchOptions;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.doc_types.syntax.SyntaxFrame;
import com.spss.java_client.ui.doc_types.syntax.SyntaxView;
import com.spss.uitools.help.StatsHelp;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.util.Stack;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;

public class SyntaxFindDlg
extends BaseFindDlg
implements WindowFocusListener {
    protected static Stack<String> sLookForStack = new Stack();
    protected static Stack<String> sReplaceWithStack = new Stack();
    protected static SyntaxSearchOptions sSearchOptions = new SyntaxSearchOptions();
    private static boolean sSessionFirstTime = true;
    private SyntaxFindPanel mSyntaxFindPanel;
    private SyntaxReplacePanel mSyntaxReplacePanel;

    public SyntaxFindDlg(JFrame jFrame, ISearchProxy iSearchProxy) {
        super(jFrame, iSearchProxy);
        this.initDialog();
        this.initReplaceButtonMouseActionRepeater();
        this.mButtonRepeater.addMneumonicRepeater(this.mReplaceButton.getMnemonic(), 8);
        if (sSessionFirstTime) {
            this.clearPersistence();
        }
        this.addWindowFocusListener(this);
        this.pack();
        this.setLocationRelativeTo(jFrame);
    }

    public void doHelp() {
        StatsHelp.getStatsHelp().showHelp(StatsHelp.Book.BASE, "idh_search_syntax_view");
    }

    @Override
    public void updateTitle() {
        String string = this.getResString("IDS_FIND_AND_REPLACE");
        this.setTitle(string + " - " + this.mProxy.getDocumentName());
    }

    @Override
    public boolean findNext() {
        Stack<String> stack = this.getSearchStack();
        int n = stack.size();
        if (n == 0) {
            Toolkit.getDefaultToolkit().beep();
            return false;
        }
        boolean bl = false;
        String string = (String)stack.get(n - 1);
        if (!this.mProxy.findNext(string, sSearchOptions)) {
            this.setCursor(null);
            this.showNotFoundMsg(string);
            sSearchOptions.setFirstSearch(true);
        } else {
            sSearchOptions.setFirstSearch(false);
            bl = true;
            this.setCursor(null);
        }
        return bl;
    }

    public void setFirstSearch() {
        this.getSearchOptions().setFirstSearch(true);
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl && sSessionFirstTime) {
            sSessionFirstTime = false;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SyntaxFindDlg.this.mInListLoad = true;
                    FindBasePanel findBasePanel = (FindBasePanel)SyntaxFindDlg.this.mTabbedPane.getSelectedComponent();
                    findBasePanel.resetComboText();
                    SyntaxFindDlg.this.mInListLoad = false;
                    SyntaxFindDlg.this.updateCmdButtons();
                }
            });
        }
    }

    @Override
    protected void updateCmdButtons() {
        if (this.mInListLoad) {
            return;
        }
        boolean bl = false;
        FindBasePanel findBasePanel = (FindBasePanel)this.mTabbedPane.getSelectedComponent();
        String string = findBasePanel.getFindString();
        bl = string != null && string.length() > 0;
        this.mFindNextAction.setEnabled(bl);
        if (this.mTabbedPane.getSelectedComponent() instanceof SyntaxFindPanel) {
            this.mReplaceButton.setEnabled(false);
            this.mRepAllButton.setEnabled(false);
        } else if (this.mTabbedPane.getSelectedComponent() instanceof SyntaxReplacePanel) {
            string = findBasePanel.getReplaceString();
            this.mReplaceButton.setEnabled(bl);
            this.mRepAllButton.setEnabled(bl);
        }
    }

    @Override
    public void windowGainedFocus(WindowEvent windowEvent) {
        if (this.getParent() instanceof SyntaxFrame) {
            boolean bl;
            SyntaxFindBasePanel syntaxFindBasePanel = (SyntaxFindBasePanel)this.mTabbedPane.getSelectedComponent();
            boolean bl2 = this.mInListLoad;
            this.mInListLoad = true;
            SyntaxFrame syntaxFrame = (SyntaxFrame)this.getParent();
            SyntaxView syntaxView = syntaxFrame.getSyntaxView();
            boolean bl3 = bl = syntaxView.getSyntaxMasterPanel().getSyntaxTextPane().getSelectionEnd() - syntaxView.getSyntaxMasterPanel().getSyntaxTextPane().getSelectionStart() > 0;
            if (!bl && syntaxFindBasePanel.getSelectedRadio().isSelected()) {
                syntaxFindBasePanel.setAllRadioSelected(true);
            }
            syntaxFindBasePanel.getSelectedRadio().setEnabled(bl);
            this.mInListLoad = bl2;
        }
    }

    @Override
    public void windowLostFocus(WindowEvent windowEvent) {
    }

    @Override
    protected void doFindNext() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        FindBasePanel findBasePanel = (FindBasePanel)this.mTabbedPane.getSelectedComponent();
        String string = findBasePanel.getFindString();
        this.saveFindValue(string);
        this.saveOptions();
        if (!this.mProxy.findNext(string, sSearchOptions)) {
            this.setCursor(null);
            this.showNotFoundMsg(string);
            sSearchOptions.setFirstSearch(true);
        } else {
            sSearchOptions.setFirstSearch(false);
            this.setCursor(null);
        }
        Component component = findBasePanel.getFindCombo().getEditor().getEditorComponent();
        if (component instanceof JTextComponent) {
            component.requestFocus();
            ((JTextComponent)component).selectAll();
        }
    }

    @Override
    protected void doReplace() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        FindBasePanel findBasePanel = (FindBasePanel)this.mTabbedPane.getSelectedComponent();
        String string = findBasePanel.getFindString();
        String string2 = findBasePanel.getReplaceString();
        this.saveFindValue(string);
        this.saveReplaceValue(string2);
        this.saveOptions();
        if (!this.mProxy.replaceNext(string, string2, sSearchOptions)) {
            this.setCursor(null);
            this.showNotFoundMsg(string);
            sSearchOptions.setFirstSearch(true);
        } else {
            sSearchOptions.setFirstSearch(false);
            this.setCursor(null);
        }
    }

    @Override
    protected void doReplaceAll() {
        String string;
        String string2;
        this.setCursor(Cursor.getPredefinedCursor(3));
        SyntaxFindBasePanel syntaxFindBasePanel = (SyntaxFindBasePanel)this.mTabbedPane.getSelectedComponent();
        String string3 = syntaxFindBasePanel.getFindString();
        String string4 = syntaxFindBasePanel.getReplaceString();
        this.saveFindValue(string3);
        this.saveReplaceValue(string4);
        this.saveOptions();
        int n = 0;
        try {
            n = this.mProxy.replaceAll(string3, string4, sSearchOptions);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (sSearchOptions.getItemsSearched() == 0) {
            string2 = this.getResString("ERR_NOT_SEARCHABLE_MSG");
        } else if (n == 0) {
            string2 = this.getResString("ERR_NOTHING_REPLACED");
        } else {
            string = this.getResString("ERR_NUM_REPLACED");
            string2 = String.format(string, n);
        }
        if (sSearchOptions.getSearchArea() == SearchOptions.SearchArea.selected) {
            string = this.getResString("ERR_EXPAND_SEARCH");
            int n2 = SpssAlertOptionPane.showConfirmDialog((Window)((Object)this), string2 = string2 + "\n\n" + string, VersionInfo.getAppVersionString(), SpssAlertOptionPane.OptionType.YES_NO_OPTION);
            if (n2 == 1) {
                syntaxFindBasePanel.setAllRadioSelected(true);
                syntaxFindBasePanel.updateUpDownCtrls(true);
            }
        } else {
            SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this), string2, VersionInfo.getAppVersionString());
        }
        sSearchOptions.setFirstSearch(true);
        this.setCursor(null);
    }

    @Override
    protected Stack<String> getSearchStack() {
        return sLookForStack;
    }

    @Override
    protected Stack<String> getReplaceStack() {
        return sReplaceWithStack;
    }

    @Override
    protected SearchOptions getSearchOptions() {
        return sSearchOptions;
    }

    @Override
    public void showNotFoundMsg(String string) {
        String string2;
        String string3;
        super.stopCurrentRepeatAction();
        if (sSearchOptions.getItemsSearched() == 0) {
            string3 = this.getResString("ERR_NOT_SEARCHABLE_MSG");
        } else {
            string2 = this.getResString("ERR_NOT_FOUND_MSG");
            string3 = String.format(string2, string);
        }
        Toolkit.getDefaultToolkit().beep();
        if (sSearchOptions.getSearchArea() == SearchOptions.SearchArea.selected) {
            string2 = this.getResString("ERR_EXPAND_SEARCH");
            int n = SpssAlertOptionPane.showConfirmDialog((Window)((Object)this), string3 = string3 + "\n\n" + string2, VersionInfo.getAppVersionString(), SpssAlertOptionPane.OptionType.YES_NO_OPTION);
            if (n == 1) {
                SyntaxFindBasePanel syntaxFindBasePanel = (SyntaxFindBasePanel)this.mTabbedPane.getSelectedComponent();
                syntaxFindBasePanel.setAllRadioSelected(true);
                syntaxFindBasePanel.updateUpDownCtrls(true);
                this.saveOptions();
            }
        } else {
            JOptionPane.showMessageDialog((Component)((Object)this), string3, VersionInfo.getAppVersionString(), 1);
        }
    }

    protected void initDialog() {
        this.mSyntaxFindPanel = new SyntaxFindPanel((JFrame)this.getParent(), (BaseFindDlg)this, this.mProxy, this.getResourceBundle());
        this.mSyntaxReplacePanel = new SyntaxReplacePanel((JFrame)this.getParent(), (BaseFindDlg)this, this.mProxy, this.getResourceBundle());
        this.mTabbedPane.addTab(this.getResString("IDS_EDIT_FIND"), this.mSyntaxFindPanel);
        this.mTabbedPane.addTab(this.getResString("IDS_EDIT_REPLACE"), this.mSyntaxReplacePanel);
    }

    @Override
    protected void loadOptions() {
        SyntaxFindBasePanel syntaxFindBasePanel = (SyntaxFindBasePanel)this.mTabbedPane.getSelectedComponent();
        syntaxFindBasePanel.loadOptions();
    }

    @Override
    protected void saveOptions() {
        SyntaxFindBasePanel syntaxFindBasePanel = (SyntaxFindBasePanel)this.mTabbedPane.getSelectedComponent();
        syntaxFindBasePanel.saveOptions();
    }

    @Override
    protected DocType getDocType() {
        return DocType.OUTPUT_DOC;
    }

    @Override
    protected String getFindKey() {
        return "find_output";
    }

    @Override
    protected String getReplaceKey() {
        return "replace_output";
    }
}

