/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.edit.find;

import com.spss.java_client.core.comp_util.OSCheck;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.base.edit.find.BaseFindDlg;
import com.spss.java_client.ui.dialogs.base.edit.find.FindBasePanel;
import com.spss.java_client.ui.dialogs.base.edit.find.ISearchProxy;
import com.spss.java_client.ui.dialogs.base.edit.find.SearchOptions;
import com.spss.java_client.ui.dialogs.base.edit.find.SyntaxFindDlg;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.shared.core_tools.system.OSInfo;
import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;

public class SyntaxFindBasePanel
extends FindBasePanel {
    protected JPanel mLowerPanel;
    protected JRadioButton mAllRadio;
    protected JRadioButton mSelectedRadio;
    protected TitledBorder mDirectionBorder;
    protected JRadioButton mUpRadio;
    protected JRadioButton mDownRadio;
    protected JCheckBox mMatchCaseCheck;
    protected JCheckBox mTreatNewlineCheck;

    public SyntaxFindBasePanel(JFrame jFrame, BaseFindDlg baseFindDlg, ISearchProxy iSearchProxy, ResourceBundle resourceBundle) {
        super(jFrame, baseFindDlg, iSearchProxy, resourceBundle);
    }

    @Override
    protected void showLowerControls(boolean bl) {
        this.mLowerPanel.setVisible(bl);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.mParentDlg.isInListLoad()) {
            return;
        }
        Object object = actionEvent.getSource();
        if (object == this.mSelectedRadio || object == this.mAllRadio) {
            boolean bl = this.mSelectedRadio.isSelected();
            if (bl) {
                this.mDownRadio.setSelected(true);
            }
            this.updateUpDownCtrls(!bl);
            SyntaxFindDlg.sSearchOptions.setFirstSearch(true);
        } else if (object == this.mUpRadio || object == this.mDownRadio || object == this.mMatchCaseCheck) {
            SyntaxFindDlg.sSearchOptions.setFirstSearch(true);
        }
    }

    public void updateUpDownCtrls(boolean bl) {
        Color color = bl ? UIManager.getColor("TitledBorder.titleColor") : this.getBackground().darker();
        this.mDirectionBorder.setTitleColor(color);
        if (!bl && (this.mUpRadio.isFocusOwner() || this.mDownRadio.isFocusOwner())) {
            this.mAllRadio.requestFocusInWindow();
        }
        this.mUpRadio.setEnabled(bl);
        this.mDownRadio.setEnabled(bl);
    }

    public void setAllRadioSelected(boolean bl) {
        this.mAllRadio.setSelected(bl);
    }

    public JRadioButton getSelectedRadio() {
        return this.mSelectedRadio;
    }

    public void loadOptions() {
        this.mMatchCaseCheck.setSelected(SyntaxFindDlg.sSearchOptions.getMatchCase());
        this.mTreatNewlineCheck.setSelected(SyntaxFindDlg.sSearchOptions.getTreatNewline());
        SearchOptions.SearchArea searchArea = SyntaxFindDlg.sSearchOptions.getSearchArea();
        if (searchArea == SearchOptions.SearchArea.selected) {
            this.mSelectedRadio.setSelected(true);
        } else {
            this.mAllRadio.setSelected(true);
        }
        SearchOptions.SearchDirection searchDirection = SyntaxFindDlg.sSearchOptions.getSearchDirection();
        if (searchDirection == SearchOptions.SearchDirection.up) {
            this.mUpRadio.setSelected(true);
        } else {
            this.mDownRadio.setSelected(true);
        }
    }

    public void saveOptions() {
        SyntaxFindDlg.sSearchOptions.setMatchCase(this.mMatchCaseCheck.isSelected());
        SyntaxFindDlg.sSearchOptions.setTreatNewline(this.mTreatNewlineCheck.isSelected());
        SearchOptions.SearchArea searchArea = this.mSelectedRadio.isSelected() ? SearchOptions.SearchArea.selected : SearchOptions.SearchArea.all;
        SyntaxFindDlg.sSearchOptions.setSearchArea(searchArea);
        SearchOptions.SearchDirection searchDirection = this.mUpRadio.isSelected() ? SearchOptions.SearchDirection.up : SearchOptions.SearchDirection.down;
        SyntaxFindDlg.sSearchOptions.setSearchDirection(searchDirection);
    }

    @Override
    protected JPanel getLowerControlPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = DialogUtil.getStandardControlInsets();
        int n2 = 23;
        this.mLowerPanel = new JPanel(new GridBagLayout(), true);
        JPanel jPanel = new JPanel(new GridBagLayout(), true);
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_SEARCH_AREA")));
        Insets insets2 = (Insets)insets.clone();
        insets2.top = n;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(this.mLowerPanel, jPanel, gridBagConstraints, 0, 0, 1, 1, n2, insets2);
        JPanel jPanel2 = new JPanel(new GridBagLayout(), true);
        jPanel2.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_ITEMS_TO_SEARCH")));
        gridBagConstraints.weightx = 0.33;
        gridBagConstraints.weighty = 0.0;
        insets2 = (Insets)insets.clone();
        insets2.bottom = 2;
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n2, insets2);
        this.mAllRadio = new JRadioButton(this.getResString("IDS_ALL"));
        if (OSCheck.getOSType() != OSInfo.OSType.MAC) {
            this.mAllRadio.setMnemonic(this.getDlgAccessKey("IDK_ALL_KEY"));
        }
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        insets2.bottom = 0;
        DialogUtil.addUsingGBL(jPanel2, this.mAllRadio, gridBagConstraints, 0, 0, 1, 1, n2, insets2);
        this.mSelectedRadio = new JRadioButton(this.getResString("IDS_SELECTED"));
        if (OSCheck.getOSType() != OSInfo.OSType.MAC) {
            this.mSelectedRadio.setMnemonic(this.getDlgAccessKey("IDK_SELECTED_KEY"));
        }
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel2, this.mSelectedRadio, gridBagConstraints, 0, 1, 1, 1, n2, insets2);
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        spssButtonGroup.add(this.mAllRadio);
        spssButtonGroup.add(this.mSelectedRadio);
        this.mAllRadio.setSelected(true);
        this.mAllRadio.addActionListener(this);
        this.mSelectedRadio.addActionListener(this);
        JPanel jPanel3 = new JPanel(new GridBagLayout(), true);
        this.mDirectionBorder = BorderFactory.createTitledBorder(this.getResString("IDS_DIRECTION"));
        jPanel3.setBorder(this.mDirectionBorder);
        gridBagConstraints.weightx = 0.33;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        insets2.bottom = 2;
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 1, 0, 1, 1, n2, insets2);
        this.mDownRadio = new JRadioButton(this.getResString("IDS_DOWN"));
        if (OSCheck.getOSType() != OSInfo.OSType.MAC) {
            this.mDownRadio.setMnemonic(this.getDlgAccessKey("IDK_DOWN_KEY"));
        }
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        insets2.bottom = 0;
        DialogUtil.addUsingGBL(jPanel3, this.mDownRadio, gridBagConstraints, 0, 0, 1, 1, n2, insets2);
        this.mUpRadio = new JRadioButton(this.getResString("IDS_UP"));
        if (OSCheck.getOSType() != OSInfo.OSType.MAC) {
            this.mUpRadio.setMnemonic(this.getDlgAccessKey("IDK_UP_KEY"));
        }
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel3, this.mUpRadio, gridBagConstraints, 0, 1, 1, 1, n2, insets2);
        spssButtonGroup = new SpssButtonGroup();
        spssButtonGroup.add(this.mDownRadio);
        spssButtonGroup.add(this.mUpRadio);
        this.mDownRadio.setSelected(true);
        this.mUpRadio.addActionListener(this);
        this.mDownRadio.addActionListener(this);
        return this.mLowerPanel;
    }

    protected JPanel getUpperOptions() {
        JPanel jPanel = new JPanel(new GridBagLayout(), true);
        this.mMatchCaseCheck = new JCheckBox(this.getResString("IDS_MATCH_CASE"));
        if (OSCheck.getOSType() != OSInfo.OSType.MAC) {
            this.mMatchCaseCheck.setMnemonic(this.getDlgAccessKey("IDK_MATCH_CASE_KEY"));
        }
        this.mTreatNewlineCheck = new JCheckBox(this.getResString("IDS_TREAT_NEWLINE"));
        if (OSCheck.getOSType() != OSInfo.OSType.MAC) {
            this.mTreatNewlineCheck.setMnemonic(this.getDlgAccessKey("IDK_TREAT_NEWLINE_KEY"));
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n = DialogUtil.getGroupBoxInnerMargin();
        int n2 = 23;
        Insets insets = new Insets(3, n, 0, n);
        DialogUtil.addUsingGBL(jPanel, this.mMatchCaseCheck, gridBagConstraints, 0, 1, 1, 1, n2, insets);
        this.mMatchCaseCheck.addActionListener(this);
        DialogUtil.addUsingGBL(jPanel, this.mTreatNewlineCheck, gridBagConstraints, 0, 2, 1, 1, n2, insets);
        this.mTreatNewlineCheck.addActionListener(this);
        return jPanel;
    }
}

