/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.edit.find;

import com.spss.java_client.core.comp_util.OSCheck;
import com.spss.java_client.ui.dialogs.base.edit.find.BaseFindDlg;
import com.spss.java_client.ui.dialogs.base.edit.find.ISearchProxy;
import com.spss.java_client.ui.dialogs.base.edit.res.EditResBundle;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.complex_samples.DefineTableModel;
import com.spss.java_client.ui.doc_types.data.DataEditContextMenu;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.clipboard.AppClipboard;
import com.spss.uitools.controls.MouseActionRepeater;
import com.spss.uitools.controls.TypeAheadCombo;
import com.spss.uitools.res.UIToolResUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ResourceBundle;
import java.util.Stack;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;

public abstract class FindBasePanel
extends JPanel
implements ActionListener {
    protected static final int MAX_STACK_SIZE = 10;
    protected boolean mInFullDisplay = false;
    protected ISearchProxy mProxy;
    protected OptionsAction mOptionsAction;
    protected JLabel mFindWhatLabel;
    protected JLabel mReplaceWithLabel;
    protected DisablingCombo mFindCombo;
    protected DisablingCombo mReplaceCombo;
    protected JButton mOptionsButton;
    protected ComponentAdapter mResizeListener = null;
    MouseActionRepeater mButtonRepeater;
    protected ResourceBundle mResBundle = null;
    protected BaseFindDlg mParentDlg;
    protected JComboBox mFindValuesCombo;
    protected DisablingCombo mValueOneCombo;
    protected DisablingCombo mValueTwoCombo;

    public FindBasePanel(Window window, BaseFindDlg baseFindDlg, ISearchProxy iSearchProxy, ResourceBundle resourceBundle) {
        this.mResBundle = resourceBundle;
        this.mParentDlg = baseFindDlg;
        this.initialize();
        this.setExpanded(this.mInFullDisplay);
    }

    protected abstract void showLowerControls(boolean var1);

    protected abstract JPanel getLowerControlPanel();

    public String getFindString() {
        if (this.mFindCombo != null) {
            return this.mFindCombo.getEditor().getItem().toString();
        }
        return "";
    }

    public String getReplaceString() {
        if (this.mReplaceCombo != null) {
            return this.mReplaceCombo.getEditor().getItem().toString();
        }
        return "";
    }

    public String getFindRangeString() {
        String string = "";
        String string2 = this.mValueOneCombo.getEditor().getItem().toString();
        String string3 = this.mValueTwoCombo.getEditor().getItem().toString();
        int n = this.mFindValuesCombo.getSelectedIndex();
        switch (n) {
            case 0: {
                string = string2 + "<>" + string3;
                break;
            }
            case 1: {
                string = ">=" + string2;
                break;
            }
            case 2: {
                string = "<=" + string3;
            }
        }
        return string;
    }

    public DisablingCombo getFindCombo() {
        return this.mFindCombo;
    }

    public void enableReplaceControls() {
        boolean bl = true;
        if (this.mReplaceWithLabel != null) {
            this.mReplaceWithLabel.setEnabled(bl);
        }
        if (this.mReplaceCombo != null) {
            this.mReplaceCombo.setEnabled(bl);
        }
    }

    public void setComboPopupVisible(boolean bl) {
        if (this.mFindCombo != null) {
            this.mFindCombo.setPopupVisible(bl);
        }
        if (this.mReplaceCombo != null) {
            this.mReplaceCombo.setPopupVisible(bl);
        }
    }

    public void loadFindSelections(Stack<String> stack, boolean bl) {
        this.mParentDlg.setInListLoad(true);
        this.loadComboBoxSelections(this.mFindCombo, stack, bl);
        this.mParentDlg.setInListLoad(false);
    }

    public void loadReplaceSelections(Stack<String> stack, boolean bl) {
        this.mParentDlg.setInListLoad(true);
        this.loadComboBoxSelections(this.mReplaceCombo, stack, bl);
        this.mParentDlg.setInListLoad(false);
    }

    public void loadRangeSelections(Stack<String> stack, Stack<String> stack2, boolean bl) {
        this.mParentDlg.setInListLoad(true);
        this.loadComboBoxSelections(this.mValueOneCombo, stack, bl);
        this.loadComboBoxSelections(this.mValueTwoCombo, stack2, bl);
        this.mParentDlg.setInListLoad(false);
    }

    public void requestFindComboFocus() {
        if (this.mFindCombo != null) {
            this.mFindCombo.requestFocusInWindow();
        }
    }

    public void resetComboText() {
        Component component = null;
        if (this.mFindCombo != null && (component = this.mFindCombo.getEditor().getEditorComponent()) instanceof JTextComponent) {
            ((JTextComponent)component).setText("");
        }
        if (this.mReplaceCombo != null && (component = this.mReplaceCombo.getEditor().getEditorComponent()) instanceof JTextComponent) {
            ((JTextComponent)component).setText("");
        }
    }

    protected String getResString(String string) {
        return UIToolResUtil.getString((ResourceBundle)this.mResBundle, (String)string);
    }

    protected String[] getResStringArray(String string) {
        return this.mResBundle.getStringArray(string);
    }

    protected Integer getDlgAccessKey(String string) {
        if (this.mResBundle != null) {
            return (Integer)UIToolResUtil.getObject((String)string, (ResourceBundle)this.mResBundle);
        }
        return null;
    }

    protected JPanel getUpperControlPanel() {
        return null;
    }

    protected void initialize() {
        Insets insets;
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        int n = DialogUtil.getGroupBoxInnerMargin();
        Insets insets2 = DialogUtil.getStandardControlInsets();
        int n2 = 23;
        int n3 = 0;
        JPanel jPanel = this.getUpperControlPanel();
        if (jPanel != null) {
            n3 = 1;
            gridBagConstraints.fill = 1;
            insets = new Insets(0, 0, n / 2, 0);
            DialogUtil.addUsingGBL(this, jPanel, gridBagConstraints, 0, 0, 2, 1, n2, insets);
        }
        this.mOptionsAction = new OptionsAction();
        this.mOptionsButton = new JButton(this.mOptionsAction);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        insets = new Insets(4, insets2.left, 0, insets2.right);
        DialogUtil.addUsingGBL(this, this.mOptionsButton, gridBagConstraints, 0, n3 + 3, 2, 1, n2, insets);
        JPanel jPanel2 = this.getLowerControlPanel();
        gridBagConstraints.fill = 1;
        insets = new Insets(n, 0, 0, 0);
        DialogUtil.addUsingGBL(this, jPanel2, gridBagConstraints, 0, n3 + 4, 2, 1, n2, insets);
        JPanel jPanel3 = new JPanel();
        DialogUtil.applyTopBorder(jPanel3);
        n2 = 22;
        Insets insets3 = new Insets(10, n, 0, n);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(this, jPanel3, gridBagConstraints, 0, n3 + 5, 2, 1, n2, insets3);
    }

    private void setExpanded(boolean bl) {
        int n;
        String string;
        if (bl) {
            string = "<< " + this.getResString("IDS_HIDE_OPTIONS");
            n = this.getDlgAccessKey("IDK_HIDE_OPTIONS_KEY");
        } else {
            string = this.getResString("IDS_SHOW_OPTIONS") + " >>";
            n = this.getDlgAccessKey("IDK_SHOW_OPTIONS_KEY");
        }
        this.mOptionsButton.setText(string);
        if (OSCheck.getOSType() != OSInfo.OSType.MAC) {
            this.mOptionsButton.setMnemonic(n);
        }
        this.showLowerControls(bl);
    }

    private void toggleDialogSize(boolean bl) {
        this.mInFullDisplay = !this.mInFullDisplay;
        this.setExpanded(this.mInFullDisplay);
        if (bl) {
            this.mParentDlg.packEx(this.mInFullDisplay);
        }
    }

    private void loadComboBoxSelections(DisablingCombo disablingCombo, Stack<String> stack, boolean bl) {
        this.mParentDlg.setInListLoad(true);
        if (disablingCombo != null) {
            disablingCombo.removeAllItems();
            for (String string : stack) {
                disablingCombo.insertItemAt(string, 0);
            }
            Component component = disablingCombo.getEditor().getEditorComponent();
            int n = stack.size();
            if (component instanceof JTextComponent && n > 0) {
                JTextComponent jTextComponent = (JTextComponent)component;
                jTextComponent.setText((String)stack.get(n - 1));
                if (bl) {
                    jTextComponent.selectAll();
                }
            }
        }
        this.mParentDlg.setInListLoad(false);
    }

    class DisablingCombo
    extends TypeAheadCombo {
        private final String[] EDITBAR_CONTEXT_MENU_IDS = new String[]{"context_data_cut", "context_data_copy", "context_data_paste", "context_data_clear"};
        private DataEditContextMenu mEditBarContextMenu = new DataEditContextMenu(this.EDITBAR_CONTEXT_MENU_IDS);
        private JPopupMenu mContextMenu;
        private JMenuItem mCopyMenu;
        private JMenuItem mCutMenu;
        private JMenuItem mPasteMenu;
        private JMenuItem mDeleteMenu;
        public static final String IDS_CUT = "IDS_CUT";
        public static final String IDS_COPY = "IDS_COPY";
        public static final String IDS_PASTE = "IDS_PASTE";
        public static final String IDS_DELETE = "IDS_DELETE";

        DisablingCombo() {
            this.initMouseListener();
            this.initClipboardPopup();
        }

        private void initMouseListener() {
            JTextComponent jTextComponent = (JTextComponent)this.getEditor().getEditorComponent();
            if (jTextComponent != null) {
                jTextComponent.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseReleased(MouseEvent mouseEvent) {
                        super.mouseReleased(mouseEvent);
                        if (mouseEvent.isPopupTrigger()) {
                            DisablingCombo.this.showPopup(mouseEvent);
                        }
                    }

                    @Override
                    public void mousePressed(MouseEvent mouseEvent) {
                        super.mousePressed(mouseEvent);
                        if (mouseEvent.isPopupTrigger()) {
                            DisablingCombo.this.showPopup(mouseEvent);
                        }
                    }
                });
            }
        }

        private void initClipboardPopup() {
            this.mCutMenu = new JMenuItem(FindBasePanel.this.mResBundle.getString(IDS_CUT));
            Integer n = this.getMenuNemonic(IDS_CUT);
            this.mCutMenu.setMnemonic(n);
            this.mCutMenu.setAccelerator(KeyStroke.getKeyStroke(88, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
            this.mCutMenu.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DisablingCombo.this.processMenuOption(DisablingCombo.IDS_CUT);
                }
            });
            this.mCopyMenu = new JMenuItem(FindBasePanel.this.mResBundle.getString(IDS_COPY));
            n = this.getMenuNemonic(IDS_COPY);
            this.mCopyMenu.setMnemonic(n);
            this.mCopyMenu.setAccelerator(KeyStroke.getKeyStroke(67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
            this.mCopyMenu.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DisablingCombo.this.processMenuOption(DisablingCombo.IDS_COPY);
                }
            });
            this.mPasteMenu = new JMenuItem(FindBasePanel.this.mResBundle.getString(IDS_PASTE));
            n = this.getMenuNemonic(IDS_PASTE);
            this.mPasteMenu.setMnemonic(n);
            this.mPasteMenu.setAccelerator(KeyStroke.getKeyStroke(86, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
            this.mPasteMenu.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DisablingCombo.this.processMenuOption(DisablingCombo.IDS_PASTE);
                }
            });
            this.mDeleteMenu = new JMenuItem(FindBasePanel.this.mResBundle.getString(IDS_DELETE));
            n = this.getMenuNemonic(IDS_DELETE);
            this.mDeleteMenu.setMnemonic(n);
            this.mDeleteMenu.setAccelerator(KeyStroke.getKeyStroke(127, 0));
            this.mDeleteMenu.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DisablingCombo.this.processMenuOption(DisablingCombo.IDS_DELETE);
                }
            });
            this.mContextMenu = new JPopupMenu();
            this.mContextMenu.add(this.mCutMenu);
            this.mContextMenu.add(this.mCopyMenu);
            this.mContextMenu.add(this.mPasteMenu);
            this.mContextMenu.add(this.mDeleteMenu);
        }

        private void processMenuOption(String string) {
            JTextField jTextField = (JTextField)this.getEditor().getEditorComponent();
            String string2 = jTextField.getSelectedText();
            if (jTextField != null) {
                if (string.equalsIgnoreCase(IDS_CUT) || string.equalsIgnoreCase(IDS_COPY)) {
                    this.setClipboardContents(string2 == null ? "" : string2);
                    if (string.equalsIgnoreCase(IDS_CUT)) {
                        jTextField.replaceSelection("");
                    }
                } else if (string.equalsIgnoreCase(IDS_PASTE)) {
                    String string3 = DefineTableModel.getClipboardContents(jTextField);
                    if (string3 != null && string3.length() > 0) {
                        jTextField.replaceSelection(string3);
                    }
                } else if (string.equalsIgnoreCase(IDS_DELETE)) {
                    jTextField.replaceSelection("");
                }
            }
        }

        private void showPopup(MouseEvent mouseEvent) {
            JTextComponent jTextComponent = (JTextComponent)this.getEditor().getEditorComponent();
            if (jTextComponent != null) {
                AppClipboard appClipboard = AppClipboard.getAppClipboard();
                String string = jTextComponent.getSelectedText();
                boolean bl = string != null && string.length() > 0;
                this.mCutMenu.setEnabled(bl);
                this.mCopyMenu.setEnabled(bl);
                this.mDeleteMenu.setEnabled(bl);
                this.mPasteMenu.setEnabled(appClipboard.isFlavorAvailable(AppClipboard.STRING_FLAVOR));
                this.mContextMenu.show(jTextComponent, mouseEvent.getX(), mouseEvent.getY());
            }
        }

        private void setClipboardContents(String string) {
            StringSelection stringSelection = new StringSelection(string);
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, stringSelection);
        }

        public void setEnabled(boolean bl) {
            super.setEnabled(bl);
            Color color = bl ? Color.white : SystemColor.control;
            this.getEditor().getEditorComponent().setBackground(color);
            Color color2 = bl ? UIManager.getColor("TextField.foreground") : UIManager.getColor("TextField.inactiveForeground");
            this.getEditor().getEditorComponent().setForeground(color2);
            Color color3 = bl ? UIManager.getColor("TextField.selectionBackground") : SystemColor.control;
            ((JTextComponent)this.getEditor().getEditorComponent()).setSelectionColor(color3);
        }

        private Integer getMenuNemonic(String string) {
            ResourceBundle resourceBundle = ResUtil.getBundle(EditResBundle.getDefaultResourceBundleName(), ResUtil.getLocale());
            return (Integer)ResUtil.getObject(string + "_KEY", resourceBundle);
        }
    }

    class OptionsAction
    extends AbstractAction {
        OptionsAction() {
            this.putValue("Name", FindBasePanel.this.getResString("IDS_SHOW_OPTIONS") + " >>");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FindBasePanel.this.toggleDialogSize(true);
        }
    }
}

