/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.edit.find;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.comp_util.OSCheck;
import com.spss.java_client.core.documents.DocType;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.core.documents.data.dictionary.ISpssVariable;
import com.spss.java_client.ui.dialogs.base.edit.find.BaseFindDlg;
import com.spss.java_client.ui.dialogs.base.edit.find.DataFindBasePanel;
import com.spss.java_client.ui.dialogs.base.edit.find.DataFindPanel;
import com.spss.java_client.ui.dialogs.base.edit.find.DataRangePanel;
import com.spss.java_client.ui.dialogs.base.edit.find.DataReplacePanel;
import com.spss.java_client.ui.dialogs.base.edit.find.DataSearchOptions;
import com.spss.java_client.ui.dialogs.base.edit.find.FindBasePanel;
import com.spss.java_client.ui.dialogs.base.edit.find.ISearchProxy;
import com.spss.java_client.ui.dialogs.base.edit.find.SearchOptions;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.doc_types.data.DataFrame;
import com.spss.java_client.ui.doc_types.data.VarViewTable;
import com.spss.java_client.ui.doc_types.data.VarViewTableModel;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.help.StatsHelp;
import java.awt.Cursor;
import java.awt.Toolkit;
import java.awt.Window;
import java.util.Stack;
import javax.swing.JFrame;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;

public class DataFindDlg
extends BaseFindDlg
implements ChangeListener {
    private static boolean sSessionFirstTime = true;
    private DataFrame mFrame;
    private Stack<String> mLookForStack = new Stack();
    private Stack<String> mReplaceWithStack = new Stack();
    private DataSearchOptions mSearchOptions = new DataSearchOptions();
    private boolean mInBackendSearch;
    private DataFindPanel mDataFindPanel;
    private DataReplacePanel mDataReplacePanel;
    private DataRangePanel mDataRangePanel;

    public DataFindDlg(DataFrame dataFrame, ISearchProxy iSearchProxy) {
        super(dataFrame, iSearchProxy);
        this.mFrame = dataFrame;
        this.mInBackendSearch = false;
        this.initDialog(true);
        if (sSessionFirstTime) {
            this.clearPersistence();
        }
        this.pack();
        this.setLocationRelativeTo(dataFrame);
    }

    @Override
    public boolean findNext() {
        Stack<String> stack = this.getSearchStack();
        int n = stack.size();
        if (n == 0) {
            Toolkit.getDefaultToolkit().beep();
            return false;
        }
        this.updateTopControls();
        this.checkForColumnChange();
        if (this.mSearchOptions.isFirstSearch()) {
            this.setupFirstSearch();
        }
        boolean bl = false;
        String string = (String)stack.get(n - 1);
        if (!this.mProxy.findNext(string, this.mSearchOptions)) {
            this.setCursor(null);
            boolean bl2 = this.mFrame.getDataView().getTabbedPane().getSelectedIndex() == 0;
            JTable jTable = this.mFrame.getDataView().getDataTable(bl2 ? 0 : 1);
            this.mSearchOptions.restoreSelections(jTable);
            this.showNotFoundMsg(string);
            this.mSearchOptions.setFirstSearch(true);
        } else {
            this.mSearchOptions.setFirstSearch(false);
            bl = true;
            this.setCursor(null);
        }
        return bl;
    }

    @Override
    public void updateTitle() {
        boolean bl = this.mFrame.getDataView().getTabbedPane().getSelectedIndex() == 0;
        String string = this.getResString("IDS_FIND_AND_REPLACE");
        this.setTitle(string + " - " + ResUtil.getString(bl ? "IDS_DATA_VIEW" : "IDS_VARIABLE_VIEW"));
    }

    public void doHelp() {
        StatsHelp.getStatsHelp().showHelp(StatsHelp.Book.BASE, "idh_search_data_view");
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            this.updateDialogControls();
            this.mFrame.getDataView().getTabbedPane().addChangeListener(this);
            if (sSessionFirstTime) {
                sSessionFirstTime = false;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DataFindDlg.this.setInListLoad(true);
                        FindBasePanel findBasePanel = (FindBasePanel)DataFindDlg.this.mTabbedPane.getSelectedComponent();
                        findBasePanel.resetComboText();
                        DataFindDlg.this.setInListLoad(false);
                        DataFindDlg.this.updateCmdButtons();
                    }
                });
            }
        } else {
            this.mFrame.getDataView().getTabbedPane().removeChangeListener(this);
        }
    }

    public boolean getInBackendSearch() {
        return this.mInBackendSearch;
    }

    public void setInBackendSearch(boolean bl) {
        this.mInBackendSearch = bl;
        this.updateDialogControls();
    }

    @Override
    boolean canClose() {
        if (this.mInBackendSearch) {
            this.mProxy.stopSearch();
            this.setInBackendSearch(false);
            return false;
        }
        return true;
    }

    @Override
    public void updateDialogControls() {
        this.updateTopControls();
        boolean bl = this.mFrame.canSearch(false) && !this.mInBackendSearch;
        boolean bl2 = bl && this.mFrame.canSearch(true);
        boolean bl3 = this.mFrame.getDataView().getActiveView() == 0;
        boolean bl4 = !bl3 || !this.isNumericColumn();
        DataFindBasePanel dataFindBasePanel = (DataFindBasePanel)this.mTabbedPane.getSelectedComponent();
        dataFindBasePanel.updateDialogControls(bl, bl3, bl4);
        this.updateCmdButtons();
        boolean bl5 = bl2 = this.mTabbedPane.getSelectedComponent() instanceof DataReplacePanel && bl2 && this.mReplaceAction.isEnabled();
        if (bl2) {
            bl2 = this.canReplaceWithCurrentText();
        }
        this.mFindNextAction.setEnabled(bl && this.mFindNextAction.isEnabled());
        this.mReplaceAction.setEnabled(bl2);
        this.mReplaceAllAction.setEnabled(bl2);
        String string = this.mInBackendSearch ? "IDS_STOP" : "IDS_CLOSE";
        this.mCloseButton.setText(ResUtil.getCommonDlgString(string));
        if (OSCheck.getOSType() != OSInfo.OSType.MAC) {
            Integer n = null;
            if (this.mInBackendSearch) {
                n = ResUtil.getCommonDlgAccessKey("IDK_STOP");
            }
            if (n == null) {
                n = -1;
            }
            this.mCloseButton.setMnemonic(n);
        }
    }

    @Override
    protected void updateCmdButtons() {
        if (this.mInListLoad) {
            return;
        }
        boolean bl = false;
        FindBasePanel findBasePanel = (FindBasePanel)this.mTabbedPane.getSelectedComponent();
        String string = findBasePanel.getFindString();
        bl = string != null && string.length() > 0;
        this.mFindNextAction.setEnabled(bl);
        if (this.mTabbedPane.getSelectedComponent() instanceof DataFindPanel || this.mTabbedPane.getSelectedComponent() instanceof DataRangePanel) {
            this.mReplaceButton.setEnabled(false);
            this.mRepAllButton.setEnabled(false);
            if (this.mTabbedPane.getSelectedComponent() instanceof DataRangePanel) {
                // empty if block
            }
        } else if (this.mTabbedPane.getSelectedComponent() instanceof DataReplacePanel) {
            string = findBasePanel.getReplaceString();
            this.mReplaceButton.setEnabled(bl);
            this.mRepAllButton.setEnabled(bl);
        }
    }

    @Override
    public DataSearchOptions getSearchOptions() {
        return this.mSearchOptions;
    }

    @Override
    public String getLastFindValue() {
        if (sSessionFirstTime) {
            return "";
        }
        return super.getLastFindValue();
    }

    public void replaceAllResponse(int n) {
        Object object;
        String string;
        boolean bl;
        boolean bl2 = bl = this.mFrame.getDataView().getTabbedPane().getSelectedIndex() == 0;
        if (!bl && this.mSearchOptions.getItemsSearched() == 0) {
            string = this.getResString("ERR_NOT_SEARCHABLE_MSG");
        } else if (n == 0) {
            string = this.getResString("ERR_NOTHING_REPLACED");
        } else {
            object = this.getResString("ERR_NUM_REPLACED");
            string = String.format((String)object, n);
        }
        SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this), string, VersionInfo.getAppVersionString());
        object = this.mFrame.getDataView().getDataTable(bl ? 0 : 1);
        this.mSearchOptions.restoreSelections((JTable)object);
        this.mSearchOptions.setFirstSearch(true);
        this.setCursor(null);
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.updateTitle();
        this.updateDialogControls();
        this.mSearchOptions.setFirstSearch(true);
    }

    protected void initDialog(boolean bl) {
        this.mDataFindPanel = new DataFindPanel((JFrame)this.getParent(), (BaseFindDlg)this, this.mProxy, this.getResourceBundle());
        this.mDataReplacePanel = new DataReplacePanel((JFrame)this.getParent(), (BaseFindDlg)this, this.mProxy, this.getResourceBundle());
        this.mDataRangePanel = new DataRangePanel((JFrame)this.getParent(), (BaseFindDlg)this, this.mProxy, this.getResourceBundle());
        this.mTabbedPane.addTab(this.getResString("IDS_EDIT_FIND"), this.mDataFindPanel);
        this.mTabbedPane.addTab(this.getResString("IDS_EDIT_REPLACE"), this.mDataReplacePanel);
        if (!bl) {
            this.mTabbedPane.addTab(this.getResString("IDS_EDIT_RANGE"), this.mDataRangePanel);
        }
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        if (this.isInListLoad()) {
            return;
        }
        this.getSearchOptions().setFirstSearch(true);
        this.updateDialogControls();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        if (this.isInListLoad()) {
            return;
        }
        this.getSearchOptions().setFirstSearch(true);
        this.updateDialogControls();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        if (this.isInListLoad()) {
            return;
        }
        this.getSearchOptions().setFirstSearch(true);
        this.updateDialogControls();
    }

    @Override
    protected void doFindNext() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        FindBasePanel findBasePanel = (FindBasePanel)this.mTabbedPane.getSelectedComponent();
        String string = findBasePanel.getFindString();
        this.saveFindValue(string);
        this.saveOptions();
        this.checkForColumnChange();
        if (this.mSearchOptions.isFirstSearch()) {
            this.setupFirstSearch();
        }
        if (!this.mProxy.findNext(string, this.mSearchOptions)) {
            this.setCursor(null);
            boolean bl = this.mFrame.getDataView().getTabbedPane().getSelectedIndex() == 0;
            JTable jTable = this.mFrame.getDataView().getDataTable(bl ? 0 : 1);
            this.mSearchOptions.restoreSelections(jTable);
            this.showNotFoundMsg(string);
            this.mSearchOptions.setFirstSearch(true);
        } else {
            this.mSearchOptions.setFirstSearch(false);
        }
        this.setCursor(null);
    }

    @Override
    protected void doReplace() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        FindBasePanel findBasePanel = (FindBasePanel)this.mTabbedPane.getSelectedComponent();
        String string = findBasePanel.getFindString();
        String string2 = findBasePanel.getReplaceString();
        this.saveFindValue(string);
        this.saveReplaceValue(string2);
        this.saveOptions();
        this.checkForColumnChange();
        if (this.mSearchOptions.isFirstSearch()) {
            this.setupFirstSearch();
        }
        if (!this.mProxy.replaceNext(string, string2, this.mSearchOptions)) {
            this.setCursor(null);
            boolean bl = this.mFrame.getDataView().getTabbedPane().getSelectedIndex() == 0;
            JTable jTable = this.mFrame.getDataView().getDataTable(bl ? 0 : 1);
            this.mSearchOptions.restoreSelections(jTable);
            this.showNotFoundMsg(string);
            this.mSearchOptions.setFirstSearch(true);
        } else {
            this.mSearchOptions.setFirstSearch(false);
        }
        this.setCursor(null);
    }

    @Override
    protected void doReplaceAll() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        FindBasePanel findBasePanel = (FindBasePanel)this.mTabbedPane.getSelectedComponent();
        String string = findBasePanel.getFindString();
        String string2 = findBasePanel.getReplaceString();
        this.saveFindValue(string);
        this.saveReplaceValue(string2);
        this.saveOptions();
        this.mSearchOptions.setFirstSearch(true);
        this.setupFirstSearch();
        this.mSearchOptions.setReplaceAll(true);
        try {
            this.mProxy.replaceAll(string, string2, this.mSearchOptions);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.setCursor(null);
    }

    @Override
    protected Stack<String> getSearchStack() {
        return this.mLookForStack;
    }

    @Override
    protected Stack<String> getReplaceStack() {
        return this.mReplaceWithStack;
    }

    @Override
    protected void loadOptions() {
        DataFindBasePanel dataFindBasePanel = (DataFindBasePanel)this.mTabbedPane.getSelectedComponent();
        dataFindBasePanel.loadOptions();
    }

    @Override
    protected void saveOptions() {
        DataFindBasePanel dataFindBasePanel = (DataFindBasePanel)this.mTabbedPane.getSelectedComponent();
        dataFindBasePanel.saveOptions();
    }

    @Override
    protected DocType getDocType() {
        return DocType.DE_DOC;
    }

    @Override
    protected String getFindKey() {
        return "find_data";
    }

    @Override
    protected String getReplaceKey() {
        return "replace_data";
    }

    private void setupFirstSearch() {
        this.saveCurrentSelections();
    }

    private void saveCurrentSelections() {
        boolean bl = this.mFrame.getDataView().getTabbedPane().getSelectedIndex() == 0;
        JTable jTable = this.mFrame.getDataView().getDataTable(bl ? 0 : 1);
        int[] nArray = jTable.getSelectedRows();
        int[] nArray2 = jTable.getSelectedColumns();
        this.mSearchOptions.setSelections(nArray, nArray2);
        int n = jTable.getSelectionModel().getLeadSelectionIndex();
        int n2 = jTable.getColumnModel().getSelectionModel().getLeadSelectionIndex();
        this.mSearchOptions.setFocusCell(n, n2);
        if (nArray.length < 2 && nArray2.length < 2) {
            this.mSearchOptions.setSearchArea(SearchOptions.SearchArea.all);
        } else {
            this.mSearchOptions.setSearchArea(SearchOptions.SearchArea.selected);
        }
    }

    private boolean isNumericColumn() {
        JTable jTable = this.mFrame.getDataView().getDataTable(0);
        int n = jTable.getColumnModel().getSelectionModel().getLeadSelectionIndex();
        ISpssDataSrc iSpssDataSrc = this.mFrame.getDataView().getDataSrc();
        if (n < 0 || iSpssDataSrc == null || n >= iSpssDataSrc.columnCount()) {
            return false;
        }
        ISpssVariable iSpssVariable = this.mFrame.getDataView().getDataSrc().getVariable(n);
        if (iSpssVariable.getType() == 0) {
            return !this.mFrame.getViewValueLabels() || iSpssVariable.getValueLabels().size() <= 0;
        }
        return false;
    }

    private boolean canReplaceWithCurrentText() {
        boolean bl;
        boolean bl2 = true;
        boolean bl3 = bl = this.mFrame.getDataView().getActiveView() == 0;
        if (!bl) {
            bl2 = false;
            VarViewTable varViewTable = (VarViewTable)this.mFrame.getDataView().getDataTable(1);
            int n = varViewTable.getColumnModel().getSelectionModel().getLeadSelectionIndex();
            if (n > -1) {
                boolean bl4 = this.getLastReplaceValue().length() > 0;
                String string = ((VarViewTableModel)varViewTable.getModel()).columnIndexToColumnId(n);
                boolean bl5 = string.startsWith("@");
                if (string.equals("values") || string.equals("label") || bl5 || bl4) {
                    bl2 = true;
                }
            }
        }
        return bl2;
    }

    protected void updateTopControls() {
        boolean bl;
        boolean bl2 = true;
        DataFindBasePanel dataFindBasePanel = (DataFindBasePanel)this.mTabbedPane.getSelectedComponent();
        boolean bl3 = bl = this.mFrame.getDataView().getActiveView() == 0;
        if (bl) {
            int n = this.mFrame.getDataView().getDataSrc().columnCount();
            JTable jTable = this.mFrame.getDataView().getDataTable(0);
            int n2 = jTable.getColumnModel().getSelectionModel().getLeadSelectionIndex();
            if (n2 > -1 && n2 < n) {
                dataFindBasePanel.getColumnName().setText(jTable.getColumnModel().getColumn(n2).getHeaderValue().toString());
            } else {
                dataFindBasePanel.getColumnName().setText("");
                bl2 = false;
            }
        } else {
            JTable jTable = this.mFrame.getDataView().getDataTable(1);
            int n = jTable.getColumnModel().getSelectionModel().getLeadSelectionIndex();
            if (n > -1) {
                dataFindBasePanel.getColumnName().setText(jTable.getColumnModel().getColumn(n).getHeaderValue().toString());
            } else {
                dataFindBasePanel.getColumnName().setText("");
                bl2 = false;
            }
        }
        dataFindBasePanel.getColumnLabel().setEnabled(bl2);
        dataFindBasePanel.getColumnName().setEnabled(bl2);
    }

    private void checkForColumnChange() {
        int n;
        JTable jTable;
        DataFindBasePanel dataFindBasePanel = (DataFindBasePanel)this.mTabbedPane.getSelectedComponent();
        String string = dataFindBasePanel.getColumnName().getText();
        String string2 = "";
        if (this.mFrame.getDataView().getActiveView() == 0) {
            jTable = this.mFrame.getDataView().getDataTable(0);
            n = this.mFrame.getDataView().getDataSrc().columnCount();
        } else {
            jTable = this.mFrame.getDataView().getDataTable(1);
            n = jTable.getColumnModel().getColumnCount();
        }
        int n2 = jTable.getColumnModel().getSelectionModel().getLeadSelectionIndex();
        if (n2 > -1 && n2 < n) {
            string2 = jTable.getColumnModel().getColumn(n2).getHeaderValue().toString();
        }
        if (!string.equals(string2)) {
            this.mSearchOptions.setFirstSearch(true);
        }
    }
}

