/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.edit.find;

import com.spss.java_client.core.comp_util.OSCheck;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.base.edit.find.BaseFindDlg;
import com.spss.java_client.ui.dialogs.base.edit.find.DataSearchOptions;
import com.spss.java_client.ui.dialogs.base.edit.find.FindBasePanel;
import com.spss.java_client.ui.dialogs.base.edit.find.ISearchProxy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.shared.core_tools.system.OSInfo;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class DataFindBasePanel
extends FindBasePanel {
    protected JLabel mColumnLabel;
    protected JLabel mColumnName;
    protected JPanel mLowerPanel;
    protected JRadioButton mContainsRadio;
    protected JRadioButton mExactRadio;
    protected JRadioButton mStartsWithRadio;
    protected JRadioButton mEndsWithRadio;
    protected JCheckBox mMatchCaseCheck;
    protected JRadioButton mSearchUpRadio;
    protected JRadioButton mSearchDownRadio;

    public DataFindBasePanel(JFrame jFrame, BaseFindDlg baseFindDlg, ISearchProxy iSearchProxy, ResourceBundle resourceBundle) {
        super(jFrame, baseFindDlg, iSearchProxy, resourceBundle);
    }

    public void updateDialogControls(boolean bl, boolean bl2, boolean bl3) {
        this.mColumnLabel.setEnabled(this.mColumnLabel.isEnabled() && bl);
        this.mColumnName.setEnabled(this.mColumnLabel.isEnabled() && bl);
        this.mFindWhatLabel.setEnabled(bl);
        if (this.mFindCombo != null) {
            this.mFindCombo.setEnabled(bl);
        }
        this.mContainsRadio.setEnabled(bl);
        this.mExactRadio.setEnabled(bl);
        this.mStartsWithRadio.setEnabled(bl);
        this.mEndsWithRadio.setEnabled(bl);
        this.mMatchCaseCheck.setEnabled(bl && bl3);
        this.mSearchUpRadio.setEnabled(bl && !bl2);
        this.mSearchDownRadio.setEnabled(bl && !bl2);
        if (bl2 && this.mSearchUpRadio.isSelected()) {
            this.mSearchDownRadio.setSelected(true);
        }
    }

    public JLabel getColumnLabel() {
        return this.mColumnLabel;
    }

    public JLabel getColumnName() {
        return this.mColumnName;
    }

    @Override
    protected void showLowerControls(boolean bl) {
        this.mLowerPanel.setVisible(bl);
    }

    protected void loadOptions() {
        DataSearchOptions dataSearchOptions = (DataSearchOptions)this.mParentDlg.getSearchOptions();
        DataSearchOptions.SearchType searchType = dataSearchOptions.getSearchType();
        if (searchType == DataSearchOptions.SearchType.contains) {
            this.mContainsRadio.setSelected(true);
        } else if (searchType == DataSearchOptions.SearchType.exact) {
            this.mExactRadio.setSelected(true);
        } else if (searchType == DataSearchOptions.SearchType.startsWith) {
            this.mStartsWithRadio.setSelected(true);
        } else if (searchType == DataSearchOptions.SearchType.endsWith) {
            this.mEndsWithRadio.setSelected(true);
        }
        this.mMatchCaseCheck.setSelected(dataSearchOptions.getMatchCase());
        if (dataSearchOptions.getSearchDown()) {
            this.mSearchDownRadio.setSelected(true);
        } else {
            this.mSearchUpRadio.setSelected(true);
        }
    }

    protected void saveOptions() {
        DataSearchOptions dataSearchOptions = (DataSearchOptions)this.mParentDlg.getSearchOptions();
        DataSearchOptions.SearchType searchType = DataSearchOptions.SearchType.contains;
        if (this.mExactRadio.isSelected()) {
            searchType = DataSearchOptions.SearchType.exact;
        } else if (this.mStartsWithRadio.isSelected()) {
            searchType = DataSearchOptions.SearchType.startsWith;
        } else if (this.mEndsWithRadio.isSelected()) {
            searchType = DataSearchOptions.SearchType.endsWith;
        }
        dataSearchOptions.setSearchType(searchType);
        dataSearchOptions.setMatchCase(this.mMatchCaseCheck.isSelected());
        dataSearchOptions.setSearchDown(this.mSearchDownRadio.isSelected());
    }

    @Override
    protected JPanel getLowerControlPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = DialogUtil.getStandardControlInsets();
        int n2 = 23;
        this.mLowerPanel = new JPanel(new GridBagLayout(), true);
        JPanel jPanel = new JPanel(new GridBagLayout(), true);
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_MATCH_TO")));
        gridBagConstraints.fill = 1;
        Insets insets2 = (Insets)insets.clone();
        insets2.top = n;
        gridBagConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(this.mLowerPanel, jPanel, gridBagConstraints, 0, 0, 1, 2, n2, insets2);
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        this.mContainsRadio = new JRadioButton(this.getResString("IDS_CONTAINS"));
        if (OSCheck.getOSType() != OSInfo.OSType.MAC) {
            this.mContainsRadio.setMnemonic(this.getDlgAccessKey("IDK_CONTAINS_KEY"));
        }
        insets2.top = 0;
        insets2.bottom = 0;
        insets2.left *= 2;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel, this.mContainsRadio, gridBagConstraints, 0, 0, 1, 1, n2, insets2);
        spssButtonGroup.add(this.mContainsRadio);
        this.mExactRadio = new JRadioButton(this.getResString("IDS_EXACT"));
        if (OSCheck.getOSType() != OSInfo.OSType.MAC) {
            this.mExactRadio.setMnemonic(this.getDlgAccessKey("IDK_EXACT_KEY"));
        }
        DialogUtil.addUsingGBL(jPanel, this.mExactRadio, gridBagConstraints, 0, 1, 1, 1, n2, insets2);
        spssButtonGroup.add(this.mExactRadio);
        this.mStartsWithRadio = new JRadioButton(this.getResString("IDS_BEGINS_WITH"));
        if (OSCheck.getOSType() != OSInfo.OSType.MAC) {
            this.mStartsWithRadio.setMnemonic(this.getDlgAccessKey("IDK_BEGINS_WITH_KEY"));
        }
        DialogUtil.addUsingGBL(jPanel, this.mStartsWithRadio, gridBagConstraints, 0, 2, 1, 1, n2, insets2);
        spssButtonGroup.add(this.mStartsWithRadio);
        this.mEndsWithRadio = new JRadioButton(this.getResString("IDS_ENDS_WITH"));
        if (OSCheck.getOSType() != OSInfo.OSType.MAC) {
            this.mEndsWithRadio.setMnemonic(this.getDlgAccessKey("IDK_ENDS_WITH_KEY"));
        }
        gridBagConstraints.weighty = 1.0;
        insets2.bottom = n;
        DialogUtil.addUsingGBL(jPanel, this.mEndsWithRadio, gridBagConstraints, 0, 3, 1, 1, n2, insets2);
        spssButtonGroup.add(this.mEndsWithRadio);
        JPanel jPanel2 = new JPanel(new GridBagLayout(), true);
        jPanel2.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_DIRECTION")));
        gridBagConstraints.fill = 1;
        insets2 = (Insets)insets.clone();
        insets2.top = n;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets2.left *= 2;
        DialogUtil.addUsingGBL(this.mLowerPanel, jPanel2, gridBagConstraints, 1, 1, 1, 1, n2, insets2);
        spssButtonGroup = new SpssButtonGroup();
        this.mSearchUpRadio = new JRadioButton(this.getResString("IDS_UP"));
        if (OSCheck.getOSType() != OSInfo.OSType.MAC) {
            this.mSearchUpRadio.setMnemonic(this.getDlgAccessKey("IDK_UP_KEY"));
        }
        insets2.top = 0;
        insets2.bottom = 0;
        gridBagConstraints.fill = 2;
        DialogUtil.addUsingGBL(jPanel2, this.mSearchUpRadio, gridBagConstraints, 0, 0, 1, 1, n2, insets2);
        spssButtonGroup.add(this.mSearchUpRadio);
        this.mSearchDownRadio = new JRadioButton(this.getResString("IDS_DOWN"));
        if (OSCheck.getOSType() != OSInfo.OSType.MAC) {
            this.mSearchDownRadio.setMnemonic(this.getDlgAccessKey("IDK_DOWN_KEY"));
        }
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel2, this.mSearchDownRadio, gridBagConstraints, 0, 1, 1, 1, n2, insets2);
        spssButtonGroup.add(this.mSearchDownRadio);
        this.mContainsRadio.addActionListener(this);
        this.mExactRadio.addActionListener(this);
        this.mStartsWithRadio.addActionListener(this);
        this.mEndsWithRadio.addActionListener(this);
        this.mSearchUpRadio.addActionListener(this);
        this.mSearchDownRadio.addActionListener(this);
        return this.mLowerPanel;
    }

    protected JPanel getUpperOptions() {
        JPanel jPanel = new JPanel(new GridBagLayout(), true);
        this.mMatchCaseCheck = new JCheckBox(this.getResString("IDS_MATCH_CASE"));
        if (OSCheck.getOSType() != OSInfo.OSType.MAC) {
            this.mMatchCaseCheck.setMnemonic(this.getDlgAccessKey("IDK_MATCH_CASE_KEY"));
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n = DialogUtil.getGroupBoxInnerMargin();
        int n2 = 23;
        Insets insets = new Insets(3, n, 0, n);
        DialogUtil.addUsingGBL(jPanel, this.mMatchCaseCheck, gridBagConstraints, 0, 1, 1, 1, n2, insets);
        this.mMatchCaseCheck.addActionListener(this);
        return jPanel;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.mParentDlg.isInListLoad()) {
            return;
        }
        Object object = actionEvent.getSource();
        if (object == this.mContainsRadio || object == this.mExactRadio || object == this.mStartsWithRadio || object == this.mEndsWithRadio || object == this.mSearchUpRadio || object == this.mSearchDownRadio || object == this.mMatchCaseCheck) {
            DataSearchOptions dataSearchOptions = (DataSearchOptions)this.mParentDlg.getSearchOptions();
            dataSearchOptions.setFirstSearch(true);
        }
    }
}

