/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.edit.find;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.common.prefs.PrefsMgr;
import com.spss.java_client.core.comp_util.OSCheck;
import com.spss.java_client.core.documents.DocType;
import com.spss.java_client.ui.SpssFrameMgr;
import com.spss.java_client.ui.dialogs.base.edit.find.FindBasePanel;
import com.spss.java_client.ui.dialogs.base.edit.find.ISearchProxy;
import com.spss.java_client.ui.dialogs.base.edit.find.SearchOptions;
import com.spss.java_client.ui.dialogs.base.edit.find.ViewerRangePanel;
import com.spss.java_client.ui.dialogs.base.edit.find.ViewerReplacePanel;
import com.spss.java_client.ui.dialogs.base.edit.res.EditResBundle;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.complex_samples.DefineTableModel;
import com.spss.java_client.ui.doc_types.data.DataEditContextMenu;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.clipboard.AppClipboard;
import com.spss.uitools.controls.MouseActionRepeater;
import com.spss.uitools.controls.TypeAheadCombo;
import com.spss.uitools.dialogs.BaseDialog;
import com.spss.uitools.dialogs.UIToolDialogUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ResourceBundle;
import java.util.Stack;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;

public abstract class BaseFindDlg
extends BaseDialog
implements DocumentListener,
ActionListener,
ChangeListener {
    protected static final int MAX_STACK_SIZE = 10;
    protected ISearchProxy mProxy;
    protected JButton mFindNextButton;
    protected JButton mReplaceButton;
    protected JButton mRepAllButton;
    protected FindNextAction mFindNextAction;
    protected ReplaceAction mReplaceAction;
    protected ReplaceAllAction mReplaceAllAction;
    protected JButton mCloseButton;
    protected boolean mInListLoad = false;
    protected ComponentAdapter mResizeListener = null;
    MouseActionRepeater mButtonRepeater;
    protected JTabbedPane mTabbedPane;

    public BaseFindDlg(Window window, ISearchProxy iSearchProxy) {
        super(window, "", false, ResUtil.getBundle(EditResBundle.getDefaultResourceBundleName(), ResUtil.getLocale()), EditResBundle.getImageFolder());
        this.mProxy = iSearchProxy;
        this.setDefaultCloseOperation(1);
        this.initialize();
        this.mResizeListener = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                BaseFindDlg.this.removeComponentListener(BaseFindDlg.this.mResizeListener);
                Dimension dimension = new Dimension();
                Dimension dimension2 = BaseFindDlg.this.getSize();
                Dimension dimension3 = BaseFindDlg.this.getSizeConstraints();
                dimension.width = dimension2.width;
                dimension.height = dimension3.height;
                if (dimension.height != dimension2.height) {
                    BaseFindDlg.this.setBounds(BaseFindDlg.this.getX(), BaseFindDlg.this.getY(), dimension.width, dimension.height);
                    BaseFindDlg.this.validate();
                }
                BaseFindDlg.this.addComponentListener(BaseFindDlg.this.mResizeListener);
            }
        };
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Stack<String> stack = BaseFindDlg.this.getSearchStack();
                if (stack.size() == 0) {
                    BaseFindDlg.this.restoreStack(stack, BaseFindDlg.this.getFindKey());
                    BaseFindDlg.this.restoreStack(BaseFindDlg.this.getReplaceStack(), BaseFindDlg.this.getReplaceKey());
                    BaseFindDlg.this.loadFindSelections(stack, true);
                    BaseFindDlg.this.loadReplaceSelections(BaseFindDlg.this.getReplaceStack(), BaseFindDlg.this.mTabbedPane.getSelectedIndex() == 1);
                    if (BaseFindDlg.this.mTabbedPane.getTabCount() == 3) {
                        BaseFindDlg.this.restoreStack(BaseFindDlg.this.getRange1Stack(), BaseFindDlg.this.getRange1Key());
                        BaseFindDlg.this.restoreStack(BaseFindDlg.this.getRange2Stack(), BaseFindDlg.this.getRange2Key());
                        BaseFindDlg.this.loadRangeSelections(BaseFindDlg.this.getRange1Stack(), BaseFindDlg.this.getRange2Stack(), BaseFindDlg.this.mTabbedPane.getSelectedIndex() == 1);
                    }
                    BaseFindDlg.this.updateDialogControls();
                } else {
                    FindBasePanel findBasePanel = (FindBasePanel)BaseFindDlg.this.mTabbedPane.getSelectedComponent();
                    findBasePanel.enableReplaceControls();
                }
            }
        });
    }

    public void selectReplace(boolean bl) {
        if (bl) {
            this.mTabbedPane.setSelectedIndex(1);
        } else {
            this.mTabbedPane.setSelectedIndex(0);
        }
        this.updateCmdButtons();
    }

    public String getLastFindValue() {
        String string = "";
        FindBasePanel findBasePanel = (FindBasePanel)this.mTabbedPane.getSelectedComponent();
        string = findBasePanel.getFindString();
        return string;
    }

    public String getLastReplaceValue() {
        String string = "";
        FindBasePanel findBasePanel = (FindBasePanel)this.mTabbedPane.getSelectedComponent();
        string = findBasePanel.getReplaceString();
        return string;
    }

    public void adjustPosition(Rectangle rectangle) {
        Point point = this.getLocationOnScreen();
        Dimension dimension = this.getSize();
        Rectangle rectangle2 = new Rectangle(point.x, point.y, dimension.width, dimension.height);
        if (!rectangle2.intersects(rectangle)) {
            return;
        }
        Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
        boolean bl = true;
        if (rectangle.y < dimension.height) {
            bl = false;
        }
        boolean bl2 = true;
        if (rectangle.getMaxX() + (double)dimension.width > (double)dimension2.width) {
            bl2 = false;
        }
        boolean bl3 = true;
        if (rectangle.x < dimension.width) {
            bl3 = false;
        }
        boolean bl4 = true;
        if (rectangle.getMaxX() + (double)dimension.width > (double)dimension2.width) {
            bl4 = false;
        }
        int n = point.x;
        int n2 = point.y;
        if (bl4) {
            n = (int)rectangle.getMaxX();
        } else if (bl) {
            n2 = rectangle.y - dimension.height;
        } else if (bl3) {
            n = rectangle.x - dimension.width;
        } else if (bl2) {
            n2 = (int)rectangle.getMaxY();
        } else {
            n = (int)rectangle.getMaxX();
        }
        Point point2 = new Point(n, n2);
        this.setLocation(point2);
    }

    public boolean findNext() {
        Stack<String> stack = this.getSearchStack();
        int n = stack.size();
        if (n == 0) {
            Toolkit.getDefaultToolkit().beep();
            return false;
        }
        String string = (String)stack.get(n - 1);
        boolean bl = this.mProxy.findNext(string, this.getSearchOptions());
        if (!bl) {
            this.showNotFoundMsg(string);
        }
        return bl;
    }

    public abstract void updateTitle();

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            FindBasePanel findBasePanel = (FindBasePanel)this.mTabbedPane.getSelectedComponent();
            findBasePanel.requestFindComboFocus();
            this.loadFindSelections(this.getSearchStack(), true);
            this.loadReplaceSelections(this.getReplaceStack(), findBasePanel instanceof ViewerReplacePanel);
            this.loadRangeSelections(this.getRange1Stack(), this.getRange2Stack(), findBasePanel instanceof ViewerRangePanel);
            this.getSearchOptions().setFirstSearch(true);
            this.loadOptions();
            this.updateTitle();
            this.updateCmdButtons();
        } else {
            DocType docType = this.getDocType();
            if (SpssFrameMgr.getSpssFrameMgr().openDocumentCount(docType) <= 1) {
                String string = this.getFindKey();
                String string2 = this.getReplaceKey();
                this.saveStack(this.getSearchStack(), string);
                this.saveStack(this.getReplaceStack(), string2);
            }
        }
    }

    public void updateDialogControls() {
    }

    public boolean isInListLoad() {
        return this.mInListLoad;
    }

    public void setInListLoad(boolean bl) {
        this.mInListLoad = bl;
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        if (this.mInListLoad) {
            return;
        }
        this.getSearchOptions().setFirstSearch(true);
        this.updateCmdButtons();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        if (this.mInListLoad) {
            return;
        }
        this.getSearchOptions().setFirstSearch(true);
        this.updateCmdButtons();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        if (this.mInListLoad) {
            return;
        }
        this.getSearchOptions().setFirstSearch(true);
        this.updateCmdButtons();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
    }

    protected abstract DocType getDocType();

    protected abstract String getFindKey();

    protected abstract String getReplaceKey();

    protected String getRange1Key() {
        return null;
    }

    protected String getRange2Key() {
        return null;
    }

    protected abstract Stack<String> getSearchStack();

    protected abstract Stack<String> getReplaceStack();

    protected Stack<String> getRange1Stack() {
        return null;
    }

    protected Stack<String> getRange2Stack() {
        return null;
    }

    protected abstract void loadOptions();

    protected abstract SearchOptions getSearchOptions();

    protected abstract void saveOptions();

    protected void doFindNext() {
        FindBasePanel findBasePanel = (FindBasePanel)this.mTabbedPane.getSelectedComponent();
        String string = findBasePanel.getFindString();
        this.saveFindValue(string);
        this.saveOptions();
        if (!this.mProxy.findNext(string, this.getSearchOptions())) {
            this.showNotFoundMsg(string);
        } else {
            this.getSearchOptions().setFirstSearch(false);
        }
    }

    protected void doReplace() {
        FindBasePanel findBasePanel = (FindBasePanel)this.mTabbedPane.getSelectedComponent();
        String string = findBasePanel.getFindString();
        String string2 = findBasePanel.getReplaceString();
        this.saveFindValue(string);
        this.saveReplaceValue(string2);
        this.saveOptions();
        if (!this.mProxy.replaceNext(string, string2, this.getSearchOptions())) {
            this.showNotFoundMsg(string);
        } else {
            this.getSearchOptions().setFirstSearch(false);
        }
    }

    protected void doReplaceAll() {
        FindBasePanel findBasePanel = (FindBasePanel)this.mTabbedPane.getSelectedComponent();
        String string = findBasePanel.getFindString();
        String string2 = findBasePanel.getReplaceString();
        this.saveFindValue(string);
        this.saveReplaceValue(string2);
        this.saveOptions();
        int n = this.mProxy.replaceAll(string, string2, this.getSearchOptions());
        String string3 = this.getResString("ERR_NUM_REPLACED");
        String string4 = String.format(string3, n);
        JOptionPane.showMessageDialog((Component)((Object)this), string4, VersionInfo.getAppVersionString(), 1);
    }

    protected abstract void updateCmdButtons();

    public void pack() {
        this.removeComponentListener(this.mResizeListener);
        super.pack();
        this.addComponentListener(this.mResizeListener);
    }

    protected void packEx(boolean bl) {
        Dimension dimension = this.getPreferredSize();
        Dimension dimension2 = new Dimension();
        Dimension dimension3 = this.getSizeConstraints();
        dimension2.width = this.getSize().width;
        dimension2.height = bl ? Math.max(dimension.height, dimension3.height) : Math.min(dimension.height, dimension3.height);
        if (dimension2.height != dimension3.height) {
            this.setSizeConstraints(new Dimension(dimension3.width, dimension2.height));
            this.setBounds(this.getX(), this.getY(), dimension2.width, dimension2.height);
            this.validate();
        } else {
            this.validate();
            this.repaint();
        }
    }

    public void showNotFoundMsg(String string) {
        Toolkit.getDefaultToolkit().beep();
        String string2 = this.getResString("ERR_NOT_FOUND_MSG");
        String string3 = String.format(string2, string);
        BaseFindDlg baseFindDlg = OSInfo.getOSType() == OSInfo.OSType.MAC && !this.isVisible() ? null : this;
        JOptionPane.showMessageDialog((Component)((Object)baseFindDlg), string3, VersionInfo.getAppVersionString(), 1);
    }

    protected void stopCurrentRepeatAction() {
        if (this.mButtonRepeater != null) {
            this.mButtonRepeater.stopCurrentRepeatAction();
        }
    }

    boolean canClose() {
        return true;
    }

    void loadFindSelections(Stack<String> stack, boolean bl) {
        FindBasePanel findBasePanel = (FindBasePanel)this.mTabbedPane.getComponentAt(0);
        findBasePanel.loadFindSelections(stack, bl);
    }

    void loadReplaceSelections(Stack<String> stack, boolean bl) {
        FindBasePanel findBasePanel = (FindBasePanel)this.mTabbedPane.getComponentAt(1);
        findBasePanel.loadReplaceSelections(stack, bl);
    }

    void loadRangeSelections(Stack<String> stack, Stack<String> stack2, boolean bl) {
        if (this.mTabbedPane.getTabCount() == 3) {
            FindBasePanel findBasePanel = (FindBasePanel)this.mTabbedPane.getComponentAt(2);
            findBasePanel.loadRangeSelections(stack, stack2, bl);
        }
    }

    protected void saveFindValue(String string) {
        Stack<String> stack = this.getSearchStack();
        this.saveStackValue(stack, string, this.getFindKey());
        this.loadFindSelections(stack, false);
    }

    protected void saveReplaceValue(String string) {
        Stack<String> stack = this.getReplaceStack();
        this.saveStackValue(stack, string, this.getReplaceKey());
        this.loadReplaceSelections(stack, false);
    }

    protected void saveStackValue(Stack<String> stack, String string, String string2) {
        int n = stack.size();
        int n2 = stack.search(string);
        if (n2 > 1) {
            stack.removeElementAt(n - n2);
        } else if (n2 != 1 && n >= 10) {
            stack.removeElementAt(0);
        }
        if (n2 != 1) {
            stack.push(string);
        }
        this.saveStack(stack, string2);
    }

    protected void saveStack(Stack<String> stack, String string) {
        String string2 = "doc_types/find_replace";
        String string3 = string2 + "/" + string;
        Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs();
        Preferences preferences2 = preferences.node(string3);
        try {
            preferences2.removeNode();
        }
        catch (BackingStoreException backingStoreException) {
            backingStoreException.printStackTrace();
        }
        preferences2 = preferences.node(string3);
        int n = stack.size();
        preferences2.putInt("count", n);
        for (int i = 0; i < n; ++i) {
            preferences2.put("item" + i, (String)stack.get(i));
        }
    }

    protected void restoreStack(Stack<String> stack, String string) {
        String string2 = "doc_types/find_replace";
        String string3 = string2 + "/" + string;
        Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs();
        Preferences preferences2 = preferences.node(string3);
        stack.clear();
        int n = preferences2.getInt("count", 0);
        for (int i = 0; i < n; ++i) {
            String string4 = preferences2.get("item" + i, "");
            stack.push(string4);
        }
    }

    protected void clearPersistence() {
        Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs();
        String string = "doc_types/find_replace";
        this.clearNode(preferences, string + "/" + this.getFindKey());
        this.clearNode(preferences, string + "/" + this.getReplaceKey());
        this.clearNode(preferences, string + "/" + this.getRange1Key());
        this.clearNode(preferences, string + "/" + this.getRange2Key());
    }

    protected void clearNode(Preferences preferences, String string) {
        Preferences preferences2 = preferences.node(string);
        try {
            preferences2.clear();
        }
        catch (BackingStoreException backingStoreException) {
            backingStoreException.printStackTrace();
        }
    }

    protected void initialize() {
        this.mTabbedPane = new JTabbedPane();
        this.mTabbedPane.addChangeListener(this);
        JPanel jPanel = this.getViewPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add(this.mTabbedPane);
    }

    protected JPanel setupCmdButtonPanel() {
        JPanel jPanel = new JPanel(true);
        Insets insets = DialogUtil.getStandardButtonInsets();
        boolean bl = DialogUtil.areCommandButtonsBelow();
        this.mFindNextAction = new FindNextAction();
        this.mReplaceAction = new ReplaceAction();
        this.mReplaceAllAction = new ReplaceAllAction();
        this.mFindNextButton = new JButton(this.mFindNextAction);
        this.mCloseButton = new JButton(new CloseAction());
        this.mReplaceButton = new JButton(this.mReplaceAction);
        this.mRepAllButton = new JButton(this.mReplaceAllAction);
        JButton jButton = new JButton(new HelpAction());
        DialogUtil.setupMacHelpButton(jButton);
        Insets insets2 = (Insets)this.mFindNextButton.getMargin().clone();
        insets2.left = 7;
        insets2.right = 7;
        this.mFindNextButton.setMargin(insets2);
        this.mReplaceButton.setMargin(insets2);
        this.mRepAllButton.setMargin(insets2);
        this.mCloseButton.setMargin(insets2);
        jButton.setMargin(insets2);
        if (bl) {
            jPanel.setBorder(new EmptyBorder(4, 0, 0, 0));
            int n = insets.left + insets.right;
            if (OSCheck.getOSType() == OSInfo.OSType.MAC) {
                jPanel.setLayout(new GridBagLayout());
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                Insets insets3 = new Insets(0, n, 0, 0);
                int n2 = 24;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.fill = 0;
                DialogUtil.addUsingGBL(jPanel, jButton, gridBagConstraints, 1, 0, 1, 1, n2, insets3);
                DialogUtil.addUsingGBL(jPanel, this.mCloseButton, gridBagConstraints, 2, 0, 1, 1, n2, insets3);
                DialogUtil.addUsingGBL(jPanel, this.mRepAllButton, gridBagConstraints, 3, 0, 1, 1, n2, insets3);
                DialogUtil.addUsingGBL(jPanel, this.mReplaceButton, gridBagConstraints, 4, 0, 1, 1, n2, insets3);
                gridBagConstraints.fill = 2;
                gridBagConstraints.weightx = 0.0;
                DialogUtil.addUsingGBL(jPanel, this.mFindNextButton, gridBagConstraints, 5, 0, 1, 1, n2, insets3);
            } else {
                FlowLayout flowLayout = new FlowLayout(1, n, 0);
                jPanel.setLayout(flowLayout);
                jPanel.add(this.mFindNextButton);
                jPanel.add(this.mReplaceButton);
                jPanel.add(this.mRepAllButton);
                jPanel.add(this.mCloseButton);
                jPanel.add(jButton);
            }
        } else {
            jPanel.setBorder(new EmptyBorder(0, DialogUtil.getMainButtonGap(), 0, 0));
            int n = insets.top + insets.bottom;
            BoxLayout boxLayout = new BoxLayout(jPanel, 1);
            jPanel.setLayout(boxLayout);
            jPanel.add(Box.createVerticalStrut(n * 2));
            jPanel.add(this.mFindNextButton);
            jPanel.add(Box.createVerticalStrut(n));
            jPanel.add(this.mReplaceButton);
            jPanel.add(Box.createVerticalStrut(n));
            jPanel.add(this.mRepAllButton);
            jPanel.add(Box.createVerticalStrut(n));
            jPanel.add(this.mCloseButton);
            jPanel.add(Box.createVerticalStrut(n));
            jPanel.add(jButton);
            jPanel.add(Box.createVerticalStrut(n));
        }
        this.getRootPane().setDefaultButton(this.mFindNextButton);
        DialogUtil.createCmdButtonGroup(jPanel);
        return jPanel;
    }

    public void initReplaceButtonMouseActionRepeater() {
        if (this.mReplaceButton != null) {
            this.mButtonRepeater = new MouseActionRepeater(this.mReplaceButton, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    BaseFindDlg.this.doReplace();
                }
            });
            this.mButtonRepeater.setRepeatInterval(500);
        }
        this.mReplaceButton.setAction(new ReplaceAction(false));
    }

    protected void init() {
        JPanel jPanel = new JPanel(new BorderLayout(), false);
        Insets insets = (Insets)UIToolDialogUtil.getStandardDialogInsets().clone();
        if (OSCheck.getOSType() == OSInfo.OSType.MAC) {
            insets.bottom = 14;
        }
        jPanel.setBorder(new EmptyBorder(insets));
        jPanel.setOpaque(true);
        this.mViewPanel = new JPanel(new GridBagLayout(), true);
        jPanel.add((Component)this.mViewPanel, "Center");
        this.mCmdButtonPanel = this.setupCmdButtonPanel();
        if (this.mCmdButtonPanel != null) {
            UIToolDialogUtil.normalizeButtonWidths((JPanel)this.mCmdButtonPanel);
            boolean bl = UIToolDialogUtil.areCommandButtonsBelow();
            jPanel.add((Component)this.mCmdButtonPanel, bl ? "South" : "East");
        }
        this.setContentPane(jPanel);
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.updateCmdButtons();
    }

    private void removeButtonRepeaterListeners() {
        if (this.mButtonRepeater != null) {
            if (this.mReplaceButton != null) {
                this.mButtonRepeater.removeListeners(this.mReplaceButton);
            }
            this.mButtonRepeater.removeMneumonicRepeater();
        }
    }

    class DisablingCombo
    extends TypeAheadCombo {
        private final String[] EDITBAR_CONTEXT_MENU_IDS = new String[]{"context_data_cut", "context_data_copy", "context_data_paste", "context_data_clear"};
        private DataEditContextMenu mEditBarContextMenu = new DataEditContextMenu(this.EDITBAR_CONTEXT_MENU_IDS);
        private JPopupMenu mContextMenu;
        private JMenuItem mCopyMenu;
        private JMenuItem mCutMenu;
        private JMenuItem mPasteMenu;
        private JMenuItem mDeleteMenu;
        public static final String IDS_CUT = "IDS_CUT";
        public static final String IDS_COPY = "IDS_COPY";
        public static final String IDS_PASTE = "IDS_PASTE";
        public static final String IDS_DELETE = "IDS_DELETE";

        DisablingCombo() {
            this.initMouseListener();
            this.initClipboardPopup();
        }

        private void initMouseListener() {
            JTextComponent jTextComponent = (JTextComponent)this.getEditor().getEditorComponent();
            if (jTextComponent != null) {
                jTextComponent.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseReleased(MouseEvent mouseEvent) {
                        super.mouseReleased(mouseEvent);
                        if (mouseEvent.isPopupTrigger()) {
                            DisablingCombo.this.showPopup(mouseEvent);
                        }
                    }

                    @Override
                    public void mousePressed(MouseEvent mouseEvent) {
                        super.mousePressed(mouseEvent);
                        if (mouseEvent.isPopupTrigger()) {
                            DisablingCombo.this.showPopup(mouseEvent);
                        }
                    }
                });
            }
        }

        private void initClipboardPopup() {
            this.mCutMenu = new JMenuItem(BaseFindDlg.this.getResString(IDS_CUT));
            Integer n = this.getMenuNemonic(IDS_CUT);
            this.mCutMenu.setMnemonic(n);
            this.mCutMenu.setAccelerator(KeyStroke.getKeyStroke(88, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
            this.mCutMenu.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DisablingCombo.this.processMenuOption(DisablingCombo.IDS_CUT);
                }
            });
            this.mCopyMenu = new JMenuItem(BaseFindDlg.this.getResString(IDS_COPY));
            n = this.getMenuNemonic(IDS_COPY);
            this.mCopyMenu.setMnemonic(n);
            this.mCopyMenu.setAccelerator(KeyStroke.getKeyStroke(67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
            this.mCopyMenu.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DisablingCombo.this.processMenuOption(DisablingCombo.IDS_COPY);
                }
            });
            this.mPasteMenu = new JMenuItem(BaseFindDlg.this.getResString(IDS_PASTE));
            n = this.getMenuNemonic(IDS_PASTE);
            this.mPasteMenu.setMnemonic(n);
            this.mPasteMenu.setAccelerator(KeyStroke.getKeyStroke(86, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
            this.mPasteMenu.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DisablingCombo.this.processMenuOption(DisablingCombo.IDS_PASTE);
                }
            });
            this.mDeleteMenu = new JMenuItem(BaseFindDlg.this.getResString(IDS_DELETE));
            n = this.getMenuNemonic(IDS_DELETE);
            this.mDeleteMenu.setMnemonic(n);
            this.mDeleteMenu.setAccelerator(KeyStroke.getKeyStroke(127, 0));
            this.mDeleteMenu.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    DisablingCombo.this.processMenuOption(DisablingCombo.IDS_DELETE);
                }
            });
            this.mContextMenu = new JPopupMenu();
            this.mContextMenu.add(this.mCutMenu);
            this.mContextMenu.add(this.mCopyMenu);
            this.mContextMenu.add(this.mPasteMenu);
            this.mContextMenu.add(this.mDeleteMenu);
        }

        private void processMenuOption(String string) {
            JTextField jTextField = (JTextField)this.getEditor().getEditorComponent();
            String string2 = jTextField.getSelectedText();
            if (jTextField != null) {
                if (string.equalsIgnoreCase(IDS_CUT) || string.equalsIgnoreCase(IDS_COPY)) {
                    this.setClipboardContents(string2 == null ? "" : string2);
                    if (string.equalsIgnoreCase(IDS_CUT)) {
                        jTextField.replaceSelection("");
                    }
                } else if (string.equalsIgnoreCase(IDS_PASTE)) {
                    String string3 = DefineTableModel.getClipboardContents(jTextField);
                    if (string3 != null && string3.length() > 0) {
                        jTextField.replaceSelection(string3);
                    }
                } else if (string.equalsIgnoreCase(IDS_DELETE)) {
                    jTextField.replaceSelection("");
                }
            }
        }

        private void showPopup(MouseEvent mouseEvent) {
            JTextComponent jTextComponent = (JTextComponent)this.getEditor().getEditorComponent();
            if (jTextComponent != null) {
                AppClipboard appClipboard = AppClipboard.getAppClipboard();
                String string = jTextComponent.getSelectedText();
                boolean bl = string != null && string.length() > 0;
                this.mCutMenu.setEnabled(bl);
                this.mCopyMenu.setEnabled(bl);
                this.mDeleteMenu.setEnabled(bl);
                this.mPasteMenu.setEnabled(appClipboard.isFlavorAvailable(AppClipboard.STRING_FLAVOR));
                this.mContextMenu.show(jTextComponent, mouseEvent.getX(), mouseEvent.getY());
            }
        }

        private void setClipboardContents(String string) {
            StringSelection stringSelection = new StringSelection(string);
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, stringSelection);
        }

        public void setEnabled(boolean bl) {
            super.setEnabled(bl);
            Color color = bl ? Color.white : SystemColor.control;
            this.getEditor().getEditorComponent().setBackground(color);
            Color color2 = bl ? UIManager.getColor("TextField.foreground") : UIManager.getColor("TextField.inactiveForeground");
            this.getEditor().getEditorComponent().setForeground(color2);
            Color color3 = bl ? UIManager.getColor("TextField.selectionBackground") : SystemColor.control;
            ((JTextComponent)this.getEditor().getEditorComponent()).setSelectionColor(color3);
        }

        private Integer getMenuNemonic(String string) {
            ResourceBundle resourceBundle = ResUtil.getBundle(EditResBundle.getDefaultResourceBundleName(), ResUtil.getLocale());
            return (Integer)ResUtil.getObject(string + "_KEY", resourceBundle);
        }
    }

    class HelpAction
    extends AbstractAction {
        HelpAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_HELP"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BaseFindDlg.this.doHelp();
        }
    }

    class CloseAction
    extends AbstractAction {
        CloseAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_CLOSE"));
            BaseFindDlg.this.removeButtonRepeaterListeners();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (BaseFindDlg.this.canClose()) {
                BaseFindDlg.this.setVisible(false);
            }
        }
    }

    class ReplaceAllAction
    extends AbstractAction {
        ReplaceAllAction() {
            this.putValue("Name", BaseFindDlg.this.getResString("IDS_REPLACE_ALL"));
            if (OSCheck.getOSType() != OSInfo.OSType.MAC) {
                this.putValue("MnemonicKey", BaseFindDlg.this.getDlgAccessKey("IDK_REPLACE_ALL_KEY"));
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BaseFindDlg.this.doReplaceAll();
        }
    }

    class ReplaceAction
    extends AbstractAction {
        boolean mDoAction = true;

        ReplaceAction() {
            this(true);
        }

        ReplaceAction(boolean bl) {
            this.mDoAction = bl;
            this.putValue("Name", BaseFindDlg.this.getResString("IDS_REPLACE_BUTTON"));
            if (OSCheck.getOSType() != OSInfo.OSType.MAC) {
                this.putValue("MnemonicKey", BaseFindDlg.this.getDlgAccessKey("IDK_REPLACE_BUTTON_KEY"));
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (this.mDoAction) {
                BaseFindDlg.this.doReplace();
            }
        }
    }

    class FindNextAction
    extends AbstractAction {
        FindNextAction() {
            this.putValue("Name", BaseFindDlg.this.getResString("IDS_FIND_NEXT"));
            if (OSCheck.getOSType() != OSInfo.OSType.MAC) {
                this.putValue("MnemonicKey", BaseFindDlg.this.getDlgAccessKey("IDK_FIND_NEXT_KEY"));
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FindBasePanel findBasePanel = (FindBasePanel)BaseFindDlg.this.mTabbedPane.getSelectedComponent();
            findBasePanel.setComboPopupVisible(false);
            BaseFindDlg.this.doFindNext();
        }
    }
}

