/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.edit.copy_special;

import com.spss.java_client.core.common.prefs.PrefsMgr;
import com.spss.java_client.ui.controls.CheckBoxList;
import com.spss.java_client.ui.dialogs.base.edit.res.EditResBundle;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.doc_types.output.ChartViewerItem;
import com.spss.java_client.ui.doc_types.output.GraphBoardViewerItem;
import com.spss.java_client.ui.doc_types.output.IViewerWindowEx;
import com.spss.java_client.ui.doc_types.output.ImageViewerItem;
import com.spss.java_client.ui.doc_types.output.JsonChartViewerItem;
import com.spss.java_client.ui.doc_types.output.MGOHelper;
import com.spss.java_client.ui.doc_types.output.TextViewerItem;
import com.spss.java_client.ui.doc_types.output.ViewerFrame;
import com.spss.java_client.ui.doc_types.output.ViewerItem;
import com.spss.java_client.ui.doc_types.output.ViewerPanel;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.format.CommonState;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.controls.FocusableLabel;
import com.spss.uitools.dialogs.BaseDialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;

public class CopySpecialDlg
extends BaseDialog
implements ItemListener {
    private IViewerWindowEx mViewerWindow;
    private DefaultListModel mFormatModel;
    private JCheckBox mMakeDefaultCheck;
    private JButton mOKButton;
    private FocusableLabel mRequiresOffice16OrHigerLabel;
    private final String EDIT_COPY_SPECIAL_DEFAULT = "edit_copy_special_default_foramt";
    private final String ROOT_PATH = "doc_types/output/menus";

    public CopySpecialDlg(Window window, IViewerWindowEx iViewerWindowEx) throws HeadlessException {
        super(window, true, ResUtil.getBundle(EditResBundle.getDefaultResourceBundleName(), ResUtil.getLocale()), EditResBundle.getImageFolder());
        this.mViewerWindow = iViewerWindowEx;
        this.setTitle(this.getResString("IDS_COPY_SPECIAL_TITLE"));
        this.initialize();
        this.loadFormatList();
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    public void doHelp() {
    }

    private int getFormats() {
        int n = 0;
        for (int i = 0; i < this.mFormatModel.getSize(); ++i) {
            FormatItem formatItem = (FormatItem)this.mFormatModel.getElementAt(i);
            if (!formatItem.isSelected()) continue;
            n |= formatItem.getFormatType();
        }
        return n;
    }

    private void loadFormatList() {
        int n;
        ViewerItem viewerItem = this.mViewerWindow.getDocument().getFocusedViewerItem();
        boolean bl = viewerItem instanceof ChartViewerItem || viewerItem instanceof GraphBoardViewerItem || viewerItem instanceof ImageViewerItem || viewerItem instanceof JsonChartViewerItem;
        Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs();
        Preferences preferences2 = preferences.node("doc_types/output/menus");
        int n2 = preferences2.getInt("edit_copy_special_default_foramt", this.mViewerWindow.getCopyFormats());
        FormatItem formatItem = new FormatItem(this.getResString("IDS_PLAIN_TEXT"), 2);
        this.mFormatModel.addElement(formatItem);
        if (bl) {
            formatItem.setEnabled(false);
        }
        if ((n2 & 2) != 0) {
            formatItem.setSelected(true);
        }
        formatItem = new FormatItem(this.getResString("IDS_RICH_TEXT"), 4);
        this.mFormatModel.addElement(formatItem);
        if ((n2 & 4) != 0) {
            formatItem.setSelected(true);
        }
        formatItem = new FormatItem(this.getResString("IDS_IMAGE"), 8);
        if (viewerItem instanceof TextViewerItem) {
            formatItem.setEnabled(false);
        }
        this.mFormatModel.addElement(formatItem);
        if ((n2 & 8) != 0) {
            formatItem.setSelected(true);
        }
        if (OSInfo.getOSType() == OSInfo.OSType.WIN) {
            formatItem = new FormatItem(this.getResString("IDS_METAFILE"), 32);
            this.mFormatModel.addElement(formatItem);
            if ((n2 & 0x20) != 0) {
                formatItem.setSelected(true);
            }
            if (this.mViewerWindow instanceof ViewerPanel && CommonState.getApplicationType() == CommonState.AppType.STATISTICS) {
                formatItem = new FormatItem(this.getResString("IDS_BIFF"), 16);
                this.mFormatModel.addElement(formatItem);
                if ((n2 & 0x10) != 0) {
                    formatItem.setSelected(true);
                }
            }
        }
        String string = this.getResString("IDS_MGO");
        if (MGOHelper.mgoSelectionNeedsOffice16(this.mViewerWindow.getDocument())) {
            string = string + "*";
        }
        if (OSInfo.getOSType() == OSInfo.OSType.WIN || OSInfo.getOSType() == OSInfo.OSType.MAC) {
            formatItem = new FormatItem(string, 64);
            this.mFormatModel.addElement(formatItem);
            if (bl && (n2 & 0x40) != 0) {
                formatItem.setSelected(true);
                n = MGOHelper.canDoMGOForSelection(this.mViewerWindow.getDocument()) ? 1 : 0;
                formatItem.setEnabled(n != 0);
            }
        }
        for (n = 0; n < this.mFormatModel.getSize(); n += 1) {
            formatItem = (FormatItem)this.mFormatModel.getElementAt(n);
            formatItem.addItemListener(this);
        }
    }

    protected JPanel setupCmdButtonPanel() {
        JPanel jPanel = new JPanel(true);
        Insets insets = DialogUtil.getStandardButtonInsets();
        if (DialogUtil.areCommandButtonsBelow()) {
            jPanel.setBorder(new EmptyBorder(DialogUtil.getMainButtonGap(), 0, 0, 0));
            int n = insets.left + insets.right;
            this.mOKButton = new JButton(new OkAction());
            JButton jButton = new JButton(new CancelAction());
            if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
                jPanel.setLayout(new GridBagLayout());
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                Insets insets2 = new Insets(0, n, 0, 0);
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.fill = 2;
                int n2 = 24;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.fill = 0;
                DialogUtil.addUsingGBL(jPanel, jButton, gridBagConstraints, 3, 0, 1, 1, n2, insets2);
                gridBagConstraints.fill = 2;
                gridBagConstraints.weightx = 0.0;
                DialogUtil.addUsingGBL(jPanel, this.mOKButton, gridBagConstraints, 4, 0, 1, 1, n2, insets2);
            } else {
                FlowLayout flowLayout = new FlowLayout(1, n, 0);
                jPanel.setLayout(flowLayout);
                jPanel.add(this.mOKButton);
                jPanel.add(jButton);
            }
        } else {
            jPanel.setBorder(new EmptyBorder(0, DialogUtil.getMainButtonGap(), 0, 0));
            int n = insets.top + insets.bottom;
            BoxLayout boxLayout = new BoxLayout(jPanel, 1);
            jPanel.setLayout(boxLayout);
            jPanel.add(Box.createVerticalStrut(n * 2));
            this.mOKButton = new JButton(new OkAction());
            jPanel.add(this.mOKButton);
            jPanel.add(Box.createVerticalStrut(n));
            JButton jButton = new JButton(new CancelAction());
            jPanel.add(jButton);
            jPanel.add(Box.createVerticalStrut(n));
        }
        this.getRootPane().setDefaultButton(this.mOKButton);
        return jPanel;
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n = 23;
        Insets insets = (Insets)DialogUtil.getStandardControlInsets().clone();
        JPanel jPanel = this.getViewPanel();
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_COPY_PROMPT");
        int n2 = 0;
        DialogUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, n2++, 0, 1, 1, n, insets);
        CheckBoxList checkBoxList = new CheckBoxList();
        this.mFormatModel = new DefaultListModel();
        checkBoxList.setModel(this.mFormatModel);
        gridBagConstraints.fill = 1;
        JScrollPane jScrollPane = new JScrollPane(checkBoxList);
        jScrollPane.setMinimumSize(new Dimension(240, 160));
        jScrollPane.setPreferredSize(new Dimension(240, 160));
        DialogUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, n2++, 1, 1, n, insets);
        jLabel.setLabelFor(checkBoxList);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        if (MGOHelper.mgoSelectionNeedsOffice16(this.mViewerWindow.getDocument())) {
            this.mRequiresOffice16OrHigerLabel = new FocusableLabel(this.getResString("IDS_MGO_NEEDS_OFFICE_16_OR_HIGHER"));
            DialogUtil.addUsingGBL(jPanel, (JComponent)this.mRequiresOffice16OrHigerLabel, gridBagConstraints, 0, n2++, 1, 1, n, insets);
        }
        this.mMakeDefaultCheck = new JCheckBox(this.getResString("IDS_MAKE_DEFAULT"));
        insets.top += 8;
        this.mMakeDefaultCheck.setMnemonic(this.getDlgAccessKey("IDK_MAKE_DEFAULT_KEY"));
        DialogUtil.addUsingGBL(jPanel, this.mMakeDefaultCheck, gridBagConstraints, 0, n2++, 1, 1, n, insets);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() instanceof FormatItem) {
            if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
                for (int i = 0; i < this.mFormatModel.getSize(); ++i) {
                    int n;
                    FormatItem formatItem = (FormatItem)this.mFormatModel.getElementAt(i);
                    if (formatItem.toString() == this.getResString("IDS_MGO") && formatItem.isSelected()) {
                        for (n = 0; n < this.mFormatModel.getSize(); ++n) {
                            formatItem = (FormatItem)this.mFormatModel.getElementAt(n);
                            if (formatItem.toString() == this.getResString("IDS_MGO") || !formatItem.isEnabled()) continue;
                            formatItem.setSelected(false);
                            formatItem.setEnabled(false);
                        }
                        continue;
                    }
                    if (formatItem.toString() == this.getResString("IDS_MGO") && !formatItem.isSelected()) {
                        for (n = 0; n < this.mFormatModel.getSize(); ++n) {
                            formatItem = (FormatItem)this.mFormatModel.getElementAt(n);
                            if (formatItem.toString() == this.getResString("IDS_MGO") || formatItem.isSelected() || formatItem.isEnabled()) continue;
                            formatItem.setEnabled(true);
                        }
                        continue;
                    }
                    if (formatItem.toString() != this.getResString("IDS_MGO") && formatItem.isSelected() && formatItem.isEnabled()) {
                        for (n = 0; n < this.mFormatModel.getSize(); ++n) {
                            formatItem = (FormatItem)this.mFormatModel.getElementAt(n);
                            if (formatItem.toString() != this.getResString("IDS_MGO")) continue;
                            formatItem.setSelected(false);
                            formatItem.setEnabled(false);
                        }
                        continue;
                    }
                    if (formatItem.toString() == this.getResString("IDS_MGO") || formatItem.isSelected() || !formatItem.isEnabled()) continue;
                    n = 0;
                    for (int j = 0; j < this.mFormatModel.getSize(); ++j) {
                        formatItem = (FormatItem)this.mFormatModel.getElementAt(j);
                        if (formatItem.toString() != this.getResString("IDS_MGO") && formatItem.isSelected() && formatItem.isEnabled()) {
                            n = 1;
                        }
                        if (formatItem.toString() != this.getResString("IDS_MGO") || n != 0) continue;
                        formatItem.setEnabled(true);
                    }
                }
            }
            this.enableOKButton();
        }
    }

    private void enableOKButton() {
        boolean bl = false;
        for (int i = 0; i < this.mFormatModel.getSize(); ++i) {
            FormatItem formatItem = (FormatItem)this.mFormatModel.getElementAt(i);
            if (!formatItem.isSelected()) continue;
            bl = true;
            break;
        }
        this.mOKButton.setEnabled(bl);
    }

    private class CancelAction
    extends AbstractAction {
        CancelAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_CANCEL"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CopySpecialDlg.this.dispose();
        }
    }

    private class OkAction
    extends AbstractAction {
        OkAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_OK"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (CopySpecialDlg.this.mViewerWindow instanceof ViewerFrame) {
                ((ViewerFrame)CopySpecialDlg.this.mViewerWindow).setSavedCopyFormats(CopySpecialDlg.this.mViewerWindow.getCopyFormats());
            }
            int n = CopySpecialDlg.this.getFormats();
            CopySpecialDlg.this.mViewerWindow.setCopyFormats(n | 1);
            CopySpecialDlg.this.mViewerWindow.doCopy();
            if (CopySpecialDlg.this.mMakeDefaultCheck.isSelected()) {
                CopySpecialDlg.this.mViewerWindow.saveDefaultCopySpecialFormat(n | 1);
            }
            CopySpecialDlg.this.dispose();
        }
    }

    class FormatItem
    extends JCheckBox {
        private int mFormatType;

        public FormatItem(String string, int n) {
            super(string);
            this.mFormatType = n;
        }

        @Override
        public String toString() {
            return this.getText();
        }

        public int getFormatType() {
            return this.mFormatType;
        }
    }
}

