/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.edit;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.common.prefs.PrefDefaults;
import com.spss.java_client.core.template.viewer.ViewerUserOptions;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.base.edit.OptionPanel;
import com.spss.java_client.ui.dialogs.base.edit.OptionsDlg;
import com.spss.java_client.ui.dialogs.base.edit.OptionsUtil;
import com.spss.java_client.ui.dialogs.base.edit.ToolBarPanel;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.TextFieldAction;
import com.spss.java_client.ui.dialogs.documents.output.pagesetup.PageSetupUtil;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.java_client.ui.texteditor.SpssTextPane;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.shared.core_tools.utils.FontUtil;
import com.spss.uitools.controls.FloatTextField;
import com.spss.uitools.util.AccessibilityUtil;
import com.spss.uitools.util.IOptionConstants;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class ViewerOptionPanel
extends OptionPanel
implements ItemListener,
PopupMenuListener {
    public static String IDS_VIEWER_PAGE_MARGIN_LEFT_VALUE = "IDS_VIEWER_PAGE_MARGIN_LEFT_VALUE";
    public static String IDS_VIEWER_PAGE_MARGIN_RIGHT_VALUE = "IDS_VIEWER_PAGE_MARGIN_RIGHT_VALUE";
    public static String IDS_VIEWER_PAGE_MARGIN_TOP_VALUE = "IDS_VIEWER_PAGE_MARGIN_TOP_VALUE";
    public static String IDS_VIEWER_PAGE_MARGIN_BOTTOM_VALUE = "IDS_VIEWER_PAGE_MARGIN_BOTTOM_VALUE";
    private static String[] sFontSizes;
    private ImageIcon mLogShownImage;
    private ImageIcon mLogHiddenImage;
    private ImageIcon mWarningsShownImage;
    private ImageIcon mWarningsHiddenImage;
    private ImageIcon mNotesShownImage;
    private ImageIcon mNotesHiddenImage;
    private ImageIcon mTitleShownImage;
    private ImageIcon mTitleHiddenImage;
    private ImageIcon mPageTitleShownImage;
    private ImageIcon mPageTitleHiddenImage;
    private ImageIcon mPivotTableShownImage;
    private ImageIcon mPivotTableHiddenImage;
    private ImageIcon mChartShownImage;
    private ImageIcon mChartHiddenImage;
    private ImageIcon mTextOutputShownImage;
    private ImageIcon mTextOutputHiddenImage;
    private ImageIcon mTreeModelShownImage;
    private ImageIcon mModelShownImage;
    private ImageIcon mModelHiddenImage;
    private ImageIcon mTreeModelHiddenImage;
    private ImageIcon mUnknownShownImage;
    private ImageIcon mUnknownHiddenImage;
    private JList mItemImagesList;
    private JLabel mItemLabel;
    private JComboBox mItemNamesComboBox;
    private JLabel mContentsLabel;
    private JRadioButton mShownRadio;
    private JRadioButton mHiddenRadio;
    private SpssButtonGroup mContentsRadioButtonGroup;
    private JLabel mJustificationLabel;
    private JRadioButton mAlignLeftRadio;
    private JRadioButton mCenterAlignRadio;
    private JRadioButton mAlignRightRadio;
    private SpssButtonGroup mJustificationButtonGroup;
    private JCheckBox mDisplayCommandsCheckBox;
    private JComboBox mTitleFontComboBox;
    private JComboBox mTitleFontSizesComboBox;
    private ToolBarPanel mFontToolBarPanel;
    private JComboBox mPageTitleFontComboBox;
    private JComboBox mPageTitleFontSizesComboBox;
    private ToolBarPanel mPageFontToolBarPanel;
    private JComboBox mOutputFontComboBox;
    private JComboBox mOutputFontSizeComboBox;
    private ToolBarPanel mOutputFontToolBarPanel;
    private HashMap<Integer, Vector<String>> mItemStateMap;
    private HashMap<Integer, Boolean> mItemStateChanged;
    private FontState mTitleFontState;
    private FontState mPageTitleFontState;
    private FontState mOutputFontState;
    private JRadioButton mPortraitRadio;
    private JRadioButton mLandscapeRadio;
    private SpssButtonGroup mOrientationGroup;
    private JLabel mLeftMarginLabel;
    private FloatTextField mLeftMargin;
    private JLabel mRightMarginLabel;
    private FloatTextField mRightMargin;
    private JLabel mTopMarginLabel;
    private FloatTextField mTopMargin;
    private JLabel mBottomMarginLabel;
    private FloatTextField mBottomMargin;
    private MouseClickHandler mMouseClickHandler;

    public ViewerOptionPanel(OptionsDlg optionsDlg, Preferences preferences, String string) {
        super(optionsDlg, preferences, string);
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
        if (popupMenuEvent.getSource().equals(this.mTitleFontSizesComboBox)) {
            String string = (String)this.mTitleFontSizesComboBox.getSelectedItem();
            int n = string.length() == 0 ? -1 : this.getMaxMatchingIndex(this.mTitleFontSizesComboBox, string);
            this.mTitleFontSizesComboBox.setSelectedIndex(n);
        } else if (popupMenuEvent.getSource().equals(this.mOutputFontSizeComboBox)) {
            String string = (String)this.mOutputFontSizeComboBox.getSelectedItem();
            int n = string.length() == 0 ? -1 : this.getMaxMatchingIndex(this.mOutputFontSizeComboBox, string);
            this.mOutputFontSizeComboBox.setSelectedIndex(n);
        }
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
        if (popupMenuEvent.getSource().equals(this.mTitleFontComboBox) || popupMenuEvent.getSource().equals(this.mTitleFontSizesComboBox)) {
            this.saveTitleFontState();
        } else if (popupMenuEvent.getSource().equals(this.mPageTitleFontComboBox) || popupMenuEvent.getSource().equals(this.mPageTitleFontSizesComboBox)) {
            this.savePageTitleFontState();
        } else if (popupMenuEvent.getSource().equals(this.mOutputFontComboBox) || popupMenuEvent.getSource().equals(this.mOutputFontSizeComboBox)) {
            this.saveOutputFontState();
        }
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        int n = this.mItemImagesList.getSelectedIndex();
        if (keyEvent.getKeyCode() == 39) {
            if (n != this.mItemImagesList.getModel().getSize() - 1) {
                this.mItemImagesList.setSelectedIndex(n + 1);
                this.mItemImagesList.ensureIndexIsVisible(n + 1);
            }
        } else if (keyEvent.getKeyCode() == 37 && n != 0) {
            this.mItemImagesList.setSelectedIndex(n - 1);
            this.mItemImagesList.ensureIndexIsVisible(n - 1);
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.getSource().equals(this.mTitleFontSizesComboBox.getEditor().getEditorComponent()) || keyEvent.getSource().equals(this.mOutputFontSizeComboBox.getEditor().getEditorComponent()) || keyEvent.getSource().equals(this.mPageTitleFontSizesComboBox.getEditor().getEditorComponent())) {
            this.setupTitleFontSizeErrMsg();
            this.setupPageTitleFontSizeErrMsg();
            this.setupOutputFontSizeErrMsg();
        }
        super.keyReleased(keyEvent);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object.equals(this.mItemNamesComboBox)) {
            this.mShownRadio.removeItemListener(this);
            this.mHiddenRadio.removeItemListener(this);
            this.mAlignLeftRadio.removeItemListener(this);
            this.mCenterAlignRadio.removeItemListener(this);
            this.mAlignRightRadio.removeItemListener(this);
            this.loadItemState();
            this.mShownRadio.addItemListener(this);
            this.mHiddenRadio.addItemListener(this);
            this.mAlignLeftRadio.addItemListener(this);
            this.mCenterAlignRadio.addItemListener(this);
            this.mAlignRightRadio.addItemListener(this);
            this.mItemImagesList.setSelectedValue(this.mItemImagesList.getModel().getElementAt(this.mItemNamesComboBox.getSelectedIndex()), true);
        } else if (object.equals(this.mTitleFontComboBox) || object.equals(this.mTitleFontSizesComboBox) || object.equals(this.mFontToolBarPanel.getBoldButton()) || object.equals(this.mFontToolBarPanel.getItalicButton()) || object.equals(this.mFontToolBarPanel.getUnderlineButton())) {
            if (object.equals(this.mTitleFontSizesComboBox)) {
                this.mTitleFontSizesComboBox.getEditor().setItem(this.mTitleFontSizesComboBox.getSelectedItem());
            }
            this.saveTitleFontState();
            super.actionPerformed(actionEvent);
        } else if (object.equals(this.mPageTitleFontComboBox) || object.equals(this.mPageTitleFontSizesComboBox) || object.equals(this.mPageFontToolBarPanel.getBoldButton()) || object.equals(this.mPageFontToolBarPanel.getItalicButton()) || object.equals(this.mPageFontToolBarPanel.getUnderlineButton())) {
            if (object.equals(this.mPageTitleFontSizesComboBox)) {
                this.mPageTitleFontSizesComboBox.getEditor().setItem(this.mPageTitleFontSizesComboBox.getSelectedItem());
            }
            this.savePageTitleFontState();
            super.actionPerformed(actionEvent);
        } else if (object.equals(this.mFontToolBarPanel.getColorButton())) {
            this.saveTitleFontState();
            if (this.mTitleFontState.isColorChanged()) {
                super.actionPerformed(actionEvent);
            }
        } else if (object.equals(this.mPageFontToolBarPanel.getColorButton())) {
            this.savePageTitleFontState();
            if (this.mPageTitleFontState.isColorChanged()) {
                super.actionPerformed(actionEvent);
            }
        } else if (object.equals(this.mOutputFontComboBox) || object.equals(this.mOutputFontSizeComboBox) || object.equals(this.mOutputFontToolBarPanel.getBoldButton()) || object.equals(this.mOutputFontToolBarPanel.getItalicButton()) || object.equals(this.mOutputFontToolBarPanel.getUnderlineButton())) {
            if (object.equals(this.mOutputFontSizeComboBox)) {
                this.mOutputFontSizeComboBox.getEditor().setItem(this.mOutputFontSizeComboBox.getSelectedItem());
            }
            this.saveOutputFontState();
            super.actionPerformed(actionEvent);
        } else if (object.equals(this.mOutputFontToolBarPanel.getColorButton())) {
            this.saveOutputFontState();
            if (this.mOutputFontState.isColorChanged()) {
                super.actionPerformed(actionEvent);
            }
        } else if (object.equals(this.mShownRadio) || object.equals(this.mHiddenRadio) || object.equals(this.mAlignLeftRadio) || object.equals(this.mCenterAlignRadio) || object.equals(this.mAlignRightRadio)) {
            this.saveItemState();
            super.actionPerformed(actionEvent);
        } else if (object.equals(this.mLandscapeRadio)) {
            this.rotatingPageMargin(this.mLandscapeRadio);
            super.actionPerformed(actionEvent);
        } else if (object.equals(this.mPortraitRadio)) {
            this.rotatingPageMargin(this.mPortraitRadio);
            super.actionPerformed(actionEvent);
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getSource().equals(this.mItemImagesList) && this.mItemImagesList.getSelectedIndex() != -1) {
            this.mItemNamesComboBox.setSelectedIndex(this.mItemImagesList.getSelectedIndex());
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        boolean bl;
        boolean bl2 = bl = itemEvent.getStateChange() == 1;
        if ((itemEvent.getSource().equals(this.mShownRadio) || itemEvent.getSource().equals(this.mHiddenRadio)) && bl) {
            this.saveItemState();
            this.enableApply();
        }
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        super.insertUpdate(documentEvent);
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        super.insertUpdate(documentEvent);
    }

    @Override
    public String getDialogHelpID() {
        return "idh_pref_output";
    }

    @Override
    public void initPanel() {
        super.initPanel();
    }

    @Override
    public void initVars() {
        boolean bl = OSInfo.getOSType() == OSInfo.OSType.WIN;
        this.mItemImagesList = new JList();
        this.mItemImagesList.setSelectionMode(0);
        this.mItemImagesList.setMinimumSize(new Dimension(55, this.mItemImagesList.getMinimumSize().height));
        this.mItemImagesList.setCellRenderer(new ItemImagesListRenderer());
        URL uRL = ResUtil.getImageResource(this.mOptionDialog.getResString("IDS_NAV_TREE_LOG_OPEN32_IMAGE"));
        this.mLogShownImage = new ImageIcon(uRL);
        uRL = ResUtil.getImageResource(this.mOptionDialog.getResString("IDS_NAV_TREE_LOG_CLOSED32_IMAGE"));
        this.mLogHiddenImage = new ImageIcon(uRL);
        JLabel jLabel = new JLabel(this.mLogShownImage);
        uRL = ResUtil.getImageResource(this.mOptionDialog.getResString("IDS_NAV_TREE_WARNING_OPEN32_IMAGE"));
        this.mWarningsShownImage = new ImageIcon(uRL);
        uRL = ResUtil.getImageResource(this.mOptionDialog.getResString("IDS_NAV_TREE_WARNING_CLOSED32_IMAGE"));
        this.mWarningsHiddenImage = new ImageIcon(uRL);
        JLabel jLabel2 = new JLabel(this.mWarningsShownImage);
        uRL = ResUtil.getImageResource(this.mOptionDialog.getResString("IDS_NAV_TREE_NOTES_OPEN32_IMAGE"));
        this.mNotesShownImage = new ImageIcon(uRL);
        uRL = ResUtil.getImageResource(this.mOptionDialog.getResString("IDS_NAV_TREE_NOTES_CLOSED32_IMAGE"));
        this.mNotesHiddenImage = new ImageIcon(uRL);
        JLabel jLabel3 = new JLabel(this.mNotesHiddenImage);
        uRL = ResUtil.getImageResource(this.mOptionDialog.getResString("IDS_NAV_TREE_TITLE_OPEN32_IMAGE"));
        this.mTitleShownImage = new ImageIcon(uRL);
        uRL = ResUtil.getImageResource(this.mOptionDialog.getResString("IDS_NAV_TREE_TITLE_CLOSED32_IMAGE"));
        this.mTitleHiddenImage = new ImageIcon(uRL);
        JLabel jLabel4 = new JLabel(this.mTitleShownImage);
        uRL = ResUtil.getImageResource(this.mOptionDialog.getResString("IDS_NAV_TREE_PAGE_TITLE_OPEN32_IMAGE"));
        this.mPageTitleShownImage = new ImageIcon(uRL);
        uRL = ResUtil.getImageResource(this.mOptionDialog.getResString("IDS_NAV_TREE_PAGE_TITLE_CLOSED32_IMAGE"));
        this.mPageTitleHiddenImage = new ImageIcon(uRL);
        JLabel jLabel5 = new JLabel(this.mPageTitleShownImage);
        uRL = ResUtil.getImageResource(this.mOptionDialog.getResString("IDS_NAV_TREE_TABLE_OPEN32_IMAGE"));
        this.mPivotTableShownImage = new ImageIcon(uRL);
        uRL = ResUtil.getImageResource(this.mOptionDialog.getResString("IDS_NAV_TREE_TABLE_CLOSED32_IMAGE"));
        this.mPivotTableHiddenImage = new ImageIcon(uRL);
        JLabel jLabel6 = new JLabel(this.mPivotTableShownImage);
        uRL = ResUtil.getImageResource(this.mOptionDialog.getResString("IDS_NAV_TREE_CHART_OPEN32_IMAGE"));
        this.mChartShownImage = new ImageIcon(uRL);
        uRL = ResUtil.getImageResource(this.mOptionDialog.getResString("IDS_NAV_TREE_CHART_CLOSED32_IMAGE"));
        this.mChartHiddenImage = new ImageIcon(uRL);
        JLabel jLabel7 = new JLabel(this.mChartShownImage);
        uRL = ResUtil.getImageResource(this.mOptionDialog.getResString("IDS_NAV_TREE_TEXT_OPEN32_IMAGE"));
        this.mTextOutputShownImage = new ImageIcon(uRL);
        uRL = ResUtil.getImageResource(this.mOptionDialog.getResString("IDS_NAV_TREE_TEXT_CLOSED32_IMAGE"));
        this.mTextOutputHiddenImage = new ImageIcon(uRL);
        JLabel jLabel8 = new JLabel(this.mTextOutputShownImage);
        uRL = ResUtil.getImageResource(this.mOptionDialog.getResString("IDS_NAV_TREE_TREE_MODEL_OPEN32_IMAGE"));
        this.mTreeModelShownImage = new ImageIcon(uRL);
        uRL = ResUtil.getImageResource(this.mOptionDialog.getResString("IDS_NAV_TREE_TREE_MODEL_CLOSED32_IMAGE"));
        this.mTreeModelHiddenImage = new ImageIcon(uRL);
        JLabel jLabel9 = new JLabel(this.mTreeModelShownImage);
        uRL = ResUtil.getImageResource(this.mOptionDialog.getResString("IDS_NAV_TREE_MODELVIEWER_OPEN32_IMAGE"));
        this.mModelShownImage = new ImageIcon(uRL);
        uRL = ResUtil.getImageResource(this.mOptionDialog.getResString("IDS_NAV_TREE_MODELVIEWER_CLOSED32_IMAGE"));
        this.mModelHiddenImage = new ImageIcon(uRL);
        JLabel jLabel10 = new JLabel(this.mModelShownImage);
        uRL = ResUtil.getImageResource(this.mOptionDialog.getResString("IDS_NAV_TREE_UNKNOWN_OPEN32_IMAGE"));
        this.mUnknownShownImage = new ImageIcon(uRL);
        uRL = ResUtil.getImageResource(this.mOptionDialog.getResString("IDS_NAV_TREE_UNKNOWN_CLOSED32_IMAGE"));
        this.mUnknownHiddenImage = new ImageIcon(uRL);
        JLabel jLabel11 = new JLabel(this.mUnknownShownImage);
        DefaultListModel<JLabel> defaultListModel = new DefaultListModel<JLabel>();
        defaultListModel.addElement(jLabel);
        defaultListModel.addElement(jLabel2);
        defaultListModel.addElement(jLabel3);
        defaultListModel.addElement(jLabel4);
        defaultListModel.addElement(jLabel5);
        defaultListModel.addElement(jLabel6);
        defaultListModel.addElement(jLabel7);
        defaultListModel.addElement(jLabel8);
        defaultListModel.addElement(jLabel9);
        defaultListModel.addElement(jLabel10);
        defaultListModel.addElement(jLabel11);
        this.mItemImagesList.setModel(defaultListModel);
        this.mItemLabel = DialogUtil.createLabel(this.mOptionDialog, "IDS_VIEWER_ITEM_LABEL");
        this.mItemNamesComboBox = new JComboBox();
        this.mItemNamesComboBox.setMaximumRowCount(13);
        String[] stringArray = bl ? this.mOptionDialog.getResStringArray("IDS_VIEWER_ITEM_NAMES_WIN_OS") : this.mOptionDialog.getResStringArray("IDS_VIEWER_ITEM_NAMES_OTHER_OS");
        this.mItemNamesComboBox.setModel(new DefaultComboBoxModel<String>(stringArray));
        this.mItemLabel.setLabelFor(this.mItemNamesComboBox);
        this.mContentsLabel = new JLabel(this.mOptionDialog.getResString("IDS_VIEWER_CONTENTS_LABEL"));
        this.mShownRadio = DialogUtil.createRadioButton(this.mOptionDialog, "IDS_VIEWER_SHOWN_RADIO", (ActionListener)this);
        this.mHiddenRadio = DialogUtil.createRadioButton(this.mOptionDialog, "IDS_VIEWER_HIDDEN_RADIO", (ActionListener)this);
        this.mJustificationLabel = new JLabel(this.mOptionDialog.getResString("IDS_VIEWER_JUSTIFICATION_LABEL"));
        this.mAlignLeftRadio = DialogUtil.createRadioButton(this.mOptionDialog, "IDS_VIEWER_ALIGN_LEFT_RADIO", (ActionListener)this);
        this.mCenterAlignRadio = DialogUtil.createRadioButton(this.mOptionDialog, "IDS_VIEWER_ALIGN_CENTER_RADIO", (ActionListener)this);
        this.mAlignRightRadio = DialogUtil.createRadioButton(this.mOptionDialog, "IDS_VIEWER_ALIGN_RIGHT_RADIO", (ActionListener)this);
        if (!VersionInfo.isStudentVersion()) {
            this.mDisplayCommandsCheckBox = DialogUtil.createCheckBox(this.mOptionDialog, "IDS_VIEWER_DISPLAY_CMD_CHECK_BOX", (ActionListener)this);
        }
        String[] stringArray2 = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames(ResUtil.getLocale());
        this.mTitleFontComboBox = new JComboBox();
        this.mTitleFontComboBox.setModel(new DefaultComboBoxModel<String>(stringArray2));
        this.mTitleFontSizesComboBox = new JComboBox();
        this.mTitleFontSizesComboBox.setModel(new DefaultComboBoxModel<String>(sFontSizes));
        this.mTitleFontSizesComboBox.setEditable(false);
        this.mPageTitleFontComboBox = new JComboBox();
        this.mPageTitleFontComboBox.setModel(new DefaultComboBoxModel<String>(stringArray2));
        this.mPageTitleFontSizesComboBox = new JComboBox();
        this.mPageTitleFontSizesComboBox.setModel(new DefaultComboBoxModel<String>(sFontSizes));
        this.mPageTitleFontSizesComboBox.setEditable(false);
        this.mOutputFontComboBox = new JComboBox();
        this.mOutputFontComboBox.setModel(new DefaultComboBoxModel<String>(stringArray2));
        this.mOutputFontSizeComboBox = new JComboBox();
        this.mOutputFontSizeComboBox.setModel(new DefaultComboBoxModel<String>(sFontSizes));
        this.mOutputFontSizeComboBox.setEditable(false);
        this.mItemStateChanged = new HashMap();
        for (int i = 0; i < 12; ++i) {
            this.mItemStateChanged.put(i, false);
        }
        this.mItemStateMap = new HashMap();
        this.mTitleFontState = new FontState();
        this.mPageTitleFontState = new FontState();
        this.mOutputFontState = new FontState();
        this.mMouseClickHandler = new MouseClickHandler();
        this.mPortraitRadio = DialogUtil.createRadioButton(this.mOptionDialog, "IDS_VIEWER_PAGE_ORIENTATION_PORTRAIT_RADIO", null);
        this.mPortraitRadio.setSelected(true);
        this.mLandscapeRadio = DialogUtil.createRadioButton(this.mOptionDialog, "IDS_VIEWER_PAGE_ORIENTATION_LANDSCAPE_RADIO", null);
        this.mOrientationGroup = new SpssButtonGroup();
        this.mOrientationGroup.add(this.mPortraitRadio);
        this.mOrientationGroup.add(this.mLandscapeRadio);
        this.mLeftMargin = new FloatTextField();
        this.mLeftMargin.setIncludeMaxRange(false);
        this.mLeftMargin.setHorizontalAlignment(4);
        this.mLeftMargin.setAction((Action)new TextFieldAction(this.mOptionDialog, IDS_VIEWER_PAGE_MARGIN_LEFT_VALUE));
        this.mLeftMargin.setColumns(10);
        this.mLeftMarginLabel = DialogUtil.createLabel(this.mOptionDialog, "IDS_VIEWER_PAGE_MARGIN_LEFT_LABEL");
        this.mLeftMarginLabel.setLabelFor((Component)this.mLeftMargin);
        this.mRightMargin = new FloatTextField();
        this.mRightMargin.setIncludeMaxRange(false);
        this.mRightMargin.setHorizontalAlignment(4);
        this.mRightMargin.setAction((Action)new TextFieldAction(this.mOptionDialog, IDS_VIEWER_PAGE_MARGIN_RIGHT_VALUE));
        this.mRightMargin.setColumns(10);
        this.mRightMarginLabel = DialogUtil.createLabel(this.mOptionDialog, "IDS_VIEWER_PAGE_MARGIN_RIGHT_LABEL");
        this.mRightMarginLabel.setLabelFor((Component)this.mRightMargin);
        this.mTopMargin = new FloatTextField();
        this.mTopMargin.setIncludeMaxRange(false);
        this.mTopMargin.setHorizontalAlignment(4);
        this.mTopMargin.setAction((Action)new TextFieldAction(this.mOptionDialog, IDS_VIEWER_PAGE_MARGIN_TOP_VALUE));
        this.mTopMargin.setColumns(10);
        this.mTopMarginLabel = DialogUtil.createLabel(this.mOptionDialog, "IDS_VIEWER_PAGE_MARGIN_TOP_LABEL");
        this.mTopMarginLabel.setLabelFor((Component)this.mTopMargin);
        this.mBottomMargin = new FloatTextField();
        this.mBottomMargin.setIncludeMaxRange(false);
        this.mBottomMargin.setHorizontalAlignment(4);
        this.mBottomMargin.setAction((Action)new TextFieldAction(this.mOptionDialog, IDS_VIEWER_PAGE_MARGIN_BOTTOM_VALUE));
        this.mBottomMargin.setColumns(10);
        this.mBottomMarginLabel = DialogUtil.createLabel(this.mOptionDialog, "IDS_VIEWER_PAGE_MARGIN_BOTTOM_LABEL");
        this.mBottomMarginLabel.setLabelFor((Component)this.mBottomMargin);
        this.addComponents();
        this.setTabTraversal();
    }

    @Override
    public void readPrefs() {
        int n;
        Preferences preferences = this.mOptionsPrefs;
        this.readPrefsValuesForItems();
        this.mItemImagesList.requestFocusInWindow();
        this.mItemImagesList.setSelectedIndex(0);
        Vector<String> vector = this.mItemStateMap.get(0);
        String string = vector.get(0);
        int n2 = DialogUtil.getIndexOfItem(IOptionConstants.VIEWER_CONTENTS_VALUES, string);
        DialogUtil.setSelectedButton(this.mContentsRadioButtonGroup, n2);
        this.mAlignLeftRadio.setSelected(true);
        this.enableJustificationButtons(false);
        for (int i = 0; i < this.mItemImagesList.getModel().getSize(); ++i) {
            this.loadImageList(i);
        }
        if (this.mDisplayCommandsCheckBox != null) {
            String string2 = preferences.get("printback", PrefDefaults.DEF_PRINTBACK);
            int n3 = n = string2.equalsIgnoreCase(IOptionConstants.VIEWER_PRINTBACK_ON) || string2.equalsIgnoreCase("Listing") || string2.equalsIgnoreCase("Both") || string2.equalsIgnoreCase("Yes") ? 1 : 0;
            if (n != 0) {
                this.mDisplayCommandsCheckBox.setSelected(true);
            } else {
                this.mDisplayCommandsCheckBox.setSelected(false);
            }
        }
        this.readPrefsValuesForFonts();
        String string3 = ViewerUserOptions.getFontNameForTextOutput();
        this.mOutputFontComboBox.setSelectedItem(string3);
        this.mOutputFontState.setFontName(string3);
        n = preferences.getInt("output_font_size", PrefDefaults.DEF_VIEWER_TEXT_OUTPUT_FONT_SIZE);
        this.mOutputFontSizeComboBox.setSelectedItem(SpssTextPane.formatLogicalFontSize(FontUtil.physicalToLogicalSize((float)n)));
        this.mOutputFontState.setFontSize(n);
        boolean bl = preferences.getBoolean("output_font_bold", false);
        this.mOutputFontToolBarPanel.getBoldButton().setSelected(bl);
        this.mOutputFontState.setBold(bl);
        bl = preferences.getBoolean("output_font_italic", false);
        this.mOutputFontToolBarPanel.getItalicButton().setSelected(bl);
        this.mOutputFontState.setItalic(bl);
        bl = preferences.getBoolean("output_font_underline", false);
        this.mOutputFontToolBarPanel.getUnderlineButton().setSelected(bl);
        this.mOutputFontState.setUnderline(bl);
        int n4 = preferences.getInt("output_font_color", 0);
        this.mOutputFontToolBarPanel.setColorButtonColor(this.getColor(n4));
        this.mOutputFontState.setColor(n4);
        this.readPrefsValuesForPageSetup();
        this.addListeners();
    }

    @Override
    public void savePrefs() {
        Preferences preferences = this.mOptionsPrefs;
        this.savePrefsValuesForItems();
        if (this.mDisplayCommandsCheckBox != null && this.mDisplayCommandsCheckBox.isSelected()) {
            preferences.put("printback", IOptionConstants.VIEWER_PRINTBACK_ON);
        } else {
            preferences.put("printback", IOptionConstants.VIEWER_PRINTBACK_OFF);
        }
        this.savePrefsValuesForFonts();
        if (this.mOutputFontState.isFontNameChanged()) {
            preferences.put("output_font_name", (String)this.mOutputFontComboBox.getSelectedItem());
        }
        if (this.mOutputFontState.isFontSizeChanged()) {
            preferences.put("output_font_size", String.valueOf(this.mOutputFontState.getFontSize()));
        }
        if (this.mOutputFontState.isBoldChanged()) {
            preferences.putBoolean("output_font_bold", this.mOutputFontToolBarPanel.getBoldButton().isSelected());
        }
        if (this.mOutputFontState.isItalicChanged()) {
            preferences.putBoolean("output_font_italic", this.mOutputFontToolBarPanel.getItalicButton().isSelected());
        }
        if (this.mOutputFontState.isUnderlineChanged()) {
            preferences.putBoolean("output_font_underline", this.mOutputFontToolBarPanel.getUnderlineButton().isSelected());
        }
        if (this.mOutputFontState.isColorChanged()) {
            preferences.putInt("output_font_color", this.mOutputFontState.getColor());
        }
        this.savePrefsValuesForPageSetup();
    }

    public void enableApply() {
        this.mOptionDialog.enableApplyAction(true);
        this.setOptionsChanged(true);
    }

    public void saveTitleColor() {
        Color color = this.mFontToolBarPanel.getColorButtonColor();
        int n = color.getRGB();
        if (this.mTitleFontState.getColor() != (n &= 0xFFFFFF)) {
            this.mTitleFontState.setColor(n);
            this.mTitleFontState.setColorChanged(true);
        }
    }

    public void savePageTitleColor() {
        Color color = this.mPageFontToolBarPanel.getColorButtonColor();
        int n = color.getRGB();
        if (this.mPageTitleFontState.getColor() != (n &= 0xFFFFFF)) {
            this.mPageTitleFontState.setColor(n);
            this.mPageTitleFontState.setColorChanged(true);
        }
    }

    @Override
    protected int getId() {
        return 8;
    }

    private int getMaxMatchingIndex(JComboBox jComboBox, String string) {
        int n = -1;
        for (int i = 0; i < jComboBox.getModel().getSize(); ++i) {
            String string2 = (String)jComboBox.getModel().getElementAt(i);
            if (!string2.startsWith(string)) continue;
            n = i;
            break;
        }
        return n;
    }

    private void setupTitleFontSizeErrMsg() {
        block11: {
            String string;
            if (OptionsDlg.sErrorMessagesDialogs.containsKey(this.mTitleFontSizesComboBox)) {
                OptionsDlg.sErrorMessagesDialogs.remove(this.mTitleFontSizesComboBox);
            }
            if (OptionsDlg.sErrorMessagesDialogs.containsKey(this.mPageTitleFontSizesComboBox)) {
                OptionsDlg.sErrorMessagesDialogs.remove(this.mPageTitleFontSizesComboBox);
            }
            if (OptionsDlg.sErrorMessagesDialogs.containsKey(this.mOutputFontSizeComboBox)) {
                OptionsDlg.sErrorMessagesDialogs.remove(this.mOutputFontSizeComboBox);
            }
            if ((string = (String)this.mTitleFontSizesComboBox.getSelectedItem()) != null) {
                if (!string.equals("")) {
                    try {
                        Double d = Double.parseDouble(string);
                        if (d.intValue() < 1 || d.intValue() > 99) {
                            if (!OptionsDlg.sErrorMessagesDialogs.containsKey(this.mOutputFontSizeComboBox)) {
                                OptionsDlg.sErrorMessagesDialogs.put(this.mTitleFontSizesComboBox, this.getResString("ERR_VIEWER_INVALID_FONT_VALUE_ERROR_MSG"));
                            }
                            break block11;
                        }
                        this.saveTitleFontState();
                    }
                    catch (NumberFormatException numberFormatException) {
                        OptionsDlg.sErrorMessagesDialogs.put(this.mTitleFontSizesComboBox, this.getResString("ERR_VIEWER_EMPTY_VALUE_ERROR_MSG"));
                    }
                } else if (!OptionsDlg.sErrorMessagesDialogs.containsKey(this.mOutputFontSizeComboBox) && !OptionsDlg.sErrorMessagesDialogs.containsKey(this.mPageTitleFontSizesComboBox)) {
                    OptionsDlg.sErrorMessagesDialogs.put(this.mTitleFontSizesComboBox, this.getResString("ERR_VIEWER_EMPTY_VALUE_ERROR_MSG"));
                }
            }
        }
    }

    private void setupPageTitleFontSizeErrMsg() {
        block11: {
            String string;
            if (OptionsDlg.sErrorMessagesDialogs.containsKey(this.mTitleFontSizesComboBox)) {
                OptionsDlg.sErrorMessagesDialogs.remove(this.mTitleFontSizesComboBox);
            }
            if (OptionsDlg.sErrorMessagesDialogs.containsKey(this.mPageTitleFontSizesComboBox)) {
                OptionsDlg.sErrorMessagesDialogs.remove(this.mPageTitleFontSizesComboBox);
            }
            if (OptionsDlg.sErrorMessagesDialogs.containsKey(this.mOutputFontSizeComboBox)) {
                OptionsDlg.sErrorMessagesDialogs.remove(this.mOutputFontSizeComboBox);
            }
            if ((string = (String)this.mPageTitleFontSizesComboBox.getEditor().getItem()) != null) {
                if (!string.equals("")) {
                    try {
                        Double d = Double.parseDouble(string);
                        if (d.intValue() < 1 || d.intValue() > 99) {
                            if (!OptionsDlg.sErrorMessagesDialogs.containsKey(this.mOutputFontSizeComboBox) && !OptionsDlg.sErrorMessagesDialogs.containsKey(this.mTitleFontSizesComboBox)) {
                                OptionsDlg.sErrorMessagesDialogs.put(this.mPageTitleFontSizesComboBox, this.getResString("ERR_VIEWER_INVALID_FONT_VALUE_ERROR_MSG"));
                            }
                            break block11;
                        }
                        this.savePageTitleFontState();
                    }
                    catch (NumberFormatException numberFormatException) {
                        OptionsDlg.sErrorMessagesDialogs.put(this.mPageTitleFontSizesComboBox, this.getResString("ERR_VIEWER_EMPTY_VALUE_ERROR_MSG"));
                    }
                } else if (!OptionsDlg.sErrorMessagesDialogs.containsKey(this.mOutputFontSizeComboBox) && !OptionsDlg.sErrorMessagesDialogs.containsKey(this.mTitleFontSizesComboBox)) {
                    OptionsDlg.sErrorMessagesDialogs.put(this.mPageTitleFontSizesComboBox, this.getResString("ERR_VIEWER_EMPTY_VALUE_ERROR_MSG"));
                }
            }
        }
    }

    private void setupOutputFontSizeErrMsg() {
        block9: {
            String string;
            if (OptionsDlg.sErrorMessagesDialogs.containsKey(this.mOutputFontSizeComboBox)) {
                OptionsDlg.sErrorMessagesDialogs.remove(this.mOutputFontSizeComboBox);
            }
            if ((string = (String)this.mOutputFontSizeComboBox.getEditor().getItem()) != null) {
                if (!string.equals("")) {
                    try {
                        Double d = Double.parseDouble(string);
                        if (d.intValue() < 1 || d.intValue() > 99) {
                            if (!OptionsDlg.sErrorMessagesDialogs.containsKey(this.mTitleFontSizesComboBox)) {
                                OptionsDlg.sErrorMessagesDialogs.put(this.mOutputFontSizeComboBox, this.getResString("ERR_VIEWER_INVALID_FONT_VALUE_ERROR_MSG"));
                            }
                            break block9;
                        }
                        this.saveOutputFontState();
                    }
                    catch (NumberFormatException numberFormatException) {
                        OptionsDlg.sErrorMessagesDialogs.put(this.mOutputFontSizeComboBox, this.getResString("ERR_VIEWER_EMPTY_VALUE_ERROR_MSG"));
                    }
                } else if (!OptionsDlg.sErrorMessagesDialogs.containsKey(this.mTitleFontSizesComboBox)) {
                    OptionsDlg.sErrorMessagesDialogs.put(this.mOutputFontSizeComboBox, this.getResString("ERR_VIEWER_EMPTY_VALUE_ERROR_MSG"));
                }
            }
        }
    }

    private void addListeners() {
        this.addMouseListener(this.mMouseClickHandler);
        this.mItemImagesList.addKeyListener(this);
        this.mItemImagesList.addListSelectionListener(this);
        this.mItemImagesList.addMouseListener(this.mMouseClickHandler);
        this.mItemNamesComboBox.addActionListener(this);
        this.mShownRadio.addActionListener(this);
        this.mShownRadio.addItemListener(this);
        this.mHiddenRadio.addActionListener(this);
        this.mHiddenRadio.addItemListener(this);
        this.mTitleFontComboBox.addActionListener(this);
        this.mTitleFontSizesComboBox.addPopupMenuListener(this);
        this.mTitleFontSizesComboBox.addActionListener(this);
        this.mPageTitleFontComboBox.addActionListener(this);
        this.mPageTitleFontSizesComboBox.addPopupMenuListener(this);
        this.mPageTitleFontSizesComboBox.addActionListener(this);
        this.mOutputFontComboBox.addActionListener(this);
        this.mOutputFontSizeComboBox.addPopupMenuListener(this);
        this.mOutputFontSizeComboBox.addActionListener(this);
        this.mLandscapeRadio.addActionListener(this);
        this.mPortraitRadio.addActionListener(this);
        this.mLeftMargin.addKeyListener((KeyListener)this);
        this.mRightMargin.addKeyListener((KeyListener)this);
        this.mTopMargin.addKeyListener((KeyListener)this);
        this.mBottomMargin.addKeyListener((KeyListener)this);
    }

    private void readPrefsValuesForItems() {
        Preferences preferences = this.mOptionsPrefs;
        String string = preferences.get("log_contents", PrefDefaults.DEF_LOG_CONTENTS);
        Vector<String> vector = new Vector<String>();
        vector.add(0, string);
        vector.add(1, "");
        this.mItemStateMap.put(0, vector);
        vector = new Vector();
        string = preferences.get("warnings_contents", PrefDefaults.DEF_WARNINGS_CONTENTS);
        vector.add(0, string);
        string = preferences.get("warnings_justification", PrefDefaults.DEF_WARNINGS_JUSTIFICATION);
        vector.add(1, string);
        this.mItemStateMap.put(1, vector);
        vector = new Vector();
        string = preferences.get("notes_contents", PrefDefaults.DEF_NOTES_CONTENTS);
        vector.add(0, string);
        string = preferences.get("notes_justification", PrefDefaults.DEF_NOTES_JUSTIFICATION);
        vector.add(1, string);
        this.mItemStateMap.put(2, vector);
        vector = new Vector();
        string = preferences.get("title_contents", PrefDefaults.DEF_TITLE_CONTENTS);
        vector.add(0, string);
        string = preferences.get("title_justification", PrefDefaults.DEF_TITLE_JUSTIFICATION);
        vector.add(1, string);
        this.mItemStateMap.put(3, vector);
        vector = new Vector();
        string = preferences.get("page_title_contents", PrefDefaults.DEF_PAGE_TITLE_CONTENTS);
        vector.add(0, string);
        string = preferences.get("page_title_justification", PrefDefaults.DEF_PAGE_TITLE_JUSTIFICATION);
        vector.add(1, string);
        this.mItemStateMap.put(4, vector);
        vector = new Vector();
        string = preferences.get("pivot_table_contents", PrefDefaults.DEF_PIVOT_TABLE_CONTENTS);
        vector.add(0, string);
        string = preferences.get("pivot_table_justification", PrefDefaults.DEF_PIVOT_TABLE_JUSTIFICATION);
        vector.add(1, string);
        this.mItemStateMap.put(5, vector);
        vector = new Vector();
        string = preferences.get("chart_contents", PrefDefaults.DEF_CHART_CONTENTS);
        vector.add(0, string);
        string = preferences.get("chart_justification", PrefDefaults.DEF_CHART_JUSTIFICATION);
        vector.add(1, string);
        this.mItemStateMap.put(6, vector);
        vector = new Vector();
        string = preferences.get("text_output_contents", PrefDefaults.DEF_TEXT_OUTPUT_CONTENTS);
        vector.add(0, string);
        vector.add(1, "");
        this.mItemStateMap.put(7, vector);
        vector = new Vector();
        string = preferences.get("tree_model_contents", PrefDefaults.DEF_TREE_MODEL_CONTENTS);
        vector.add(0, string);
        string = preferences.get("tree_justification", PrefDefaults.DEF_TREE_JUSTIFICATION);
        vector.add(1, string);
        this.mItemStateMap.put(8, vector);
        vector = new Vector();
        string = preferences.get("model_viewer_contents", PrefDefaults.DEF_MODELVIEWER_CONTENTS);
        vector.add(0, string);
        string = preferences.get("model_justification", PrefDefaults.DEF_MODEL_JUSTIFICATION);
        vector.add(1, string);
        this.mItemStateMap.put(9, vector);
        vector = new Vector();
        string = preferences.get("unknown_contents", PrefDefaults.DEF_UNKNOWN_CONTENTS);
        vector.add(0, string);
        string = preferences.get("unknown_justification", PrefDefaults.DEF_UNKNOWN_JUSTIFICATION);
        vector.add(1, string);
        this.mItemStateMap.put(10, vector);
    }

    private void savePrefsValuesForItems() {
        String string;
        String string2;
        Preferences preferences = this.mOptionsPrefs;
        Vector<String> vector = this.mItemStateMap.get(0);
        if (this.mItemStateChanged.get(0).booleanValue()) {
            string2 = vector.get(0);
            preferences.put("log_contents", string2);
        }
        if (this.mItemStateChanged.get(1).booleanValue()) {
            vector = this.mItemStateMap.get(1);
            string2 = vector.get(0);
            preferences.put("warnings_contents", string2);
            string = vector.get(1);
            preferences.put("warnings_justification", string);
        }
        if (this.mItemStateChanged.get(2).booleanValue()) {
            vector = this.mItemStateMap.get(2);
            string2 = vector.get(0);
            preferences.put("notes_contents", string2);
            string = vector.get(1);
            preferences.put("notes_justification", string);
        }
        if (this.mItemStateChanged.get(3).booleanValue()) {
            vector = this.mItemStateMap.get(3);
            string2 = vector.get(0);
            preferences.put("title_contents", string2);
            string = vector.get(1);
            preferences.put("title_justification", string);
        }
        if (this.mItemStateChanged.get(4).booleanValue()) {
            vector = this.mItemStateMap.get(4);
            string2 = vector.get(0);
            preferences.put("page_title_contents", string2);
            string = vector.get(1);
            preferences.put("page_title_justification", string);
        }
        if (this.mItemStateChanged.get(5).booleanValue()) {
            vector = this.mItemStateMap.get(5);
            string2 = vector.get(0);
            preferences.put("pivot_table_contents", string2);
            string = vector.get(1);
            preferences.put("pivot_table_justification", string);
        }
        if (this.mItemStateChanged.get(6).booleanValue()) {
            vector = this.mItemStateMap.get(6);
            string2 = vector.get(0);
            preferences.put("chart_contents", string2);
            string = vector.get(1);
            preferences.put("chart_justification", string);
        }
        if (this.mItemStateChanged.get(7).booleanValue()) {
            vector = this.mItemStateMap.get(7);
            string2 = vector.get(0);
            preferences.put("text_output_contents", string2);
        }
        if (this.mItemStateChanged.get(8).booleanValue()) {
            vector = this.mItemStateMap.get(8);
            string2 = vector.get(0);
            preferences.put("tree_model_contents", string2);
            string = vector.get(1);
            preferences.put("tree_justification", string);
        }
        if (this.mItemStateChanged.get(9).booleanValue()) {
            vector = this.mItemStateMap.get(9);
            string2 = vector.get(0);
            preferences.put("model_viewer_contents", string2);
            string = vector.get(1);
            preferences.put("model_justification", string);
        }
        if (this.mItemStateChanged.get(10).booleanValue()) {
            vector = this.mItemStateMap.get(10);
            string2 = vector.get(0);
            preferences.put("unknown_contents", string2);
            string = vector.get(1);
            preferences.put("unknown_justification", string);
        }
    }

    private void readPrefsValuesForFonts() {
        Preferences preferences = this.mOptionsPrefs;
        String string = preferences.get("title_font_name", PrefDefaults.DEF_VIEWER_TITLE_FONT_FAMILY);
        this.mTitleFontComboBox.setSelectedItem(string);
        this.mTitleFontState.setFontName(string);
        int n = preferences.getInt("title_font_size", PrefDefaults.DEF_VIEWER_TITLE_FONT_SIZE);
        this.mTitleFontSizesComboBox.setSelectedItem(SpssTextPane.formatLogicalFontSize(FontUtil.physicalToLogicalSize((float)n)));
        this.mTitleFontState.setFontSize(n);
        boolean bl = preferences.getBoolean("title_font_bold", true);
        this.mTitleFontState.setBold(bl);
        this.mFontToolBarPanel.getBoldButton().setSelected(bl);
        bl = preferences.getBoolean("title_font_italic", false);
        this.mTitleFontState.setItalic(bl);
        this.mFontToolBarPanel.getItalicButton().setSelected(bl);
        bl = preferences.getBoolean("title_font_underline", false);
        this.mTitleFontState.setUnderline(bl);
        this.mFontToolBarPanel.getUnderlineButton().setSelected(bl);
        int n2 = preferences.getInt("title_font_color", 0);
        this.mFontToolBarPanel.setColorButtonColor(this.getColor(n2));
        this.mTitleFontState.setColor(n2);
        string = preferences.get("page_title_font_name", PrefDefaults.DEF_VIEWER_PAGE_TITLE_FONT_FAMILY);
        this.mPageTitleFontComboBox.setSelectedItem(string);
        this.mPageTitleFontState.setFontName(string);
        n = preferences.getInt("page_title_font_size", PrefDefaults.DEF_VIEWER_PAGE_TITLE_FONT_SIZE);
        this.mPageTitleFontSizesComboBox.setSelectedItem(SpssTextPane.formatLogicalFontSize(FontUtil.physicalToLogicalSize((float)n)));
        this.mPageTitleFontState.setFontSize(n);
        bl = preferences.getBoolean("page_title_font_bold", false);
        this.mPageTitleFontState.setBold(bl);
        this.mPageFontToolBarPanel.getBoldButton().setSelected(bl);
        bl = preferences.getBoolean("page_title_font_italic", false);
        this.mPageTitleFontState.setItalic(bl);
        this.mPageFontToolBarPanel.getItalicButton().setSelected(bl);
        bl = preferences.getBoolean("page_title_font_underline", false);
        this.mPageTitleFontState.setUnderline(bl);
        this.mPageFontToolBarPanel.getUnderlineButton().setSelected(bl);
        n2 = preferences.getInt("page_title_font_color", 0);
        this.mPageFontToolBarPanel.setColorButtonColor(this.getColor(n2));
        this.mPageTitleFontState.setColor(n2);
    }

    private void savePrefsValuesForFonts() {
        Preferences preferences = this.mOptionsPrefs;
        if (this.mTitleFontState.isFontNameChanged()) {
            preferences.put("title_font_name", this.mTitleFontState.getFontName());
        }
        if (this.mTitleFontState.isFontSizeChanged()) {
            preferences.put("title_font_size", String.valueOf(this.mTitleFontState.getFontSize()));
        }
        if (this.mTitleFontState.isBoldChanged()) {
            preferences.putBoolean("title_font_bold", this.mTitleFontState.isBold());
        }
        if (this.mTitleFontState.isItalicChanged()) {
            preferences.putBoolean("title_font_italic", this.mTitleFontState.isItalic());
        }
        if (this.mTitleFontState.isUnderlineChanged()) {
            preferences.putBoolean("title_font_underline", this.mTitleFontState.isUnderline());
        }
        if (this.mTitleFontState.isColorChanged()) {
            preferences.putInt("title_font_color", this.mTitleFontState.getColor());
        }
        if (this.mPageTitleFontState.isFontNameChanged()) {
            preferences.put("page_title_font_name", this.mPageTitleFontState.getFontName());
        }
        if (this.mPageTitleFontState.isFontSizeChanged()) {
            preferences.put("page_title_font_size", String.valueOf(this.mPageTitleFontState.getFontSize()));
        }
        if (this.mPageTitleFontState.isBoldChanged()) {
            preferences.putBoolean("page_title_font_bold", this.mPageTitleFontState.isBold());
        }
        if (this.mPageTitleFontState.isItalicChanged()) {
            preferences.putBoolean("page_title_font_italic", this.mPageTitleFontState.isItalic());
        }
        if (this.mPageTitleFontState.isUnderlineChanged()) {
            preferences.putBoolean("page_title_font_underline", this.mPageTitleFontState.isUnderline());
        }
        if (this.mPageTitleFontState.isColorChanged()) {
            preferences.putInt("page_title_font_color", this.mPageTitleFontState.getColor());
        }
    }

    private void readPrefsValuesForPageSetup() {
        Preferences preferences = this.mOptionsPrefs;
        int n = preferences.getInt("page_setup_orientation", 1);
        if (n == 1) {
            this.mPortraitRadio.setSelected(true);
        } else {
            this.mLandscapeRadio.setSelected(true);
        }
        boolean bl = PageSetupUtil.getMeasurementUnit().equalsIgnoreCase("inches");
        double d = 1.0;
        if (!bl) {
            d = 25.0;
        }
        double d2 = preferences.getDouble("page_setup_left_margin", d);
        this.mLeftMargin.setText(String.valueOf(d2));
        d2 = preferences.getDouble("page_setup_right_margin", d);
        this.mRightMargin.setText(String.valueOf(d2));
        d2 = preferences.getDouble("page_setup_top_margin", d);
        this.mTopMargin.setText(String.valueOf(d2));
        d2 = preferences.getDouble("page_setup_bottom_margin", d);
        this.mBottomMargin.setText(String.valueOf(d2));
    }

    private void savePrefsValuesForPageSetup() {
        try {
            Preferences preferences = this.mOptionsPrefs;
            if (this.mPortraitRadio.isSelected()) {
                preferences.putInt("page_setup_orientation", 1);
            } else {
                preferences.putInt("page_setup_orientation", 0);
            }
            double d = Double.parseDouble(this.mLeftMargin.getText());
            preferences.putDouble("page_setup_left_margin", d);
            d = Double.parseDouble(this.mRightMargin.getText());
            preferences.putDouble("page_setup_right_margin", d);
            d = Double.parseDouble(this.mTopMargin.getText());
            preferences.putDouble("page_setup_top_margin", d);
            d = Double.parseDouble(this.mBottomMargin.getText());
            preferences.putDouble("page_setup_bottom_margin", d);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void loadItemState() {
        int n = this.mItemNamesComboBox.getSelectedIndex();
        Vector<String> vector = this.mItemStateMap.get(n);
        switch (n) {
            case 0: {
                String string = vector.get(0);
                int n2 = DialogUtil.getIndexOfItem(IOptionConstants.VIEWER_CONTENTS_VALUES, string);
                DialogUtil.setSelectedButton(this.mContentsRadioButtonGroup, n2);
                this.enableJustificationButtons(false);
                break;
            }
            case 1: {
                String string = vector.get(0);
                int n3 = DialogUtil.getIndexOfItem(IOptionConstants.VIEWER_CONTENTS_VALUES, string);
                DialogUtil.setSelectedButton(this.mContentsRadioButtonGroup, n3);
                this.enableJustificationButtons(true);
                string = vector.get(1);
                n3 = DialogUtil.getIndexOfItem(IOptionConstants.VIEWER_JUSTIFICATION_VALUES, string);
                DialogUtil.setSelectedButton(this.mJustificationButtonGroup, n3);
                break;
            }
            case 2: {
                String string = vector.get(0);
                int n4 = DialogUtil.getIndexOfItem(IOptionConstants.VIEWER_CONTENTS_VALUES, string);
                DialogUtil.setSelectedButton(this.mContentsRadioButtonGroup, n4);
                this.enableJustificationButtons(true);
                string = vector.get(1);
                n4 = DialogUtil.getIndexOfItem(IOptionConstants.VIEWER_JUSTIFICATION_VALUES, string);
                DialogUtil.setSelectedButton(this.mJustificationButtonGroup, n4);
                break;
            }
            case 3: {
                String string = vector.get(0);
                int n5 = DialogUtil.getIndexOfItem(IOptionConstants.VIEWER_CONTENTS_VALUES, string);
                DialogUtil.setSelectedButton(this.mContentsRadioButtonGroup, n5);
                this.enableJustificationButtons(true);
                string = vector.get(1);
                n5 = DialogUtil.getIndexOfItem(IOptionConstants.VIEWER_JUSTIFICATION_VALUES, string);
                DialogUtil.setSelectedButton(this.mJustificationButtonGroup, n5);
                break;
            }
            case 4: {
                String string = vector.get(0);
                int n6 = DialogUtil.getIndexOfItem(IOptionConstants.VIEWER_CONTENTS_VALUES, string);
                DialogUtil.setSelectedButton(this.mContentsRadioButtonGroup, n6);
                this.enableJustificationButtons(true);
                string = vector.get(1);
                n6 = DialogUtil.getIndexOfItem(IOptionConstants.VIEWER_JUSTIFICATION_VALUES, string);
                DialogUtil.setSelectedButton(this.mJustificationButtonGroup, n6);
                break;
            }
            case 5: {
                String string = vector.get(0);
                int n7 = DialogUtil.getIndexOfItem(IOptionConstants.VIEWER_CONTENTS_VALUES, string);
                DialogUtil.setSelectedButton(this.mContentsRadioButtonGroup, n7);
                this.enableJustificationButtons(true);
                string = vector.get(1);
                n7 = DialogUtil.getIndexOfItem(IOptionConstants.VIEWER_JUSTIFICATION_VALUES, string);
                DialogUtil.setSelectedButton(this.mJustificationButtonGroup, n7);
                break;
            }
            case 6: {
                String string = vector.get(0);
                int n8 = DialogUtil.getIndexOfItem(IOptionConstants.VIEWER_CONTENTS_VALUES, string);
                DialogUtil.setSelectedButton(this.mContentsRadioButtonGroup, n8);
                this.enableJustificationButtons(true);
                string = vector.get(1);
                n8 = DialogUtil.getIndexOfItem(IOptionConstants.VIEWER_JUSTIFICATION_VALUES, string);
                DialogUtil.setSelectedButton(this.mJustificationButtonGroup, n8);
                break;
            }
            case 7: {
                String string = vector.get(0);
                int n9 = DialogUtil.getIndexOfItem(IOptionConstants.VIEWER_CONTENTS_VALUES, string);
                DialogUtil.setSelectedButton(this.mContentsRadioButtonGroup, n9);
                this.enableJustificationButtons(false);
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                String string = vector.get(0);
                int n10 = DialogUtil.getIndexOfItem(IOptionConstants.VIEWER_CONTENTS_VALUES, string);
                DialogUtil.setSelectedButton(this.mContentsRadioButtonGroup, n10);
                this.enableJustificationButtons(true);
                string = vector.get(1);
                n10 = DialogUtil.getIndexOfItem(IOptionConstants.VIEWER_JUSTIFICATION_VALUES, string);
                DialogUtil.setSelectedButton(this.mJustificationButtonGroup, n10);
            }
        }
    }

    private void saveItemState() {
        int n = this.mItemNamesComboBox.getSelectedIndex();
        ImageIcon imageIcon = null;
        Vector<String> vector = this.mItemStateMap.get(n);
        String string = this.mShownRadio.isSelected() ? IOptionConstants.VIEWER_CONTENTS_VALUES[0] : IOptionConstants.VIEWER_CONTENTS_VALUES[1];
        String string2 = this.mAlignLeftRadio.isSelected() ? IOptionConstants.VIEWER_JUSTIFICATION_VALUES[0] : (this.mCenterAlignRadio.isSelected() ? IOptionConstants.VIEWER_JUSTIFICATION_VALUES[1] : IOptionConstants.VIEWER_JUSTIFICATION_VALUES[2]);
        switch (n) {
            case 0: {
                if (!vector.get(0).equals(string)) {
                    vector.set(0, string);
                    this.mItemStateChanged.put(0, true);
                }
                imageIcon = this.mShownRadio.isSelected() ? this.mLogShownImage : this.mLogHiddenImage;
                break;
            }
            case 1: {
                if (!vector.get(0).equals(string)) {
                    vector.set(0, string);
                    this.mItemStateChanged.put(1, true);
                }
                if (!vector.get(1).equals(string2)) {
                    vector.set(1, string2);
                    this.mItemStateChanged.put(1, true);
                }
                imageIcon = this.mShownRadio.isSelected() ? this.mWarningsShownImage : this.mWarningsHiddenImage;
                break;
            }
            case 2: {
                if (!vector.get(0).equals(string)) {
                    vector.set(0, string);
                    this.mItemStateChanged.put(2, true);
                }
                if (!vector.get(1).equals(string2)) {
                    vector.set(1, string2);
                    this.mItemStateChanged.put(2, true);
                }
                imageIcon = this.mShownRadio.isSelected() ? this.mNotesShownImage : this.mNotesHiddenImage;
                break;
            }
            case 3: {
                if (!vector.get(0).equals(string)) {
                    vector.set(0, string);
                    this.mItemStateChanged.put(3, true);
                }
                if (!vector.get(1).equals(string2)) {
                    vector.set(1, string2);
                    this.mItemStateChanged.put(3, true);
                }
                imageIcon = this.mShownRadio.isSelected() ? this.mTitleShownImage : this.mTitleHiddenImage;
                break;
            }
            case 4: {
                if (!vector.get(0).equals(string)) {
                    vector.set(0, string);
                    this.mItemStateChanged.put(4, true);
                }
                if (!vector.get(1).equals(string2)) {
                    vector.set(1, string2);
                    this.mItemStateChanged.put(4, true);
                }
                imageIcon = this.mShownRadio.isSelected() ? this.mPageTitleShownImage : this.mPageTitleHiddenImage;
                break;
            }
            case 5: {
                if (!vector.get(0).equals(string)) {
                    vector.set(0, string);
                    this.mItemStateChanged.put(5, true);
                }
                if (!vector.get(1).equals(string2)) {
                    vector.set(1, string2);
                    this.mItemStateChanged.put(5, true);
                }
                imageIcon = this.mShownRadio.isSelected() ? this.mPivotTableShownImage : this.mPivotTableHiddenImage;
                break;
            }
            case 6: {
                if (!vector.get(0).equals(string)) {
                    vector.set(0, string);
                    this.mItemStateChanged.put(6, true);
                }
                if (!vector.get(1).equals(string2)) {
                    vector.set(1, string2);
                    this.mItemStateChanged.put(6, true);
                }
                imageIcon = this.mShownRadio.isSelected() ? this.mChartShownImage : this.mChartHiddenImage;
                break;
            }
            case 7: {
                if (!vector.get(0).equals(string)) {
                    vector.set(0, string);
                    this.mItemStateChanged.put(7, true);
                }
                imageIcon = this.mShownRadio.isSelected() ? this.mTextOutputShownImage : this.mTextOutputHiddenImage;
                break;
            }
            case 8: {
                if (!vector.get(0).equals(string)) {
                    vector.set(0, string);
                    this.mItemStateChanged.put(8, true);
                }
                if (!vector.get(1).equals(string2)) {
                    vector.set(1, string2);
                    this.mItemStateChanged.put(8, true);
                }
                imageIcon = this.mShownRadio.isSelected() ? this.mTreeModelShownImage : this.mTreeModelHiddenImage;
                break;
            }
            case 9: {
                if (!vector.get(0).equals(string)) {
                    vector.set(0, string);
                    this.mItemStateChanged.put(9, true);
                }
                if (!vector.get(1).equals(string2)) {
                    vector.set(1, string2);
                    this.mItemStateChanged.put(9, true);
                }
                imageIcon = this.mShownRadio.isSelected() ? this.mModelShownImage : this.mModelHiddenImage;
                break;
            }
            case 10: {
                if (!vector.get(0).equals(string)) {
                    vector.set(0, string);
                    this.mItemStateChanged.put(10, true);
                }
                if (!vector.get(1).equals(string2)) {
                    vector.set(1, string2);
                    this.mItemStateChanged.put(10, true);
                }
                imageIcon = this.mShownRadio.isSelected() ? this.mUnknownShownImage : this.mUnknownHiddenImage;
            }
        }
        this.mItemStateMap.put(n, vector);
        JLabel jLabel = (JLabel)((DefaultListModel)this.mItemImagesList.getModel()).getElementAt(n);
        jLabel.setIcon(imageIcon);
        ((DefaultListModel)this.mItemImagesList.getModel()).setElementAt(jLabel, n);
    }

    private void loadImageList(int n) {
        ImageIcon imageIcon = null;
        Vector<String> vector = this.mItemStateMap.get(n);
        String string = vector.get(0);
        int n2 = DialogUtil.getIndexOfItem(IOptionConstants.VIEWER_CONTENTS_VALUES, string);
        switch (n) {
            case 0: {
                imageIcon = n2 == 0 ? this.mLogShownImage : this.mLogHiddenImage;
                break;
            }
            case 1: {
                imageIcon = n2 == 0 ? this.mWarningsShownImage : this.mWarningsHiddenImage;
                break;
            }
            case 2: {
                imageIcon = n2 == 0 ? this.mNotesShownImage : this.mNotesHiddenImage;
                break;
            }
            case 3: {
                imageIcon = n2 == 0 ? this.mTitleShownImage : this.mTitleHiddenImage;
                break;
            }
            case 4: {
                imageIcon = n2 == 0 ? this.mPageTitleShownImage : this.mPageTitleHiddenImage;
                break;
            }
            case 5: {
                imageIcon = n2 == 0 ? this.mPivotTableShownImage : this.mPivotTableHiddenImage;
                break;
            }
            case 6: {
                imageIcon = n2 == 0 ? this.mChartShownImage : this.mChartHiddenImage;
                break;
            }
            case 7: {
                imageIcon = n2 == 0 ? this.mTextOutputShownImage : this.mTextOutputHiddenImage;
                break;
            }
            case 8: {
                imageIcon = n2 == 0 ? this.mTreeModelShownImage : this.mTreeModelHiddenImage;
                break;
            }
            case 9: {
                imageIcon = n2 == 0 ? this.mModelShownImage : this.mModelHiddenImage;
                break;
            }
            case 10: {
                imageIcon = n2 == 0 ? this.mUnknownShownImage : this.mUnknownHiddenImage;
            }
        }
        JLabel jLabel = (JLabel)((DefaultListModel)this.mItemImagesList.getModel()).getElementAt(n);
        jLabel.setIcon(imageIcon);
        ((DefaultListModel)this.mItemImagesList.getModel()).setElementAt(jLabel, n);
    }

    private void saveTitleFontState() {
        Color color;
        int n;
        String string;
        if (!this.mTitleFontState.getFontName().equals(this.mTitleFontComboBox.getSelectedItem())) {
            this.mTitleFontState.setFontName((String)this.mTitleFontComboBox.getSelectedItem());
            this.mTitleFontState.setFontNameChanged(true);
        }
        if (!(string = (String)this.mTitleFontSizesComboBox.getSelectedItem()).equals("") && (n = this.convertFontSizeToPhysical(string)) > 0 && this.mTitleFontState.getFontSize() != n) {
            this.mTitleFontState.setFontSize(n);
            this.mTitleFontState.setFontSizeChanged(true);
        }
        if (this.mTitleFontState.isBold() != this.mFontToolBarPanel.getBoldButton().isSelected()) {
            this.mTitleFontState.setBold(this.mFontToolBarPanel.getBoldButton().isSelected());
            this.mTitleFontState.setBoldChanged(true);
        }
        if (this.mTitleFontState.isItalic() != this.mFontToolBarPanel.getItalicButton().isSelected()) {
            this.mTitleFontState.setItalic(this.mFontToolBarPanel.getItalicButton().isSelected());
            this.mTitleFontState.setItalicChanged(true);
        }
        if (this.mTitleFontState.isUnderline() != this.mFontToolBarPanel.getUnderlineButton().isSelected()) {
            this.mTitleFontState.setUnderline(this.mFontToolBarPanel.getUnderlineButton().isSelected());
            this.mTitleFontState.setUnderlineChanged(true);
        }
        if ((color = this.mFontToolBarPanel.getColorButton().getUserSelectedColor()) != null) {
            int n2 = color.getRGB();
            if (this.mTitleFontState.getColor() != (n2 &= 0xFFFFFF)) {
                this.mTitleFontState.setColor(n2);
                this.mTitleFontState.setColorChanged(true);
            }
        }
    }

    private int convertFontSizeToPhysical(String string) {
        NumberFormat numberFormat = NumberFormat.getNumberInstance(ComponentState.getSPSSLocale());
        float f = 0.0f;
        try {
            f = numberFormat.parse(string).floatValue();
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
        }
        return (int)FontUtil.logicalToPhysicalSize((float)f);
    }

    private void savePageTitleFontState() {
        Color color;
        int n;
        String string;
        if (!this.mPageTitleFontState.getFontName().equals(this.mPageTitleFontComboBox.getSelectedItem())) {
            this.mPageTitleFontState.setFontName((String)this.mPageTitleFontComboBox.getSelectedItem());
            this.mPageTitleFontState.setFontNameChanged(true);
        }
        if (!(string = (String)this.mPageTitleFontSizesComboBox.getSelectedItem()).equals("") && (n = this.convertFontSizeToPhysical(string)) > 0 && this.mPageTitleFontState.getFontSize() != n) {
            this.mPageTitleFontState.setFontSize(n);
            this.mPageTitleFontState.setFontSizeChanged(true);
        }
        if (this.mPageTitleFontState.isBold() != this.mPageFontToolBarPanel.getBoldButton().isSelected()) {
            this.mPageTitleFontState.setBold(this.mPageFontToolBarPanel.getBoldButton().isSelected());
            this.mPageTitleFontState.setBoldChanged(true);
        }
        if (this.mPageTitleFontState.isItalic() != this.mPageFontToolBarPanel.getItalicButton().isSelected()) {
            this.mPageTitleFontState.setItalic(this.mPageFontToolBarPanel.getItalicButton().isSelected());
            this.mPageTitleFontState.setItalicChanged(true);
        }
        if (this.mPageTitleFontState.isUnderline() != this.mPageFontToolBarPanel.getUnderlineButton().isSelected()) {
            this.mPageTitleFontState.setUnderline(this.mPageFontToolBarPanel.getUnderlineButton().isSelected());
            this.mPageTitleFontState.setUnderlineChanged(true);
        }
        if ((color = this.mPageFontToolBarPanel.getColorButton().getUserSelectedColor()) != null) {
            int n2 = color.getRGB();
            if (this.mPageTitleFontState.getColor() != (n2 &= 0xFFFFFF)) {
                this.mPageTitleFontState.setColor(n2);
                this.mPageTitleFontState.setColorChanged(true);
            }
        }
    }

    private void saveOutputFontState() {
        int n;
        String string;
        if (!this.mOutputFontState.getFontName().equals(this.mOutputFontComboBox.getSelectedItem())) {
            this.mOutputFontState.setFontName((String)this.mOutputFontComboBox.getSelectedItem());
            this.mOutputFontState.setFontNameChanged(true);
        }
        if (!(string = (String)this.mOutputFontSizeComboBox.getSelectedItem()).equals("") && (n = this.convertFontSizeToPhysical(string)) > 0 && this.mOutputFontState.getFontSize() != n) {
            this.mOutputFontState.setFontSize(n);
            this.mOutputFontState.setFontSizeChanged(true);
        }
        if (this.mOutputFontState.isBold() != this.mOutputFontToolBarPanel.getBoldButton().isSelected()) {
            this.mOutputFontState.setBold(this.mOutputFontToolBarPanel.getBoldButton().isSelected());
            this.mOutputFontState.setBoldChanged(true);
        }
        if (this.mOutputFontState.isItalic() != this.mOutputFontToolBarPanel.getItalicButton().isSelected()) {
            this.mOutputFontState.setItalic(this.mOutputFontToolBarPanel.getItalicButton().isSelected());
            this.mOutputFontState.setItalicChanged(true);
        }
        if (this.mOutputFontState.isUnderline() != this.mOutputFontToolBarPanel.getUnderlineButton().isSelected()) {
            this.mOutputFontState.setUnderline(this.mOutputFontToolBarPanel.getUnderlineButton().isSelected());
            this.mOutputFontState.setUnderlineChanged(true);
        }
        Color color = this.mOutputFontToolBarPanel.getColorButtonColor();
        int n2 = color.getRGB();
        if (this.mOutputFontState.getColor() != (n2 &= 0xFFFFFF)) {
            this.mOutputFontState.setColor(n2);
            this.mOutputFontState.setColorChanged(true);
        }
    }

    private void addComponents() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n = 23;
        JPanel jPanel = this.setupInitialOutputStatePanel();
        Insets insets = new Insets(DialogUtil.getComponentGroupGap(), 0, 0, 0);
        OptionsUtil.addUsingGBL(this, jPanel, gridBagConstraints, 0, 0, 1, 4, n, insets);
        JPanel jPanel2 = this.setupTitleFontPanel();
        insets.set(DialogUtil.getComponentGroupGap(), DialogUtil.getComponentGroupGap(), 0, 0);
        OptionsUtil.addUsingGBL(this, jPanel2, gridBagConstraints, 1, 0, 1, 1, n, insets);
        JPanel jPanel3 = this.setupPageTitleFontPanel();
        insets.set(DialogUtil.getComponentGroupGap(), DialogUtil.getComponentGroupGap(), 0, 0);
        OptionsUtil.addUsingGBL(this, jPanel3, gridBagConstraints, 1, 1, 1, 1, n, insets);
        JPanel jPanel4 = this.setupTextOutputFontPanel();
        insets.set(DialogUtil.getComponentGroupGap(), DialogUtil.getComponentGroupGap(), 0, 0);
        OptionsUtil.addUsingGBL(this, jPanel4, gridBagConstraints, 1, 2, 1, 1, n, insets);
        JPanel jPanel5 = this.setupPageSetupPanel();
        insets.set(DialogUtil.getComponentGroupGap(), DialogUtil.getComponentGroupGap(), 0, 0);
        OptionsUtil.addUsingGBL(this, jPanel5, gridBagConstraints, 1, 3, 1, 1, n, insets);
    }

    private JPanel setupInitialOutputStatePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.mOptionDialog.getResString("IDS_VIEWER_INITIAL_OUTPUT_STATE_PANEL_TITLE")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 3;
        int n = 23;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        Insets insets = new Insets(0, DialogUtil.getGroupBoxInnerMargin(), 0, 0);
        JLabel jLabel = DialogUtil.createLabel(this.mOptionDialog, "IDS_VIEWER_ITEM_ICON_LABEL");
        OptionsUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        insets.set(DialogUtil.getGroupBoxInnerMargin(), DialogUtil.getGroupBoxInnerMargin(), 0, DialogUtil.getGroupBoxInnerMargin());
        JScrollPane jScrollPane = new JScrollPane(this.mItemImagesList);
        jScrollPane.setPreferredSize(this.mItemImagesList.getMinimumSize());
        OptionsUtil.addUsingGBL(jPanel, jScrollPane, gridBagConstraints, 0, 1, 1, 6, n, insets);
        jLabel.setLabelFor(this.mItemImagesList);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        OptionsUtil.addUsingGBL(jPanel, this.mItemLabel, gridBagConstraints, 1, 1, 1, 1, n, null);
        insets.set(0, 0, 0, DialogUtil.getGroupBoxInnerMargin());
        OptionsUtil.addUsingGBL(jPanel, this.mItemNamesComboBox, gridBagConstraints, 1, 2, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        insets.set(DialogUtil.getComponentGroupGap() * 3, 0, 0, 0);
        gridBagConstraints.fill = 0;
        OptionsUtil.addUsingGBL(jPanel, this.mContentsLabel, gridBagConstraints, 1, 3, 1, 1, n, insets);
        JComponent[] jComponentArray = new JComponent[]{this.mShownRadio, this.mHiddenRadio};
        JPanel jPanel2 = PanelFactory.getBasicPanel(jComponentArray, PanelFactory.PanelType.yaxis, null, true);
        this.mContentsLabel.setLabelFor(jPanel2);
        this.mContentsRadioButtonGroup = DialogUtil.createButtonGroup(jPanel2);
        OptionsUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 1, 4, 1, 1, n, null);
        insets.set(DialogUtil.getComponentGroupGap() * 2, 0, 0, 0);
        OptionsUtil.addUsingGBL(jPanel, this.mJustificationLabel, gridBagConstraints, 1, 5, 1, 1, n, insets);
        jComponentArray = new JComponent[]{this.mAlignLeftRadio, this.mCenterAlignRadio, this.mAlignRightRadio};
        JPanel jPanel3 = PanelFactory.getBasicPanel(jComponentArray, PanelFactory.PanelType.yaxis, null, true);
        this.mJustificationLabel.setLabelFor(jPanel3);
        this.mJustificationButtonGroup = DialogUtil.createButtonGroup(jPanel3);
        OptionsUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 1, 6, 1, 1, n, null);
        if (this.mDisplayCommandsCheckBox != null) {
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 0;
            insets.set(DialogUtil.getGroupBoxInnerMargin(), DialogUtil.getGroupBoxInnerMargin(), 0, 0);
            OptionsUtil.addUsingGBL(jPanel, this.mDisplayCommandsCheckBox, gridBagConstraints, 0, 8, 2, 1, n, insets);
        }
        return jPanel;
    }

    private JPanel setupPageSetupPanel() {
        JPanel jPanel = PanelFactory.getEmptyPanel(this.mOptionDialog.getResString("IDS_VIEWER_PAGE_SETUP_PANEL_TITLE"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 2;
        int n = 23;
        Insets insets = new Insets(2, 0, DialogUtil.getGroupBoxInnerMargin(), 0);
        JPanel jPanel2 = PanelFactory.getEmptyPanel(this.mOptionDialog.getResString("IDS_VIEWER_PAGE_SETUP_ORIENTATION_PANEL_TITLE"));
        gridBagConstraints.fill = 0;
        gridBagConstraints.weighty = 0.0;
        OptionsUtil.addUsingGBL(jPanel2, this.mPortraitRadio, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        OptionsUtil.addUsingGBL(jPanel2, this.mLandscapeRadio, gridBagConstraints, 0, 1, 1, 1, n, insets);
        String string = this.mOptionDialog.getResString("IDS_VIEWER_PAGE_SETUP_MARGINS_PANEL_TITLE");
        string = string + "(" + PageSetupUtil.getMeasurementUnit() + ")";
        JPanel jPanel3 = PanelFactory.getEmptyPanel(string);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        insets.set(2, 4, 2, 1);
        OptionsUtil.addUsingGBL(jPanel3, this.mLeftMarginLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        insets.set(2, 1, 2, 8);
        OptionsUtil.addUsingGBL(jPanel3, (JComponent)this.mLeftMargin, gridBagConstraints, 1, 0, 1, 1, n, insets);
        insets.set(2, 8, 2, 1);
        OptionsUtil.addUsingGBL(jPanel3, this.mRightMarginLabel, gridBagConstraints, 2, 0, 1, 1, n, insets);
        insets.set(2, 1, 2, 2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        OptionsUtil.addUsingGBL(jPanel3, (JComponent)this.mRightMargin, gridBagConstraints, 3, 0, 1, 1, n, insets);
        insets.set(2, 4, 2, 1);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        OptionsUtil.addUsingGBL(jPanel3, this.mTopMarginLabel, gridBagConstraints, 0, 1, 1, 1, n, insets);
        insets.set(2, 1, 2, 8);
        OptionsUtil.addUsingGBL(jPanel3, (JComponent)this.mTopMargin, gridBagConstraints, 1, 1, 1, 1, n, insets);
        insets.set(2, 8, 2, 1);
        OptionsUtil.addUsingGBL(jPanel3, this.mBottomMarginLabel, gridBagConstraints, 2, 1, 1, 1, n, insets);
        insets.set(2, 1, 2, 2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        OptionsUtil.addUsingGBL(jPanel3, (JComponent)this.mBottomMargin, gridBagConstraints, 3, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        insets.set(2, 4, 8, 8);
        OptionsUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        insets.set(2, 8, 6, 8);
        OptionsUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 1, 0, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel setupTitleFontPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.mOptionDialog.getResString("IDS_VIEWER_FONT_TYPES_TITLE")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 2;
        int n = 23;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        Insets insets = new Insets(DialogUtil.getGroupBoxInnerMargin(), DialogUtil.getGroupBoxInnerMargin(), 0, 0);
        JLabel jLabel = DialogUtil.createLabel(this.mOptionDialog, "IDS_VIEWER_FONT_LABEL");
        OptionsUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        insets.set(0, DialogUtil.getGroupBoxInnerMargin(), 0, 0);
        OptionsUtil.addUsingGBL(jPanel, this.mTitleFontComboBox, gridBagConstraints, 0, 1, 1, 1, n, insets);
        jLabel.setLabelFor(this.mTitleFontComboBox);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        JLabel jLabel2 = DialogUtil.createLabel(this.mOptionDialog, "IDS_VIEWER_SIZE_LABEL");
        insets.set(DialogUtil.getGroupBoxInnerMargin(), DialogUtil.getGroupBoxInnerMargin(), 0, 0);
        OptionsUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        insets.set(0, DialogUtil.getGroupBoxInnerMargin(), 0, 0);
        OptionsUtil.addUsingGBL(jPanel, this.mTitleFontSizesComboBox, gridBagConstraints, 1, 1, 1, 1, n, insets);
        jLabel2.setLabelFor(this.mTitleFontSizesComboBox);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 0;
        this.mFontToolBarPanel = new ToolBarPanel(this.mOptionDialog, this);
        AccessibilityUtil.setAccessibleText((Component)this.mFontToolBarPanel, (Object)this.mOptionDialog.getResString("IDS_VIEWER_FONT_TYPES_TITLE"));
        this.mFontToolBarPanel.setupToolBar();
        OptionsUtil.addUsingGBL(jPanel, this.mFontToolBarPanel, gridBagConstraints, 2, 1, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel setupPageTitleFontPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.mOptionDialog.getResString("IDS_VIEWER_FONT_TYPES_PAGE_TITLE")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 2;
        int n = 23;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        Insets insets = new Insets(DialogUtil.getGroupBoxInnerMargin(), DialogUtil.getGroupBoxInnerMargin(), 0, 0);
        JLabel jLabel = DialogUtil.createLabel(this.mOptionDialog, "IDS_VIEWER_FONT_LABEL");
        if (OSInfo.getOSType() != OSInfo.OSType.MAC) {
            jLabel.setDisplayedMnemonic(this.mOptionDialog.getDlgAccessKey("IDK_VIEWER_PAGE_TITLE_FONT_LABEL_KEY"));
        }
        OptionsUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        insets.set(0, DialogUtil.getGroupBoxInnerMargin(), 0, 0);
        OptionsUtil.addUsingGBL(jPanel, this.mPageTitleFontComboBox, gridBagConstraints, 0, 1, 1, 1, n, insets);
        jLabel.setLabelFor(this.mPageTitleFontComboBox);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        JLabel jLabel2 = DialogUtil.createLabel(this.mOptionDialog, "IDS_VIEWER_SIZE_LABEL");
        if (OSInfo.getOSType() != OSInfo.OSType.MAC) {
            jLabel2.setDisplayedMnemonic(this.mOptionDialog.getDlgAccessKey("IDK_VIEWER_PAGE_TITLE_SIZE_LABEL_KEY"));
        }
        insets.set(DialogUtil.getGroupBoxInnerMargin(), DialogUtil.getGroupBoxInnerMargin(), 0, 0);
        OptionsUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        insets.set(0, DialogUtil.getGroupBoxInnerMargin(), 0, 0);
        OptionsUtil.addUsingGBL(jPanel, this.mPageTitleFontSizesComboBox, gridBagConstraints, 1, 1, 1, 1, n, insets);
        jLabel2.setLabelFor(this.mPageTitleFontSizesComboBox);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 0;
        this.mPageFontToolBarPanel = new ToolBarPanel(this.mOptionDialog, this);
        AccessibilityUtil.setAccessibleText((Component)this.mPageFontToolBarPanel, (Object)this.mOptionDialog.getResString("IDS_VIEWER_FONT_TYPES_PAGE_TITLE"));
        this.mPageFontToolBarPanel.setupToolBar();
        OptionsUtil.addUsingGBL(jPanel, this.mPageFontToolBarPanel, gridBagConstraints, 2, 1, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel setupTextOutputFontPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.mOptionDialog.getResString("IDS_VIEWER_TEXT_OUTPUT_FONT_PANEL_TITLE")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 2;
        int n = 23;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        Insets insets = new Insets(DialogUtil.getGroupBoxInnerMargin(), DialogUtil.getGroupBoxInnerMargin(), 0, 0);
        JLabel jLabel = DialogUtil.createLabel(this.mOptionDialog, "IDS_VIEWER_FONT_LABEL");
        if (OSInfo.getOSType() != OSInfo.OSType.MAC) {
            jLabel.setDisplayedMnemonic(this.mOptionDialog.getDlgAccessKey("IDK_VIEWER_TEXT_OUTPUT_FONT_LABEL_KEY"));
        }
        OptionsUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        insets.set(0, DialogUtil.getGroupBoxInnerMargin(), 0, 0);
        OptionsUtil.addUsingGBL(jPanel, this.mOutputFontComboBox, gridBagConstraints, 0, 1, 1, 1, n, insets);
        jLabel.setLabelFor(this.mOutputFontComboBox);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        JLabel jLabel2 = DialogUtil.createLabel(this.mOptionDialog, "IDS_VIEWER_SIZE_LABEL");
        if (OSInfo.getOSType() != OSInfo.OSType.MAC) {
            jLabel2.setDisplayedMnemonic(this.mOptionDialog.getDlgAccessKey("IDK_VIEWER_TEXT_OUTPUT_SIZE_LABEL_KEY"));
        }
        insets.set(DialogUtil.getGroupBoxInnerMargin(), DialogUtil.getGroupBoxInnerMargin(), 0, 0);
        OptionsUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        insets.set(0, DialogUtil.getGroupBoxInnerMargin(), 0, 0);
        OptionsUtil.addUsingGBL(jPanel, this.mOutputFontSizeComboBox, gridBagConstraints, 1, 1, 1, 1, n, insets);
        jLabel2.setLabelFor(this.mOutputFontSizeComboBox);
        this.mOutputFontToolBarPanel = new ToolBarPanel(this.mOptionDialog, this);
        AccessibilityUtil.setAccessibleText((Component)this.mOutputFontToolBarPanel, (Object)this.mOptionDialog.getResString("IDS_VIEWER_TEXT_OUTPUT_FONT_PANEL_TITLE"));
        this.mOutputFontToolBarPanel.setupToolBar();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        OptionsUtil.addUsingGBL(jPanel, this.mOutputFontToolBarPanel, gridBagConstraints, 2, 1, 1, 1, n, insets);
        return jPanel;
    }

    private void rotatingPageMargin(JRadioButton jRadioButton) {
        String string = this.mLeftMargin.getText();
        String string2 = this.mRightMargin.getText();
        String string3 = this.mTopMargin.getText();
        String string4 = this.mBottomMargin.getText();
        if (jRadioButton == this.mPortraitRadio && this.mPortraitRadio.isSelected()) {
            this.mLeftMargin.setText(string3);
            this.mRightMargin.setText(string4);
            this.mTopMargin.setText(string2);
            this.mBottomMargin.setText(string);
        } else if (jRadioButton == this.mLandscapeRadio && this.mLandscapeRadio.isSelected()) {
            this.mLeftMargin.setText(string4);
            this.mRightMargin.setText(string3);
            this.mTopMargin.setText(string);
            this.mBottomMargin.setText(string2);
        }
    }

    private void setTabTraversal() {
        this.mComponentOrder.add(this.mItemImagesList);
        this.mComponentOrder.add(this.mItemNamesComboBox);
        this.mComponentOrder.add(this.mContentsRadioButtonGroup);
        this.mComponentOrder.add(this.mJustificationButtonGroup);
        if (this.mDisplayCommandsCheckBox != null) {
            this.mComponentOrder.add(this.mDisplayCommandsCheckBox);
        }
        this.mComponentOrder.add(this.mTitleFontComboBox);
        this.mComponentOrder.add(this.mTitleFontSizesComboBox);
        this.mComponentOrder.add(this.mFontToolBarPanel.getBoldButton());
        this.mComponentOrder.add(this.mFontToolBarPanel.getItalicButton());
        this.mComponentOrder.add(this.mFontToolBarPanel.getUnderlineButton());
        this.mComponentOrder.add(this.mFontToolBarPanel.getColorButton());
        this.mComponentOrder.add(this.mPageTitleFontComboBox);
        this.mComponentOrder.add(this.mPageTitleFontSizesComboBox);
        this.mComponentOrder.add(this.mPageFontToolBarPanel.getBoldButton());
        this.mComponentOrder.add(this.mPageFontToolBarPanel.getItalicButton());
        this.mComponentOrder.add(this.mPageFontToolBarPanel.getUnderlineButton());
        this.mComponentOrder.add(this.mPageFontToolBarPanel.getColorButton());
        this.mComponentOrder.add(this.mOutputFontComboBox);
        this.mComponentOrder.add(this.mOutputFontSizeComboBox);
        this.mComponentOrder.add(this.mOutputFontToolBarPanel.getBoldButton());
        this.mComponentOrder.add(this.mOutputFontToolBarPanel.getItalicButton());
        this.mComponentOrder.add(this.mOutputFontToolBarPanel.getUnderlineButton());
        this.mComponentOrder.add(this.mOutputFontToolBarPanel.getColorButton());
        this.mComponentOrder.add(this.mPortraitRadio);
        this.mComponentOrder.add(this.mLandscapeRadio);
        this.mComponentOrder.add(this.mLeftMargin);
        this.mComponentOrder.add(this.mRightMargin);
        this.mComponentOrder.add(this.mTopMargin);
        this.mComponentOrder.add(this.mBottomMargin);
        for (Component component : this.mOptionDialog.getCmdButtonPanel().getComponents()) {
            this.mComponentOrder.add(component);
        }
    }

    private Color getColor(int n) {
        Color color;
        if (n > 0) {
            int n2;
            String string = Integer.toHexString(n);
            int n3 = 6 - string.length();
            for (n2 = 0; n2 < n3; ++n2) {
                string = "0" + string;
            }
            n2 = Integer.parseInt(string.substring(0, 2), 16);
            int n4 = Integer.parseInt(string.substring(2, 4), 16);
            int n5 = Integer.parseInt(string.substring(4, 6), 16);
            color = new Color(n2, n4, n5);
        } else {
            color = new Color(0, 0, 0);
        }
        return color;
    }

    private void enableJustificationButtons(boolean bl) {
        this.mAlignLeftRadio.setEnabled(bl);
        this.mCenterAlignRadio.setEnabled(bl);
        this.mAlignRightRadio.setEnabled(bl);
    }

    static {
        float[] fArray = SpssTextPane.getLogicalFontSizes();
        sFontSizes = new String[fArray.length];
        for (int i = 0; i < fArray.length; ++i) {
            ViewerOptionPanel.sFontSizes[i] = SpssTextPane.formatLogicalFontSize(fArray[i]);
        }
    }

    private class FontState {
        private String mFontName;
        private int mFontSize;
        private boolean mBold;
        private boolean mItalic;
        private boolean mUnderline;
        private int mColor;
        private boolean mFontNameChanged = false;
        private boolean mFontSizeChanged = false;
        private boolean mBoldChanged = false;
        private boolean mItalicChanged = false;
        private boolean mUnderlineChanged = false;
        private boolean mColorChanged = false;

        private FontState() {
        }

        String getFontName() {
            return this.mFontName;
        }

        void setFontName(String string) {
            this.mFontName = string;
        }

        boolean isFontNameChanged() {
            return this.mFontNameChanged;
        }

        void setFontNameChanged(boolean bl) {
            this.mFontNameChanged = bl;
        }

        int getFontSize() {
            return this.mFontSize;
        }

        void setFontSize(int n) {
            this.mFontSize = n;
        }

        boolean isFontSizeChanged() {
            return this.mFontSizeChanged;
        }

        void setFontSizeChanged(boolean bl) {
            this.mFontSizeChanged = bl;
        }

        boolean isBold() {
            return this.mBold;
        }

        void setBold(boolean bl) {
            this.mBold = bl;
        }

        boolean isBoldChanged() {
            return this.mBoldChanged;
        }

        void setBoldChanged(boolean bl) {
            this.mBoldChanged = bl;
        }

        boolean isItalic() {
            return this.mItalic;
        }

        void setItalic(boolean bl) {
            this.mItalic = bl;
        }

        boolean isItalicChanged() {
            return this.mItalicChanged;
        }

        void setItalicChanged(boolean bl) {
            this.mItalicChanged = bl;
        }

        boolean isUnderline() {
            return this.mUnderline;
        }

        void setUnderline(boolean bl) {
            this.mUnderline = bl;
        }

        boolean isUnderlineChanged() {
            return this.mUnderlineChanged;
        }

        void setUnderlineChanged(boolean bl) {
            this.mUnderlineChanged = bl;
        }

        int getColor() {
            return this.mColor;
        }

        void setColor(int n) {
            this.mColor = n;
        }

        boolean isColorChanged() {
            return this.mColorChanged;
        }

        void setColorChanged(boolean bl) {
            this.mColorChanged = bl;
        }
    }

    private class ItemImagesListRenderer
    extends JLabel
    implements ListCellRenderer {
        protected Border mNoFocusBorder = new EmptyBorder(1, 1, 1, 1);

        ItemImagesListRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Object object2;
            if (object instanceof JLabel) {
                this.setIcon(((JLabel)object).getIcon());
                object2 = ViewerOptionPanel.this.mItemNamesComboBox.getModel().getSelectedItem().toString();
                this.setToolTipText((String)object2);
            }
            if (bl) {
                if (jList.hasFocus()) {
                    this.setBackground(jList.getSelectionBackground());
                    this.setForeground(jList.getSelectionForeground());
                } else {
                    this.setBackground(Color.lightGray);
                    this.setForeground(Color.black);
                }
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            this.setEnabled(jList.isEnabled());
            this.setFont(jList.getFont());
            object2 = null;
            if (bl2) {
                if (bl) {
                    object2 = UIManager.getBorder("List.focusSelectedCellHighlightBorder");
                }
                if (object2 == null) {
                    object2 = UIManager.getBorder("List.focusCellHighlightBorder");
                }
            } else {
                object2 = this.mNoFocusBorder;
            }
            this.setBorder((Border)object2);
            return this;
        }

        @Override
        public void setToolTipText(String string) {
            if (ComponentState.isBtdRtlOrLtr() && string != null && string.length() > 0) {
                super.setToolTipText(ComponentState.prepareStringForBidiRendering((String)string));
            } else {
                super.setToolTipText(string);
            }
        }
    }

    class MouseClickHandler
    extends MouseAdapter {
        MouseClickHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getSource().equals(ViewerOptionPanel.this.mItemImagesList) && mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 2) {
                if (ViewerOptionPanel.this.mShownRadio.isSelected()) {
                    ViewerOptionPanel.this.mHiddenRadio.setSelected(true);
                    ViewerOptionPanel.this.saveItemState();
                } else {
                    ViewerOptionPanel.this.mShownRadio.setSelected(true);
                    ViewerOptionPanel.this.saveItemState();
                }
            }
        }
    }
}

