/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.edit;

import com.spss.java_client.ui.dialogs.base.edit.OptionsUtil;
import com.spss.java_client.ui.dialogs.base.edit.ViewerOptionPanel;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.uitools.dialogs.BaseDialog;
import com.spss.uitools.drop_menu_button.DropButton;
import com.spss.uitools.drop_menu_button.DropButtonDrawer;
import com.spss.uitools.drop_menu_button.DropButtonEx;
import com.spss.uitools.drop_menu_button.FillButtonDrawer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.ResourceBundle;
import javax.accessibility.AccessibleContext;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToggleButton;

public class ToolBarPanel
extends JPanel {
    private BaseDialog mBaseDialog;
    private ViewerOptionPanel mViewerPanel;
    private JToggleButton mBoldButton = null;
    private JToggleButton mItalicButton = null;
    private JToggleButton mUnderlineButton = null;
    private DropButtonEx mColorDropButton;

    public ToolBarPanel(BaseDialog baseDialog, ViewerOptionPanel viewerOptionPanel) {
        this.mBaseDialog = baseDialog;
        this.mViewerPanel = viewerOptionPanel;
        this.setLayout(new GridBagLayout());
    }

    public void setColorButtonColor(Color color) {
        this.mColorDropButton.setUserSelectedColor(color);
        this.mColorDropButton.repaint();
    }

    public Color getColorButtonColor() {
        return this.mColorDropButton.getUserSelectedColor();
    }

    public DropButton getColorButton() {
        return this.mColorDropButton;
    }

    public JToggleButton getBoldButton() {
        return this.mBoldButton;
    }

    public JToggleButton getItalicButton() {
        return this.mItalicButton;
    }

    public JToggleButton getUnderlineButton() {
        return this.mUnderlineButton;
    }

    public void setupToolBar() {
        ResourceBundle resourceBundle;
        Object object;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        this.mBoldButton = new JToggleButton();
        this.mBoldButton.addActionListener(this.mViewerPanel);
        URL uRL = ResUtil.getImageResource(this.mBaseDialog.getResString("IDS_BOLD_IMAGE"));
        this.mBoldButton.setIcon(new ImageIcon(uRL));
        this.mBoldButton.setMargin(new Insets(0, 0, 0, 0));
        AccessibleContext accessibleContext = this.mBoldButton.getAccessibleContext();
        if (accessibleContext != null) {
            object = ResUtil.getBundle("com.spss.java_client.ui.dialogs.common.res.CommonDlgResBundle", ResUtil.getLocale());
            accessibleContext.setAccessibleName(((ResourceBundle)object).getString("IDS_FONT_BOLD"));
        }
        object = new Insets(0, DialogUtil.getGroupBoxInnerMargin(), 0, 0);
        OptionsUtil.addUsingGBL(this, this.mBoldButton, gridBagConstraints, 0, 0, 1, 1, n, (Insets)object);
        this.mItalicButton = new JToggleButton();
        this.mItalicButton.addActionListener(this.mViewerPanel);
        uRL = ResUtil.getImageResource(this.mBaseDialog.getResString("IDS_ITALIC_IMAGE"));
        this.mItalicButton.setIcon(new ImageIcon(uRL));
        this.mItalicButton.setMargin(new Insets(0, 0, 0, 0));
        accessibleContext = this.mItalicButton.getAccessibleContext();
        if (accessibleContext != null) {
            resourceBundle = ResUtil.getBundle("com.spss.java_client.ui.dialogs.common.res.CommonDlgResBundle", ResUtil.getLocale());
            accessibleContext.setAccessibleName(resourceBundle.getString("IDS_FONT_ITALIC"));
        }
        OptionsUtil.addUsingGBL(this, this.mItalicButton, gridBagConstraints, 1, 0, 1, 1, n, (Insets)object);
        this.mUnderlineButton = new JToggleButton();
        this.mUnderlineButton.addActionListener(this.mViewerPanel);
        uRL = ResUtil.getImageResource(this.mBaseDialog.getResString("IDS_UNDERLINE_IMAGE"));
        this.mUnderlineButton.setIcon(new ImageIcon(uRL));
        this.mUnderlineButton.setMargin(new Insets(0, 0, 0, 0));
        accessibleContext = this.mUnderlineButton.getAccessibleContext();
        if (accessibleContext != null) {
            resourceBundle = ResUtil.getBundle("com.spss.java_client.ui.dialogs.common.res.CommonDlgResBundle", ResUtil.getLocale());
            accessibleContext.setAccessibleName(resourceBundle.getString("IDS_FONTCHOOSER_UNDERLINE_CHECK"));
        }
        OptionsUtil.addUsingGBL(this, this.mUnderlineButton, gridBagConstraints, 2, 0, 1, 1, n, (Insets)object);
        resourceBundle = new FillButtonDrawer();
        this.mColorDropButton = new DropButtonEx((DropButtonDrawer)resourceBundle);
        Dimension dimension = this.mColorDropButton.getSize();
        dimension.width = this.mBoldButton.getPreferredSize().width * 2;
        dimension.height = this.mBoldButton.getPreferredSize().height + 10;
        this.mColorDropButton.setPreferredSize(dimension);
        this.mColorDropButton.addActionListener((ActionListener)this.mViewerPanel);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        ((Insets)object).set(0, DialogUtil.getGroupBoxInnerMargin(), 0, 0);
        OptionsUtil.addUsingGBL(this, (JComponent)this.mColorDropButton, gridBagConstraints, 3, 0, 1, 1, n, (Insets)object);
        this.setTextColors();
    }

    private void setTextColors() {
        Color[] colorArray = new Color[]{new Color(225, 188, 29), new Color(92, 202, 136), new Color(0, 180, 160), new Color(227, 215, 16), new Color(236, 230, 208), new Color(254, 130, 180), new Color(204, 134, 63), new Color(63, 235, 124), new Color(28, 205, 205), new Color(207, 172, 227), new Color(208, 202, 140), new Color(237, 75, 75), new Color(225, 139, 14), new Color(95, 195, 56), new Color(85, 150, 230), new Color(204, 127, 228), new Color(150, 145, 145), new Color(215, 0, 51), new Color(208, 83, 52), new Color(41, 134, 38), new Color(63, 90, 168), new Color(171, 73, 243), new Color(90, 100, 94), new Color(155, 0, 0), new Color(243, 103, 42), new Color(92, 113, 72), new Color(9, 38, 114), new Color(119, 55, 143), new Color(69, 70, 71)};
        this.mColorDropButton.setColors(colorArray);
    }
}

