/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.edit;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.common.prefs.PrefDefaults;
import com.spss.java_client.core.common.prefs.PrefsMgr;
import com.spss.java_client.core.documents.UpdateUserPrefs;
import com.spss.java_client.ui.dialogs.base.edit.GeneralOptionPanel;
import com.spss.java_client.ui.dialogs.base.edit.OptionsUtil;
import com.spss.java_client.ui.dialogs.base.edit.res.EditResBundle;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.ProcedureDlgMgr;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.dialogs.BaseDialog;
import com.spss.uitools.help.StatsHelp;
import com.spss.uitools.util.IOptionConstants;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.Array;
import java.util.Locale;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class SmartReaderOptionsDlg
extends BaseDialog {
    private JComboBox mUILangList;
    private JComboBox mWideTablesCombo;
    private JCheckBox mShowPesCheck;

    public SmartReaderOptionsDlg(JFrame jFrame) {
        super(jFrame, true, ResUtil.getBundle(EditResBundle.getDefaultResourceBundleName(), ResUtil.getLocale()), EditResBundle.getImageFolder());
        Point point;
        this.setTitle(this.getResString("IDS_TITLE"));
        this.initialize();
        this.pack();
        Dimension dimension = ProcedureDlgMgr.getMgr().getDialogSize("edit_smartreader_options");
        if (dimension != null) {
            this.setSize(dimension);
        }
        if ((point = ProcedureDlgMgr.getMgr().getDialogLocation("edit_smartreader_options")) != null) {
            this.setLocation(point);
        } else {
            this.setLocationRelativeTo(jFrame);
        }
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                SmartReaderOptionsDlg.this.cleanStaticVariables();
                super.windowClosing(windowEvent);
            }
        });
        this.loadState();
    }

    public void doHelp() {
        StatsHelp.getStatsHelp().showHelp(StatsHelp.Book.BASE, "idh_pref_general_smartreader");
    }

    protected JPanel setupCmdButtonPanel() {
        JPanel jPanel = new JPanel(true);
        Insets insets = DialogUtil.getStandardButtonInsets();
        boolean bl = DialogUtil.areCommandButtonsBelow();
        JButton jButton = new JButton(new OKAction());
        JButton jButton2 = new JButton(new CancelAction());
        JButton jButton3 = new JButton(new HelpAction());
        DialogUtil.setupMacHelpButton(jButton3);
        if (bl) {
            jPanel.setBorder(new EmptyBorder(DialogUtil.getMainButtonGap(), 0, 0, 0));
            int n = insets.left + insets.right;
            if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
                jPanel.setLayout(new GridBagLayout());
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                Insets insets2 = new Insets(0, n, 0, 0);
                int n2 = 23;
                gridBagConstraints.weightx = 0.0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.fill = 2;
                DialogUtil.addUsingGBL(jPanel, jButton3, gridBagConstraints, 0, 0, 1, 1, n2, null);
                n2 = 24;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.fill = 0;
                DialogUtil.addUsingGBL(jPanel, jButton2, gridBagConstraints, 1, 0, 1, 1, n2, insets2);
                gridBagConstraints.fill = 2;
                DialogUtil.addUsingGBL(jPanel, jButton, gridBagConstraints, 2, 0, 1, 1, n2, insets2);
            } else {
                FlowLayout flowLayout = new FlowLayout(1, n, 0);
                jPanel.setLayout(flowLayout);
                jPanel.add(jButton);
                jPanel.add(jButton2);
                jPanel.add(jButton3);
            }
        } else {
            jPanel.setBorder(new EmptyBorder(0, DialogUtil.getMainButtonGap(), 0, 0));
            int n = insets.top + insets.bottom;
            BoxLayout boxLayout = new BoxLayout(jPanel, 1);
            jPanel.setLayout(boxLayout);
            jPanel.add(Box.createVerticalStrut(n * 2));
            jPanel.add(jButton);
            jPanel.add(Box.createVerticalStrut(n));
            jPanel.add(jButton2);
            jPanel.add(Box.createVerticalStrut(n));
            jPanel.add(jButton3);
            jPanel.add(Box.createVerticalStrut(n));
        }
        this.getRootPane().setDefaultButton(jButton);
        return jPanel;
    }

    private void initialize() {
        JPanel jPanel = this.getViewPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n = 23;
        Insets insets = DialogUtil.getStandardDialogInsets();
        Insets insets2 = (Insets)insets.clone();
        insets2.top = 0;
        insets2.bottom -= 2;
        JPanel jPanel2 = this.createUILangPanel();
        DialogUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n, insets2);
        JPanel jPanel3 = this.setupWideTablesPanel();
        DialogUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        JPanel jPanel4 = this.setupPesCheckPanel();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, jPanel4, gridBagConstraints, 0, 2, 1, 1, n, insets2);
    }

    private JPanel createUILangPanel() {
        String[] stringArray = new String[Array.getLength(GeneralOptionPanel.LANG_ITEMS)];
        for (int i = 0; i < Array.getLength(GeneralOptionPanel.LANG_ITEMS); ++i) {
            Array.set(stringArray, i, this.getResString(GeneralOptionPanel.LANG_ITEMS[i]));
        }
        this.mUILangList = new JComboBox<String>(stringArray);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel(new GridBagLayout(), true);
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_USER_INTERFACE")));
        JLabel jLabel = new JLabel(this.getResString("IDS_LANG"));
        jLabel.setDisplayedMnemonic(this.getDlgAccessKey("IDK_LANG_KEY"));
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n = DialogUtil.getGroupBoxInnerMargin();
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = (Insets)insets.clone();
        insets2.top = 0;
        insets2.left = n;
        OptionsUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, 23, insets2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 1.0;
        Insets insets3 = (Insets)insets.clone();
        insets3.left = n;
        insets3.bottom = n;
        insets3.right = n2 * 8;
        OptionsUtil.addUsingGBL(jPanel, this.mUILangList, gridBagConstraints, 0, 1, 1, 1, 23, insets3);
        jLabel.setLabelFor(this.mUILangList);
        return jPanel;
    }

    private JPanel setupWideTablesPanel() {
        this.mWideTablesCombo = new JComboBox<String>(this.getResStringArray("IDS_PIVOT_WTABLES_COMBO_ITEMS"));
        this.mWideTablesCombo.setSelectedIndex(0);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_TAB_PIVOT_TABLES")));
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_PIVOT_WTABLES_LBL");
        jLabel.setLabelFor(this.mWideTablesCombo);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = DialogUtil.getGroupBoxInnerMargin();
        int n2 = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = (Insets)insets.clone();
        insets2.top = 0;
        insets2.left = n;
        int n3 = DialogUtil.getComponentGroupGap();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        OptionsUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n2, insets2);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        Insets insets3 = (Insets)insets.clone();
        insets3.left = n;
        insets3.bottom = n;
        insets3.right = n3 * 8;
        OptionsUtil.addUsingGBL(jPanel, this.mWideTablesCombo, gridBagConstraints, 0, 1, 1, 1, n2, insets3);
        return jPanel;
    }

    private JPanel setupPesCheckPanel() {
        this.mShowPesCheck = new JCheckBox(this.getResString("IDS_SHOW_PES_ON_OPEN"));
        this.mShowPesCheck.setMnemonic(this.getDlgAccessKey("IDK_SHOW_PES_ON_OPEN_KEY"));
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_GROUP_PES")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        int n2 = DialogUtil.getComponentGroupGap();
        int n3 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets2 = new Insets(insets.top, n3, n3, n2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        OptionsUtil.addUsingGBL(jPanel, this.mShowPesCheck, gridBagConstraints, 0, 0, 1, 1, n, insets2);
        return jPanel;
    }

    private void loadState() {
        Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs().node("options");
        Preferences preferences2 = preferences.node("general");
        Preferences preferences3 = preferences.node("tables");
        String string = PrefsMgr.getILangName();
        int n = DialogUtil.getIndexOfItem(IOptionConstants.OUTPUT_LANGUAGE_VALUES, string);
        this.mUILangList.setSelectedIndex(n);
        String string2 = preferences3.get("wide_tables", PrefDefaults.DEF_WIDE_TABLES);
        n = DialogUtil.getIndexOfItem(IOptionConstants.TABLES_COPY_WIDE_VALUES, string2);
        this.mWideTablesCombo.setSelectedIndex(n);
        boolean bl = preferences2.getBoolean("show_pes_on_file_dlgs", false);
        this.mShowPesCheck.setSelected(bl);
    }

    private void saveState() {
        Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs().node("options");
        Preferences preferences2 = preferences.node("general");
        Preferences preferences3 = preferences.node("tables");
        String string = IOptionConstants.OUTPUT_LANGUAGE_VALUES[this.mUILangList.getSelectedIndex()];
        preferences2.put("ui_language", string);
        Locale locale = ComponentState.nlvNameToLocale((String)string);
        ComponentState.setILangLocale((Locale)locale);
        StatsHelp.getStatsHelp().startEclipseHelp(locale, Boolean.valueOf(UpdateUserPrefs.firstLaunchAfterInstall()));
        preferences3.put("wide_tables", IOptionConstants.TABLES_COPY_WIDE_VALUES[this.mWideTablesCombo.getSelectedIndex()]);
        boolean bl = this.mShowPesCheck.isSelected();
        preferences2.putBoolean("show_pes_on_file_dlgs", bl);
        ProcedureDlgMgr.getMgr().saveDialogSize("edit_smartreader_options", this.getSize());
        ProcedureDlgMgr.getMgr().saveDialogLocation("edit_smartreader_options", this.getLocation());
    }

    private void cleanStaticVariables() {
    }

    private boolean hasUIHelp() {
        String string = IOptionConstants.OUTPUT_LANGUAGE_VALUES[this.mUILangList.getSelectedIndex()];
        Locale locale = ComponentState.nlvNameToLocale((String)string);
        return StatsHelp.getStatsHelp().hasHelp(locale);
    }

    class HelpAction
    extends AbstractAction {
        HelpAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_HELP"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SmartReaderOptionsDlg.this.doHelp();
        }
    }

    class CancelAction
    extends AbstractAction {
        public CancelAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_CANCEL"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SmartReaderOptionsDlg.this.dispose();
        }
    }

    class OKAction
    extends AbstractAction {
        public OKAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_OK"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string;
            if (!SmartReaderOptionsDlg.this.hasUIHelp() && SpssAlertOptionPane.showConfirmDialog((Window)((Object)SmartReaderOptionsDlg.this), string = String.format(SmartReaderOptionsDlg.this.getResString("ERR_HELP_FILE_MSG"), VersionInfo.getProductNickName()), VersionInfo.getAppVersionString(), SpssAlertOptionPane.IconType.eInformation, SpssAlertOptionPane.OptionType.OK_CANCEL_OPTION) != 0) {
                return;
            }
            SmartReaderOptionsDlg.this.saveState();
            SmartReaderOptionsDlg.this.dispose();
        }
    }
}

