/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.edit;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.OutputItemType;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.common.fopen.RefFileFilter;
import com.spss.java_client.core.comp_util.FileLocationsUtil;
import com.spss.java_client.core.script.ScriptingFrameworkException;
import com.spss.java_client.core.script.autoscripts.AutoscriptEvent;
import com.spss.java_client.core.script.autoscripts.AutoscriptRegistry;
import com.spss.java_client.core.script.autoscripts.IAutoscriptRegistry;
import com.spss.java_client.core.script.autoscripts.IScriptFile;
import com.spss.java_client.core.script.autoscripts.ScriptFile;
import com.spss.java_client.core.script.engine.IScriptLanguage;
import com.spss.java_client.core.script.engine.IScriptLanguageMgr;
import com.spss.java_client.core.script.engine.ScriptLanguageMgr;
import com.spss.java_client.ui.controls.ButtonEditCtrl;
import com.spss.java_client.ui.controls.FileTextField;
import com.spss.java_client.ui.controls.IButtonEditListener;
import com.spss.java_client.ui.dialogs.base.edit.OptionPanel;
import com.spss.java_client.ui.dialogs.base.edit.OptionsDlg;
import com.spss.java_client.ui.dialogs.base.edit.OptionsUtil;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import com.spss.uitools.util.IniHandler;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.text.Collator;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class ScriptsOptionPanel
extends OptionPanel
implements ListSelectionListener,
IButtonEditListener,
ActionListener,
CellEditorListener {
    public static final int COMMANDS_SIZE = 3;
    public static final int COMMANDS_IDENTIFIERS_COLUMN = 0;
    public static final int COMMANDS_SCRIPTS_COLUMN = 1;
    public static final int COMMANDS_KEYS_COLUMN = 2;
    public static final int OBJECTS_SIZE = 4;
    public static final int OBJECTS_OBJECT_COLUMN = 0;
    public static final int OBJECTS_SCRIPT_COLUMN = 1;
    public static final int OBJECTS_LANGUAGE_COLUMN = 2;
    public static final int OBJECTS_SIGNATURE_COLUMN = 3;
    public static final String CHART_SUBTYPE = "Chart";
    public static final String TREE_SUBTYPE = "Tree";
    public static final String NOTE_SUBTYPE = "Notes";
    public static final String WARNING_SUBTYPE = "Warnings";
    public static final String TABLE_SUFFIX = "Table";
    private JLabel mDefaultScriptLanguageLbl;
    private JComboBox mDefaultScriptLanguageCombo;
    private JCheckBox mAutoscriptingCheck;
    private FileTextField mScriptFileText;
    private JLabel mScriptFileLbl;
    private JButton mBrowseFile;
    private JLabel mScriptLanguageLbl;
    private JComboBox mScriptLanguageCombo;
    private JLabel mTotalScriptsAppliedLabel;
    private JLabel mTotalScriptsAppliedCount;
    private JTable mCommandsTable;
    private JTable mObjectsTable;
    private TableModel mObjectsTableModel;
    private JScrollPane mCommandsScrollPane;
    private JScrollPane mObjectsScrollPane;
    private Comparator<Object> mComparator;
    private Object[][] mObjectsCellData;
    private ButtonEditCtrl mButtonEditCtrl;
    private HashMap<String, String> mCommandsWithCharts;
    JLabel mCommandsLabel;
    JLabel mObjectsLabel;

    public ScriptsOptionPanel(OptionsDlg optionsDlg, Preferences preferences, String string) {
        super(optionsDlg, preferences, string);
        this.setOpaque(false);
        this.setOptionsChanged(false);
    }

    @Override
    public String getDialogHelpID() {
        return "idh_pref_scripts";
    }

    @Override
    protected void initVars() {
        this.fillCommandsWithCharts();
        this.mDefaultScriptLanguageLbl = DialogUtil.createLabel(this.mOptionDialog, "IDS_SCRIPTS_DEFAULT_LANGUAGE_LABEL");
        this.mDefaultScriptLanguageCombo = new JComboBox();
        this.mDefaultScriptLanguageCombo.setOpaque(true);
        this.mDefaultScriptLanguageLbl.setLabelFor(this.mDefaultScriptLanguageCombo);
        this.mAutoscriptingCheck = DialogUtil.createCheckBox(this.mOptionDialog, "IDS_AUTOSCRIPTS_ENABLE_LABEL", (ActionListener)this);
        this.mScriptFileText = new FileTextField();
        this.mScriptFileText.setColumns(40);
        this.mBrowseFile = DialogUtil.createButton(this.mOptionDialog, "IDS_AUTOSCRIPTS_BASE_BROWSE_LABEL", this);
        this.mScriptFileLbl = DialogUtil.createLabel(this.mOptionDialog, "IDS_AUTOSCRIPTS_FILE_LABEL");
        this.mScriptFileLbl.setLabelFor((Component)((Object)this.mScriptFileText));
        this.mScriptFileText.setCaretPosition(0);
        this.mScriptLanguageLbl = DialogUtil.createLabel(this.mOptionDialog, "IDS_AUTOSCRIPTS_LANGUAGE_LABEL");
        this.mScriptLanguageCombo = new JComboBox();
        this.mScriptLanguageCombo.setOpaque(true);
        this.mScriptLanguageLbl.setLabelFor(this.mScriptLanguageCombo);
        this.mTotalScriptsAppliedLabel = DialogUtil.createLabel(this.mOptionDialog, "IDS_AUTOSCRIPTS_SCRIPTS_APPLIED_LABEL");
        this.mTotalScriptsAppliedCount = new JLabel();
        Object[] objectArray = this.getCommandsColumnData();
        DefaultTableModel defaultTableModel = new DefaultTableModel(null, objectArray){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        this.mCommandsTable = new JTableWithToolTips();
        this.mCommandsTable.setModel(defaultTableModel);
        Dimension dimension = new Dimension(200, 145);
        this.mCommandsTable.setMinimumSize(dimension);
        this.mCommandsTable.setSize(dimension);
        this.mCommandsTable.setAutoResizeMode(4);
        this.mCommandsTable.setSelectionMode(0);
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent();
            }
        };
        AbstractAction abstractAction2 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().focusPreviousComponent();
            }
        };
        this.mCommandsTable.getInputMap(0).put(KeyStroke.getKeyStroke(9, 0), "tabOut");
        this.mCommandsTable.getInputMap(0).put(KeyStroke.getKeyStroke(9, 1), "tabIn");
        this.mCommandsTable.getActionMap().put("tabIn", abstractAction2);
        this.mCommandsTable.getActionMap().put("tabOut", abstractAction);
        this.mCommandsScrollPane = new JScrollPane(this.mCommandsTable);
        this.mCommandsScrollPane.setPreferredSize(this.mCommandsTable.getMinimumSize());
        this.mCommandsScrollPane.setHorizontalScrollBarPolicy(30);
        this.mCommandsScrollPane.setVerticalScrollBarPolicy(20);
        objectArray = this.getObjectsColumnData();
        this.mObjectsTableModel = new DefaultTableModel(null, objectArray){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return n2 == 1 || n2 == 2;
            }
        };
        this.mObjectsTable = new JTableWithToolTips();
        this.mObjectsTable.setModel(this.mObjectsTableModel);
        dimension = new Dimension(400, 145);
        this.mObjectsTable.setMinimumSize(dimension);
        this.mObjectsTable.setSize(dimension);
        this.mObjectsTable.setAutoResizeMode(4);
        this.mObjectsTable.setSelectionMode(0);
        this.mObjectsTable.setRowSelectionAllowed(false);
        this.mObjectsTable.getInputMap(0).put(KeyStroke.getKeyStroke(9, 0), "tabOut");
        this.mObjectsTable.getInputMap(0).put(KeyStroke.getKeyStroke(9, 1), "tabIn");
        this.mObjectsTable.getActionMap().put("tabIn", abstractAction2);
        this.mObjectsTable.getActionMap().put("tabOut", abstractAction);
        this.mObjectsScrollPane = new JScrollPane(this.mObjectsTable);
        this.mObjectsScrollPane.setPreferredSize(this.mObjectsTable.getMinimumSize());
        this.mObjectsScrollPane.setHorizontalScrollBarPolicy(30);
        this.mObjectsScrollPane.setVerticalScrollBarPolicy(20);
        this.mComponentOrder.add(this.mDefaultScriptLanguageCombo);
        this.mComponentOrder.add(this.mAutoscriptingCheck);
        this.mComponentOrder.add(this.mScriptFileText);
        this.mComponentOrder.add(this.mBrowseFile);
        this.mComponentOrder.add(this.mScriptLanguageCombo);
        this.mComponentOrder.add(this.mCommandsTable);
        this.mComponentOrder.add(this.mObjectsTable);
        for (int i = 0; i < this.mOptionDialog.getCmdButtonPanel().getComponents().length; ++i) {
            Component component = this.mOptionDialog.getCmdButtonPanel().getComponents()[i];
            this.mComponentOrder.add(component);
        }
        this.mComparator = new Comparator<Object>(){

            @Override
            public int compare(Object object, Object object2) {
                if (object instanceof String && object2 instanceof String) {
                    return object.toString().compareToIgnoreCase(object2.toString());
                }
                return 0;
            }
        };
        this.mButtonEditCtrl = new ButtonEditCtrl(1);
        this.mButtonEditCtrl.setReadOnlyEdit(false);
        this.mButtonEditCtrl.addButtonListener(this);
        this.mButtonEditCtrl.addCellEditorListener(this);
        this.mCommandsLabel = DialogUtil.createLabel(this.mOptionDialog, "IDS_AUTOSCRIPTS_COMMAND_ID_LABEL");
        this.mCommandsLabel.setLabelFor(this.mCommandsTable);
        this.mObjectsLabel = DialogUtil.createLabel(this.mOptionDialog, "IDS_AUTOSCRIPTS_OBJECTS_LABEL");
        this.mObjectsLabel.setLabelFor(this.mObjectsTable);
        this.DisableAllControls();
        this.addListeners();
    }

    private void DisableAllControls() {
        IScriptLanguageMgr iScriptLanguageMgr = ScriptLanguageMgr.getInstance();
        Vector vector = iScriptLanguageMgr.getAllLanguages();
        if (vector.isEmpty()) {
            this.mDefaultScriptLanguageLbl.setEnabled(false);
            this.mDefaultScriptLanguageCombo.setEnabled(false);
            this.mAutoscriptingCheck.setEnabled(false);
            this.DisableEnableAutoscriptingControls(false);
        }
    }

    @Override
    public void initPanel() {
        super.initPanel();
        JPanel jPanel = this.createScriptsPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        OptionsUtil.addUsingGBL(this, jPanel, gridBagConstraints, 0, 0, 1, 1, 23, null);
    }

    private JPanel createScriptsPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        JPanel jPanel2 = this.createDefaultLanguagePanel();
        JPanel jPanel3 = this.createAutoscriptsPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = 23;
        OptionsUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        OptionsUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 1, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel createDefaultLanguagePanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        OptionsUtil.addUsingGBL(jPanel, this.mDefaultScriptLanguageLbl, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.fill = 0;
        OptionsUtil.addUsingGBL(jPanel, this.mDefaultScriptLanguageCombo, gridBagConstraints, 1, 0, 1, 1, n, insets);
        JTextArea jTextArea = new JTextArea(this.getResString("IDS_SCRIPTS_DEFAULT_LANGUAGE_DESCRIPTION"));
        jTextArea.setOpaque(false);
        jTextArea.setEditable(false);
        jTextArea.setFocusable(false);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setLineWrap(true);
        jTextArea.setDisabledTextColor(jTextArea.getForeground());
        jTextArea.setEnabled(false);
        gridBagConstraints.fill = 2;
        OptionsUtil.addUsingGBL(jPanel, jTextArea, gridBagConstraints, 2, 0, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel createAutoscriptsPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_SCRIPTS_GROUP_AUTOSCRIPTS_LABEL")));
        jPanel.setLayout(new GridBagLayout());
        JPanel jPanel2 = this.createBaseAutoscriptPanel();
        JPanel jPanel3 = this.createAutoscriptsForObjectsPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = 23;
        OptionsUtil.addUsingGBL(jPanel, this.mAutoscriptingCheck, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.fill = 2;
        OptionsUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        OptionsUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 2, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel createBaseAutoscriptPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_AUTOSCRIPTS_GROUP_BASE_LABEL")));
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        gridBagConstraints.weightx = 0.0;
        OptionsUtil.addUsingGBL(jPanel, this.mScriptFileLbl, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        OptionsUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mScriptFileText), gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        OptionsUtil.addUsingGBL(jPanel, this.mBrowseFile, gridBagConstraints, 2, 0, 1, 1, n, insets);
        this.mScriptFileText.setOpaque(true);
        gridBagConstraints.fill = 2;
        OptionsUtil.addUsingGBL(jPanel, this.mScriptLanguageLbl, gridBagConstraints, 3, 0, 1, 1, n, insets);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        OptionsUtil.addUsingGBL(jPanel, this.mScriptLanguageCombo, gridBagConstraints, 4, 0, 1, 1, n, insets);
        JTextArea jTextArea = new JTextArea(this.getResString("IDS_AUTOSCRIPTS_BASE_DESCRIPTION"));
        jTextArea.setOpaque(false);
        jTextArea.setEditable(false);
        jTextArea.setFocusable(false);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setLineWrap(true);
        jTextArea.setDisabledTextColor(jTextArea.getForeground());
        jTextArea.setEnabled(false);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        OptionsUtil.addUsingGBL(jPanel, jTextArea, gridBagConstraints, 0, 1, 5, 1, n, insets);
        return jPanel;
    }

    private JPanel createAutoscriptsForObjectsPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_AUTOSCRIPTS_GROUP_AUTOSCRIPTS_LABEL")));
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        OptionsUtil.addUsingGBL(jPanel, this.mCommandsLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        OptionsUtil.addUsingGBL(jPanel, this.mObjectsLabel, gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        OptionsUtil.addUsingGBL(jPanel, this.mCommandsScrollPane, gridBagConstraints, 0, 1, 1, 1, n, insets);
        OptionsUtil.addUsingGBL(jPanel, this.mObjectsScrollPane, gridBagConstraints, 1, 1, 1, 1, n, insets);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        gridBagConstraints.fill = 0;
        OptionsUtil.addUsingGBL(jPanel2, this.mTotalScriptsAppliedLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        OptionsUtil.addUsingGBL(jPanel2, this.mTotalScriptsAppliedCount, gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.weighty = 0.0;
        OptionsUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 2, 1, 1, n, insets);
        JTextArea jTextArea = new JTextArea(this.getResString("IDS_AUTOSCRIPTS_OBJECTS_DESCRIPTION"));
        jTextArea.setOpaque(false);
        jTextArea.setEditable(false);
        jTextArea.setFocusable(false);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setLineWrap(true);
        jTextArea.setDisabledTextColor(jTextArea.getForeground());
        jTextArea.setEnabled(false);
        gridBagConstraints.fill = 1;
        OptionsUtil.addUsingGBL(jPanel, jTextArea, gridBagConstraints, 0, 3, 2, 1, n, insets);
        return jPanel;
    }

    @Override
    protected void readPrefs() {
        IScriptLanguageMgr iScriptLanguageMgr = ScriptLanguageMgr.getInstance();
        Vector vector = iScriptLanguageMgr.getAllLanguages();
        if (!vector.isEmpty()) {
            IAutoscriptRegistry iAutoscriptRegistry = AutoscriptRegistry.getInstance();
            iAutoscriptRegistry.readFromPersistentStore();
            this.mAutoscriptingCheck.setSelected(iAutoscriptRegistry.isAutoscriptingEnabled());
            this.DisableEnableAutoscriptingControls(iAutoscriptRegistry.isAutoscriptingEnabled());
            for (IScriptLanguage iScriptLanguage : vector) {
                this.mScriptLanguageCombo.addItem(iScriptLanguage.getLanguageName());
                this.mDefaultScriptLanguageCombo.addItem(iScriptLanguage.getLanguageName());
            }
            this.mDefaultScriptLanguageCombo.setEnabled(this.isMoreThanOneLanguage());
            this.mDefaultScriptLanguageCombo.setSelectedItem(iScriptLanguageMgr.getDefaultLanguage().getLanguageName());
            this.mScriptLanguageCombo.setSelectedItem(iScriptLanguageMgr.getDefaultLanguage().getLanguageName());
            if (iAutoscriptRegistry.getBaseScriptFile() != null && iAutoscriptRegistry.getBaseScriptFile().getFile().exists()) {
                this.mScriptFileText.setText(iAutoscriptRegistry.getBaseScriptFile().getFile().getAbsolutePath());
                this.mScriptFileText.setCaretPosition(0);
                this.mScriptLanguageCombo.setSelectedItem(iAutoscriptRegistry.getBaseScriptFile().getLanguage().getLanguageName());
            }
            Object[][] objectArray = this.getCommandsCellData();
            int n = this.getTotalScriptsApplied(objectArray);
            this.mTotalScriptsAppliedCount.setText("" + n);
            Object[] objectArray2 = this.getCommandsColumnData();
            DefaultTableModel defaultTableModel = new DefaultTableModel(objectArray, objectArray2){

                @Override
                public boolean isCellEditable(int n, int n2) {
                    return false;
                }
            };
            this.mCommandsTable.setModel(defaultTableModel);
            DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer();
            defaultTableCellRenderer.setHorizontalAlignment(4);
            this.mCommandsTable.getColumnModel().getColumn(1).setCellRenderer(defaultTableCellRenderer);
            this.mCommandsTable.getSelectionModel().setSelectionInterval(0, 0);
        }
    }

    @Override
    protected void savePrefs() {
        IScriptLanguageMgr iScriptLanguageMgr = ScriptLanguageMgr.getInstance();
        Vector vector = iScriptLanguageMgr.getAllLanguages();
        if (!vector.isEmpty()) {
            if (!this.mDefaultScriptLanguageCombo.getSelectedItem().toString().equalsIgnoreCase(iScriptLanguageMgr.getDefaultLanguage().getLanguageName())) {
                iScriptLanguageMgr.setDefaultLanguage(this.mDefaultScriptLanguageCombo.getSelectedItem().toString());
            }
            IAutoscriptRegistry iAutoscriptRegistry = AutoscriptRegistry.getInstance();
            iAutoscriptRegistry.setAutoscriptingEnabled(this.mAutoscriptingCheck.isSelected());
            IScriptLanguage iScriptLanguage = iScriptLanguageMgr.getLanguageByName(this.mScriptLanguageCombo.getSelectedItem().toString());
            if (this.mScriptFileText.getText().length() > 0) {
                try {
                    ScriptFile scriptFile = new ScriptFile(new File(this.mScriptFileText.getText()), iScriptLanguage);
                    iAutoscriptRegistry.setBaseScriptFile((IScriptFile)scriptFile);
                }
                catch (ScriptingFrameworkException scriptingFrameworkException) {
                    scriptingFrameworkException.printStackTrace();
                }
            } else {
                iAutoscriptRegistry.setBaseScriptFile(null);
            }
            this.saveAutoscripts();
            this.updateCounts();
            if (this.mScriptFileText.getText().length() == 0) {
                this.mScriptLanguageCombo.setSelectedItem(iScriptLanguageMgr.getDefaultLanguage().getLanguageName());
            }
            iAutoscriptRegistry.writeToPersistentStore();
        }
    }

    private void updateCounts() {
        int n;
        Object[][] objectArray = this.getCommandsCellData();
        for (n = 0; n < objectArray.length; ++n) {
            this.mCommandsTable.getModel().setValueAt(objectArray[n][1], n, 1);
        }
        n = this.getTotalScriptsApplied(objectArray);
        if (n == 0) {
            this.mTotalScriptsAppliedCount.setText("");
        } else {
            this.mTotalScriptsAppliedCount.setText("" + n);
        }
    }

    private void saveAutoscripts() {
        IAutoscriptRegistry iAutoscriptRegistry = AutoscriptRegistry.getInstance();
        IScriptLanguageMgr iScriptLanguageMgr = ScriptLanguageMgr.getInstance();
        String string = iScriptLanguageMgr.getDefaultLanguage().getLanguageName();
        if (this.mObjectsTableModel != null && this.mObjectsCellData != null) {
            int n = this.mObjectsTableModel.getRowCount();
            for (int i = 0; i < n; ++i) {
                String string2 = this.mObjectsCellData[i][3].toString();
                String string3 = this.mObjectsTableModel.getValueAt(i, 1).toString();
                String string4 = this.mObjectsTableModel.getValueAt(i, 2).toString();
                if (string3.length() == 0) {
                    if (iAutoscriptRegistry.getScriptFile(string2) != null) {
                        iAutoscriptRegistry.setScriptFile(string2, null);
                    }
                    if (string4.compareToIgnoreCase(string) == 0) continue;
                    this.mObjectsTableModel.setValueAt(string, i, 2);
                    continue;
                }
                IScriptLanguage iScriptLanguage = iScriptLanguageMgr.getLanguageByName(string4);
                try {
                    ScriptFile scriptFile = new ScriptFile(new File(string3), iScriptLanguage);
                    if (scriptFile.getFile().exists()) {
                        iAutoscriptRegistry.setScriptFile(string2, (IScriptFile)scriptFile);
                        continue;
                    }
                    iAutoscriptRegistry.setScriptFile(string2, null);
                    continue;
                }
                catch (ScriptingFrameworkException scriptingFrameworkException) {
                    scriptingFrameworkException.printStackTrace();
                }
            }
        }
    }

    @Override
    protected int getId() {
        return 0;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.mBrowseFile) {
            int n;
            String string;
            RefFileFilter refFileFilter;
            RemoteFileChooser remoteFileChooser = new RemoteFileChooser(RemoteFileChooser.ChooserType.OpenFile, RemoteFileChooser.ChooserOption.Script, FileLocationsUtil.getOtherFilesDirectoryPath(), false);
            remoteFileChooser.setDialogTitle(this.getResString("IDS_FILE_CHOOSER_SELECT_SCRIPT_TITLE"));
            remoteFileChooser.setPythonVersionControlsVisible(false);
            IScriptLanguage iScriptLanguage = ScriptLanguageMgr.getInstance().getLanguageByName(this.mScriptLanguageCombo.getSelectedItem().toString());
            String string2 = iScriptLanguage.getLanguageName().toLowerCase().contains("python") ? "Python" : iScriptLanguage.getLanguageName();
            Vector vector = iScriptLanguage.getFileExtensions();
            StringBuilder stringBuilder = new StringBuilder();
            if (vector.size() != 0) {
                refFileFilter = iScriptLanguage.getFileExtensions().iterator();
                stringBuilder.append((String)refFileFilter.next());
                while (refFileFilter.hasNext()) {
                    string = (String)refFileFilter.next();
                    assert (string != null && string.length() > 0);
                    stringBuilder.append(";");
                    stringBuilder.append(string);
                }
            }
            if (stringBuilder.length() > 0) {
                refFileFilter = new RefFileFilter(string2 + " (" + stringBuilder.toString() + ")", stringBuilder.toString(), ";");
                remoteFileChooser.addChoosableFileFilter((FileFilter)refFileFilter);
                remoteFileChooser.setAcceptAllFileFilterUsed(true);
                remoteFileChooser.setFileFilter((FileFilter)refFileFilter);
            } else {
                remoteFileChooser.setAcceptAllFileFilterUsed(true);
            }
            if (this.mScriptFileText.getText().length() > 0) {
                remoteFileChooser.setCurrentDirectory(new File(this.mScriptFileText.getText()));
            }
            if ((n = remoteFileChooser.showOpenDialog((Component)((Object)this.mOptionDialog))) == 0) {
                FileLocationsUtil.setOtherFilesDirectoryPath((String)remoteFileChooser.getCurrentDirectory().getAbsolutePath());
                string = remoteFileChooser.getSelectedFilePath();
                this.mScriptFileText.setText(string);
                this.mScriptFileText.setCaretPosition(0);
            }
        } else if (object == this.mAutoscriptingCheck) {
            this.DisableEnableAutoscriptingControls(this.mAutoscriptingCheck.isSelected());
        } else if (object == this.mDefaultScriptLanguageCombo) {
            if (this.mScriptFileText.getText().trim().length() == 0) {
                this.mScriptLanguageCombo.setSelectedItem(this.mDefaultScriptLanguageCombo.getSelectedItem());
            }
            this.populateObjectsTable();
        }
        super.actionPerformed(actionEvent);
    }

    private boolean isMoreThanOneLanguage() {
        IScriptLanguageMgr iScriptLanguageMgr = ScriptLanguageMgr.getInstance();
        Vector vector = iScriptLanguageMgr.getAllLanguages();
        return !vector.isEmpty() && vector.size() > 1;
    }

    private void DisableEnableAutoscriptingControls(boolean bl) {
        TableCellEditor tableCellEditor;
        this.mScriptFileLbl.setEnabled(bl);
        this.mScriptFileText.setEnabled(bl);
        this.mBrowseFile.setEnabled(bl);
        this.mButtonEditCtrl.setEnabled(bl);
        this.mCommandsScrollPane.setEnabled(bl);
        this.mObjectsScrollPane.setEnabled(bl);
        this.mTotalScriptsAppliedLabel.setEnabled(bl);
        this.mCommandsTable.setEnabled(bl);
        this.mObjectsTable.setEnabled(bl);
        this.mTotalScriptsAppliedCount.setEnabled(bl);
        this.mScriptLanguageLbl.setEnabled(bl);
        this.mScriptLanguageCombo.setEnabled(this.isMoreThanOneLanguage() && bl);
        this.mCommandsLabel.setEnabled(bl);
        this.mObjectsLabel.setEnabled(bl);
        if (!bl && (tableCellEditor = this.mObjectsTable.getCellEditor()) != null) {
            tableCellEditor.cancelCellEditing();
        }
    }

    private void addListeners() {
        this.mAutoscriptingCheck.addActionListener(this);
        this.mCommandsTable.getSelectionModel().addListSelectionListener(this);
        this.mCommandsTable.addKeyListener(new TableColumnTypeAhead(this.mCommandsTable, 0));
        this.mObjectsTable.addKeyListener(new TableColumnTypeAhead(this.mObjectsTable, 0));
        this.mScriptFileText.addKeyListener(this);
        this.mScriptFileText.addFocusListener(this);
        this.mDefaultScriptLanguageCombo.addActionListener(this);
        this.mCommandsTable.addFocusListener(this);
        this.mObjectsTable.addFocusListener(this);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        Object object = listSelectionEvent.getSource();
        if (!listSelectionEvent.getValueIsAdjusting() && object.equals(this.mCommandsTable.getSelectionModel())) {
            this.populateObjectsTable();
            this.updateCounts();
        }
    }

    private Object[] getCommandsColumnData() {
        return new String[]{this.getResString("IDS_AUTOSCRIPTS_COMMAND_ID_HEADER"), this.getResString("IDS_AUTOSCRIPTS_COMMAND_SCRIPTS_HEADER")};
    }

    private Object[][] getCommandsCellData() {
        LinkedList linkedList;
        IniHandler iniHandler;
        String string = "omsgui.ini";
        String string2 = VersionInfo.getStatisticsHome() + File.separatorChar + string;
        Object[][] objectArray = null;
        File file = new File(string2);
        if (file.exists() && (iniHandler = IniHandler.loadIniFile((String)string2, (boolean)true, (String)"")) != null && (linkedList = iniHandler.getPrivateProfileSectionNames()) != null) {
            HashMap hashMap = iniHandler.getPrivateProfileSection("Subtypes");
            if (hashMap == null) {
                return null;
            }
            hashMap = iniHandler.getPrivateProfileSection("Command_Subtypes");
            if (hashMap == null) {
                return null;
            }
            hashMap = iniHandler.getPrivateProfileSection("Commands");
            if (hashMap == null) {
                return null;
            }
            Iterator iterator = hashMap.keySet().iterator();
            objectArray = new Object[hashMap.size()][3];
            IAutoscriptRegistry iAutoscriptRegistry = AutoscriptRegistry.getInstance();
            int n = 0;
            while (iterator.hasNext()) {
                String string3 = (String)iterator.next();
                Vector<String> vector = this.getSubTypes(string3);
                int n2 = 0;
                String string4 = ((IniHandler.KeyValuePair)hashMap.get(string3)).toString();
                String[] stringArray = string4.split("=");
                string4 = stringArray.length > 1 ? stringArray[1] : stringArray[0];
                string4 = string4.trim();
                if (vector != null) {
                    for (String string5 : vector) {
                        String string6 = this.buildEventSignature(string4, this.getItemTypeFromSubType(string5), string5);
                        if (iAutoscriptRegistry == null || iAutoscriptRegistry.getScriptFile(string6) == null) continue;
                        ++n2;
                    }
                    Object object = this.buildEventSignature(string4, this.getItemTypeFromSubType(TREE_SUBTYPE), TREE_SUBTYPE);
                    if (iAutoscriptRegistry != null && iAutoscriptRegistry.getScriptFile((String)object) != null) {
                        ++n2;
                    } else {
                        object = this.buildEventSignature(string4, this.getItemTypeFromSubType(CHART_SUBTYPE), CHART_SUBTYPE);
                        if (iAutoscriptRegistry != null && iAutoscriptRegistry.getScriptFile((String)object) != null) {
                            ++n2;
                        }
                    }
                }
                objectArray[n][0] = string4;
                if (n2 > 0) {
                    objectArray[n][1] = n2;
                }
                objectArray[n][2] = string3;
                ++n;
            }
        }
        this.sortCommandsData(objectArray);
        return objectArray;
    }

    private int getTotalScriptsApplied(Object[][] objectArray) {
        int n = 0;
        for (Object[] objectArray2 : objectArray) {
            Integer n2 = (Integer)objectArray2[1];
            if (n2 == null) continue;
            n += n2.intValue();
        }
        return n;
    }

    private Object[] getObjectsColumnData() {
        return new String[]{this.getResString("IDS_AUTOSCRIPTS_OBJECTS_HEADER"), this.getResString("IDS_AUTOSCRIPTS_SCRIPT_HEADER"), this.getResString("IDS_AUTOSCRIPTS_LANGUAGE_HEADER")};
    }

    private Object[][] getObjectsCellData(Set<String> set) {
        Object[][] objectArray = null;
        String string = (String)this.mDefaultScriptLanguageCombo.getSelectedItem();
        if (string.length() > 0 && set != null && !set.isEmpty()) {
            objectArray = new Object[set.size()][4];
            int n = 0;
            for (String string2 : set) {
                String[] stringArray = string2.split("=");
                OutputItemType outputItemType = this.getItemTypeFromSubType(stringArray[2]);
                String string3 = this.buildEventSignature(stringArray[1], outputItemType, stringArray[2]);
                IAutoscriptRegistry iAutoscriptRegistry = AutoscriptRegistry.getInstance();
                IScriptFile iScriptFile = iAutoscriptRegistry.getScriptFile(string3);
                objectArray[n][0] = outputItemType == OutputItemType.PIVOT && !stringArray[2].endsWith(TABLE_SUFFIX) ? stringArray[2] + " " + TABLE_SUFFIX : stringArray[2];
                objectArray[n][1] = "";
                if (iScriptFile != null && iScriptFile.getFile().exists()) {
                    objectArray[n][1] = iScriptFile.getFile().getAbsolutePath();
                }
                objectArray[n][2] = iScriptFile != null ? iScriptFile.getLanguage().getLanguageName() : string;
                objectArray[n][3] = string3;
                ++n;
            }
        }
        return objectArray;
    }

    private OutputItemType getItemTypeFromSubType(String string) {
        OutputItemType outputItemType = string.equalsIgnoreCase(CHART_SUBTYPE) ? OutputItemType.CHART : (string.equalsIgnoreCase(TREE_SUBTYPE) ? OutputItemType.CHART : (string.equalsIgnoreCase(NOTE_SUBTYPE) ? OutputItemType.NOTE : (string.equalsIgnoreCase(WARNING_SUBTYPE) ? OutputItemType.WARNING : OutputItemType.PIVOT)));
        return outputItemType;
    }

    private void sortCommandsData(Object[][] objectArray) {
        Collator collator = Collator.getInstance();
        for (int i = 0; i < objectArray.length; ++i) {
            for (int j = i + 1; j < objectArray.length; ++j) {
                if (collator.compare(objectArray[i][0].toString(), objectArray[j][0].toString()) <= 0) continue;
                Object object = objectArray[i][0];
                objectArray[i][0] = objectArray[j][0];
                objectArray[j][0] = object;
                object = objectArray[i][1];
                objectArray[i][1] = objectArray[j][1];
                objectArray[j][1] = object;
                object = objectArray[i][2];
                objectArray[i][2] = objectArray[j][2];
                objectArray[j][2] = object;
            }
        }
    }

    private void populateObjectsTable() {
        Object object;
        Object object2;
        Object[][] objectArray = this.getCommandsCellData();
        int n = this.mCommandsTable.getSelectedRowCount();
        int[] nArray = this.mCommandsTable.getSelectedRows();
        TreeSet<Object> treeSet = new TreeSet<Object>(this.mComparator);
        for (int i = 0; i < n; ++i) {
            object2 = objectArray[nArray[i]][0].toString();
            object = objectArray[nArray[i]][2].toString();
            Vector<String> vector = this.getSubTypes((String)object);
            if (vector == null) continue;
            for (String string : vector) {
                treeSet.add((String)object + "=" + ((String)object2).trim() + "=" + string);
            }
            this.addChartAndTreeSubtypes((String)object, (String)object2, treeSet);
        }
        this.mObjectsCellData = this.getObjectsCellData(treeSet);
        Object[] objectArray2 = this.getObjectsColumnData();
        this.mObjectsTableModel = new DefaultTableModel(this.mObjectsCellData, objectArray2){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return n2 == 1 || n2 == 2 && ScriptsOptionPanel.this.isMoreThanOneLanguage();
            }
        };
        this.mObjectsTable.setModel(this.mObjectsTableModel);
        object2 = this.mObjectsTable.getColumnModel().getColumn(1);
        ((TableColumn)object2).setIdentifier(objectArray2[1]);
        ((TableColumn)object2).setCellEditor(this.mButtonEditCtrl);
        object2 = this.mObjectsTable.getColumnModel().getColumn(2);
        ((TableColumn)object2).setIdentifier(objectArray2[2]);
        ((TableColumn)object2).setCellEditor(new ComboEditor(2));
        object = new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                Component component = ComponentState.isBtdRtlOrLtr() && object != null && object instanceof String && ((String)object).length() > 0 ? super.getTableCellRendererComponent(jTable, ComponentState.prepareStringForBidiRendering((String)((String)object)), bl, bl2, n, n2) : super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                if (component instanceof JComponent) {
                    component.setEnabled(ScriptsOptionPanel.this.isMoreThanOneLanguage());
                }
                return component;
            }
        };
        ((TableColumn)object2).setCellRenderer((TableCellRenderer)object);
    }

    void addChartAndTreeSubtypes(String string, String string2, Set<String> set) {
        if (this.isCommandHasCharts(string)) {
            set.add(string + "=" + string2.trim() + "=" + CHART_SUBTYPE);
        }
        if (this.isCommandHasTrees(string)) {
            set.add(string + "=" + string2.trim() + "=" + TREE_SUBTYPE);
        }
    }

    boolean isCommandHasCharts(String string) {
        return this.mCommandsWithCharts.containsKey(string);
    }

    boolean isCommandHasTrees(String string) {
        return string.compareToIgnoreCase("TREE") == 0;
    }

    private Vector<String> getSubTypes(String string) {
        HashMap hashMap;
        IniHandler iniHandler;
        String string2 = "omsgui.ini";
        String string3 = VersionInfo.getStatisticsHome() + File.separatorChar + string2;
        Vector<String> vector = new Vector<String>();
        File file = new File(string3);
        if (file.exists() && (iniHandler = IniHandler.loadIniFile((String)string3, (boolean)true, (String)"")) != null && (hashMap = iniHandler.getPrivateProfileSection("Command_Subtypes")) != null) {
            LinkedList linkedList = iniHandler.getPrivateProfileString("Command_Subtypes", string);
            String string4 = linkedList.toString();
            String string5 = string4.substring(1, string4.length() - 1);
            StringTokenizer stringTokenizer = new StringTokenizer(string5, ";");
            HashMap hashMap2 = iniHandler.getPrivateProfileSection("Subtypes");
            while (stringTokenizer.hasMoreTokens()) {
                String string6 = ((IniHandler.KeyValuePair)hashMap2.get(stringTokenizer.nextToken())).toString();
                String string7 = string6.substring(string6.indexOf("=") + 1, string6.length());
                vector.add(string7.trim());
            }
        }
        return vector;
    }

    @Override
    public void buttonPressed(long l, int n) {
        if (n == 1) {
            int n2;
            Object object;
            RemoteFileChooser remoteFileChooser = new RemoteFileChooser(RemoteFileChooser.ChooserType.OpenFile, RemoteFileChooser.ChooserOption.Script, FileLocationsUtil.getOtherFilesDirectoryPath(), false);
            remoteFileChooser.setDialogTitle(this.getResString("IDS_FILE_CHOOSER_SELECT_SCRIPT_TITLE"));
            remoteFileChooser.setPythonVersionControlsVisible(false);
            String string = this.mObjectsTableModel.getValueAt((int)l, 2).toString();
            IScriptLanguage iScriptLanguage = ScriptLanguageMgr.getInstance().getLanguageByName(string);
            String string2 = iScriptLanguage.getLanguageName().toLowerCase().contains("python") ? "Python" : iScriptLanguage.getLanguageName();
            Vector vector = iScriptLanguage.getFileExtensions();
            StringBuilder stringBuilder = new StringBuilder();
            if (vector.size() != 0) {
                object = iScriptLanguage.getFileExtensions().iterator();
                stringBuilder.append((String)object.next());
                while (object.hasNext()) {
                    String string3 = (String)object.next();
                    assert (string3 != null && string3.length() > 0);
                    stringBuilder.append(";");
                    stringBuilder.append(string3);
                }
            }
            if (stringBuilder.length() > 0) {
                object = new RefFileFilter(string2 + " (" + stringBuilder.toString() + ")", stringBuilder.toString(), ";");
                remoteFileChooser.addChoosableFileFilter((FileFilter)object);
                remoteFileChooser.setAcceptAllFileFilterUsed(true);
                remoteFileChooser.setFileFilter((FileFilter)object);
            } else {
                remoteFileChooser.setAcceptAllFileFilterUsed(true);
            }
            if (this.mScriptFileText.getText().length() > 0) {
                remoteFileChooser.setCurrentDirectory(new File(this.mScriptFileText.getText()));
            }
            if (((String)(object = this.mObjectsTableModel.getValueAt((int)l, n).toString())).length() > 0) {
                remoteFileChooser.setCurrentDirectory(new File((String)object));
            }
            if ((n2 = remoteFileChooser.showOpenDialog((Component)((Object)this.mOptionDialog))) == 0) {
                FileLocationsUtil.setOtherFilesDirectoryPath((String)remoteFileChooser.getCurrentDirectory().getAbsolutePath());
                TableColumn tableColumn = this.mObjectsTable.getColumnModel().getColumn(n);
                tableColumn.getCellEditor().cancelCellEditing();
                String string4 = remoteFileChooser.getSelectedFilePath();
                this.mObjectsTableModel.setValueAt(string4, (int)l, n);
                this.mOptionDialog.enableApplyAction(true);
                this.saveAutoscripts();
                this.updateCounts();
                this.setOptionsChanged(true);
            }
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        super.focusGained(focusEvent);
        if (focusEvent.getSource().equals(this.mCommandsTable)) {
            int n = this.mCommandsTable.getSelectedRow() != -1 ? this.mCommandsTable.getSelectedRow() : 0;
            int n2 = this.mCommandsTable.getSelectedColumn() != -1 ? this.mCommandsTable.getSelectedColumn() : 0;
            this.mCommandsTable.setColumnSelectionInterval(n2, n2);
            this.mCommandsTable.setRowSelectionInterval(n, n);
        } else if (focusEvent.getSource().equals(this.mObjectsTable)) {
            int n = this.mObjectsTable.getSelectedRow() != -1 ? this.mObjectsTable.getSelectedRow() : 0;
            int n3 = this.mObjectsTable.getSelectedColumn() != -1 ? this.mObjectsTable.getSelectedColumn() : 0;
            this.mObjectsTable.setColumnSelectionInterval(n3, n3);
            this.mObjectsTable.setRowSelectionInterval(n, n);
        }
    }

    public boolean isValidPanel() {
        return this.isBaseScriptFileValid() && this.isObjectsTableScriptFilesValid();
    }

    private boolean isBaseScriptFileValid() {
        boolean bl = true;
        IAutoscriptRegistry iAutoscriptRegistry = AutoscriptRegistry.getInstance();
        String string = this.mScriptFileText.getText();
        File file = new File(string);
        if (string.length() > 0 && !file.exists()) {
            SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this.mOptionDialog), this.getResString("ERR_FILE_DOES_NOT_EXIST"), VersionInfo.getAppVersionString());
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ScriptsOptionPanel.this.mScriptFileText.selectAll();
                    ScriptsOptionPanel.this.mScriptFileText.requestFocusInWindow();
                }
            });
            bl = false;
        } else {
            boolean bl2 = false;
            if (iAutoscriptRegistry.getBaseScriptFile() != null) {
                if (!iAutoscriptRegistry.getBaseScriptFile().getFile().getAbsolutePath().equalsIgnoreCase(string)) {
                    bl2 = true;
                }
            } else if (string.length() > 0) {
                bl2 = true;
            }
            if (bl2) {
                this.mOptionDialog.enableApplyAction(true);
                this.setOptionsChanged(true);
            }
        }
        return bl;
    }

    private boolean isObjectsTableScriptFilesValid() {
        boolean bl = true;
        TableCellEditor tableCellEditor = this.mObjectsTable.getCellEditor();
        if (tableCellEditor != null) {
            tableCellEditor.stopCellEditing();
        }
        int n = this.mObjectsTableModel.getRowCount();
        for (int i = 0; i < n; ++i) {
            File file;
            String string = this.mObjectsTableModel.getValueAt(i, 1).toString();
            if (string.length() == 0 || (file = new File(string)).exists()) continue;
            SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this.mOptionDialog), this.getResString("ERR_FILE_DOES_NOT_EXIST"), VersionInfo.getAppVersionString());
            this.changeSelection(i, 1);
            bl = false;
            break;
        }
        return bl;
    }

    private void changeSelection(final int n, final int n2) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ScriptsOptionPanel.this.mObjectsTable.changeSelection(n, n2, false, false);
                ScriptsOptionPanel.this.mObjectsTable.editCellAt(n, n2, null);
                ScriptsOptionPanel.this.mObjectsTable.requestFocusInWindow();
                if (ScriptsOptionPanel.this.mButtonEditCtrl.getTextField() != null) {
                    ScriptsOptionPanel.this.mButtonEditCtrl.getTextField().requestFocus();
                    ScriptsOptionPanel.this.mButtonEditCtrl.getTextField().selectAll();
                }
            }
        });
    }

    private void fillCommandsWithCharts() {
        this.mCommandsWithCharts = new HashMap();
        this.mCommandsWithCharts.put("AIM", null);
        this.mCommandsWithCharts.put("ALSCAL", null);
        this.mCommandsWithCharts.put("ANACOR", null);
        this.mCommandsWithCharts.put("CASEPLOT", null);
        this.mCommandsWithCharts.put("CATPCA", null);
        this.mCommandsWithCharts.put("CATREG", null);
        this.mCommandsWithCharts.put("CLUSTER", null);
        this.mCommandsWithCharts.put("CONJOINT", null);
        this.mCommandsWithCharts.put("CORRESPONDENCE", null);
        this.mCommandsWithCharts.put("COXREG", null);
        this.mCommandsWithCharts.put("CURVEFIT", null);
        this.mCommandsWithCharts.put("DISCRIMINANT", null);
        this.mCommandsWithCharts.put("EXAMINE", null);
        this.mCommandsWithCharts.put("FACTOR", null);
        this.mCommandsWithCharts.put("FREQUENCIES", null);
        this.mCommandsWithCharts.put("GENLOG", null);
        this.mCommandsWithCharts.put("GLM", null);
        this.mCommandsWithCharts.put("GRAPH", null);
        this.mCommandsWithCharts.put("GGRAPH", null);
        this.mCommandsWithCharts.put("IGRAPH", null);
        this.mCommandsWithCharts.put("HILOGLINEAR", null);
        this.mCommandsWithCharts.put("HOMALS", null);
        this.mCommandsWithCharts.put("KM", null);
        this.mCommandsWithCharts.put("LOGISTIC REGRESSION", null);
        this.mCommandsWithCharts.put("LOGLINEAR", null);
        this.mCommandsWithCharts.put("MANOVA", null);
        this.mCommandsWithCharts.put("MLP", null);
        this.mCommandsWithCharts.put("MULTIPLE CORRESPONDENCE", null);
        this.mCommandsWithCharts.put("ONEWAY", null);
        this.mCommandsWithCharts.put("OVERALS", null);
        this.mCommandsWithCharts.put("PPLOT", null);
        this.mCommandsWithCharts.put("PREFSCAL", null);
        this.mCommandsWithCharts.put("PRINCALS", null);
        this.mCommandsWithCharts.put("PROXSCAL", null);
        this.mCommandsWithCharts.put("RBF", null);
        this.mCommandsWithCharts.put("REGRESSION", null);
        this.mCommandsWithCharts.put("ROC", null);
        this.mCommandsWithCharts.put("SELECTPRED", null);
        this.mCommandsWithCharts.put("SPECTRAL", null);
        this.mCommandsWithCharts.put("SURVIVAL", null);
        this.mCommandsWithCharts.put("TREE", null);
        this.mCommandsWithCharts.put("TSAPPLY", null);
        this.mCommandsWithCharts.put("TSMODEL", null);
        this.mCommandsWithCharts.put("TSPLOT", null);
        this.mCommandsWithCharts.put("UNIANOVA", null);
        this.mCommandsWithCharts.put("XGRAPH", null);
    }

    private String buildEventSignature(String string, OutputItemType outputItemType, String string2) {
        return AutoscriptEvent.buildEventSignature((String)string, (OutputItemType)outputItemType, (String)string2);
    }

    @Override
    public void editingStopped(ChangeEvent changeEvent) {
        if (changeEvent.getSource().equals(this.mButtonEditCtrl)) {
            this.mOptionDialog.enableApplyAction(true);
            this.setOptionsChanged(true);
        }
    }

    @Override
    public void editingCanceled(ChangeEvent changeEvent) {
    }

    public class TableColumnTypeAhead
    extends KeyAdapter {
        private JTable mTable;
        private int mColumnIndex;

        public TableColumnTypeAhead(JTable jTable, int n) {
            this.mTable = jTable;
            this.mColumnIndex = n;
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
            int n;
            char c = keyEvent.getKeyChar();
            String string = c + "";
            int n2 = this.findTableRow(string = string.toLowerCase(), (n = this.mTable.getSelectionModel().getMinSelectionIndex()) + 1);
            if (n2 == -1) {
                n2 = this.findTableRow(string, 0);
            }
            if (n2 != -1) {
                this.scrollAndSelectRow(n2);
            }
        }

        private int findTableRow(String string, int n) {
            for (int i = n; i < this.mTable.getModel().getRowCount(); ++i) {
                String string2 = this.mTable.getModel().getValueAt(i, this.mColumnIndex).toString().toLowerCase();
                if (!string2.startsWith(string)) continue;
                return i;
            }
            return -1;
        }

        private void scrollAndSelectRow(int n) {
            this.mTable.getSelectionModel().setSelectionInterval(n, n);
            Rectangle rectangle = this.mTable.getCellRect(n, this.mColumnIndex, true);
            this.mTable.scrollRectToVisible(rectangle);
        }
    }

    public class JTableWithToolTips
    extends JTable {
        @Override
        public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
            Component component = super.prepareRenderer(tableCellRenderer, n, n2);
            if (component instanceof JComponent) {
                JComponent jComponent = (JComponent)component;
                if (this.getValueAt(n, n2) != null) {
                    jComponent.setToolTipText(this.getValueAt(n, n2).toString());
                } else {
                    jComponent.setToolTipText("");
                }
            }
            return component;
        }
    }

    class ComboEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private JComboBox mCombo = new JComboBox();

        ComboEditor(int n) {
            if (n == 2) {
                IScriptLanguageMgr iScriptLanguageMgr = ScriptLanguageMgr.getInstance();
                Vector vector = iScriptLanguageMgr.getAllLanguages();
                if (!vector.isEmpty()) {
                    for (IScriptLanguage iScriptLanguage : vector) {
                        this.mCombo.addItem(iScriptLanguage.getLanguageName());
                    }
                }
            } else assert (false);
            this.mCombo.setEditable(false);
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            if (bl) {
                this.mCombo.setForeground(jTable.getSelectionForeground());
                this.mCombo.setBackground(jTable.getSelectionBackground());
            } else {
                this.mCombo.setForeground(jTable.getForeground());
                this.mCombo.setBackground(jTable.getBackground());
            }
            if (object.toString().length() == 0) {
                object = null;
            }
            this.mCombo.setSelectedItem(object);
            return this.mCombo;
        }

        @Override
        public Object getCellEditorValue() {
            return this.mCombo.getSelectedItem();
        }
    }
}

