/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.edit;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.fopen.RefFileFilter;
import com.spss.java_client.core.common.prefs.PrefDefaults;
import com.spss.java_client.core.common.prefs.PrefsMgr;
import com.spss.java_client.ui.controls.FileTextField;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.base.edit.OptionPanel;
import com.spss.java_client.ui.dialogs.base.edit.OptionsDlg;
import com.spss.java_client.ui.dialogs.base.edit.OptionsUtil;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import com.spss.pivottable.dialogs.PTBaseDialog;
import com.spss.pivottable.dialogs.components.PreviewCanvas;
import com.spss.pivottable.dialogs.table_properties.GeneralPreview;
import com.spss.pivottable.util.FileUtil;
import com.spss.shared.core_tools.format.CommonState;
import com.spss.shared.export.table_look.SysDefaultTableProperties;
import com.spss.shared.export.table_look.TableProperties;
import com.spss.uitools.dialogs.UIToolDialogUtil;
import com.spss.uitools.util.CharacterUtil;
import com.spss.uitools.util.IOptionConstants;
import com.spss.vis.specification.VisualizationSpecification;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.filechooser.FileFilter;

public class PivotTablesOptionPanel
extends OptionPanel {
    private SpssButtonGroup mButtonGrp;
    private JComboBox mEditingModeCombo;
    private JComboBox mWideTablesCombo;
    private FileTextField mFileText;
    private static String mFileTextNone = "None";
    private JButton mBrowseButton;
    private JButton mSetDirButton;
    private JList mTableLookList;
    private DefaultListModel mTableLookListModel;
    private JScrollPane mTableLookListScroller;
    private JRadioButton mLabelsRadio;
    private JRadioButton mLabelsDataRadio;
    private PreviewCanvas mCanvas;
    private String mCurrentTableLookPath;
    private String mLastTableLookPath;
    private JCheckBox mIncludeComment;
    private JLabel mCommentTextLbl;
    private JButton mTitleBtn;
    private JButton mProcedureBtn;
    private JButton mDateBtn;
    private JButton mDataSetBtn;
    private JTextArea mCommentTextArea;
    private JScrollPane mCommentTextAreaScrollPane;
    private String TITLE_SYNTAX = ")TITLE";
    private String PROCEDURE_SYNTAX = ")PROCEDURE";
    private String DATE_SYNTAX = ")DATE";
    private String DATASET_SYNTAX = ")DATASET";
    private String TITLE_UI = this.getResString("IDS_PIVOT_TABLE_TITLE_UI");
    private String PROCEDURE_UI = this.getResString("IDS_PIVOT_TABLE_PROCEDURE_UI");
    private String DATE_UI = this.getResString("IDS_PIVOT_TABLE_DATE_UI");
    private String DATASET_UI = this.getResString("IDS_PIVOT_TABLE_DATASET_UI");

    public PivotTablesOptionPanel(OptionsDlg optionsDlg, Preferences preferences, String string) {
        super(optionsDlg, preferences, string);
    }

    @Override
    public String getDialogHelpID() {
        return "idh_pref_pivot";
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        super.itemStateChanged(itemEvent);
        Object object = itemEvent.getSource();
        if (object == this.mIncludeComment) {
            this.setTableCommentEnableStatus(this.mIncludeComment.isSelected());
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.mBrowseButton) {
            int n;
            this.mTableLookList.removeListSelectionListener(this);
            RemoteFileChooser remoteFileChooser = new RemoteFileChooser(RemoteFileChooser.ChooserType.OpenFile, RemoteFileChooser.ChooserOption.Generic, null, false);
            remoteFileChooser.setDialogTitle(this.getResString("IDS_PIVOT_TABLES_OPEN_FILE_TITLE"));
            if (this.mCurrentTableLookPath != null) {
                remoteFileChooser.setCurrentDirectory(new File(this.mCurrentTableLookPath));
            }
            RefFileFilter refFileFilter = new RefFileFilter(this.getResString("IDS_PIVOT_TABLELOOK_FILE_FILTER"), this.getResString("IDS_TABLELOOK_FILES"));
            remoteFileChooser.addChoosableFileFilter((FileFilter)refFileFilter);
            remoteFileChooser.setAcceptAllFileFilterUsed(true);
            remoteFileChooser.setFileFilter((FileFilter)refFileFilter);
            if (!this.mFileText.getText().equals(this.getResString("IDS_PIVOT_TABLE_LOOK_SYSTEM_NONE"))) {
                remoteFileChooser.setCurrentDirectory(new File(this.mFileText.getText()));
            }
            if ((n = remoteFileChooser.showOpenDialog((Component)((Object)this.mOptionDialog))) == 0) {
                File file = remoteFileChooser.getCurrentDirectory();
                this.mLastTableLookPath = file.toString() + System.getProperty("file.separator");
                File file2 = new File(this.mLastTableLookPath + remoteFileChooser.getSelectedFile().getName());
                if (file2.exists()) {
                    String string = file2.getAbsolutePath();
                    this.mFileText.setText(string);
                    FilePack filePack = this.createTableLookFilePack(file2, false);
                    this.mTableLookListModel.addElement(filePack);
                    this.selectFilePack(filePack.getFile().getAbsolutePath());
                    this.mCanvas.setPreviewSpecification(filePack.mSampleVisSpec);
                    this.mCanvas.turnOnNeedRefreshScale();
                    this.mCanvas.repaint();
                }
            }
            this.mTableLookList.addListSelectionListener(this);
        } else if (object == this.mSetDirButton) {
            if (this.mLastTableLookPath != null) {
                this.mCurrentTableLookPath = this.mLastTableLookPath;
                FilePack filePack = (FilePack)this.mTableLookList.getSelectedValue();
                Vector<FilePack> vector = this.populateFileList(new File(this.mLastTableLookPath), false);
                this.mTableLookList.setListData(vector);
                if (filePack.getFile() != null) {
                    this.selectFilePack(filePack.getFile().getAbsolutePath());
                }
            }
        } else if (object == this.mTitleBtn) {
            int n = this.mCommentTextArea.getSelectionStart();
            String string = this.mCommentTextArea.getText();
            this.mCommentTextArea.setText(string.substring(0, n) + this.getResString("IDS_PIVOT_TABLE_TITLE") + ": " + this.getResString("IDS_PIVOT_TABLE_TITLE_UI") + string.substring(n));
            this.mCommentTextArea.requestFocus();
        } else if (object == this.mProcedureBtn) {
            int n = this.mCommentTextArea.getSelectionStart();
            String string = this.mCommentTextArea.getText();
            this.mCommentTextArea.setText(string.substring(0, n) + this.getResString("IDS_PIVOT_TABLE_PROCEDURE") + ": " + this.getResString("IDS_PIVOT_TABLE_PROCEDURE_UI") + string.substring(n));
            this.mCommentTextArea.requestFocus();
        } else if (object == this.mDateBtn) {
            int n = this.mCommentTextArea.getSelectionStart();
            String string = this.mCommentTextArea.getText();
            this.mCommentTextArea.setText(string.substring(0, n) + this.getResString("IDS_PIVOT_TABLE_DATE_CREATED") + ": " + this.getResString("IDS_PIVOT_TABLE_DATE_UI") + string.substring(n));
            this.mCommentTextArea.requestFocus();
        } else if (object == this.mDataSetBtn) {
            int n = this.mCommentTextArea.getSelectionStart();
            String string = this.mCommentTextArea.getText();
            this.mCommentTextArea.setText(string.substring(0, n) + this.getResString("IDS_PIVOT_TABLE_DATASET") + ": " + this.getResString("IDS_PIVOT_TABLE_DATASET_UI") + string.substring(n));
            this.mCommentTextArea.requestFocus();
        }
        super.actionPerformed(actionEvent);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        FilePack filePack;
        if (!listSelectionEvent.getValueIsAdjusting() && listSelectionEvent.getSource() == this.mTableLookList && (filePack = (FilePack)this.mTableLookList.getSelectedValue()) != null) {
            this.mFileText.setText(filePack.mFile == null ? this.getResString("IDS_PIVOT_TABLE_LOOK_SYSTEM_NONE") : filePack.mFile.getAbsolutePath());
            this.mCanvas.setPreviewSpecification(filePack.mSampleVisSpec);
            this.mCanvas.turnOnNeedRefreshScale();
            this.mCanvas.repaint();
        }
        super.valueChanged(listSelectionEvent);
    }

    @Override
    public void initPanel() {
        super.initPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = this.setupTableLookPanel();
        JPanel jPanel2 = this.setupSamplePanel();
        JPanel jPanel3 = this.setupAdjustColumnWidthsPanel();
        JPanel jPanel4 = this.setupEditingModePanel();
        JPanel jPanel5 = this.setupWideTablesPanel();
        JPanel jPanel6 = this.setupTableCommentPanel();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        int n = DialogUtil.getComponentGroupGap();
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(n2, 0, 0, 0);
        OptionsUtil.addUsingGBL(this, jPanel, gridBagConstraints, 0, 0, 1, 1, 23, insets);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridheight = CommonState.getApplicationType() != CommonState.AppType.MODELER && CommonState.getApplicationType() != CommonState.AppType.MODELERCLOUD ? 1 : 2;
        OptionsUtil.addUsingGBL(this, jPanel3, gridBagConstraints, 0, 1, 1, gridBagConstraints.gridheight, 23, insets);
        if (CommonState.getApplicationType() != CommonState.AppType.MODELER && CommonState.getApplicationType() != CommonState.AppType.MODELERCLOUD) {
            gridBagConstraints.fill = 2;
            OptionsUtil.addUsingGBL(this, jPanel6, gridBagConstraints, 0, 2, 1, 2, 23, insets);
        }
        insets.set(n, n, 0, 0);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        OptionsUtil.addUsingGBL(this, jPanel2, gridBagConstraints, 1, gridBagConstraints.gridy, 1, 1, 23, insets);
        ++gridBagConstraints.gridy;
        OptionsUtil.addUsingGBL(this, jPanel4, gridBagConstraints, 1, gridBagConstraints.gridy++, 1, 1, 23, insets);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        OptionsUtil.addUsingGBL(this, jPanel5, gridBagConstraints, 1, gridBagConstraints.gridy, 1, 1, 23, insets);
    }

    public boolean isValidPanel() {
        return true;
    }

    @Override
    public void doPostDisplayProcessing() {
        for (int i = 0; i < this.mTableLookListModel.size(); ++i) {
            FilePack filePack = (FilePack)this.mTableLookListModel.get(i);
            if (filePack.getFile() == null || filePack.mTableProperties != null) continue;
            filePack.delayedLoad();
        }
        FilePack filePack = (FilePack)this.mTableLookList.getSelectedValue();
        if (filePack != null) {
            this.mCanvas.setPreviewSpecification(filePack.mSampleVisSpec);
            this.mCanvas.turnOnNeedRefreshScale();
            this.mCanvas.repaint();
        }
        super.doPostDisplayProcessing();
    }

    @Override
    protected void initVars() {
        this.mLabelsRadio = DialogUtil.createRadioButton(this.mOptionDialog, "IDS_PIVOT_LABELS_LBLS", (ActionListener)this);
        this.mLabelsDataRadio = DialogUtil.createRadioButton(this.mOptionDialog, "IDS_PIVOT_LABELS_DATA_LBLS", (ActionListener)this);
        this.mButtonGrp = new SpssButtonGroup();
        this.mButtonGrp.add(this.mLabelsRadio);
        this.mButtonGrp.add(this.mLabelsDataRadio);
        this.mLabelsDataRadio.setSelected(true);
        this.mEditingModeCombo = new JComboBox<String>(this.getResStringArray("IDS_PIVOT_EDITING_MODE_COMBO_ITEMS"));
        this.mEditingModeCombo.setSelectedIndex(1);
        this.mWideTablesCombo = new JComboBox<String>(this.getResStringArray("IDS_PIVOT_WTABLES_COMBO_ITEMS"));
        this.mWideTablesCombo.setSelectedIndex(0);
        this.mBrowseButton = DialogUtil.createButton(this.mOptionDialog, "IDS_PIVOT_TABLE_LOOK_BROWSE", this);
        this.mFileText = new FileTextField();
        this.mFileText.setOpaque(false);
        this.mFileText.setEditable(false);
        this.mFileText.setColumns(20);
        this.mTableLookListModel = new DefaultListModel();
        this.mTableLookList = new JList(this.mTableLookListModel);
        this.mTableLookList.setSelectionMode(0);
        this.mTableLookList.setBorder(BorderFactory.createEtchedBorder());
        this.mTableLookList.setSelectedIndex(0);
        this.mTableLookList.setCellRenderer(new TableLookListCellRenderer());
        this.mTableLookList.setVisibleRowCount(8);
        this.mTableLookListScroller = new JScrollPane(this.mTableLookList);
        this.mTableLookListScroller.setVerticalScrollBarPolicy(20);
        this.mFileText.setText(this.getResString("IDS_PIVOT_TABLE_LOOK_SYSTEM_NONE"));
        this.mSetDirButton = DialogUtil.createButton(this.mOptionDialog, "IDS_PIVOT_TABLE_LOOK_SET_DIRECTORY", this);
        this.mLastTableLookPath = null;
        this.mCanvas = new PreviewCanvas();
        this.mIncludeComment = DialogUtil.createCheckBox(this.mOptionDialog, "IDS_PIVOT_TABLE_INCLUDE_COMMENT", null);
        this.mTitleBtn = DialogUtil.createButton(this.mOptionDialog, "IDS_PIVOT_TABLE_TITLE", this);
        this.mProcedureBtn = DialogUtil.createButton(this.mOptionDialog, "IDS_PIVOT_TABLE_PROCEDURE", this);
        this.mDateBtn = DialogUtil.createButton(this.mOptionDialog, "IDS_PIVOT_TABLE_DATE", this);
        this.mDataSetBtn = DialogUtil.createButton(this.mOptionDialog, "IDS_PIVOT_TABLE_DATASET", this);
        this.mCommentTextLbl = DialogUtil.createLabel(this.mOptionDialog, "IDS_PIVOT_TABLE_COMMENT_TEXT");
        this.mCommentTextArea = new JTextArea(4, 20);
        this.mCommentTextLbl.setLabelFor(this.mCommentTextArea);
        this.mCommentTextAreaScrollPane = new JScrollPane(this.mCommentTextArea);
        this.mCommentTextAreaScrollPane.setVerticalScrollBarPolicy(20);
        this.mCommentTextAreaScrollPane.setHorizontalScrollBarPolicy(30);
        this.mCommentTextAreaScrollPane.setPreferredSize(new Dimension(90, 60));
        this.mComponentOrder.add(this.mTableLookList);
        this.mComponentOrder.add(this.mBrowseButton);
        this.mComponentOrder.add(this.mSetDirButton);
        this.mComponentOrder.add(this.mButtonGrp);
        this.mComponentOrder.add(this.mIncludeComment);
        this.mComponentOrder.add(this.mCommentTextArea);
        this.mComponentOrder.add(this.mTitleBtn);
        this.mComponentOrder.add(this.mProcedureBtn);
        this.mComponentOrder.add(this.mDateBtn);
        this.mComponentOrder.add(this.mDataSetBtn);
        this.mComponentOrder.add(this.mEditingModeCombo);
        this.mComponentOrder.add(this.mWideTablesCombo);
        this.mComponentOrder.addAll(Arrays.asList(this.mOptionDialog.getCmdButtonPanel().getComponents()));
    }

    @Override
    protected void readPrefs() {
        Object object;
        Preferences preferences = this.mOptionsPrefs;
        String string = preferences.get("adj_col_widths", PrefDefaults.DEF_COL_WIDTH_ADJUST);
        int n = DialogUtil.getIndexOfItem(IOptionConstants.TABLES_COL_WIDTH_ADJUST_VALUES, string);
        DialogUtil.setSelectedButton(this.mButtonGrp, n > 1 ? 1 : n);
        string = preferences.get("editing_mode", PrefDefaults.DEF_EDITING_MODE);
        n = DialogUtil.getIndexOfItem(IOptionConstants.TABLES_EDITING_MODE_VALUES, string);
        this.mEditingModeCombo.setSelectedIndex(n);
        string = preferences.get("wide_tables", PrefDefaults.DEF_WIDE_TABLES);
        n = DialogUtil.getIndexOfItem(IOptionConstants.TABLES_COPY_WIDE_VALUES, string);
        this.mWideTablesCombo.setSelectedIndex(n);
        this.mCurrentTableLookPath = string = preferences.get("table_look_directory", SysDefaultTableProperties.TABLELOOK_DEFAULT_PATH);
        File file = new File(string);
        Vector<FilePack> vector = this.populateFileList(file, true);
        String string2 = preferences.get("table_look_path", mFileTextNone);
        if (string2.startsWith("'") && string2.endsWith("'")) {
            string2 = CharacterUtil.unSmartQuote((String)string2);
        }
        file = new File(string2);
        String string3 = this.mCurrentTableLookPath;
        if (string3.endsWith(File.separator)) {
            string3 = string3.substring(0, string3.length() - 1);
        }
        if (string2.equals(mFileTextNone)) {
            string2 = this.getResString("IDS_PIVOT_TABLE_LOOK_SYSTEM_NONE");
        } else if (file.exists() && !file.getParent().equals(string3) && ((String)(object = file.getName())).endsWith(this.getResString("IDS_TABLELOOK_FILES")) && !((String)object).equalsIgnoreCase("default.stt")) {
            vector.add(this.createTableLookFilePack(file, false));
            Collections.sort(vector);
        }
        this.mFileText.setText(string2);
        for (FilePack filePack : vector) {
            this.mTableLookListModel.addElement(filePack);
        }
        this.mIncludeComment.setSelected(preferences.getBoolean("include_comment", true));
        this.setTableCommentEnableStatus(this.mIncludeComment.isEnabled() && this.mIncludeComment.isSelected());
        object = preferences.get("comment_text", "");
        if (((String)object).length() > 2) {
            object = ((String)object).substring(1, ((String)object).length() - 1);
            object = ((String)object).replace(this.TITLE_SYNTAX, this.TITLE_UI);
            object = ((String)object).replace(this.PROCEDURE_SYNTAX, this.PROCEDURE_UI);
            object = ((String)object).replace(this.DATE_SYNTAX, this.DATE_UI);
            object = ((String)object).replace(this.DATASET_SYNTAX, this.DATASET_UI);
            this.mCommentTextArea.setText((String)object);
        }
        this.addListeners();
        this.selectFilePack(string2);
        this.mFileText.setBorder(BorderFactory.createEmptyBorder());
    }

    @Override
    protected void savePrefs() {
        Preferences preferences = this.mOptionsPrefs;
        if (this.mLabelsRadio.isEnabled() && this.mLabelsRadio.isSelected()) {
            preferences.put("adj_col_widths", IOptionConstants.TABLES_COL_WIDTH_ADJUST_VALUES[0]);
        } else {
            preferences.put("adj_col_widths", IOptionConstants.TABLES_COL_WIDTH_ADJUST_VALUES[1]);
        }
        preferences.put("editing_mode", IOptionConstants.TABLES_EDITING_MODE_VALUES[this.mEditingModeCombo.getSelectedIndex()]);
        preferences.put("wide_tables", IOptionConstants.TABLES_COPY_WIDE_VALUES[this.mWideTablesCombo.getSelectedIndex()]);
        String string = this.mFileText.getText();
        if (string.equals(this.getResString("IDS_PIVOT_TABLE_LOOK_SYSTEM_NONE"))) {
            string = mFileTextNone;
        }
        preferences.put("table_look_path", string);
        if (this.mCurrentTableLookPath != null) {
            preferences.put("table_look_directory", this.mCurrentTableLookPath);
        }
        if (this.mIncludeComment.isEnabled() && this.mIncludeComment.isSelected()) {
            preferences.putBoolean("include_comment", true);
        } else {
            preferences.putBoolean("include_comment", false);
        }
        String string2 = this.mCommentTextArea.getText();
        string2 = string2.replace(this.TITLE_UI, this.TITLE_SYNTAX);
        string2 = string2.replace(this.PROCEDURE_UI, this.PROCEDURE_SYNTAX);
        string2 = string2.replace(this.DATE_UI, this.DATE_SYNTAX);
        string2 = string2.replace(this.DATASET_UI, this.DATASET_SYNTAX);
        preferences.put("comment_text", "'" + string2 + "'");
    }

    @Override
    protected int getId() {
        return 4;
    }

    private void selectFilePack(String string) {
        boolean bl = false;
        File file = new File(string);
        ListModel listModel = this.mTableLookList.getModel();
        if (listModel instanceof AbstractListModel) {
            AbstractListModel abstractListModel = (AbstractListModel)listModel;
            for (int i = 0; i < abstractListModel.getSize(); ++i) {
                FilePack filePack = (FilePack)abstractListModel.getElementAt(i);
                if (filePack == null || filePack.getFile() == null || !filePack.getFile().equals(file)) continue;
                this.mTableLookList.setSelectedValue(filePack, true);
                bl = true;
                break;
            }
        }
        if (!bl) {
            this.mTableLookList.setSelectedIndex(0);
        }
    }

    private JPanel setupAdjustColumnWidthsPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_PIVOT_ADJUST_WIDTHS_PANEL")));
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        gridBagConstraints.weighty = 0.0;
        Insets insets = DialogUtil.getStandardControlInsets();
        OptionsUtil.addUsingGBL(jPanel, this.mLabelsRadio, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        OptionsUtil.addUsingGBL(jPanel, this.mLabelsDataRadio, gridBagConstraints, 0, 1, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel setupEditingModePanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        JLabel jLabel = DialogUtil.createLabel(this.mOptionDialog, "IDS_PIVOT_DEFAULT_EDITING_MODE_PANEL");
        jLabel.setLabelFor(this.mEditingModeCombo);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = new Insets(insets.top, 0, insets.bottom, n2 * 8);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        OptionsUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        insets2.set(n2 / 2, 0, n2 / 2, n2 * 8);
        OptionsUtil.addUsingGBL(jPanel, this.mEditingModeCombo, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        return jPanel;
    }

    private JPanel setupWideTablesPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        JLabel jLabel = DialogUtil.createLabel(this.mOptionDialog, "IDS_PIVOT_WTABLES_LBL");
        jLabel.setLabelFor(this.mWideTablesCombo);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets2 = new Insets(insets.top, 0, insets.bottom, n2 * 8);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        OptionsUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        insets2.set(n2 / 2, 0, insets.bottom, n2 * 8);
        OptionsUtil.addUsingGBL(jPanel, this.mWideTablesCombo, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        return jPanel;
    }

    private JPanel setupTableLookPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        JLabel jLabel = DialogUtil.createLabel(this.mOptionDialog, "IDS_PIVOT_TABLE_LOOK_PANEL");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        gridBagConstraints.weightx = 1.0;
        Insets insets = new Insets(0, n2, 0, n2);
        gridBagConstraints.fill = 2;
        OptionsUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mFileText), gridBagConstraints, 0, 0, 2, 1, n, insets);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        insets.set(n2, n2, 0, n2);
        OptionsUtil.addUsingGBL(jPanel, this.mTableLookListScroller, gridBagConstraints, 0, 1, 2, 1, n, insets);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weighty = 0.0;
        OptionsUtil.addUsingGBL(jPanel, this.mBrowseButton, gridBagConstraints, 0, 2, 1, 1, 24, insets);
        gridBagConstraints.weighty = 0.0;
        insets.set(n2, n2, n2, n2);
        OptionsUtil.addUsingGBL(jPanel, this.mSetDirButton, gridBagConstraints, 1, 2, 1, 1, 24, insets);
        jLabel.setLabelFor(this.mTableLookList);
        return OptionsUtil.setupControlOnBorder(jPanel, jLabel);
    }

    private JPanel setupSamplePanel() {
        return PTBaseDialog.createSamplePanel((String)this.getResString("IDS_PIVOT_SAMPLE_PANEL"), (PreviewCanvas)this.mCanvas, null, (Dimension)new Dimension(350, 250));
    }

    private JPanel setupTableCommentPanel() {
        JPanel jPanel = PanelFactory.getEmptyPanel(this.getResString("IDS_PIVOT_TABLE_TABLE_COMMENT"));
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        int n2 = DialogUtil.getComponentGroupGap();
        Insets insets = new Insets(0, n2, 0, n2);
        OptionsUtil.addUsingGBL(jPanel, this.mIncludeComment, gridBagConstraints, 0, 0, 2, 1, n, insets);
        insets = new Insets(0, 3 * n2, 0, n2);
        OptionsUtil.addUsingGBL(jPanel, this.mCommentTextLbl, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        OptionsUtil.addUsingGBL(jPanel, this.mCommentTextAreaScrollPane, gridBagConstraints, 0, 2, 1, 1, n, insets);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        JPanel jPanel2 = PanelFactory.getEmptyPanel("");
        jPanel2.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        jPanel2.setLayout(new FlowLayout(2, 3, 0));
        jPanel2.add(this.mTitleBtn);
        jPanel2.add(this.mProcedureBtn);
        jPanel2.add(this.mDateBtn);
        jPanel2.add(this.mDataSetBtn);
        UIToolDialogUtil.normalizeButtonWidths((JPanel)jPanel2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        OptionsUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 3, 1, 1, 24, new Insets(2, n2, 0, 3));
        return jPanel;
    }

    private void addListeners() {
        this.mLabelsRadio.addItemListener(this);
        this.mLabelsDataRadio.addItemListener(this);
        this.mEditingModeCombo.addActionListener(this);
        this.mWideTablesCombo.addActionListener(this);
        this.mTableLookList.addListSelectionListener(this);
        this.mTableLookList.addFocusListener(this);
        this.mIncludeComment.addItemListener(this);
        this.mCommentTextArea.getDocument().addDocumentListener(this);
        this.mTitleBtn.addItemListener(this);
        this.mProcedureBtn.addItemListener(this);
        this.mDateBtn.addItemListener(this);
        this.mDataSetBtn.addItemListener(this);
    }

    private Vector<FilePack> populateFileList(File file, boolean bl) {
        Vector<FilePack> vector = new Vector<FilePack>();
        File[] fileArray = file.listFiles();
        Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs().node("options").node("tables");
        String string = preferences.get("table_look_directory", SysDefaultTableProperties.TABLELOOK_DEFAULT_PATH);
        TableProperties tableProperties = SysDefaultTableProperties.getSysDefaultTableProperties((String)string);
        VisualizationSpecification visualizationSpecification = GeneralPreview.createPreviewSpec();
        if (tableProperties != null) {
            tableProperties.applyTableLook(visualizationSpecification);
        }
        vector.add(new FilePack(null, tableProperties, visualizationSpecification));
        if (fileArray != null) {
            for (File file2 : fileArray) {
                String string2 = file2.getName();
                if (!string2.endsWith(this.getResString("IDS_TABLELOOK_FILES")) || string2.equalsIgnoreCase("default.stt")) continue;
                if (string2.equalsIgnoreCase("Original.stt")) {
                    vector.insertElementAt(this.createTableLookFilePack(file2, bl), 1);
                    continue;
                }
                vector.add(this.createTableLookFilePack(file2, bl));
            }
        }
        return vector;
    }

    private FilePack createTableLookFilePack(File file, boolean bl) {
        FilePack filePack = null;
        if (bl) {
            filePack = new FilePack(file);
        } else {
            TableProperties tableProperties = TableProperties.createTableProp((File)file);
            if (tableProperties != null) {
                VisualizationSpecification visualizationSpecification = GeneralPreview.createPreviewSpec();
                tableProperties.applyTableLook(visualizationSpecification);
                filePack = new FilePack(file, tableProperties, visualizationSpecification);
            }
        }
        return filePack;
    }

    private void setTableCommentEnableStatus(boolean bl) {
        this.mTitleBtn.setEnabled(bl);
        this.mProcedureBtn.setEnabled(bl);
        this.mDateBtn.setEnabled(bl);
        this.mDataSetBtn.setEnabled(bl);
        this.mCommentTextLbl.setEnabled(bl);
        this.mCommentTextArea.setEnabled(bl);
    }

    class TableLookListCellRenderer
    extends JLabel
    implements ListCellRenderer {
        private Border mEmptyBorder = new EmptyBorder(1, 1, 1, 1);

        TableLookListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (ComponentState.isBtdRtlOrLtr() && object != null && object instanceof String && ((String)object).length() > 0) {
                super.setText(ComponentState.prepareStringForBidiRendering((String)object.toString()));
            } else {
                super.setText(object.toString());
            }
            this.setOpaque(true);
            if (bl) {
                if (jList.hasFocus()) {
                    this.setForeground(jList.getSelectionForeground());
                    this.setBackground(jList.getSelectionBackground());
                } else {
                    this.setForeground(Color.black);
                    this.setBackground(Color.lightGray);
                }
            } else {
                this.setForeground(jList.getForeground());
                this.setBackground(jList.getBackground());
            }
            Border border = null;
            if (bl2) {
                if (bl) {
                    border = UIManager.getBorder("List.focusSelectedCellHighlightBorder");
                }
                if (border == null) {
                    border = UIManager.getBorder("List.focusCellHighlightBorder");
                }
            } else {
                border = this.mEmptyBorder;
            }
            this.setBorder(border);
            return this;
        }
    }

    class FilePack
    implements Comparable<FilePack> {
        String mName;
        File mFile;
        TableProperties mTableProperties;
        VisualizationSpecification mSampleVisSpec;

        public FilePack(File file) {
            this(file, null, null);
        }

        public FilePack(File file, TableProperties tableProperties, VisualizationSpecification visualizationSpecification) {
            this.mFile = file;
            this.mTableProperties = tableProperties;
            this.mSampleVisSpec = visualizationSpecification;
            this.mName = this.mFile == null ? PivotTablesOptionPanel.this.getResString("IDS_PIVOT_TABLE_LOOK_SYSTEM_DEFAULT") : (this.mFile.getName().equalsIgnoreCase("Original.stt") ? PivotTablesOptionPanel.this.getResString("IDS_PIVOT_TABLE_LOOK_CLASSIC_DEFAULT") : FileUtil.getFileNameWithoutExtension((File)this.mFile));
        }

        public void delayedLoad() {
            TableProperties tableProperties = TableProperties.createTableProp((File)this.mFile);
            if (tableProperties != null) {
                VisualizationSpecification visualizationSpecification = GeneralPreview.createPreviewSpec();
                tableProperties.applyTableLook(visualizationSpecification);
                this.mTableProperties = tableProperties;
                this.mSampleVisSpec = visualizationSpecification;
            }
        }

        public File getFile() {
            return this.mFile;
        }

        public String toString() {
            return this.mName;
        }

        @Override
        public int compareTo(FilePack filePack) {
            if (this.getFile() == null) {
                return -1;
            }
            if (filePack.getFile() == null) {
                return 1;
            }
            return this.getFile().getName().compareTo(filePack.getFile().getName());
        }

        public boolean equals(Object object) {
            if (object instanceof FilePack) {
                FilePack filePack = (FilePack)object;
                return this.getFile() != null && filePack.getFile() != null && this.getFile().getPath().equals(filePack.getFile().getPath());
            }
            return false;
        }
    }
}

