/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.edit;

import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.documents.data.VarNameValidator;
import com.spss.java_client.ui.controls.FixedLengthNumericDocument;
import com.spss.java_client.ui.controls.StringTextField;
import com.spss.java_client.ui.dialogs.base.edit.res.EditResBundle;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.controls.IntTextField;
import com.spss.uitools.controls.NumberSpinner;
import com.spss.uitools.dialogs.BaseDialog;
import com.spss.uitools.help.StatsHelp;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;
import javax.swing.text.Document;

public class PasteVariablesDlg
extends BaseDialog {
    private GridBagConstraints mConstraints;
    private Insets mInsets;
    private IntTextField mNumberSpinnerTextField;
    private StringTextField mVarNameTextField;
    private IntTextField mNameSpinnerTextField;
    private boolean mIsOkPressed;
    private DataModel mDataModel;

    public PasteVariablesDlg(SpssFrame spssFrame) {
        super((JFrame)spssFrame, true, ResUtil.getBundle(EditResBundle.getDefaultResourceBundleName(), ResUtil.getLocale()), EditResBundle.getImageFolder());
        this.setTitle(this.getResString("IDS_PASTE_VARIABLES_TITLE"));
        this.setLocationRelativeTo(this.getParent());
    }

    public void doHelp() {
        StatsHelp.getStatsHelp().showHelp(StatsHelp.Book.BASE, this.getDialogHelpID());
    }

    public String getDialogHelpID() {
        return "idh_idd_pastevars";
    }

    public StringTextField getVariableNameTextField() {
        return this.mVarNameTextField;
    }

    public boolean isOkPressed() {
        return this.mIsOkPressed;
    }

    public DataModel getData() {
        return this.mDataModel;
    }

    public IntTextField getNumberOfVarsCreated() {
        return this.mNumberSpinnerTextField;
    }

    protected JPanel setupCmdButtonPanel() {
        JPanel jPanel = new JPanel(true);
        Insets insets = DialogUtil.getStandardButtonInsets();
        jPanel.setBorder(new EmptyBorder(DialogUtil.getMainButtonGap(), 0, 0, 0));
        JButton jButton = new JButton(new OkAction());
        JButton jButton2 = new JButton(new CancelAction());
        JButton jButton3 = new JButton(new HelpAction());
        DialogUtil.setupMacHelpButton(jButton3);
        int n = insets.left + insets.right;
        if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
            jPanel.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            Insets insets2 = new Insets(0, n, 0, 0);
            int n2 = 23;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 2;
            DialogUtil.addUsingGBL(jPanel, jButton3, gridBagConstraints, 0, 0, 1, 1, n2, null);
            n2 = 24;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 0;
            DialogUtil.addUsingGBL(jPanel, jButton2, gridBagConstraints, 1, 0, 1, 1, n2, insets2);
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 0.0;
            DialogUtil.addUsingGBL(jPanel, jButton, gridBagConstraints, 2, 0, 1, 1, n2, insets2);
        } else {
            FlowLayout flowLayout = new FlowLayout(1, n, 0);
            jPanel.setLayout(flowLayout);
            jPanel.add(jButton);
            jPanel.add(jButton2);
            jPanel.add(jButton3);
        }
        this.getRootPane().setDefaultButton(jButton);
        DialogUtil.createCmdButtonGroup(jPanel);
        return jPanel;
    }

    protected void init() {
        super.init();
        JPanel jPanel = this.getViewPanel();
        this.initVars();
        this.setupUI(jPanel);
        this.setTabTraversal();
        this.setDefaults();
        this.pack();
    }

    private boolean isValidVarName() {
        boolean bl = true;
        String string = this.mVarNameTextField.getText();
        int n = VarNameValidator.validateSPSSName((String)string, (boolean)true).asInt();
        if (n != 100 && !(bl = DialogUtil.showBadSpssVarNameWarning(n, this))) {
            this.mVarNameTextField.requestFocus();
            this.mVarNameTextField.selectAll();
        }
        return bl;
    }

    private boolean isTextFieldsEmpty() {
        boolean bl = true;
        if (this.mNumberSpinnerTextField.getText().equals("")) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_NUMBERFORMAT"), VersionInfo.getAppVersionString());
            this.mNumberSpinnerTextField.requestFocus();
            bl = false;
        } else if (this.mNameSpinnerTextField.getText().equals("")) {
            SpssAlertOptionPane.showWarningMessageDialog((Window)((Object)this), this.getResString("ERR_NUMBERFORMAT"), VersionInfo.getAppVersionString());
            this.mNameSpinnerTextField.requestFocus();
            bl = false;
        }
        return bl;
    }

    private void setDefaults() {
        this.mNumberSpinnerTextField.requestFocus();
        this.mNumberSpinnerTextField.selectAll();
    }

    private void setTabTraversal() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this.mNumberSpinnerTextField);
        vector.add(this.mVarNameTextField);
        vector.add(this.mNameSpinnerTextField);
        Component[] componentArray = this.mCmdButtonPanel.getComponents();
        vector.addAll(Arrays.asList(componentArray));
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(vector, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
    }

    private void initVars() {
        this.mConstraints = new GridBagConstraints();
        this.mInsets = new Insets(0, 0, 0, 0);
        this.mNumberSpinnerTextField = new IntTextField(1, 9999);
        this.mNumberSpinnerTextField.setDocument((Document)new FixedLengthNumericDocument(4, true, false));
        this.mVarNameTextField = new StringTextField(10);
        this.mNameSpinnerTextField = new IntTextField(0, 9999);
        this.mNameSpinnerTextField.setDocument((Document)new FixedLengthNumericDocument(4, true, false));
    }

    private void setupUI(JPanel jPanel) {
        int n = 18;
        JPanel jPanel2 = this.setupNumberOfVariablesPanel();
        JPanel jPanel3 = this.setupVariableNamesPanel();
        this.mConstraints.fill = 2;
        this.mConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, jPanel2, this.mConstraints, 0, 0, 1, 1, n, null);
        this.mConstraints.weighty = 1.0;
        DialogUtil.addUsingGBL(jPanel, jPanel3, this.mConstraints, 0, 1, 1, 1, n, null);
    }

    private JPanel setupNumberOfVariablesPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_PASTE_VARIABLES_NO_OF_VARIABLES");
        jLabel.setLabelFor((Component)this.mNumberSpinnerTextField);
        int n = 18;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = DialogUtil.getStandardControlInsets();
        this.mInsets.set(n2, n2, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jLabel, this.mConstraints, 0, 0, 1, 1, n, this.mInsets);
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(1, 1, 9999, 1);
        NumberSpinner numberSpinner = new NumberSpinner(this.mNumberSpinnerTextField, spinnerNumberModel);
        this.mInsets.set(n2, insets.left, 0, n2);
        this.mConstraints.weightx = 1.0;
        DialogUtil.addUsingGBL(jPanel, (JComponent)numberSpinner, this.mConstraints, 1, 0, 1, 1, n, this.mInsets);
        return jPanel;
    }

    private JPanel setupVariableNamesPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        JLabel jLabel = DialogUtil.createLabel(this, "IDS_PASTE_VARIABLES_VARIABLE_NAME");
        jLabel.setLabelFor((Component)((Object)this.mVarNameTextField));
        int n = 18;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        int n3 = n2 + n2;
        Insets insets = DialogUtil.getStandardControlInsets();
        this.mConstraints.weightx = 0.0;
        this.mInsets.set(n3, n2, 0, 0);
        DialogUtil.addUsingGBL(jPanel, jLabel, this.mConstraints, 0, 0, 1, 1, n, this.mInsets);
        this.mConstraints.weightx = 1.0;
        this.mConstraints.fill = 1;
        this.mInsets.set(n3, insets.left, 0, 0);
        DialogUtil.addUsingGBL(jPanel, (JComponent)((Object)this.mVarNameTextField), this.mConstraints, 1, 0, 1, 1, n, this.mInsets);
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(1, 0, 9999, 1);
        NumberSpinner numberSpinner = new NumberSpinner(this.mNameSpinnerTextField, spinnerNumberModel);
        this.mConstraints.weightx = 0.0;
        this.mConstraints.fill = 0;
        this.mInsets.set(n3, n2, 0, n2);
        DialogUtil.addUsingGBL(jPanel, (JComponent)numberSpinner, this.mConstraints, 2, 0, 1, 1, n, this.mInsets);
        return jPanel;
    }

    public class DataModel {
        private String mVarName;
        private int mSuffixNo;
        private int mNoOfVariables;

        private DataModel(String string, int n, int n2) {
            this.mVarName = string;
            this.mSuffixNo = n;
            this.mNoOfVariables = n2;
        }

        public String getVarName() {
            return this.mVarName;
        }

        public int getVariableSuffix() {
            return this.mSuffixNo;
        }

        public int getNoOfVariablesToCreate() {
            return this.mNoOfVariables;
        }
    }

    private class HelpAction
    extends AbstractAction {
        HelpAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_HELP"));
            this.putValue("AcceleratorKey", 112);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PasteVariablesDlg.this.doHelp();
        }
    }

    private class OkAction
    extends AbstractAction {
        OkAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_OK"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (PasteVariablesDlg.this.isValidVarName() && PasteVariablesDlg.this.isTextFieldsEmpty()) {
                PasteVariablesDlg.this.mIsOkPressed = true;
                String string = PasteVariablesDlg.this.mVarNameTextField.getText();
                int n = Integer.parseInt(PasteVariablesDlg.this.mNameSpinnerTextField.getText());
                int n2 = Integer.parseInt(PasteVariablesDlg.this.mNumberSpinnerTextField.getText());
                PasteVariablesDlg.this.mDataModel = new DataModel(string, n, n2);
                PasteVariablesDlg.this.dispose();
            }
        }
    }

    private class CancelAction
    extends AbstractAction {
        CancelAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_CANCEL"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PasteVariablesDlg.this.dispose();
        }
    }
}

