/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.edit;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.common.prefs.ExecStartupPreferences;
import com.spss.java_client.core.common.prefs.PrefsMgr;
import com.spss.java_client.ui.SpssFrameMgr;
import com.spss.java_client.ui.SpssMgr;
import com.spss.java_client.ui.controlbar.ToolbarObject;
import com.spss.java_client.ui.controlbar.ToolbarsUtil;
import com.spss.java_client.ui.dialogs.base.edit.ChartsOptionPanel;
import com.spss.java_client.ui.dialogs.base.edit.CurrencyOptionPanel;
import com.spss.java_client.ui.dialogs.base.edit.DataOptionPanel;
import com.spss.java_client.ui.dialogs.base.edit.FileLocationsOptionPanel;
import com.spss.java_client.ui.dialogs.base.edit.GeneralOptionPanel;
import com.spss.java_client.ui.dialogs.base.edit.LanguageOptionPanel;
import com.spss.java_client.ui.dialogs.base.edit.MultipleImputationsOptionPanel;
import com.spss.java_client.ui.dialogs.base.edit.OptionPanel;
import com.spss.java_client.ui.dialogs.base.edit.OptionsUtil;
import com.spss.java_client.ui.dialogs.base.edit.OutputLabelsOptionPanel;
import com.spss.java_client.ui.dialogs.base.edit.PivotTablesOptionPanel;
import com.spss.java_client.ui.dialogs.base.edit.ScriptsOptionPanel;
import com.spss.java_client.ui.dialogs.base.edit.SyntaxOptionPanel;
import com.spss.java_client.ui.dialogs.base.edit.ViewerOptionPanel;
import com.spss.java_client.ui.dialogs.base.edit.res.EditResBundle;
import com.spss.java_client.ui.dialogs.common.DialogFocusTraversalPolicy;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.ProcedureDlgMgr;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.doc_types.syntax.SyntaxFrame;
import com.spss.java_client.ui.laf.LookAndFeelManager;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.shared.core_tools.format.CommonState;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.shared.syntaxeditor.shared_objects.SyntaxEditorState;
import com.spss.uitools.dialogs.BaseDialog;
import com.spss.uitools.help.StatsHelp;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class OptionsDlg
extends BaseDialog
implements ChangeListener {
    public static Hashtable<Object, String> sConfirmDialogs = new Hashtable();
    public static Hashtable<Object, String> sMessagesDialogs = new Hashtable();
    public static Hashtable<Object, String> sErrorMessagesDialogs = new Hashtable();
    public static Component sLastSelectedTab;
    private static int sLastTabSelectedIndex;
    private GeneralOptionPanel mGeneralPanel;
    private LanguageOptionPanel mLangPanel;
    private DataOptionPanel mDataPanel;
    private ChartsOptionPanel mChartsPanel;
    private PivotTablesOptionPanel mPivotTablesPanel;
    private ScriptsOptionPanel mScriptsPanel;
    private Preferences mOptionsPrefs;
    private ApplyAction mApplyAction;
    private JTabbedPane mTabbedPane;
    private static boolean mInvalidField;

    public OptionsDlg(Window window) {
        super(window, true, ResUtil.getBundle(EditResBundle.getDefaultResourceBundleName(), ResUtil.getLocale()), EditResBundle.getImageFolder());
        Point point;
        this.setTitle(this.getResString("IDS_TITLE"));
        Dimension dimension = ProcedureDlgMgr.getMgr().getDialogSize("edit_options");
        if (dimension != null) {
            this.setSize(dimension);
        }
        if ((point = ProcedureDlgMgr.getMgr().getDialogLocation("edit_options")) != null) {
            this.setLocation(point);
        } else {
            this.setLocationRelativeTo(window);
        }
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                OptionsDlg.this.cleanStaticVariables();
                super.windowClosing(windowEvent);
            }
        });
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        int n = this.mTabbedPane.getSelectedIndex();
        OptionPanel optionPanel = OptionPanel.sOptionTabsList.get(n);
        if (!optionPanel.isPanelInitialized() || !optionPanel.isPostDisplayProcessing()) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            if (!optionPanel.isPanelInitialized()) {
                optionPanel.initPanel();
            }
            if (!optionPanel.isPostDisplayProcessing()) {
                this.doPostDisplayTasksOnThread(optionPanel);
            }
            this.setCursor(null);
        }
        this.mTabbedPane.getSelectedComponent().setEnabled(true);
        this.mTabbedPane.getSelectedComponent().setFocusable(true);
        Vector<Object> vector = optionPanel.mComponentOrder;
        if (!vector.contains(this.mTabbedPane)) {
            vector.add(this.mTabbedPane);
        }
        DialogFocusTraversalPolicy dialogFocusTraversalPolicy = new DialogFocusTraversalPolicy(optionPanel.mComponentOrder, false);
        this.setFocusTraversalPolicy(dialogFocusTraversalPolicy);
        sLastSelectedTab = this.mTabbedPane.getSelectedComponent();
    }

    public void dispose() {
        this.cleanStaticVariables();
        super.dispose();
    }

    public void enableApplyAction(boolean bl) {
        if (OptionPanel.sEnableApplyButton) {
            this.mApplyAction.setEnabled(bl);
        }
    }

    public JPanel getCmdButtonPanel() {
        return this.mCmdButtonPanel;
    }

    public void doHelp() {
        OptionPanel optionPanel = (OptionPanel)this.mTabbedPane.getComponentAt(this.mTabbedPane.getSelectedIndex());
        StatsHelp.getStatsHelp().showHelp(StatsHelp.Book.BASE, optionPanel.getDialogHelpID());
    }

    protected void init() {
        super.init();
        this.mOptionsPrefs = PrefsMgr.getPrefsMgr().getUIUserPrefs().node("options");
        JPanel jPanel = this.getViewPanel();
        this.setupTabs(jPanel);
        if (sLastTabSelectedIndex == -1) {
            sLastTabSelectedIndex = 0;
        }
        this.mTabbedPane.setSelectedIndex(sLastTabSelectedIndex);
        this.pack();
    }

    protected JPanel setupCmdButtonPanel() {
        JPanel jPanel = new JPanel();
        Insets insets = DialogUtil.getStandardButtonInsets();
        jPanel.setBorder(new EmptyBorder(DialogUtil.getMainButtonGap(), 0, 0, 0));
        int n = insets.left + insets.right;
        OkAction okAction = new OkAction();
        CancelAction cancelAction = new CancelAction();
        this.mApplyAction = new ApplyAction();
        this.mApplyAction.setEnabled(false);
        HelpAction helpAction = new HelpAction();
        JButton jButton = new JButton(okAction);
        JButton jButton2 = new JButton(cancelAction);
        JButton jButton3 = new JButton(this.mApplyAction);
        JButton jButton4 = new JButton(helpAction);
        DialogUtil.setupMacHelpButton(jButton4);
        if (OSInfo.getOSType() == OSInfo.OSType.MAC) {
            jPanel.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            Insets insets2 = new Insets(0, n, 0, 0);
            int n2 = 23;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 2;
            DialogUtil.addUsingGBL(jPanel, jButton4, gridBagConstraints, 0, 0, 1, 1, n2, null);
            DialogUtil.addUsingGBL(jPanel, jButton3, gridBagConstraints, 1, 0, 1, 1, n2, insets2);
            n2 = 24;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 0;
            DialogUtil.addUsingGBL(jPanel, jButton2, gridBagConstraints, 2, 0, 1, 1, n2, insets2);
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 0.0;
            DialogUtil.addUsingGBL(jPanel, jButton, gridBagConstraints, 3, 0, 1, 1, n2, insets2);
        } else {
            FlowLayout flowLayout = new FlowLayout(1, n, 0);
            jPanel.setLayout(flowLayout);
            jPanel.add(jButton);
            jPanel.add(jButton2);
            jPanel.add(jButton3);
            jPanel.add(jButton4);
        }
        this.getRootPane().setDefaultButton(jButton);
        DialogUtil.createCmdButtonGroup(jPanel);
        return jPanel;
    }

    private void cleanStaticVariables() {
        OptionPanel.sOptionTabsList.clear();
        sConfirmDialogs.clear();
        sMessagesDialogs.clear();
        sErrorMessagesDialogs.clear();
    }

    private boolean canSwitchTab() {
        boolean bl = true;
        if (this.mDataPanel != null && sLastSelectedTab == this.mDataPanel && !this.mDataPanel.handleFocus()) {
            return false;
        }
        if (this.mChartsPanel != null && sLastSelectedTab == this.mChartsPanel && !this.mChartsPanel.handleFocus()) {
            return false;
        }
        if (this.mPivotTablesPanel != null && sLastSelectedTab == this.mPivotTablesPanel && !this.mPivotTablesPanel.isValidPanel()) {
            return false;
        }
        if (this.mScriptsPanel != null && sLastSelectedTab == this.mScriptsPanel && !this.mScriptsPanel.isValidPanel()) {
            return false;
        }
        Iterator<Object> iterator = sErrorMessagesDialogs.keySet().iterator();
        while (iterator.hasNext() && sLastSelectedTab != null) {
            bl = false;
            Object object = iterator.next();
            ComponentState.trace1((String)"inside err", (int)15);
            SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this), sErrorMessagesDialogs.get(object), VersionInfo.getAppVersionString());
            if (object instanceof JSpinner) {
                ((JSpinner)object).getEditor().requestFocus();
                ((JTextField)((JSpinner)object).getEditor()).selectAll();
                continue;
            }
            if (object instanceof JTextField) {
                ((JTextField)object).requestFocusInWindow();
                ((JTextField)object).selectAll();
                continue;
            }
            if (object instanceof JComboBox) {
                ((JComboBox)object).requestFocusInWindow();
                ((JComboBox)object).getEditor().selectAll();
                continue;
            }
            ((JComponent)object).requestFocusInWindow();
        }
        return bl;
    }

    private void resetOptionsChangedFlag() {
        for (OptionPanel optionPanel : OptionPanel.sOptionTabsList) {
            optionPanel.setOptionsChanged(false);
        }
    }

    private void setupTabs(JPanel jPanel) {
        this.mTabbedPane = new JTabbedPane(){

            @Override
            public void setSelectedIndex(int n) {
                if (OptionsDlg.this.canSwitchTab()) {
                    super.setSelectedIndex(n);
                }
            }
        };
        this.mTabbedPane.setFocusable(true);
        this.mTabbedPane.addChangeListener(this);
        FocusAdapter focusAdapter = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                OptionsDlg.this.mTabbedPane.repaint();
            }
        };
        this.mTabbedPane.addFocusListener(focusAdapter);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                OptionsDlg.this.mTabbedPane.requestFocusInWindow();
            }
        };
        this.mTabbedPane.addMouseListener(mouseAdapter);
        this.mTabbedPane.setTabLayoutPolicy(0);
        this.addGeneralOptions(this.mTabbedPane, "IDS_TAB_GENERAL");
        if (CommonState.getApplicationType() != CommonState.AppType.MODELER && CommonState.getApplicationType() != CommonState.AppType.MODELERCLOUD) {
            this.addLanguageOptions(this.mTabbedPane, "IDS_TAB_LANGUAGE");
        }
        this.addViewerOptions(this.mTabbedPane, "IDS_TAB_VIEWER");
        if (CommonState.getApplicationType() != CommonState.AppType.MODELER && CommonState.getApplicationType() != CommonState.AppType.MODELERCLOUD) {
            this.addDataOptions(this.mTabbedPane, "IDS_TAB_DATA");
            this.addCurrencyOptions(this.mTabbedPane, "IDS_TAB_CURRENCY");
        }
        this.addOuputLabelsOptions(this.mTabbedPane, "IDS_TAB_OUTPUT_LABELS");
        if (CommonState.getApplicationType() != CommonState.AppType.MODELER && CommonState.getApplicationType() != CommonState.AppType.MODELERCLOUD) {
            this.addChartsOptions(this.mTabbedPane, "IDS_TAB_CHARTS");
        }
        this.addPivotTablesOptions(this.mTabbedPane, "IDS_TAB_PIVOT_TABLES");
        if (CommonState.getApplicationType() != CommonState.AppType.MODELER && CommonState.getApplicationType() != CommonState.AppType.MODELERCLOUD) {
            this.addFileLocationsOptions(this.mTabbedPane, "IDS_TAB_FILE_LOCATIONS");
            if (VersionInfo.allowScripting()) {
                this.addScriptsOptions(this.mTabbedPane, "IDS_TAB_SCRIPTS");
            }
            if (VersionInfo.allowMultipleImputation()) {
                this.addMultipleImputationsOptions(this.mTabbedPane, "IDS_TAB_MULTIPLE_IMPUTATIONS");
            }
            if (VersionInfo.allowSyntax()) {
                this.addSyntaxEditorOptions(this.mTabbedPane, "IDS_TAB_SYNTAX");
            }
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        int n = 23;
        OptionsUtil.addUsingGBL(jPanel, this.mTabbedPane, gridBagConstraints, 0, 0, 1, 1, n, null);
    }

    private void addGeneralOptions(JTabbedPane jTabbedPane, String string) {
        this.mGeneralPanel = new GeneralOptionPanel(this, this.mOptionsPrefs, "general");
        jTabbedPane.add(this.getResString(string), this.mGeneralPanel);
        sLastSelectedTab = this.mGeneralPanel;
    }

    private void addLanguageOptions(JTabbedPane jTabbedPane, String string) {
        this.mLangPanel = new LanguageOptionPanel(this, this.mOptionsPrefs, "general");
        jTabbedPane.add(this.getResString(string), this.mLangPanel);
        sLastSelectedTab = this.mLangPanel;
    }

    private void addViewerOptions(JTabbedPane jTabbedPane, String string) {
        ViewerOptionPanel viewerOptionPanel = new ViewerOptionPanel(this, this.mOptionsPrefs, "viewer");
        viewerOptionPanel.initPanel();
        jTabbedPane.add(this.getResString(string), viewerOptionPanel);
    }

    private void addDataOptions(JTabbedPane jTabbedPane, String string) {
        this.mDataPanel = new DataOptionPanel(this, this.mOptionsPrefs, "data");
        jTabbedPane.add(this.getResString(string), this.mDataPanel);
    }

    private void addCurrencyOptions(JTabbedPane jTabbedPane, String string) {
        CurrencyOptionPanel currencyOptionPanel = new CurrencyOptionPanel(this, this.mOptionsPrefs, "currency");
        jTabbedPane.add(this.getResString(string), currencyOptionPanel);
    }

    private void addOuputLabelsOptions(JTabbedPane jTabbedPane, String string) {
        OutputLabelsOptionPanel outputLabelsOptionPanel = new OutputLabelsOptionPanel(this, this.mOptionsPrefs, "output_labels");
        jTabbedPane.add(this.getResString(string), outputLabelsOptionPanel);
    }

    private void addChartsOptions(JTabbedPane jTabbedPane, String string) {
        this.mChartsPanel = new ChartsOptionPanel(this, this.mOptionsPrefs, "charts");
        jTabbedPane.add(this.getResString(string), this.mChartsPanel);
    }

    private void addPivotTablesOptions(JTabbedPane jTabbedPane, String string) {
        this.mPivotTablesPanel = new PivotTablesOptionPanel(this, this.mOptionsPrefs, "tables");
        this.mPivotTablesPanel.initPanel();
        jTabbedPane.add(this.getResString(string), this.mPivotTablesPanel);
    }

    private void addFileLocationsOptions(JTabbedPane jTabbedPane, String string) {
        FileLocationsOptionPanel fileLocationsOptionPanel = new FileLocationsOptionPanel(this, this.mOptionsPrefs, "file_locations");
        fileLocationsOptionPanel.initPanel();
        jTabbedPane.add(this.getResString(string), fileLocationsOptionPanel);
    }

    private void addScriptsOptions(JTabbedPane jTabbedPane, String string) {
        this.mScriptsPanel = new ScriptsOptionPanel(this, this.mOptionsPrefs, "scripting");
        jTabbedPane.add(this.getResString(string), this.mScriptsPanel);
    }

    private void addMultipleImputationsOptions(JTabbedPane jTabbedPane, String string) {
        MultipleImputationsOptionPanel multipleImputationsOptionPanel = new MultipleImputationsOptionPanel(this, this.mOptionsPrefs, "multiple_imputations");
        multipleImputationsOptionPanel.initPanel();
        jTabbedPane.add(this.getResString(string), multipleImputationsOptionPanel);
    }

    private void addSyntaxEditorOptions(JTabbedPane jTabbedPane, String string) {
        SyntaxOptionPanel syntaxOptionPanel = new SyntaxOptionPanel(this, this.mOptionsPrefs, "syntax_editor");
        jTabbedPane.add(this.getResString(string), syntaxOptionPanel);
    }

    private void savePrefs() {
        int n = 0;
        for (OptionPanel optionPanel : OptionPanel.sOptionTabsList) {
            SpssFrame[] spssFrameArray;
            if (!optionPanel.isOptionsChanged()) continue;
            n |= optionPanel.getId();
            optionPanel.savePrefs();
            if (!(optionPanel instanceof SyntaxOptionPanel)) continue;
            for (SpssFrame spssFrame : spssFrameArray = SpssFrameMgr.getSpssFrameMgr().getOpenDocuments()) {
                if (!(spssFrame instanceof SyntaxFrame)) continue;
                try {
                    SyntaxEditorState syntaxEditorState = ((SyntaxOptionPanel)optionPanel).getSyntaxEditorState();
                    ((SyntaxFrame)spssFrame).getSyntaxView().setState(syntaxEditorState);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        sLastTabSelectedIndex = this.mTabbedPane.getSelectedIndex();
        if (n != 0) {
            new ExecStartupPreferences(n).start();
        }
    }

    private boolean saveChanges() {
        boolean bl = true;
        if (this.mScriptsPanel != null && sLastSelectedTab == this.mScriptsPanel && !this.mScriptsPanel.isValidPanel()) {
            return false;
        }
        if (this.mPivotTablesPanel != null && sLastSelectedTab == this.mPivotTablesPanel && !this.mPivotTablesPanel.isValidPanel()) {
            return false;
        }
        Iterator<Object> iterator = sErrorMessagesDialogs.keySet().iterator();
        if (iterator.hasNext()) {
            Object object = iterator.next();
            ComponentState.trace1((String)"inside err", (int)15);
            SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this), sErrorMessagesDialogs.get(object), VersionInfo.getAppVersionString());
            if (object instanceof JSpinner) {
                ((JSpinner)object).getEditor().requestFocus();
                ((JTextField)((JSpinner)object).getEditor()).selectAll();
            } else {
                ((JComponent)object).requestFocus(true);
            }
            return false;
        }
        for (String string : sMessagesDialogs.values()) {
            SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this), string, VersionInfo.getAppVersionString());
        }
        for (String string : sConfirmDialogs.values()) {
            if (SpssAlertOptionPane.showConfirmDialog((Window)((Object)this), string, VersionInfo.getAppVersionString(), SpssAlertOptionPane.IconType.eInformation, SpssAlertOptionPane.OptionType.OK_CANCEL_OPTION) == 0) continue;
            ComponentState.trace1((String)" Do not save the changes options", (int)15);
            ComponentState.trace1((String)"", (int)15);
            bl = false;
            break;
        }
        if (bl && sConfirmDialogs.size() > 0) {
            ProcedureDlgMgr.getMgr().closeAllProcedureDialogs();
            ProcedureDlgMgr.getMgr().clearDatasetMaps();
        }
        if (bl) {
            sConfirmDialogs.clear();
            sMessagesDialogs.clear();
        }
        return bl;
    }

    private void doPostDisplayTasksOnThread(final OptionPanel optionPanel) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                optionPanel.doPostDisplayProcessing();
            }
        };
        new Thread(runnable, "Options Load Task").start();
    }

    public static void setInvalidField(boolean bl) {
        mInvalidField = bl;
    }

    static {
        sLastTabSelectedIndex = -1;
        mInvalidField = false;
    }

    private class HelpAction
    extends AbstractAction {
        HelpAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_HELP"));
            this.putValue("AcceleratorKey", 112);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            OptionsDlg.this.doHelp();
        }
    }

    private class CancelAction
    extends AbstractAction {
        CancelAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_CANCEL"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ProcedureDlgMgr.getMgr().saveDialogSize("edit_options", OptionsDlg.this.getSize());
            ProcedureDlgMgr.getMgr().saveDialogLocation("edit_options", OptionsDlg.this.getLocation());
            OptionsDlg.this.dispose();
        }
    }

    private class ApplyAction
    extends AbstractAction {
        ApplyAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_APPLY"));
            if (OSInfo.getOSType() != OSInfo.OSType.MAC) {
                this.putValue("MnemonicKey", ResUtil.getCommonDlgAccessKey("IDK_APPLY"));
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (OptionsDlg.this.saveChanges()) {
                OptionsDlg.this.savePrefs();
                OptionsDlg.this.enableApplyAction(false);
                OptionsDlg.this.resetOptionsChangedFlag();
            }
        }
    }

    private class OkAction
    extends AbstractAction {
        OkAction() {
            this.putValue("Name", ResUtil.getCommonDlgString("IDS_OK"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (mInvalidField) {
                mInvalidField = false;
                return;
            }
            if (OptionsDlg.this.saveChanges()) {
                ProcedureDlgMgr.getMgr().saveDialogSize("edit_options", OptionsDlg.this.getSize());
                ProcedureDlgMgr.getMgr().saveDialogLocation("edit_options", OptionsDlg.this.getLocation());
                OptionsDlg.this.savePrefs();
                OptionsDlg.this.dispose();
                if (OptionsDlg.this.mGeneralPanel != null && OptionsDlg.this.mGeneralPanel.getLAFModified()) {
                    LookAndFeelManager lookAndFeelManager = SpssMgr.getSpssMgr().getLookAndFeelManager();
                    String string = lookAndFeelManager.getLookAndFeel().getClass().getName();
                    Preferences preferences = PrefsMgr.getPrefsMgr().getUIUserPrefs().node("options");
                    Preferences preferences2 = preferences.node("general");
                    String string2 = preferences2.get("look_and_feel", string);
                    lookAndFeelManager.setLookAndFeel(string2);
                    SpssFrame[] spssFrameArray = SpssFrameMgr.getSpssFrameMgr().getOpenDocuments();
                    List<ToolbarObject> list = ToolbarsUtil.loadToolBarsFromPrefs();
                    for (SpssFrame spssFrame : spssFrameArray) {
                        spssFrame.setToolbarPrefCache(list);
                        spssFrame.refreshToolbar();
                    }
                }
            }
        }
    }
}

