/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.edit;

import com.spss.java_client.ui.dialogs.base.edit.OptionsDlg;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.JTextComponent;

public abstract class OptionPanel
extends JPanel
implements ActionListener,
KeyListener,
ChangeListener,
ListSelectionListener,
DocumentListener,
FocusListener,
ItemListener {
    public static List<OptionPanel> sOptionTabsList = new ArrayList<OptionPanel>();
    public static boolean sEnableApplyButton = false;
    public Vector<Object> mComponentOrder = new Vector();
    protected OptionsDlg mOptionDialog;
    protected final Preferences mOptionsPrefs;
    private boolean mOptionsChanged;
    private boolean mPanelInitialized;
    private boolean mPostDisplayProcessing;

    public OptionPanel(OptionsDlg optionsDlg, Preferences preferences, String string) {
        super(new GridBagLayout(), true);
        this.mOptionDialog = optionsDlg;
        this.mOptionsPrefs = preferences.node(string);
        sOptionTabsList.add(this);
        this.setOpaque(false);
    }

    public void initPanel() {
        try {
            sEnableApplyButton = false;
            this.mPanelInitialized = true;
            this.initVars();
            this.readPrefs();
            sEnableApplyButton = true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.mOptionDialog.enableApplyAction(true);
        this.mOptionsChanged = true;
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.mOptionDialog.enableApplyAction(true);
        this.mOptionsChanged = true;
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.mOptionDialog.enableApplyAction(true);
        this.mOptionsChanged = true;
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        this.mOptionDialog.enableApplyAction(true);
        this.mOptionsChanged = true;
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.mOptionDialog.enableApplyAction(true);
        this.mOptionsChanged = true;
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.insertUpdate(documentEvent);
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.insertUpdate(documentEvent);
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        Object object = focusEvent.getSource();
        if (object instanceof JTextField) {
            ((JTextComponent)object).selectAll();
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        if (focusEvent.isTemporary() || focusEvent.getID() != 1005) {
            return;
        }
        Object object = focusEvent.getSource();
        if (object instanceof JTextField) {
            ((JTextComponent)object).select(0, 0);
        } else if (object instanceof JComboBox) {
            ((JTextComponent)((JComboBox)object).getEditor().getEditorComponent()).select(0, 0);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.mOptionDialog.enableApplyAction(true);
        this.mOptionsChanged = true;
    }

    public boolean isPanelInitialized() {
        return this.mPanelInitialized;
    }

    public boolean isPostDisplayProcessing() {
        return this.mPostDisplayProcessing;
    }

    public boolean isOptionsChanged() {
        return this.mOptionsChanged;
    }

    public void setOptionsChanged(boolean bl) {
        this.mOptionsChanged = bl;
    }

    public String getResString(String string) {
        return this.mOptionDialog.getResString(string);
    }

    public String[] getResStringArray(String string) {
        return this.mOptionDialog.getResStringArray(string);
    }

    public int getResStringInt(String string) {
        return this.mOptionDialog.getResInt(string);
    }

    public abstract String getDialogHelpID();

    protected abstract void initVars();

    protected abstract void readPrefs();

    protected abstract void savePrefs();

    protected abstract int getId();

    protected void doPostDisplayProcessing() {
        this.mPostDisplayProcessing = true;
    }

    public static void setComponentEnableState(Component component, boolean bl) {
        if (component instanceof JTextField) {
            ((JTextField)component).setEditable(bl);
        }
        if (component instanceof Container) {
            Component[] componentArray = ((Container)component).getComponents();
            for (int i = 0; i < ((Container)component).getComponentCount(); ++i) {
                OptionPanel.setComponentEnableState(componentArray[i], bl);
            }
            component.setEnabled(bl);
            if (component instanceof JPanel) {
                OptionPanel.enableTitledBorder((JPanel)component, bl);
            }
        }
    }

    protected static void enableTitledBorder(JPanel jPanel, boolean bl) {
        Border border = jPanel.getBorder();
        UIManager.getColor("Button.disabled");
        if (border instanceof TitledBorder) {
            TitledBorder titledBorder = (TitledBorder)border;
            if (bl) {
                titledBorder.setTitleColor(UIManager.getColor("TitledBorder.titleColor"));
            } else {
                titledBorder.setTitleColor(UIManager.getColor("Button.disabledText"));
            }
        }
    }
}

