/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.edit;

import com.spss.java_client.core.common.prefs.PrefDefaults;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.IImputationInfo;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.ui.SpssFrameMgr;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.base.edit.OptionPanel;
import com.spss.java_client.ui.dialogs.base.edit.OptionsDlg;
import com.spss.java_client.ui.dialogs.base.edit.OptionsUtil;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.doc_types.SpssFrame;
import com.spss.java_client.ui.doc_types.data.DataFrame;
import com.spss.java_client.ui.resources.ResUtil;
import com.spss.uitools.dialogs.BaseDialog;
import com.spss.uitools.drop_menu_button.DropButton;
import com.spss.uitools.drop_menu_button.DropButtonDrawer;
import com.spss.uitools.drop_menu_button.FillButtonDrawer;
import com.spss.uitools.util.AccessibilityUtil;
import com.spss.uitools.util.IOptionConstants;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.net.URL;
import java.util.Arrays;
import java.util.ResourceBundle;
import java.util.prefs.Preferences;
import javax.accessibility.AccessibleContext;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JToggleButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class MultipleImputationsOptionPanel
extends OptionPanel
implements ItemListener,
PopupMenuListener {
    private FontState mFontState;
    private FontPanel mFontPanel;
    private SpssButtonGroup mResultsButtonGroup;
    private JRadioButton mResultsBothRadio;
    private JRadioButton mResultsObservedRadio;
    private JRadioButton mResultsImputedRadio;
    private JCheckBox mPooledResultsCheckBox;
    private JCheckBox mDiagnosticStatisticsCheckBox;

    public MultipleImputationsOptionPanel(OptionsDlg optionsDlg, Preferences preferences, String string) {
        super(optionsDlg, preferences, string);
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
        if (popupMenuEvent.getSource().equals(this.mFontPanel.getFontComboBox())) {
            this.saveFontState();
        }
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        super.keyReleased(keyEvent);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object.equals(this.mFontPanel.getFontComboBox()) || object.equals(this.mFontPanel.getBoldButton())) {
            this.saveFontState();
            super.actionPerformed(actionEvent);
        } else if (object.equals(this.mFontPanel.getColorButton())) {
            this.saveFontState();
            if (this.mFontState.isColorChanged()) {
                super.actionPerformed(actionEvent);
            }
        } else if (object.equals(this.mResultsBothRadio) || object.equals(this.mResultsObservedRadio) || object.equals(this.mResultsImputedRadio)) {
            super.actionPerformed(actionEvent);
        } else if (object.equals(this.mPooledResultsCheckBox)) {
            super.actionPerformed(actionEvent);
        } else if (object.equals(this.mDiagnosticStatisticsCheckBox)) {
            super.actionPerformed(actionEvent);
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        boolean bl;
        boolean bl2 = bl = itemEvent.getStateChange() == 1;
        if (itemEvent.getSource().equals(this.mPooledResultsCheckBox)) {
            this.mDiagnosticStatisticsCheckBox.setEnabled(bl);
            this.mDiagnosticStatisticsCheckBox.setOpaque(bl);
        }
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        super.insertUpdate(documentEvent);
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        super.insertUpdate(documentEvent);
    }

    @Override
    public String getDialogHelpID() {
        return "idh_pref_imputation";
    }

    @Override
    public void initPanel() {
        super.initPanel();
    }

    @Override
    public void initVars() {
        this.mFontState = new FontState();
        this.mResultsBothRadio = DialogUtil.createRadioButton(this.mOptionDialog, "IDS_MI_RESULTS_BOTH_RADIO", (ActionListener)this);
        this.mResultsObservedRadio = DialogUtil.createRadioButton(this.mOptionDialog, "IDS_MI_RESULTS_OBSERVED_RADIO", (ActionListener)this);
        this.mResultsImputedRadio = DialogUtil.createRadioButton(this.mOptionDialog, "IDS_MI_RESULTS_IMPUTED_RADIO", (ActionListener)this);
        this.mPooledResultsCheckBox = DialogUtil.createCheckBox(this.mOptionDialog, "IDS_MI_POOLED_RESULTS_CHECK_BOX", (ActionListener)this);
        this.mDiagnosticStatisticsCheckBox = DialogUtil.createCheckBox(this.mOptionDialog, "IDS_MI_DIAGNOSTIC_STATISTICS_CHECK_BOX", (ActionListener)this);
        this.addComponents();
        this.setTabTraversal();
    }

    @Override
    public void readPrefs() {
        Preferences preferences = this.mOptionsPrefs;
        this.readPrefsValuesForFontInfo();
        String string = preferences.get("MIOUTPUT", IOptionConstants.MI_OUTPUT_VALUES[8]);
        if (string.equalsIgnoreCase(IOptionConstants.MI_OUTPUT_VALUES[0]) || string.equalsIgnoreCase(IOptionConstants.MI_OUTPUT_VALUES[1]) || string.equalsIgnoreCase(IOptionConstants.MI_OUTPUT_VALUES[2])) {
            DialogUtil.setSelectedButton(this.mResultsButtonGroup, 1);
        } else if (string.equalsIgnoreCase(IOptionConstants.MI_OUTPUT_VALUES[3]) || string.equalsIgnoreCase(IOptionConstants.MI_OUTPUT_VALUES[4]) || string.equalsIgnoreCase(IOptionConstants.MI_OUTPUT_VALUES[5])) {
            DialogUtil.setSelectedButton(this.mResultsButtonGroup, 2);
        } else {
            DialogUtil.setSelectedButton(this.mResultsButtonGroup, 0);
        }
        this.enableResultsButtons(true);
        this.mPooledResultsCheckBox.setSelected(false);
        this.mDiagnosticStatisticsCheckBox.setSelected(false);
        this.mDiagnosticStatisticsCheckBox.setEnabled(false);
        this.mDiagnosticStatisticsCheckBox.setOpaque(false);
        if (string.equalsIgnoreCase(IOptionConstants.MI_OUTPUT_VALUES[1]) || string.equalsIgnoreCase(IOptionConstants.MI_OUTPUT_VALUES[2]) || string.equalsIgnoreCase(IOptionConstants.MI_OUTPUT_VALUES[4]) || string.equalsIgnoreCase(IOptionConstants.MI_OUTPUT_VALUES[5]) || string.equalsIgnoreCase(IOptionConstants.MI_OUTPUT_VALUES[7]) || string.equalsIgnoreCase(IOptionConstants.MI_OUTPUT_VALUES[8])) {
            this.mPooledResultsCheckBox.setSelected(true);
            this.mDiagnosticStatisticsCheckBox.setEnabled(true);
            this.mDiagnosticStatisticsCheckBox.setOpaque(true);
        }
        if (string.equalsIgnoreCase(IOptionConstants.MI_OUTPUT_VALUES[2]) || string.equalsIgnoreCase(IOptionConstants.MI_OUTPUT_VALUES[5]) || string.equalsIgnoreCase(IOptionConstants.MI_OUTPUT_VALUES[8])) {
            this.mDiagnosticStatisticsCheckBox.setSelected(true);
        }
        this.addListeners();
    }

    @Override
    public void savePrefs() {
        Preferences preferences = this.mOptionsPrefs;
        this.savePrefsValuesForFontInfo();
        if (this.mResultsObservedRadio.isSelected()) {
            if (this.mPooledResultsCheckBox.isSelected()) {
                if (this.mDiagnosticStatisticsCheckBox.isSelected()) {
                    preferences.put("MIOUTPUT", IOptionConstants.MI_OUTPUT_VALUES[2]);
                } else {
                    preferences.put("MIOUTPUT", IOptionConstants.MI_OUTPUT_VALUES[1]);
                }
            } else {
                preferences.put("MIOUTPUT", IOptionConstants.MI_OUTPUT_VALUES[0]);
            }
        } else if (this.mResultsImputedRadio.isSelected()) {
            if (this.mPooledResultsCheckBox.isSelected()) {
                if (this.mDiagnosticStatisticsCheckBox.isSelected()) {
                    preferences.put("MIOUTPUT", IOptionConstants.MI_OUTPUT_VALUES[5]);
                } else {
                    preferences.put("MIOUTPUT", IOptionConstants.MI_OUTPUT_VALUES[4]);
                }
            } else {
                preferences.put("MIOUTPUT", IOptionConstants.MI_OUTPUT_VALUES[3]);
            }
        } else if (this.mPooledResultsCheckBox.isSelected()) {
            if (this.mDiagnosticStatisticsCheckBox.isSelected()) {
                preferences.put("MIOUTPUT", IOptionConstants.MI_OUTPUT_VALUES[8]);
            } else {
                preferences.put("MIOUTPUT", IOptionConstants.MI_OUTPUT_VALUES[7]);
            }
        } else {
            preferences.put("MIOUTPUT", IOptionConstants.MI_OUTPUT_VALUES[6]);
        }
        this.updateDataDocsWithMultipleImputation();
    }

    public void enableApply() {
        this.mOptionDialog.enableApplyAction(true);
        this.setOptionsChanged(true);
    }

    public void saveColor() {
        Color color = this.mFontPanel.getColorButtonColor();
        int n = color.getRGB();
        if (this.mFontState.getColor() != (n &= 0xFFFFFF)) {
            this.mFontState.setColor(n);
            this.mFontState.setColorChanged(true);
        }
    }

    @Override
    protected int getId() {
        return 4096;
    }

    private void addListeners() {
        this.mFontPanel.getFontComboBox().addActionListener(this);
        this.mPooledResultsCheckBox.addItemListener(this);
    }

    private void readPrefsValuesForFontInfo() {
        Preferences preferences = this.mOptionsPrefs;
        int n = preferences.getInt("font_color", 16378540);
        this.mFontPanel.setColorButtonColor(this.getColor(n));
        this.mFontState.setColor(n);
        String string = preferences.get("font_name", PrefDefaults.DEF_MI_FONT_FAMILY);
        this.mFontPanel.getFontComboBox().setSelectedItem(string);
        this.mFontState.setFontName(string);
        boolean bl = preferences.getBoolean("font_bold", false);
        this.mFontState.setBold(bl);
        this.mFontPanel.getBoldButton().setSelected(bl);
    }

    private void savePrefsValuesForFontInfo() {
        Preferences preferences = this.mOptionsPrefs;
        if (this.mFontState.isColorChanged()) {
            preferences.putInt("font_color", this.mFontState.getColor());
        }
        if (this.mFontState.isFontNameChanged()) {
            preferences.put("font_name", this.mFontState.getFontName());
        }
        if (this.mFontState.isBoldChanged()) {
            preferences.putBoolean("font_bold", this.mFontState.isBold());
        }
    }

    private void updateDataDocsWithMultipleImputation() {
        SpssFrame[] spssFrameArray;
        SpssFrameMgr spssFrameMgr = SpssFrameMgr.getSpssFrameMgr();
        for (SpssFrame spssFrame : spssFrameArray = spssFrameMgr.getOpenDocuments()) {
            if (!(spssFrame instanceof DataFrame)) continue;
            DataFrame dataFrame = (DataFrame)spssFrame;
            ISpssDataSrc iSpssDataSrc = DataMgr.getDataMgr().getDataSource(dataFrame.getDatasetId());
            if (iSpssDataSrc == null || !iSpssDataSrc.isMultipleImputation()) continue;
            IImputationInfo iImputationInfo = iSpssDataSrc.getImputationInfo();
            iImputationInfo.readFromPreferences();
            iSpssDataSrc.notifyImputationDisplayChange();
        }
    }

    private void saveFontState() {
        if (!this.mFontState.getFontName().equals(this.mFontPanel.getFontComboBox().getSelectedItem())) {
            this.mFontState.setFontName((String)this.mFontPanel.getFontComboBox().getSelectedItem());
            this.mFontState.setFontNameChanged(true);
        }
        if (this.mFontState.isBold() != this.mFontPanel.getBoldButton().isSelected()) {
            this.mFontState.setBold(this.mFontPanel.getBoldButton().isSelected());
            this.mFontState.setBoldChanged(true);
        }
        Color color = this.mFontPanel.getColorButton().getUserSelectedColor();
        int n = color.getRGB();
        if (this.mFontState.getColor() != (n &= 0xFFFFFF)) {
            this.mFontState.setColor(n);
            this.mFontState.setColorChanged(true);
        }
    }

    private void addComponents() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n = 23;
        Insets insets = new Insets(DialogUtil.getComponentGroupGap(), 0, 0, 0);
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = this.setupFontPanel();
        OptionsUtil.addUsingGBL(this, jPanel2, gridBagConstraints, 0, 0, 2, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        JPanel jPanel3 = this.setupAnalyisOutuptPanel();
        OptionsUtil.addUsingGBL(this, jPanel3, gridBagConstraints, 0, 1, 2, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        OptionsUtil.addUsingGBL(this, jPanel, gridBagConstraints, 2, 0, 1, 2, n, insets);
    }

    private JPanel setupFontPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n = 23;
        Insets insets = new Insets(DialogUtil.getComponentGroupGap(), DialogUtil.getGroupBoxInnerMargin(), DialogUtil.getGroupBoxInnerMargin(), DialogUtil.getGroupBoxInnerMargin());
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.mFontPanel = new FontPanel(this.mOptionDialog, this);
        jPanel.setBorder(BorderFactory.createTitledBorder(this.mOptionDialog.getResString("IDS_MI_APPEARANCE_OF_IMPUTED_DATA_PANEL_TITLE")));
        AccessibilityUtil.setAccessibleText((Component)this.mFontPanel, (Object)this.mOptionDialog.getResString("IDS_MI_APPEARANCE_OF_IMPUTED_DATA_PANEL_TITLE"));
        this.mFontPanel.setupToolBar();
        OptionsUtil.addUsingGBL(jPanel, this.mFontPanel, gridBagConstraints, 1, 2, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel setupAnalyisOutuptPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.mOptionDialog.getResString("IDS_MI_ANALYIS_IS_OUTPUT_PANEL_TITLE")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n = 23;
        Insets insets = (Insets)DialogUtil.getStandardControlInsets().clone();
        JComponent[] jComponentArray = new JComponent[]{this.mResultsBothRadio, this.mResultsObservedRadio, this.mResultsImputedRadio};
        JPanel jPanel2 = PanelFactory.getBasicPanel(jComponentArray, PanelFactory.PanelType.yaxis, null, true);
        AccessibilityUtil.setAccessibleText((Component)jPanel2, (Object)this.mOptionDialog.getResString("IDS_MI_ANALYIS_IS_OUTPUT_PANEL_TITLE"));
        this.mResultsButtonGroup = DialogUtil.createButtonGroup(jPanel2);
        OptionsUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n, null);
        insets.top = DialogUtil.getComponentGroupGap();
        OptionsUtil.addUsingGBL(jPanel, this.mPooledResultsCheckBox, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        insets = new Insets(0, DialogUtil.getGroupBoxInnerMargin() + 12, DialogUtil.getGroupBoxInnerMargin(), DialogUtil.getGroupBoxInnerMargin());
        OptionsUtil.addUsingGBL(jPanel, this.mDiagnosticStatisticsCheckBox, gridBagConstraints, 0, 2, 1, 1, n, insets);
        return jPanel;
    }

    private void setTabTraversal() {
        this.mComponentOrder.add(this.mFontPanel.getColorButton());
        this.mComponentOrder.add(this.mFontPanel.getFontComboBox());
        this.mComponentOrder.add(this.mFontPanel.getBoldButton());
        this.mComponentOrder.add(this.mResultsButtonGroup);
        if (this.mPooledResultsCheckBox != null) {
            this.mComponentOrder.add(this.mPooledResultsCheckBox);
        }
        if (this.mDiagnosticStatisticsCheckBox != null) {
            this.mComponentOrder.add(this.mDiagnosticStatisticsCheckBox);
        }
        this.mComponentOrder.addAll(Arrays.asList(this.mOptionDialog.getCmdButtonPanel().getComponents()));
    }

    private Color getColor(int n) {
        Color color;
        if (n > 0) {
            int n2;
            String string = Integer.toHexString(n);
            int n3 = 6 - string.length();
            for (n2 = 0; n2 < n3; ++n2) {
                string = "0" + string;
            }
            n2 = Integer.parseInt(string.substring(0, 2), 16);
            int n4 = Integer.parseInt(string.substring(2, 4), 16);
            int n5 = Integer.parseInt(string.substring(4, 6), 16);
            color = new Color(n2, n4, n5);
        } else {
            color = new Color(0, 0, 0);
        }
        return color;
    }

    private void enableResultsButtons(boolean bl) {
        this.mResultsBothRadio.setEnabled(bl);
        this.mResultsObservedRadio.setEnabled(bl);
        this.mResultsImputedRadio.setEnabled(bl);
    }

    public class FontPanel
    extends JPanel {
        private BaseDialog mBaseDialog;
        private MultipleImputationsOptionPanel mMultipleImputationsOptionPanel;
        private DropButton mColorDropButton;
        private JComboBox mFontComboBox;
        private JToggleButton mBoldButton = null;

        public FontPanel(BaseDialog baseDialog, MultipleImputationsOptionPanel multipleImputationsOptionPanel2) {
            this.mBaseDialog = baseDialog;
            this.mMultipleImputationsOptionPanel = multipleImputationsOptionPanel2;
            this.setLayout(new GridBagLayout());
        }

        public void setColorButtonColor(Color color) {
            this.mColorDropButton.setUserSelectedColor(color);
            this.mColorDropButton.repaint();
        }

        public Color getColorButtonColor() {
            return this.mColorDropButton.getUserSelectedColor();
        }

        public DropButton getColorButton() {
            return this.mColorDropButton;
        }

        public JComboBox getFontComboBox() {
            return this.mFontComboBox;
        }

        public JToggleButton getBoldButton() {
            return this.mBoldButton;
        }

        public void setupToolBar() {
            ResourceBundle resourceBundle;
            String[] stringArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames(ResUtil.getLocale());
            this.mFontComboBox = new JComboBox();
            this.mFontComboBox.setModel(new DefaultComboBoxModel<String>(stringArray));
            this.mBoldButton = new JToggleButton();
            this.mBoldButton.addActionListener(this.mMultipleImputationsOptionPanel);
            URL uRL = ResUtil.getImageResource(this.mBaseDialog.getResString("IDS_BOLD_IMAGE"));
            this.mBoldButton.setIcon(new ImageIcon(uRL));
            this.mBoldButton.setMargin(new Insets(0, 0, 0, 0));
            AccessibleContext accessibleContext = this.mBoldButton.getAccessibleContext();
            if (accessibleContext != null) {
                resourceBundle = ResUtil.getBundle("com.spss.java_client.ui.dialogs.common.res.CommonDlgResBundle", ResUtil.getLocale());
                accessibleContext.setAccessibleName(resourceBundle.getString("IDS_FONT_BOLD"));
            }
            resourceBundle = new FillButtonDrawer();
            this.mColorDropButton = new DropButton((DropButtonDrawer)resourceBundle);
            Dimension dimension = this.mColorDropButton.getSize();
            dimension.width = this.mBoldButton.getPreferredSize().width * 2;
            dimension.height = this.mBoldButton.getPreferredSize().height + 10;
            this.mColorDropButton.setPreferredSize(dimension);
            this.setupPanel();
            this.setTextColors();
            this.mColorDropButton.addActionListener((ActionListener)this.mMultipleImputationsOptionPanel);
        }

        private void setupPanel() {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.fill = 0;
            int n = 23;
            Insets insets = new Insets(0, 0, 0, 0);
            JLabel jLabel = DialogUtil.createLabel(MultipleImputationsOptionPanel.this.mOptionDialog, "IDS_MI_COLOR_CHOOSER_LABEL");
            OptionsUtil.addUsingGBL(this, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
            insets.top = DialogUtil.getGroupBoxInnerMargin();
            OptionsUtil.addUsingGBL(this, (JComponent)this.mColorDropButton, gridBagConstraints, 0, 1, 1, 1, n, insets);
            jLabel.setLabelFor((Component)this.mColorDropButton);
            insets.set(DialogUtil.getComponentGroupGap(), 0, 0, 0);
            JLabel jLabel2 = DialogUtil.createLabel(MultipleImputationsOptionPanel.this.mOptionDialog, "IDS_MI_FONT_LABEL");
            OptionsUtil.addUsingGBL(this, jLabel2, gridBagConstraints, 0, 2, 1, 1, n, insets);
            insets.top = DialogUtil.getGroupBoxInnerMargin();
            OptionsUtil.addUsingGBL(this, this.mFontComboBox, gridBagConstraints, 0, 3, 1, 1, n, insets);
            jLabel2.setLabelFor(this.mFontComboBox);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            insets.left = DialogUtil.getComponentGroupGap() * 2;
            OptionsUtil.addUsingGBL(this, this.mBoldButton, gridBagConstraints, 1, 3, 1, 1, n, insets);
        }

        private void setTextColors() {
            Color[] colorArray = new Color[]{new Color(225, 188, 29), new Color(92, 202, 136), new Color(0, 180, 160), new Color(227, 215, 16), new Color(236, 230, 208), new Color(254, 130, 180), new Color(204, 134, 63), new Color(63, 235, 124), new Color(28, 205, 205), new Color(207, 172, 227), new Color(208, 202, 140), new Color(237, 75, 75), new Color(225, 139, 14), new Color(95, 195, 56), new Color(85, 150, 230), new Color(204, 127, 228), new Color(150, 145, 145), new Color(215, 0, 51), new Color(208, 83, 52), new Color(41, 134, 38), new Color(63, 90, 168), new Color(171, 73, 243), new Color(90, 100, 94), new Color(155, 0, 0), new Color(243, 103, 42), new Color(92, 113, 72), new Color(9, 38, 114), new Color(119, 55, 143), new Color(69, 70, 71)};
            this.mColorDropButton.setColors(colorArray);
        }
    }

    private class FontState {
        private String mFontName;
        private int mFontSize;
        private boolean mBold;
        private boolean mItalic;
        private boolean mUnderline;
        private int mColor;
        private boolean mFontNameChanged = false;
        private boolean mFontSizeChanged = false;
        private boolean mBoldChanged = false;
        private boolean mItalicChanged = false;
        private boolean mUnderlineChanged = false;
        private boolean mColorChanged = false;

        private FontState() {
        }

        String getFontName() {
            return this.mFontName;
        }

        void setFontName(String string) {
            this.mFontName = string;
        }

        boolean isFontNameChanged() {
            return this.mFontNameChanged;
        }

        void setFontNameChanged(boolean bl) {
            this.mFontNameChanged = bl;
        }

        int getFontSize() {
            return this.mFontSize;
        }

        void setFontSize(int n) {
            this.mFontSize = n;
        }

        boolean isFontSizeChanged() {
            return this.mFontSizeChanged;
        }

        void setFontSizeChanged(boolean bl) {
            this.mFontSizeChanged = bl;
        }

        boolean isBold() {
            return this.mBold;
        }

        void setBold(boolean bl) {
            this.mBold = bl;
        }

        boolean isBoldChanged() {
            return this.mBoldChanged;
        }

        void setBoldChanged(boolean bl) {
            this.mBoldChanged = bl;
        }

        boolean isItalic() {
            return this.mItalic;
        }

        void setItalic(boolean bl) {
            this.mItalic = bl;
        }

        boolean isItalicChanged() {
            return this.mItalicChanged;
        }

        void setItalicChanged(boolean bl) {
            this.mItalicChanged = bl;
        }

        boolean isUnderline() {
            return this.mUnderline;
        }

        void setUnderline(boolean bl) {
            this.mUnderline = bl;
        }

        boolean isUnderlineChanged() {
            return this.mUnderlineChanged;
        }

        void setUnderlineChanged(boolean bl) {
            this.mUnderlineChanged = bl;
        }

        int getColor() {
            return this.mColor;
        }

        void setColor(int n) {
            this.mColor = n;
        }

        boolean isColorChanged() {
            return this.mColorChanged;
        }

        void setColorChanged(boolean bl) {
            this.mColorChanged = bl;
        }
    }
}

