/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.edit;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.core.common.prefs.PrefDefaults;
import com.spss.java_client.core.common.prefs.PrefsMgr;
import com.spss.java_client.core.comp_util.UtilityProxy;
import com.spss.java_client.core.documents.UpdateUserPrefs;
import com.spss.java_client.core.documents.data.DataMgr;
import com.spss.java_client.core.documents.data.dictionary.ISpssDataSrc;
import com.spss.java_client.ui.controls.FocusableTextArea;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.base.edit.GeneralOptionPanel;
import com.spss.java_client.ui.dialogs.base.edit.OptionPanel;
import com.spss.java_client.ui.dialogs.base.edit.OptionsDlg;
import com.spss.java_client.ui.dialogs.base.edit.OptionsUtil;
import com.spss.java_client.ui.dialogs.base.graphs.chart_builder.Statistics;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.ProcedureDlgMgr;
import com.spss.uitools.help.StatsHelp;
import com.spss.uitools.util.IOptionConstants;
import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;

public class LanguageOptionPanel
extends OptionPanel {
    public static final String[] BTD_OPTIONS = new String[]{"IDS_CNTX_BTD", "IDS_RTL_BTD", "IDS_LTR_BTD"};
    static final String UI_HELP_KEY = "ui_help";
    private JRadioButton mCharLocaleRadio;
    private JComboBox mCharLocaleList;
    private JRadioButton mCharUnicodeRadio;
    private SpssButtonGroup mCharEncodingButtonGrp;
    private FocusableTextArea mCharInfoLabel;
    private JPanel mCharPanel;
    private JLabel mCharLocaleListLbl;
    private JComboBox mOLangList;
    private JComboBox mUILangList;
    private boolean mUILangChanged;
    private FocusableTextArea mBtdSelInfoLabel;
    private FocusableTextArea mBtdCntxInfoLabel;
    private FocusableTextArea mBtdRestartInfoLabel;
    private FocusableTextArea mBtdSyntaxEditorCheckLabel;
    private JComboBox mBtdOptionsList;
    private JLabel mBtdOptionSelectionLbl;
    private boolean btdSelectionChanged = false;
    private boolean mCharLocaleChanged = false;
    private int mInitialCharLocaleListIndex = -1;
    private String mCharLocaleUserSpecified = "";

    public LanguageOptionPanel(OptionsDlg optionsDlg, Preferences preferences, String string) {
        super(optionsDlg, preferences, string);
        this.setOpaque(false);
        this.setOptionsChanged(false);
    }

    @Override
    public String getDialogHelpID() {
        return "idh_pref_language";
    }

    private boolean isCharEncodingGrpEnabled() {
        DataMgr dataMgr = DataMgr.getDataMgr();
        int n = dataMgr.dataSourceCount();
        for (int i = 0; i < n; ++i) {
            ISpssDataSrc iSpssDataSrc = dataMgr.getDataSource(i);
            if (iSpssDataSrc.columnCount() <= 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public void initVars() {
        this.mUILangChanged = false;
        ArrayList arrayList = UtilityProxy.getUtilProxy().getServerLoclmapContents();
        this.mCharLocaleRadio = DialogUtil.createRadioButton(this.mOptionDialog, "IDS_CHAR_ENCODING_LOCALE", (ActionListener)this);
        this.mCharUnicodeRadio = DialogUtil.createRadioButton(this.mOptionDialog, "IDS_CHAR_ENCODING_UNICODE", (ActionListener)this);
        this.mCharEncodingButtonGrp = new SpssButtonGroup();
        this.mCharEncodingButtonGrp.add(this.mCharLocaleRadio);
        this.mCharEncodingButtonGrp.add(this.mCharUnicodeRadio);
        this.mCharInfoLabel = new FocusableTextArea(this.getResString("IDS_CHAR_ENCODING_MSG"), null);
        this.mCharPanel = new JPanel(true);
        TitledBorder titledBorder = BorderFactory.createTitledBorder(this.getResString("IDS_CHAR_ENCODING_TITLE"));
        this.mCharPanel.setLayout(new GridBagLayout());
        this.mCharPanel.setBorder(titledBorder);
        boolean bl = this.isCharEncodingGrpEnabled();
        this.mCharLocaleRadio.setEnabled(bl);
        this.mCharUnicodeRadio.setEnabled(bl);
        this.mCharLocaleListLbl = DialogUtil.createLabel(this.mOptionDialog, "IDS_CHAR_ENCODING_LOCALE_LIST");
        this.mCharLocaleListLbl.setEnabled(bl);
        this.mBtdSelInfoLabel = new FocusableTextArea(this.getResString("IDS_BTD_SEL_MSG"), null);
        this.mBtdCntxInfoLabel = new FocusableTextArea(this.getResString("IDS_BTD_CNTX_MSG"), null);
        this.mBtdRestartInfoLabel = new FocusableTextArea(this.getResString("IDS_BTD_RESTART_MSG"), null);
        this.mBtdSyntaxEditorCheckLabel = new FocusableTextArea(this.getResString("IDS_BTD_SE_MSG"), null);
        this.mBtdOptionSelectionLbl = DialogUtil.createLabel(this.mOptionDialog, "IDS_BIDI_TEXT_DIRECTION");
        String[] stringArray = new String[Array.getLength(GeneralOptionPanel.LANG_ITEMS)];
        for (int i = 0; i < Array.getLength(GeneralOptionPanel.LANG_ITEMS); ++i) {
            Array.set(stringArray, i, this.getResString(GeneralOptionPanel.LANG_ITEMS[i]));
        }
        this.mUILangList = new JComboBox<String>(stringArray);
        this.mOLangList = new JComboBox<String>(stringArray);
        this.mCharLocaleList = new JComboBox<String>(arrayList.toArray(new String[arrayList.size()]));
        this.mCharLocaleList.insertItemAt(this.getResString("IDS_CHAR_ENCODING_OS_WRITING_SYSTEM"), 0);
        this.mCharLocaleList.setEditable(true);
        this.mCharLocaleList.setEnabled(bl);
        this.mCharInfoLabel.setEnabled(bl);
        String[] stringArray2 = new String[Array.getLength(BTD_OPTIONS)];
        for (int i = 0; i < Array.getLength(BTD_OPTIONS); ++i) {
            Array.set(stringArray2, i, this.getResString(BTD_OPTIONS[i]));
        }
        this.mBtdOptionsList = new JComboBox<String>(stringArray2);
        this.mComponentOrder.add(this.mOLangList);
        this.mComponentOrder.add(this.mUILangList);
        this.mComponentOrder.add(this.mCharEncodingButtonGrp);
        this.mComponentOrder.add(this.mCharLocaleList);
        this.mComponentOrder.add(this.mCharInfoLabel);
        this.mComponentOrder.add(this.mBtdSelInfoLabel);
        this.mComponentOrder.add(this.mBtdCntxInfoLabel);
        this.mComponentOrder.add(this.mBtdRestartInfoLabel);
        this.mComponentOrder.add(this.mBtdSyntaxEditorCheckLabel);
        this.mComponentOrder.add(this.mBtdOptionsList);
        this.mComponentOrder.addAll(Arrays.asList(this.mOptionDialog.getCmdButtonPanel().getComponents()));
    }

    @Override
    public void initPanel() {
        super.initPanel();
        double[] dArray = new double[]{-1.0, -1.0};
        double[] dArray2 = new double[]{DialogUtil.getComponentGroupGap(), -2.0, -2.0, -2.0};
        int n = 3;
        TableLayout tableLayout = new TableLayout(dArray, dArray2);
        this.setLayout((LayoutManager)tableLayout);
        tableLayout.setHGap(n);
        tableLayout.setVGap(n);
        JPanel jPanel = this.createLangEncodPanel();
        JPanel jPanel2 = this.createBidiSettingsPanel();
        this.add((Component)jPanel, "0, 1, 0, 3");
        this.add((Component)jPanel2, "1, 1, 0, 3");
    }

    private JPanel createLangEncodPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        JPanel jPanel2 = this.createLangsPanel();
        JPanel jPanel3 = this.createCharEncodingPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        Insets insets = new Insets(0, 0, 0, 0);
        int n = 23;
        OptionsUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n, insets);
        OptionsUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 1, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel createLangsPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel(new GridBagLayout(), true);
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_LANGUAGE")));
        JLabel jLabel = new JLabel(this.getResString("IDS_USER_INTERFACE2"));
        JLabel jLabel2 = new JLabel(this.getResString("IDS_OUTPUT_LANG2"));
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        OptionsUtil.addUsingGBL(jPanel, jLabel2, gridBagConstraints, 0, 0, 1, 1, 23, new Insets(10, 0, 15, 0));
        OptionsUtil.addUsingGBL(jPanel, this.mOLangList, gridBagConstraints, 1, 0, 1, 1, 24, new Insets(10, 0, 10, 5));
        OptionsUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 1, 1, 1, 23, new Insets(15, 0, 15, 0));
        OptionsUtil.addUsingGBL(jPanel, this.mUILangList, gridBagConstraints, 1, 1, 1, 1, 24, new Insets(15, 0, 10, 5));
        jLabel.setLabelFor(this.mUILangList);
        jLabel2.setLabelFor(this.mOLangList);
        return jPanel;
    }

    private JPanel createBidiSettingsPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_BIDI_TEXT")));
        jPanel.setLayout(new GridBagLayout());
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        int n = 23;
        OptionsUtil.addUsingGBL(jPanel, this.mBtdSelInfoLabel, gridBagConstraints, 0, 0, 2, 1, n, new Insets(0, 5, 10, 0));
        OptionsUtil.addUsingGBL(jPanel, this.mBtdCntxInfoLabel, gridBagConstraints, 0, 1, 2, 1, n, new Insets(10, 5, 20, 0));
        OptionsUtil.addUsingGBL(jPanel, this.mBtdRestartInfoLabel, gridBagConstraints, 0, 2, 2, 1, n, new Insets(0, 5, 20, 0));
        OptionsUtil.addUsingGBL(jPanel, this.mBtdSyntaxEditorCheckLabel, gridBagConstraints, 0, 3, 2, 1, n, new Insets(0, 5, 20, 0));
        gridBagConstraints.weightx = 0.0;
        OptionsUtil.addUsingGBL(jPanel, this.mBtdOptionSelectionLbl, gridBagConstraints, 0, 4, 1, 1, 23, new Insets(0, 5, 10, 10));
        gridBagConstraints.weightx = 1.0;
        OptionsUtil.addUsingGBL(jPanel, this.mBtdOptionsList, gridBagConstraints, 1, 4, 1, 1, 24, new Insets(0, 0, 0, 5));
        JPanel jPanel2 = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        jPanel2.setLayout(new GridBagLayout());
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        OptionsUtil.addUsingGBL(jPanel2, jPanel, gridBagConstraints, 0, 0, 1, 1, 23, new Insets(0, 0, 0, 0));
        return jPanel2;
    }

    @Override
    public void readPrefs() {
        String string = this.mOptionsPrefs.get("char_encoding", PrefDefaults.DEF_CHAR_ENCODING);
        int n = DialogUtil.getIndexOfItem(IOptionConstants.CHAR_ENCODING_VALUES, string);
        DialogUtil.setSelectedButton(this.mCharEncodingButtonGrp, n);
        string = ComponentState.localeToNLV((Locale)ComponentState.getOLangLocale()).getName();
        n = DialogUtil.getIndexOfItem(IOptionConstants.OUTPUT_LANGUAGE_VALUES, string);
        if (n < 0) {
            n = 0;
        }
        this.mOLangList.setSelectedIndex(n);
        string = PrefsMgr.getILangName();
        n = DialogUtil.getIndexOfItem(IOptionConstants.OUTPUT_LANGUAGE_VALUES, string);
        this.mUILangList.setSelectedIndex(n);
        Preferences preferences = PrefsMgr.getPrefsMgr().getCoreSetServerPrefs();
        string = preferences.get("Locale", this.getResString("IDS_CHAR_ENCODING_OS_WRITING_SYSTEM"));
        if (string.charAt(0) == '\'' && string.charAt(string.length() - 1) == '\'') {
            string = string.substring(1, string.length() - 1);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.mCharLocaleList.getItemCount(); ++i) {
            String string2 = (String)this.mCharLocaleList.getItemAt(i);
            arrayList.add(string2);
        }
        this.mInitialCharLocaleListIndex = DialogUtil.getIndexOfItemIgnoreCase(arrayList.toArray(new String[arrayList.size()]), string);
        this.mCharLocaleList.setSelectedIndex(this.mInitialCharLocaleListIndex);
        if (this.mInitialCharLocaleListIndex == -1) {
            this.mCharLocaleUserSpecified = string;
            this.mCharLocaleList.setSelectedItem(string);
        }
        if ((string = preferences.get("BASETEXTDIRECTION", "AUTOMATIC")).startsWith("AUT")) {
            this.mBtdOptionsList.setSelectedIndex(0);
        } else if (string.startsWith("RIG")) {
            this.mBtdOptionsList.setSelectedIndex(1);
        } else {
            this.mBtdOptionsList.setSelectedIndex(2);
        }
        this.addListeners();
    }

    @Override
    public void savePrefs() {
        Object object;
        if (this.mCharLocaleRadio.isEnabled() && this.mCharLocaleRadio.isSelected()) {
            this.mOptionsPrefs.put("char_encoding", IOptionConstants.CHAR_ENCODING_VALUES[0]);
        } else if (this.mCharUnicodeRadio.isEnabled() && this.mCharUnicodeRadio.isSelected()) {
            this.mOptionsPrefs.put("char_encoding", IOptionConstants.CHAR_ENCODING_VALUES[1]);
        }
        this.mOptionsPrefs.put("language", IOptionConstants.OUTPUT_LANGUAGE_VALUES[this.mOLangList.getSelectedIndex()]);
        if (this.mUILangChanged) {
            object = IOptionConstants.OUTPUT_LANGUAGE_VALUES[this.mUILangList.getSelectedIndex()];
            this.mOptionsPrefs.put("ui_language", (String)object);
            Locale locale = ComponentState.nlvNameToLocale((String)object);
            ComponentState.setILangLocale((Locale)locale);
            StatsHelp.getStatsHelp().startEclipseHelp(locale, Boolean.valueOf(UpdateUserPrefs.firstLaunchAfterInstall()));
            this.mUILangChanged = false;
        }
        if (this.mCharLocaleChanged || !this.mCharLocaleUserSpecified.equalsIgnoreCase((String)this.mCharLocaleList.getSelectedItem())) {
            object = PrefsMgr.getPrefsMgr().getCoreSetServerPrefs();
            if (this.mCharLocaleList.getSelectedIndex() == 0) {
                ((Preferences)object).put("Locale", "OSLOCALE");
            } else {
                ((Preferences)object).put("Locale", (String)this.mCharLocaleList.getSelectedItem());
            }
        }
        if (this.btdSelectionChanged) {
            object = PrefsMgr.getPrefsMgr().getCoreSetServerPrefs();
            int n = this.mBtdOptionsList.getSelectedIndex();
            if (n == 1) {
                System.setProperty("SPSS_BIDI_BTD", "1");
                ComponentState.setBTD((int)1);
                ((Preferences)object).put("BASETEXTDIRECTION", "RIGHTTOLEFT");
            } else if (n == 2) {
                System.setProperty("SPSS_BIDI_BTD", "2");
                ComponentState.setBTD((int)2);
                ((Preferences)object).put("BASETEXTDIRECTION", "LEFTTORIGHT");
            } else {
                System.setProperty("SPSS_BIDI_BTD", "0");
                ComponentState.setBTD((int)0);
                ((Preferences)object).put("BASETEXTDIRECTION", "AUTOMATIC");
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.mOLangList) {
            Statistics.resetNames();
            ProcedureDlgMgr.getMgr().clearDatasetMaps();
        } else if (object == this.mUILangList) {
            this.mUILangChanged = true;
            OptionsDlg.sConfirmDialogs.put(this.mUILangList, this.getResString("ERR_UI_LANG_CHANGED"));
        } else if (this.mBtdOptionsList != null && object == this.mBtdOptionsList && this.mBtdOptionsList.getSelectedIndex() != ComponentState.getBTD()) {
            this.btdSelectionChanged = true;
        }
        super.actionPerformed(actionEvent);
    }

    private boolean hasUIHelp() {
        String string = IOptionConstants.OUTPUT_LANGUAGE_VALUES[this.mUILangList.getSelectedIndex()];
        Locale locale = ComponentState.nlvNameToLocale((String)string);
        return StatsHelp.getStatsHelp().hasHelp(locale);
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        super.stateChanged(changeEvent);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        super.itemStateChanged(itemEvent);
        Object object = itemEvent.getSource();
        if (object == this.mCharLocaleList && this.mCharLocaleList.getSelectedIndex() != this.mInitialCharLocaleListIndex) {
            this.mCharLocaleChanged = true;
        }
    }

    @Override
    protected int getId() {
        return 4608;
    }

    private void addListeners() {
        this.mOLangList.addActionListener(this);
        this.mUILangList.addActionListener(this);
        this.mBtdOptionsList.addActionListener(this);
        this.mCharLocaleRadio.addItemListener(this);
        this.mCharUnicodeRadio.addItemListener(this);
        this.mCharLocaleList.addItemListener(this);
    }

    private JPanel createCharEncodingPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        Insets insets = new Insets(DialogUtil.getGroupBoxInnerMargin(), 2, DialogUtil.getGroupBoxInnerMargin(), 2);
        int n = 23;
        OptionsUtil.addUsingGBL(this.mCharPanel, this.mCharLocaleRadio, gridBagConstraints, 0, 0, 2, 1, n, insets);
        OptionsUtil.addUsingGBL(this.mCharPanel, this.mCharLocaleListLbl, gridBagConstraints, 0, 1, 1, 1, 23, new Insets(10, 40, 15, 0));
        OptionsUtil.addUsingGBL(this.mCharPanel, this.mCharLocaleList, gridBagConstraints, 1, 1, 1, 1, 24, new Insets(10, 0, 10, 5));
        insets.set(DialogUtil.getGroupBoxInnerMargin(), 2, DialogUtil.getGroupBoxInnerMargin(), 2);
        OptionsUtil.addUsingGBL(this.mCharPanel, this.mCharUnicodeRadio, gridBagConstraints, 0, 2, 2, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        insets.left += 20;
        OptionsUtil.addUsingGBL(this.mCharPanel, this.mCharInfoLabel, gridBagConstraints, 0, 3, 2, 1, n, insets);
        this.mCharLocaleListLbl.setLabelFor(this.mCharLocaleList);
        return this.mCharPanel;
    }
}

