/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.edit;

import com.spss.java_client.core.common.CPUInfo;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.common.fopen.RefFileFilter;
import com.spss.java_client.core.common.prefs.PrefDefaults;
import com.spss.java_client.core.common.prefs.PrefsMgr;
import com.spss.java_client.core.comp_util.FileLocationsUtil;
import com.spss.java_client.core.server.DataServerProxy;
import com.spss.java_client.ui.controls.FileTextField;
import com.spss.java_client.ui.controls.PanelFactory;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.controls.SpssMultiLineCheckBox;
import com.spss.java_client.ui.controls.SpssStaticText;
import com.spss.java_client.ui.dialogs.base.edit.OptionPanel;
import com.spss.java_client.ui.dialogs.base.edit.OptionsDlg;
import com.spss.java_client.ui.dialogs.base.edit.OptionsUtil;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.actions.ToggleButtonAction;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import com.spss.java_client.ui.laf.SpssPlasticXPLookAndFeel;
import com.spss.shared.core_tools.format.CommonState;
import com.spss.shared.core_tools.system.OSInfo;
import com.spss.uitools.controls.IntTextField;
import com.spss.uitools.util.IOptionConstants;
import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.io.File;
import java.util.Arrays;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;

public class GeneralOptionPanel
extends OptionPanel {
    static final String UI_HELP_KEY = "ui_help";
    public static final String[] LANG_ITEMS = new String[]{"IDS_LANG_ENGLISH", "IDS_LANG_SIMPLIFILED_CHINESE", "IDS_LANG_TRADITIONAL_CHINESE", "IDS_LANG_FRENCH", "IDS_LANG_GERMAN", "IDS_LANG_ITALIAN", "IDS_LANG_JAPANESE", "IDS_LANG_KOREAN", "IDS_LANG_POLISH", "IDS_LANG_PORTUGUESE_BRAZIL", "IDS_LANG_RUSSIAN", "IDS_LANG_SPANISH"};
    private JRadioButton mDisplayLbls;
    private JRadioButton mDisplayNames;
    private SpssButtonGroup mDisplayButtonGrp;
    private JRadioButton mAlphaButton;
    private JRadioButton mFileButton;
    private JRadioButton mMeasurementLevelButton;
    private JRadioButton mUseRoles;
    private JRadioButton mDontUseRoles;
    private JRadioButton threadsAutomation;
    private JRadioButton numberOfThreads;
    private IntTextField threadsValue;
    private SpssButtonGroup mSortButtonGrp;
    private JCheckBox mSynWinCbox;
    private JCheckBox mOnlyOneDataset;
    private JLabel mMeasureLbl;
    private JComboBox mMeasureList;
    private JLabel mNotifiLbl;
    private JCheckBox mRaiseCheck;
    private JCheckBox mScrollCheck;
    private JRadioButton mNoneRadio;
    private JRadioButton mBeepRadio;
    private JRadioButton mSoundRadio;
    private SpssButtonGroup mSoundButtonGrp;
    private JButton mBrowseSound;
    private FileTextField mSoundFileText;
    private JCheckBox mSciNotation;
    private JCheckBox mGrouping;
    private JCheckBox mDisplayLeadZero;
    private JComboBox mLookAndFeelCombo;
    private JLabel mLookAndFeelLbl;
    private boolean mLookAndFeelModified;
    private boolean mThreadsModified;
    private JCheckBox mAutoCheckUpdateCheckbox;

    public GeneralOptionPanel(OptionsDlg optionsDlg, Preferences preferences, String string) {
        super(optionsDlg, preferences, string);
        this.setOpaque(false);
        this.setOptionsChanged(false);
    }

    @Override
    public String getDialogHelpID() {
        return "idh_pref_general";
    }

    public boolean getLAFModified() {
        return this.mLookAndFeelModified;
    }

    public boolean getThreadsModified() {
        return this.mThreadsModified;
    }

    @Override
    public void initVars() {
        this.mLookAndFeelModified = false;
        this.mLookAndFeelCombo = new JComboBox();
        this.checkOS();
        this.mLookAndFeelLbl = DialogUtil.createLabel(this.mOptionDialog, "IDS_LOOK_AND_FEEL");
        this.mLookAndFeelLbl.setLabelFor(this.mLookAndFeelCombo);
        this.mDisplayLbls = DialogUtil.createRadioButton(this.mOptionDialog, "IDS_DISPLAY_LBLS", (ActionListener)this);
        this.mDisplayNames = DialogUtil.createRadioButton(this.mOptionDialog, "IDS_DISPLAY_NAMES", (ActionListener)this);
        this.mDisplayLbls.setSelected(true);
        this.mDisplayButtonGrp = new SpssButtonGroup();
        this.mDisplayButtonGrp.add(this.mDisplayLbls);
        this.mDisplayButtonGrp.add(this.mDisplayNames);
        this.mAlphaButton = DialogUtil.createRadioButton(this.mOptionDialog, "IDS_ALPHA", (ActionListener)this);
        this.mFileButton = DialogUtil.createRadioButton(this.mOptionDialog, "IDS_FILE", (ActionListener)this);
        this.mMeasurementLevelButton = DialogUtil.createRadioButton(this.mOptionDialog, "IDS_MEASUREMENT_LEVEL", (ActionListener)this);
        this.mFileButton.setSelected(true);
        this.mSortButtonGrp = new SpssButtonGroup();
        this.mSortButtonGrp.add(this.mAlphaButton);
        this.mSortButtonGrp.add(this.mFileButton);
        this.mSortButtonGrp.add(this.mMeasurementLevelButton);
        this.mUseRoles = DialogUtil.createRadioButton(this.mOptionDialog, "IDS_USE_ROLES", (ActionListener)this);
        this.mDontUseRoles = DialogUtil.createRadioButton(this.mOptionDialog, "IDS_DONT_USE_ROLES", (ActionListener)this);
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        spssButtonGroup.add(this.mUseRoles);
        spssButtonGroup.add(this.mDontUseRoles);
        this.mUseRoles.setSelected(true);
        this.threadsAutomation = DialogUtil.createRadioButton(this.mOptionDialog, "IDS_THREADS_AUTO", (ActionListener)this);
        this.numberOfThreads = DialogUtil.createRadioButton(this.mOptionDialog, "IDS_THREADS_NUMBER", (ActionListener)this);
        this.threadsValue = new IntTextField(true);
        this.threadsAutomation.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                GeneralOptionPanel.this.mThreadsModified = true;
                GeneralOptionPanel.this.setOptionsChanged(true);
                if (GeneralOptionPanel.this.threadsAutomation.isSelected()) {
                    GeneralOptionPanel.this.threadsValue.setEnabled(false);
                }
            }
        });
        this.numberOfThreads.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (GeneralOptionPanel.this.numberOfThreads.isSelected()) {
                    GeneralOptionPanel.this.threadsValue.setEnabled(true);
                }
            }
        });
        SpssButtonGroup spssButtonGroup2 = new SpssButtonGroup();
        spssButtonGroup2.add(this.threadsAutomation);
        spssButtonGroup2.add(this.numberOfThreads);
        this.threadsAutomation.setSelected(true);
        if (CommonState.getApplicationType() != CommonState.AppType.MODELER && CommonState.getApplicationType() != CommonState.AppType.MODELERCLOUD) {
            int n = CPUInfo.getLogicalCPUCount();
            this.threadsValue.setText(String.valueOf(n));
            if (DataServerProxy.getDataProxy().isRemoteConnection()) {
                this.threadsAutomation.setEnabled(false);
                this.numberOfThreads.setEnabled(false);
                this.threadsValue.setEnabled(false);
            }
        }
        if (VersionInfo.allowSyntax()) {
            this.mSynWinCbox = DialogUtil.createCheckBox(this.mOptionDialog, "IDS_SYNTAX_WIN", (ActionListener)this);
        }
        this.mOnlyOneDataset = DialogUtil.createCheckBox(this.mOptionDialog, "IDS_ONLY_ONE_DATASET", (ActionListener)this);
        this.mMeasureLbl = DialogUtil.createLabel(this.mOptionDialog, "IDS_MEASURE_SYSTEM");
        String[] stringArray = new String[]{this.getResString("IDS_MEASURE_POINTS"), this.getResString("IDS_MEASURE_INCHES"), this.getResString("IDS_MEASURE_CENTIMETERS")};
        this.mMeasureList = new JComboBox<String>(stringArray);
        this.mMeasureLbl.setLabelFor(this.mMeasureList);
        this.mNotifiLbl = DialogUtil.createLabel(this.mOptionDialog, "IDS_NOTIFICATION");
        this.mRaiseCheck = DialogUtil.createCheckBox(this.mOptionDialog, "IDS_RAISE_VIEW", (ActionListener)this);
        this.mScrollCheck = DialogUtil.createCheckBox(this.mOptionDialog, "IDS_SCROLL_OUT", (ActionListener)this);
        this.mNotifiLbl.setLabelFor(this.mRaiseCheck);
        this.mRaiseCheck.setSelected(true);
        this.mScrollCheck.setSelected(true);
        SpssButtonGroup spssButtonGroup3 = new SpssButtonGroup();
        spssButtonGroup3.add(this.mRaiseCheck);
        spssButtonGroup3.add(this.mScrollCheck);
        JLabel jLabel = DialogUtil.createLabel(this.mOptionDialog, "IDS_SOUND");
        this.mNoneRadio = DialogUtil.createRadioButton(this.mOptionDialog, "IDS_NONE", (ActionListener)this);
        this.mNoneRadio.setSelected(true);
        this.mBeepRadio = DialogUtil.createRadioButton(this.mOptionDialog, "IDS_SYSTEM_BEEP", (ActionListener)this);
        this.mSoundRadio = DialogUtil.createRadioButton(this.mOptionDialog, "IDS_SOUND_SELECTED", (ActionListener)this);
        jLabel.setLabelFor(this.mNoneRadio);
        this.mSoundButtonGrp = new SpssButtonGroup();
        this.mSoundButtonGrp.add(this.mNoneRadio);
        this.mSoundButtonGrp.add(this.mBeepRadio);
        this.mSoundButtonGrp.add(this.mSoundRadio);
        this.mSoundFileText = new FileTextField();
        this.mSoundFileText.setOpaque(false);
        this.mSoundFileText.setEditable(false);
        this.mSoundFileText.setEnabled(false);
        this.mSoundFileText.setBorder(BorderFactory.createEmptyBorder());
        this.mBrowseSound = DialogUtil.createButton(this.mOptionDialog, "IDS_SOUND_BROWSE", this);
        ToggleButtonAction toggleButtonAction = new ToggleButtonAction(this.mOptionDialog, "IDS_NO_SCI_NTN");
        this.mSciNotation = new SpssMultiLineCheckBox(toggleButtonAction, 360);
        this.mSciNotation.addActionListener(this);
        toggleButtonAction = new ToggleButtonAction(this.mOptionDialog, "IDS_DIGIT_GROUPING");
        this.mGrouping = new SpssMultiLineCheckBox(toggleButtonAction, 360);
        this.mGrouping.addActionListener(this);
        toggleButtonAction = new ToggleButtonAction(this.mOptionDialog, "IDS_DISPLAY_LEAD_ZERO");
        this.mDisplayLeadZero = new SpssMultiLineCheckBox(toggleButtonAction, 360);
        this.mDisplayLeadZero.addActionListener(this);
        this.mBrowseSound.setEnabled(false);
        this.mAutoCheckUpdateCheckbox = DialogUtil.createCheckBox(this.mOptionDialog, "IDS_AUTO_CHECK_UPDATE", (ActionListener)this);
        this.mAutoCheckUpdateCheckbox.setSelected(true);
        this.mComponentOrder.add(this.mDisplayButtonGrp);
        this.mComponentOrder.add(this.mSortButtonGrp);
        this.mComponentOrder.add(spssButtonGroup);
        this.mComponentOrder.add(spssButtonGroup2);
        this.mComponentOrder.add(this.mSciNotation);
        this.mComponentOrder.add(this.mGrouping);
        this.mComponentOrder.add(this.mDisplayLeadZero);
        this.mComponentOrder.add(this.mMeasureList);
        this.mComponentOrder.add(this.mRaiseCheck);
        this.mComponentOrder.add(this.mScrollCheck);
        this.mComponentOrder.add(this.mAutoCheckUpdateCheckbox);
        this.mComponentOrder.add(this.mLookAndFeelCombo);
        if (this.mSynWinCbox != null) {
            this.mComponentOrder.add(this.mSynWinCbox);
        }
        this.mComponentOrder.add(this.mOnlyOneDataset);
        this.mComponentOrder.addAll(Arrays.asList(this.mOptionDialog.getCmdButtonPanel().getComponents()));
    }

    @Override
    public void initPanel() {
        super.initPanel();
        double[] dArray = new double[]{-1.0, -1.0};
        double[] dArray2 = new double[]{DialogUtil.getComponentGroupGap(), -2.0, -2.0, -2.0};
        int n = 3;
        TableLayout tableLayout = new TableLayout(dArray, dArray2);
        this.setLayout((LayoutManager)tableLayout);
        tableLayout.setHGap(n);
        tableLayout.setVGap(n);
        JPanel jPanel = this.createVarSessTempPanel();
        JPanel jPanel2 = this.createOutputPanel();
        if (CommonState.getApplicationType() == CommonState.AppType.MODELER || CommonState.getApplicationType() == CommonState.AppType.MODELERCLOUD) {
            this.add((Component)jPanel2, "0, 1, 0, 1");
        } else {
            this.add((Component)jPanel, "0, 1, 0, 3");
            this.add((Component)jPanel2, "1, 1, 1, 3");
        }
    }

    @Override
    public void readPrefs() {
        int n;
        Preferences preferences = this.mOptionsPrefs;
        String string = preferences.get("var_list_display", PrefDefaults.DEF_VAR_LIST_DISPLAY_LABELS);
        int n2 = DialogUtil.getIndexOfItem(IOptionConstants.VAR_LIST_DISPLAY_VALUES, string);
        DialogUtil.setSelectedButton(this.mDisplayButtonGrp, n2);
        string = preferences.get("var_list_sort", PrefDefaults.DEF_VAR_LIST_SORT_ORDER_FILE);
        n2 = DialogUtil.getIndexOfItem(IOptionConstants.VAR_LIST_SORT_VALUES, string);
        DialogUtil.setSelectedButton(this.mSortButtonGrp, n2);
        if (preferences.get("no_sci_notation", "false").equals("false")) {
            this.mSciNotation.setSelected(false);
        } else {
            this.mSciNotation.setSelected(true);
        }
        if (preferences.get("digit_grouping", "No").equalsIgnoreCase("yes")) {
            this.mGrouping.setSelected(true);
        } else {
            this.mGrouping.setSelected(false);
        }
        if (preferences.get("lead_zero", "No").equalsIgnoreCase("yes")) {
            this.mDisplayLeadZero.setSelected(true);
        } else {
            this.mDisplayLeadZero.setSelected(false);
        }
        string = preferences.get("measurement_system", PrefDefaults.DEF_MEASUREMENT_UNITS);
        n2 = DialogUtil.getIndexOfItem(IOptionConstants.OUTPUT_MEASUREMENT_SYSTEM_VALUES, string);
        this.mMeasureList.setSelectedIndex(n2);
        this.mRaiseCheck.setSelected(preferences.getBoolean("raise_viewer_window", true));
        this.mScrollCheck.setSelected(preferences.getBoolean("scroll_to_new", true));
        string = preferences.get("output_sound", PrefDefaults.DEF_OUTPUT_SOUND);
        n2 = DialogUtil.getIndexOfItem(IOptionConstants.OUTPUT_SOUND_VALUES, string);
        DialogUtil.setSelectedButton(this.mSoundButtonGrp, n2);
        if (n2 == 0 || n2 == 1) {
            this.mBrowseSound.setEnabled(false);
            this.mSoundFileText.setEnabled(false);
        } else if (n2 == 2) {
            this.mBrowseSound.setEnabled(true);
            this.mSoundFileText.setEnabled(true);
        }
        this.mSoundFileText.setText(preferences.get("sound_file", ""));
        if (this.mSynWinCbox != null) {
            this.mSynWinCbox.setSelected(preferences.getBoolean("open_syntax_window", false));
        }
        this.mOnlyOneDataset.setSelected(preferences.getBoolean("only_one_dataset", false));
        this.mLookAndFeelCombo.setSelectedIndex(preferences.getInt("look_and_feel_index", 0));
        boolean bl = preferences.getBoolean("use_roles", true);
        if (bl) {
            this.mUseRoles.setSelected(true);
        } else {
            this.mDontUseRoles.setSelected(true);
        }
        Preferences preferences2 = PrefsMgr.getPrefsMgr().getCoreSetServerPrefs();
        String string2 = preferences2.get("THREADS", "AUTO");
        if (string2.equalsIgnoreCase("AUTO")) {
            this.threadsAutomation.setSelected(true);
            this.threadsValue.setEnabled(false);
        } else {
            n = Integer.valueOf(string2);
            if (0 == n) {
                n = CPUInfo.getLogicalCPUCount();
            }
            this.numberOfThreads.setSelected(true);
            this.threadsValue.setText(String.valueOf(n));
            this.threadsValue.setEnabled(true);
        }
        n = preferences.getBoolean("is_auto_update", true) ? 1 : 0;
        if (n != 0) {
            this.mAutoCheckUpdateCheckbox.setSelected(true);
        } else {
            this.mAutoCheckUpdateCheckbox.setSelected(false);
        }
        this.addListeners();
    }

    @Override
    public void savePrefs() {
        Preferences preferences = this.mOptionsPrefs;
        if (this.mLookAndFeelCombo.getSelectedItem().equals(this.getResString("IDS_LOOK_AND_FEEL_SPSS"))) {
            preferences.put("look_and_feel", "com.spss.cobalt_laf.CobaltLookAndFeel");
        } else if (this.mLookAndFeelCombo.getSelectedItem().equals(this.getResString("IDS_LOOK_AND_FEEL_SPSSFASHION"))) {
            preferences.put("look_and_feel", "com.spss.analytics_laf.AnalyticsLafLookAndFeel");
        } else if (this.mLookAndFeelCombo.getSelectedItem().equals(this.getResString("IDS_LOOK_AND_FEEL_WINDOWS"))) {
            preferences.put("look_and_feel", UIManager.getSystemLookAndFeelClassName());
        } else if (this.mLookAndFeelCombo.getSelectedItem().equals(this.getResString("IDS_LOOK_AND_FEEL_LINUX"))) {
            preferences.put("look_and_feel", "com.sun.java.swing.plaf.motif.MotifLookAndFeel");
        } else if (this.mLookAndFeelCombo.getSelectedItem().equals(this.getResString("IDS_LOOK_AND_FEEL_MACINTOSH"))) {
            preferences.put("look_and_feel", UIManager.getSystemLookAndFeelClassName());
        } else if (this.mLookAndFeelCombo.getSelectedItem().equals(this.getResString("IDS_LOOK_AND_FEEL_PLASTIC"))) {
            preferences.put("look_and_feel", SpssPlasticXPLookAndFeel.class.getName());
        }
        preferences.putInt("look_and_feel_index", this.mLookAndFeelCombo.getSelectedIndex());
        if (this.mDisplayLbls.isSelected()) {
            preferences.put("var_list_display", IOptionConstants.VAR_LIST_DISPLAY_VALUES[0]);
        } else {
            preferences.put("var_list_display", IOptionConstants.VAR_LIST_DISPLAY_VALUES[1]);
        }
        if (this.mAlphaButton.isSelected()) {
            preferences.put("var_list_sort", IOptionConstants.VAR_LIST_SORT_VALUES[0]);
        } else if (this.mFileButton.isSelected()) {
            preferences.put("var_list_sort", IOptionConstants.VAR_LIST_SORT_VALUES[1]);
        } else {
            preferences.put("var_list_sort", IOptionConstants.VAR_LIST_SORT_VALUES[2]);
        }
        if (this.mSciNotation.isSelected()) {
            preferences.putBoolean("no_sci_notation", true);
        } else {
            preferences.putBoolean("no_sci_notation", false);
        }
        if (this.mGrouping.isSelected()) {
            preferences.put("digit_grouping", "Yes");
        } else {
            preferences.put("digit_grouping", "No");
        }
        if (this.mDisplayLeadZero.isSelected()) {
            preferences.put("lead_zero", "Yes");
        } else {
            preferences.put("lead_zero", "No");
        }
        preferences.put("measurement_system", IOptionConstants.OUTPUT_MEASUREMENT_SYSTEM_VALUES[this.mMeasureList.getSelectedIndex()]);
        if (this.mRaiseCheck.isSelected()) {
            preferences.putBoolean("raise_viewer_window", true);
        } else {
            preferences.putBoolean("raise_viewer_window", false);
        }
        if (this.mScrollCheck.isSelected()) {
            preferences.putBoolean("scroll_to_new", true);
        } else {
            preferences.putBoolean("scroll_to_new", false);
        }
        if (this.mNoneRadio.isSelected()) {
            preferences.put("output_sound", IOptionConstants.OUTPUT_SOUND_VALUES[0]);
        } else if (this.mBeepRadio.isSelected()) {
            preferences.put("output_sound", IOptionConstants.OUTPUT_SOUND_VALUES[1]);
        } else {
            preferences.put("output_sound", IOptionConstants.OUTPUT_SOUND_VALUES[2]);
        }
        preferences.put("sound_file", this.mSoundFileText.getText());
        if (this.mSynWinCbox != null && this.mSynWinCbox.isSelected()) {
            preferences.putBoolean("open_syntax_window", true);
        } else {
            preferences.putBoolean("open_syntax_window", false);
        }
        if (this.mOnlyOneDataset.isSelected()) {
            preferences.putBoolean("only_one_dataset", true);
        } else {
            preferences.putBoolean("only_one_dataset", false);
        }
        Preferences preferences2 = PrefsMgr.getPrefsMgr().getCoreSetServerPrefs();
        if (this.threadsAutomation.isSelected()) {
            preferences2.put("THREADS", "AUTO");
        } else {
            preferences2.put("THREADS", this.threadsValue.getText());
        }
        preferences.putBoolean("use_roles", this.mUseRoles.isSelected());
        if (this.mAutoCheckUpdateCheckbox.isSelected()) {
            preferences.putBoolean("is_auto_update", true);
        } else {
            preferences.putBoolean("is_auto_update", false);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.mDisplayLbls || object == this.mDisplayNames || object == this.mFileButton || object == this.mAlphaButton || object == this.mMeasurementLevelButton) {
            OptionsDlg.sConfirmDialogs.put(this.mDisplayLbls, this.getResString("ERR_VARIBLE_LIST_CHANGED"));
        } else if (object == this.mBrowseSound) {
            int n;
            RemoteFileChooser remoteFileChooser = new RemoteFileChooser(RemoteFileChooser.ChooserType.OpenFile, RemoteFileChooser.ChooserOption.Generic, FileLocationsUtil.getOtherFilesDirectoryPath(), false);
            RefFileFilter refFileFilter = new RefFileFilter(this.getResString("IDS_SOUND_FILE_FILTER"), this.getResString("IDS_WAV"));
            remoteFileChooser.addChoosableFileFilter((FileFilter)refFileFilter);
            remoteFileChooser.setAcceptAllFileFilterUsed(true);
            remoteFileChooser.setFileFilter((FileFilter)refFileFilter);
            if (!this.mSoundFileText.getText().equals("")) {
                remoteFileChooser.setCurrentDirectory(new File(this.mSoundFileText.getText()));
            }
            if ((n = remoteFileChooser.showOpenDialog((Component)((Object)this.mOptionDialog))) == 0) {
                String string = remoteFileChooser.getSelectedFilePath();
                this.mSoundRadio.setSelected(true);
                String string2 = string.toLowerCase();
                int n2 = string2.indexOf(this.getResString("IDS_WAV"));
                if (n2 == -1) {
                    string = string.concat(this.getResString("IDS_WAV"));
                } else if (!string2.substring(n2).equals(this.getResString("IDS_WAV"))) {
                    string = string.concat(this.getResString("IDS_WAV"));
                }
                this.mSoundFileText.setText(string);
            }
        } else if (object == this.mLookAndFeelCombo) {
            this.mLookAndFeelModified = true;
        } else if (object == this.numberOfThreads || object == this.threadsValue) {
            int n;
            int n3 = Integer.parseInt(this.threadsValue.getText());
            if (n3 > (n = CPUInfo.getLogicalCPUCount())) {
                OptionsDlg.sConfirmDialogs.put(this.threadsValue, this.getResString("IDS_THREADS_WARN_MAX"));
            }
            if (n3 <= 0) {
                OptionsDlg.sConfirmDialogs.put(this.threadsValue, this.getResString("IDS_THREADS_WARN_ZERO"));
            } else {
                this.mThreadsModified = true;
            }
        } else if (object == this.threadsAutomation) {
            this.mThreadsModified = true;
        }
        super.actionPerformed(actionEvent);
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        super.stateChanged(changeEvent);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.mNoneRadio || object == this.mBeepRadio) {
            this.mBrowseSound.setEnabled(false);
            this.mSoundFileText.setEnabled(false);
        } else if (object == this.mSoundRadio) {
            this.mBrowseSound.setEnabled(true);
            this.mSoundFileText.setEnabled(true);
        }
        super.itemStateChanged(itemEvent);
    }

    private void checkOS() {
        String string = this.getResString("IDS_LOOK_AND_FEEL_SPSS");
        String string2 = this.getResString("IDS_LOOK_AND_FEEL_SPSSFASHION");
        OSInfo.OSType oSType = OSInfo.getOSType();
        if (oSType == OSInfo.OSType.WIN) {
            this.mLookAndFeelCombo.addItem(string);
            this.mLookAndFeelCombo.addItem(this.getResString("IDS_LOOK_AND_FEEL_PLASTIC"));
            this.mLookAndFeelCombo.addItem(this.getResString("IDS_LOOK_AND_FEEL_WINDOWS"));
        } else if (oSType == OSInfo.OSType.LINUX) {
            this.mLookAndFeelCombo.addItem(string);
            this.mLookAndFeelCombo.addItem(this.getResString("IDS_LOOK_AND_FEEL_PLASTIC"));
            this.mLookAndFeelCombo.addItem(this.getResString("IDS_LOOK_AND_FEEL_LINUX"));
        } else if (oSType == OSInfo.OSType.MAC) {
            this.mLookAndFeelCombo.addItem(this.getResString("IDS_LOOK_AND_FEEL_MACINTOSH"));
            String string3 = System.getProperty("java.version");
            if (!string3.startsWith("1.5")) {
                this.mLookAndFeelCombo.addItem(string);
            }
            this.mLookAndFeelCombo.addItem(this.getResString("IDS_LOOK_AND_FEEL_PLASTIC"));
        }
    }

    @Override
    protected int getId() {
        return 1;
    }

    private void addListeners() {
        this.mDisplayLbls.addItemListener(this);
        this.mDisplayNames.addItemListener(this);
        this.mAlphaButton.addItemListener(this);
        this.mFileButton.addItemListener(this);
        this.mMeasurementLevelButton.addItemListener(this);
        this.mMeasureList.addActionListener(this);
        this.mNoneRadio.addItemListener(this);
        this.mBeepRadio.addItemListener(this);
        this.mSoundRadio.addItemListener(this);
        this.mLookAndFeelCombo.addActionListener(this);
        this.threadsAutomation.addActionListener(this);
        this.numberOfThreads.addActionListener(this);
        this.threadsValue.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                GeneralOptionPanel.this.actionPerformed(new ActionEvent(GeneralOptionPanel.this.threadsValue, 0, ""));
            }
        });
    }

    private JPanel createVarSessTempPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        JPanel jPanel2 = this.createVariableListPanel();
        JPanel jPanel3 = this.createRolesPanel();
        JPanel jPanel4 = this.createThreadsPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        Insets insets = new Insets(0, 0, 0, 0);
        int n = 23;
        OptionsUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        OptionsUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 1, 1, 1, n, insets);
        OptionsUtil.addUsingGBL(jPanel, jPanel4, gridBagConstraints, 0, 2, 1, 1, n, insets);
        JPanel jPanel5 = new JPanel();
        gridBagConstraints.weighty = 0.0;
        OptionsUtil.addUsingGBL(jPanel, jPanel5, gridBagConstraints, 0, 2, 1, 1, 23, new Insets(12, 12, 12, 12));
        return jPanel;
    }

    private JPanel createRolesPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_ROLES")));
        SpssStaticText spssStaticText = new SpssStaticText(this.getResString("INFO_ROLES_MSG"));
        int n = 3;
        double[] dArray = new double[]{-2.0, -2.0, -2.0};
        double[] dArray2 = new double[]{n, -1.0, n};
        TableLayout tableLayout = new TableLayout(dArray2, dArray);
        jPanel.setLayout((LayoutManager)tableLayout);
        tableLayout.setHGap(n);
        tableLayout.setVGap(n);
        jPanel.add((Component)spssStaticText, "1, 0");
        jPanel.add((Component)this.mUseRoles, "1, 1");
        jPanel.add((Component)this.mDontUseRoles, "1, 2");
        return jPanel;
    }

    private JPanel createThreadsPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_THREADS")));
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        Insets insets = new Insets(DialogUtil.getComponentGroupGap(), 0, 0, 0);
        int n = 23;
        gridBagConstraints.weighty = 0.0;
        insets.set(DialogUtil.getComponentGroupGap(), DialogUtil.getGroupBoxInnerMargin(), 0, 0);
        OptionsUtil.addUsingGBL(jPanel, this.threadsAutomation, gridBagConstraints, 0, 0, 1, 1, n, insets);
        OptionsUtil.addUsingGBL(jPanel, this.numberOfThreads, gridBagConstraints, 0, 1, 1, 1, n, insets);
        n = 24;
        gridBagConstraints.fill = 2;
        insets.set(DialogUtil.getComponentGroupGap(), 0, 0, 2);
        OptionsUtil.addUsingGBL(jPanel, (JComponent)this.threadsValue, gridBagConstraints, 1, 1, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel createWindowsPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_WINDOWS_PANEL")));
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        Insets insets = new Insets(DialogUtil.getComponentGroupGap(), 0, 0, 0);
        int n = 23;
        gridBagConstraints.weighty = 0.0;
        insets.set(DialogUtil.getComponentGroupGap(), DialogUtil.getGroupBoxInnerMargin(), 0, 0);
        OptionsUtil.addUsingGBL(jPanel, this.mLookAndFeelLbl, gridBagConstraints, 0, 0, 1, 1, n, insets);
        n = 24;
        gridBagConstraints.fill = 2;
        insets.set(DialogUtil.getComponentGroupGap(), 0, 0, 2);
        OptionsUtil.addUsingGBL(jPanel, this.mLookAndFeelCombo, gridBagConstraints, 1, 0, 1, 1, n, insets);
        n = 23;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 1.0;
        insets.set(DialogUtil.getComponentGroupGap(), 0, 0, 0);
        JPanel jPanel2 = this.createSyntaxDatasetPanel();
        OptionsUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 2, 2, 1, n, insets);
        JPanel jPanel3 = new JPanel();
        gridBagConstraints.weighty = 0.0;
        OptionsUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 3, 1, 1, 23, OptionsUtil.DROPDOWN_INSETS);
        return jPanel;
    }

    private JPanel createSyntaxDatasetPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        int n = DialogUtil.getGroupBoxInnerMargin();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n2 = 23;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        Insets insets = new Insets(n, n, 0, n);
        int n3 = 0;
        if (this.mSynWinCbox != null) {
            insets.set(DialogUtil.getComponentGroupGap(), n, n, n);
            OptionsUtil.addUsingGBL(jPanel, this.mSynWinCbox, gridBagConstraints, 0, n3, 1, 1, n2, insets);
            ++n3;
        }
        insets.set(3, n, n, n);
        OptionsUtil.addUsingGBL(jPanel, this.mOnlyOneDataset, gridBagConstraints, 0, n3, 1, 1, n2, insets);
        return jPanel;
    }

    private JPanel createVariableListPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_VAR_LISTS")));
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = 23;
        JComponent[] jComponentArray = new JComponent[]{this.mDisplayLbls, this.mDisplayNames};
        JPanel jPanel2 = PanelFactory.getBasicPanel(jComponentArray, PanelFactory.PanelType.yaxis, "", true);
        OptionsUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n, insets);
        JPanel jPanel3 = new JPanel();
        DialogUtil.applyTopBorder(jPanel3);
        gridBagConstraints.weighty = 0.0;
        Insets insets2 = new Insets(4, DialogUtil.getGroupBoxInnerMargin(), 0, DialogUtil.getGroupBoxInnerMargin());
        OptionsUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 2, 3, 1, n, insets2);
        n = 23;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        JComponent[] jComponentArray2 = new JComponent[]{this.mAlphaButton, this.mFileButton, this.mMeasurementLevelButton};
        JPanel jPanel4 = PanelFactory.getBasicPanel(jComponentArray2, PanelFactory.PanelType.yaxis, "", true);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        OptionsUtil.addUsingGBL(jPanel, jPanel4, gridBagConstraints, 0, 4, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel createOutputPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_OUTPUT")));
        JPanel jPanel2 = this.createMeasurePanel();
        JPanel jPanel3 = this.createNotifyPanel();
        JPanel jPanel4 = this.createSciNotationPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        int n = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(0, 0, 0, n);
        int n2 = 23;
        gridBagConstraints.fill = 1;
        if (CommonState.getApplicationType() != CommonState.AppType.MODELER && CommonState.getApplicationType() != CommonState.AppType.MODELERCLOUD) {
            gridBagConstraints.weighty = 0.0;
            OptionsUtil.addUsingGBL(jPanel, jPanel4, gridBagConstraints, 0, 0, 1, 1, n2, insets);
        }
        gridBagConstraints.weighty = 0.0;
        insets.set(n, 0, 0, n);
        OptionsUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 2, 1, 1, n2, insets);
        gridBagConstraints.weighty = 0.5;
        gridBagConstraints.fill = 2;
        if (CommonState.getApplicationType() != CommonState.AppType.MODELER && CommonState.getApplicationType() != CommonState.AppType.MODELERCLOUD) {
            OptionsUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 4, 1, 1, n2, insets);
        }
        JPanel jPanel5 = this.createWindowsPanel();
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        n = DialogUtil.getGroupBoxInnerMargin();
        insets = new Insets(0, 0, 0, 0);
        n2 = 23;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weighty = 0.0;
        OptionsUtil.addUsingGBL(jPanel6, jPanel, gridBagConstraints, 0, 0, 1, 1, n2, insets);
        if (CommonState.getApplicationType() != CommonState.AppType.MODELER && CommonState.getApplicationType() != CommonState.AppType.MODELERCLOUD) {
            gridBagConstraints.weighty = 1.0;
            OptionsUtil.addUsingGBL(jPanel6, jPanel5, gridBagConstraints, 0, 1, 1, 2, n2, insets);
        }
        return jPanel6;
    }

    private JPanel createSciNotationPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        Insets insets = DialogUtil.getStandardControlInsets();
        int n = 23;
        gridBagConstraints.fill = 0;
        Insets insets2 = new Insets(DialogUtil.getGroupBoxInnerMargin(), insets.left, DialogUtil.getGroupBoxInnerMargin(), insets.right);
        OptionsUtil.addUsingGBL(jPanel, this.mSciNotation, gridBagConstraints, 0, 0, 1, 1, n, insets2);
        OptionsUtil.addUsingGBL(jPanel, this.mGrouping, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        gridBagConstraints.weighty = 1.0;
        insets2.bottom = DialogUtil.getGroupBoxInnerMargin() + 10;
        OptionsUtil.addUsingGBL(jPanel, this.mDisplayLeadZero, gridBagConstraints, 0, 2, 1, 1, n, insets2);
        return jPanel;
    }

    private JPanel createNotifyPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        DialogUtil.applyTopBorder(jPanel);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        Insets insets = new Insets(DialogUtil.getGroupBoxInnerMargin(), DialogUtil.getGroupBoxInnerMargin(), 0, DialogUtil.getGroupBoxInnerMargin());
        OptionsUtil.addUsingGBL(jPanel, this.mNotifiLbl, gridBagConstraints, 0, 0, 1, 1, 23, insets);
        OptionsUtil.addUsingGBL(jPanel, this.mRaiseCheck, gridBagConstraints, 0, 1, 1, 1, 23, insets);
        OptionsUtil.addUsingGBL(jPanel, this.mScrollCheck, gridBagConstraints, 0, 2, 1, 1, 23, insets);
        if (VersionInfo.IsApplicationOnCloud()) {
            OptionsUtil.addUsingGBL(jPanel, this.mAutoCheckUpdateCheckbox, gridBagConstraints, 0, 3, 1, 1, 23, insets);
        }
        return jPanel;
    }

    private JPanel createMeasurePanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        if (CommonState.getApplicationType() != CommonState.AppType.MODELER && CommonState.getApplicationType() != CommonState.AppType.MODELERCLOUD) {
            DialogUtil.applyTopBorder(jPanel);
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        Insets insets = new Insets(DialogUtil.getComponentGroupGap(), DialogUtil.getGroupBoxInnerMargin(), 0, 0);
        OptionsUtil.addUsingGBL(jPanel, this.mMeasureLbl, gridBagConstraints, 0, 0, 1, 1, 23, insets);
        gridBagConstraints.fill = 2;
        insets.set(DialogUtil.getComponentGroupGap(), 0, 0, 0);
        OptionsUtil.addUsingGBL(jPanel, this.mMeasureList, gridBagConstraints, 1, 0, 1, 1, 24, insets);
        JPanel jPanel2 = new JPanel();
        gridBagConstraints.weighty = 1.0;
        insets.set(0, 0, 0, 0);
        OptionsUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 1, 1, 1, 23, OptionsUtil.DROPDOWN_INSETS);
        return jPanel;
    }
}

