/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.edit;

import com.spss.java_client.core.common.SpssJournal;
import com.spss.java_client.core.common.VersionInfo;
import com.spss.java_client.core.common.fopen.RefFileFilter;
import com.spss.java_client.core.common.prefs.PrefDefaults;
import com.spss.java_client.core.comp_util.FileLocationsUtil;
import com.spss.java_client.core.script.engine.PythonUtil;
import com.spss.java_client.core.server.DataServerProxy;
import com.spss.java_client.ui.controls.FileTextField;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.base.edit.OptionPanel;
import com.spss.java_client.ui.dialogs.base.edit.OptionsDlg;
import com.spss.java_client.ui.dialogs.base.edit.OptionsUtil;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.java_client.ui.dialogs.common.SpssAlertOptionPane;
import com.spss.java_client.ui.dialogs.fopen.RefWindowsFileChooserUI;
import com.spss.java_client.ui.dialogs.fopen.RemoteFileChooser;
import com.spss.uitools.controls.ContextEnabledTextField;
import com.spss.uitools.util.IOptionConstants;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.basic.BasicFileChooserUI;

public class FileLocationsOptionPanel
extends OptionPanel {
    public static boolean sSpinnerChanged = true;
    private JRadioButton mSpecifiedButton;
    private JLabel mDataFilesLbl;
    private FileTextField mDataFileText;
    private JButton mBrowseData;
    private JLabel mOtherFilesLbl;
    private FileTextField mOtherFileText;
    private JButton mBrowseOther;
    private JRadioButton mLastButton;
    private JCheckBox mRecordCheck;
    private JRadioButton mAppendButton;
    private JRadioButton mOvwrtButton;
    private SpssButtonGroup mModeButtonGrp;
    private JLabel mJournalFileLbl;
    private FileTextField mJournalFileText;
    private JButton mBrowseJrnl;
    private JLabel mTempDirLbl;
    private FileTextField mTempDir;
    private JButton mBrowseTemp;
    private JLabel mRecentlyUsedLbl;
    private JLabel mPythonHomeWarningLbl;
    private JSpinner mSpinner;
    private String mTempDirPath;
    private String mPythonDirPath;
    private JLabel mPythonDirLbl;
    private FileTextField mPythonDir;
    private JButton mBrowsePython;
    private JRadioButton mInPythonButton;
    private JRadioButton mOutPythonButton;
    private String mPython3DirPath;
    private JLabel mPython3DirLbl;
    private FileTextField mPython3Dir;
    private JButton mBrowsePython3;
    private JRadioButton mInPython3Button;
    private JRadioButton mOutPython3Button;
    private static final int MINLIMIT = 0;
    private static final int MAXLIMIT = 10;
    private static final int STEPSIZE = 1;
    private ContextEnabledTextField mSpinnerText;

    public FileLocationsOptionPanel(OptionsDlg optionsDlg, Preferences preferences, String string) {
        super(optionsDlg, preferences, string);
        this.setOpaque(false);
        this.setOptionsChanged(false);
    }

    @Override
    public String getDialogHelpID() {
        return "idh_pref_file_locations";
    }

    @Override
    public void initVars() {
        this.mDataFileText = new FileTextField();
        this.mDataFileText.setColumns(45);
        this.mBrowseData = DialogUtil.createButton(this.mOptionDialog, "IDS_DATA_BROWSE", this);
        this.mDataFilesLbl = DialogUtil.createLabel(this.mOptionDialog, "IDS_DATA_FILES");
        this.mDataFilesLbl.setLabelFor((Component)((Object)this.mDataFileText));
        this.mDataFileText.setCaretPosition(0);
        this.mOtherFileText = new FileTextField();
        this.mOtherFileText.setColumns(45);
        this.mBrowseOther = DialogUtil.createButton(this.mOptionDialog, "IDS_OTHER_BROWSE", this);
        this.mOtherFilesLbl = DialogUtil.createLabel(this.mOptionDialog, "IDS_OTHER_FILES");
        this.mOtherFilesLbl.setLabelFor((Component)((Object)this.mOtherFileText));
        this.mSpecifiedButton = DialogUtil.createRadioButton(this.mOptionDialog, "IDS_SPECIFIED_FOLDER", (ActionListener)this);
        this.mLastButton = DialogUtil.createRadioButton(this.mOptionDialog, "IDS_LAST_FOLDER", (ActionListener)this);
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        spssButtonGroup.add(this.mSpecifiedButton);
        spssButtonGroup.add(this.mLastButton);
        if (VersionInfo.allowSyntax()) {
            this.mRecordCheck = DialogUtil.createCheckBox(this.mOptionDialog, "IDS_RECORD_SYNTAX", (ActionListener)this);
            this.mAppendButton = DialogUtil.createRadioButton(this.mOptionDialog, "IDS_APPEND", (ActionListener)this);
            this.mOvwrtButton = DialogUtil.createRadioButton(this.mOptionDialog, "IDS_OVERWRITE", (ActionListener)this);
            this.mRecordCheck.setSelected(true);
            this.mAppendButton.setSelected(true);
            this.mModeButtonGrp = new SpssButtonGroup();
            this.mModeButtonGrp.add(this.mAppendButton);
            this.mModeButtonGrp.add(this.mOvwrtButton);
            this.mJournalFileLbl = DialogUtil.createLabel(this.mOptionDialog, "IDS_JOURNAL_FILE");
            this.mJournalFileText = new FileTextField();
            this.mJournalFileText.setColumns(45);
            this.mJournalFileLbl.setLabelFor((Component)((Object)this.mJournalFileText));
            this.mBrowseJrnl = DialogUtil.createButton(this.mOptionDialog, "IDS_SESS_BROWSE", this);
        }
        this.mTempDirLbl = DialogUtil.createLabel(this.mOptionDialog, "IDS_TEMP_DIR");
        File file = new File(System.getProperty("java.io.tmpdir"));
        this.mTempDir = new FileTextField();
        this.mTempDir.setText(file.toString());
        this.mTempDir.setColumns(45);
        this.mTempDirLbl.setLabelFor((Component)((Object)this.mTempDir));
        this.mBrowseTemp = DialogUtil.createButton(this.mOptionDialog, "IDS_TEMP_BROWSE", this);
        this.mRecentlyUsedLbl = DialogUtil.createLabel(this.mOptionDialog, "IDS_FILE_LIST");
        this.mSpinner = new JSpinner();
        this.mSpinner.setPreferredSize(new Dimension(50, 22));
        this.mSpinner.setModel(new SpinnerNumberModel(PrefDefaults.DEF_RECENTLY_USED_FILE_LIST, 0, 10, 1));
        this.mSpinner.setFont(this.getFont());
        this.mSpinnerText = new ContextEnabledTextField();
        this.mSpinner.setEditor((JComponent)this.mSpinnerText);
        this.mSpinnerText.addFocusListener((FocusListener)this);
        this.mRecentlyUsedLbl.setLabelFor(this.mSpinner.getEditor());
        OptionsUtil.setSpinnerTextAlignment(this.mSpinner);
        this.mPythonDirLbl = DialogUtil.createLabel(this.mOptionDialog, "IDS_PYTHON_DIR");
        this.mPythonDir = new FileTextField();
        this.mPythonDir.setColumns(45);
        this.mPythonDirLbl.setLabelFor((Component)((Object)this.mPythonDir));
        this.mBrowsePython = DialogUtil.createButton(this.mOptionDialog, "IDS_PYTHON_BROWSE", this);
        this.mInPythonButton = DialogUtil.createRadioButton(this.mOptionDialog, "IDS_PYTHON_INSTALLED", (ActionListener)this);
        this.mOutPythonButton = DialogUtil.createRadioButton(this.mOptionDialog, "IDS_PYTHON_OTHER", (ActionListener)this);
        SpssButtonGroup spssButtonGroup2 = new SpssButtonGroup();
        spssButtonGroup2.add(this.mInPythonButton);
        spssButtonGroup2.add(this.mOutPythonButton);
        this.mPython3DirLbl = DialogUtil.createLabel(this.mOptionDialog, "IDS_PYTHON3_DIR");
        this.mPython3Dir = new FileTextField();
        this.mPython3Dir.setColumns(45);
        this.mPython3DirLbl.setLabelFor((Component)((Object)this.mPython3Dir));
        this.mBrowsePython3 = DialogUtil.createButton(this.mOptionDialog, "IDS_PYTHON3_BROWSE", this);
        this.mInPython3Button = DialogUtil.createRadioButton(this.mOptionDialog, "IDS_PYTHON_INSTALLED", (ActionListener)this);
        this.mOutPython3Button = DialogUtil.createRadioButton(this.mOptionDialog, "IDS_PYTHON3_OTHER", (ActionListener)this);
        SpssButtonGroup spssButtonGroup3 = new SpssButtonGroup();
        spssButtonGroup3.add(this.mInPython3Button);
        spssButtonGroup3.add(this.mOutPython3Button);
        this.mPythonHomeWarningLbl = DialogUtil.createLabel(this.mOptionDialog, "IDS_PYTHON_HOME_WARNING");
        this.mPythonHomeWarningLbl.setVisible(false);
        this.mComponentOrder.add(spssButtonGroup);
        this.mComponentOrder.add(this.mDataFileText);
        this.mComponentOrder.add(this.mBrowseData);
        this.mComponentOrder.add(this.mOtherFileText);
        this.mComponentOrder.add(this.mBrowseOther);
        if (this.mRecordCheck != null) {
            this.mComponentOrder.add(this.mRecordCheck);
        }
        if (this.mModeButtonGrp != null) {
            this.mComponentOrder.add(this.mModeButtonGrp);
        }
        if (this.mJournalFileText != null) {
            this.mComponentOrder.add(this.mJournalFileText);
        }
        if (this.mBrowseJrnl != null) {
            this.mComponentOrder.add(this.mBrowseJrnl);
        }
        this.mComponentOrder.add(this.mTempDir);
        this.mComponentOrder.add(this.mBrowseTemp);
        this.mComponentOrder.add(this.mSpinner.getEditor());
        this.mComponentOrder.add(spssButtonGroup2);
        this.mComponentOrder.add(this.mPythonDir);
        this.mComponentOrder.add(this.mBrowsePython);
        this.mComponentOrder.add(spssButtonGroup3);
        this.mComponentOrder.add(this.mPython3Dir);
        this.mComponentOrder.add(this.mBrowsePython3);
        this.mComponentOrder.addAll(Arrays.asList(this.mOptionDialog.getCmdButtonPanel().getComponents()));
        if (DataServerProxy.getDataProxy().isRemoteConnection()) {
            this.mSpecifiedButton.setEnabled(false);
            this.mLastButton.setEnabled(false);
            this.mLastButton.setSelected(true);
            this.mDataFileText.setEnabled(false);
            this.mDataFilesLbl.setEnabled(false);
            this.mBrowseData.setEnabled(false);
            this.mOtherFileText.setEnabled(false);
            this.mOtherFilesLbl.setEnabled(false);
            this.mBrowseOther.setEnabled(false);
            this.mDataFilesLbl.setEnabled(false);
            this.mOtherFilesLbl.setEnabled(false);
            this.mPythonDir.setEnabled(false);
            this.mPythonDirLbl.setEnabled(false);
            this.mBrowsePython.setEnabled(false);
            this.mInPythonButton.setEnabled(false);
            this.mOutPythonButton.setEnabled(false);
            this.mPythonHomeWarningLbl.setVisible(true);
            this.mPythonHomeWarningLbl.setEnabled(false);
            this.mPython3Dir.setEnabled(false);
            this.mPython3DirLbl.setEnabled(false);
            this.mBrowsePython3.setEnabled(false);
            this.mInPython3Button.setEnabled(false);
            this.mOutPython3Button.setEnabled(false);
        }
        if (!PythonUtil.hasPythonPlugin()) {
            this.mPythonDir.setEnabled(false);
            this.mPythonDirLbl.setEnabled(false);
            this.mBrowsePython.setEnabled(false);
            this.mInPythonButton.setEnabled(false);
            this.mOutPythonButton.setEnabled(false);
            this.mPython3Dir.setEnabled(false);
            this.mPython3DirLbl.setEnabled(false);
            this.mBrowsePython3.setEnabled(false);
            this.mInPython3Button.setEnabled(false);
            this.mOutPython3Button.setEnabled(false);
        }
    }

    @Override
    public void initPanel() {
        super.initPanel();
        JPanel jPanel = this.createFileLocationsPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        OptionsUtil.addUsingGBL(this, jPanel, gridBagConstraints, 0, 0, 1, 1, 23, null);
    }

    @Override
    public void readPrefs() {
        Object object;
        Object object2;
        Preferences preferences = this.mOptionsPrefs;
        if (!preferences.getBoolean("sess_record_syntax", true)) {
            if (this.mRecordCheck != null) {
                this.mRecordCheck.setSelected(false);
            }
            if (this.mAppendButton != null) {
                this.mAppendButton.setEnabled(false);
            }
            if (this.mOvwrtButton != null) {
                this.mOvwrtButton.setEnabled(false);
            }
            if (this.mJournalFileText != null) {
                this.mJournalFileText.setEnabled(false);
            }
            if (this.mJournalFileText != null) {
                this.mJournalFileText.setOpaque(false);
            }
            if (this.mBrowseJrnl != null) {
                this.mBrowseJrnl.setEnabled(false);
            }
        }
        String string = preferences.get("sess_record_mode", PrefDefaults.DEF_SESS_JOURNAL_RECORD_MODE);
        int n = DialogUtil.getIndexOfItem(IOptionConstants.SESS_JOURNAL_RECORD_MODE_VALUES, string);
        if (this.mModeButtonGrp != null) {
            DialogUtil.setSelectedButton(this.mModeButtonGrp, n);
        }
        if (this.mJournalFileText != null) {
            object2 = FileLocationsUtil.getJournalFilePathFromPreferences();
            object = new File((String)object2);
            try {
                this.mJournalFileText.setText(((File)object).getCanonicalPath());
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        this.mTempDirPath = preferences.get("temp_dir", PrefDefaults.DEF_GENERAL_TEMP_DIR);
        object2 = new File(this.mTempDirPath);
        try {
            this.mTempDirPath = ((File)object2).getCanonicalPath();
            if (!this.mTempDirPath.endsWith(File.separator)) {
                this.mTempDir.setText(this.mTempDirPath + File.separator);
            } else {
                this.mTempDir.setText(this.mTempDirPath);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.mTempDir.setCaretPosition(0);
        object = preferences.getInt("recently_used_files", PrefDefaults.DEF_RECENTLY_USED_FILE_LIST) + "";
        ((JTextField)this.mSpinner.getEditor()).setText((String)object);
        this.mSpinner.getModel().setValue(Integer.parseInt((String)object));
        if (!DataServerProxy.getDataProxy().isRemoteConnection()) {
            if (FileLocationsUtil.isLastUsed()) {
                this.mLastButton.setEnabled(true);
                this.mLastButton.setSelected(true);
                this.mDataFileText.setEnabled(false);
                this.mDataFileText.setOpaque(false);
                this.mBrowseData.setEnabled(false);
                this.mOtherFileText.setEnabled(false);
                this.mOtherFileText.setOpaque(false);
                this.mBrowseOther.setEnabled(false);
            } else {
                this.mSpecifiedButton.setEnabled(true);
                this.mSpecifiedButton.setSelected(true);
                this.mDataFileText.setEnabled(true);
                this.mDataFileText.setOpaque(true);
                this.mBrowseData.setEnabled(true);
                this.mOtherFileText.setEnabled(true);
                this.mOtherFileText.setOpaque(true);
                this.mBrowseOther.setEnabled(true);
            }
            this.mDataFileText.setText(FileLocationsUtil.readDataFilesDirectoryPathFromPreferences());
            this.mOtherFileText.setText(FileLocationsUtil.readOtherFilesDirectoryPathFromPreferences());
            this.mPythonDirPath = PythonUtil.getPythonPath((PythonUtil.PythonVersionEnum)PythonUtil.PythonVersionEnum.Python2);
            this.mPythonDir.setText(this.mPythonDirPath);
            this.mPython3DirPath = PythonUtil.getPythonPath((PythonUtil.PythonVersionEnum)PythonUtil.PythonVersionEnum.Python3);
            this.mPython3Dir.setText(this.mPython3DirPath);
            if (PythonUtil.hasPythonPlugin()) {
                boolean bl = PythonUtil.isExternalPython((PythonUtil.PythonVersionEnum)PythonUtil.PythonVersionEnum.Python2);
                boolean bl2 = PythonUtil.isExternalPython((PythonUtil.PythonVersionEnum)PythonUtil.PythonVersionEnum.Python3);
                if (bl) {
                    this.mOutPythonButton.setSelected(true);
                } else {
                    this.mInPythonButton.setSelected(true);
                }
                this.mPythonDir.setEnabled(bl);
                this.mPythonDir.setOpaque(bl);
                this.mBrowsePython.setEnabled(bl);
                if (bl2) {
                    this.mOutPython3Button.setSelected(true);
                } else {
                    this.mInPython3Button.setSelected(true);
                }
                this.mPython3Dir.setEnabled(bl2);
                this.mPython3Dir.setOpaque(bl2);
                this.mBrowsePython3.setEnabled(bl2);
            }
        }
        this.addListeners();
    }

    @Override
    public void savePrefs() {
        if (!this.isDirectoriesOK()) {
            return;
        }
        if (!DataServerProxy.getDataProxy().isRemoteConnection() && PythonUtil.hasPythonPlugin()) {
            for (PythonUtil.PythonVersionEnum object2 : PythonUtil.PythonVersionEnum.values()) {
                FileTextField bl;
                FileTextField fileTextField = bl = object2.equals((Object)PythonUtil.PythonVersionEnum.Python2) ? this.mPythonDir : this.mPython3Dir;
                if (this.isPythonOK(bl.getText(), object2).booleanValue()) continue;
                bl.setText(PythonUtil.getPythonPath((PythonUtil.PythonVersionEnum)object2));
            }
        }
        PythonUtil.PythonVersionEnum[] pythonVersionEnumArray = this.mOptionsPrefs;
        if (!DataServerProxy.getDataProxy().isRemoteConnection()) {
            if (this.mSpecifiedButton.isSelected()) {
                FileLocationsUtil.setLastUsed((boolean)false);
                FileLocationsUtil.writeDataFilesDirectoryPathToPreferences((String)this.mDataFileText.getText());
                FileLocationsUtil.writeOtherFilesDirectoryPathToPreferences((String)this.mOtherFileText.getText());
            } else {
                FileLocationsUtil.setLastUsed((boolean)true);
            }
            if (this.mOutPythonButton.isSelected()) {
                PythonUtil.updatePythonPath((String)this.mPythonDir.getText(), (PythonUtil.PythonVersionEnum)PythonUtil.PythonVersionEnum.Python2);
            }
            PythonUtil.setExternalPython((boolean)this.mOutPythonButton.isSelected(), (PythonUtil.PythonVersionEnum)PythonUtil.PythonVersionEnum.Python2);
            if (this.mOutPython3Button.isSelected()) {
                PythonUtil.updatePythonPath((String)this.mPython3Dir.getText(), (PythonUtil.PythonVersionEnum)PythonUtil.PythonVersionEnum.Python3);
            }
            PythonUtil.setExternalPython((boolean)this.mOutPython3Button.isSelected(), (PythonUtil.PythonVersionEnum)PythonUtil.PythonVersionEnum.Python3);
        }
        if (this.mRecordCheck != null && this.mRecordCheck.isSelected()) {
            pythonVersionEnumArray.putBoolean("sess_record_syntax", true);
        } else {
            pythonVersionEnumArray.putBoolean("sess_record_syntax", false);
        }
        if (this.mAppendButton != null && this.mAppendButton.isSelected()) {
            pythonVersionEnumArray.put("sess_record_mode", IOptionConstants.SESS_JOURNAL_RECORD_MODE_VALUES[0]);
        } else {
            pythonVersionEnumArray.put("sess_record_mode", IOptionConstants.SESS_JOURNAL_RECORD_MODE_VALUES[1]);
        }
        if (this.mJournalFileText != null) {
            pythonVersionEnumArray.put("sess_journal_file", this.mJournalFileText.getText());
            try {
                pythonVersionEnumArray.flush();
            }
            catch (BackingStoreException backingStoreException) {
                // empty catch block
            }
        }
        pythonVersionEnumArray.put("temp_dir", this.mTempDir.getText());
        pythonVersionEnumArray.putInt("recently_used_files", Integer.parseInt(this.mSpinner.getValue().toString()));
        SpssJournal spssJournal = SpssJournal.getInstance();
        int n = pythonVersionEnumArray.getBoolean("sess_record_syntax", true) ? 1 : 0;
        spssJournal.record(n != 0);
        String string = pythonVersionEnumArray.get("sess_record_mode", PrefDefaults.DEF_SESS_JOURNAL_RECORD_MODE);
        boolean bl = string.equals(IOptionConstants.SESS_JOURNAL_RECORD_MODE_VALUES[0]);
        spssJournal.append(bl);
        String string2 = this.mJournalFileText.getText();
        spssJournal.filePath(string2);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (this.mBrowseJrnl != null && object == this.mBrowseJrnl) {
            String string;
            RemoteFileChooser remoteFileChooser = new RemoteFileChooser(RemoteFileChooser.ChooserType.SaveFile, RemoteFileChooser.ChooserOption.GenericWithoutPES, null, DataServerProxy.getDataProxy().isRemoteConnection(), false, true);
            remoteFileChooser.setDialogTitle(this.getResString("IDS_SAVE_AS"));
            RefFileFilter refFileFilter = new RefFileFilter(this.getResString("IDS_JRNL_FILE_FILTER"), this.getResString("IDS_JNL"));
            remoteFileChooser.setFileFilter((FileFilter)refFileFilter);
            remoteFileChooser.setAcceptAllFileFilterUsed(false);
            if (this.mJournalFileText.getText().trim().length() != 0) {
                remoteFileChooser.setCurrentDirectory(new File(this.mJournalFileText.getText()));
            }
            try {
                File file = new File(new File(this.mJournalFileText.getText()).getCanonicalPath());
                int n = file.getName().lastIndexOf(".");
                if (n != -1) {
                    string = file.getName();
                    if (remoteFileChooser.getUI() instanceof RefWindowsFileChooserUI) {
                        ((BasicFileChooserUI)remoteFileChooser.getUI()).setFileName(string);
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            int n = remoteFileChooser.showSaveDialog((Component)((Object)this.mOptionDialog));
            if (n == 0) {
                String string2 = remoteFileChooser.getSelectedFilePath();
                string = string2.toLowerCase();
                int n2 = string.indexOf(this.getResString("IDS_JNL"));
                if (n2 == -1) {
                    string2 = string2.concat(this.getResString("IDS_JNL"));
                } else if (string.substring(n2).compareToIgnoreCase(this.getResString("IDS_JNL")) != 0) {
                    string2 = string2.concat(this.getResString("IDS_JNL"));
                }
                this.mJournalFileText.setText(string2);
            }
        } else if (object == this.mRecordCheck) {
            boolean bl;
            boolean bl2 = bl = this.mRecordCheck != null && this.mRecordCheck.isSelected();
            if (this.mAppendButton != null) {
                this.mAppendButton.setEnabled(bl);
            }
            if (this.mOvwrtButton != null) {
                this.mOvwrtButton.setEnabled(bl);
            }
            if (this.mJournalFileText != null) {
                this.mJournalFileText.setEnabled(bl);
                this.mJournalFileText.setOpaque(bl);
            }
            if (this.mBrowseJrnl != null) {
                this.mBrowseJrnl.setEnabled(bl);
            }
        } else if (object == this.mSpecifiedButton || object == this.mLastButton) {
            if (this.mSpecifiedButton.isSelected()) {
                this.mDataFileText.setEnabled(true);
                this.mDataFileText.setOpaque(true);
                this.mBrowseData.setEnabled(true);
                this.mOtherFileText.setEnabled(true);
                this.mOtherFileText.setOpaque(true);
                this.mBrowseOther.setEnabled(true);
            } else {
                this.mDataFileText.setEnabled(false);
                this.mDataFileText.setOpaque(false);
                this.mBrowseData.setEnabled(false);
                this.mOtherFileText.setEnabled(false);
                this.mOtherFileText.setOpaque(false);
                this.mBrowseOther.setEnabled(false);
            }
        } else if (object == this.mBrowseData) {
            RemoteFileChooser remoteFileChooser = new RemoteFileChooser(RemoteFileChooser.ChooserType.OpenFolder, RemoteFileChooser.ChooserOption.GenericWithoutPES, this.mDataFileText.getText(), DataServerProxy.getDataProxy().isRemoteConnection(), false, true);
            remoteFileChooser.setDialogTitle(this.getResString("IDS_DEFAULT_DATA_FOLDER_TITLE"));
            remoteFileChooser.setApproveButtonText(this.getResString("IDS_DIR_CHOOSER_APPROVE_BUTTON_TEXT"));
            remoteFileChooser.setSelectedFile(remoteFileChooser.getCurrentDirectory());
            int n = remoteFileChooser.showOpenDialog((Component)((Object)this.mOptionDialog));
            if (n == 0) {
                String string = remoteFileChooser.getSelectedFilePath();
                this.mDataFileText.setText(string);
            }
        } else if (object == this.mBrowseOther) {
            RemoteFileChooser remoteFileChooser = new RemoteFileChooser(RemoteFileChooser.ChooserType.OpenFolder, RemoteFileChooser.ChooserOption.GenericWithoutPES, this.mOtherFileText.getText(), DataServerProxy.getDataProxy().isRemoteConnection(), false, true);
            remoteFileChooser.setDialogTitle(this.getResString("IDS_DEFAULT_FOLDER_TITLE"));
            remoteFileChooser.setApproveButtonText(this.getResString("IDS_DIR_CHOOSER_APPROVE_BUTTON_TEXT"));
            remoteFileChooser.setSelectedFile(remoteFileChooser.getCurrentDirectory());
            int n = remoteFileChooser.showOpenDialog((Component)((Object)this.mOptionDialog));
            if (n == 0) {
                String string = remoteFileChooser.getSelectedFilePath();
                this.mOtherFileText.setText(string);
            }
        } else if (object == this.mBrowseTemp) {
            RemoteFileChooser remoteFileChooser = new RemoteFileChooser(RemoteFileChooser.ChooserType.OpenFolder, RemoteFileChooser.ChooserOption.GenericWithoutPES, this.mTempDir.getText(), DataServerProxy.getDataProxy().isRemoteConnection(), false, true);
            remoteFileChooser.setDialogTitle(this.getResString("IDS_TEMPORARY_FOLDER_TITLE"));
            remoteFileChooser.setApproveButtonText(this.getResString("IDS_DIR_CHOOSER_APPROVE_BUTTON_TEXT"));
            remoteFileChooser.setSelectedFile(remoteFileChooser.getCurrentDirectory());
            int n = remoteFileChooser.showOpenDialog((Component)((Object)this.mOptionDialog));
            if (n == 0) {
                String string = remoteFileChooser.getSelectedFilePath();
                this.mTempDir.setText(string);
            }
        } else if (object == this.mInPythonButton || object == this.mOutPythonButton) {
            if (this.mInPythonButton.isSelected()) {
                this.mPythonDir.setEnabled(false);
                this.mPythonDir.setOpaque(false);
                this.mBrowsePython.setEnabled(false);
            } else {
                this.mPythonDir.setEnabled(true);
                this.mPythonDir.setOpaque(true);
                this.mBrowsePython.setEnabled(true);
            }
        } else if (object == this.mBrowsePython) {
            RemoteFileChooser remoteFileChooser = new RemoteFileChooser(RemoteFileChooser.ChooserType.OpenFolder, RemoteFileChooser.ChooserOption.GenericWithoutPES, this.mPythonDir.getText(), DataServerProxy.getDataProxy().isRemoteConnection(), false, true);
            remoteFileChooser.setDialogTitle(this.getResString("IDS_PYTHON_FOLDER_TITLE"));
            remoteFileChooser.setApproveButtonText(this.getResString("IDS_DIR_CHOOSER_APPROVE_BUTTON_TEXT"));
            remoteFileChooser.setSelectedFile(remoteFileChooser.getCurrentDirectory());
            int n = remoteFileChooser.showOpenDialog((Component)((Object)this.mOptionDialog));
            if (n == 0) {
                String string = remoteFileChooser.getSelectedFilePath();
                if (this.isPythonOK(string, PythonUtil.PythonVersionEnum.Python2).booleanValue()) {
                    this.mPythonDir.setText(string);
                } else {
                    this.mPythonDir.requestFocus();
                }
            }
        } else if (object == this.mInPython3Button || object == this.mOutPython3Button) {
            if (this.mInPython3Button.isSelected()) {
                this.mPython3Dir.setEnabled(false);
                this.mPython3Dir.setOpaque(false);
                this.mBrowsePython3.setEnabled(false);
            } else {
                this.mPython3Dir.setEnabled(true);
                this.mPython3Dir.setOpaque(true);
                this.mBrowsePython3.setEnabled(true);
            }
        } else if (object == this.mBrowsePython3) {
            RemoteFileChooser remoteFileChooser = new RemoteFileChooser(RemoteFileChooser.ChooserType.OpenFolder, RemoteFileChooser.ChooserOption.GenericWithoutPES, this.mPython3Dir.getText(), DataServerProxy.getDataProxy().isRemoteConnection(), false, true);
            remoteFileChooser.setDialogTitle(this.getResString("IDS_PYTHON3_FOLDER_TITLE"));
            remoteFileChooser.setApproveButtonText(this.getResString("IDS_DIR_CHOOSER_APPROVE_BUTTON_TEXT"));
            remoteFileChooser.setSelectedFile(remoteFileChooser.getCurrentDirectory());
            int n = remoteFileChooser.showOpenDialog((Component)((Object)this.mOptionDialog));
            if (n == 0) {
                String string = remoteFileChooser.getSelectedFilePath();
                if (this.isPythonOK(string, PythonUtil.PythonVersionEnum.Python3).booleanValue()) {
                    this.mPython3Dir.setText(string);
                } else {
                    this.mPython3Dir.requestFocus();
                }
            }
        }
        super.actionPerformed(actionEvent);
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        Object object = changeEvent.getSource();
        if (object == this.mSpinner && sEnableApplyButton) {
            OptionsDlg.sMessagesDialogs.put(this.mSpinner, this.getResString("ERR_COUNTER_CHANGED"));
            JTextField jTextField = (JTextField)this.mSpinner.getEditor();
            if (sSpinnerChanged) {
                jTextField.setText(this.mSpinner.getValue() + "");
            }
            sSpinnerChanged = true;
        }
        super.stateChanged(changeEvent);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        super.itemStateChanged(itemEvent);
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        super.focusLost(focusEvent);
        if (focusEvent.isTemporary() || focusEvent.getID() != 1005) {
            return;
        }
    }

    private boolean isDirectoriesOK() {
        boolean bl = false;
        if (this.isDirectoryOK(this.mDataFileText, this.mDataFilesLbl.getText())) {
            if (this.isDirectoryOK(this.mOtherFileText, this.mOtherFilesLbl.getText())) {
                if (this.isDirectoryOK(this.mTempDir, this.mTempDirLbl.getText())) {
                    if (this.isJournalFileOK()) {
                        bl = true;
                    }
                } else {
                    this.mTempDir.requestFocus();
                }
            } else {
                this.mOtherFileText.requestFocus();
            }
        } else {
            this.mDataFileText.requestFocus();
        }
        return bl;
    }

    private boolean isJournalFileOK() {
        boolean bl = true;
        if (this.mJournalFileText != null && this.mJournalFileText.isEnabled()) {
            if (this.mJournalFileText.getText().trim().length() > 0) {
                File file = new File(this.mJournalFileText.getText().trim());
                if (!file.exists()) {
                    try {
                        if (file.createNewFile()) {
                            file.delete();
                            bl = true;
                        }
                    }
                    catch (IOException iOException) {
                        bl = false;
                    }
                } else if (file.isFile()) {
                    bl = true;
                }
                if (!bl) {
                    SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this.mOptionDialog), this.getResString("ERR_ACCESS_DENIED"), VersionInfo.getAppVersionString());
                    this.mJournalFileText.setText(FileLocationsUtil.getJournalFilePathFromPreferences());
                }
            } else {
                bl = false;
                SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this.mOptionDialog), this.getResString("ERR_ENTER_DIRECTORY"), VersionInfo.getAppVersionString());
                this.mJournalFileText.setText(FileLocationsUtil.getJournalFilePathFromPreferences());
            }
        }
        return bl;
    }

    private boolean isDirectoryOK(FileTextField fileTextField, String string) {
        boolean bl = false;
        if (fileTextField.isEnabled()) {
            if (fileTextField.getText().trim().length() > 0) {
                File file = new File(fileTextField.getText());
                if (!file.isDirectory()) {
                    String string2 = MessageFormat.format(this.getResString("ERR_DIR_INVALID_FOLDER"), string);
                    SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this.mOptionDialog), string2, VersionInfo.getAppVersionString());
                } else if (!file.exists()) {
                    if (!file.mkdir()) {
                        SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this.mOptionDialog), this.getResString("ERR_ACCESS_DENIED"), VersionInfo.getAppVersionString());
                    } else {
                        bl = true;
                    }
                } else {
                    bl = true;
                }
            } else {
                SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this.mOptionDialog), this.getResString("ERR_ENTER_DIRECTORY"), VersionInfo.getAppVersionString());
                bl = false;
            }
            if (!bl) {
                if (this.mDataFileText.equals(fileTextField)) {
                    fileTextField.setText(FileLocationsUtil.readDataFilesDirectoryPathFromPreferences());
                } else if (this.mOtherFileText.equals(fileTextField)) {
                    fileTextField.setText(FileLocationsUtil.readOtherFilesDirectoryPathFromPreferences());
                } else if (this.mPythonDir.equals(fileTextField)) {
                    fileTextField.setText(this.mPythonDirPath);
                } else if (this.mPython3Dir.equals(fileTextField)) {
                    fileTextField.setText(this.mPython3DirPath);
                } else {
                    fileTextField.setText(this.mTempDirPath);
                }
                fileTextField.setCaretPosition(0);
            }
        } else {
            bl = true;
        }
        return bl;
    }

    private Boolean isPythonOK(String string, PythonUtil.PythonVersionEnum pythonVersionEnum) {
        Boolean bl = false;
        String string2 = PythonUtil.getSupportPythonString((PythonUtil.PythonVersionEnum)pythonVersionEnum);
        Object[] objectArray = new Object[]{string2, string};
        if (string.length() == 0 || !PythonUtil.CheckPythonVersion((String)string, (PythonUtil.PythonVersionEnum)pythonVersionEnum)) {
            String string3 = MessageFormat.format(this.getResString("ERR_PYTHON_VERSION_NOT_MATCH"), objectArray);
            SpssAlertOptionPane.showInformationMessageDialog((Window)((Object)this.mOptionDialog), string3, VersionInfo.getAppVersionString());
        } else {
            bl = true;
        }
        return bl;
    }

    @Override
    protected int getId() {
        return 0;
    }

    private void addListeners() {
        this.mSpecifiedButton.addItemListener(this);
        this.mLastButton.addItemListener(this);
        this.mDataFileText.addKeyListener(this);
        this.mDataFileText.addFocusListener(this);
        this.mOtherFileText.addKeyListener(this);
        this.mOtherFileText.addFocusListener(this);
        if (this.mJournalFileText != null) {
            this.mJournalFileText.addKeyListener(this);
            this.mJournalFileText.addFocusListener(this);
        }
        if (this.mAppendButton != null) {
            this.mAppendButton.addItemListener(this);
        }
        if (this.mOvwrtButton != null) {
            this.mOvwrtButton.addItemListener(this);
        }
        this.mTempDir.addKeyListener(this);
        this.mTempDir.addFocusListener(this);
        this.mSpinner.addChangeListener(this);
        this.mSpinnerText.getDocument().addDocumentListener(this.getDocumentListener(0, 10, this.mSpinner));
        this.mSpinner.getEditor().addFocusListener(this);
        if (this.mInPythonButton != null) {
            this.mInPythonButton.addItemListener(this);
        }
        if (this.mOutPythonButton != null) {
            this.mOutPythonButton.addItemListener(this);
        }
        this.mPythonDir.addKeyListener(this);
        this.mPythonDir.addFocusListener(this);
        if (this.mInPython3Button != null) {
            this.mInPython3Button.addItemListener(this);
        }
        if (this.mOutPython3Button != null) {
            this.mOutPython3Button.addItemListener(this);
        }
        this.mPython3Dir.addKeyListener(this);
        this.mPython3Dir.addFocusListener(this);
    }

    private JPanel createFileLocationsPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        JPanel jPanel2 = this.createOpenSavePanel();
        JPanel jPanel3 = !VersionInfo.isStudentVersion() ? this.createSessJrnlPanel() : null;
        JPanel jPanel4 = this.createTempDirPanel();
        JPanel jPanel5 = this.createPythonDirPanel(PythonUtil.PythonVersionEnum.Python2);
        JPanel jPanel6 = this.createPythonDirPanel(PythonUtil.PythonVersionEnum.Python3);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        Insets insets = new Insets(DialogUtil.getComponentGroupGap(), 0, 0, 0);
        int n = 23;
        OptionsUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n, insets);
        int n2 = 1;
        if (jPanel3 != null) {
            OptionsUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, n2, 2, 1, n, insets);
            ++n2;
        }
        insets.set(DialogUtil.getComponentGroupGap(), 0, 0, 0);
        OptionsUtil.addUsingGBL(jPanel, jPanel4, gridBagConstraints, 0, n2, 2, 1, n, insets);
        OptionsUtil.addUsingGBL(jPanel, jPanel5, gridBagConstraints, 0, ++n2, 2, 1, n, insets);
        OptionsUtil.addUsingGBL(jPanel, jPanel6, gridBagConstraints, 0, ++n2, 2, 1, n, insets);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        OptionsUtil.addUsingGBL(jPanel, new JPanel(), gridBagConstraints, 0, ++n2, 2, 1, n, insets);
        return jPanel;
    }

    private JPanel createTempDirPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        int n = DialogUtil.getGroupBoxInnerMargin();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        Insets insets = DialogUtil.getStandardControlInsets();
        gridBagConstraints.fill = 0;
        int n2 = 23;
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        OptionsUtil.addUsingGBL(jPanel2, this.mTempDirLbl, gridBagConstraints, 0, 0, 1, 1, n2, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        OptionsUtil.addUsingGBL(jPanel2, (JComponent)((Object)this.mTempDir), gridBagConstraints, 1, 0, 1, 1, n2, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        OptionsUtil.addUsingGBL(jPanel2, this.mBrowseTemp, gridBagConstraints, 2, 0, 1, 1, n2, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        OptionsUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 0, 1, 1, n2, insets);
        this.mTempDir.setOpaque(true);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridBagLayout());
        gridBagConstraints.weightx = 0.0;
        n2 = 22;
        OptionsUtil.addUsingGBL(jPanel3, this.mRecentlyUsedLbl, gridBagConstraints, 0, 0, 1, 1, n2, insets);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        n2 = 21;
        Insets insets2 = new Insets(0, 4, 0, 0);
        OptionsUtil.addUsingGBL(jPanel3, this.mSpinner, gridBagConstraints, 1, 0, 1, 1, n2, insets2);
        insets2.set(DialogUtil.getComponentGroupGap(), n, 0, n);
        n2 = 23;
        OptionsUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 1, 1, 1, n2, insets);
        return jPanel;
    }

    private JPanel createPythonDirPanel(PythonUtil.PythonVersionEnum pythonVersionEnum) {
        JButton jButton;
        FileTextField fileTextField;
        JLabel jLabel;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        String string;
        switch (pythonVersionEnum) {
            case Python3: {
                string = "IDS_PYTHON3_FOLDER";
                jRadioButton2 = this.mInPython3Button;
                jRadioButton = this.mOutPython3Button;
                jLabel = this.mPython3DirLbl;
                fileTextField = this.mPython3Dir;
                jButton = this.mBrowsePython3;
                break;
            }
            default: {
                string = "IDS_PYTHON_FOLDER";
                jRadioButton2 = this.mInPythonButton;
                jRadioButton = this.mOutPythonButton;
                jLabel = this.mPythonDirLbl;
                fileTextField = this.mPythonDir;
                jButton = this.mBrowsePython;
            }
        }
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString(string)));
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        Insets insets2 = new Insets(insets.top, insets.left + 20, 0, 0);
        OptionsUtil.addUsingGBL(jPanel, jRadioButton2, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        OptionsUtil.addUsingGBL(jPanel, jRadioButton, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        OptionsUtil.addUsingGBL(jPanel2, jLabel, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        OptionsUtil.addUsingGBL(jPanel2, (JComponent)((Object)fileTextField), gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        OptionsUtil.addUsingGBL(jPanel2, jButton, gridBagConstraints, 2, 0, 1, 1, n, insets);
        OptionsUtil.addUsingGBL(jPanel2, this.mPythonHomeWarningLbl, gridBagConstraints, 0, 1, 3, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        OptionsUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 2, 1, 1, n, insets2);
        return jPanel;
    }

    private JPanel createOpenSavePanel() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_STARTUP_FOLDERS")));
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        int n2 = DialogUtil.getComponentGroupGap();
        OptionsUtil.addUsingGBL(jPanel, this.mSpecifiedButton, gridBagConstraints, 0, 0, 1, 1, n, insets);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        Insets insets2 = new Insets(insets.top, insets.left * 3 + insets.bottom, insets.bottom, insets.right);
        OptionsUtil.addUsingGBL(jPanel2, this.mDataFilesLbl, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        OptionsUtil.addUsingGBL(jPanel2, (JComponent)((Object)this.mDataFileText), gridBagConstraints, 1, 0, 1, 1, n, insets2);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        OptionsUtil.addUsingGBL(jPanel2, this.mBrowseData, gridBagConstraints, 2, 0, 1, 1, n, insets);
        this.mDataFileText.setOpaque(true);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        insets2.set(insets.top, n2 * 4, 0, 0);
        OptionsUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 1, 1, 1, n, insets2);
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        OptionsUtil.addUsingGBL(jPanel3, this.mOtherFilesLbl, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        OptionsUtil.addUsingGBL(jPanel3, (JComponent)((Object)this.mOtherFileText), gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        OptionsUtil.addUsingGBL(jPanel3, this.mBrowseOther, gridBagConstraints, 2, 0, 1, 1, n, insets);
        this.mOtherFileText.setOpaque(true);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        insets2.set(insets.top, n2 * 4, 0, 0);
        OptionsUtil.addUsingGBL(jPanel, jPanel3, gridBagConstraints, 0, 2, 1, 1, n, insets2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        OptionsUtil.addUsingGBL(jPanel, this.mLastButton, gridBagConstraints, 0, 3, 1, 1, n, insets);
        return jPanel;
    }

    private JPanel createSessJrnlPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_SESS_JRNL")));
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        OptionsUtil.addUsingGBL(jPanel, this.mRecordCheck, gridBagConstraints, 0, 0, 2, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        OptionsUtil.addUsingGBL(jPanel, this.mAppendButton, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        OptionsUtil.addUsingGBL(jPanel, this.mOvwrtButton, gridBagConstraints, 1, 1, 1, 1, n, insets);
        gridBagConstraints.fill = 0;
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        gridBagConstraints.weightx = 0.0;
        OptionsUtil.addUsingGBL(jPanel2, this.mJournalFileLbl, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        OptionsUtil.addUsingGBL(jPanel2, (JComponent)((Object)this.mJournalFileText), gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        OptionsUtil.addUsingGBL(jPanel2, this.mBrowseJrnl, gridBagConstraints, 2, 0, 1, 1, n, insets);
        this.mJournalFileText.setOpaque(true);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        OptionsUtil.addUsingGBL(jPanel, jPanel2, gridBagConstraints, 0, 2, 2, 1, n, insets);
        String string = FileLocationsUtil.getJournalFilePathFromPreferences();
        File file = new File(string);
        try {
            final String string2 = file.getCanonicalPath();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    FileLocationsOptionPanel.this.mJournalFileText.setText(string2);
                }
            });
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return jPanel;
    }

    private void fireStateChanged() {
        ChangeListener[] changeListenerArray;
        for (ChangeListener changeListener : changeListenerArray = this.mSpinner.getChangeListeners()) {
            ChangeEvent changeEvent = new ChangeEvent(this.mSpinner);
            changeListener.stateChanged(changeEvent);
        }
    }

    private DocumentListener getDocumentListener(final int n, final int n2, final JSpinner jSpinner) {
        return new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                sSpinnerChanged = false;
                JTextField jTextField = (JTextField)jSpinner.getEditor();
                int n3 = 10;
                int n22 = Integer.parseInt(FileLocationsOptionPanel.this.mSpinner.getModel().getValue().toString());
                if (OptionsDlg.sErrorMessagesDialogs.containsKey(jSpinner)) {
                    OptionsDlg.sErrorMessagesDialogs.remove(jSpinner);
                }
                try {
                    n3 = Integer.parseInt(jTextField.getText());
                    if (n3 < n || n3 > n2) {
                        OptionsDlg.sErrorMessagesDialogs.put(jSpinner, FileLocationsOptionPanel.this.getResString("ERR_FILE_LIST"));
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    OptionsDlg.sErrorMessagesDialogs.put(jSpinner, FileLocationsOptionPanel.this.getResString("ERR_NUMBERFORMAT"));
                }
                jSpinner.getModel().setValue(n3);
                if (n3 == n22) {
                    FileLocationsOptionPanel.this.fireStateChanged();
                }
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.insertUpdate(documentEvent);
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
            }
        };
    }
}

