/*
 * Decompiled with CFR 0.152.
 */
package com.spss.java_client.ui.dialogs.base.edit;

import com.spss.java_client.core.common.ComponentState;
import com.spss.java_client.ui.controls.FixedLengthDocument;
import com.spss.java_client.ui.controls.FocusableTextArea;
import com.spss.java_client.ui.controls.SpssButtonGroup;
import com.spss.java_client.ui.dialogs.base.edit.CustomOutputFormat;
import com.spss.java_client.ui.dialogs.base.edit.OptionPanel;
import com.spss.java_client.ui.dialogs.base.edit.OptionsDlg;
import com.spss.java_client.ui.dialogs.base.edit.OptionsUtil;
import com.spss.java_client.ui.dialogs.common.DialogUtil;
import com.spss.uitools.controls.ContextEnabledTextField;
import com.spss.uitools.util.IOptionConstants;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.util.Arrays;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.text.Document;

public class CurrencyOptionPanel
extends OptionPanel {
    private static final String POSITIVE_DEFAULT_VALUE = "1,234.56";
    private static final String NEGATIVE_DEFAULT_VALUE = "-1,234.56";
    private JList mCustomFormatList;
    protected JScrollPane mScrollPane;
    private JLabel mPosLbl;
    private JLabel mNegLbl;
    private FocusableTextArea mPosValue;
    private FocusableTextArea mNegValue;
    private JLabel mAllPrefLbl;
    private JLabel mAllSuffLbl;
    private ContextEnabledTextField mAllPrefix;
    private ContextEnabledTextField mAllSuffix;
    private JLabel mNegPrefLbl;
    private JLabel mNegSuffLbl;
    private ContextEnabledTextField mNegPrefix;
    private ContextEnabledTextField mNegSuffix;
    private JRadioButton mPeriodRadio;
    private JRadioButton mCommaRadio;
    private OutputFormatListModel mSampleFormatListModel;
    private static boolean sEnableApply = false;

    public CurrencyOptionPanel(OptionsDlg optionsDlg, Preferences preferences, String string) {
        super(optionsDlg, preferences, string);
    }

    @Override
    public String getDialogHelpID() {
        return "idh_pref_ccur";
    }

    public static String[] getCustomCurrencyFormatNames() {
        return new String[]{"CCA", "CCB", "CCC", "CCD", "CCE"};
    }

    @Override
    public void initVars() {
        CustomOutputFormat.setSampleOutput(POSITIVE_DEFAULT_VALUE);
        String[] stringArray = CurrencyOptionPanel.getCustomCurrencyFormatNames();
        this.mSampleFormatListModel = new OutputFormatListModel();
        this.populateListModel(this.mSampleFormatListModel, stringArray);
        this.mCustomFormatList = new JList<String>(stringArray);
        this.mScrollPane = new JScrollPane(this.mCustomFormatList, 20, 31);
        this.mScrollPane.setPreferredSize(new Dimension(this.mCustomFormatList.getPreferredSize().width + 20, 60));
        this.mCustomFormatList.setCellRenderer(new CustomFormatListCellRenderer());
        this.mCustomFormatList.setFocusable(true);
        this.mCustomFormatList.setSelectedIndex(0);
        this.mPosLbl = DialogUtil.createLabel(this.mOptionDialog, "IDS_SMPL_POS_LBLS");
        this.mNegLbl = DialogUtil.createLabel(this.mOptionDialog, "IDS_SMPL_NEG_LBLS");
        this.mPosValue = new FocusableTextArea(POSITIVE_DEFAULT_VALUE, null);
        this.mNegValue = new FocusableTextArea(NEGATIVE_DEFAULT_VALUE, null);
        this.mPosValue.setLabel(this.mPosLbl);
        this.mNegValue.setLabel(this.mNegLbl);
        this.mAllPrefLbl = DialogUtil.createLabel(this.mOptionDialog, "IDS_ALLVAL_PREF_LBLS");
        this.mAllSuffLbl = DialogUtil.createLabel(this.mOptionDialog, "IDS_ALLVAL_SUFF_LBLS");
        this.mAllPrefix = new ContextEnabledTextField((Document)new FixedLengthDocument(10), "", 8);
        this.mAllSuffix = new ContextEnabledTextField((Document)new FixedLengthDocument(10), "", 8);
        this.mAllPrefLbl.setLabelFor((Component)this.mAllPrefix);
        this.mAllSuffLbl.setLabelFor((Component)this.mAllSuffix);
        this.mNegPrefLbl = DialogUtil.createLabel(this.mOptionDialog, "IDS_NEGVAL_PREF_LBLS");
        this.mNegSuffLbl = DialogUtil.createLabel(this.mOptionDialog, "IDS_NEGVAL_SUFF_LBLS");
        this.mNegPrefix = new ContextEnabledTextField((Document)new FixedLengthDocument(10), "-", 8);
        this.mNegSuffix = new ContextEnabledTextField((Document)new FixedLengthDocument(10), "", 8);
        this.mNegPrefLbl.setLabelFor((Component)this.mNegPrefix);
        this.mNegSuffLbl.setLabelFor((Component)this.mNegSuffix);
        this.mPeriodRadio = DialogUtil.createRadioButton(this.mOptionDialog, "IDS_DECSEP_PERIOD_LBLS", (ActionListener)this);
        this.mCommaRadio = DialogUtil.createRadioButton(this.mOptionDialog, "IDS_DECSEP_COMMA_LBLS", (ActionListener)this);
        SpssButtonGroup spssButtonGroup = new SpssButtonGroup();
        spssButtonGroup.add(this.mPeriodRadio);
        spssButtonGroup.add(this.mCommaRadio);
        this.mPeriodRadio.setSelected(true);
        this.mComponentOrder.add(this.mCustomFormatList);
        this.mComponentOrder.add(this.mPosValue);
        this.mComponentOrder.add(this.mNegValue);
        this.mComponentOrder.add(this.mAllPrefix);
        this.mComponentOrder.add(this.mAllSuffix);
        this.mComponentOrder.add(this.mNegPrefix);
        this.mComponentOrder.add(this.mNegSuffix);
        this.mComponentOrder.add(spssButtonGroup);
        this.mComponentOrder.addAll(Arrays.asList(this.mOptionDialog.getCmdButtonPanel().getComponents()));
        this.addListeners();
    }

    @Override
    public void initPanel() {
        super.initPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        int n2 = DialogUtil.getComponentGroupGap();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        Insets insets = new Insets(n2, 0, 0, 0);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        OptionsUtil.addUsingGBL(jPanel, this.setupCustomFormatsPanel(), gridBagConstraints, 0, 0, 1, 1, n, insets);
        insets.set(n2, n2, 0, 0);
        OptionsUtil.addUsingGBL(jPanel, this.setupSampleOutputPanel(), gridBagConstraints, 1, 0, 2, 1, n, insets);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        insets.set(n2, 0, 0, 0);
        OptionsUtil.addUsingGBL(jPanel2, this.setupAllValuesPanel(), gridBagConstraints, 0, 0, 2, 1, n, insets);
        OptionsUtil.addUsingGBL(jPanel2, this.setupNegValuesPanel(), gridBagConstraints, 0, 1, 2, 1, n, insets);
        insets.set(n2, n2, 0, 0);
        OptionsUtil.addUsingGBL(jPanel2, this.setupDecimalSepPanel(), gridBagConstraints, 2, 0, 1, 2, n, insets);
        OptionsUtil.addUsingGBL(this, jPanel, gridBagConstraints, 0, 0, 1, 1, n, null);
        OptionsUtil.addUsingGBL(this, jPanel2, gridBagConstraints, 0, 1, 1, 1, n, null);
    }

    @Override
    public void readPrefs() {
        CustomOutputFormat customOutputFormat = this.mSampleFormatListModel.getSample(this.mCustomFormatList.getSelectedIndex());
        this.populatePanelFields(customOutputFormat);
    }

    @Override
    public void savePrefs() {
        int n = this.mSampleFormatListModel.getSize();
        for (int i = 0; i < n; ++i) {
            CustomOutputFormat customOutputFormat = this.mSampleFormatListModel.getSample(i);
            if (!customOutputFormat.isChanged()) continue;
            Preferences preferences = this.mOptionsPrefs.node(customOutputFormat.getSampleName().toLowerCase());
            preferences.put("all_val_prefix", customOutputFormat.getAllPrefix());
            preferences.put("all_val_suffix", customOutputFormat.getAllSuffix());
            preferences.put("neg_val_prefix", customOutputFormat.getNegPrefix());
            preferences.put("neg_val_suffix", customOutputFormat.getNegSuffix());
            if (customOutputFormat.isCommaSeparated()) {
                preferences.put("decimal_separator", IOptionConstants.CUSTOM_OUTPUT_FORMAT_SEPARATOR_VALUES[1]);
                continue;
            }
            preferences.put("decimal_separator", IOptionConstants.CUSTOM_OUTPUT_FORMAT_SEPARATOR_VALUES[0]);
        }
    }

    @Override
    protected int getId() {
        return 32;
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        Document document = documentEvent.getDocument();
        CustomOutputFormat customOutputFormat = this.mSampleFormatListModel.getSample(this.mCustomFormatList.getSelectedIndex());
        if (document == this.mAllPrefix.getDocument()) {
            customOutputFormat.setAllPrefix(this.mAllPrefix.getText());
        } else if (document == this.mAllSuffix.getDocument()) {
            customOutputFormat.setAllSuffix(this.mAllSuffix.getText());
        } else if (document == this.mNegPrefix.getDocument()) {
            customOutputFormat.setNegPrefix(this.mNegPrefix.getText());
        } else if (document == this.mNegSuffix.getDocument()) {
            customOutputFormat.setNegSuffix(this.mNegSuffix.getText());
        }
        this.mPosValue.setText(customOutputFormat.getPositiveSample());
        this.mNegValue.setText(customOutputFormat.getNegativeSample());
        if (sEnableApply) {
            customOutputFormat.setChanged(true);
            super.insertUpdate(documentEvent);
        }
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.insertUpdate(documentEvent);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        JList jList = (JList)listSelectionEvent.getSource();
        CustomOutputFormat customOutputFormat = this.mSampleFormatListModel.getSample(jList.getSelectedIndex());
        this.populatePanelFields(customOutputFormat);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        CustomOutputFormat customOutputFormat = this.mSampleFormatListModel.getSample(this.mCustomFormatList.getSelectedIndex());
        if (actionEvent.getSource() == this.mCommaRadio) {
            customOutputFormat.setCommaSeparated(true);
            this.mPosValue.setText(customOutputFormat.getPositiveSample());
            this.mNegValue.setText(customOutputFormat.getNegativeSample());
        } else {
            customOutputFormat.setCommaSeparated(false);
            this.mPosValue.setText(customOutputFormat.getPositiveSample());
            this.mNegValue.setText(customOutputFormat.getNegativeSample());
        }
        if (sEnableApply) {
            customOutputFormat.setChanged(true);
        }
        super.actionPerformed(actionEvent);
    }

    private void addListeners() {
        this.mCustomFormatList.addListSelectionListener(this);
        this.mAllPrefix.getDocument().addDocumentListener(this);
        this.mAllSuffix.getDocument().addDocumentListener(this);
        this.mAllPrefix.addFocusListener((FocusListener)this);
        this.mAllSuffix.addFocusListener((FocusListener)this);
        this.mNegPrefix.getDocument().addDocumentListener(this);
        this.mNegSuffix.getDocument().addDocumentListener(this);
        this.mNegPrefix.addFocusListener((FocusListener)this);
        this.mNegSuffix.addFocusListener((FocusListener)this);
        this.mPeriodRadio.addItemListener(this);
        this.mCommaRadio.addItemListener(this);
    }

    private void populateListModel(OutputFormatListModel outputFormatListModel, String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            CustomOutputFormat customOutputFormat = new CustomOutputFormat(stringArray[i]);
            outputFormatListModel.add(i, customOutputFormat);
        }
    }

    private void populatePanelFields(CustomOutputFormat customOutputFormat) {
        sEnableApply = false;
        if (!customOutputFormat.isInitialized()) {
            this.populateSample(customOutputFormat);
        }
        this.mPosValue.setText(customOutputFormat.getPositiveSample());
        this.mNegValue.setText(customOutputFormat.getNegativeSample());
        this.mAllPrefix.setText(customOutputFormat.getAllPrefix());
        this.mAllSuffix.setText(customOutputFormat.getAllSuffix());
        String string = customOutputFormat.getNegPrefix();
        this.mNegPrefix.setText(string.equals("") ? "-" : string);
        this.mNegSuffix.setText(customOutputFormat.getNegSuffix());
        if (customOutputFormat.isCommaSeparated()) {
            this.mCommaRadio.setSelected(true);
            this.mPeriodRadio.setSelected(false);
        } else {
            this.mPeriodRadio.setSelected(true);
            this.mCommaRadio.setSelected(false);
        }
        sEnableApply = true;
    }

    private void populateSample(CustomOutputFormat customOutputFormat) {
        Preferences preferences = this.mOptionsPrefs.node(customOutputFormat.getSampleName().toLowerCase());
        String string = preferences.get("all_val_prefix", "");
        String string2 = preferences.get("all_val_suffix", "");
        String string3 = preferences.get("neg_val_prefix", "");
        String string4 = preferences.get("neg_val_suffix", "");
        boolean bl = false;
        if (preferences.get("decimal_separator", "").equals(IOptionConstants.CUSTOM_OUTPUT_FORMAT_SEPARATOR_VALUES[1])) {
            bl = true;
        }
        customOutputFormat.init(string, string2, string3, string4, bl);
    }

    private JPanel setupCustomFormatsPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = DialogUtil.getGroupBoxInnerMargin();
        Insets insets = new Insets(n - 3, n, n - 3, n);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        JLabel jLabel = new JLabel(this.getResString("IDS_CURRENCY_FORMATS") + ":");
        OptionsUtil.addUsingGBL(jPanel, jLabel, gridBagConstraints, 0, 0, 1, 1, 23, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 40;
        insets.set(n - 3, n, n, n);
        OptionsUtil.addUsingGBL(jPanel, this.mScrollPane, gridBagConstraints, 0, 1, 1, 1, 23, insets);
        return jPanel;
    }

    private JPanel setupSampleOutputPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_SAMPLE_OUTPUT_PANEL")));
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 21;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets = new Insets(n2, n2, 0, 0);
        OptionsUtil.addUsingGBL(jPanel, this.mPosLbl, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        insets.set(n2, 20, 0, n2);
        OptionsUtil.addUsingGBL(jPanel, this.mPosValue, gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        insets.set(n2, n2, n2, 0);
        OptionsUtil.addUsingGBL(jPanel, this.mNegLbl, gridBagConstraints, 0, 1, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        insets.set(n2, 20, n2, n2);
        OptionsUtil.addUsingGBL(jPanel, this.mNegValue, gridBagConstraints, 1, 1, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        OptionsUtil.addUsingGBL(jPanel, new JPanel(), gridBagConstraints, 0, 2, 2, 1, n, insets);
        return jPanel;
    }

    private JPanel setupAllValuesPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_ALL_VALUES_PANEL")));
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets = new Insets(n2, n2, n2, 0);
        OptionsUtil.addUsingGBL(jPanel, this.mAllPrefLbl, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        insets.set(n2, 20, n2, 0);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mAllPrefix, gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        OptionsUtil.addUsingGBL(jPanel, this.mAllSuffLbl, gridBagConstraints, 2, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        insets.set(n2, 20, n2, n2);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mAllSuffix, gridBagConstraints, 3, 0, 2, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        OptionsUtil.addUsingGBL(jPanel, new JPanel(), gridBagConstraints, 0, 1, 4, 1, n, insets);
        return jPanel;
    }

    private JPanel setupNegValuesPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_NEG_VALUES_PANEL")));
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        int n2 = DialogUtil.getGroupBoxInnerMargin();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        Insets insets = new Insets(n2, n2, n2, 0);
        OptionsUtil.addUsingGBL(jPanel, this.mNegPrefLbl, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        insets.set(n2, 20, n2, 0);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mNegPrefix, gridBagConstraints, 1, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        OptionsUtil.addUsingGBL(jPanel, this.mNegSuffLbl, gridBagConstraints, 2, 0, 1, 1, n, insets);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        insets.set(n2, 20, n2, n2);
        DialogUtil.addUsingGBL(jPanel, (JComponent)this.mNegSuffix, gridBagConstraints, 3, 0, 2, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        OptionsUtil.addUsingGBL(jPanel, new JPanel(), gridBagConstraints, 0, 1, 4, 1, n, insets);
        return jPanel;
    }

    private JPanel setupDecimalSepPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder(this.getResString("IDS_DEC_SEPARATOR_PANEL")));
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 23;
        Insets insets = DialogUtil.getStandardControlInsets();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        OptionsUtil.addUsingGBL(jPanel, this.mPeriodRadio, gridBagConstraints, 0, 0, 1, 1, n, insets);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        OptionsUtil.addUsingGBL(jPanel, this.mCommaRadio, gridBagConstraints, 0, 1, 1, 1, n, insets);
        jPanel.setFocusCycleRoot(true);
        return jPanel;
    }

    class CustomFormatListCellRenderer
    extends JLabel
    implements ListCellRenderer {
        CustomFormatListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (ComponentState.isBtdRtlOrLtr() && object != null && object instanceof String && ((String)object).length() > 0) {
                super.setText(ComponentState.prepareStringForBidiRendering((String)object.toString()));
            } else {
                super.setText(object.toString());
            }
            this.setOpaque(true);
            if (bl) {
                if (jList.hasFocus()) {
                    this.setForeground(jList.getSelectionForeground());
                    this.setBackground(jList.getSelectionBackground());
                } else {
                    this.setForeground(Color.black);
                    this.setBackground(Color.lightGray);
                }
            } else {
                this.setForeground(jList.getForeground());
                this.setBackground(jList.getBackground());
            }
            Border border = null;
            if (bl2) {
                if (bl) {
                    border = UIManager.getBorder("List.focusSelectedCellHighlightBorder");
                }
                if (border == null) {
                    border = UIManager.getBorder("List.focusCellHighlightBorder");
                }
            } else {
                border = new EmptyBorder(1, 1, 1, 1);
            }
            this.setBorder(border);
            return this;
        }
    }

    private class OutputFormatListModel
    extends DefaultListModel {
        private OutputFormatListModel() {
        }

        public void add(int n, Object object) {
            super.add(n, object);
        }

        public Object get(int n) {
            Object e = super.get(n);
            return ((CustomOutputFormat)e).getSampleName();
        }

        @Override
        public int getSize() {
            return super.getSize();
        }

        public CustomOutputFormat getSample(int n) {
            return (CustomOutputFormat)super.get(n);
        }
    }
}

